# cmr-opendap

*OPeNDAP Integration in the CMR*

[![][logo]][logo]


#### Contents

* [About](#about-)
* [Dependencies](#dependencies-)
* [Documentation](#documentation-)
* [License](#license-)


## About [&#x219F;](#contents)

The Common Metadata Repository (CMR) is a high-performance, high-quality,
continuously evolving metadata system that catalogs Earth Science data and
associated service metadata records. These metadata records are registered,
modified, discovered, and accessed through programmatic interfaces leveraging
standard protocols and APIs.

The CMR OPeNDAP API allows client applications to integrate core CMR metadata
more easily with provider OPeNDAP deployments.


## Dependencies [&#x219F;](#contents)

* Java
* `lein`


## Documentation [&#x219F;](#contents)

Documentation for CMR OPeNDAP is availble
[here](https://cmr.sit.earthdata.nasa.gov/opendap/docs). The content there
is broken down by category; some of that is offered below as a convenience:

* [Introduction](https://cmr.sit.earthdata.nasa.gov/opendap/docs/reference/0000-intro.html)
* [Configuration](https://cmr.sit.earthdata.nasa.gov/opendap/docs/reference/0500-configuration.html)
* [Running the Tests](https://cmr.sit.earthdata.nasa.gov/opendap/docs/reference/0750-tests.html)
* [Quick Start](https://cmr.sit.earthdata.nasa.gov/opendap/docs/reference/1000-quick-start.html)
* [REST API Usage](https://cmr.sit.earthdata.nasa.gov/opendap/docs/reference/2000-usage.html)
* [Source Code API Reference](https://cmr.sit.earthdata.nasa.gov/opendap/docs/reference/index.html)
* [Source Code Annotation](https://cmr.sit.earthdata.nasa.gov/opendap/docs/marginalia/index.html)


## License [&#x219F;](#contents)

Copyright © 2018 NASA

Distributed under the Apache License, Version 2.0.


<!-- Named page links below: /-->

[logo]: https://avatars2.githubusercontent.com/u/32934967?s=200&v=4
