(ns cmr.dev.env.manager.messaging.impl.pubsub
  (:require [clojure.core.async :as async]))

(defrecord PubSubMessenger
  [message-key
   publisher])

(def default-pubsub-key :topic)

(defn publisher
  [input-chan msg-key]
  (async/pub input-chan msg-key))

(defn publish
  [this]
  )

(defn subscribe
  [this]
  )

(def behaviour
  {:publish publish
   :subscribe subscribe})

(defn new-messenger
  ([]
    (new-messenger (async/chan)))
  ([input-channel]
    (map->PubSubMessenger
      {:message-key default-pubsub-key
       :input-channel input-channel
       :publisher (publisher input-channel default-pubsub-key)}))
