(ns cmr.dev.env.manager.components.dem.messaging
  "System component for inter-component communications."
  (:require
    [clojusc.twig :as logger]
    [cmr.dev.env.manager.config :as config]
    [com.stuartsierra.component :as component]
    [taoensso.timbre :as log]))

(defrecord Messaging []
  component/Lifecycle

  (start [component]
    (log/info "Starting inter-component messaging component ...")
    (let []
      (log/debug "Started inter-component messaging component.")
      component))

  (stop [component]
    (log/info "Stopping inter-component messaging component ...")
    (log/debug "Stopped inter-component messaging component.")
    component))

(defn create-messaging-component
  ""
  []
  (->Messaging))

