// Compiled by ClojureScript 1.10.217 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__3123 = arguments.length;
switch (G__3123) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async3124 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3124 = (function (f,blockable,meta3125){
this.f = f;
this.blockable = blockable;
this.meta3125 = meta3125;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3124.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3126,meta3125__$1){
var self__ = this;
var _3126__$1 = this;
return (new cljs.core.async.t_cljs$core$async3124(self__.f,self__.blockable,meta3125__$1));
});

cljs.core.async.t_cljs$core$async3124.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3126){
var self__ = this;
var _3126__$1 = this;
return self__.meta3125;
});

cljs.core.async.t_cljs$core$async3124.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3124.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async3124.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async3124.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async3124.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta3125","meta3125",-1628751589,null)], null);
});

cljs.core.async.t_cljs$core$async3124.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3124.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3124";

cljs.core.async.t_cljs$core$async3124.cljs$lang$ctorPrWriter = (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async3124");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3124.
 */
cljs.core.async.__GT_t_cljs$core$async3124 = (function cljs$core$async$__GT_t_cljs$core$async3124(f__$1,blockable__$1,meta3125){
return (new cljs.core.async.t_cljs$core$async3124(f__$1,blockable__$1,meta3125));
});

}

return (new cljs.core.async.t_cljs$core$async3124(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__3130 = arguments.length;
switch (G__3130) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__3133 = arguments.length;
switch (G__3133) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__3136 = arguments.length;
switch (G__3136) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_3138 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_3138);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_3138,ret){
return (function (){
return fn1.call(null,val_3138);
});})(val_3138,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__3140 = arguments.length;
switch (G__3140) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4375__auto___3142 = n;
var x_3143 = (0);
while(true){
if((x_3143 < n__4375__auto___3142)){
(a[x_3143] = (0));

var G__3144 = (x_3143 + (1));
x_3143 = G__3144;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__3145 = (i + (1));
i = G__3145;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async3146 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3146 = (function (flag,meta3147){
this.flag = flag;
this.meta3147 = meta3147;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3146.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_3148,meta3147__$1){
var self__ = this;
var _3148__$1 = this;
return (new cljs.core.async.t_cljs$core$async3146(self__.flag,meta3147__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async3146.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_3148){
var self__ = this;
var _3148__$1 = this;
return self__.meta3147;
});})(flag))
;

cljs.core.async.t_cljs$core$async3146.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3146.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async3146.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async3146.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async3146.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta3147","meta3147",1576420627,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async3146.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3146.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3146";

cljs.core.async.t_cljs$core$async3146.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async3146");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3146.
 */
cljs.core.async.__GT_t_cljs$core$async3146 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async3146(flag__$1,meta3147){
return (new cljs.core.async.t_cljs$core$async3146(flag__$1,meta3147));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async3146(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async3149 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3149 = (function (flag,cb,meta3150){
this.flag = flag;
this.cb = cb;
this.meta3150 = meta3150;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3149.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3151,meta3150__$1){
var self__ = this;
var _3151__$1 = this;
return (new cljs.core.async.t_cljs$core$async3149(self__.flag,self__.cb,meta3150__$1));
});

cljs.core.async.t_cljs$core$async3149.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3151){
var self__ = this;
var _3151__$1 = this;
return self__.meta3150;
});

cljs.core.async.t_cljs$core$async3149.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3149.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async3149.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async3149.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async3149.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta3150","meta3150",1460733754,null)], null);
});

cljs.core.async.t_cljs$core$async3149.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3149.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3149";

cljs.core.async.t_cljs$core$async3149.cljs$lang$ctorPrWriter = (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async3149");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3149.
 */
cljs.core.async.__GT_t_cljs$core$async3149 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async3149(flag__$1,cb__$1,meta3150){
return (new cljs.core.async.t_cljs$core$async3149(flag__$1,cb__$1,meta3150));
});

}

return (new cljs.core.async.t_cljs$core$async3149(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__3152_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__3152_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__3153_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__3153_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3921__auto__ = wport;
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
return port;
}
})()], null));
} else {
var G__3154 = (i + (1));
i = G__3154;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3921__auto__ = ret;
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3910__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3910__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3910__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4501__auto__ = [];
var len__4498__auto___3160 = arguments.length;
var i__4499__auto___3161 = (0);
while(true){
if((i__4499__auto___3161 < len__4498__auto___3160)){
args__4501__auto__.push((arguments[i__4499__auto___3161]));

var G__3162 = (i__4499__auto___3161 + (1));
i__4499__auto___3161 = G__3162;
continue;
} else {
}
break;
}

var argseq__4502__auto__ = ((((1) < args__4501__auto__.length))?(new cljs.core.IndexedSeq(args__4501__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4502__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__3157){
var map__3158 = p__3157;
var map__3158__$1 = ((((!((map__3158 == null)))?(((((map__3158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3158.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3158):map__3158);
var opts = map__3158__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq3155){
var G__3156 = cljs.core.first.call(null,seq3155);
var seq3155__$1 = cljs.core.next.call(null,seq3155);
var self__4485__auto__ = this;
return self__4485__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3156,seq3155__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__3164 = arguments.length;
switch (G__3164) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__3063__auto___3210 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___3210){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___3210){
return (function (state_3188){
var state_val_3189 = (state_3188[(1)]);
if((state_val_3189 === (7))){
var inst_3184 = (state_3188[(2)]);
var state_3188__$1 = state_3188;
var statearr_3190_3211 = state_3188__$1;
(statearr_3190_3211[(2)] = inst_3184);

(statearr_3190_3211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (1))){
var state_3188__$1 = state_3188;
var statearr_3191_3212 = state_3188__$1;
(statearr_3191_3212[(2)] = null);

(statearr_3191_3212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (4))){
var inst_3167 = (state_3188[(7)]);
var inst_3167__$1 = (state_3188[(2)]);
var inst_3168 = (inst_3167__$1 == null);
var state_3188__$1 = (function (){var statearr_3192 = state_3188;
(statearr_3192[(7)] = inst_3167__$1);

return statearr_3192;
})();
if(cljs.core.truth_(inst_3168)){
var statearr_3193_3213 = state_3188__$1;
(statearr_3193_3213[(1)] = (5));

} else {
var statearr_3194_3214 = state_3188__$1;
(statearr_3194_3214[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (13))){
var state_3188__$1 = state_3188;
var statearr_3195_3215 = state_3188__$1;
(statearr_3195_3215[(2)] = null);

(statearr_3195_3215[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (6))){
var inst_3167 = (state_3188[(7)]);
var state_3188__$1 = state_3188;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3188__$1,(11),to,inst_3167);
} else {
if((state_val_3189 === (3))){
var inst_3186 = (state_3188[(2)]);
var state_3188__$1 = state_3188;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3188__$1,inst_3186);
} else {
if((state_val_3189 === (12))){
var state_3188__$1 = state_3188;
var statearr_3196_3216 = state_3188__$1;
(statearr_3196_3216[(2)] = null);

(statearr_3196_3216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (2))){
var state_3188__$1 = state_3188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3188__$1,(4),from);
} else {
if((state_val_3189 === (11))){
var inst_3177 = (state_3188[(2)]);
var state_3188__$1 = state_3188;
if(cljs.core.truth_(inst_3177)){
var statearr_3197_3217 = state_3188__$1;
(statearr_3197_3217[(1)] = (12));

} else {
var statearr_3198_3218 = state_3188__$1;
(statearr_3198_3218[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (9))){
var state_3188__$1 = state_3188;
var statearr_3199_3219 = state_3188__$1;
(statearr_3199_3219[(2)] = null);

(statearr_3199_3219[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (5))){
var state_3188__$1 = state_3188;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3200_3220 = state_3188__$1;
(statearr_3200_3220[(1)] = (8));

} else {
var statearr_3201_3221 = state_3188__$1;
(statearr_3201_3221[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (14))){
var inst_3182 = (state_3188[(2)]);
var state_3188__$1 = state_3188;
var statearr_3202_3222 = state_3188__$1;
(statearr_3202_3222[(2)] = inst_3182);

(statearr_3202_3222[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (10))){
var inst_3174 = (state_3188[(2)]);
var state_3188__$1 = state_3188;
var statearr_3203_3223 = state_3188__$1;
(statearr_3203_3223[(2)] = inst_3174);

(statearr_3203_3223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3189 === (8))){
var inst_3171 = cljs.core.async.close_BANG_.call(null,to);
var state_3188__$1 = state_3188;
var statearr_3204_3224 = state_3188__$1;
(statearr_3204_3224[(2)] = inst_3171);

(statearr_3204_3224[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___3210))
;
return ((function (switch__2973__auto__,c__3063__auto___3210){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_3205 = [null,null,null,null,null,null,null,null];
(statearr_3205[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_3205[(1)] = (1));

return statearr_3205;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_3188){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3206){if((e3206 instanceof Object)){
var ex__2977__auto__ = e3206;
var statearr_3207_3225 = state_3188;
(statearr_3207_3225[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3188);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3206;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3226 = state_3188;
state_3188 = G__3226;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_3188){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_3188);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___3210))
})();
var state__3065__auto__ = (function (){var statearr_3208 = f__3064__auto__.call(null);
(statearr_3208[(6)] = c__3063__auto___3210);

return statearr_3208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___3210))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__3227){
var vec__3228 = p__3227;
var v = cljs.core.nth.call(null,vec__3228,(0),null);
var p = cljs.core.nth.call(null,vec__3228,(1),null);
var job = vec__3228;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__3063__auto___3399 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___3399,res,vec__3228,v,p,job,jobs,results){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___3399,res,vec__3228,v,p,job,jobs,results){
return (function (state_3235){
var state_val_3236 = (state_3235[(1)]);
if((state_val_3236 === (1))){
var state_3235__$1 = state_3235;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3235__$1,(2),res,v);
} else {
if((state_val_3236 === (2))){
var inst_3232 = (state_3235[(2)]);
var inst_3233 = cljs.core.async.close_BANG_.call(null,res);
var state_3235__$1 = (function (){var statearr_3237 = state_3235;
(statearr_3237[(7)] = inst_3232);

return statearr_3237;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3235__$1,inst_3233);
} else {
return null;
}
}
});})(c__3063__auto___3399,res,vec__3228,v,p,job,jobs,results))
;
return ((function (switch__2973__auto__,c__3063__auto___3399,res,vec__3228,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0 = (function (){
var statearr_3238 = [null,null,null,null,null,null,null,null];
(statearr_3238[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__);

(statearr_3238[(1)] = (1));

return statearr_3238;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1 = (function (state_3235){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3235);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3239){if((e3239 instanceof Object)){
var ex__2977__auto__ = e3239;
var statearr_3240_3400 = state_3235;
(statearr_3240_3400[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3235);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3239;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3401 = state_3235;
state_3235 = G__3401;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = function(state_3235){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1.call(this,state_3235);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___3399,res,vec__3228,v,p,job,jobs,results))
})();
var state__3065__auto__ = (function (){var statearr_3241 = f__3064__auto__.call(null);
(statearr_3241[(6)] = c__3063__auto___3399);

return statearr_3241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___3399,res,vec__3228,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__3242){
var vec__3243 = p__3242;
var v = cljs.core.nth.call(null,vec__3243,(0),null);
var p = cljs.core.nth.call(null,vec__3243,(1),null);
var job = vec__3243;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4375__auto___3402 = n;
var __3403 = (0);
while(true){
if((__3403 < n__4375__auto___3402)){
var G__3246_3404 = type;
var G__3246_3405__$1 = (((G__3246_3404 instanceof cljs.core.Keyword))?G__3246_3404.fqn:null);
switch (G__3246_3405__$1) {
case "compute":
var c__3063__auto___3407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__3403,c__3063__auto___3407,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (__3403,c__3063__auto___3407,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async){
return (function (state_3259){
var state_val_3260 = (state_3259[(1)]);
if((state_val_3260 === (1))){
var state_3259__$1 = state_3259;
var statearr_3261_3408 = state_3259__$1;
(statearr_3261_3408[(2)] = null);

(statearr_3261_3408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3260 === (2))){
var state_3259__$1 = state_3259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3259__$1,(4),jobs);
} else {
if((state_val_3260 === (3))){
var inst_3257 = (state_3259[(2)]);
var state_3259__$1 = state_3259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3259__$1,inst_3257);
} else {
if((state_val_3260 === (4))){
var inst_3249 = (state_3259[(2)]);
var inst_3250 = process.call(null,inst_3249);
var state_3259__$1 = state_3259;
if(cljs.core.truth_(inst_3250)){
var statearr_3262_3409 = state_3259__$1;
(statearr_3262_3409[(1)] = (5));

} else {
var statearr_3263_3410 = state_3259__$1;
(statearr_3263_3410[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3260 === (5))){
var state_3259__$1 = state_3259;
var statearr_3264_3411 = state_3259__$1;
(statearr_3264_3411[(2)] = null);

(statearr_3264_3411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3260 === (6))){
var state_3259__$1 = state_3259;
var statearr_3265_3412 = state_3259__$1;
(statearr_3265_3412[(2)] = null);

(statearr_3265_3412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3260 === (7))){
var inst_3255 = (state_3259[(2)]);
var state_3259__$1 = state_3259;
var statearr_3266_3413 = state_3259__$1;
(statearr_3266_3413[(2)] = inst_3255);

(statearr_3266_3413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__3403,c__3063__auto___3407,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async))
;
return ((function (__3403,switch__2973__auto__,c__3063__auto___3407,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0 = (function (){
var statearr_3267 = [null,null,null,null,null,null,null];
(statearr_3267[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__);

(statearr_3267[(1)] = (1));

return statearr_3267;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1 = (function (state_3259){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3268){if((e3268 instanceof Object)){
var ex__2977__auto__ = e3268;
var statearr_3269_3414 = state_3259;
(statearr_3269_3414[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3259);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3268;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3415 = state_3259;
state_3259 = G__3415;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = function(state_3259){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1.call(this,state_3259);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__;
})()
;})(__3403,switch__2973__auto__,c__3063__auto___3407,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async))
})();
var state__3065__auto__ = (function (){var statearr_3270 = f__3064__auto__.call(null);
(statearr_3270[(6)] = c__3063__auto___3407);

return statearr_3270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(__3403,c__3063__auto___3407,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async))
);


break;
case "async":
var c__3063__auto___3416 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__3403,c__3063__auto___3416,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (__3403,c__3063__auto___3416,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async){
return (function (state_3283){
var state_val_3284 = (state_3283[(1)]);
if((state_val_3284 === (1))){
var state_3283__$1 = state_3283;
var statearr_3285_3417 = state_3283__$1;
(statearr_3285_3417[(2)] = null);

(statearr_3285_3417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3284 === (2))){
var state_3283__$1 = state_3283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3283__$1,(4),jobs);
} else {
if((state_val_3284 === (3))){
var inst_3281 = (state_3283[(2)]);
var state_3283__$1 = state_3283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3283__$1,inst_3281);
} else {
if((state_val_3284 === (4))){
var inst_3273 = (state_3283[(2)]);
var inst_3274 = async.call(null,inst_3273);
var state_3283__$1 = state_3283;
if(cljs.core.truth_(inst_3274)){
var statearr_3286_3418 = state_3283__$1;
(statearr_3286_3418[(1)] = (5));

} else {
var statearr_3287_3419 = state_3283__$1;
(statearr_3287_3419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3284 === (5))){
var state_3283__$1 = state_3283;
var statearr_3288_3420 = state_3283__$1;
(statearr_3288_3420[(2)] = null);

(statearr_3288_3420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3284 === (6))){
var state_3283__$1 = state_3283;
var statearr_3289_3421 = state_3283__$1;
(statearr_3289_3421[(2)] = null);

(statearr_3289_3421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3284 === (7))){
var inst_3279 = (state_3283[(2)]);
var state_3283__$1 = state_3283;
var statearr_3290_3422 = state_3283__$1;
(statearr_3290_3422[(2)] = inst_3279);

(statearr_3290_3422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__3403,c__3063__auto___3416,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async))
;
return ((function (__3403,switch__2973__auto__,c__3063__auto___3416,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0 = (function (){
var statearr_3291 = [null,null,null,null,null,null,null];
(statearr_3291[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__);

(statearr_3291[(1)] = (1));

return statearr_3291;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1 = (function (state_3283){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3292){if((e3292 instanceof Object)){
var ex__2977__auto__ = e3292;
var statearr_3293_3423 = state_3283;
(statearr_3293_3423[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3283);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3292;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3424 = state_3283;
state_3283 = G__3424;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = function(state_3283){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1.call(this,state_3283);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__;
})()
;})(__3403,switch__2973__auto__,c__3063__auto___3416,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async))
})();
var state__3065__auto__ = (function (){var statearr_3294 = f__3064__auto__.call(null);
(statearr_3294[(6)] = c__3063__auto___3416);

return statearr_3294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(__3403,c__3063__auto___3416,G__3246_3404,G__3246_3405__$1,n__4375__auto___3402,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__3246_3405__$1)].join('')));

}

var G__3425 = (__3403 + (1));
__3403 = G__3425;
continue;
} else {
}
break;
}

var c__3063__auto___3426 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___3426,jobs,results,process,async){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___3426,jobs,results,process,async){
return (function (state_3316){
var state_val_3317 = (state_3316[(1)]);
if((state_val_3317 === (1))){
var state_3316__$1 = state_3316;
var statearr_3318_3427 = state_3316__$1;
(statearr_3318_3427[(2)] = null);

(statearr_3318_3427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3317 === (2))){
var state_3316__$1 = state_3316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3316__$1,(4),from);
} else {
if((state_val_3317 === (3))){
var inst_3314 = (state_3316[(2)]);
var state_3316__$1 = state_3316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3316__$1,inst_3314);
} else {
if((state_val_3317 === (4))){
var inst_3297 = (state_3316[(7)]);
var inst_3297__$1 = (state_3316[(2)]);
var inst_3298 = (inst_3297__$1 == null);
var state_3316__$1 = (function (){var statearr_3319 = state_3316;
(statearr_3319[(7)] = inst_3297__$1);

return statearr_3319;
})();
if(cljs.core.truth_(inst_3298)){
var statearr_3320_3428 = state_3316__$1;
(statearr_3320_3428[(1)] = (5));

} else {
var statearr_3321_3429 = state_3316__$1;
(statearr_3321_3429[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3317 === (5))){
var inst_3300 = cljs.core.async.close_BANG_.call(null,jobs);
var state_3316__$1 = state_3316;
var statearr_3322_3430 = state_3316__$1;
(statearr_3322_3430[(2)] = inst_3300);

(statearr_3322_3430[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3317 === (6))){
var inst_3302 = (state_3316[(8)]);
var inst_3297 = (state_3316[(7)]);
var inst_3302__$1 = cljs.core.async.chan.call(null,(1));
var inst_3303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_3304 = [inst_3297,inst_3302__$1];
var inst_3305 = (new cljs.core.PersistentVector(null,2,(5),inst_3303,inst_3304,null));
var state_3316__$1 = (function (){var statearr_3323 = state_3316;
(statearr_3323[(8)] = inst_3302__$1);

return statearr_3323;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3316__$1,(8),jobs,inst_3305);
} else {
if((state_val_3317 === (7))){
var inst_3312 = (state_3316[(2)]);
var state_3316__$1 = state_3316;
var statearr_3324_3431 = state_3316__$1;
(statearr_3324_3431[(2)] = inst_3312);

(statearr_3324_3431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3317 === (8))){
var inst_3302 = (state_3316[(8)]);
var inst_3307 = (state_3316[(2)]);
var state_3316__$1 = (function (){var statearr_3325 = state_3316;
(statearr_3325[(9)] = inst_3307);

return statearr_3325;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3316__$1,(9),results,inst_3302);
} else {
if((state_val_3317 === (9))){
var inst_3309 = (state_3316[(2)]);
var state_3316__$1 = (function (){var statearr_3326 = state_3316;
(statearr_3326[(10)] = inst_3309);

return statearr_3326;
})();
var statearr_3327_3432 = state_3316__$1;
(statearr_3327_3432[(2)] = null);

(statearr_3327_3432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___3426,jobs,results,process,async))
;
return ((function (switch__2973__auto__,c__3063__auto___3426,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0 = (function (){
var statearr_3328 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_3328[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__);

(statearr_3328[(1)] = (1));

return statearr_3328;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1 = (function (state_3316){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3329){if((e3329 instanceof Object)){
var ex__2977__auto__ = e3329;
var statearr_3330_3433 = state_3316;
(statearr_3330_3433[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3316);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3329;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3434 = state_3316;
state_3316 = G__3434;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = function(state_3316){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1.call(this,state_3316);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___3426,jobs,results,process,async))
})();
var state__3065__auto__ = (function (){var statearr_3331 = f__3064__auto__.call(null);
(statearr_3331[(6)] = c__3063__auto___3426);

return statearr_3331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___3426,jobs,results,process,async))
);


var c__3063__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto__,jobs,results,process,async){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto__,jobs,results,process,async){
return (function (state_3369){
var state_val_3370 = (state_3369[(1)]);
if((state_val_3370 === (7))){
var inst_3365 = (state_3369[(2)]);
var state_3369__$1 = state_3369;
var statearr_3371_3435 = state_3369__$1;
(statearr_3371_3435[(2)] = inst_3365);

(statearr_3371_3435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (20))){
var state_3369__$1 = state_3369;
var statearr_3372_3436 = state_3369__$1;
(statearr_3372_3436[(2)] = null);

(statearr_3372_3436[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (1))){
var state_3369__$1 = state_3369;
var statearr_3373_3437 = state_3369__$1;
(statearr_3373_3437[(2)] = null);

(statearr_3373_3437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (4))){
var inst_3334 = (state_3369[(7)]);
var inst_3334__$1 = (state_3369[(2)]);
var inst_3335 = (inst_3334__$1 == null);
var state_3369__$1 = (function (){var statearr_3374 = state_3369;
(statearr_3374[(7)] = inst_3334__$1);

return statearr_3374;
})();
if(cljs.core.truth_(inst_3335)){
var statearr_3375_3438 = state_3369__$1;
(statearr_3375_3438[(1)] = (5));

} else {
var statearr_3376_3439 = state_3369__$1;
(statearr_3376_3439[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (15))){
var inst_3347 = (state_3369[(8)]);
var state_3369__$1 = state_3369;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3369__$1,(18),to,inst_3347);
} else {
if((state_val_3370 === (21))){
var inst_3360 = (state_3369[(2)]);
var state_3369__$1 = state_3369;
var statearr_3377_3440 = state_3369__$1;
(statearr_3377_3440[(2)] = inst_3360);

(statearr_3377_3440[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (13))){
var inst_3362 = (state_3369[(2)]);
var state_3369__$1 = (function (){var statearr_3378 = state_3369;
(statearr_3378[(9)] = inst_3362);

return statearr_3378;
})();
var statearr_3379_3441 = state_3369__$1;
(statearr_3379_3441[(2)] = null);

(statearr_3379_3441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (6))){
var inst_3334 = (state_3369[(7)]);
var state_3369__$1 = state_3369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3369__$1,(11),inst_3334);
} else {
if((state_val_3370 === (17))){
var inst_3355 = (state_3369[(2)]);
var state_3369__$1 = state_3369;
if(cljs.core.truth_(inst_3355)){
var statearr_3380_3442 = state_3369__$1;
(statearr_3380_3442[(1)] = (19));

} else {
var statearr_3381_3443 = state_3369__$1;
(statearr_3381_3443[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (3))){
var inst_3367 = (state_3369[(2)]);
var state_3369__$1 = state_3369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3369__$1,inst_3367);
} else {
if((state_val_3370 === (12))){
var inst_3344 = (state_3369[(10)]);
var state_3369__$1 = state_3369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3369__$1,(14),inst_3344);
} else {
if((state_val_3370 === (2))){
var state_3369__$1 = state_3369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3369__$1,(4),results);
} else {
if((state_val_3370 === (19))){
var state_3369__$1 = state_3369;
var statearr_3382_3444 = state_3369__$1;
(statearr_3382_3444[(2)] = null);

(statearr_3382_3444[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (11))){
var inst_3344 = (state_3369[(2)]);
var state_3369__$1 = (function (){var statearr_3383 = state_3369;
(statearr_3383[(10)] = inst_3344);

return statearr_3383;
})();
var statearr_3384_3445 = state_3369__$1;
(statearr_3384_3445[(2)] = null);

(statearr_3384_3445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (9))){
var state_3369__$1 = state_3369;
var statearr_3385_3446 = state_3369__$1;
(statearr_3385_3446[(2)] = null);

(statearr_3385_3446[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (5))){
var state_3369__$1 = state_3369;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3386_3447 = state_3369__$1;
(statearr_3386_3447[(1)] = (8));

} else {
var statearr_3387_3448 = state_3369__$1;
(statearr_3387_3448[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (14))){
var inst_3349 = (state_3369[(11)]);
var inst_3347 = (state_3369[(8)]);
var inst_3347__$1 = (state_3369[(2)]);
var inst_3348 = (inst_3347__$1 == null);
var inst_3349__$1 = cljs.core.not.call(null,inst_3348);
var state_3369__$1 = (function (){var statearr_3388 = state_3369;
(statearr_3388[(11)] = inst_3349__$1);

(statearr_3388[(8)] = inst_3347__$1);

return statearr_3388;
})();
if(inst_3349__$1){
var statearr_3389_3449 = state_3369__$1;
(statearr_3389_3449[(1)] = (15));

} else {
var statearr_3390_3450 = state_3369__$1;
(statearr_3390_3450[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (16))){
var inst_3349 = (state_3369[(11)]);
var state_3369__$1 = state_3369;
var statearr_3391_3451 = state_3369__$1;
(statearr_3391_3451[(2)] = inst_3349);

(statearr_3391_3451[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (10))){
var inst_3341 = (state_3369[(2)]);
var state_3369__$1 = state_3369;
var statearr_3392_3452 = state_3369__$1;
(statearr_3392_3452[(2)] = inst_3341);

(statearr_3392_3452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (18))){
var inst_3352 = (state_3369[(2)]);
var state_3369__$1 = state_3369;
var statearr_3393_3453 = state_3369__$1;
(statearr_3393_3453[(2)] = inst_3352);

(statearr_3393_3453[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3370 === (8))){
var inst_3338 = cljs.core.async.close_BANG_.call(null,to);
var state_3369__$1 = state_3369;
var statearr_3394_3454 = state_3369__$1;
(statearr_3394_3454[(2)] = inst_3338);

(statearr_3394_3454[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto__,jobs,results,process,async))
;
return ((function (switch__2973__auto__,c__3063__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0 = (function (){
var statearr_3395 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3395[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__);

(statearr_3395[(1)] = (1));

return statearr_3395;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1 = (function (state_3369){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3396){if((e3396 instanceof Object)){
var ex__2977__auto__ = e3396;
var statearr_3397_3455 = state_3369;
(statearr_3397_3455[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3369);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3396;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3456 = state_3369;
state_3369 = G__3456;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__ = function(state_3369){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1.call(this,state_3369);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2974__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto__,jobs,results,process,async))
})();
var state__3065__auto__ = (function (){var statearr_3398 = f__3064__auto__.call(null);
(statearr_3398[(6)] = c__3063__auto__);

return statearr_3398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto__,jobs,results,process,async))
);

return c__3063__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__3458 = arguments.length;
switch (G__3458) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__3461 = arguments.length;
switch (G__3461) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__3464 = arguments.length;
switch (G__3464) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__3063__auto___3513 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___3513,tc,fc){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___3513,tc,fc){
return (function (state_3490){
var state_val_3491 = (state_3490[(1)]);
if((state_val_3491 === (7))){
var inst_3486 = (state_3490[(2)]);
var state_3490__$1 = state_3490;
var statearr_3492_3514 = state_3490__$1;
(statearr_3492_3514[(2)] = inst_3486);

(statearr_3492_3514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (1))){
var state_3490__$1 = state_3490;
var statearr_3493_3515 = state_3490__$1;
(statearr_3493_3515[(2)] = null);

(statearr_3493_3515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (4))){
var inst_3467 = (state_3490[(7)]);
var inst_3467__$1 = (state_3490[(2)]);
var inst_3468 = (inst_3467__$1 == null);
var state_3490__$1 = (function (){var statearr_3494 = state_3490;
(statearr_3494[(7)] = inst_3467__$1);

return statearr_3494;
})();
if(cljs.core.truth_(inst_3468)){
var statearr_3495_3516 = state_3490__$1;
(statearr_3495_3516[(1)] = (5));

} else {
var statearr_3496_3517 = state_3490__$1;
(statearr_3496_3517[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (13))){
var state_3490__$1 = state_3490;
var statearr_3497_3518 = state_3490__$1;
(statearr_3497_3518[(2)] = null);

(statearr_3497_3518[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (6))){
var inst_3467 = (state_3490[(7)]);
var inst_3473 = p.call(null,inst_3467);
var state_3490__$1 = state_3490;
if(cljs.core.truth_(inst_3473)){
var statearr_3498_3519 = state_3490__$1;
(statearr_3498_3519[(1)] = (9));

} else {
var statearr_3499_3520 = state_3490__$1;
(statearr_3499_3520[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (3))){
var inst_3488 = (state_3490[(2)]);
var state_3490__$1 = state_3490;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3490__$1,inst_3488);
} else {
if((state_val_3491 === (12))){
var state_3490__$1 = state_3490;
var statearr_3500_3521 = state_3490__$1;
(statearr_3500_3521[(2)] = null);

(statearr_3500_3521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (2))){
var state_3490__$1 = state_3490;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3490__$1,(4),ch);
} else {
if((state_val_3491 === (11))){
var inst_3467 = (state_3490[(7)]);
var inst_3477 = (state_3490[(2)]);
var state_3490__$1 = state_3490;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3490__$1,(8),inst_3477,inst_3467);
} else {
if((state_val_3491 === (9))){
var state_3490__$1 = state_3490;
var statearr_3501_3522 = state_3490__$1;
(statearr_3501_3522[(2)] = tc);

(statearr_3501_3522[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (5))){
var inst_3470 = cljs.core.async.close_BANG_.call(null,tc);
var inst_3471 = cljs.core.async.close_BANG_.call(null,fc);
var state_3490__$1 = (function (){var statearr_3502 = state_3490;
(statearr_3502[(8)] = inst_3470);

return statearr_3502;
})();
var statearr_3503_3523 = state_3490__$1;
(statearr_3503_3523[(2)] = inst_3471);

(statearr_3503_3523[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (14))){
var inst_3484 = (state_3490[(2)]);
var state_3490__$1 = state_3490;
var statearr_3504_3524 = state_3490__$1;
(statearr_3504_3524[(2)] = inst_3484);

(statearr_3504_3524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (10))){
var state_3490__$1 = state_3490;
var statearr_3505_3525 = state_3490__$1;
(statearr_3505_3525[(2)] = fc);

(statearr_3505_3525[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3491 === (8))){
var inst_3479 = (state_3490[(2)]);
var state_3490__$1 = state_3490;
if(cljs.core.truth_(inst_3479)){
var statearr_3506_3526 = state_3490__$1;
(statearr_3506_3526[(1)] = (12));

} else {
var statearr_3507_3527 = state_3490__$1;
(statearr_3507_3527[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___3513,tc,fc))
;
return ((function (switch__2973__auto__,c__3063__auto___3513,tc,fc){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_3508 = [null,null,null,null,null,null,null,null,null];
(statearr_3508[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_3508[(1)] = (1));

return statearr_3508;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_3490){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3490);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3509){if((e3509 instanceof Object)){
var ex__2977__auto__ = e3509;
var statearr_3510_3528 = state_3490;
(statearr_3510_3528[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3490);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3529 = state_3490;
state_3490 = G__3529;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_3490){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_3490);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___3513,tc,fc))
})();
var state__3065__auto__ = (function (){var statearr_3511 = f__3064__auto__.call(null);
(statearr_3511[(6)] = c__3063__auto___3513);

return statearr_3511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___3513,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__3063__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto__){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto__){
return (function (state_3550){
var state_val_3551 = (state_3550[(1)]);
if((state_val_3551 === (7))){
var inst_3546 = (state_3550[(2)]);
var state_3550__$1 = state_3550;
var statearr_3552_3570 = state_3550__$1;
(statearr_3552_3570[(2)] = inst_3546);

(statearr_3552_3570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3551 === (1))){
var inst_3530 = init;
var state_3550__$1 = (function (){var statearr_3553 = state_3550;
(statearr_3553[(7)] = inst_3530);

return statearr_3553;
})();
var statearr_3554_3571 = state_3550__$1;
(statearr_3554_3571[(2)] = null);

(statearr_3554_3571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3551 === (4))){
var inst_3533 = (state_3550[(8)]);
var inst_3533__$1 = (state_3550[(2)]);
var inst_3534 = (inst_3533__$1 == null);
var state_3550__$1 = (function (){var statearr_3555 = state_3550;
(statearr_3555[(8)] = inst_3533__$1);

return statearr_3555;
})();
if(cljs.core.truth_(inst_3534)){
var statearr_3556_3572 = state_3550__$1;
(statearr_3556_3572[(1)] = (5));

} else {
var statearr_3557_3573 = state_3550__$1;
(statearr_3557_3573[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3551 === (6))){
var inst_3530 = (state_3550[(7)]);
var inst_3533 = (state_3550[(8)]);
var inst_3537 = (state_3550[(9)]);
var inst_3537__$1 = f.call(null,inst_3530,inst_3533);
var inst_3538 = cljs.core.reduced_QMARK_.call(null,inst_3537__$1);
var state_3550__$1 = (function (){var statearr_3558 = state_3550;
(statearr_3558[(9)] = inst_3537__$1);

return statearr_3558;
})();
if(inst_3538){
var statearr_3559_3574 = state_3550__$1;
(statearr_3559_3574[(1)] = (8));

} else {
var statearr_3560_3575 = state_3550__$1;
(statearr_3560_3575[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3551 === (3))){
var inst_3548 = (state_3550[(2)]);
var state_3550__$1 = state_3550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3550__$1,inst_3548);
} else {
if((state_val_3551 === (2))){
var state_3550__$1 = state_3550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3550__$1,(4),ch);
} else {
if((state_val_3551 === (9))){
var inst_3537 = (state_3550[(9)]);
var inst_3530 = inst_3537;
var state_3550__$1 = (function (){var statearr_3561 = state_3550;
(statearr_3561[(7)] = inst_3530);

return statearr_3561;
})();
var statearr_3562_3576 = state_3550__$1;
(statearr_3562_3576[(2)] = null);

(statearr_3562_3576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3551 === (5))){
var inst_3530 = (state_3550[(7)]);
var state_3550__$1 = state_3550;
var statearr_3563_3577 = state_3550__$1;
(statearr_3563_3577[(2)] = inst_3530);

(statearr_3563_3577[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3551 === (10))){
var inst_3544 = (state_3550[(2)]);
var state_3550__$1 = state_3550;
var statearr_3564_3578 = state_3550__$1;
(statearr_3564_3578[(2)] = inst_3544);

(statearr_3564_3578[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3551 === (8))){
var inst_3537 = (state_3550[(9)]);
var inst_3540 = cljs.core.deref.call(null,inst_3537);
var state_3550__$1 = state_3550;
var statearr_3565_3579 = state_3550__$1;
(statearr_3565_3579[(2)] = inst_3540);

(statearr_3565_3579[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto__))
;
return ((function (switch__2973__auto__,c__3063__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__2974__auto__ = null;
var cljs$core$async$reduce_$_state_machine__2974__auto____0 = (function (){
var statearr_3566 = [null,null,null,null,null,null,null,null,null,null];
(statearr_3566[(0)] = cljs$core$async$reduce_$_state_machine__2974__auto__);

(statearr_3566[(1)] = (1));

return statearr_3566;
});
var cljs$core$async$reduce_$_state_machine__2974__auto____1 = (function (state_3550){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3567){if((e3567 instanceof Object)){
var ex__2977__auto__ = e3567;
var statearr_3568_3580 = state_3550;
(statearr_3568_3580[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3567;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3581 = state_3550;
state_3550 = G__3581;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__2974__auto__ = function(state_3550){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__2974__auto____1.call(this,state_3550);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__2974__auto____0;
cljs$core$async$reduce_$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__2974__auto____1;
return cljs$core$async$reduce_$_state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto__))
})();
var state__3065__auto__ = (function (){var statearr_3569 = f__3064__auto__.call(null);
(statearr_3569[(6)] = c__3063__auto__);

return statearr_3569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto__))
);

return c__3063__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__3063__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto__,f__$1){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto__,f__$1){
return (function (state_3587){
var state_val_3588 = (state_3587[(1)]);
if((state_val_3588 === (1))){
var inst_3582 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_3587__$1 = state_3587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3587__$1,(2),inst_3582);
} else {
if((state_val_3588 === (2))){
var inst_3584 = (state_3587[(2)]);
var inst_3585 = f__$1.call(null,inst_3584);
var state_3587__$1 = state_3587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3587__$1,inst_3585);
} else {
return null;
}
}
});})(c__3063__auto__,f__$1))
;
return ((function (switch__2973__auto__,c__3063__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__2974__auto__ = null;
var cljs$core$async$transduce_$_state_machine__2974__auto____0 = (function (){
var statearr_3589 = [null,null,null,null,null,null,null];
(statearr_3589[(0)] = cljs$core$async$transduce_$_state_machine__2974__auto__);

(statearr_3589[(1)] = (1));

return statearr_3589;
});
var cljs$core$async$transduce_$_state_machine__2974__auto____1 = (function (state_3587){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3590){if((e3590 instanceof Object)){
var ex__2977__auto__ = e3590;
var statearr_3591_3593 = state_3587;
(statearr_3591_3593[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3587);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3590;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3594 = state_3587;
state_3587 = G__3594;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__2974__auto__ = function(state_3587){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__2974__auto____1.call(this,state_3587);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__2974__auto____0;
cljs$core$async$transduce_$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__2974__auto____1;
return cljs$core$async$transduce_$_state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto__,f__$1))
})();
var state__3065__auto__ = (function (){var statearr_3592 = f__3064__auto__.call(null);
(statearr_3592[(6)] = c__3063__auto__);

return statearr_3592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto__,f__$1))
);

return c__3063__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__3596 = arguments.length;
switch (G__3596) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__3063__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto__){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto__){
return (function (state_3621){
var state_val_3622 = (state_3621[(1)]);
if((state_val_3622 === (7))){
var inst_3603 = (state_3621[(2)]);
var state_3621__$1 = state_3621;
var statearr_3623_3644 = state_3621__$1;
(statearr_3623_3644[(2)] = inst_3603);

(statearr_3623_3644[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (1))){
var inst_3597 = cljs.core.seq.call(null,coll);
var inst_3598 = inst_3597;
var state_3621__$1 = (function (){var statearr_3624 = state_3621;
(statearr_3624[(7)] = inst_3598);

return statearr_3624;
})();
var statearr_3625_3645 = state_3621__$1;
(statearr_3625_3645[(2)] = null);

(statearr_3625_3645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (4))){
var inst_3598 = (state_3621[(7)]);
var inst_3601 = cljs.core.first.call(null,inst_3598);
var state_3621__$1 = state_3621;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3621__$1,(7),ch,inst_3601);
} else {
if((state_val_3622 === (13))){
var inst_3615 = (state_3621[(2)]);
var state_3621__$1 = state_3621;
var statearr_3626_3646 = state_3621__$1;
(statearr_3626_3646[(2)] = inst_3615);

(statearr_3626_3646[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (6))){
var inst_3606 = (state_3621[(2)]);
var state_3621__$1 = state_3621;
if(cljs.core.truth_(inst_3606)){
var statearr_3627_3647 = state_3621__$1;
(statearr_3627_3647[(1)] = (8));

} else {
var statearr_3628_3648 = state_3621__$1;
(statearr_3628_3648[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (3))){
var inst_3619 = (state_3621[(2)]);
var state_3621__$1 = state_3621;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3621__$1,inst_3619);
} else {
if((state_val_3622 === (12))){
var state_3621__$1 = state_3621;
var statearr_3629_3649 = state_3621__$1;
(statearr_3629_3649[(2)] = null);

(statearr_3629_3649[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (2))){
var inst_3598 = (state_3621[(7)]);
var state_3621__$1 = state_3621;
if(cljs.core.truth_(inst_3598)){
var statearr_3630_3650 = state_3621__$1;
(statearr_3630_3650[(1)] = (4));

} else {
var statearr_3631_3651 = state_3621__$1;
(statearr_3631_3651[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (11))){
var inst_3612 = cljs.core.async.close_BANG_.call(null,ch);
var state_3621__$1 = state_3621;
var statearr_3632_3652 = state_3621__$1;
(statearr_3632_3652[(2)] = inst_3612);

(statearr_3632_3652[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (9))){
var state_3621__$1 = state_3621;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3633_3653 = state_3621__$1;
(statearr_3633_3653[(1)] = (11));

} else {
var statearr_3634_3654 = state_3621__$1;
(statearr_3634_3654[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (5))){
var inst_3598 = (state_3621[(7)]);
var state_3621__$1 = state_3621;
var statearr_3635_3655 = state_3621__$1;
(statearr_3635_3655[(2)] = inst_3598);

(statearr_3635_3655[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (10))){
var inst_3617 = (state_3621[(2)]);
var state_3621__$1 = state_3621;
var statearr_3636_3656 = state_3621__$1;
(statearr_3636_3656[(2)] = inst_3617);

(statearr_3636_3656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3622 === (8))){
var inst_3598 = (state_3621[(7)]);
var inst_3608 = cljs.core.next.call(null,inst_3598);
var inst_3598__$1 = inst_3608;
var state_3621__$1 = (function (){var statearr_3637 = state_3621;
(statearr_3637[(7)] = inst_3598__$1);

return statearr_3637;
})();
var statearr_3638_3657 = state_3621__$1;
(statearr_3638_3657[(2)] = null);

(statearr_3638_3657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto__))
;
return ((function (switch__2973__auto__,c__3063__auto__){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_3639 = [null,null,null,null,null,null,null,null];
(statearr_3639[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_3639[(1)] = (1));

return statearr_3639;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_3621){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3621);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3640){if((e3640 instanceof Object)){
var ex__2977__auto__ = e3640;
var statearr_3641_3658 = state_3621;
(statearr_3641_3658[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3621);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3640;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3659 = state_3621;
state_3621 = G__3659;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_3621){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_3621);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto__))
})();
var state__3065__auto__ = (function (){var statearr_3642 = f__3064__auto__.call(null);
(statearr_3642[(6)] = c__3063__auto__);

return statearr_3642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto__))
);

return c__3063__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4210__auto__ = (((_ == null))?null:_);
var m__4211__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,_);
} else {
var m__4211__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4210__auto__ = (((m == null))?null:m);
var m__4211__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4211__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4210__auto__ = (((m == null))?null:m);
var m__4211__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,m,ch);
} else {
var m__4211__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4210__auto__ = (((m == null))?null:m);
var m__4211__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,m);
} else {
var m__4211__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async3660 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3660 = (function (ch,cs,meta3661){
this.ch = ch;
this.cs = cs;
this.meta3661 = meta3661;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3660.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_3662,meta3661__$1){
var self__ = this;
var _3662__$1 = this;
return (new cljs.core.async.t_cljs$core$async3660(self__.ch,self__.cs,meta3661__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async3660.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_3662){
var self__ = this;
var _3662__$1 = this;
return self__.meta3661;
});})(cs))
;

cljs.core.async.t_cljs$core$async3660.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3660.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async3660.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3660.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async3660.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async3660.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async3660.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta3661","meta3661",-1491868593,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async3660.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3660.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3660";

cljs.core.async.t_cljs$core$async3660.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async3660");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3660.
 */
cljs.core.async.__GT_t_cljs$core$async3660 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async3660(ch__$1,cs__$1,meta3661){
return (new cljs.core.async.t_cljs$core$async3660(ch__$1,cs__$1,meta3661));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async3660(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__3063__auto___3882 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___3882,cs,m,dchan,dctr,done){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___3882,cs,m,dchan,dctr,done){
return (function (state_3797){
var state_val_3798 = (state_3797[(1)]);
if((state_val_3798 === (7))){
var inst_3793 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3799_3883 = state_3797__$1;
(statearr_3799_3883[(2)] = inst_3793);

(statearr_3799_3883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (20))){
var inst_3696 = (state_3797[(7)]);
var inst_3708 = cljs.core.first.call(null,inst_3696);
var inst_3709 = cljs.core.nth.call(null,inst_3708,(0),null);
var inst_3710 = cljs.core.nth.call(null,inst_3708,(1),null);
var state_3797__$1 = (function (){var statearr_3800 = state_3797;
(statearr_3800[(8)] = inst_3709);

return statearr_3800;
})();
if(cljs.core.truth_(inst_3710)){
var statearr_3801_3884 = state_3797__$1;
(statearr_3801_3884[(1)] = (22));

} else {
var statearr_3802_3885 = state_3797__$1;
(statearr_3802_3885[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (27))){
var inst_3665 = (state_3797[(9)]);
var inst_3745 = (state_3797[(10)]);
var inst_3740 = (state_3797[(11)]);
var inst_3738 = (state_3797[(12)]);
var inst_3745__$1 = cljs.core._nth.call(null,inst_3738,inst_3740);
var inst_3746 = cljs.core.async.put_BANG_.call(null,inst_3745__$1,inst_3665,done);
var state_3797__$1 = (function (){var statearr_3803 = state_3797;
(statearr_3803[(10)] = inst_3745__$1);

return statearr_3803;
})();
if(cljs.core.truth_(inst_3746)){
var statearr_3804_3886 = state_3797__$1;
(statearr_3804_3886[(1)] = (30));

} else {
var statearr_3805_3887 = state_3797__$1;
(statearr_3805_3887[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (1))){
var state_3797__$1 = state_3797;
var statearr_3806_3888 = state_3797__$1;
(statearr_3806_3888[(2)] = null);

(statearr_3806_3888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (24))){
var inst_3696 = (state_3797[(7)]);
var inst_3715 = (state_3797[(2)]);
var inst_3716 = cljs.core.next.call(null,inst_3696);
var inst_3674 = inst_3716;
var inst_3675 = null;
var inst_3676 = (0);
var inst_3677 = (0);
var state_3797__$1 = (function (){var statearr_3807 = state_3797;
(statearr_3807[(13)] = inst_3674);

(statearr_3807[(14)] = inst_3675);

(statearr_3807[(15)] = inst_3715);

(statearr_3807[(16)] = inst_3677);

(statearr_3807[(17)] = inst_3676);

return statearr_3807;
})();
var statearr_3808_3889 = state_3797__$1;
(statearr_3808_3889[(2)] = null);

(statearr_3808_3889[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (39))){
var state_3797__$1 = state_3797;
var statearr_3812_3890 = state_3797__$1;
(statearr_3812_3890[(2)] = null);

(statearr_3812_3890[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (4))){
var inst_3665 = (state_3797[(9)]);
var inst_3665__$1 = (state_3797[(2)]);
var inst_3666 = (inst_3665__$1 == null);
var state_3797__$1 = (function (){var statearr_3813 = state_3797;
(statearr_3813[(9)] = inst_3665__$1);

return statearr_3813;
})();
if(cljs.core.truth_(inst_3666)){
var statearr_3814_3891 = state_3797__$1;
(statearr_3814_3891[(1)] = (5));

} else {
var statearr_3815_3892 = state_3797__$1;
(statearr_3815_3892[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (15))){
var inst_3674 = (state_3797[(13)]);
var inst_3675 = (state_3797[(14)]);
var inst_3677 = (state_3797[(16)]);
var inst_3676 = (state_3797[(17)]);
var inst_3692 = (state_3797[(2)]);
var inst_3693 = (inst_3677 + (1));
var tmp3809 = inst_3674;
var tmp3810 = inst_3675;
var tmp3811 = inst_3676;
var inst_3674__$1 = tmp3809;
var inst_3675__$1 = tmp3810;
var inst_3676__$1 = tmp3811;
var inst_3677__$1 = inst_3693;
var state_3797__$1 = (function (){var statearr_3816 = state_3797;
(statearr_3816[(13)] = inst_3674__$1);

(statearr_3816[(14)] = inst_3675__$1);

(statearr_3816[(18)] = inst_3692);

(statearr_3816[(16)] = inst_3677__$1);

(statearr_3816[(17)] = inst_3676__$1);

return statearr_3816;
})();
var statearr_3817_3893 = state_3797__$1;
(statearr_3817_3893[(2)] = null);

(statearr_3817_3893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (21))){
var inst_3719 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3821_3894 = state_3797__$1;
(statearr_3821_3894[(2)] = inst_3719);

(statearr_3821_3894[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (31))){
var inst_3745 = (state_3797[(10)]);
var inst_3749 = done.call(null,null);
var inst_3750 = cljs.core.async.untap_STAR_.call(null,m,inst_3745);
var state_3797__$1 = (function (){var statearr_3822 = state_3797;
(statearr_3822[(19)] = inst_3749);

return statearr_3822;
})();
var statearr_3823_3895 = state_3797__$1;
(statearr_3823_3895[(2)] = inst_3750);

(statearr_3823_3895[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (32))){
var inst_3740 = (state_3797[(11)]);
var inst_3737 = (state_3797[(20)]);
var inst_3739 = (state_3797[(21)]);
var inst_3738 = (state_3797[(12)]);
var inst_3752 = (state_3797[(2)]);
var inst_3753 = (inst_3740 + (1));
var tmp3818 = inst_3737;
var tmp3819 = inst_3739;
var tmp3820 = inst_3738;
var inst_3737__$1 = tmp3818;
var inst_3738__$1 = tmp3820;
var inst_3739__$1 = tmp3819;
var inst_3740__$1 = inst_3753;
var state_3797__$1 = (function (){var statearr_3824 = state_3797;
(statearr_3824[(11)] = inst_3740__$1);

(statearr_3824[(20)] = inst_3737__$1);

(statearr_3824[(21)] = inst_3739__$1);

(statearr_3824[(12)] = inst_3738__$1);

(statearr_3824[(22)] = inst_3752);

return statearr_3824;
})();
var statearr_3825_3896 = state_3797__$1;
(statearr_3825_3896[(2)] = null);

(statearr_3825_3896[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (40))){
var inst_3765 = (state_3797[(23)]);
var inst_3769 = done.call(null,null);
var inst_3770 = cljs.core.async.untap_STAR_.call(null,m,inst_3765);
var state_3797__$1 = (function (){var statearr_3826 = state_3797;
(statearr_3826[(24)] = inst_3769);

return statearr_3826;
})();
var statearr_3827_3897 = state_3797__$1;
(statearr_3827_3897[(2)] = inst_3770);

(statearr_3827_3897[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (33))){
var inst_3756 = (state_3797[(25)]);
var inst_3758 = cljs.core.chunked_seq_QMARK_.call(null,inst_3756);
var state_3797__$1 = state_3797;
if(inst_3758){
var statearr_3828_3898 = state_3797__$1;
(statearr_3828_3898[(1)] = (36));

} else {
var statearr_3829_3899 = state_3797__$1;
(statearr_3829_3899[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (13))){
var inst_3686 = (state_3797[(26)]);
var inst_3689 = cljs.core.async.close_BANG_.call(null,inst_3686);
var state_3797__$1 = state_3797;
var statearr_3830_3900 = state_3797__$1;
(statearr_3830_3900[(2)] = inst_3689);

(statearr_3830_3900[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (22))){
var inst_3709 = (state_3797[(8)]);
var inst_3712 = cljs.core.async.close_BANG_.call(null,inst_3709);
var state_3797__$1 = state_3797;
var statearr_3831_3901 = state_3797__$1;
(statearr_3831_3901[(2)] = inst_3712);

(statearr_3831_3901[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (36))){
var inst_3756 = (state_3797[(25)]);
var inst_3760 = cljs.core.chunk_first.call(null,inst_3756);
var inst_3761 = cljs.core.chunk_rest.call(null,inst_3756);
var inst_3762 = cljs.core.count.call(null,inst_3760);
var inst_3737 = inst_3761;
var inst_3738 = inst_3760;
var inst_3739 = inst_3762;
var inst_3740 = (0);
var state_3797__$1 = (function (){var statearr_3832 = state_3797;
(statearr_3832[(11)] = inst_3740);

(statearr_3832[(20)] = inst_3737);

(statearr_3832[(21)] = inst_3739);

(statearr_3832[(12)] = inst_3738);

return statearr_3832;
})();
var statearr_3833_3902 = state_3797__$1;
(statearr_3833_3902[(2)] = null);

(statearr_3833_3902[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (41))){
var inst_3756 = (state_3797[(25)]);
var inst_3772 = (state_3797[(2)]);
var inst_3773 = cljs.core.next.call(null,inst_3756);
var inst_3737 = inst_3773;
var inst_3738 = null;
var inst_3739 = (0);
var inst_3740 = (0);
var state_3797__$1 = (function (){var statearr_3834 = state_3797;
(statearr_3834[(27)] = inst_3772);

(statearr_3834[(11)] = inst_3740);

(statearr_3834[(20)] = inst_3737);

(statearr_3834[(21)] = inst_3739);

(statearr_3834[(12)] = inst_3738);

return statearr_3834;
})();
var statearr_3835_3903 = state_3797__$1;
(statearr_3835_3903[(2)] = null);

(statearr_3835_3903[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (43))){
var state_3797__$1 = state_3797;
var statearr_3836_3904 = state_3797__$1;
(statearr_3836_3904[(2)] = null);

(statearr_3836_3904[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (29))){
var inst_3781 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3837_3905 = state_3797__$1;
(statearr_3837_3905[(2)] = inst_3781);

(statearr_3837_3905[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (44))){
var inst_3790 = (state_3797[(2)]);
var state_3797__$1 = (function (){var statearr_3838 = state_3797;
(statearr_3838[(28)] = inst_3790);

return statearr_3838;
})();
var statearr_3839_3906 = state_3797__$1;
(statearr_3839_3906[(2)] = null);

(statearr_3839_3906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (6))){
var inst_3729 = (state_3797[(29)]);
var inst_3728 = cljs.core.deref.call(null,cs);
var inst_3729__$1 = cljs.core.keys.call(null,inst_3728);
var inst_3730 = cljs.core.count.call(null,inst_3729__$1);
var inst_3731 = cljs.core.reset_BANG_.call(null,dctr,inst_3730);
var inst_3736 = cljs.core.seq.call(null,inst_3729__$1);
var inst_3737 = inst_3736;
var inst_3738 = null;
var inst_3739 = (0);
var inst_3740 = (0);
var state_3797__$1 = (function (){var statearr_3840 = state_3797;
(statearr_3840[(30)] = inst_3731);

(statearr_3840[(11)] = inst_3740);

(statearr_3840[(29)] = inst_3729__$1);

(statearr_3840[(20)] = inst_3737);

(statearr_3840[(21)] = inst_3739);

(statearr_3840[(12)] = inst_3738);

return statearr_3840;
})();
var statearr_3841_3907 = state_3797__$1;
(statearr_3841_3907[(2)] = null);

(statearr_3841_3907[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (28))){
var inst_3756 = (state_3797[(25)]);
var inst_3737 = (state_3797[(20)]);
var inst_3756__$1 = cljs.core.seq.call(null,inst_3737);
var state_3797__$1 = (function (){var statearr_3842 = state_3797;
(statearr_3842[(25)] = inst_3756__$1);

return statearr_3842;
})();
if(inst_3756__$1){
var statearr_3843_3908 = state_3797__$1;
(statearr_3843_3908[(1)] = (33));

} else {
var statearr_3844_3909 = state_3797__$1;
(statearr_3844_3909[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (25))){
var inst_3740 = (state_3797[(11)]);
var inst_3739 = (state_3797[(21)]);
var inst_3742 = (inst_3740 < inst_3739);
var inst_3743 = inst_3742;
var state_3797__$1 = state_3797;
if(cljs.core.truth_(inst_3743)){
var statearr_3845_3910 = state_3797__$1;
(statearr_3845_3910[(1)] = (27));

} else {
var statearr_3846_3911 = state_3797__$1;
(statearr_3846_3911[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (34))){
var state_3797__$1 = state_3797;
var statearr_3847_3912 = state_3797__$1;
(statearr_3847_3912[(2)] = null);

(statearr_3847_3912[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (17))){
var state_3797__$1 = state_3797;
var statearr_3848_3913 = state_3797__$1;
(statearr_3848_3913[(2)] = null);

(statearr_3848_3913[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (3))){
var inst_3795 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3797__$1,inst_3795);
} else {
if((state_val_3798 === (12))){
var inst_3724 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3849_3914 = state_3797__$1;
(statearr_3849_3914[(2)] = inst_3724);

(statearr_3849_3914[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (2))){
var state_3797__$1 = state_3797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3797__$1,(4),ch);
} else {
if((state_val_3798 === (23))){
var state_3797__$1 = state_3797;
var statearr_3850_3915 = state_3797__$1;
(statearr_3850_3915[(2)] = null);

(statearr_3850_3915[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (35))){
var inst_3779 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3851_3916 = state_3797__$1;
(statearr_3851_3916[(2)] = inst_3779);

(statearr_3851_3916[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (19))){
var inst_3696 = (state_3797[(7)]);
var inst_3700 = cljs.core.chunk_first.call(null,inst_3696);
var inst_3701 = cljs.core.chunk_rest.call(null,inst_3696);
var inst_3702 = cljs.core.count.call(null,inst_3700);
var inst_3674 = inst_3701;
var inst_3675 = inst_3700;
var inst_3676 = inst_3702;
var inst_3677 = (0);
var state_3797__$1 = (function (){var statearr_3852 = state_3797;
(statearr_3852[(13)] = inst_3674);

(statearr_3852[(14)] = inst_3675);

(statearr_3852[(16)] = inst_3677);

(statearr_3852[(17)] = inst_3676);

return statearr_3852;
})();
var statearr_3853_3917 = state_3797__$1;
(statearr_3853_3917[(2)] = null);

(statearr_3853_3917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (11))){
var inst_3674 = (state_3797[(13)]);
var inst_3696 = (state_3797[(7)]);
var inst_3696__$1 = cljs.core.seq.call(null,inst_3674);
var state_3797__$1 = (function (){var statearr_3854 = state_3797;
(statearr_3854[(7)] = inst_3696__$1);

return statearr_3854;
})();
if(inst_3696__$1){
var statearr_3855_3918 = state_3797__$1;
(statearr_3855_3918[(1)] = (16));

} else {
var statearr_3856_3919 = state_3797__$1;
(statearr_3856_3919[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (9))){
var inst_3726 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3857_3920 = state_3797__$1;
(statearr_3857_3920[(2)] = inst_3726);

(statearr_3857_3920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (5))){
var inst_3672 = cljs.core.deref.call(null,cs);
var inst_3673 = cljs.core.seq.call(null,inst_3672);
var inst_3674 = inst_3673;
var inst_3675 = null;
var inst_3676 = (0);
var inst_3677 = (0);
var state_3797__$1 = (function (){var statearr_3858 = state_3797;
(statearr_3858[(13)] = inst_3674);

(statearr_3858[(14)] = inst_3675);

(statearr_3858[(16)] = inst_3677);

(statearr_3858[(17)] = inst_3676);

return statearr_3858;
})();
var statearr_3859_3921 = state_3797__$1;
(statearr_3859_3921[(2)] = null);

(statearr_3859_3921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (14))){
var state_3797__$1 = state_3797;
var statearr_3860_3922 = state_3797__$1;
(statearr_3860_3922[(2)] = null);

(statearr_3860_3922[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (45))){
var inst_3787 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3861_3923 = state_3797__$1;
(statearr_3861_3923[(2)] = inst_3787);

(statearr_3861_3923[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (26))){
var inst_3729 = (state_3797[(29)]);
var inst_3783 = (state_3797[(2)]);
var inst_3784 = cljs.core.seq.call(null,inst_3729);
var state_3797__$1 = (function (){var statearr_3862 = state_3797;
(statearr_3862[(31)] = inst_3783);

return statearr_3862;
})();
if(inst_3784){
var statearr_3863_3924 = state_3797__$1;
(statearr_3863_3924[(1)] = (42));

} else {
var statearr_3864_3925 = state_3797__$1;
(statearr_3864_3925[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (16))){
var inst_3696 = (state_3797[(7)]);
var inst_3698 = cljs.core.chunked_seq_QMARK_.call(null,inst_3696);
var state_3797__$1 = state_3797;
if(inst_3698){
var statearr_3865_3926 = state_3797__$1;
(statearr_3865_3926[(1)] = (19));

} else {
var statearr_3866_3927 = state_3797__$1;
(statearr_3866_3927[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (38))){
var inst_3776 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3867_3928 = state_3797__$1;
(statearr_3867_3928[(2)] = inst_3776);

(statearr_3867_3928[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (30))){
var state_3797__$1 = state_3797;
var statearr_3868_3929 = state_3797__$1;
(statearr_3868_3929[(2)] = null);

(statearr_3868_3929[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (10))){
var inst_3675 = (state_3797[(14)]);
var inst_3677 = (state_3797[(16)]);
var inst_3685 = cljs.core._nth.call(null,inst_3675,inst_3677);
var inst_3686 = cljs.core.nth.call(null,inst_3685,(0),null);
var inst_3687 = cljs.core.nth.call(null,inst_3685,(1),null);
var state_3797__$1 = (function (){var statearr_3869 = state_3797;
(statearr_3869[(26)] = inst_3686);

return statearr_3869;
})();
if(cljs.core.truth_(inst_3687)){
var statearr_3870_3930 = state_3797__$1;
(statearr_3870_3930[(1)] = (13));

} else {
var statearr_3871_3931 = state_3797__$1;
(statearr_3871_3931[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (18))){
var inst_3722 = (state_3797[(2)]);
var state_3797__$1 = state_3797;
var statearr_3872_3932 = state_3797__$1;
(statearr_3872_3932[(2)] = inst_3722);

(statearr_3872_3932[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (42))){
var state_3797__$1 = state_3797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3797__$1,(45),dchan);
} else {
if((state_val_3798 === (37))){
var inst_3756 = (state_3797[(25)]);
var inst_3665 = (state_3797[(9)]);
var inst_3765 = (state_3797[(23)]);
var inst_3765__$1 = cljs.core.first.call(null,inst_3756);
var inst_3766 = cljs.core.async.put_BANG_.call(null,inst_3765__$1,inst_3665,done);
var state_3797__$1 = (function (){var statearr_3873 = state_3797;
(statearr_3873[(23)] = inst_3765__$1);

return statearr_3873;
})();
if(cljs.core.truth_(inst_3766)){
var statearr_3874_3933 = state_3797__$1;
(statearr_3874_3933[(1)] = (39));

} else {
var statearr_3875_3934 = state_3797__$1;
(statearr_3875_3934[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3798 === (8))){
var inst_3677 = (state_3797[(16)]);
var inst_3676 = (state_3797[(17)]);
var inst_3679 = (inst_3677 < inst_3676);
var inst_3680 = inst_3679;
var state_3797__$1 = state_3797;
if(cljs.core.truth_(inst_3680)){
var statearr_3876_3935 = state_3797__$1;
(statearr_3876_3935[(1)] = (10));

} else {
var statearr_3877_3936 = state_3797__$1;
(statearr_3877_3936[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___3882,cs,m,dchan,dctr,done))
;
return ((function (switch__2973__auto__,c__3063__auto___3882,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__2974__auto__ = null;
var cljs$core$async$mult_$_state_machine__2974__auto____0 = (function (){
var statearr_3878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3878[(0)] = cljs$core$async$mult_$_state_machine__2974__auto__);

(statearr_3878[(1)] = (1));

return statearr_3878;
});
var cljs$core$async$mult_$_state_machine__2974__auto____1 = (function (state_3797){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_3797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e3879){if((e3879 instanceof Object)){
var ex__2977__auto__ = e3879;
var statearr_3880_3937 = state_3797;
(statearr_3880_3937[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3797);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3938 = state_3797;
state_3797 = G__3938;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__2974__auto__ = function(state_3797){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__2974__auto____1.call(this,state_3797);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__2974__auto____0;
cljs$core$async$mult_$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__2974__auto____1;
return cljs$core$async$mult_$_state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___3882,cs,m,dchan,dctr,done))
})();
var state__3065__auto__ = (function (){var statearr_3881 = f__3064__auto__.call(null);
(statearr_3881[(6)] = c__3063__auto___3882);

return statearr_3881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___3882,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__3940 = arguments.length;
switch (G__3940) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4210__auto__ = (((m == null))?null:m);
var m__4211__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,m,ch);
} else {
var m__4211__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4210__auto__ = (((m == null))?null:m);
var m__4211__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,m,ch);
} else {
var m__4211__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4210__auto__ = (((m == null))?null:m);
var m__4211__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,m);
} else {
var m__4211__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4210__auto__ = (((m == null))?null:m);
var m__4211__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,m,state_map);
} else {
var m__4211__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4210__auto__ = (((m == null))?null:m);
var m__4211__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,m,mode);
} else {
var m__4211__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4501__auto__ = [];
var len__4498__auto___3952 = arguments.length;
var i__4499__auto___3953 = (0);
while(true){
if((i__4499__auto___3953 < len__4498__auto___3952)){
args__4501__auto__.push((arguments[i__4499__auto___3953]));

var G__3954 = (i__4499__auto___3953 + (1));
i__4499__auto___3953 = G__3954;
continue;
} else {
}
break;
}

var argseq__4502__auto__ = ((((3) < args__4501__auto__.length))?(new cljs.core.IndexedSeq(args__4501__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4502__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__3946){
var map__3947 = p__3946;
var map__3947__$1 = ((((!((map__3947 == null)))?(((((map__3947.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3947.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3947):map__3947);
var opts = map__3947__$1;
var statearr_3949_3955 = state;
(statearr_3949_3955[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__3947,map__3947__$1,opts){
return (function (val){
var statearr_3950_3956 = state;
(statearr_3950_3956[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__3947,map__3947__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_3951_3957 = state;
(statearr_3951_3957[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq3942){
var G__3943 = cljs.core.first.call(null,seq3942);
var seq3942__$1 = cljs.core.next.call(null,seq3942);
var G__3944 = cljs.core.first.call(null,seq3942__$1);
var seq3942__$2 = cljs.core.next.call(null,seq3942__$1);
var G__3945 = cljs.core.first.call(null,seq3942__$2);
var seq3942__$3 = cljs.core.next.call(null,seq3942__$2);
var self__4485__auto__ = this;
return self__4485__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3943,G__3944,G__3945,seq3942__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos)))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async3958 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3958 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta3959){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta3959 = meta3959;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_3960,meta3959__$1){
var self__ = this;
var _3960__$1 = this;
return (new cljs.core.async.t_cljs$core$async3958(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta3959__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_3960){
var self__ = this;
var _3960__$1 = this;
return self__.meta3959;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta3959","meta3959",1094103805,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3958.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3958.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3958";

cljs.core.async.t_cljs$core$async3958.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async3958");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3958.
 */
cljs.core.async.__GT_t_cljs$core$async3958 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async3958(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta3959){
return (new cljs.core.async.t_cljs$core$async3958(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta3959));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async3958(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__3063__auto___4122 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4122,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4122,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_4062){
var state_val_4063 = (state_4062[(1)]);
if((state_val_4063 === (7))){
var inst_3977 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
var statearr_4064_4123 = state_4062__$1;
(statearr_4064_4123[(2)] = inst_3977);

(statearr_4064_4123[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (20))){
var inst_3989 = (state_4062[(7)]);
var state_4062__$1 = state_4062;
var statearr_4065_4124 = state_4062__$1;
(statearr_4065_4124[(2)] = inst_3989);

(statearr_4065_4124[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (27))){
var state_4062__$1 = state_4062;
var statearr_4066_4125 = state_4062__$1;
(statearr_4066_4125[(2)] = null);

(statearr_4066_4125[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (1))){
var inst_3964 = (state_4062[(8)]);
var inst_3964__$1 = calc_state.call(null);
var inst_3966 = (inst_3964__$1 == null);
var inst_3967 = cljs.core.not.call(null,inst_3966);
var state_4062__$1 = (function (){var statearr_4067 = state_4062;
(statearr_4067[(8)] = inst_3964__$1);

return statearr_4067;
})();
if(inst_3967){
var statearr_4068_4126 = state_4062__$1;
(statearr_4068_4126[(1)] = (2));

} else {
var statearr_4069_4127 = state_4062__$1;
(statearr_4069_4127[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (24))){
var inst_4036 = (state_4062[(9)]);
var inst_4013 = (state_4062[(10)]);
var inst_4022 = (state_4062[(11)]);
var inst_4036__$1 = inst_4013.call(null,inst_4022);
var state_4062__$1 = (function (){var statearr_4070 = state_4062;
(statearr_4070[(9)] = inst_4036__$1);

return statearr_4070;
})();
if(cljs.core.truth_(inst_4036__$1)){
var statearr_4071_4128 = state_4062__$1;
(statearr_4071_4128[(1)] = (29));

} else {
var statearr_4072_4129 = state_4062__$1;
(statearr_4072_4129[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (4))){
var inst_3980 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
if(cljs.core.truth_(inst_3980)){
var statearr_4073_4130 = state_4062__$1;
(statearr_4073_4130[(1)] = (8));

} else {
var statearr_4074_4131 = state_4062__$1;
(statearr_4074_4131[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (15))){
var inst_4007 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
if(cljs.core.truth_(inst_4007)){
var statearr_4075_4132 = state_4062__$1;
(statearr_4075_4132[(1)] = (19));

} else {
var statearr_4076_4133 = state_4062__$1;
(statearr_4076_4133[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (21))){
var inst_4012 = (state_4062[(12)]);
var inst_4012__$1 = (state_4062[(2)]);
var inst_4013 = cljs.core.get.call(null,inst_4012__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_4014 = cljs.core.get.call(null,inst_4012__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_4015 = cljs.core.get.call(null,inst_4012__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_4062__$1 = (function (){var statearr_4077 = state_4062;
(statearr_4077[(10)] = inst_4013);

(statearr_4077[(13)] = inst_4014);

(statearr_4077[(12)] = inst_4012__$1);

return statearr_4077;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_4062__$1,(22),inst_4015);
} else {
if((state_val_4063 === (31))){
var inst_4044 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
if(cljs.core.truth_(inst_4044)){
var statearr_4078_4134 = state_4062__$1;
(statearr_4078_4134[(1)] = (32));

} else {
var statearr_4079_4135 = state_4062__$1;
(statearr_4079_4135[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (32))){
var inst_4021 = (state_4062[(14)]);
var state_4062__$1 = state_4062;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4062__$1,(35),out,inst_4021);
} else {
if((state_val_4063 === (33))){
var inst_4012 = (state_4062[(12)]);
var inst_3989 = inst_4012;
var state_4062__$1 = (function (){var statearr_4080 = state_4062;
(statearr_4080[(7)] = inst_3989);

return statearr_4080;
})();
var statearr_4081_4136 = state_4062__$1;
(statearr_4081_4136[(2)] = null);

(statearr_4081_4136[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (13))){
var inst_3989 = (state_4062[(7)]);
var inst_3996 = inst_3989.cljs$lang$protocol_mask$partition0$;
var inst_3997 = (inst_3996 & (64));
var inst_3998 = inst_3989.cljs$core$ISeq$;
var inst_3999 = (cljs.core.PROTOCOL_SENTINEL === inst_3998);
var inst_4000 = ((inst_3997) || (inst_3999));
var state_4062__$1 = state_4062;
if(cljs.core.truth_(inst_4000)){
var statearr_4082_4137 = state_4062__$1;
(statearr_4082_4137[(1)] = (16));

} else {
var statearr_4083_4138 = state_4062__$1;
(statearr_4083_4138[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (22))){
var inst_4021 = (state_4062[(14)]);
var inst_4022 = (state_4062[(11)]);
var inst_4020 = (state_4062[(2)]);
var inst_4021__$1 = cljs.core.nth.call(null,inst_4020,(0),null);
var inst_4022__$1 = cljs.core.nth.call(null,inst_4020,(1),null);
var inst_4023 = (inst_4021__$1 == null);
var inst_4024 = cljs.core._EQ_.call(null,inst_4022__$1,change);
var inst_4025 = ((inst_4023) || (inst_4024));
var state_4062__$1 = (function (){var statearr_4084 = state_4062;
(statearr_4084[(14)] = inst_4021__$1);

(statearr_4084[(11)] = inst_4022__$1);

return statearr_4084;
})();
if(cljs.core.truth_(inst_4025)){
var statearr_4085_4139 = state_4062__$1;
(statearr_4085_4139[(1)] = (23));

} else {
var statearr_4086_4140 = state_4062__$1;
(statearr_4086_4140[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (36))){
var inst_4012 = (state_4062[(12)]);
var inst_3989 = inst_4012;
var state_4062__$1 = (function (){var statearr_4087 = state_4062;
(statearr_4087[(7)] = inst_3989);

return statearr_4087;
})();
var statearr_4088_4141 = state_4062__$1;
(statearr_4088_4141[(2)] = null);

(statearr_4088_4141[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (29))){
var inst_4036 = (state_4062[(9)]);
var state_4062__$1 = state_4062;
var statearr_4089_4142 = state_4062__$1;
(statearr_4089_4142[(2)] = inst_4036);

(statearr_4089_4142[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (6))){
var state_4062__$1 = state_4062;
var statearr_4090_4143 = state_4062__$1;
(statearr_4090_4143[(2)] = false);

(statearr_4090_4143[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (28))){
var inst_4032 = (state_4062[(2)]);
var inst_4033 = calc_state.call(null);
var inst_3989 = inst_4033;
var state_4062__$1 = (function (){var statearr_4091 = state_4062;
(statearr_4091[(15)] = inst_4032);

(statearr_4091[(7)] = inst_3989);

return statearr_4091;
})();
var statearr_4092_4144 = state_4062__$1;
(statearr_4092_4144[(2)] = null);

(statearr_4092_4144[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (25))){
var inst_4058 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
var statearr_4093_4145 = state_4062__$1;
(statearr_4093_4145[(2)] = inst_4058);

(statearr_4093_4145[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (34))){
var inst_4056 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
var statearr_4094_4146 = state_4062__$1;
(statearr_4094_4146[(2)] = inst_4056);

(statearr_4094_4146[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (17))){
var state_4062__$1 = state_4062;
var statearr_4095_4147 = state_4062__$1;
(statearr_4095_4147[(2)] = false);

(statearr_4095_4147[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (3))){
var state_4062__$1 = state_4062;
var statearr_4096_4148 = state_4062__$1;
(statearr_4096_4148[(2)] = false);

(statearr_4096_4148[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (12))){
var inst_4060 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4062__$1,inst_4060);
} else {
if((state_val_4063 === (2))){
var inst_3964 = (state_4062[(8)]);
var inst_3969 = inst_3964.cljs$lang$protocol_mask$partition0$;
var inst_3970 = (inst_3969 & (64));
var inst_3971 = inst_3964.cljs$core$ISeq$;
var inst_3972 = (cljs.core.PROTOCOL_SENTINEL === inst_3971);
var inst_3973 = ((inst_3970) || (inst_3972));
var state_4062__$1 = state_4062;
if(cljs.core.truth_(inst_3973)){
var statearr_4097_4149 = state_4062__$1;
(statearr_4097_4149[(1)] = (5));

} else {
var statearr_4098_4150 = state_4062__$1;
(statearr_4098_4150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (23))){
var inst_4021 = (state_4062[(14)]);
var inst_4027 = (inst_4021 == null);
var state_4062__$1 = state_4062;
if(cljs.core.truth_(inst_4027)){
var statearr_4099_4151 = state_4062__$1;
(statearr_4099_4151[(1)] = (26));

} else {
var statearr_4100_4152 = state_4062__$1;
(statearr_4100_4152[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (35))){
var inst_4047 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
if(cljs.core.truth_(inst_4047)){
var statearr_4101_4153 = state_4062__$1;
(statearr_4101_4153[(1)] = (36));

} else {
var statearr_4102_4154 = state_4062__$1;
(statearr_4102_4154[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (19))){
var inst_3989 = (state_4062[(7)]);
var inst_4009 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3989);
var state_4062__$1 = state_4062;
var statearr_4103_4155 = state_4062__$1;
(statearr_4103_4155[(2)] = inst_4009);

(statearr_4103_4155[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (11))){
var inst_3989 = (state_4062[(7)]);
var inst_3993 = (inst_3989 == null);
var inst_3994 = cljs.core.not.call(null,inst_3993);
var state_4062__$1 = state_4062;
if(inst_3994){
var statearr_4104_4156 = state_4062__$1;
(statearr_4104_4156[(1)] = (13));

} else {
var statearr_4105_4157 = state_4062__$1;
(statearr_4105_4157[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (9))){
var inst_3964 = (state_4062[(8)]);
var state_4062__$1 = state_4062;
var statearr_4106_4158 = state_4062__$1;
(statearr_4106_4158[(2)] = inst_3964);

(statearr_4106_4158[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (5))){
var state_4062__$1 = state_4062;
var statearr_4107_4159 = state_4062__$1;
(statearr_4107_4159[(2)] = true);

(statearr_4107_4159[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (14))){
var state_4062__$1 = state_4062;
var statearr_4108_4160 = state_4062__$1;
(statearr_4108_4160[(2)] = false);

(statearr_4108_4160[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (26))){
var inst_4022 = (state_4062[(11)]);
var inst_4029 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_4022);
var state_4062__$1 = state_4062;
var statearr_4109_4161 = state_4062__$1;
(statearr_4109_4161[(2)] = inst_4029);

(statearr_4109_4161[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (16))){
var state_4062__$1 = state_4062;
var statearr_4110_4162 = state_4062__$1;
(statearr_4110_4162[(2)] = true);

(statearr_4110_4162[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (38))){
var inst_4052 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
var statearr_4111_4163 = state_4062__$1;
(statearr_4111_4163[(2)] = inst_4052);

(statearr_4111_4163[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (30))){
var inst_4013 = (state_4062[(10)]);
var inst_4014 = (state_4062[(13)]);
var inst_4022 = (state_4062[(11)]);
var inst_4039 = cljs.core.empty_QMARK_.call(null,inst_4013);
var inst_4040 = inst_4014.call(null,inst_4022);
var inst_4041 = cljs.core.not.call(null,inst_4040);
var inst_4042 = ((inst_4039) && (inst_4041));
var state_4062__$1 = state_4062;
var statearr_4112_4164 = state_4062__$1;
(statearr_4112_4164[(2)] = inst_4042);

(statearr_4112_4164[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (10))){
var inst_3964 = (state_4062[(8)]);
var inst_3985 = (state_4062[(2)]);
var inst_3986 = cljs.core.get.call(null,inst_3985,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_3987 = cljs.core.get.call(null,inst_3985,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_3988 = cljs.core.get.call(null,inst_3985,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_3989 = inst_3964;
var state_4062__$1 = (function (){var statearr_4113 = state_4062;
(statearr_4113[(16)] = inst_3986);

(statearr_4113[(17)] = inst_3987);

(statearr_4113[(18)] = inst_3988);

(statearr_4113[(7)] = inst_3989);

return statearr_4113;
})();
var statearr_4114_4165 = state_4062__$1;
(statearr_4114_4165[(2)] = null);

(statearr_4114_4165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (18))){
var inst_4004 = (state_4062[(2)]);
var state_4062__$1 = state_4062;
var statearr_4115_4166 = state_4062__$1;
(statearr_4115_4166[(2)] = inst_4004);

(statearr_4115_4166[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (37))){
var state_4062__$1 = state_4062;
var statearr_4116_4167 = state_4062__$1;
(statearr_4116_4167[(2)] = null);

(statearr_4116_4167[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4063 === (8))){
var inst_3964 = (state_4062[(8)]);
var inst_3982 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3964);
var state_4062__$1 = state_4062;
var statearr_4117_4168 = state_4062__$1;
(statearr_4117_4168[(2)] = inst_3982);

(statearr_4117_4168[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4122,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__2973__auto__,c__3063__auto___4122,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__2974__auto__ = null;
var cljs$core$async$mix_$_state_machine__2974__auto____0 = (function (){
var statearr_4118 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4118[(0)] = cljs$core$async$mix_$_state_machine__2974__auto__);

(statearr_4118[(1)] = (1));

return statearr_4118;
});
var cljs$core$async$mix_$_state_machine__2974__auto____1 = (function (state_4062){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4119){if((e4119 instanceof Object)){
var ex__2977__auto__ = e4119;
var statearr_4120_4169 = state_4062;
(statearr_4120_4169[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4119;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4170 = state_4062;
state_4062 = G__4170;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__2974__auto__ = function(state_4062){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__2974__auto____1.call(this,state_4062);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__2974__auto____0;
cljs$core$async$mix_$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__2974__auto____1;
return cljs$core$async$mix_$_state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4122,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__3065__auto__ = (function (){var statearr_4121 = f__3064__auto__.call(null);
(statearr_4121[(6)] = c__3063__auto___4122);

return statearr_4121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4122,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4210__auto__ = (((p == null))?null:p);
var m__4211__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4211__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4210__auto__ = (((p == null))?null:p);
var m__4211__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,p,v,ch);
} else {
var m__4211__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__4172 = arguments.length;
switch (G__4172) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4210__auto__ = (((p == null))?null:p);
var m__4211__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,p);
} else {
var m__4211__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4210__auto__ = (((p == null))?null:p);
var m__4211__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4210__auto__)]);
if(!((m__4211__auto__ == null))){
return m__4211__auto__.call(null,p,v);
} else {
var m__4211__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4211__auto____$1 == null))){
return m__4211__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__4176 = arguments.length;
switch (G__4176) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3921__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3921__auto__,mults){
return (function (p1__4174_SHARP_){
if(cljs.core.truth_(p1__4174_SHARP_.call(null,topic))){
return p1__4174_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__4174_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3921__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async4177 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4177 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta4178){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta4178 = meta4178;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_4179,meta4178__$1){
var self__ = this;
var _4179__$1 = this;
return (new cljs.core.async.t_cljs$core$async4177(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta4178__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_4179){
var self__ = this;
var _4179__$1 = this;
return self__.meta4178;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4177.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4177.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta4178","meta4178",1854816625,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async4177.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4177.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4177";

cljs.core.async.t_cljs$core$async4177.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async4177");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4177.
 */
cljs.core.async.__GT_t_cljs$core$async4177 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async4177(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta4178){
return (new cljs.core.async.t_cljs$core$async4177(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta4178));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async4177(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__3063__auto___4297 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4297,mults,ensure_mult,p){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4297,mults,ensure_mult,p){
return (function (state_4251){
var state_val_4252 = (state_4251[(1)]);
if((state_val_4252 === (7))){
var inst_4247 = (state_4251[(2)]);
var state_4251__$1 = state_4251;
var statearr_4253_4298 = state_4251__$1;
(statearr_4253_4298[(2)] = inst_4247);

(statearr_4253_4298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (20))){
var state_4251__$1 = state_4251;
var statearr_4254_4299 = state_4251__$1;
(statearr_4254_4299[(2)] = null);

(statearr_4254_4299[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (1))){
var state_4251__$1 = state_4251;
var statearr_4255_4300 = state_4251__$1;
(statearr_4255_4300[(2)] = null);

(statearr_4255_4300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (24))){
var inst_4230 = (state_4251[(7)]);
var inst_4239 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_4230);
var state_4251__$1 = state_4251;
var statearr_4256_4301 = state_4251__$1;
(statearr_4256_4301[(2)] = inst_4239);

(statearr_4256_4301[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (4))){
var inst_4182 = (state_4251[(8)]);
var inst_4182__$1 = (state_4251[(2)]);
var inst_4183 = (inst_4182__$1 == null);
var state_4251__$1 = (function (){var statearr_4257 = state_4251;
(statearr_4257[(8)] = inst_4182__$1);

return statearr_4257;
})();
if(cljs.core.truth_(inst_4183)){
var statearr_4258_4302 = state_4251__$1;
(statearr_4258_4302[(1)] = (5));

} else {
var statearr_4259_4303 = state_4251__$1;
(statearr_4259_4303[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (15))){
var inst_4224 = (state_4251[(2)]);
var state_4251__$1 = state_4251;
var statearr_4260_4304 = state_4251__$1;
(statearr_4260_4304[(2)] = inst_4224);

(statearr_4260_4304[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (21))){
var inst_4244 = (state_4251[(2)]);
var state_4251__$1 = (function (){var statearr_4261 = state_4251;
(statearr_4261[(9)] = inst_4244);

return statearr_4261;
})();
var statearr_4262_4305 = state_4251__$1;
(statearr_4262_4305[(2)] = null);

(statearr_4262_4305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (13))){
var inst_4206 = (state_4251[(10)]);
var inst_4208 = cljs.core.chunked_seq_QMARK_.call(null,inst_4206);
var state_4251__$1 = state_4251;
if(inst_4208){
var statearr_4263_4306 = state_4251__$1;
(statearr_4263_4306[(1)] = (16));

} else {
var statearr_4264_4307 = state_4251__$1;
(statearr_4264_4307[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (22))){
var inst_4236 = (state_4251[(2)]);
var state_4251__$1 = state_4251;
if(cljs.core.truth_(inst_4236)){
var statearr_4265_4308 = state_4251__$1;
(statearr_4265_4308[(1)] = (23));

} else {
var statearr_4266_4309 = state_4251__$1;
(statearr_4266_4309[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (6))){
var inst_4230 = (state_4251[(7)]);
var inst_4182 = (state_4251[(8)]);
var inst_4232 = (state_4251[(11)]);
var inst_4230__$1 = topic_fn.call(null,inst_4182);
var inst_4231 = cljs.core.deref.call(null,mults);
var inst_4232__$1 = cljs.core.get.call(null,inst_4231,inst_4230__$1);
var state_4251__$1 = (function (){var statearr_4267 = state_4251;
(statearr_4267[(7)] = inst_4230__$1);

(statearr_4267[(11)] = inst_4232__$1);

return statearr_4267;
})();
if(cljs.core.truth_(inst_4232__$1)){
var statearr_4268_4310 = state_4251__$1;
(statearr_4268_4310[(1)] = (19));

} else {
var statearr_4269_4311 = state_4251__$1;
(statearr_4269_4311[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (25))){
var inst_4241 = (state_4251[(2)]);
var state_4251__$1 = state_4251;
var statearr_4270_4312 = state_4251__$1;
(statearr_4270_4312[(2)] = inst_4241);

(statearr_4270_4312[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (17))){
var inst_4206 = (state_4251[(10)]);
var inst_4215 = cljs.core.first.call(null,inst_4206);
var inst_4216 = cljs.core.async.muxch_STAR_.call(null,inst_4215);
var inst_4217 = cljs.core.async.close_BANG_.call(null,inst_4216);
var inst_4218 = cljs.core.next.call(null,inst_4206);
var inst_4192 = inst_4218;
var inst_4193 = null;
var inst_4194 = (0);
var inst_4195 = (0);
var state_4251__$1 = (function (){var statearr_4271 = state_4251;
(statearr_4271[(12)] = inst_4194);

(statearr_4271[(13)] = inst_4193);

(statearr_4271[(14)] = inst_4195);

(statearr_4271[(15)] = inst_4217);

(statearr_4271[(16)] = inst_4192);

return statearr_4271;
})();
var statearr_4272_4313 = state_4251__$1;
(statearr_4272_4313[(2)] = null);

(statearr_4272_4313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (3))){
var inst_4249 = (state_4251[(2)]);
var state_4251__$1 = state_4251;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4251__$1,inst_4249);
} else {
if((state_val_4252 === (12))){
var inst_4226 = (state_4251[(2)]);
var state_4251__$1 = state_4251;
var statearr_4273_4314 = state_4251__$1;
(statearr_4273_4314[(2)] = inst_4226);

(statearr_4273_4314[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (2))){
var state_4251__$1 = state_4251;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4251__$1,(4),ch);
} else {
if((state_val_4252 === (23))){
var state_4251__$1 = state_4251;
var statearr_4274_4315 = state_4251__$1;
(statearr_4274_4315[(2)] = null);

(statearr_4274_4315[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (19))){
var inst_4182 = (state_4251[(8)]);
var inst_4232 = (state_4251[(11)]);
var inst_4234 = cljs.core.async.muxch_STAR_.call(null,inst_4232);
var state_4251__$1 = state_4251;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4251__$1,(22),inst_4234,inst_4182);
} else {
if((state_val_4252 === (11))){
var inst_4206 = (state_4251[(10)]);
var inst_4192 = (state_4251[(16)]);
var inst_4206__$1 = cljs.core.seq.call(null,inst_4192);
var state_4251__$1 = (function (){var statearr_4275 = state_4251;
(statearr_4275[(10)] = inst_4206__$1);

return statearr_4275;
})();
if(inst_4206__$1){
var statearr_4276_4316 = state_4251__$1;
(statearr_4276_4316[(1)] = (13));

} else {
var statearr_4277_4317 = state_4251__$1;
(statearr_4277_4317[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (9))){
var inst_4228 = (state_4251[(2)]);
var state_4251__$1 = state_4251;
var statearr_4278_4318 = state_4251__$1;
(statearr_4278_4318[(2)] = inst_4228);

(statearr_4278_4318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (5))){
var inst_4189 = cljs.core.deref.call(null,mults);
var inst_4190 = cljs.core.vals.call(null,inst_4189);
var inst_4191 = cljs.core.seq.call(null,inst_4190);
var inst_4192 = inst_4191;
var inst_4193 = null;
var inst_4194 = (0);
var inst_4195 = (0);
var state_4251__$1 = (function (){var statearr_4279 = state_4251;
(statearr_4279[(12)] = inst_4194);

(statearr_4279[(13)] = inst_4193);

(statearr_4279[(14)] = inst_4195);

(statearr_4279[(16)] = inst_4192);

return statearr_4279;
})();
var statearr_4280_4319 = state_4251__$1;
(statearr_4280_4319[(2)] = null);

(statearr_4280_4319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (14))){
var state_4251__$1 = state_4251;
var statearr_4284_4320 = state_4251__$1;
(statearr_4284_4320[(2)] = null);

(statearr_4284_4320[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (16))){
var inst_4206 = (state_4251[(10)]);
var inst_4210 = cljs.core.chunk_first.call(null,inst_4206);
var inst_4211 = cljs.core.chunk_rest.call(null,inst_4206);
var inst_4212 = cljs.core.count.call(null,inst_4210);
var inst_4192 = inst_4211;
var inst_4193 = inst_4210;
var inst_4194 = inst_4212;
var inst_4195 = (0);
var state_4251__$1 = (function (){var statearr_4285 = state_4251;
(statearr_4285[(12)] = inst_4194);

(statearr_4285[(13)] = inst_4193);

(statearr_4285[(14)] = inst_4195);

(statearr_4285[(16)] = inst_4192);

return statearr_4285;
})();
var statearr_4286_4321 = state_4251__$1;
(statearr_4286_4321[(2)] = null);

(statearr_4286_4321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (10))){
var inst_4194 = (state_4251[(12)]);
var inst_4193 = (state_4251[(13)]);
var inst_4195 = (state_4251[(14)]);
var inst_4192 = (state_4251[(16)]);
var inst_4200 = cljs.core._nth.call(null,inst_4193,inst_4195);
var inst_4201 = cljs.core.async.muxch_STAR_.call(null,inst_4200);
var inst_4202 = cljs.core.async.close_BANG_.call(null,inst_4201);
var inst_4203 = (inst_4195 + (1));
var tmp4281 = inst_4194;
var tmp4282 = inst_4193;
var tmp4283 = inst_4192;
var inst_4192__$1 = tmp4283;
var inst_4193__$1 = tmp4282;
var inst_4194__$1 = tmp4281;
var inst_4195__$1 = inst_4203;
var state_4251__$1 = (function (){var statearr_4287 = state_4251;
(statearr_4287[(12)] = inst_4194__$1);

(statearr_4287[(17)] = inst_4202);

(statearr_4287[(13)] = inst_4193__$1);

(statearr_4287[(14)] = inst_4195__$1);

(statearr_4287[(16)] = inst_4192__$1);

return statearr_4287;
})();
var statearr_4288_4322 = state_4251__$1;
(statearr_4288_4322[(2)] = null);

(statearr_4288_4322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (18))){
var inst_4221 = (state_4251[(2)]);
var state_4251__$1 = state_4251;
var statearr_4289_4323 = state_4251__$1;
(statearr_4289_4323[(2)] = inst_4221);

(statearr_4289_4323[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4252 === (8))){
var inst_4194 = (state_4251[(12)]);
var inst_4195 = (state_4251[(14)]);
var inst_4197 = (inst_4195 < inst_4194);
var inst_4198 = inst_4197;
var state_4251__$1 = state_4251;
if(cljs.core.truth_(inst_4198)){
var statearr_4290_4324 = state_4251__$1;
(statearr_4290_4324[(1)] = (10));

} else {
var statearr_4291_4325 = state_4251__$1;
(statearr_4291_4325[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4297,mults,ensure_mult,p))
;
return ((function (switch__2973__auto__,c__3063__auto___4297,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_4292 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4292[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_4292[(1)] = (1));

return statearr_4292;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_4251){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4251);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4293){if((e4293 instanceof Object)){
var ex__2977__auto__ = e4293;
var statearr_4294_4326 = state_4251;
(statearr_4294_4326[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4251);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4293;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4327 = state_4251;
state_4251 = G__4327;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_4251){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_4251);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4297,mults,ensure_mult,p))
})();
var state__3065__auto__ = (function (){var statearr_4295 = f__3064__auto__.call(null);
(statearr_4295[(6)] = c__3063__auto___4297);

return statearr_4295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4297,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__4329 = arguments.length;
switch (G__4329) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__4332 = arguments.length;
switch (G__4332) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__4335 = arguments.length;
switch (G__4335) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__3063__auto___4402 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4402,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4402,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_4374){
var state_val_4375 = (state_4374[(1)]);
if((state_val_4375 === (7))){
var state_4374__$1 = state_4374;
var statearr_4376_4403 = state_4374__$1;
(statearr_4376_4403[(2)] = null);

(statearr_4376_4403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (1))){
var state_4374__$1 = state_4374;
var statearr_4377_4404 = state_4374__$1;
(statearr_4377_4404[(2)] = null);

(statearr_4377_4404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (4))){
var inst_4338 = (state_4374[(7)]);
var inst_4340 = (inst_4338 < cnt);
var state_4374__$1 = state_4374;
if(cljs.core.truth_(inst_4340)){
var statearr_4378_4405 = state_4374__$1;
(statearr_4378_4405[(1)] = (6));

} else {
var statearr_4379_4406 = state_4374__$1;
(statearr_4379_4406[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (15))){
var inst_4370 = (state_4374[(2)]);
var state_4374__$1 = state_4374;
var statearr_4380_4407 = state_4374__$1;
(statearr_4380_4407[(2)] = inst_4370);

(statearr_4380_4407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (13))){
var inst_4363 = cljs.core.async.close_BANG_.call(null,out);
var state_4374__$1 = state_4374;
var statearr_4381_4408 = state_4374__$1;
(statearr_4381_4408[(2)] = inst_4363);

(statearr_4381_4408[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (6))){
var state_4374__$1 = state_4374;
var statearr_4382_4409 = state_4374__$1;
(statearr_4382_4409[(2)] = null);

(statearr_4382_4409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (3))){
var inst_4372 = (state_4374[(2)]);
var state_4374__$1 = state_4374;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4374__$1,inst_4372);
} else {
if((state_val_4375 === (12))){
var inst_4360 = (state_4374[(8)]);
var inst_4360__$1 = (state_4374[(2)]);
var inst_4361 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_4360__$1);
var state_4374__$1 = (function (){var statearr_4383 = state_4374;
(statearr_4383[(8)] = inst_4360__$1);

return statearr_4383;
})();
if(cljs.core.truth_(inst_4361)){
var statearr_4384_4410 = state_4374__$1;
(statearr_4384_4410[(1)] = (13));

} else {
var statearr_4385_4411 = state_4374__$1;
(statearr_4385_4411[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (2))){
var inst_4337 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_4338 = (0);
var state_4374__$1 = (function (){var statearr_4386 = state_4374;
(statearr_4386[(9)] = inst_4337);

(statearr_4386[(7)] = inst_4338);

return statearr_4386;
})();
var statearr_4387_4412 = state_4374__$1;
(statearr_4387_4412[(2)] = null);

(statearr_4387_4412[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (11))){
var inst_4338 = (state_4374[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_4374,(10),Object,null,(9));
var inst_4347 = chs__$1.call(null,inst_4338);
var inst_4348 = done.call(null,inst_4338);
var inst_4349 = cljs.core.async.take_BANG_.call(null,inst_4347,inst_4348);
var state_4374__$1 = state_4374;
var statearr_4388_4413 = state_4374__$1;
(statearr_4388_4413[(2)] = inst_4349);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4374__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (9))){
var inst_4338 = (state_4374[(7)]);
var inst_4351 = (state_4374[(2)]);
var inst_4352 = (inst_4338 + (1));
var inst_4338__$1 = inst_4352;
var state_4374__$1 = (function (){var statearr_4389 = state_4374;
(statearr_4389[(10)] = inst_4351);

(statearr_4389[(7)] = inst_4338__$1);

return statearr_4389;
})();
var statearr_4390_4414 = state_4374__$1;
(statearr_4390_4414[(2)] = null);

(statearr_4390_4414[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (5))){
var inst_4358 = (state_4374[(2)]);
var state_4374__$1 = (function (){var statearr_4391 = state_4374;
(statearr_4391[(11)] = inst_4358);

return statearr_4391;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4374__$1,(12),dchan);
} else {
if((state_val_4375 === (14))){
var inst_4360 = (state_4374[(8)]);
var inst_4365 = cljs.core.apply.call(null,f,inst_4360);
var state_4374__$1 = state_4374;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4374__$1,(16),out,inst_4365);
} else {
if((state_val_4375 === (16))){
var inst_4367 = (state_4374[(2)]);
var state_4374__$1 = (function (){var statearr_4392 = state_4374;
(statearr_4392[(12)] = inst_4367);

return statearr_4392;
})();
var statearr_4393_4415 = state_4374__$1;
(statearr_4393_4415[(2)] = null);

(statearr_4393_4415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (10))){
var inst_4342 = (state_4374[(2)]);
var inst_4343 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_4374__$1 = (function (){var statearr_4394 = state_4374;
(statearr_4394[(13)] = inst_4342);

return statearr_4394;
})();
var statearr_4395_4416 = state_4374__$1;
(statearr_4395_4416[(2)] = inst_4343);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4374__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4375 === (8))){
var inst_4356 = (state_4374[(2)]);
var state_4374__$1 = state_4374;
var statearr_4396_4417 = state_4374__$1;
(statearr_4396_4417[(2)] = inst_4356);

(statearr_4396_4417[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4402,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__2973__auto__,c__3063__auto___4402,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_4397 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4397[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_4397[(1)] = (1));

return statearr_4397;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_4374){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4374);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4398){if((e4398 instanceof Object)){
var ex__2977__auto__ = e4398;
var statearr_4399_4418 = state_4374;
(statearr_4399_4418[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4374);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4398;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4419 = state_4374;
state_4374 = G__4419;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_4374){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_4374);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4402,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__3065__auto__ = (function (){var statearr_4400 = f__3064__auto__.call(null);
(statearr_4400[(6)] = c__3063__auto___4402);

return statearr_4400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4402,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__4422 = arguments.length;
switch (G__4422) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3063__auto___4476 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4476,out){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4476,out){
return (function (state_4454){
var state_val_4455 = (state_4454[(1)]);
if((state_val_4455 === (7))){
var inst_4434 = (state_4454[(7)]);
var inst_4433 = (state_4454[(8)]);
var inst_4433__$1 = (state_4454[(2)]);
var inst_4434__$1 = cljs.core.nth.call(null,inst_4433__$1,(0),null);
var inst_4435 = cljs.core.nth.call(null,inst_4433__$1,(1),null);
var inst_4436 = (inst_4434__$1 == null);
var state_4454__$1 = (function (){var statearr_4456 = state_4454;
(statearr_4456[(7)] = inst_4434__$1);

(statearr_4456[(9)] = inst_4435);

(statearr_4456[(8)] = inst_4433__$1);

return statearr_4456;
})();
if(cljs.core.truth_(inst_4436)){
var statearr_4457_4477 = state_4454__$1;
(statearr_4457_4477[(1)] = (8));

} else {
var statearr_4458_4478 = state_4454__$1;
(statearr_4458_4478[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4455 === (1))){
var inst_4423 = cljs.core.vec.call(null,chs);
var inst_4424 = inst_4423;
var state_4454__$1 = (function (){var statearr_4459 = state_4454;
(statearr_4459[(10)] = inst_4424);

return statearr_4459;
})();
var statearr_4460_4479 = state_4454__$1;
(statearr_4460_4479[(2)] = null);

(statearr_4460_4479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4455 === (4))){
var inst_4424 = (state_4454[(10)]);
var state_4454__$1 = state_4454;
return cljs.core.async.ioc_alts_BANG_.call(null,state_4454__$1,(7),inst_4424);
} else {
if((state_val_4455 === (6))){
var inst_4450 = (state_4454[(2)]);
var state_4454__$1 = state_4454;
var statearr_4461_4480 = state_4454__$1;
(statearr_4461_4480[(2)] = inst_4450);

(statearr_4461_4480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4455 === (3))){
var inst_4452 = (state_4454[(2)]);
var state_4454__$1 = state_4454;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4454__$1,inst_4452);
} else {
if((state_val_4455 === (2))){
var inst_4424 = (state_4454[(10)]);
var inst_4426 = cljs.core.count.call(null,inst_4424);
var inst_4427 = (inst_4426 > (0));
var state_4454__$1 = state_4454;
if(cljs.core.truth_(inst_4427)){
var statearr_4463_4481 = state_4454__$1;
(statearr_4463_4481[(1)] = (4));

} else {
var statearr_4464_4482 = state_4454__$1;
(statearr_4464_4482[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4455 === (11))){
var inst_4424 = (state_4454[(10)]);
var inst_4443 = (state_4454[(2)]);
var tmp4462 = inst_4424;
var inst_4424__$1 = tmp4462;
var state_4454__$1 = (function (){var statearr_4465 = state_4454;
(statearr_4465[(11)] = inst_4443);

(statearr_4465[(10)] = inst_4424__$1);

return statearr_4465;
})();
var statearr_4466_4483 = state_4454__$1;
(statearr_4466_4483[(2)] = null);

(statearr_4466_4483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4455 === (9))){
var inst_4434 = (state_4454[(7)]);
var state_4454__$1 = state_4454;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4454__$1,(11),out,inst_4434);
} else {
if((state_val_4455 === (5))){
var inst_4448 = cljs.core.async.close_BANG_.call(null,out);
var state_4454__$1 = state_4454;
var statearr_4467_4484 = state_4454__$1;
(statearr_4467_4484[(2)] = inst_4448);

(statearr_4467_4484[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4455 === (10))){
var inst_4446 = (state_4454[(2)]);
var state_4454__$1 = state_4454;
var statearr_4468_4485 = state_4454__$1;
(statearr_4468_4485[(2)] = inst_4446);

(statearr_4468_4485[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4455 === (8))){
var inst_4434 = (state_4454[(7)]);
var inst_4435 = (state_4454[(9)]);
var inst_4424 = (state_4454[(10)]);
var inst_4433 = (state_4454[(8)]);
var inst_4438 = (function (){var cs = inst_4424;
var vec__4429 = inst_4433;
var v = inst_4434;
var c = inst_4435;
return ((function (cs,vec__4429,v,c,inst_4434,inst_4435,inst_4424,inst_4433,state_val_4455,c__3063__auto___4476,out){
return (function (p1__4420_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__4420_SHARP_);
});
;})(cs,vec__4429,v,c,inst_4434,inst_4435,inst_4424,inst_4433,state_val_4455,c__3063__auto___4476,out))
})();
var inst_4439 = cljs.core.filterv.call(null,inst_4438,inst_4424);
var inst_4424__$1 = inst_4439;
var state_4454__$1 = (function (){var statearr_4469 = state_4454;
(statearr_4469[(10)] = inst_4424__$1);

return statearr_4469;
})();
var statearr_4470_4486 = state_4454__$1;
(statearr_4470_4486[(2)] = null);

(statearr_4470_4486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4476,out))
;
return ((function (switch__2973__auto__,c__3063__auto___4476,out){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_4471 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4471[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_4471[(1)] = (1));

return statearr_4471;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_4454){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4454);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4472){if((e4472 instanceof Object)){
var ex__2977__auto__ = e4472;
var statearr_4473_4487 = state_4454;
(statearr_4473_4487[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4472;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4488 = state_4454;
state_4454 = G__4488;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_4454){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_4454);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4476,out))
})();
var state__3065__auto__ = (function (){var statearr_4474 = f__3064__auto__.call(null);
(statearr_4474[(6)] = c__3063__auto___4476);

return statearr_4474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4476,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__4490 = arguments.length;
switch (G__4490) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3063__auto___4535 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4535,out){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4535,out){
return (function (state_4514){
var state_val_4515 = (state_4514[(1)]);
if((state_val_4515 === (7))){
var inst_4496 = (state_4514[(7)]);
var inst_4496__$1 = (state_4514[(2)]);
var inst_4497 = (inst_4496__$1 == null);
var inst_4498 = cljs.core.not.call(null,inst_4497);
var state_4514__$1 = (function (){var statearr_4516 = state_4514;
(statearr_4516[(7)] = inst_4496__$1);

return statearr_4516;
})();
if(inst_4498){
var statearr_4517_4536 = state_4514__$1;
(statearr_4517_4536[(1)] = (8));

} else {
var statearr_4518_4537 = state_4514__$1;
(statearr_4518_4537[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4515 === (1))){
var inst_4491 = (0);
var state_4514__$1 = (function (){var statearr_4519 = state_4514;
(statearr_4519[(8)] = inst_4491);

return statearr_4519;
})();
var statearr_4520_4538 = state_4514__$1;
(statearr_4520_4538[(2)] = null);

(statearr_4520_4538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4515 === (4))){
var state_4514__$1 = state_4514;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4514__$1,(7),ch);
} else {
if((state_val_4515 === (6))){
var inst_4509 = (state_4514[(2)]);
var state_4514__$1 = state_4514;
var statearr_4521_4539 = state_4514__$1;
(statearr_4521_4539[(2)] = inst_4509);

(statearr_4521_4539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4515 === (3))){
var inst_4511 = (state_4514[(2)]);
var inst_4512 = cljs.core.async.close_BANG_.call(null,out);
var state_4514__$1 = (function (){var statearr_4522 = state_4514;
(statearr_4522[(9)] = inst_4511);

return statearr_4522;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4514__$1,inst_4512);
} else {
if((state_val_4515 === (2))){
var inst_4491 = (state_4514[(8)]);
var inst_4493 = (inst_4491 < n);
var state_4514__$1 = state_4514;
if(cljs.core.truth_(inst_4493)){
var statearr_4523_4540 = state_4514__$1;
(statearr_4523_4540[(1)] = (4));

} else {
var statearr_4524_4541 = state_4514__$1;
(statearr_4524_4541[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4515 === (11))){
var inst_4491 = (state_4514[(8)]);
var inst_4501 = (state_4514[(2)]);
var inst_4502 = (inst_4491 + (1));
var inst_4491__$1 = inst_4502;
var state_4514__$1 = (function (){var statearr_4525 = state_4514;
(statearr_4525[(8)] = inst_4491__$1);

(statearr_4525[(10)] = inst_4501);

return statearr_4525;
})();
var statearr_4526_4542 = state_4514__$1;
(statearr_4526_4542[(2)] = null);

(statearr_4526_4542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4515 === (9))){
var state_4514__$1 = state_4514;
var statearr_4527_4543 = state_4514__$1;
(statearr_4527_4543[(2)] = null);

(statearr_4527_4543[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4515 === (5))){
var state_4514__$1 = state_4514;
var statearr_4528_4544 = state_4514__$1;
(statearr_4528_4544[(2)] = null);

(statearr_4528_4544[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4515 === (10))){
var inst_4506 = (state_4514[(2)]);
var state_4514__$1 = state_4514;
var statearr_4529_4545 = state_4514__$1;
(statearr_4529_4545[(2)] = inst_4506);

(statearr_4529_4545[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4515 === (8))){
var inst_4496 = (state_4514[(7)]);
var state_4514__$1 = state_4514;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4514__$1,(11),out,inst_4496);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4535,out))
;
return ((function (switch__2973__auto__,c__3063__auto___4535,out){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_4530 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_4530[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_4530[(1)] = (1));

return statearr_4530;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_4514){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4514);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4531){if((e4531 instanceof Object)){
var ex__2977__auto__ = e4531;
var statearr_4532_4546 = state_4514;
(statearr_4532_4546[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4514);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4531;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4547 = state_4514;
state_4514 = G__4547;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_4514){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_4514);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4535,out))
})();
var state__3065__auto__ = (function (){var statearr_4533 = f__3064__auto__.call(null);
(statearr_4533[(6)] = c__3063__auto___4535);

return statearr_4533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4535,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async4549 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4549 = (function (f,ch,meta4550){
this.f = f;
this.ch = ch;
this.meta4550 = meta4550;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4551,meta4550__$1){
var self__ = this;
var _4551__$1 = this;
return (new cljs.core.async.t_cljs$core$async4549(self__.f,self__.ch,meta4550__$1));
});

cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4551){
var self__ = this;
var _4551__$1 = this;
return self__.meta4550;
});

cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async4552 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4552 = (function (f,ch,meta4550,_,fn1,meta4553){
this.f = f;
this.ch = ch;
this.meta4550 = meta4550;
this._ = _;
this.fn1 = fn1;
this.meta4553 = meta4553;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4552.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_4554,meta4553__$1){
var self__ = this;
var _4554__$1 = this;
return (new cljs.core.async.t_cljs$core$async4552(self__.f,self__.ch,self__.meta4550,self__._,self__.fn1,meta4553__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async4552.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_4554){
var self__ = this;
var _4554__$1 = this;
return self__.meta4553;
});})(___$1))
;

cljs.core.async.t_cljs$core$async4552.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4552.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async4552.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async4552.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__4548_SHARP_){
return f1.call(null,(((p1__4548_SHARP_ == null))?null:self__.f.call(null,p1__4548_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async4552.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4550","meta4550",-1441296034,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async4549","cljs.core.async/t_cljs$core$async4549",208881511,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta4553","meta4553",1313502136,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async4552.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4552.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4552";

cljs.core.async.t_cljs$core$async4552.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async4552");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4552.
 */
cljs.core.async.__GT_t_cljs$core$async4552 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async4552(f__$1,ch__$1,meta4550__$1,___$2,fn1__$1,meta4553){
return (new cljs.core.async.t_cljs$core$async4552(f__$1,ch__$1,meta4550__$1,___$2,fn1__$1,meta4553));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async4552(self__.f,self__.ch,self__.meta4550,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3910__auto__ = ret;
if(cljs.core.truth_(and__3910__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3910__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4549.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async4549.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4550","meta4550",-1441296034,null)], null);
});

cljs.core.async.t_cljs$core$async4549.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4549.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4549";

cljs.core.async.t_cljs$core$async4549.cljs$lang$ctorPrWriter = (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async4549");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4549.
 */
cljs.core.async.__GT_t_cljs$core$async4549 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async4549(f__$1,ch__$1,meta4550){
return (new cljs.core.async.t_cljs$core$async4549(f__$1,ch__$1,meta4550));
});

}

return (new cljs.core.async.t_cljs$core$async4549(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async4555 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4555 = (function (f,ch,meta4556){
this.f = f;
this.ch = ch;
this.meta4556 = meta4556;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4555.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4557,meta4556__$1){
var self__ = this;
var _4557__$1 = this;
return (new cljs.core.async.t_cljs$core$async4555(self__.f,self__.ch,meta4556__$1));
});

cljs.core.async.t_cljs$core$async4555.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4557){
var self__ = this;
var _4557__$1 = this;
return self__.meta4556;
});

cljs.core.async.t_cljs$core$async4555.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4555.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async4555.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4555.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async4555.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4555.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async4555.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4556","meta4556",-1851749141,null)], null);
});

cljs.core.async.t_cljs$core$async4555.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4555.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4555";

cljs.core.async.t_cljs$core$async4555.cljs$lang$ctorPrWriter = (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async4555");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4555.
 */
cljs.core.async.__GT_t_cljs$core$async4555 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async4555(f__$1,ch__$1,meta4556){
return (new cljs.core.async.t_cljs$core$async4555(f__$1,ch__$1,meta4556));
});

}

return (new cljs.core.async.t_cljs$core$async4555(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async4558 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4558 = (function (p,ch,meta4559){
this.p = p;
this.ch = ch;
this.meta4559 = meta4559;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4560,meta4559__$1){
var self__ = this;
var _4560__$1 = this;
return (new cljs.core.async.t_cljs$core$async4558(self__.p,self__.ch,meta4559__$1));
});

cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4560){
var self__ = this;
var _4560__$1 = this;
return self__.meta4559;
});

cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4558.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async4558.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4559","meta4559",169409017,null)], null);
});

cljs.core.async.t_cljs$core$async4558.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4558.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4558";

cljs.core.async.t_cljs$core$async4558.cljs$lang$ctorPrWriter = (function (this__4160__auto__,writer__4161__auto__,opt__4162__auto__){
return cljs.core._write.call(null,writer__4161__auto__,"cljs.core.async/t_cljs$core$async4558");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4558.
 */
cljs.core.async.__GT_t_cljs$core$async4558 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async4558(p__$1,ch__$1,meta4559){
return (new cljs.core.async.t_cljs$core$async4558(p__$1,ch__$1,meta4559));
});

}

return (new cljs.core.async.t_cljs$core$async4558(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__4562 = arguments.length;
switch (G__4562) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3063__auto___4602 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4602,out){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4602,out){
return (function (state_4583){
var state_val_4584 = (state_4583[(1)]);
if((state_val_4584 === (7))){
var inst_4579 = (state_4583[(2)]);
var state_4583__$1 = state_4583;
var statearr_4585_4603 = state_4583__$1;
(statearr_4585_4603[(2)] = inst_4579);

(statearr_4585_4603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4584 === (1))){
var state_4583__$1 = state_4583;
var statearr_4586_4604 = state_4583__$1;
(statearr_4586_4604[(2)] = null);

(statearr_4586_4604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4584 === (4))){
var inst_4565 = (state_4583[(7)]);
var inst_4565__$1 = (state_4583[(2)]);
var inst_4566 = (inst_4565__$1 == null);
var state_4583__$1 = (function (){var statearr_4587 = state_4583;
(statearr_4587[(7)] = inst_4565__$1);

return statearr_4587;
})();
if(cljs.core.truth_(inst_4566)){
var statearr_4588_4605 = state_4583__$1;
(statearr_4588_4605[(1)] = (5));

} else {
var statearr_4589_4606 = state_4583__$1;
(statearr_4589_4606[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4584 === (6))){
var inst_4565 = (state_4583[(7)]);
var inst_4570 = p.call(null,inst_4565);
var state_4583__$1 = state_4583;
if(cljs.core.truth_(inst_4570)){
var statearr_4590_4607 = state_4583__$1;
(statearr_4590_4607[(1)] = (8));

} else {
var statearr_4591_4608 = state_4583__$1;
(statearr_4591_4608[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4584 === (3))){
var inst_4581 = (state_4583[(2)]);
var state_4583__$1 = state_4583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4583__$1,inst_4581);
} else {
if((state_val_4584 === (2))){
var state_4583__$1 = state_4583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4583__$1,(4),ch);
} else {
if((state_val_4584 === (11))){
var inst_4573 = (state_4583[(2)]);
var state_4583__$1 = state_4583;
var statearr_4592_4609 = state_4583__$1;
(statearr_4592_4609[(2)] = inst_4573);

(statearr_4592_4609[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4584 === (9))){
var state_4583__$1 = state_4583;
var statearr_4593_4610 = state_4583__$1;
(statearr_4593_4610[(2)] = null);

(statearr_4593_4610[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4584 === (5))){
var inst_4568 = cljs.core.async.close_BANG_.call(null,out);
var state_4583__$1 = state_4583;
var statearr_4594_4611 = state_4583__$1;
(statearr_4594_4611[(2)] = inst_4568);

(statearr_4594_4611[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4584 === (10))){
var inst_4576 = (state_4583[(2)]);
var state_4583__$1 = (function (){var statearr_4595 = state_4583;
(statearr_4595[(8)] = inst_4576);

return statearr_4595;
})();
var statearr_4596_4612 = state_4583__$1;
(statearr_4596_4612[(2)] = null);

(statearr_4596_4612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4584 === (8))){
var inst_4565 = (state_4583[(7)]);
var state_4583__$1 = state_4583;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4583__$1,(11),out,inst_4565);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4602,out))
;
return ((function (switch__2973__auto__,c__3063__auto___4602,out){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_4597 = [null,null,null,null,null,null,null,null,null];
(statearr_4597[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_4597[(1)] = (1));

return statearr_4597;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_4583){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4598){if((e4598 instanceof Object)){
var ex__2977__auto__ = e4598;
var statearr_4599_4613 = state_4583;
(statearr_4599_4613[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4583);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4598;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4614 = state_4583;
state_4583 = G__4614;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_4583){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_4583);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4602,out))
})();
var state__3065__auto__ = (function (){var statearr_4600 = f__3064__auto__.call(null);
(statearr_4600[(6)] = c__3063__auto___4602);

return statearr_4600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4602,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__4616 = arguments.length;
switch (G__4616) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__3063__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto__){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto__){
return (function (state_4679){
var state_val_4680 = (state_4679[(1)]);
if((state_val_4680 === (7))){
var inst_4675 = (state_4679[(2)]);
var state_4679__$1 = state_4679;
var statearr_4681_4719 = state_4679__$1;
(statearr_4681_4719[(2)] = inst_4675);

(statearr_4681_4719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (20))){
var inst_4645 = (state_4679[(7)]);
var inst_4656 = (state_4679[(2)]);
var inst_4657 = cljs.core.next.call(null,inst_4645);
var inst_4631 = inst_4657;
var inst_4632 = null;
var inst_4633 = (0);
var inst_4634 = (0);
var state_4679__$1 = (function (){var statearr_4682 = state_4679;
(statearr_4682[(8)] = inst_4632);

(statearr_4682[(9)] = inst_4631);

(statearr_4682[(10)] = inst_4656);

(statearr_4682[(11)] = inst_4634);

(statearr_4682[(12)] = inst_4633);

return statearr_4682;
})();
var statearr_4683_4720 = state_4679__$1;
(statearr_4683_4720[(2)] = null);

(statearr_4683_4720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (1))){
var state_4679__$1 = state_4679;
var statearr_4684_4721 = state_4679__$1;
(statearr_4684_4721[(2)] = null);

(statearr_4684_4721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (4))){
var inst_4620 = (state_4679[(13)]);
var inst_4620__$1 = (state_4679[(2)]);
var inst_4621 = (inst_4620__$1 == null);
var state_4679__$1 = (function (){var statearr_4685 = state_4679;
(statearr_4685[(13)] = inst_4620__$1);

return statearr_4685;
})();
if(cljs.core.truth_(inst_4621)){
var statearr_4686_4722 = state_4679__$1;
(statearr_4686_4722[(1)] = (5));

} else {
var statearr_4687_4723 = state_4679__$1;
(statearr_4687_4723[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (15))){
var state_4679__$1 = state_4679;
var statearr_4691_4724 = state_4679__$1;
(statearr_4691_4724[(2)] = null);

(statearr_4691_4724[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (21))){
var state_4679__$1 = state_4679;
var statearr_4692_4725 = state_4679__$1;
(statearr_4692_4725[(2)] = null);

(statearr_4692_4725[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (13))){
var inst_4632 = (state_4679[(8)]);
var inst_4631 = (state_4679[(9)]);
var inst_4634 = (state_4679[(11)]);
var inst_4633 = (state_4679[(12)]);
var inst_4641 = (state_4679[(2)]);
var inst_4642 = (inst_4634 + (1));
var tmp4688 = inst_4632;
var tmp4689 = inst_4631;
var tmp4690 = inst_4633;
var inst_4631__$1 = tmp4689;
var inst_4632__$1 = tmp4688;
var inst_4633__$1 = tmp4690;
var inst_4634__$1 = inst_4642;
var state_4679__$1 = (function (){var statearr_4693 = state_4679;
(statearr_4693[(8)] = inst_4632__$1);

(statearr_4693[(14)] = inst_4641);

(statearr_4693[(9)] = inst_4631__$1);

(statearr_4693[(11)] = inst_4634__$1);

(statearr_4693[(12)] = inst_4633__$1);

return statearr_4693;
})();
var statearr_4694_4726 = state_4679__$1;
(statearr_4694_4726[(2)] = null);

(statearr_4694_4726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (22))){
var state_4679__$1 = state_4679;
var statearr_4695_4727 = state_4679__$1;
(statearr_4695_4727[(2)] = null);

(statearr_4695_4727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (6))){
var inst_4620 = (state_4679[(13)]);
var inst_4629 = f.call(null,inst_4620);
var inst_4630 = cljs.core.seq.call(null,inst_4629);
var inst_4631 = inst_4630;
var inst_4632 = null;
var inst_4633 = (0);
var inst_4634 = (0);
var state_4679__$1 = (function (){var statearr_4696 = state_4679;
(statearr_4696[(8)] = inst_4632);

(statearr_4696[(9)] = inst_4631);

(statearr_4696[(11)] = inst_4634);

(statearr_4696[(12)] = inst_4633);

return statearr_4696;
})();
var statearr_4697_4728 = state_4679__$1;
(statearr_4697_4728[(2)] = null);

(statearr_4697_4728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (17))){
var inst_4645 = (state_4679[(7)]);
var inst_4649 = cljs.core.chunk_first.call(null,inst_4645);
var inst_4650 = cljs.core.chunk_rest.call(null,inst_4645);
var inst_4651 = cljs.core.count.call(null,inst_4649);
var inst_4631 = inst_4650;
var inst_4632 = inst_4649;
var inst_4633 = inst_4651;
var inst_4634 = (0);
var state_4679__$1 = (function (){var statearr_4698 = state_4679;
(statearr_4698[(8)] = inst_4632);

(statearr_4698[(9)] = inst_4631);

(statearr_4698[(11)] = inst_4634);

(statearr_4698[(12)] = inst_4633);

return statearr_4698;
})();
var statearr_4699_4729 = state_4679__$1;
(statearr_4699_4729[(2)] = null);

(statearr_4699_4729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (3))){
var inst_4677 = (state_4679[(2)]);
var state_4679__$1 = state_4679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4679__$1,inst_4677);
} else {
if((state_val_4680 === (12))){
var inst_4665 = (state_4679[(2)]);
var state_4679__$1 = state_4679;
var statearr_4700_4730 = state_4679__$1;
(statearr_4700_4730[(2)] = inst_4665);

(statearr_4700_4730[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (2))){
var state_4679__$1 = state_4679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4679__$1,(4),in$);
} else {
if((state_val_4680 === (23))){
var inst_4673 = (state_4679[(2)]);
var state_4679__$1 = state_4679;
var statearr_4701_4731 = state_4679__$1;
(statearr_4701_4731[(2)] = inst_4673);

(statearr_4701_4731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (19))){
var inst_4660 = (state_4679[(2)]);
var state_4679__$1 = state_4679;
var statearr_4702_4732 = state_4679__$1;
(statearr_4702_4732[(2)] = inst_4660);

(statearr_4702_4732[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (11))){
var inst_4631 = (state_4679[(9)]);
var inst_4645 = (state_4679[(7)]);
var inst_4645__$1 = cljs.core.seq.call(null,inst_4631);
var state_4679__$1 = (function (){var statearr_4703 = state_4679;
(statearr_4703[(7)] = inst_4645__$1);

return statearr_4703;
})();
if(inst_4645__$1){
var statearr_4704_4733 = state_4679__$1;
(statearr_4704_4733[(1)] = (14));

} else {
var statearr_4705_4734 = state_4679__$1;
(statearr_4705_4734[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (9))){
var inst_4667 = (state_4679[(2)]);
var inst_4668 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_4679__$1 = (function (){var statearr_4706 = state_4679;
(statearr_4706[(15)] = inst_4667);

return statearr_4706;
})();
if(cljs.core.truth_(inst_4668)){
var statearr_4707_4735 = state_4679__$1;
(statearr_4707_4735[(1)] = (21));

} else {
var statearr_4708_4736 = state_4679__$1;
(statearr_4708_4736[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (5))){
var inst_4623 = cljs.core.async.close_BANG_.call(null,out);
var state_4679__$1 = state_4679;
var statearr_4709_4737 = state_4679__$1;
(statearr_4709_4737[(2)] = inst_4623);

(statearr_4709_4737[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (14))){
var inst_4645 = (state_4679[(7)]);
var inst_4647 = cljs.core.chunked_seq_QMARK_.call(null,inst_4645);
var state_4679__$1 = state_4679;
if(inst_4647){
var statearr_4710_4738 = state_4679__$1;
(statearr_4710_4738[(1)] = (17));

} else {
var statearr_4711_4739 = state_4679__$1;
(statearr_4711_4739[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (16))){
var inst_4663 = (state_4679[(2)]);
var state_4679__$1 = state_4679;
var statearr_4712_4740 = state_4679__$1;
(statearr_4712_4740[(2)] = inst_4663);

(statearr_4712_4740[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4680 === (10))){
var inst_4632 = (state_4679[(8)]);
var inst_4634 = (state_4679[(11)]);
var inst_4639 = cljs.core._nth.call(null,inst_4632,inst_4634);
var state_4679__$1 = state_4679;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4679__$1,(13),out,inst_4639);
} else {
if((state_val_4680 === (18))){
var inst_4645 = (state_4679[(7)]);
var inst_4654 = cljs.core.first.call(null,inst_4645);
var state_4679__$1 = state_4679;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4679__$1,(20),out,inst_4654);
} else {
if((state_val_4680 === (8))){
var inst_4634 = (state_4679[(11)]);
var inst_4633 = (state_4679[(12)]);
var inst_4636 = (inst_4634 < inst_4633);
var inst_4637 = inst_4636;
var state_4679__$1 = state_4679;
if(cljs.core.truth_(inst_4637)){
var statearr_4713_4741 = state_4679__$1;
(statearr_4713_4741[(1)] = (10));

} else {
var statearr_4714_4742 = state_4679__$1;
(statearr_4714_4742[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto__))
;
return ((function (switch__2973__auto__,c__3063__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__2974__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__2974__auto____0 = (function (){
var statearr_4715 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4715[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__2974__auto__);

(statearr_4715[(1)] = (1));

return statearr_4715;
});
var cljs$core$async$mapcat_STAR__$_state_machine__2974__auto____1 = (function (state_4679){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4716){if((e4716 instanceof Object)){
var ex__2977__auto__ = e4716;
var statearr_4717_4743 = state_4679;
(statearr_4717_4743[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4679);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4716;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4744 = state_4679;
state_4679 = G__4744;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__2974__auto__ = function(state_4679){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__2974__auto____1.call(this,state_4679);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__2974__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__2974__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto__))
})();
var state__3065__auto__ = (function (){var statearr_4718 = f__3064__auto__.call(null);
(statearr_4718[(6)] = c__3063__auto__);

return statearr_4718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto__))
);

return c__3063__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__4746 = arguments.length;
switch (G__4746) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__4749 = arguments.length;
switch (G__4749) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__4752 = arguments.length;
switch (G__4752) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3063__auto___4799 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4799,out){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4799,out){
return (function (state_4776){
var state_val_4777 = (state_4776[(1)]);
if((state_val_4777 === (7))){
var inst_4771 = (state_4776[(2)]);
var state_4776__$1 = state_4776;
var statearr_4778_4800 = state_4776__$1;
(statearr_4778_4800[(2)] = inst_4771);

(statearr_4778_4800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4777 === (1))){
var inst_4753 = null;
var state_4776__$1 = (function (){var statearr_4779 = state_4776;
(statearr_4779[(7)] = inst_4753);

return statearr_4779;
})();
var statearr_4780_4801 = state_4776__$1;
(statearr_4780_4801[(2)] = null);

(statearr_4780_4801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4777 === (4))){
var inst_4756 = (state_4776[(8)]);
var inst_4756__$1 = (state_4776[(2)]);
var inst_4757 = (inst_4756__$1 == null);
var inst_4758 = cljs.core.not.call(null,inst_4757);
var state_4776__$1 = (function (){var statearr_4781 = state_4776;
(statearr_4781[(8)] = inst_4756__$1);

return statearr_4781;
})();
if(inst_4758){
var statearr_4782_4802 = state_4776__$1;
(statearr_4782_4802[(1)] = (5));

} else {
var statearr_4783_4803 = state_4776__$1;
(statearr_4783_4803[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4777 === (6))){
var state_4776__$1 = state_4776;
var statearr_4784_4804 = state_4776__$1;
(statearr_4784_4804[(2)] = null);

(statearr_4784_4804[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4777 === (3))){
var inst_4773 = (state_4776[(2)]);
var inst_4774 = cljs.core.async.close_BANG_.call(null,out);
var state_4776__$1 = (function (){var statearr_4785 = state_4776;
(statearr_4785[(9)] = inst_4773);

return statearr_4785;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4776__$1,inst_4774);
} else {
if((state_val_4777 === (2))){
var state_4776__$1 = state_4776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4776__$1,(4),ch);
} else {
if((state_val_4777 === (11))){
var inst_4756 = (state_4776[(8)]);
var inst_4765 = (state_4776[(2)]);
var inst_4753 = inst_4756;
var state_4776__$1 = (function (){var statearr_4786 = state_4776;
(statearr_4786[(10)] = inst_4765);

(statearr_4786[(7)] = inst_4753);

return statearr_4786;
})();
var statearr_4787_4805 = state_4776__$1;
(statearr_4787_4805[(2)] = null);

(statearr_4787_4805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4777 === (9))){
var inst_4756 = (state_4776[(8)]);
var state_4776__$1 = state_4776;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4776__$1,(11),out,inst_4756);
} else {
if((state_val_4777 === (5))){
var inst_4756 = (state_4776[(8)]);
var inst_4753 = (state_4776[(7)]);
var inst_4760 = cljs.core._EQ_.call(null,inst_4756,inst_4753);
var state_4776__$1 = state_4776;
if(inst_4760){
var statearr_4789_4806 = state_4776__$1;
(statearr_4789_4806[(1)] = (8));

} else {
var statearr_4790_4807 = state_4776__$1;
(statearr_4790_4807[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4777 === (10))){
var inst_4768 = (state_4776[(2)]);
var state_4776__$1 = state_4776;
var statearr_4791_4808 = state_4776__$1;
(statearr_4791_4808[(2)] = inst_4768);

(statearr_4791_4808[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4777 === (8))){
var inst_4753 = (state_4776[(7)]);
var tmp4788 = inst_4753;
var inst_4753__$1 = tmp4788;
var state_4776__$1 = (function (){var statearr_4792 = state_4776;
(statearr_4792[(7)] = inst_4753__$1);

return statearr_4792;
})();
var statearr_4793_4809 = state_4776__$1;
(statearr_4793_4809[(2)] = null);

(statearr_4793_4809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4799,out))
;
return ((function (switch__2973__auto__,c__3063__auto___4799,out){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_4794 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_4794[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_4794[(1)] = (1));

return statearr_4794;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_4776){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4795){if((e4795 instanceof Object)){
var ex__2977__auto__ = e4795;
var statearr_4796_4810 = state_4776;
(statearr_4796_4810[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4776);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4795;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4811 = state_4776;
state_4776 = G__4811;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_4776){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_4776);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4799,out))
})();
var state__3065__auto__ = (function (){var statearr_4797 = f__3064__auto__.call(null);
(statearr_4797[(6)] = c__3063__auto___4799);

return statearr_4797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4799,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__4813 = arguments.length;
switch (G__4813) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3063__auto___4879 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4879,out){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4879,out){
return (function (state_4851){
var state_val_4852 = (state_4851[(1)]);
if((state_val_4852 === (7))){
var inst_4847 = (state_4851[(2)]);
var state_4851__$1 = state_4851;
var statearr_4853_4880 = state_4851__$1;
(statearr_4853_4880[(2)] = inst_4847);

(statearr_4853_4880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (1))){
var inst_4814 = (new Array(n));
var inst_4815 = inst_4814;
var inst_4816 = (0);
var state_4851__$1 = (function (){var statearr_4854 = state_4851;
(statearr_4854[(7)] = inst_4815);

(statearr_4854[(8)] = inst_4816);

return statearr_4854;
})();
var statearr_4855_4881 = state_4851__$1;
(statearr_4855_4881[(2)] = null);

(statearr_4855_4881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (4))){
var inst_4819 = (state_4851[(9)]);
var inst_4819__$1 = (state_4851[(2)]);
var inst_4820 = (inst_4819__$1 == null);
var inst_4821 = cljs.core.not.call(null,inst_4820);
var state_4851__$1 = (function (){var statearr_4856 = state_4851;
(statearr_4856[(9)] = inst_4819__$1);

return statearr_4856;
})();
if(inst_4821){
var statearr_4857_4882 = state_4851__$1;
(statearr_4857_4882[(1)] = (5));

} else {
var statearr_4858_4883 = state_4851__$1;
(statearr_4858_4883[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (15))){
var inst_4841 = (state_4851[(2)]);
var state_4851__$1 = state_4851;
var statearr_4859_4884 = state_4851__$1;
(statearr_4859_4884[(2)] = inst_4841);

(statearr_4859_4884[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (13))){
var state_4851__$1 = state_4851;
var statearr_4860_4885 = state_4851__$1;
(statearr_4860_4885[(2)] = null);

(statearr_4860_4885[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (6))){
var inst_4816 = (state_4851[(8)]);
var inst_4837 = (inst_4816 > (0));
var state_4851__$1 = state_4851;
if(cljs.core.truth_(inst_4837)){
var statearr_4861_4886 = state_4851__$1;
(statearr_4861_4886[(1)] = (12));

} else {
var statearr_4862_4887 = state_4851__$1;
(statearr_4862_4887[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (3))){
var inst_4849 = (state_4851[(2)]);
var state_4851__$1 = state_4851;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4851__$1,inst_4849);
} else {
if((state_val_4852 === (12))){
var inst_4815 = (state_4851[(7)]);
var inst_4839 = cljs.core.vec.call(null,inst_4815);
var state_4851__$1 = state_4851;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4851__$1,(15),out,inst_4839);
} else {
if((state_val_4852 === (2))){
var state_4851__$1 = state_4851;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4851__$1,(4),ch);
} else {
if((state_val_4852 === (11))){
var inst_4831 = (state_4851[(2)]);
var inst_4832 = (new Array(n));
var inst_4815 = inst_4832;
var inst_4816 = (0);
var state_4851__$1 = (function (){var statearr_4863 = state_4851;
(statearr_4863[(7)] = inst_4815);

(statearr_4863[(8)] = inst_4816);

(statearr_4863[(10)] = inst_4831);

return statearr_4863;
})();
var statearr_4864_4888 = state_4851__$1;
(statearr_4864_4888[(2)] = null);

(statearr_4864_4888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (9))){
var inst_4815 = (state_4851[(7)]);
var inst_4829 = cljs.core.vec.call(null,inst_4815);
var state_4851__$1 = state_4851;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4851__$1,(11),out,inst_4829);
} else {
if((state_val_4852 === (5))){
var inst_4815 = (state_4851[(7)]);
var inst_4816 = (state_4851[(8)]);
var inst_4824 = (state_4851[(11)]);
var inst_4819 = (state_4851[(9)]);
var inst_4823 = (inst_4815[inst_4816] = inst_4819);
var inst_4824__$1 = (inst_4816 + (1));
var inst_4825 = (inst_4824__$1 < n);
var state_4851__$1 = (function (){var statearr_4865 = state_4851;
(statearr_4865[(12)] = inst_4823);

(statearr_4865[(11)] = inst_4824__$1);

return statearr_4865;
})();
if(cljs.core.truth_(inst_4825)){
var statearr_4866_4889 = state_4851__$1;
(statearr_4866_4889[(1)] = (8));

} else {
var statearr_4867_4890 = state_4851__$1;
(statearr_4867_4890[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (14))){
var inst_4844 = (state_4851[(2)]);
var inst_4845 = cljs.core.async.close_BANG_.call(null,out);
var state_4851__$1 = (function (){var statearr_4869 = state_4851;
(statearr_4869[(13)] = inst_4844);

return statearr_4869;
})();
var statearr_4870_4891 = state_4851__$1;
(statearr_4870_4891[(2)] = inst_4845);

(statearr_4870_4891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (10))){
var inst_4835 = (state_4851[(2)]);
var state_4851__$1 = state_4851;
var statearr_4871_4892 = state_4851__$1;
(statearr_4871_4892[(2)] = inst_4835);

(statearr_4871_4892[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4852 === (8))){
var inst_4815 = (state_4851[(7)]);
var inst_4824 = (state_4851[(11)]);
var tmp4868 = inst_4815;
var inst_4815__$1 = tmp4868;
var inst_4816 = inst_4824;
var state_4851__$1 = (function (){var statearr_4872 = state_4851;
(statearr_4872[(7)] = inst_4815__$1);

(statearr_4872[(8)] = inst_4816);

return statearr_4872;
})();
var statearr_4873_4893 = state_4851__$1;
(statearr_4873_4893[(2)] = null);

(statearr_4873_4893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4879,out))
;
return ((function (switch__2973__auto__,c__3063__auto___4879,out){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_4874 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4874[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_4874[(1)] = (1));

return statearr_4874;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_4851){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4851);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4875){if((e4875 instanceof Object)){
var ex__2977__auto__ = e4875;
var statearr_4876_4894 = state_4851;
(statearr_4876_4894[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4851);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4875;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4895 = state_4851;
state_4851 = G__4895;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_4851){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_4851);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4879,out))
})();
var state__3065__auto__ = (function (){var statearr_4877 = f__3064__auto__.call(null);
(statearr_4877[(6)] = c__3063__auto___4879);

return statearr_4877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4879,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__4897 = arguments.length;
switch (G__4897) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3063__auto___4967 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__3063__auto___4967,out){
return (function (){
var f__3064__auto__ = (function (){var switch__2973__auto__ = ((function (c__3063__auto___4967,out){
return (function (state_4939){
var state_val_4940 = (state_4939[(1)]);
if((state_val_4940 === (7))){
var inst_4935 = (state_4939[(2)]);
var state_4939__$1 = state_4939;
var statearr_4941_4968 = state_4939__$1;
(statearr_4941_4968[(2)] = inst_4935);

(statearr_4941_4968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (1))){
var inst_4898 = [];
var inst_4899 = inst_4898;
var inst_4900 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_4939__$1 = (function (){var statearr_4942 = state_4939;
(statearr_4942[(7)] = inst_4899);

(statearr_4942[(8)] = inst_4900);

return statearr_4942;
})();
var statearr_4943_4969 = state_4939__$1;
(statearr_4943_4969[(2)] = null);

(statearr_4943_4969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (4))){
var inst_4903 = (state_4939[(9)]);
var inst_4903__$1 = (state_4939[(2)]);
var inst_4904 = (inst_4903__$1 == null);
var inst_4905 = cljs.core.not.call(null,inst_4904);
var state_4939__$1 = (function (){var statearr_4944 = state_4939;
(statearr_4944[(9)] = inst_4903__$1);

return statearr_4944;
})();
if(inst_4905){
var statearr_4945_4970 = state_4939__$1;
(statearr_4945_4970[(1)] = (5));

} else {
var statearr_4946_4971 = state_4939__$1;
(statearr_4946_4971[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (15))){
var inst_4929 = (state_4939[(2)]);
var state_4939__$1 = state_4939;
var statearr_4947_4972 = state_4939__$1;
(statearr_4947_4972[(2)] = inst_4929);

(statearr_4947_4972[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (13))){
var state_4939__$1 = state_4939;
var statearr_4948_4973 = state_4939__$1;
(statearr_4948_4973[(2)] = null);

(statearr_4948_4973[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (6))){
var inst_4899 = (state_4939[(7)]);
var inst_4924 = inst_4899.length;
var inst_4925 = (inst_4924 > (0));
var state_4939__$1 = state_4939;
if(cljs.core.truth_(inst_4925)){
var statearr_4949_4974 = state_4939__$1;
(statearr_4949_4974[(1)] = (12));

} else {
var statearr_4950_4975 = state_4939__$1;
(statearr_4950_4975[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (3))){
var inst_4937 = (state_4939[(2)]);
var state_4939__$1 = state_4939;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4939__$1,inst_4937);
} else {
if((state_val_4940 === (12))){
var inst_4899 = (state_4939[(7)]);
var inst_4927 = cljs.core.vec.call(null,inst_4899);
var state_4939__$1 = state_4939;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4939__$1,(15),out,inst_4927);
} else {
if((state_val_4940 === (2))){
var state_4939__$1 = state_4939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4939__$1,(4),ch);
} else {
if((state_val_4940 === (11))){
var inst_4907 = (state_4939[(10)]);
var inst_4903 = (state_4939[(9)]);
var inst_4917 = (state_4939[(2)]);
var inst_4918 = [];
var inst_4919 = inst_4918.push(inst_4903);
var inst_4899 = inst_4918;
var inst_4900 = inst_4907;
var state_4939__$1 = (function (){var statearr_4951 = state_4939;
(statearr_4951[(7)] = inst_4899);

(statearr_4951[(8)] = inst_4900);

(statearr_4951[(11)] = inst_4919);

(statearr_4951[(12)] = inst_4917);

return statearr_4951;
})();
var statearr_4952_4976 = state_4939__$1;
(statearr_4952_4976[(2)] = null);

(statearr_4952_4976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (9))){
var inst_4899 = (state_4939[(7)]);
var inst_4915 = cljs.core.vec.call(null,inst_4899);
var state_4939__$1 = state_4939;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4939__$1,(11),out,inst_4915);
} else {
if((state_val_4940 === (5))){
var inst_4900 = (state_4939[(8)]);
var inst_4907 = (state_4939[(10)]);
var inst_4903 = (state_4939[(9)]);
var inst_4907__$1 = f.call(null,inst_4903);
var inst_4908 = cljs.core._EQ_.call(null,inst_4907__$1,inst_4900);
var inst_4909 = cljs.core.keyword_identical_QMARK_.call(null,inst_4900,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_4910 = ((inst_4908) || (inst_4909));
var state_4939__$1 = (function (){var statearr_4953 = state_4939;
(statearr_4953[(10)] = inst_4907__$1);

return statearr_4953;
})();
if(cljs.core.truth_(inst_4910)){
var statearr_4954_4977 = state_4939__$1;
(statearr_4954_4977[(1)] = (8));

} else {
var statearr_4955_4978 = state_4939__$1;
(statearr_4955_4978[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (14))){
var inst_4932 = (state_4939[(2)]);
var inst_4933 = cljs.core.async.close_BANG_.call(null,out);
var state_4939__$1 = (function (){var statearr_4957 = state_4939;
(statearr_4957[(13)] = inst_4932);

return statearr_4957;
})();
var statearr_4958_4979 = state_4939__$1;
(statearr_4958_4979[(2)] = inst_4933);

(statearr_4958_4979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (10))){
var inst_4922 = (state_4939[(2)]);
var state_4939__$1 = state_4939;
var statearr_4959_4980 = state_4939__$1;
(statearr_4959_4980[(2)] = inst_4922);

(statearr_4959_4980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4940 === (8))){
var inst_4899 = (state_4939[(7)]);
var inst_4907 = (state_4939[(10)]);
var inst_4903 = (state_4939[(9)]);
var inst_4912 = inst_4899.push(inst_4903);
var tmp4956 = inst_4899;
var inst_4899__$1 = tmp4956;
var inst_4900 = inst_4907;
var state_4939__$1 = (function (){var statearr_4960 = state_4939;
(statearr_4960[(7)] = inst_4899__$1);

(statearr_4960[(8)] = inst_4900);

(statearr_4960[(14)] = inst_4912);

return statearr_4960;
})();
var statearr_4961_4981 = state_4939__$1;
(statearr_4961_4981[(2)] = null);

(statearr_4961_4981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__3063__auto___4967,out))
;
return ((function (switch__2973__auto__,c__3063__auto___4967,out){
return (function() {
var cljs$core$async$state_machine__2974__auto__ = null;
var cljs$core$async$state_machine__2974__auto____0 = (function (){
var statearr_4962 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4962[(0)] = cljs$core$async$state_machine__2974__auto__);

(statearr_4962[(1)] = (1));

return statearr_4962;
});
var cljs$core$async$state_machine__2974__auto____1 = (function (state_4939){
while(true){
var ret_value__2975__auto__ = (function (){try{while(true){
var result__2976__auto__ = switch__2973__auto__.call(null,state_4939);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2976__auto__;
}
break;
}
}catch (e4963){if((e4963 instanceof Object)){
var ex__2977__auto__ = e4963;
var statearr_4964_4982 = state_4939;
(statearr_4964_4982[(5)] = ex__2977__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4939);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4963;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4983 = state_4939;
state_4939 = G__4983;
continue;
} else {
return ret_value__2975__auto__;
}
break;
}
});
cljs$core$async$state_machine__2974__auto__ = function(state_4939){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2974__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2974__auto____1.call(this,state_4939);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2974__auto____0;
cljs$core$async$state_machine__2974__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2974__auto____1;
return cljs$core$async$state_machine__2974__auto__;
})()
;})(switch__2973__auto__,c__3063__auto___4967,out))
})();
var state__3065__auto__ = (function (){var statearr_4965 = f__3064__auto__.call(null);
(statearr_4965[(6)] = c__3063__auto___4967);

return statearr_4965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3065__auto__);
});})(c__3063__auto___4967,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
