// Compiled by ClojureScript 1.10.217 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.15";
figwheel.client.js_stringify = ((((typeof JSON !== 'undefined') && (!((JSON.stringify == null)))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e26727){if((e26727 instanceof Error)){
var e = e26727;
return "Error: Unable to stringify";
} else {
throw e26727;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__26730 = arguments.length;
switch (G__26730) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__26728_SHARP_){
if(typeof p1__26728_SHARP_ === 'string'){
return p1__26728_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__26728_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4501__auto__ = [];
var len__4498__auto___26733 = arguments.length;
var i__4499__auto___26734 = (0);
while(true){
if((i__4499__auto___26734 < len__4498__auto___26733)){
args__4501__auto__.push((arguments[i__4499__auto___26734]));

var G__26735 = (i__4499__auto___26734 + (1));
i__4499__auto___26734 = G__26735;
continue;
} else {
}
break;
}

var argseq__4502__auto__ = ((((0) < args__4501__auto__.length))?(new cljs.core.IndexedSeq(args__4501__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4502__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq26732){
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq26732));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4501__auto__ = [];
var len__4498__auto___26737 = arguments.length;
var i__4499__auto___26738 = (0);
while(true){
if((i__4499__auto___26738 < len__4498__auto___26737)){
args__4501__auto__.push((arguments[i__4499__auto___26738]));

var G__26739 = (i__4499__auto___26738 + (1));
i__4499__auto___26738 = G__26739;
continue;
} else {
}
break;
}

var argseq__4502__auto__ = ((((0) < args__4501__auto__.length))?(new cljs.core.IndexedSeq(args__4501__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4502__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq26736){
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq26736));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__26740){
var map__26741 = p__26740;
var map__26741__$1 = ((((!((map__26741 == null)))?(((((map__26741.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26741.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26741):map__26741);
var message = cljs.core.get.call(null,map__26741__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__26741__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__3921__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__3910__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__3910__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__3910__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__23296__auto___26820 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23296__auto___26820,ch){
return (function (){
var f__23297__auto__ = (function (){var switch__23273__auto__ = ((function (c__23296__auto___26820,ch){
return (function (state_26792){
var state_val_26793 = (state_26792[(1)]);
if((state_val_26793 === (7))){
var inst_26788 = (state_26792[(2)]);
var state_26792__$1 = state_26792;
var statearr_26794_26821 = state_26792__$1;
(statearr_26794_26821[(2)] = inst_26788);

(statearr_26794_26821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (1))){
var state_26792__$1 = state_26792;
var statearr_26795_26822 = state_26792__$1;
(statearr_26795_26822[(2)] = null);

(statearr_26795_26822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (4))){
var inst_26745 = (state_26792[(7)]);
var inst_26745__$1 = (state_26792[(2)]);
var state_26792__$1 = (function (){var statearr_26796 = state_26792;
(statearr_26796[(7)] = inst_26745__$1);

return statearr_26796;
})();
if(cljs.core.truth_(inst_26745__$1)){
var statearr_26797_26823 = state_26792__$1;
(statearr_26797_26823[(1)] = (5));

} else {
var statearr_26798_26824 = state_26792__$1;
(statearr_26798_26824[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (15))){
var inst_26752 = (state_26792[(8)]);
var inst_26767 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_26752);
var inst_26768 = cljs.core.first.call(null,inst_26767);
var inst_26769 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_26768);
var inst_26770 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26769)].join('');
var inst_26771 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_26770);
var state_26792__$1 = state_26792;
var statearr_26799_26825 = state_26792__$1;
(statearr_26799_26825[(2)] = inst_26771);

(statearr_26799_26825[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (13))){
var inst_26776 = (state_26792[(2)]);
var state_26792__$1 = state_26792;
var statearr_26800_26826 = state_26792__$1;
(statearr_26800_26826[(2)] = inst_26776);

(statearr_26800_26826[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (6))){
var state_26792__$1 = state_26792;
var statearr_26801_26827 = state_26792__$1;
(statearr_26801_26827[(2)] = null);

(statearr_26801_26827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (17))){
var inst_26774 = (state_26792[(2)]);
var state_26792__$1 = state_26792;
var statearr_26802_26828 = state_26792__$1;
(statearr_26802_26828[(2)] = inst_26774);

(statearr_26802_26828[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (3))){
var inst_26790 = (state_26792[(2)]);
var state_26792__$1 = state_26792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26792__$1,inst_26790);
} else {
if((state_val_26793 === (12))){
var inst_26751 = (state_26792[(9)]);
var inst_26765 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_26751,opts);
var state_26792__$1 = state_26792;
if(cljs.core.truth_(inst_26765)){
var statearr_26803_26829 = state_26792__$1;
(statearr_26803_26829[(1)] = (15));

} else {
var statearr_26804_26830 = state_26792__$1;
(statearr_26804_26830[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (2))){
var state_26792__$1 = state_26792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26792__$1,(4),ch);
} else {
if((state_val_26793 === (11))){
var inst_26752 = (state_26792[(8)]);
var inst_26757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26758 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_26752);
var inst_26759 = cljs.core.async.timeout.call(null,(1000));
var inst_26760 = [inst_26758,inst_26759];
var inst_26761 = (new cljs.core.PersistentVector(null,2,(5),inst_26757,inst_26760,null));
var state_26792__$1 = state_26792;
return cljs.core.async.ioc_alts_BANG_.call(null,state_26792__$1,(14),inst_26761);
} else {
if((state_val_26793 === (9))){
var inst_26752 = (state_26792[(8)]);
var inst_26778 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_26779 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_26752);
var inst_26780 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_26779);
var inst_26781 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26780)].join('');
var inst_26782 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_26781);
var state_26792__$1 = (function (){var statearr_26805 = state_26792;
(statearr_26805[(10)] = inst_26778);

return statearr_26805;
})();
var statearr_26806_26831 = state_26792__$1;
(statearr_26806_26831[(2)] = inst_26782);

(statearr_26806_26831[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (5))){
var inst_26745 = (state_26792[(7)]);
var inst_26747 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_26748 = (new cljs.core.PersistentArrayMap(null,2,inst_26747,null));
var inst_26749 = (new cljs.core.PersistentHashSet(null,inst_26748,null));
var inst_26750 = figwheel.client.focus_msgs.call(null,inst_26749,inst_26745);
var inst_26751 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_26750);
var inst_26752 = cljs.core.first.call(null,inst_26750);
var inst_26753 = figwheel.client.autoload_QMARK_.call(null);
var state_26792__$1 = (function (){var statearr_26807 = state_26792;
(statearr_26807[(8)] = inst_26752);

(statearr_26807[(9)] = inst_26751);

return statearr_26807;
})();
if(cljs.core.truth_(inst_26753)){
var statearr_26808_26832 = state_26792__$1;
(statearr_26808_26832[(1)] = (8));

} else {
var statearr_26809_26833 = state_26792__$1;
(statearr_26809_26833[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (14))){
var inst_26763 = (state_26792[(2)]);
var state_26792__$1 = state_26792;
var statearr_26810_26834 = state_26792__$1;
(statearr_26810_26834[(2)] = inst_26763);

(statearr_26810_26834[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (16))){
var state_26792__$1 = state_26792;
var statearr_26811_26835 = state_26792__$1;
(statearr_26811_26835[(2)] = null);

(statearr_26811_26835[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (10))){
var inst_26784 = (state_26792[(2)]);
var state_26792__$1 = (function (){var statearr_26812 = state_26792;
(statearr_26812[(11)] = inst_26784);

return statearr_26812;
})();
var statearr_26813_26836 = state_26792__$1;
(statearr_26813_26836[(2)] = null);

(statearr_26813_26836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26793 === (8))){
var inst_26751 = (state_26792[(9)]);
var inst_26755 = figwheel.client.reload_file_state_QMARK_.call(null,inst_26751,opts);
var state_26792__$1 = state_26792;
if(cljs.core.truth_(inst_26755)){
var statearr_26814_26837 = state_26792__$1;
(statearr_26814_26837[(1)] = (11));

} else {
var statearr_26815_26838 = state_26792__$1;
(statearr_26815_26838[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23296__auto___26820,ch))
;
return ((function (switch__23273__auto__,c__23296__auto___26820,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__23274__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__23274__auto____0 = (function (){
var statearr_26816 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26816[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__23274__auto__);

(statearr_26816[(1)] = (1));

return statearr_26816;
});
var figwheel$client$file_reloader_plugin_$_state_machine__23274__auto____1 = (function (state_26792){
while(true){
var ret_value__23275__auto__ = (function (){try{while(true){
var result__23276__auto__ = switch__23273__auto__.call(null,state_26792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23276__auto__;
}
break;
}
}catch (e26817){if((e26817 instanceof Object)){
var ex__23277__auto__ = e26817;
var statearr_26818_26839 = state_26792;
(statearr_26818_26839[(5)] = ex__23277__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26792);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26817;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23275__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26840 = state_26792;
state_26792 = G__26840;
continue;
} else {
return ret_value__23275__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__23274__auto__ = function(state_26792){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__23274__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__23274__auto____1.call(this,state_26792);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__23274__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__23274__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__23274__auto__;
})()
;})(switch__23273__auto__,c__23296__auto___26820,ch))
})();
var state__23298__auto__ = (function (){var statearr_26819 = f__23297__auto__.call(null);
(statearr_26819[(6)] = c__23296__auto___26820);

return statearr_26819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23298__auto__);
});})(c__23296__auto___26820,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__26841_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__26841_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_26845 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_26845){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_26843 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_26844 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_26843,_STAR_print_fn_STAR_26844,sb,base_path_26845){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR_26843,_STAR_print_fn_STAR_26844,sb,base_path_26845))
;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join(''),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_26844;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_26843;
}}catch (e26842){if((e26842 instanceof Error)){
var e = e26842;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_26845], null));
} else {
var e = e26842;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_26845))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__26846){
var map__26847 = p__26846;
var map__26847__$1 = ((((!((map__26847 == null)))?(((((map__26847.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26847.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26847):map__26847);
var opts = map__26847__$1;
var build_id = cljs.core.get.call(null,map__26847__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__26847,map__26847__$1,opts,build_id){
return (function (p__26849){
var vec__26850 = p__26849;
var seq__26851 = cljs.core.seq.call(null,vec__26850);
var first__26852 = cljs.core.first.call(null,seq__26851);
var seq__26851__$1 = cljs.core.next.call(null,seq__26851);
var map__26853 = first__26852;
var map__26853__$1 = ((((!((map__26853 == null)))?(((((map__26853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26853):map__26853);
var msg = map__26853__$1;
var msg_name = cljs.core.get.call(null,map__26853__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__26851__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__26850,seq__26851,first__26852,seq__26851__$1,map__26853,map__26853__$1,msg,msg_name,_,map__26847,map__26847__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__26850,seq__26851,first__26852,seq__26851__$1,map__26853,map__26853__$1,msg,msg_name,_,map__26847,map__26847__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__26847,map__26847__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__26855){
var vec__26856 = p__26855;
var seq__26857 = cljs.core.seq.call(null,vec__26856);
var first__26858 = cljs.core.first.call(null,seq__26857);
var seq__26857__$1 = cljs.core.next.call(null,seq__26857);
var map__26859 = first__26858;
var map__26859__$1 = ((((!((map__26859 == null)))?(((((map__26859.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26859.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26859):map__26859);
var msg = map__26859__$1;
var msg_name = cljs.core.get.call(null,map__26859__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__26857__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__26861){
var map__26862 = p__26861;
var map__26862__$1 = ((((!((map__26862 == null)))?(((((map__26862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26862.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26862):map__26862);
var on_compile_warning = cljs.core.get.call(null,map__26862__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__26862__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__26862,map__26862__$1,on_compile_warning,on_compile_fail){
return (function (p__26864){
var vec__26865 = p__26864;
var seq__26866 = cljs.core.seq.call(null,vec__26865);
var first__26867 = cljs.core.first.call(null,seq__26866);
var seq__26866__$1 = cljs.core.next.call(null,seq__26866);
var map__26868 = first__26867;
var map__26868__$1 = ((((!((map__26868 == null)))?(((((map__26868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26868):map__26868);
var msg = map__26868__$1;
var msg_name = cljs.core.get.call(null,map__26868__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__26866__$1;
var pred__26870 = cljs.core._EQ_;
var expr__26871 = msg_name;
if(cljs.core.truth_(pred__26870.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__26871))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__26870.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__26871))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__26862,map__26862__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__23296__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23296__auto__,msg_hist,msg_names,msg){
return (function (){
var f__23297__auto__ = (function (){var switch__23273__auto__ = ((function (c__23296__auto__,msg_hist,msg_names,msg){
return (function (state_26960){
var state_val_26961 = (state_26960[(1)]);
if((state_val_26961 === (7))){
var inst_26880 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
if(cljs.core.truth_(inst_26880)){
var statearr_26962_27009 = state_26960__$1;
(statearr_26962_27009[(1)] = (8));

} else {
var statearr_26963_27010 = state_26960__$1;
(statearr_26963_27010[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (20))){
var inst_26954 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_26964_27011 = state_26960__$1;
(statearr_26964_27011[(2)] = inst_26954);

(statearr_26964_27011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (27))){
var inst_26950 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_26965_27012 = state_26960__$1;
(statearr_26965_27012[(2)] = inst_26950);

(statearr_26965_27012[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (1))){
var inst_26873 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_26960__$1 = state_26960;
if(cljs.core.truth_(inst_26873)){
var statearr_26966_27013 = state_26960__$1;
(statearr_26966_27013[(1)] = (2));

} else {
var statearr_26967_27014 = state_26960__$1;
(statearr_26967_27014[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (24))){
var inst_26952 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_26968_27015 = state_26960__$1;
(statearr_26968_27015[(2)] = inst_26952);

(statearr_26968_27015[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (4))){
var inst_26958 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26960__$1,inst_26958);
} else {
if((state_val_26961 === (15))){
var inst_26956 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_26969_27016 = state_26960__$1;
(statearr_26969_27016[(2)] = inst_26956);

(statearr_26969_27016[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (21))){
var inst_26909 = (state_26960[(2)]);
var inst_26910 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26911 = figwheel.client.auto_jump_to_error.call(null,opts,inst_26910);
var state_26960__$1 = (function (){var statearr_26970 = state_26960;
(statearr_26970[(7)] = inst_26909);

return statearr_26970;
})();
var statearr_26971_27017 = state_26960__$1;
(statearr_26971_27017[(2)] = inst_26911);

(statearr_26971_27017[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (31))){
var inst_26939 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_26960__$1 = state_26960;
if(cljs.core.truth_(inst_26939)){
var statearr_26972_27018 = state_26960__$1;
(statearr_26972_27018[(1)] = (34));

} else {
var statearr_26973_27019 = state_26960__$1;
(statearr_26973_27019[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (32))){
var inst_26948 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_26974_27020 = state_26960__$1;
(statearr_26974_27020[(2)] = inst_26948);

(statearr_26974_27020[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (33))){
var inst_26935 = (state_26960[(2)]);
var inst_26936 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26937 = figwheel.client.auto_jump_to_error.call(null,opts,inst_26936);
var state_26960__$1 = (function (){var statearr_26975 = state_26960;
(statearr_26975[(8)] = inst_26935);

return statearr_26975;
})();
var statearr_26976_27021 = state_26960__$1;
(statearr_26976_27021[(2)] = inst_26937);

(statearr_26976_27021[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (13))){
var inst_26894 = figwheel.client.heads_up.clear.call(null);
var state_26960__$1 = state_26960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(16),inst_26894);
} else {
if((state_val_26961 === (22))){
var inst_26915 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26916 = figwheel.client.heads_up.append_warning_message.call(null,inst_26915);
var state_26960__$1 = state_26960;
var statearr_26977_27022 = state_26960__$1;
(statearr_26977_27022[(2)] = inst_26916);

(statearr_26977_27022[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (36))){
var inst_26946 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_26978_27023 = state_26960__$1;
(statearr_26978_27023[(2)] = inst_26946);

(statearr_26978_27023[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (29))){
var inst_26926 = (state_26960[(2)]);
var inst_26927 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26928 = figwheel.client.auto_jump_to_error.call(null,opts,inst_26927);
var state_26960__$1 = (function (){var statearr_26979 = state_26960;
(statearr_26979[(9)] = inst_26926);

return statearr_26979;
})();
var statearr_26980_27024 = state_26960__$1;
(statearr_26980_27024[(2)] = inst_26928);

(statearr_26980_27024[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (6))){
var inst_26875 = (state_26960[(10)]);
var state_26960__$1 = state_26960;
var statearr_26981_27025 = state_26960__$1;
(statearr_26981_27025[(2)] = inst_26875);

(statearr_26981_27025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (28))){
var inst_26922 = (state_26960[(2)]);
var inst_26923 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26924 = figwheel.client.heads_up.display_warning.call(null,inst_26923);
var state_26960__$1 = (function (){var statearr_26982 = state_26960;
(statearr_26982[(11)] = inst_26922);

return statearr_26982;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(29),inst_26924);
} else {
if((state_val_26961 === (25))){
var inst_26920 = figwheel.client.heads_up.clear.call(null);
var state_26960__$1 = state_26960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(28),inst_26920);
} else {
if((state_val_26961 === (34))){
var inst_26941 = figwheel.client.heads_up.flash_loaded.call(null);
var state_26960__$1 = state_26960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(37),inst_26941);
} else {
if((state_val_26961 === (17))){
var inst_26900 = (state_26960[(2)]);
var inst_26901 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26902 = figwheel.client.auto_jump_to_error.call(null,opts,inst_26901);
var state_26960__$1 = (function (){var statearr_26983 = state_26960;
(statearr_26983[(12)] = inst_26900);

return statearr_26983;
})();
var statearr_26984_27026 = state_26960__$1;
(statearr_26984_27026[(2)] = inst_26902);

(statearr_26984_27026[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (3))){
var inst_26892 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_26960__$1 = state_26960;
if(cljs.core.truth_(inst_26892)){
var statearr_26985_27027 = state_26960__$1;
(statearr_26985_27027[(1)] = (13));

} else {
var statearr_26986_27028 = state_26960__$1;
(statearr_26986_27028[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (12))){
var inst_26888 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_26987_27029 = state_26960__$1;
(statearr_26987_27029[(2)] = inst_26888);

(statearr_26987_27029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (2))){
var inst_26875 = (state_26960[(10)]);
var inst_26875__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_26960__$1 = (function (){var statearr_26988 = state_26960;
(statearr_26988[(10)] = inst_26875__$1);

return statearr_26988;
})();
if(cljs.core.truth_(inst_26875__$1)){
var statearr_26989_27030 = state_26960__$1;
(statearr_26989_27030[(1)] = (5));

} else {
var statearr_26990_27031 = state_26960__$1;
(statearr_26990_27031[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (23))){
var inst_26918 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_26960__$1 = state_26960;
if(cljs.core.truth_(inst_26918)){
var statearr_26991_27032 = state_26960__$1;
(statearr_26991_27032[(1)] = (25));

} else {
var statearr_26992_27033 = state_26960__$1;
(statearr_26992_27033[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (35))){
var state_26960__$1 = state_26960;
var statearr_26993_27034 = state_26960__$1;
(statearr_26993_27034[(2)] = null);

(statearr_26993_27034[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (19))){
var inst_26913 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_26960__$1 = state_26960;
if(cljs.core.truth_(inst_26913)){
var statearr_26994_27035 = state_26960__$1;
(statearr_26994_27035[(1)] = (22));

} else {
var statearr_26995_27036 = state_26960__$1;
(statearr_26995_27036[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (11))){
var inst_26884 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_26996_27037 = state_26960__$1;
(statearr_26996_27037[(2)] = inst_26884);

(statearr_26996_27037[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (9))){
var inst_26886 = figwheel.client.heads_up.clear.call(null);
var state_26960__$1 = state_26960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(12),inst_26886);
} else {
if((state_val_26961 === (5))){
var inst_26877 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_26960__$1 = state_26960;
var statearr_26997_27038 = state_26960__$1;
(statearr_26997_27038[(2)] = inst_26877);

(statearr_26997_27038[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (14))){
var inst_26904 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_26960__$1 = state_26960;
if(cljs.core.truth_(inst_26904)){
var statearr_26998_27039 = state_26960__$1;
(statearr_26998_27039[(1)] = (18));

} else {
var statearr_26999_27040 = state_26960__$1;
(statearr_26999_27040[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (26))){
var inst_26930 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_26960__$1 = state_26960;
if(cljs.core.truth_(inst_26930)){
var statearr_27000_27041 = state_26960__$1;
(statearr_27000_27041[(1)] = (30));

} else {
var statearr_27001_27042 = state_26960__$1;
(statearr_27001_27042[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (16))){
var inst_26896 = (state_26960[(2)]);
var inst_26897 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26898 = figwheel.client.heads_up.display_exception.call(null,inst_26897);
var state_26960__$1 = (function (){var statearr_27002 = state_26960;
(statearr_27002[(13)] = inst_26896);

return statearr_27002;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(17),inst_26898);
} else {
if((state_val_26961 === (30))){
var inst_26932 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26933 = figwheel.client.heads_up.display_warning.call(null,inst_26932);
var state_26960__$1 = state_26960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(33),inst_26933);
} else {
if((state_val_26961 === (10))){
var inst_26890 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_27003_27043 = state_26960__$1;
(statearr_27003_27043[(2)] = inst_26890);

(statearr_27003_27043[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (18))){
var inst_26906 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_26907 = figwheel.client.heads_up.display_exception.call(null,inst_26906);
var state_26960__$1 = state_26960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(21),inst_26907);
} else {
if((state_val_26961 === (37))){
var inst_26943 = (state_26960[(2)]);
var state_26960__$1 = state_26960;
var statearr_27004_27044 = state_26960__$1;
(statearr_27004_27044[(2)] = inst_26943);

(statearr_27004_27044[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26961 === (8))){
var inst_26882 = figwheel.client.heads_up.flash_loaded.call(null);
var state_26960__$1 = state_26960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26960__$1,(11),inst_26882);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23296__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__23273__auto__,c__23296__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto____0 = (function (){
var statearr_27005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27005[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto__);

(statearr_27005[(1)] = (1));

return statearr_27005;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto____1 = (function (state_26960){
while(true){
var ret_value__23275__auto__ = (function (){try{while(true){
var result__23276__auto__ = switch__23273__auto__.call(null,state_26960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23276__auto__;
}
break;
}
}catch (e27006){if((e27006 instanceof Object)){
var ex__23277__auto__ = e27006;
var statearr_27007_27045 = state_26960;
(statearr_27007_27045[(5)] = ex__23277__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26960);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23275__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27046 = state_26960;
state_26960 = G__27046;
continue;
} else {
return ret_value__23275__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto__ = function(state_26960){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto____1.call(this,state_26960);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__23274__auto__;
})()
;})(switch__23273__auto__,c__23296__auto__,msg_hist,msg_names,msg))
})();
var state__23298__auto__ = (function (){var statearr_27008 = f__23297__auto__.call(null);
(statearr_27008[(6)] = c__23296__auto__);

return statearr_27008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23298__auto__);
});})(c__23296__auto__,msg_hist,msg_names,msg))
);

return c__23296__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__23296__auto___27075 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23296__auto___27075,ch){
return (function (){
var f__23297__auto__ = (function (){var switch__23273__auto__ = ((function (c__23296__auto___27075,ch){
return (function (state_27061){
var state_val_27062 = (state_27061[(1)]);
if((state_val_27062 === (1))){
var state_27061__$1 = state_27061;
var statearr_27063_27076 = state_27061__$1;
(statearr_27063_27076[(2)] = null);

(statearr_27063_27076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27062 === (2))){
var state_27061__$1 = state_27061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27061__$1,(4),ch);
} else {
if((state_val_27062 === (3))){
var inst_27059 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27061__$1,inst_27059);
} else {
if((state_val_27062 === (4))){
var inst_27049 = (state_27061[(7)]);
var inst_27049__$1 = (state_27061[(2)]);
var state_27061__$1 = (function (){var statearr_27064 = state_27061;
(statearr_27064[(7)] = inst_27049__$1);

return statearr_27064;
})();
if(cljs.core.truth_(inst_27049__$1)){
var statearr_27065_27077 = state_27061__$1;
(statearr_27065_27077[(1)] = (5));

} else {
var statearr_27066_27078 = state_27061__$1;
(statearr_27066_27078[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27062 === (5))){
var inst_27049 = (state_27061[(7)]);
var inst_27051 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_27049);
var state_27061__$1 = state_27061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27061__$1,(8),inst_27051);
} else {
if((state_val_27062 === (6))){
var state_27061__$1 = state_27061;
var statearr_27067_27079 = state_27061__$1;
(statearr_27067_27079[(2)] = null);

(statearr_27067_27079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27062 === (7))){
var inst_27057 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27068_27080 = state_27061__$1;
(statearr_27068_27080[(2)] = inst_27057);

(statearr_27068_27080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27062 === (8))){
var inst_27053 = (state_27061[(2)]);
var state_27061__$1 = (function (){var statearr_27069 = state_27061;
(statearr_27069[(8)] = inst_27053);

return statearr_27069;
})();
var statearr_27070_27081 = state_27061__$1;
(statearr_27070_27081[(2)] = null);

(statearr_27070_27081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__23296__auto___27075,ch))
;
return ((function (switch__23273__auto__,c__23296__auto___27075,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__23274__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__23274__auto____0 = (function (){
var statearr_27071 = [null,null,null,null,null,null,null,null,null];
(statearr_27071[(0)] = figwheel$client$heads_up_plugin_$_state_machine__23274__auto__);

(statearr_27071[(1)] = (1));

return statearr_27071;
});
var figwheel$client$heads_up_plugin_$_state_machine__23274__auto____1 = (function (state_27061){
while(true){
var ret_value__23275__auto__ = (function (){try{while(true){
var result__23276__auto__ = switch__23273__auto__.call(null,state_27061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23276__auto__;
}
break;
}
}catch (e27072){if((e27072 instanceof Object)){
var ex__23277__auto__ = e27072;
var statearr_27073_27082 = state_27061;
(statearr_27073_27082[(5)] = ex__23277__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27061);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27072;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23275__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27083 = state_27061;
state_27061 = G__27083;
continue;
} else {
return ret_value__23275__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__23274__auto__ = function(state_27061){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__23274__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__23274__auto____1.call(this,state_27061);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__23274__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__23274__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__23274__auto__;
})()
;})(switch__23273__auto__,c__23296__auto___27075,ch))
})();
var state__23298__auto__ = (function (){var statearr_27074 = f__23297__auto__.call(null);
(statearr_27074[(6)] = c__23296__auto___27075);

return statearr_27074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23298__auto__);
});})(c__23296__auto___27075,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__23296__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23296__auto__){
return (function (){
var f__23297__auto__ = (function (){var switch__23273__auto__ = ((function (c__23296__auto__){
return (function (state_27089){
var state_val_27090 = (state_27089[(1)]);
if((state_val_27090 === (1))){
var inst_27084 = cljs.core.async.timeout.call(null,(3000));
var state_27089__$1 = state_27089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27089__$1,(2),inst_27084);
} else {
if((state_val_27090 === (2))){
var inst_27086 = (state_27089[(2)]);
var inst_27087 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_27089__$1 = (function (){var statearr_27091 = state_27089;
(statearr_27091[(7)] = inst_27086);

return statearr_27091;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27089__$1,inst_27087);
} else {
return null;
}
}
});})(c__23296__auto__))
;
return ((function (switch__23273__auto__,c__23296__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__23274__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__23274__auto____0 = (function (){
var statearr_27092 = [null,null,null,null,null,null,null,null];
(statearr_27092[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__23274__auto__);

(statearr_27092[(1)] = (1));

return statearr_27092;
});
var figwheel$client$enforce_project_plugin_$_state_machine__23274__auto____1 = (function (state_27089){
while(true){
var ret_value__23275__auto__ = (function (){try{while(true){
var result__23276__auto__ = switch__23273__auto__.call(null,state_27089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23276__auto__;
}
break;
}
}catch (e27093){if((e27093 instanceof Object)){
var ex__23277__auto__ = e27093;
var statearr_27094_27096 = state_27089;
(statearr_27094_27096[(5)] = ex__23277__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27093;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23275__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27097 = state_27089;
state_27089 = G__27097;
continue;
} else {
return ret_value__23275__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__23274__auto__ = function(state_27089){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__23274__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__23274__auto____1.call(this,state_27089);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__23274__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__23274__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__23274__auto__;
})()
;})(switch__23273__auto__,c__23296__auto__))
})();
var state__23298__auto__ = (function (){var statearr_27095 = f__23297__auto__.call(null);
(statearr_27095[(6)] = c__23296__auto__);

return statearr_27095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23298__auto__);
});})(c__23296__auto__))
);

return c__23296__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5457__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5457__auto__)){
var figwheel_version = temp__5457__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__23296__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23296__auto__,figwheel_version,temp__5457__auto__){
return (function (){
var f__23297__auto__ = (function (){var switch__23273__auto__ = ((function (c__23296__auto__,figwheel_version,temp__5457__auto__){
return (function (state_27104){
var state_val_27105 = (state_27104[(1)]);
if((state_val_27105 === (1))){
var inst_27098 = cljs.core.async.timeout.call(null,(2000));
var state_27104__$1 = state_27104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27104__$1,(2),inst_27098);
} else {
if((state_val_27105 === (2))){
var inst_27100 = (state_27104[(2)]);
var inst_27101 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_27102 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_27101);
var state_27104__$1 = (function (){var statearr_27106 = state_27104;
(statearr_27106[(7)] = inst_27100);

return statearr_27106;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27104__$1,inst_27102);
} else {
return null;
}
}
});})(c__23296__auto__,figwheel_version,temp__5457__auto__))
;
return ((function (switch__23273__auto__,c__23296__auto__,figwheel_version,temp__5457__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto____0 = (function (){
var statearr_27107 = [null,null,null,null,null,null,null,null];
(statearr_27107[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto__);

(statearr_27107[(1)] = (1));

return statearr_27107;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto____1 = (function (state_27104){
while(true){
var ret_value__23275__auto__ = (function (){try{while(true){
var result__23276__auto__ = switch__23273__auto__.call(null,state_27104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23276__auto__;
}
break;
}
}catch (e27108){if((e27108 instanceof Object)){
var ex__23277__auto__ = e27108;
var statearr_27109_27111 = state_27104;
(statearr_27109_27111[(5)] = ex__23277__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27104);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27108;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23275__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27112 = state_27104;
state_27104 = G__27112;
continue;
} else {
return ret_value__23275__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto__ = function(state_27104){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto____1.call(this,state_27104);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__23274__auto__;
})()
;})(switch__23273__auto__,c__23296__auto__,figwheel_version,temp__5457__auto__))
})();
var state__23298__auto__ = (function (){var statearr_27110 = f__23297__auto__.call(null);
(statearr_27110[(6)] = c__23296__auto__);

return statearr_27110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23298__auto__);
});})(c__23296__auto__,figwheel_version,temp__5457__auto__))
);

return c__23296__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__27113){
var map__27114 = p__27113;
var map__27114__$1 = ((((!((map__27114 == null)))?(((((map__27114.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27114.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27114):map__27114);
var file = cljs.core.get.call(null,map__27114__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__27114__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__27114__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__27116 = "";
var G__27116__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27116),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__27116);
var G__27116__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27116__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__27116__$1);
if(cljs.core.truth_((function (){var and__3910__auto__ = line;
if(cljs.core.truth_(and__3910__auto__)){
return column;
} else {
return and__3910__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27116__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__27116__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__27117){
var map__27118 = p__27117;
var map__27118__$1 = ((((!((map__27118 == null)))?(((((map__27118.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27118.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27118):map__27118);
var ed = map__27118__$1;
var formatted_exception = cljs.core.get.call(null,map__27118__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__27118__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__27118__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__27120_27124 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__27121_27125 = null;
var count__27122_27126 = (0);
var i__27123_27127 = (0);
while(true){
if((i__27123_27127 < count__27122_27126)){
var msg_27128 = cljs.core._nth.call(null,chunk__27121_27125,i__27123_27127);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_27128);


var G__27129 = seq__27120_27124;
var G__27130 = chunk__27121_27125;
var G__27131 = count__27122_27126;
var G__27132 = (i__27123_27127 + (1));
seq__27120_27124 = G__27129;
chunk__27121_27125 = G__27130;
count__27122_27126 = G__27131;
i__27123_27127 = G__27132;
continue;
} else {
var temp__5457__auto___27133 = cljs.core.seq.call(null,seq__27120_27124);
if(temp__5457__auto___27133){
var seq__27120_27134__$1 = temp__5457__auto___27133;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27120_27134__$1)){
var c__4318__auto___27135 = cljs.core.chunk_first.call(null,seq__27120_27134__$1);
var G__27136 = cljs.core.chunk_rest.call(null,seq__27120_27134__$1);
var G__27137 = c__4318__auto___27135;
var G__27138 = cljs.core.count.call(null,c__4318__auto___27135);
var G__27139 = (0);
seq__27120_27124 = G__27136;
chunk__27121_27125 = G__27137;
count__27122_27126 = G__27138;
i__27123_27127 = G__27139;
continue;
} else {
var msg_27140 = cljs.core.first.call(null,seq__27120_27134__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_27140);


var G__27141 = cljs.core.next.call(null,seq__27120_27134__$1);
var G__27142 = null;
var G__27143 = (0);
var G__27144 = (0);
seq__27120_27124 = G__27141;
chunk__27121_27125 = G__27142;
count__27122_27126 = G__27143;
i__27123_27127 = G__27144;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__27145){
var map__27146 = p__27145;
var map__27146__$1 = ((((!((map__27146 == null)))?(((((map__27146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27146.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27146):map__27146);
var w = map__27146__$1;
var message = cljs.core.get.call(null,map__27146__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,353,353,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__3910__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__3910__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__3910__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__27148 = cljs.core.seq.call(null,plugins);
var chunk__27149 = null;
var count__27150 = (0);
var i__27151 = (0);
while(true){
if((i__27151 < count__27150)){
var vec__27152 = cljs.core._nth.call(null,chunk__27149,i__27151);
var k = cljs.core.nth.call(null,vec__27152,(0),null);
var plugin = cljs.core.nth.call(null,vec__27152,(1),null);
if(cljs.core.truth_(plugin)){
var pl_27158 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__27148,chunk__27149,count__27150,i__27151,pl_27158,vec__27152,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_27158.call(null,msg_hist);
});})(seq__27148,chunk__27149,count__27150,i__27151,pl_27158,vec__27152,k,plugin))
);
} else {
}


var G__27159 = seq__27148;
var G__27160 = chunk__27149;
var G__27161 = count__27150;
var G__27162 = (i__27151 + (1));
seq__27148 = G__27159;
chunk__27149 = G__27160;
count__27150 = G__27161;
i__27151 = G__27162;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__27148);
if(temp__5457__auto__){
var seq__27148__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27148__$1)){
var c__4318__auto__ = cljs.core.chunk_first.call(null,seq__27148__$1);
var G__27163 = cljs.core.chunk_rest.call(null,seq__27148__$1);
var G__27164 = c__4318__auto__;
var G__27165 = cljs.core.count.call(null,c__4318__auto__);
var G__27166 = (0);
seq__27148 = G__27163;
chunk__27149 = G__27164;
count__27150 = G__27165;
i__27151 = G__27166;
continue;
} else {
var vec__27155 = cljs.core.first.call(null,seq__27148__$1);
var k = cljs.core.nth.call(null,vec__27155,(0),null);
var plugin = cljs.core.nth.call(null,vec__27155,(1),null);
if(cljs.core.truth_(plugin)){
var pl_27167 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__27148,chunk__27149,count__27150,i__27151,pl_27167,vec__27155,k,plugin,seq__27148__$1,temp__5457__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_27167.call(null,msg_hist);
});})(seq__27148,chunk__27149,count__27150,i__27151,pl_27167,vec__27155,k,plugin,seq__27148__$1,temp__5457__auto__))
);
} else {
}


var G__27168 = cljs.core.next.call(null,seq__27148__$1);
var G__27169 = null;
var G__27170 = (0);
var G__27171 = (0);
seq__27148 = G__27168;
chunk__27149 = G__27169;
count__27150 = G__27170;
i__27151 = G__27171;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__27173 = arguments.length;
switch (G__27173) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__27174_27179 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__27175_27180 = null;
var count__27176_27181 = (0);
var i__27177_27182 = (0);
while(true){
if((i__27177_27182 < count__27176_27181)){
var msg_27183 = cljs.core._nth.call(null,chunk__27175_27180,i__27177_27182);
figwheel.client.socket.handle_incoming_message.call(null,msg_27183);


var G__27184 = seq__27174_27179;
var G__27185 = chunk__27175_27180;
var G__27186 = count__27176_27181;
var G__27187 = (i__27177_27182 + (1));
seq__27174_27179 = G__27184;
chunk__27175_27180 = G__27185;
count__27176_27181 = G__27186;
i__27177_27182 = G__27187;
continue;
} else {
var temp__5457__auto___27188 = cljs.core.seq.call(null,seq__27174_27179);
if(temp__5457__auto___27188){
var seq__27174_27189__$1 = temp__5457__auto___27188;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27174_27189__$1)){
var c__4318__auto___27190 = cljs.core.chunk_first.call(null,seq__27174_27189__$1);
var G__27191 = cljs.core.chunk_rest.call(null,seq__27174_27189__$1);
var G__27192 = c__4318__auto___27190;
var G__27193 = cljs.core.count.call(null,c__4318__auto___27190);
var G__27194 = (0);
seq__27174_27179 = G__27191;
chunk__27175_27180 = G__27192;
count__27176_27181 = G__27193;
i__27177_27182 = G__27194;
continue;
} else {
var msg_27195 = cljs.core.first.call(null,seq__27174_27189__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_27195);


var G__27196 = cljs.core.next.call(null,seq__27174_27189__$1);
var G__27197 = null;
var G__27198 = (0);
var G__27199 = (0);
seq__27174_27179 = G__27196;
chunk__27175_27180 = G__27197;
count__27176_27181 = G__27198;
i__27177_27182 = G__27199;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4501__auto__ = [];
var len__4498__auto___27204 = arguments.length;
var i__4499__auto___27205 = (0);
while(true){
if((i__4499__auto___27205 < len__4498__auto___27204)){
args__4501__auto__.push((arguments[i__4499__auto___27205]));

var G__27206 = (i__4499__auto___27205 + (1));
i__4499__auto___27205 = G__27206;
continue;
} else {
}
break;
}

var argseq__4502__auto__ = ((((0) < args__4501__auto__.length))?(new cljs.core.IndexedSeq(args__4501__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4502__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__27201){
var map__27202 = p__27201;
var map__27202__$1 = ((((!((map__27202 == null)))?(((((map__27202.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27202.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27202):map__27202);
var opts = map__27202__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq27200){
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27200));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e27207){if((e27207 instanceof Error)){
var e = e27207;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e27207;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__27208){
var map__27209 = p__27208;
var map__27209__$1 = ((((!((map__27209 == null)))?(((((map__27209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27209.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27209):map__27209);
var msg_name = cljs.core.get.call(null,map__27209__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1521564159817
