// Compiled by ClojureScript 1.9.946 {}
goog.provide('cmr.client.http.impl');
goog.require('cljs.core');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
goog.require('cmr.client.common.util');
/**
 * Default HTTP client options.
 */
cmr.client.http.impl.default_options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false,new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Accept","application/json"], null)], null);
/**
 * A transducer for use with the HTTP client that is used to transform inputs
 *   from Clojure data structures to JavaScript ones.
 */
cmr.client.http.impl.result_xducer = cljs.core.map.call(null,cljs.core.clj__GT_js);
/**
 * A transducer for use with the HTTP client that is used to extract the body
 *   from the inputs and transform it from a Clojure data structure to JavaScript
 *   one.
 */
cmr.client.http.impl.result_body_xducer = cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.clj__GT_js,new cljs.core.Keyword(null,"body","body",-2049205669)));
/**
 * Create a promise channel used by the third-party HTTP client library to
 *   receive responses.
 */
cmr.client.http.impl.create_channel = (function cmr$client$http$impl$create_channel(client){
if(cljs.core.truth_(cljs.core.get_in.call(null,client,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),new cljs.core.Keyword(null,"return-body?","return-body?",930286761)], null)))){
return cljs.core.async.promise_chan.call(null,cmr.client.http.impl.result_body_xducer);
} else {
return cljs.core.async.promise_chan.call(null,cmr.client.http.impl.result_xducer);
}
});
/**
 * This function is intended to be used with every call, giving the call the
 *   opportunity to override the HTTP client options saved when the client was
 *   instantiated.
 */
cmr.client.http.impl.create_http_options = (function cmr$client$http$impl$create_http_options(client,call_options){
return cljs.core.merge.call(null,cmr.client.http.impl.default_options,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"channel","channel",734187692),cmr.client.http.impl.create_channel.call(null,client)], null),new cljs.core.Keyword(null,"http-options","http-options",1919701946).cljs$core$IFn$_invoke$arity$1(client),call_options);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cmr.client.http.impl.HTTPClientData = (function (parent_client_options,http_options,__meta,__extmap,__hash){
this.parent_client_options = parent_client_options;
this.http_options = http_options;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
cmr.client.http.impl.HTTPClientData.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8095__auto__,k__8096__auto__){
var self__ = this;
var this__8095__auto____$1 = this;
return this__8095__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8096__auto__,null);
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8097__auto__,k10577,else__8098__auto__){
var self__ = this;
var this__8097__auto____$1 = this;
var G__10581 = k10577;
var G__10581__$1 = (((G__10581 instanceof cljs.core.Keyword))?G__10581.fqn:null);
switch (G__10581__$1) {
case "parent-client-options":
return self__.parent_client_options;

break;
case "http-options":
return self__.http_options;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k10577,else__8098__auto__);

}
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8109__auto__,writer__8110__auto__,opts__8111__auto__){
var self__ = this;
var this__8109__auto____$1 = this;
var pr_pair__8112__auto__ = ((function (this__8109__auto____$1){
return (function (keyval__8113__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8110__auto__,cljs.core.pr_writer,""," ","",opts__8111__auto__,keyval__8113__auto__);
});})(this__8109__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8110__auto__,pr_pair__8112__auto__,"#cmr.client.http.impl.HTTPClientData{",", ","}",opts__8111__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),self__.parent_client_options],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"http-options","http-options",1919701946),self__.http_options],null))], null),self__.__extmap));
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10576){
var self__ = this;
var G__10576__$1 = this;
return (new cljs.core.RecordIter((0),G__10576__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),new cljs.core.Keyword(null,"http-options","http-options",1919701946)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8093__auto__){
var self__ = this;
var this__8093__auto____$1 = this;
return self__.__meta;
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8090__auto__){
var self__ = this;
var this__8090__auto____$1 = this;
return (new cmr.client.http.impl.HTTPClientData(self__.parent_client_options,self__.http_options,self__.__meta,self__.__extmap,self__.__hash));
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8099__auto__){
var self__ = this;
var this__8099__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8091__auto__){
var self__ = this;
var this__8091__auto____$1 = this;
var h__7863__auto__ = self__.__hash;
if(!((h__7863__auto__ == null))){
return h__7863__auto__;
} else {
var h__7863__auto____$1 = ((function (h__7863__auto__,this__8091__auto____$1){
return (function (coll__8092__auto__){
return (1503257311 ^ cljs.core.hash_unordered_coll.call(null,coll__8092__auto__));
});})(h__7863__auto__,this__8091__auto____$1))
.call(null,this__8091__auto____$1);
self__.__hash = h__7863__auto____$1;

return h__7863__auto____$1;
}
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this10578,other10579){
var self__ = this;
var this10578__$1 = this;
return (!((other10579 == null))) && ((this10578__$1.constructor === other10579.constructor)) && (cljs.core._EQ_.call(null,this10578__$1.parent_client_options,other10579.parent_client_options)) && (cljs.core._EQ_.call(null,this10578__$1.http_options,other10579.http_options)) && (cljs.core._EQ_.call(null,this10578__$1.__extmap,other10579.__extmap));
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8104__auto__,k__8105__auto__){
var self__ = this;
var this__8104__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),null,new cljs.core.Keyword(null,"http-options","http-options",1919701946),null], null), null),k__8105__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8104__auto____$1),self__.__meta),k__8105__auto__);
} else {
return (new cmr.client.http.impl.HTTPClientData(self__.parent_client_options,self__.http_options,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8105__auto__)),null));
}
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8102__auto__,k__8103__auto__,G__10576){
var self__ = this;
var this__8102__auto____$1 = this;
var pred__10582 = cljs.core.keyword_identical_QMARK_;
var expr__10583 = k__8103__auto__;
if(cljs.core.truth_(pred__10582.call(null,new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),expr__10583))){
return (new cmr.client.http.impl.HTTPClientData(G__10576,self__.http_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__10582.call(null,new cljs.core.Keyword(null,"http-options","http-options",1919701946),expr__10583))){
return (new cmr.client.http.impl.HTTPClientData(self__.parent_client_options,G__10576,self__.__meta,self__.__extmap,null));
} else {
return (new cmr.client.http.impl.HTTPClientData(self__.parent_client_options,self__.http_options,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8103__auto__,G__10576),null));
}
}
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8107__auto__){
var self__ = this;
var this__8107__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),self__.parent_client_options],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"http-options","http-options",1919701946),self__.http_options],null))], null),self__.__extmap));
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8094__auto__,G__10576){
var self__ = this;
var this__8094__auto____$1 = this;
return (new cmr.client.http.impl.HTTPClientData(self__.parent_client_options,self__.http_options,G__10576,self__.__extmap,self__.__hash));
});

cmr.client.http.impl.HTTPClientData.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8100__auto__,entry__8101__auto__){
var self__ = this;
var this__8100__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8101__auto__)){
return this__8100__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8101__auto__,(0)),cljs.core._nth.call(null,entry__8101__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8100__auto____$1,entry__8101__auto__);
}
});

cmr.client.http.impl.HTTPClientData.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parent-client-options","parent-client-options",1465001739,null),new cljs.core.Symbol(null,"http-options","http-options",-734733823,null)], null);
});

cmr.client.http.impl.HTTPClientData.cljs$lang$type = true;

cmr.client.http.impl.HTTPClientData.cljs$lang$ctorPrSeq = (function (this__8133__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"cmr.client.http.impl/HTTPClientData");
});

cmr.client.http.impl.HTTPClientData.cljs$lang$ctorPrWriter = (function (this__8133__auto__,writer__8134__auto__){
return cljs.core._write.call(null,writer__8134__auto__,"cmr.client.http.impl/HTTPClientData");
});

cmr.client.http.impl.__GT_HTTPClientData = (function cmr$client$http$impl$__GT_HTTPClientData(parent_client_options,http_options){
return (new cmr.client.http.impl.HTTPClientData(parent_client_options,http_options,null,null,null));
});

cmr.client.http.impl.map__GT_HTTPClientData = (function cmr$client$http$impl$map__GT_HTTPClientData(G__10580){
return (new cmr.client.http.impl.HTTPClientData(new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788).cljs$core$IFn$_invoke$arity$1(G__10580),new cljs.core.Keyword(null,"http-options","http-options",1919701946).cljs$core$IFn$_invoke$arity$1(G__10580),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__10580,new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),new cljs.core.Keyword(null,"http-options","http-options",1919701946))),null));
});

/**
 * Perform an HTTP `GET`.
 */
cmr.client.http.impl.get = (function cmr$client$http$impl$get(this$,url,options){
return cljs_http.client.get.call(null,url,cmr.client.http.impl.create_http_options.call(null,this$,options));
});
/**
 * Perform an HTTP `HEAD`.
 */
cmr.client.http.impl.head = (function cmr$client$http$impl$head(this$,url,options){
return cljs_http.client.head.call(null,url,cmr.client.http.impl.create_http_options.call(null,this$,options));
});
cmr.client.http.impl.put = (function cmr$client$http$impl$put(this$,url,data,options){
return cljs_http.client.put.call(null,url,cljs.core.merge.call(null,cmr.client.http.impl.create_http_options.call(null,this$,options),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),data], null)));
});
cmr.client.http.impl.post = (function cmr$client$http$impl$post(this$,url,data,options){
return cljs_http.client.post.call(null,url,cljs.core.merge.call(null,cmr.client.http.impl.create_http_options.call(null,this$,options),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),data], null)));
});

//# sourceMappingURL=impl.js.map
