// Compiled by ClojureScript 1.9.946 {}
goog.provide('cmr.client.common.util');
goog.require('cljs.core');
goog.require('cmr.client.common.const$');
goog.require('cljs.core.async');
/**
 * Get the default endpoint for a given CMR service. If an environment type
 *   is provided, override the default and get the endpoint for that type.
 */
cmr.client.common.util.get_endpoint = (function cmr$client$common$util$get_endpoint(var_args){
var G__10478 = arguments.length;
switch (G__10478) {
case 1:
return cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$1 = (function (service_key){
return service_key.call(null,cmr.client.common.const$.default_endpoints);
});

cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$2 = (function (environment_type,service_key){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(environment_type.call(null,cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[service_key,environment_type.call(null,cmr.client.common.const$.deployment_type)],null))))].join('');
});

cmr.client.common.util.get_endpoint.cljs$lang$maxFixedArity = 2;

/**
 * Get the default endpoint; if the client options specify an endpoint, then
 *   use that one.
 */
cmr.client.common.util.get_default_endpoint = (function cmr$client$common$util$get_default_endpoint(options,service_key){
var or__7407__auto__ = new cljs.core.Keyword(null,"endpoint","endpoint",447890044).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return cmr.client.common.util.get_endpoint.call(null,service_key);
}
});
/**
 * Use the token that is defined in the options data structure; if one is not
 *   provided, a null value for token will be used.
 */
cmr.client.common.util.get_default_token = (function cmr$client$common$util$get_default_token(options){
return new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(options);
});
/**
 * Given a string or a deployment environment and a service key, retur the
 *   service endpoint.
 */
cmr.client.common.util.parse_endpoint = (function cmr$client$common$util$parse_endpoint(var_args){
var G__10481 = arguments.length;
switch (G__10481) {
case 1:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1 = (function (endpoint){
return cmr.client.common.util.parse_endpoint.call(null,endpoint,null);
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2 = (function (endpoint,service_key){
if(typeof endpoint === 'string'){
return endpoint;
} else {
return cmr.client.common.util.get_endpoint.call(null,endpoint,service_key);
}
});

cmr.client.common.util.parse_endpoint.cljs$lang$maxFixedArity = 2;

/**
 * A utility function for running a callback function when a channel receives
 *   data.
 */
cmr.client.common.util.with_callback = (function cmr$client$common$util$with_callback(chan,callback){
var c__10399__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10399__auto__){
return (function (){
var f__10400__auto__ = (function (){var switch__10376__auto__ = ((function (c__10399__auto__){
return (function (state_10495){
var state_val_10496 = (state_10495[(1)]);
if((state_val_10496 === (1))){
var state_10495__$1 = state_10495;
var statearr_10497_10508 = state_10495__$1;
(statearr_10497_10508[(2)] = null);

(statearr_10497_10508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10496 === (2))){
var state_10495__$1 = state_10495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10495__$1,(4),chan);
} else {
if((state_val_10496 === (3))){
var inst_10493 = (state_10495[(2)]);
var state_10495__$1 = state_10495;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10495__$1,inst_10493);
} else {
if((state_val_10496 === (4))){
var inst_10485 = (state_10495[(7)]);
var inst_10485__$1 = (state_10495[(2)]);
var state_10495__$1 = (function (){var statearr_10498 = state_10495;
(statearr_10498[(7)] = inst_10485__$1);

return statearr_10498;
})();
if(cljs.core.truth_(inst_10485__$1)){
var statearr_10499_10509 = state_10495__$1;
(statearr_10499_10509[(1)] = (5));

} else {
var statearr_10500_10510 = state_10495__$1;
(statearr_10500_10510[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10496 === (5))){
var inst_10485 = (state_10495[(7)]);
var inst_10487 = callback.call(null,inst_10485);
var state_10495__$1 = state_10495;
var statearr_10501_10511 = state_10495__$1;
(statearr_10501_10511[(2)] = inst_10487);

(statearr_10501_10511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10496 === (6))){
var state_10495__$1 = state_10495;
var statearr_10502_10512 = state_10495__$1;
(statearr_10502_10512[(2)] = null);

(statearr_10502_10512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10496 === (7))){
var inst_10491 = (state_10495[(2)]);
var state_10495__$1 = state_10495;
var statearr_10503_10513 = state_10495__$1;
(statearr_10503_10513[(2)] = inst_10491);

(statearr_10503_10513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__10399__auto__))
;
return ((function (switch__10376__auto__,c__10399__auto__){
return (function() {
var cmr$client$common$util$with_callback_$_state_machine__10377__auto__ = null;
var cmr$client$common$util$with_callback_$_state_machine__10377__auto____0 = (function (){
var statearr_10504 = [null,null,null,null,null,null,null,null];
(statearr_10504[(0)] = cmr$client$common$util$with_callback_$_state_machine__10377__auto__);

(statearr_10504[(1)] = (1));

return statearr_10504;
});
var cmr$client$common$util$with_callback_$_state_machine__10377__auto____1 = (function (state_10495){
while(true){
var ret_value__10378__auto__ = (function (){try{while(true){
var result__10379__auto__ = switch__10376__auto__.call(null,state_10495);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10379__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10379__auto__;
}
break;
}
}catch (e10505){if((e10505 instanceof Object)){
var ex__10380__auto__ = e10505;
var statearr_10506_10514 = state_10495;
(statearr_10506_10514[(5)] = ex__10380__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10495);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10505;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10378__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10515 = state_10495;
state_10495 = G__10515;
continue;
} else {
return ret_value__10378__auto__;
}
break;
}
});
cmr$client$common$util$with_callback_$_state_machine__10377__auto__ = function(state_10495){
switch(arguments.length){
case 0:
return cmr$client$common$util$with_callback_$_state_machine__10377__auto____0.call(this);
case 1:
return cmr$client$common$util$with_callback_$_state_machine__10377__auto____1.call(this,state_10495);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cmr$client$common$util$with_callback_$_state_machine__10377__auto__.cljs$core$IFn$_invoke$arity$0 = cmr$client$common$util$with_callback_$_state_machine__10377__auto____0;
cmr$client$common$util$with_callback_$_state_machine__10377__auto__.cljs$core$IFn$_invoke$arity$1 = cmr$client$common$util$with_callback_$_state_machine__10377__auto____1;
return cmr$client$common$util$with_callback_$_state_machine__10377__auto__;
})()
;})(switch__10376__auto__,c__10399__auto__))
})();
var state__10401__auto__ = (function (){var statearr_10507 = f__10400__auto__.call(null);
(statearr_10507[(6)] = c__10399__auto__);

return statearr_10507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10401__auto__);
});})(c__10399__auto__))
);

return c__10399__auto__;
});
goog.exportSymbol('cmr.client.common.util.with_callback', cmr.client.common.util.with_callback);
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `service-type` - must be one of the supported service types, notably
 *  `:ingest`, `:search`, or `:access-control`
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 *   * `options-fn` - a functin which creates the client client options, including
 *  basic defaults, for the implementation; it should be a function that in
 *  turn calls a `CMR*ClientOpions` constructor
 *   * `http-client-constructor` - a function that instrantiates the CMR HTTP
 *  client used by all CMR service type clients (different for Clojure and
 *  ClojureScript)
 * 
 *   This docstring is a bit dense; for more clarity, be sure to view the calls
 *   made to this function in both the Clojure and ClojureScript clients.
 */
cmr.client.common.util.create_service_client_constructor = (function cmr$client$common$util$create_service_client_constructor(service_type,client_constructor_var,client_data_constructor,options_fn,http_client_constructor){
return (function() {
var G__10516 = null;
var G__10516__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__10516__1 = (function (options){
return client_constructor_var.call(null,options,cljs.core.PersistentArrayMap.EMPTY);
});
var G__10516__2 = (function (options,http_options){
var endpoint = cmr.client.common.util.get_default_endpoint.call(null,options,service_type);
var token = cmr.client.common.util.get_default_token.call(null,options);
var client_options = options_fn.call(null,options);
var http_client = http_client_constructor.call(null,client_options,http_options);
return client_data_constructor.call(null,cmr.client.common.util.parse_endpoint.call(null,endpoint,service_type),token,client_options,http_client);
});
G__10516 = function(options,http_options){
switch(arguments.length){
case 0:
return G__10516__0.call(this);
case 1:
return G__10516__1.call(this,options);
case 2:
return G__10516__2.call(this,options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10516.cljs$core$IFn$_invoke$arity$0 = G__10516__0;
G__10516.cljs$core$IFn$_invoke$arity$1 = G__10516__1;
G__10516.cljs$core$IFn$_invoke$arity$2 = G__10516__2;
return G__10516;
})()
});
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 */
cmr.client.common.util.create_http_client_constructor = (function cmr$client$common$util$create_http_client_constructor(client_constructor_var,client_data_constructor){
return (function() {
var G__10517 = null;
var G__10517__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__10517__1 = (function (http_options){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY,http_options);
});
var G__10517__2 = (function (parent_client_options,http_options){
return client_data_constructor.call(null,parent_client_options,http_options);
});
G__10517 = function(parent_client_options,http_options){
switch(arguments.length){
case 0:
return G__10517__0.call(this);
case 1:
return G__10517__1.call(this,parent_client_options);
case 2:
return G__10517__2.call(this,parent_client_options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10517.cljs$core$IFn$_invoke$arity$0 = G__10517__0;
G__10517.cljs$core$IFn$_invoke$arity$1 = G__10517__1;
G__10517.cljs$core$IFn$_invoke$arity$2 = G__10517__2;
return G__10517;
})()
});
var ret__8732__auto___10518 = /**
 * Import a single function or var:
 *   ```
 *   (import-def a b) => (def b a/b)
 *   ```
 */
cmr.client.common.util.import_def = (function cmr$client$common$util$import_def(_AMPERSAND_form,_AMPERSAND_env,from_ns,def_name){
var from_sym_SHARP_ = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(from_ns)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(def_name)].join(''));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__8361__auto__ = def_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8361__auto__);
})(),(function (){var x__8361__auto__ = from_sym_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8361__auto__);
})())));
});
cmr.client.common.util.import_def.cljs$lang$macro = true;

var ret__8732__auto___10531 = (function (){
/**
 * Import multiple defs from multiple namespaces.
 * 
 * This works for vars and functions, but not macros. Uses the same syntax as
 * `potemkin.namespaces/import-vars`, namely:
 * ```
 * (import-vars
 *   [m.n.ns1 a b]
 *   [x.y.ns2 d e f])
 *   ```
 */
cmr.client.common.util.import_vars = (function cmr$client$common$util$import_vars(var_args){
var args__8693__auto__ = [];
var len__8686__auto___10532 = arguments.length;
var i__8687__auto___10533 = (0);
while(true){
if((i__8687__auto___10533 < len__8686__auto___10532)){
args__8693__auto__.push((arguments[i__8687__auto___10533]));

var G__10534 = (i__8687__auto___10533 + (1));
i__8687__auto___10533 = G__10534;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((2) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((2)),(0),null)):null);
return cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8694__auto__);
});

cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,imports){
var expanded_imports = (function (){var iter__8289__auto__ = (function cmr$client$common$util$iter__10522(s__10523){
return (new cljs.core.LazySeq(null,(function (){
var s__10523__$1 = s__10523;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__10523__$1);
if(temp__5457__auto__){
var xs__6012__auto__ = temp__5457__auto__;
var vec__10528 = cljs.core.first.call(null,xs__6012__auto__);
var seq__10529 = cljs.core.seq.call(null,vec__10528);
var first__10530 = cljs.core.first.call(null,seq__10529);
var seq__10529__$1 = cljs.core.next.call(null,seq__10529);
var from_ns = first__10530;
var defs = seq__10529__$1;
var iterys__8285__auto__ = ((function (s__10523__$1,vec__10528,seq__10529,first__10530,seq__10529__$1,from_ns,defs,xs__6012__auto__,temp__5457__auto__){
return (function cmr$client$common$util$iter__10522_$_iter__10524(s__10525){
return (new cljs.core.LazySeq(null,((function (s__10523__$1,vec__10528,seq__10529,first__10530,seq__10529__$1,from_ns,defs,xs__6012__auto__,temp__5457__auto__){
return (function (){
var s__10525__$1 = s__10525;
while(true){
var temp__5457__auto____$1 = cljs.core.seq.call(null,s__10525__$1);
if(temp__5457__auto____$1){
var s__10525__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10525__$2)){
var c__8287__auto__ = cljs.core.chunk_first.call(null,s__10525__$2);
var size__8288__auto__ = cljs.core.count.call(null,c__8287__auto__);
var b__10527 = cljs.core.chunk_buffer.call(null,size__8288__auto__);
if((function (){var i__10526 = (0);
while(true){
if((i__10526 < size__8288__auto__)){
var d = cljs.core._nth.call(null,c__8287__auto__,i__10526);
cljs.core.chunk_append.call(null,b__10527,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cmr.client.common.util","import-def","cmr.client.common.util/import-def",708150912,null)),(function (){var x__8361__auto__ = from_ns;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8361__auto__);
})(),(function (){var x__8361__auto__ = d;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8361__auto__);
})()))));

var G__10535 = (i__10526 + (1));
i__10526 = G__10535;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10527),cmr$client$common$util$iter__10522_$_iter__10524.call(null,cljs.core.chunk_rest.call(null,s__10525__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10527),null);
}
} else {
var d = cljs.core.first.call(null,s__10525__$2);
return cljs.core.cons.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cmr.client.common.util","import-def","cmr.client.common.util/import-def",708150912,null)),(function (){var x__8361__auto__ = from_ns;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8361__auto__);
})(),(function (){var x__8361__auto__ = d;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8361__auto__);
})()))),cmr$client$common$util$iter__10522_$_iter__10524.call(null,cljs.core.rest.call(null,s__10525__$2)));
}
} else {
return null;
}
break;
}
});})(s__10523__$1,vec__10528,seq__10529,first__10530,seq__10529__$1,from_ns,defs,xs__6012__auto__,temp__5457__auto__))
,null,null));
});})(s__10523__$1,vec__10528,seq__10529,first__10530,seq__10529__$1,from_ns,defs,xs__6012__auto__,temp__5457__auto__))
;
var fs__8286__auto__ = cljs.core.seq.call(null,iterys__8285__auto__.call(null,defs));
if(fs__8286__auto__){
return cljs.core.concat.call(null,fs__8286__auto__,cmr$client$common$util$iter__10522.call(null,cljs.core.rest.call(null,s__10523__$1)));
} else {
var G__10536 = cljs.core.rest.call(null,s__10523__$1);
s__10523__$1 = G__10536;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8289__auto__.call(null,imports);
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),expanded_imports)));
});

cmr.client.common.util.import_vars.cljs$lang$maxFixedArity = (2);

cmr.client.common.util.import_vars.cljs$lang$applyTo = (function (seq10519){
var G__10520 = cljs.core.first.call(null,seq10519);
var seq10519__$1 = cljs.core.next.call(null,seq10519);
var G__10521 = cljs.core.first.call(null,seq10519__$1);
var seq10519__$2 = cljs.core.next.call(null,seq10519__$1);
return cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic(G__10520,G__10521,seq10519__$2);
});

return null;
})()
;
cmr.client.common.util.import_vars.cljs$lang$macro = true;


//# sourceMappingURL=util.js.map
