// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__7395__auto__ = v;
if(cljs.core.truth_(and__7395__auto__)){
return (v > (0));
} else {
return and__7395__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__13226_SHARP_,p2__13225_SHARP_){
var vec__13227 = clojure.string.split.call(null,p2__13225_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__13227,(0),null);
var v = cljs.core.nth.call(null,vec__13227,(1),null);
return cljs.core.assoc.call(null,p1__13226_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__13230_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__13230_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__13231){
var vec__13232 = p__13231;
var k = cljs.core.nth.call(null,vec__13232,(0),null);
var v = cljs.core.nth.call(null,vec__13232,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__13235_SHARP_){
return ["\\",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__13235_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__7395__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__7395__auto__){
var and__7395__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__7395__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__7395__auto____$1;
}
} else {
return and__7395__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__5455__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__13236_SHARP_){
return cljs_http.client.decode_body.call(null,p1__13236_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13243 = arguments.length;
var i__8687__auto___13244 = (0);
while(true){
if((i__8687__auto___13244 < len__8686__auto___13243)){
args__8693__auto__.push((arguments[i__8687__auto___13244]));

var G__13245 = (i__8687__auto___13244 + (1));
i__8687__auto___13244 = G__13245;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__13239){
var vec__13240 = p__13239;
var default_headers = cljs.core.nth.call(null,vec__13240,(0),null);
return ((function (vec__13240,default_headers){
return (function (request){
var temp__5455__auto__ = (function (){var or__7407__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var default_headers__$1 = temp__5455__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__13240,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq13237){
var G__13238 = cljs.core.first.call(null,seq13237);
var seq13237__$1 = cljs.core.next.call(null,seq13237);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__13238,seq13237__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13252 = arguments.length;
var i__8687__auto___13253 = (0);
while(true){
if((i__8687__auto___13253 < len__8686__auto___13252)){
args__8693__auto__.push((arguments[i__8687__auto___13253]));

var G__13254 = (i__8687__auto___13253 + (1));
i__8687__auto___13253 = G__13254;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__13248){
var vec__13249 = p__13248;
var accept = cljs.core.nth.call(null,vec__13249,(0),null);
return ((function (vec__13249,accept){
return (function (request){
var temp__5455__auto__ = (function (){var or__7407__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var accept__$1 = temp__5455__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__13249,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq13246){
var G__13247 = cljs.core.first.call(null,seq13246);
var seq13246__$1 = cljs.core.next.call(null,seq13246);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__13247,seq13246__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13261 = arguments.length;
var i__8687__auto___13262 = (0);
while(true){
if((i__8687__auto___13262 < len__8686__auto___13261)){
args__8693__auto__.push((arguments[i__8687__auto___13262]));

var G__13263 = (i__8687__auto___13262 + (1));
i__8687__auto___13262 = G__13263;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__13257){
var vec__13258 = p__13257;
var content_type = cljs.core.nth.call(null,vec__13258,(0),null);
return ((function (vec__13258,content_type){
return (function (request){
var temp__5455__auto__ = (function (){var or__7407__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var content_type__$1 = temp__5455__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__13258,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq13255){
var G__13256 = cljs.core.first.call(null,seq13255);
var seq13255__$1 = cljs.core.next.call(null,seq13255);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__13256,seq13255__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__5455__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var map__13264 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__13264__$1 = ((((!((map__13264 == null)))?((((map__13264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13264.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13264):map__13264);
var encoding = cljs.core.get.call(null,map__13264__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__13264__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__13268 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__13268__$1 = ((((!((map__13268 == null)))?((((map__13268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13268.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13268):map__13268);
var decoding = cljs.core.get.call(null,map__13268__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__13268__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__13268,map__13268__$1,decoding,decoding_opts){
return (function (p1__13266_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__13266_SHARP_,decoding,decoding_opts);
});})(map__13268,map__13268__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__13268,map__13268__$1,decoding,decoding_opts,transit_decode){
return (function (p1__13267_SHARP_){
return cljs_http.client.decode_body.call(null,p1__13267_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__13268,map__13268__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__5455__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__13270_SHARP_){
return cljs_http.client.decode_body.call(null,p1__13270_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__13271){
var map__13272 = p__13271;
var map__13272__$1 = ((((!((map__13272 == null)))?((((map__13272.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13272.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13272):map__13272);
var req = map__13272__$1;
var query_params = cljs.core.get.call(null,map__13272__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__13274){
var map__13275 = p__13274;
var map__13275__$1 = ((((!((map__13275 == null)))?((((map__13275.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13275.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13275):map__13275);
var request = map__13275__$1;
var form_params = cljs.core.get.call(null,map__13275__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__13275__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__13275__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__7395__auto__ = form_params;
if(cljs.core.truth_(and__7395__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__7395__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__13277_13287 = cljs.core.seq.call(null,params);
var chunk__13278_13288 = null;
var count__13279_13289 = (0);
var i__13280_13290 = (0);
while(true){
if((i__13280_13290 < count__13279_13289)){
var vec__13281_13291 = cljs.core._nth.call(null,chunk__13278_13288,i__13280_13290);
var k_13292 = cljs.core.nth.call(null,vec__13281_13291,(0),null);
var v_13293 = cljs.core.nth.call(null,vec__13281_13291,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_13293)){
form_data.append(cljs.core.name.call(null,k_13292),cljs.core.first.call(null,v_13293),cljs.core.second.call(null,v_13293));
} else {
form_data.append(cljs.core.name.call(null,k_13292),v_13293);
}

var G__13294 = seq__13277_13287;
var G__13295 = chunk__13278_13288;
var G__13296 = count__13279_13289;
var G__13297 = (i__13280_13290 + (1));
seq__13277_13287 = G__13294;
chunk__13278_13288 = G__13295;
count__13279_13289 = G__13296;
i__13280_13290 = G__13297;
continue;
} else {
var temp__5457__auto___13298 = cljs.core.seq.call(null,seq__13277_13287);
if(temp__5457__auto___13298){
var seq__13277_13299__$1 = temp__5457__auto___13298;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13277_13299__$1)){
var c__8338__auto___13300 = cljs.core.chunk_first.call(null,seq__13277_13299__$1);
var G__13301 = cljs.core.chunk_rest.call(null,seq__13277_13299__$1);
var G__13302 = c__8338__auto___13300;
var G__13303 = cljs.core.count.call(null,c__8338__auto___13300);
var G__13304 = (0);
seq__13277_13287 = G__13301;
chunk__13278_13288 = G__13302;
count__13279_13289 = G__13303;
i__13280_13290 = G__13304;
continue;
} else {
var vec__13284_13305 = cljs.core.first.call(null,seq__13277_13299__$1);
var k_13306 = cljs.core.nth.call(null,vec__13284_13305,(0),null);
var v_13307 = cljs.core.nth.call(null,vec__13284_13305,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_13307)){
form_data.append(cljs.core.name.call(null,k_13306),cljs.core.first.call(null,v_13307),cljs.core.second.call(null,v_13307));
} else {
form_data.append(cljs.core.name.call(null,k_13306),v_13307);
}

var G__13308 = cljs.core.next.call(null,seq__13277_13299__$1);
var G__13309 = null;
var G__13310 = (0);
var G__13311 = (0);
seq__13277_13287 = G__13308;
chunk__13278_13288 = G__13309;
count__13279_13289 = G__13310;
i__13280_13290 = G__13311;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__13312){
var map__13313 = p__13312;
var map__13313__$1 = ((((!((map__13313 == null)))?((((map__13313.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13313.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13313):map__13313);
var request = map__13313__$1;
var multipart_params = cljs.core.get.call(null,map__13313__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__13313__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__7395__auto__ = multipart_params;
if(cljs.core.truth_(and__7395__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__7395__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__5455__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__5455__auto__)){
var m = temp__5455__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__13315_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__13315_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__13317){
var map__13318 = p__13317;
var map__13318__$1 = ((((!((map__13318 == null)))?((((map__13318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13318.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13318):map__13318);
var req = map__13318__$1;
var query_params = cljs.core.get.call(null,map__13318__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__5455__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__5455__auto__)){
var spec = temp__5455__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__5455__auto__,map__13318,map__13318__$1,req,query_params){
return (function (p1__13316_SHARP_){
return cljs.core.merge.call(null,p1__13316_SHARP_,query_params);
});})(spec,temp__5455__auto__,map__13318,map__13318__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13326 = arguments.length;
var i__8687__auto___13327 = (0);
while(true){
if((i__8687__auto___13327 < len__8686__auto___13326)){
args__8693__auto__.push((arguments[i__8687__auto___13327]));

var G__13328 = (i__8687__auto___13327 + (1));
i__8687__auto___13327 = G__13328;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__13322){
var vec__13323 = p__13322;
var credentials = cljs.core.nth.call(null,vec__13323,(0),null);
return ((function (vec__13323,credentials){
return (function (req){
var credentials__$1 = (function (){var or__7407__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__13323,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq13320){
var G__13321 = cljs.core.first.call(null,seq13320);
var seq13320__$1 = cljs.core.next.call(null,seq13320);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__13321,seq13320__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__5455__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__5455__auto__)){
var oauth_token = temp__5455__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__5455__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var custom_channel = temp__5455__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13335 = arguments.length;
var i__8687__auto___13336 = (0);
while(true){
if((i__8687__auto___13336 < len__8686__auto___13335)){
args__8693__auto__.push((arguments[i__8687__auto___13336]));

var G__13337 = (i__8687__auto___13336 + (1));
i__8687__auto___13336 = G__13337;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13331){
var vec__13332 = p__13331;
var req = cljs.core.nth.call(null,vec__13332,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq13329){
var G__13330 = cljs.core.first.call(null,seq13329);
var seq13329__$1 = cljs.core.next.call(null,seq13329);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__13330,seq13329__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13344 = arguments.length;
var i__8687__auto___13345 = (0);
while(true){
if((i__8687__auto___13345 < len__8686__auto___13344)){
args__8693__auto__.push((arguments[i__8687__auto___13345]));

var G__13346 = (i__8687__auto___13345 + (1));
i__8687__auto___13345 = G__13346;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13340){
var vec__13341 = p__13340;
var req = cljs.core.nth.call(null,vec__13341,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq13338){
var G__13339 = cljs.core.first.call(null,seq13338);
var seq13338__$1 = cljs.core.next.call(null,seq13338);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__13339,seq13338__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13353 = arguments.length;
var i__8687__auto___13354 = (0);
while(true){
if((i__8687__auto___13354 < len__8686__auto___13353)){
args__8693__auto__.push((arguments[i__8687__auto___13354]));

var G__13355 = (i__8687__auto___13354 + (1));
i__8687__auto___13354 = G__13355;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13349){
var vec__13350 = p__13349;
var req = cljs.core.nth.call(null,vec__13350,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq13347){
var G__13348 = cljs.core.first.call(null,seq13347);
var seq13347__$1 = cljs.core.next.call(null,seq13347);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__13348,seq13347__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13362 = arguments.length;
var i__8687__auto___13363 = (0);
while(true){
if((i__8687__auto___13363 < len__8686__auto___13362)){
args__8693__auto__.push((arguments[i__8687__auto___13363]));

var G__13364 = (i__8687__auto___13363 + (1));
i__8687__auto___13363 = G__13364;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13358){
var vec__13359 = p__13358;
var req = cljs.core.nth.call(null,vec__13359,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq13356){
var G__13357 = cljs.core.first.call(null,seq13356);
var seq13356__$1 = cljs.core.next.call(null,seq13356);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__13357,seq13356__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13371 = arguments.length;
var i__8687__auto___13372 = (0);
while(true){
if((i__8687__auto___13372 < len__8686__auto___13371)){
args__8693__auto__.push((arguments[i__8687__auto___13372]));

var G__13373 = (i__8687__auto___13372 + (1));
i__8687__auto___13372 = G__13373;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13367){
var vec__13368 = p__13367;
var req = cljs.core.nth.call(null,vec__13368,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq13365){
var G__13366 = cljs.core.first.call(null,seq13365);
var seq13365__$1 = cljs.core.next.call(null,seq13365);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__13366,seq13365__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13380 = arguments.length;
var i__8687__auto___13381 = (0);
while(true){
if((i__8687__auto___13381 < len__8686__auto___13380)){
args__8693__auto__.push((arguments[i__8687__auto___13381]));

var G__13382 = (i__8687__auto___13381 + (1));
i__8687__auto___13381 = G__13382;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13376){
var vec__13377 = p__13376;
var req = cljs.core.nth.call(null,vec__13377,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq13374){
var G__13375 = cljs.core.first.call(null,seq13374);
var seq13374__$1 = cljs.core.next.call(null,seq13374);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__13375,seq13374__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13389 = arguments.length;
var i__8687__auto___13390 = (0);
while(true){
if((i__8687__auto___13390 < len__8686__auto___13389)){
args__8693__auto__.push((arguments[i__8687__auto___13390]));

var G__13391 = (i__8687__auto___13390 + (1));
i__8687__auto___13390 = G__13391;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13385){
var vec__13386 = p__13385;
var req = cljs.core.nth.call(null,vec__13386,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq13383){
var G__13384 = cljs.core.first.call(null,seq13383);
var seq13383__$1 = cljs.core.next.call(null,seq13383);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__13384,seq13383__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13398 = arguments.length;
var i__8687__auto___13399 = (0);
while(true){
if((i__8687__auto___13399 < len__8686__auto___13398)){
args__8693__auto__.push((arguments[i__8687__auto___13399]));

var G__13400 = (i__8687__auto___13399 + (1));
i__8687__auto___13399 = G__13400;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13394){
var vec__13395 = p__13394;
var req = cljs.core.nth.call(null,vec__13395,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq13392){
var G__13393 = cljs.core.first.call(null,seq13392);
var seq13392__$1 = cljs.core.next.call(null,seq13392);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__13393,seq13392__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__8693__auto__ = [];
var len__8686__auto___13407 = arguments.length;
var i__8687__auto___13408 = (0);
while(true){
if((i__8687__auto___13408 < len__8686__auto___13407)){
args__8693__auto__.push((arguments[i__8687__auto___13408]));

var G__13409 = (i__8687__auto___13408 + (1));
i__8687__auto___13408 = G__13409;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13403){
var vec__13404 = p__13403;
var req = cljs.core.nth.call(null,vec__13404,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq13401){
var G__13402 = cljs.core.first.call(null,seq13401);
var seq13401__$1 = cljs.core.next.call(null,seq13401);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__13402,seq13401__$1);
});


//# sourceMappingURL=client.js.map
