// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28347__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28347__auto__){
return or__28347__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28347__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
var or__28347__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28347__auto____$1)){
return or__28347__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__42716_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__42716_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__42717 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__42718 = null;
var count__42719 = (0);
var i__42720 = (0);
while(true){
if((i__42720 < count__42719)){
var n = cljs.core._nth.call(null,chunk__42718,i__42720);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__42721 = seq__42717;
var G__42722 = chunk__42718;
var G__42723 = count__42719;
var G__42724 = (i__42720 + (1));
seq__42717 = G__42721;
chunk__42718 = G__42722;
count__42719 = G__42723;
i__42720 = G__42724;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__42717);
if(temp__4657__auto__){
var seq__42717__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42717__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__42717__$1);
var G__42725 = cljs.core.chunk_rest.call(null,seq__42717__$1);
var G__42726 = c__29186__auto__;
var G__42727 = cljs.core.count.call(null,c__29186__auto__);
var G__42728 = (0);
seq__42717 = G__42725;
chunk__42718 = G__42726;
count__42719 = G__42727;
i__42720 = G__42728;
continue;
} else {
var n = cljs.core.first.call(null,seq__42717__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__42729 = cljs.core.next.call(null,seq__42717__$1);
var G__42730 = null;
var G__42731 = (0);
var G__42732 = (0);
seq__42717 = G__42729;
chunk__42718 = G__42730;
count__42719 = G__42731;
i__42720 = G__42732;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__42742_42750 = cljs.core.seq.call(null,deps);
var chunk__42743_42751 = null;
var count__42744_42752 = (0);
var i__42745_42753 = (0);
while(true){
if((i__42745_42753 < count__42744_42752)){
var dep_42754 = cljs.core._nth.call(null,chunk__42743_42751,i__42745_42753);
topo_sort_helper_STAR_.call(null,dep_42754,(depth + (1)),state);

var G__42755 = seq__42742_42750;
var G__42756 = chunk__42743_42751;
var G__42757 = count__42744_42752;
var G__42758 = (i__42745_42753 + (1));
seq__42742_42750 = G__42755;
chunk__42743_42751 = G__42756;
count__42744_42752 = G__42757;
i__42745_42753 = G__42758;
continue;
} else {
var temp__4657__auto___42759 = cljs.core.seq.call(null,seq__42742_42750);
if(temp__4657__auto___42759){
var seq__42742_42760__$1 = temp__4657__auto___42759;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42742_42760__$1)){
var c__29186__auto___42761 = cljs.core.chunk_first.call(null,seq__42742_42760__$1);
var G__42762 = cljs.core.chunk_rest.call(null,seq__42742_42760__$1);
var G__42763 = c__29186__auto___42761;
var G__42764 = cljs.core.count.call(null,c__29186__auto___42761);
var G__42765 = (0);
seq__42742_42750 = G__42762;
chunk__42743_42751 = G__42763;
count__42744_42752 = G__42764;
i__42745_42753 = G__42765;
continue;
} else {
var dep_42766 = cljs.core.first.call(null,seq__42742_42760__$1);
topo_sort_helper_STAR_.call(null,dep_42766,(depth + (1)),state);

var G__42767 = cljs.core.next.call(null,seq__42742_42760__$1);
var G__42768 = null;
var G__42769 = (0);
var G__42770 = (0);
seq__42742_42750 = G__42767;
chunk__42743_42751 = G__42768;
count__42744_42752 = G__42769;
i__42745_42753 = G__42770;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__42746){
var vec__42747 = p__42746;
var seq__42748 = cljs.core.seq.call(null,vec__42747);
var first__42749 = cljs.core.first.call(null,seq__42748);
var seq__42748__$1 = cljs.core.next.call(null,seq__42748);
var x = first__42749;
var xs = seq__42748__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__42747,seq__42748,first__42749,seq__42748__$1,x,xs,get_deps__$1){
return (function (p1__42733_SHARP_){
return clojure.set.difference.call(null,p1__42733_SHARP_,x);
});})(vec__42747,seq__42748,first__42749,seq__42748__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__42771 = cljs.core.seq.call(null,provides);
var chunk__42772 = null;
var count__42773 = (0);
var i__42774 = (0);
while(true){
if((i__42774 < count__42773)){
var prov = cljs.core._nth.call(null,chunk__42772,i__42774);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__42775_42783 = cljs.core.seq.call(null,requires);
var chunk__42776_42784 = null;
var count__42777_42785 = (0);
var i__42778_42786 = (0);
while(true){
if((i__42778_42786 < count__42777_42785)){
var req_42787 = cljs.core._nth.call(null,chunk__42776_42784,i__42778_42786);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_42787,prov);

var G__42788 = seq__42775_42783;
var G__42789 = chunk__42776_42784;
var G__42790 = count__42777_42785;
var G__42791 = (i__42778_42786 + (1));
seq__42775_42783 = G__42788;
chunk__42776_42784 = G__42789;
count__42777_42785 = G__42790;
i__42778_42786 = G__42791;
continue;
} else {
var temp__4657__auto___42792 = cljs.core.seq.call(null,seq__42775_42783);
if(temp__4657__auto___42792){
var seq__42775_42793__$1 = temp__4657__auto___42792;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42775_42793__$1)){
var c__29186__auto___42794 = cljs.core.chunk_first.call(null,seq__42775_42793__$1);
var G__42795 = cljs.core.chunk_rest.call(null,seq__42775_42793__$1);
var G__42796 = c__29186__auto___42794;
var G__42797 = cljs.core.count.call(null,c__29186__auto___42794);
var G__42798 = (0);
seq__42775_42783 = G__42795;
chunk__42776_42784 = G__42796;
count__42777_42785 = G__42797;
i__42778_42786 = G__42798;
continue;
} else {
var req_42799 = cljs.core.first.call(null,seq__42775_42793__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_42799,prov);

var G__42800 = cljs.core.next.call(null,seq__42775_42793__$1);
var G__42801 = null;
var G__42802 = (0);
var G__42803 = (0);
seq__42775_42783 = G__42800;
chunk__42776_42784 = G__42801;
count__42777_42785 = G__42802;
i__42778_42786 = G__42803;
continue;
}
} else {
}
}
break;
}

var G__42804 = seq__42771;
var G__42805 = chunk__42772;
var G__42806 = count__42773;
var G__42807 = (i__42774 + (1));
seq__42771 = G__42804;
chunk__42772 = G__42805;
count__42773 = G__42806;
i__42774 = G__42807;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__42771);
if(temp__4657__auto__){
var seq__42771__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42771__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__42771__$1);
var G__42808 = cljs.core.chunk_rest.call(null,seq__42771__$1);
var G__42809 = c__29186__auto__;
var G__42810 = cljs.core.count.call(null,c__29186__auto__);
var G__42811 = (0);
seq__42771 = G__42808;
chunk__42772 = G__42809;
count__42773 = G__42810;
i__42774 = G__42811;
continue;
} else {
var prov = cljs.core.first.call(null,seq__42771__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__42779_42812 = cljs.core.seq.call(null,requires);
var chunk__42780_42813 = null;
var count__42781_42814 = (0);
var i__42782_42815 = (0);
while(true){
if((i__42782_42815 < count__42781_42814)){
var req_42816 = cljs.core._nth.call(null,chunk__42780_42813,i__42782_42815);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_42816,prov);

var G__42817 = seq__42779_42812;
var G__42818 = chunk__42780_42813;
var G__42819 = count__42781_42814;
var G__42820 = (i__42782_42815 + (1));
seq__42779_42812 = G__42817;
chunk__42780_42813 = G__42818;
count__42781_42814 = G__42819;
i__42782_42815 = G__42820;
continue;
} else {
var temp__4657__auto___42821__$1 = cljs.core.seq.call(null,seq__42779_42812);
if(temp__4657__auto___42821__$1){
var seq__42779_42822__$1 = temp__4657__auto___42821__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42779_42822__$1)){
var c__29186__auto___42823 = cljs.core.chunk_first.call(null,seq__42779_42822__$1);
var G__42824 = cljs.core.chunk_rest.call(null,seq__42779_42822__$1);
var G__42825 = c__29186__auto___42823;
var G__42826 = cljs.core.count.call(null,c__29186__auto___42823);
var G__42827 = (0);
seq__42779_42812 = G__42824;
chunk__42780_42813 = G__42825;
count__42781_42814 = G__42826;
i__42782_42815 = G__42827;
continue;
} else {
var req_42828 = cljs.core.first.call(null,seq__42779_42822__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_42828,prov);

var G__42829 = cljs.core.next.call(null,seq__42779_42822__$1);
var G__42830 = null;
var G__42831 = (0);
var G__42832 = (0);
seq__42779_42812 = G__42829;
chunk__42780_42813 = G__42830;
count__42781_42814 = G__42831;
i__42782_42815 = G__42832;
continue;
}
} else {
}
}
break;
}

var G__42833 = cljs.core.next.call(null,seq__42771__$1);
var G__42834 = null;
var G__42835 = (0);
var G__42836 = (0);
seq__42771 = G__42833;
chunk__42772 = G__42834;
count__42773 = G__42835;
i__42774 = G__42836;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__42837_42841 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__42838_42842 = null;
var count__42839_42843 = (0);
var i__42840_42844 = (0);
while(true){
if((i__42840_42844 < count__42839_42843)){
var ns_42845 = cljs.core._nth.call(null,chunk__42838_42842,i__42840_42844);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_42845);

var G__42846 = seq__42837_42841;
var G__42847 = chunk__42838_42842;
var G__42848 = count__42839_42843;
var G__42849 = (i__42840_42844 + (1));
seq__42837_42841 = G__42846;
chunk__42838_42842 = G__42847;
count__42839_42843 = G__42848;
i__42840_42844 = G__42849;
continue;
} else {
var temp__4657__auto___42850 = cljs.core.seq.call(null,seq__42837_42841);
if(temp__4657__auto___42850){
var seq__42837_42851__$1 = temp__4657__auto___42850;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42837_42851__$1)){
var c__29186__auto___42852 = cljs.core.chunk_first.call(null,seq__42837_42851__$1);
var G__42853 = cljs.core.chunk_rest.call(null,seq__42837_42851__$1);
var G__42854 = c__29186__auto___42852;
var G__42855 = cljs.core.count.call(null,c__29186__auto___42852);
var G__42856 = (0);
seq__42837_42841 = G__42853;
chunk__42838_42842 = G__42854;
count__42839_42843 = G__42855;
i__42840_42844 = G__42856;
continue;
} else {
var ns_42857 = cljs.core.first.call(null,seq__42837_42851__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_42857);

var G__42858 = cljs.core.next.call(null,seq__42837_42851__$1);
var G__42859 = null;
var G__42860 = (0);
var G__42861 = (0);
seq__42837_42841 = G__42858;
chunk__42838_42842 = G__42859;
count__42839_42843 = G__42860;
i__42840_42844 = G__42861;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28347__auto__ = goog.require__;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__42862__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__42862 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__42863__i = 0, G__42863__a = new Array(arguments.length -  0);
while (G__42863__i < G__42863__a.length) {G__42863__a[G__42863__i] = arguments[G__42863__i + 0]; ++G__42863__i;}
  args = new cljs.core.IndexedSeq(G__42863__a,0,null);
} 
return G__42862__delegate.call(this,args);};
G__42862.cljs$lang$maxFixedArity = 0;
G__42862.cljs$lang$applyTo = (function (arglist__42864){
var args = cljs.core.seq(arglist__42864);
return G__42862__delegate(args);
});
G__42862.cljs$core$IFn$_invoke$arity$variadic = G__42862__delegate;
return G__42862;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__42865_SHARP_,p2__42866_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__42865_SHARP_)].join('')),p2__42866_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__42867_SHARP_,p2__42868_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__42867_SHARP_)].join(''),p2__42868_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__42869 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__42869.addCallback(((function (G__42869){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__42869))
);

G__42869.addErrback(((function (G__42869){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__42869))
);

return G__42869;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__42870 = cljs.core._EQ_;
var expr__42871 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__42870.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__42871))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__42870,expr__42871){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__42870,expr__42871))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__42870,expr__42871){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e42873){if((e42873 instanceof Error)){
var e = e42873;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e42873;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__42870,expr__42871))
} else {
if(cljs.core.truth_(pred__42870.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__42871))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__42870.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__42871))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__42870.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__42871))){
return ((function (pred__42870,expr__42871){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e42874){if((e42874 instanceof Error)){
var e = e42874;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e42874;

}
}})());
});
;})(pred__42870,expr__42871))
} else {
return ((function (pred__42870,expr__42871){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__42870,expr__42871))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__42875,callback){
var map__42876 = p__42875;
var map__42876__$1 = ((((!((map__42876 == null)))?((((map__42876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42876.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42876):map__42876);
var file_msg = map__42876__$1;
var request_url = cljs.core.get.call(null,map__42876__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__42876,map__42876__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__42876,map__42876__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__){
return (function (state_42900){
var state_val_42901 = (state_42900[(1)]);
if((state_val_42901 === (7))){
var inst_42896 = (state_42900[(2)]);
var state_42900__$1 = state_42900;
var statearr_42902_42919 = state_42900__$1;
(statearr_42902_42919[(2)] = inst_42896);

(statearr_42902_42919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (1))){
var state_42900__$1 = state_42900;
var statearr_42903_42920 = state_42900__$1;
(statearr_42903_42920[(2)] = null);

(statearr_42903_42920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (4))){
var inst_42880 = (state_42900[(7)]);
var inst_42880__$1 = (state_42900[(2)]);
var state_42900__$1 = (function (){var statearr_42904 = state_42900;
(statearr_42904[(7)] = inst_42880__$1);

return statearr_42904;
})();
if(cljs.core.truth_(inst_42880__$1)){
var statearr_42905_42921 = state_42900__$1;
(statearr_42905_42921[(1)] = (5));

} else {
var statearr_42906_42922 = state_42900__$1;
(statearr_42906_42922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (6))){
var state_42900__$1 = state_42900;
var statearr_42907_42923 = state_42900__$1;
(statearr_42907_42923[(2)] = null);

(statearr_42907_42923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (3))){
var inst_42898 = (state_42900[(2)]);
var state_42900__$1 = state_42900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42900__$1,inst_42898);
} else {
if((state_val_42901 === (2))){
var state_42900__$1 = state_42900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42900__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_42901 === (11))){
var inst_42892 = (state_42900[(2)]);
var state_42900__$1 = (function (){var statearr_42908 = state_42900;
(statearr_42908[(8)] = inst_42892);

return statearr_42908;
})();
var statearr_42909_42924 = state_42900__$1;
(statearr_42909_42924[(2)] = null);

(statearr_42909_42924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (9))){
var inst_42884 = (state_42900[(9)]);
var inst_42886 = (state_42900[(10)]);
var inst_42888 = inst_42886.call(null,inst_42884);
var state_42900__$1 = state_42900;
var statearr_42910_42925 = state_42900__$1;
(statearr_42910_42925[(2)] = inst_42888);

(statearr_42910_42925[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (5))){
var inst_42880 = (state_42900[(7)]);
var inst_42882 = figwheel.client.file_reloading.blocking_load.call(null,inst_42880);
var state_42900__$1 = state_42900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42900__$1,(8),inst_42882);
} else {
if((state_val_42901 === (10))){
var inst_42884 = (state_42900[(9)]);
var inst_42890 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_42884);
var state_42900__$1 = state_42900;
var statearr_42911_42926 = state_42900__$1;
(statearr_42911_42926[(2)] = inst_42890);

(statearr_42911_42926[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42901 === (8))){
var inst_42880 = (state_42900[(7)]);
var inst_42886 = (state_42900[(10)]);
var inst_42884 = (state_42900[(2)]);
var inst_42885 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_42886__$1 = cljs.core.get.call(null,inst_42885,inst_42880);
var state_42900__$1 = (function (){var statearr_42912 = state_42900;
(statearr_42912[(9)] = inst_42884);

(statearr_42912[(10)] = inst_42886__$1);

return statearr_42912;
})();
if(cljs.core.truth_(inst_42886__$1)){
var statearr_42913_42927 = state_42900__$1;
(statearr_42913_42927[(1)] = (9));

} else {
var statearr_42914_42928 = state_42900__$1;
(statearr_42914_42928[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto__))
;
return ((function (switch__30769__auto__,c__30790__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__30770__auto__ = null;
var figwheel$client$file_reloading$state_machine__30770__auto____0 = (function (){
var statearr_42915 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42915[(0)] = figwheel$client$file_reloading$state_machine__30770__auto__);

(statearr_42915[(1)] = (1));

return statearr_42915;
});
var figwheel$client$file_reloading$state_machine__30770__auto____1 = (function (state_42900){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_42900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e42916){if((e42916 instanceof Object)){
var ex__30773__auto__ = e42916;
var statearr_42917_42929 = state_42900;
(statearr_42917_42929[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42916;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42930 = state_42900;
state_42900 = G__42930;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__30770__auto__ = function(state_42900){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__30770__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__30770__auto____1.call(this,state_42900);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__30770__auto____0;
figwheel$client$file_reloading$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__30770__auto____1;
return figwheel$client$file_reloading$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__))
})();
var state__30792__auto__ = (function (){var statearr_42918 = f__30791__auto__.call(null);
(statearr_42918[(6)] = c__30790__auto__);

return statearr_42918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__))
);

return c__30790__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__42931,callback){
var map__42932 = p__42931;
var map__42932__$1 = ((((!((map__42932 == null)))?((((map__42932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42932.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42932):map__42932);
var file_msg = map__42932__$1;
var namespace = cljs.core.get.call(null,map__42932__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__42932,map__42932__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__42932,map__42932__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__42934){
var map__42935 = p__42934;
var map__42935__$1 = ((((!((map__42935 == null)))?((((map__42935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42935.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42935):map__42935);
var file_msg = map__42935__$1;
var namespace = cljs.core.get.call(null,map__42935__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__42937){
var map__42938 = p__42937;
var map__42938__$1 = ((((!((map__42938 == null)))?((((map__42938.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42938.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42938):map__42938);
var file_msg = map__42938__$1;
var namespace = cljs.core.get.call(null,map__42938__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28335__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28335__auto__){
var or__28347__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
var or__28347__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28347__auto____$1)){
return or__28347__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28335__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__42940,callback){
var map__42941 = p__42940;
var map__42941__$1 = ((((!((map__42941 == null)))?((((map__42941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42941.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42941):map__42941);
var file_msg = map__42941__$1;
var request_url = cljs.core.get.call(null,map__42941__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__42941__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__30790__auto___42991 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___42991,out){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___42991,out){
return (function (state_42976){
var state_val_42977 = (state_42976[(1)]);
if((state_val_42977 === (1))){
var inst_42950 = cljs.core.seq.call(null,files);
var inst_42951 = cljs.core.first.call(null,inst_42950);
var inst_42952 = cljs.core.next.call(null,inst_42950);
var inst_42953 = files;
var state_42976__$1 = (function (){var statearr_42978 = state_42976;
(statearr_42978[(7)] = inst_42953);

(statearr_42978[(8)] = inst_42952);

(statearr_42978[(9)] = inst_42951);

return statearr_42978;
})();
var statearr_42979_42992 = state_42976__$1;
(statearr_42979_42992[(2)] = null);

(statearr_42979_42992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42977 === (2))){
var inst_42953 = (state_42976[(7)]);
var inst_42959 = (state_42976[(10)]);
var inst_42958 = cljs.core.seq.call(null,inst_42953);
var inst_42959__$1 = cljs.core.first.call(null,inst_42958);
var inst_42960 = cljs.core.next.call(null,inst_42958);
var inst_42961 = (inst_42959__$1 == null);
var inst_42962 = cljs.core.not.call(null,inst_42961);
var state_42976__$1 = (function (){var statearr_42980 = state_42976;
(statearr_42980[(10)] = inst_42959__$1);

(statearr_42980[(11)] = inst_42960);

return statearr_42980;
})();
if(inst_42962){
var statearr_42981_42993 = state_42976__$1;
(statearr_42981_42993[(1)] = (4));

} else {
var statearr_42982_42994 = state_42976__$1;
(statearr_42982_42994[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42977 === (3))){
var inst_42974 = (state_42976[(2)]);
var state_42976__$1 = state_42976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42976__$1,inst_42974);
} else {
if((state_val_42977 === (4))){
var inst_42959 = (state_42976[(10)]);
var inst_42964 = figwheel.client.file_reloading.reload_js_file.call(null,inst_42959);
var state_42976__$1 = state_42976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42976__$1,(7),inst_42964);
} else {
if((state_val_42977 === (5))){
var inst_42970 = cljs.core.async.close_BANG_.call(null,out);
var state_42976__$1 = state_42976;
var statearr_42983_42995 = state_42976__$1;
(statearr_42983_42995[(2)] = inst_42970);

(statearr_42983_42995[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42977 === (6))){
var inst_42972 = (state_42976[(2)]);
var state_42976__$1 = state_42976;
var statearr_42984_42996 = state_42976__$1;
(statearr_42984_42996[(2)] = inst_42972);

(statearr_42984_42996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42977 === (7))){
var inst_42960 = (state_42976[(11)]);
var inst_42966 = (state_42976[(2)]);
var inst_42967 = cljs.core.async.put_BANG_.call(null,out,inst_42966);
var inst_42953 = inst_42960;
var state_42976__$1 = (function (){var statearr_42985 = state_42976;
(statearr_42985[(7)] = inst_42953);

(statearr_42985[(12)] = inst_42967);

return statearr_42985;
})();
var statearr_42986_42997 = state_42976__$1;
(statearr_42986_42997[(2)] = null);

(statearr_42986_42997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30790__auto___42991,out))
;
return ((function (switch__30769__auto__,c__30790__auto___42991,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto____0 = (function (){
var statearr_42987 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42987[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto__);

(statearr_42987[(1)] = (1));

return statearr_42987;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto____1 = (function (state_42976){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_42976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e42988){if((e42988 instanceof Object)){
var ex__30773__auto__ = e42988;
var statearr_42989_42998 = state_42976;
(statearr_42989_42998[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42976);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42988;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42999 = state_42976;
state_42976 = G__42999;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto__ = function(state_42976){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto____1.call(this,state_42976);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___42991,out))
})();
var state__30792__auto__ = (function (){var statearr_42990 = f__30791__auto__.call(null);
(statearr_42990[(6)] = c__30790__auto___42991);

return statearr_42990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___42991,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__43000,opts){
var map__43001 = p__43000;
var map__43001__$1 = ((((!((map__43001 == null)))?((((map__43001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43001.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43001):map__43001);
var eval_body = cljs.core.get.call(null,map__43001__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__43001__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28335__auto__ = eval_body;
if(cljs.core.truth_(and__28335__auto__)){
return typeof eval_body === 'string';
} else {
return and__28335__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e43003){var e = e43003;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__43004_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__43004_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__43005){
var vec__43006 = p__43005;
var k = cljs.core.nth.call(null,vec__43006,(0),null);
var v = cljs.core.nth.call(null,vec__43006,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__43009){
var vec__43010 = p__43009;
var k = cljs.core.nth.call(null,vec__43010,(0),null);
var v = cljs.core.nth.call(null,vec__43010,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__43016,p__43017){
var map__43018 = p__43016;
var map__43018__$1 = ((((!((map__43018 == null)))?((((map__43018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43018.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43018):map__43018);
var opts = map__43018__$1;
var before_jsload = cljs.core.get.call(null,map__43018__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__43018__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__43018__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__43019 = p__43017;
var map__43019__$1 = ((((!((map__43019 == null)))?((((map__43019.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43019.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43019):map__43019);
var msg = map__43019__$1;
var files = cljs.core.get.call(null,map__43019__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__43019__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__43019__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_43173){
var state_val_43174 = (state_43173[(1)]);
if((state_val_43174 === (7))){
var inst_43035 = (state_43173[(7)]);
var inst_43034 = (state_43173[(8)]);
var inst_43036 = (state_43173[(9)]);
var inst_43033 = (state_43173[(10)]);
var inst_43041 = cljs.core._nth.call(null,inst_43034,inst_43036);
var inst_43042 = figwheel.client.file_reloading.eval_body.call(null,inst_43041,opts);
var inst_43043 = (inst_43036 + (1));
var tmp43175 = inst_43035;
var tmp43176 = inst_43034;
var tmp43177 = inst_43033;
var inst_43033__$1 = tmp43177;
var inst_43034__$1 = tmp43176;
var inst_43035__$1 = tmp43175;
var inst_43036__$1 = inst_43043;
var state_43173__$1 = (function (){var statearr_43178 = state_43173;
(statearr_43178[(7)] = inst_43035__$1);

(statearr_43178[(8)] = inst_43034__$1);

(statearr_43178[(9)] = inst_43036__$1);

(statearr_43178[(11)] = inst_43042);

(statearr_43178[(10)] = inst_43033__$1);

return statearr_43178;
})();
var statearr_43179_43262 = state_43173__$1;
(statearr_43179_43262[(2)] = null);

(statearr_43179_43262[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (20))){
var inst_43076 = (state_43173[(12)]);
var inst_43084 = figwheel.client.file_reloading.sort_files.call(null,inst_43076);
var state_43173__$1 = state_43173;
var statearr_43180_43263 = state_43173__$1;
(statearr_43180_43263[(2)] = inst_43084);

(statearr_43180_43263[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (27))){
var state_43173__$1 = state_43173;
var statearr_43181_43264 = state_43173__$1;
(statearr_43181_43264[(2)] = null);

(statearr_43181_43264[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (1))){
var inst_43025 = (state_43173[(13)]);
var inst_43022 = before_jsload.call(null,files);
var inst_43023 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_43024 = (function (){return ((function (inst_43025,inst_43022,inst_43023,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__43013_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__43013_SHARP_);
});
;})(inst_43025,inst_43022,inst_43023,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_43025__$1 = cljs.core.filter.call(null,inst_43024,files);
var inst_43026 = cljs.core.not_empty.call(null,inst_43025__$1);
var state_43173__$1 = (function (){var statearr_43182 = state_43173;
(statearr_43182[(14)] = inst_43023);

(statearr_43182[(13)] = inst_43025__$1);

(statearr_43182[(15)] = inst_43022);

return statearr_43182;
})();
if(cljs.core.truth_(inst_43026)){
var statearr_43183_43265 = state_43173__$1;
(statearr_43183_43265[(1)] = (2));

} else {
var statearr_43184_43266 = state_43173__$1;
(statearr_43184_43266[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (24))){
var state_43173__$1 = state_43173;
var statearr_43185_43267 = state_43173__$1;
(statearr_43185_43267[(2)] = null);

(statearr_43185_43267[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (39))){
var inst_43126 = (state_43173[(16)]);
var state_43173__$1 = state_43173;
var statearr_43186_43268 = state_43173__$1;
(statearr_43186_43268[(2)] = inst_43126);

(statearr_43186_43268[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (46))){
var inst_43168 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
var statearr_43187_43269 = state_43173__$1;
(statearr_43187_43269[(2)] = inst_43168);

(statearr_43187_43269[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (4))){
var inst_43070 = (state_43173[(2)]);
var inst_43071 = cljs.core.List.EMPTY;
var inst_43072 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_43071);
var inst_43073 = (function (){return ((function (inst_43070,inst_43071,inst_43072,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__43014_SHARP_){
var and__28335__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__43014_SHARP_);
if(cljs.core.truth_(and__28335__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__43014_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__43014_SHARP_)));
} else {
return and__28335__auto__;
}
});
;})(inst_43070,inst_43071,inst_43072,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_43074 = cljs.core.filter.call(null,inst_43073,files);
var inst_43075 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_43076 = cljs.core.concat.call(null,inst_43074,inst_43075);
var state_43173__$1 = (function (){var statearr_43188 = state_43173;
(statearr_43188[(17)] = inst_43070);

(statearr_43188[(12)] = inst_43076);

(statearr_43188[(18)] = inst_43072);

return statearr_43188;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_43189_43270 = state_43173__$1;
(statearr_43189_43270[(1)] = (16));

} else {
var statearr_43190_43271 = state_43173__$1;
(statearr_43190_43271[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (15))){
var inst_43060 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
var statearr_43191_43272 = state_43173__$1;
(statearr_43191_43272[(2)] = inst_43060);

(statearr_43191_43272[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (21))){
var inst_43086 = (state_43173[(19)]);
var inst_43086__$1 = (state_43173[(2)]);
var inst_43087 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_43086__$1);
var state_43173__$1 = (function (){var statearr_43192 = state_43173;
(statearr_43192[(19)] = inst_43086__$1);

return statearr_43192;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43173__$1,(22),inst_43087);
} else {
if((state_val_43174 === (31))){
var inst_43171 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43173__$1,inst_43171);
} else {
if((state_val_43174 === (32))){
var inst_43126 = (state_43173[(16)]);
var inst_43131 = inst_43126.cljs$lang$protocol_mask$partition0$;
var inst_43132 = (inst_43131 & (64));
var inst_43133 = inst_43126.cljs$core$ISeq$;
var inst_43134 = (cljs.core.PROTOCOL_SENTINEL === inst_43133);
var inst_43135 = (inst_43132) || (inst_43134);
var state_43173__$1 = state_43173;
if(cljs.core.truth_(inst_43135)){
var statearr_43193_43273 = state_43173__$1;
(statearr_43193_43273[(1)] = (35));

} else {
var statearr_43194_43274 = state_43173__$1;
(statearr_43194_43274[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (40))){
var inst_43148 = (state_43173[(20)]);
var inst_43147 = (state_43173[(2)]);
var inst_43148__$1 = cljs.core.get.call(null,inst_43147,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_43149 = cljs.core.get.call(null,inst_43147,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_43150 = cljs.core.not_empty.call(null,inst_43148__$1);
var state_43173__$1 = (function (){var statearr_43195 = state_43173;
(statearr_43195[(21)] = inst_43149);

(statearr_43195[(20)] = inst_43148__$1);

return statearr_43195;
})();
if(cljs.core.truth_(inst_43150)){
var statearr_43196_43275 = state_43173__$1;
(statearr_43196_43275[(1)] = (41));

} else {
var statearr_43197_43276 = state_43173__$1;
(statearr_43197_43276[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (33))){
var state_43173__$1 = state_43173;
var statearr_43198_43277 = state_43173__$1;
(statearr_43198_43277[(2)] = false);

(statearr_43198_43277[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (13))){
var inst_43046 = (state_43173[(22)]);
var inst_43050 = cljs.core.chunk_first.call(null,inst_43046);
var inst_43051 = cljs.core.chunk_rest.call(null,inst_43046);
var inst_43052 = cljs.core.count.call(null,inst_43050);
var inst_43033 = inst_43051;
var inst_43034 = inst_43050;
var inst_43035 = inst_43052;
var inst_43036 = (0);
var state_43173__$1 = (function (){var statearr_43199 = state_43173;
(statearr_43199[(7)] = inst_43035);

(statearr_43199[(8)] = inst_43034);

(statearr_43199[(9)] = inst_43036);

(statearr_43199[(10)] = inst_43033);

return statearr_43199;
})();
var statearr_43200_43278 = state_43173__$1;
(statearr_43200_43278[(2)] = null);

(statearr_43200_43278[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (22))){
var inst_43090 = (state_43173[(23)]);
var inst_43094 = (state_43173[(24)]);
var inst_43089 = (state_43173[(25)]);
var inst_43086 = (state_43173[(19)]);
var inst_43089__$1 = (state_43173[(2)]);
var inst_43090__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_43089__$1);
var inst_43091 = (function (){var all_files = inst_43086;
var res_SINGLEQUOTE_ = inst_43089__$1;
var res = inst_43090__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_43090,inst_43094,inst_43089,inst_43086,inst_43089__$1,inst_43090__$1,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__43015_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__43015_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_43090,inst_43094,inst_43089,inst_43086,inst_43089__$1,inst_43090__$1,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_43092 = cljs.core.filter.call(null,inst_43091,inst_43089__$1);
var inst_43093 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_43094__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_43093);
var inst_43095 = cljs.core.not_empty.call(null,inst_43094__$1);
var state_43173__$1 = (function (){var statearr_43201 = state_43173;
(statearr_43201[(23)] = inst_43090__$1);

(statearr_43201[(24)] = inst_43094__$1);

(statearr_43201[(25)] = inst_43089__$1);

(statearr_43201[(26)] = inst_43092);

return statearr_43201;
})();
if(cljs.core.truth_(inst_43095)){
var statearr_43202_43279 = state_43173__$1;
(statearr_43202_43279[(1)] = (23));

} else {
var statearr_43203_43280 = state_43173__$1;
(statearr_43203_43280[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (36))){
var state_43173__$1 = state_43173;
var statearr_43204_43281 = state_43173__$1;
(statearr_43204_43281[(2)] = false);

(statearr_43204_43281[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (41))){
var inst_43148 = (state_43173[(20)]);
var inst_43152 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_43153 = cljs.core.map.call(null,inst_43152,inst_43148);
var inst_43154 = cljs.core.pr_str.call(null,inst_43153);
var inst_43155 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43154)].join('');
var inst_43156 = figwheel.client.utils.log.call(null,inst_43155);
var state_43173__$1 = state_43173;
var statearr_43205_43282 = state_43173__$1;
(statearr_43205_43282[(2)] = inst_43156);

(statearr_43205_43282[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (43))){
var inst_43149 = (state_43173[(21)]);
var inst_43159 = (state_43173[(2)]);
var inst_43160 = cljs.core.not_empty.call(null,inst_43149);
var state_43173__$1 = (function (){var statearr_43206 = state_43173;
(statearr_43206[(27)] = inst_43159);

return statearr_43206;
})();
if(cljs.core.truth_(inst_43160)){
var statearr_43207_43283 = state_43173__$1;
(statearr_43207_43283[(1)] = (44));

} else {
var statearr_43208_43284 = state_43173__$1;
(statearr_43208_43284[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (29))){
var inst_43090 = (state_43173[(23)]);
var inst_43126 = (state_43173[(16)]);
var inst_43094 = (state_43173[(24)]);
var inst_43089 = (state_43173[(25)]);
var inst_43086 = (state_43173[(19)]);
var inst_43092 = (state_43173[(26)]);
var inst_43122 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_43125 = (function (){var all_files = inst_43086;
var res_SINGLEQUOTE_ = inst_43089;
var res = inst_43090;
var files_not_loaded = inst_43092;
var dependencies_that_loaded = inst_43094;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_43090,inst_43126,inst_43094,inst_43089,inst_43086,inst_43092,inst_43122,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__43124){
var map__43209 = p__43124;
var map__43209__$1 = ((((!((map__43209 == null)))?((((map__43209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43209.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43209):map__43209);
var namespace = cljs.core.get.call(null,map__43209__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_43090,inst_43126,inst_43094,inst_43089,inst_43086,inst_43092,inst_43122,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_43126__$1 = cljs.core.group_by.call(null,inst_43125,inst_43092);
var inst_43128 = (inst_43126__$1 == null);
var inst_43129 = cljs.core.not.call(null,inst_43128);
var state_43173__$1 = (function (){var statearr_43211 = state_43173;
(statearr_43211[(16)] = inst_43126__$1);

(statearr_43211[(28)] = inst_43122);

return statearr_43211;
})();
if(inst_43129){
var statearr_43212_43285 = state_43173__$1;
(statearr_43212_43285[(1)] = (32));

} else {
var statearr_43213_43286 = state_43173__$1;
(statearr_43213_43286[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (44))){
var inst_43149 = (state_43173[(21)]);
var inst_43162 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_43149);
var inst_43163 = cljs.core.pr_str.call(null,inst_43162);
var inst_43164 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43163)].join('');
var inst_43165 = figwheel.client.utils.log.call(null,inst_43164);
var state_43173__$1 = state_43173;
var statearr_43214_43287 = state_43173__$1;
(statearr_43214_43287[(2)] = inst_43165);

(statearr_43214_43287[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (6))){
var inst_43067 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
var statearr_43215_43288 = state_43173__$1;
(statearr_43215_43288[(2)] = inst_43067);

(statearr_43215_43288[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (28))){
var inst_43092 = (state_43173[(26)]);
var inst_43119 = (state_43173[(2)]);
var inst_43120 = cljs.core.not_empty.call(null,inst_43092);
var state_43173__$1 = (function (){var statearr_43216 = state_43173;
(statearr_43216[(29)] = inst_43119);

return statearr_43216;
})();
if(cljs.core.truth_(inst_43120)){
var statearr_43217_43289 = state_43173__$1;
(statearr_43217_43289[(1)] = (29));

} else {
var statearr_43218_43290 = state_43173__$1;
(statearr_43218_43290[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (25))){
var inst_43090 = (state_43173[(23)]);
var inst_43106 = (state_43173[(2)]);
var inst_43107 = cljs.core.not_empty.call(null,inst_43090);
var state_43173__$1 = (function (){var statearr_43219 = state_43173;
(statearr_43219[(30)] = inst_43106);

return statearr_43219;
})();
if(cljs.core.truth_(inst_43107)){
var statearr_43220_43291 = state_43173__$1;
(statearr_43220_43291[(1)] = (26));

} else {
var statearr_43221_43292 = state_43173__$1;
(statearr_43221_43292[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (34))){
var inst_43142 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
if(cljs.core.truth_(inst_43142)){
var statearr_43222_43293 = state_43173__$1;
(statearr_43222_43293[(1)] = (38));

} else {
var statearr_43223_43294 = state_43173__$1;
(statearr_43223_43294[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (17))){
var state_43173__$1 = state_43173;
var statearr_43224_43295 = state_43173__$1;
(statearr_43224_43295[(2)] = recompile_dependents);

(statearr_43224_43295[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (3))){
var state_43173__$1 = state_43173;
var statearr_43225_43296 = state_43173__$1;
(statearr_43225_43296[(2)] = null);

(statearr_43225_43296[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (12))){
var inst_43063 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
var statearr_43226_43297 = state_43173__$1;
(statearr_43226_43297[(2)] = inst_43063);

(statearr_43226_43297[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (2))){
var inst_43025 = (state_43173[(13)]);
var inst_43032 = cljs.core.seq.call(null,inst_43025);
var inst_43033 = inst_43032;
var inst_43034 = null;
var inst_43035 = (0);
var inst_43036 = (0);
var state_43173__$1 = (function (){var statearr_43227 = state_43173;
(statearr_43227[(7)] = inst_43035);

(statearr_43227[(8)] = inst_43034);

(statearr_43227[(9)] = inst_43036);

(statearr_43227[(10)] = inst_43033);

return statearr_43227;
})();
var statearr_43228_43298 = state_43173__$1;
(statearr_43228_43298[(2)] = null);

(statearr_43228_43298[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (23))){
var inst_43090 = (state_43173[(23)]);
var inst_43094 = (state_43173[(24)]);
var inst_43089 = (state_43173[(25)]);
var inst_43086 = (state_43173[(19)]);
var inst_43092 = (state_43173[(26)]);
var inst_43097 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_43099 = (function (){var all_files = inst_43086;
var res_SINGLEQUOTE_ = inst_43089;
var res = inst_43090;
var files_not_loaded = inst_43092;
var dependencies_that_loaded = inst_43094;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_43090,inst_43094,inst_43089,inst_43086,inst_43092,inst_43097,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__43098){
var map__43229 = p__43098;
var map__43229__$1 = ((((!((map__43229 == null)))?((((map__43229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43229.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43229):map__43229);
var request_url = cljs.core.get.call(null,map__43229__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_43090,inst_43094,inst_43089,inst_43086,inst_43092,inst_43097,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_43100 = cljs.core.reverse.call(null,inst_43094);
var inst_43101 = cljs.core.map.call(null,inst_43099,inst_43100);
var inst_43102 = cljs.core.pr_str.call(null,inst_43101);
var inst_43103 = figwheel.client.utils.log.call(null,inst_43102);
var state_43173__$1 = (function (){var statearr_43231 = state_43173;
(statearr_43231[(31)] = inst_43097);

return statearr_43231;
})();
var statearr_43232_43299 = state_43173__$1;
(statearr_43232_43299[(2)] = inst_43103);

(statearr_43232_43299[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (35))){
var state_43173__$1 = state_43173;
var statearr_43233_43300 = state_43173__$1;
(statearr_43233_43300[(2)] = true);

(statearr_43233_43300[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (19))){
var inst_43076 = (state_43173[(12)]);
var inst_43082 = figwheel.client.file_reloading.expand_files.call(null,inst_43076);
var state_43173__$1 = state_43173;
var statearr_43234_43301 = state_43173__$1;
(statearr_43234_43301[(2)] = inst_43082);

(statearr_43234_43301[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (11))){
var state_43173__$1 = state_43173;
var statearr_43235_43302 = state_43173__$1;
(statearr_43235_43302[(2)] = null);

(statearr_43235_43302[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (9))){
var inst_43065 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
var statearr_43236_43303 = state_43173__$1;
(statearr_43236_43303[(2)] = inst_43065);

(statearr_43236_43303[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (5))){
var inst_43035 = (state_43173[(7)]);
var inst_43036 = (state_43173[(9)]);
var inst_43038 = (inst_43036 < inst_43035);
var inst_43039 = inst_43038;
var state_43173__$1 = state_43173;
if(cljs.core.truth_(inst_43039)){
var statearr_43237_43304 = state_43173__$1;
(statearr_43237_43304[(1)] = (7));

} else {
var statearr_43238_43305 = state_43173__$1;
(statearr_43238_43305[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (14))){
var inst_43046 = (state_43173[(22)]);
var inst_43055 = cljs.core.first.call(null,inst_43046);
var inst_43056 = figwheel.client.file_reloading.eval_body.call(null,inst_43055,opts);
var inst_43057 = cljs.core.next.call(null,inst_43046);
var inst_43033 = inst_43057;
var inst_43034 = null;
var inst_43035 = (0);
var inst_43036 = (0);
var state_43173__$1 = (function (){var statearr_43239 = state_43173;
(statearr_43239[(32)] = inst_43056);

(statearr_43239[(7)] = inst_43035);

(statearr_43239[(8)] = inst_43034);

(statearr_43239[(9)] = inst_43036);

(statearr_43239[(10)] = inst_43033);

return statearr_43239;
})();
var statearr_43240_43306 = state_43173__$1;
(statearr_43240_43306[(2)] = null);

(statearr_43240_43306[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (45))){
var state_43173__$1 = state_43173;
var statearr_43241_43307 = state_43173__$1;
(statearr_43241_43307[(2)] = null);

(statearr_43241_43307[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (26))){
var inst_43090 = (state_43173[(23)]);
var inst_43094 = (state_43173[(24)]);
var inst_43089 = (state_43173[(25)]);
var inst_43086 = (state_43173[(19)]);
var inst_43092 = (state_43173[(26)]);
var inst_43109 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_43111 = (function (){var all_files = inst_43086;
var res_SINGLEQUOTE_ = inst_43089;
var res = inst_43090;
var files_not_loaded = inst_43092;
var dependencies_that_loaded = inst_43094;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_43090,inst_43094,inst_43089,inst_43086,inst_43092,inst_43109,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__43110){
var map__43242 = p__43110;
var map__43242__$1 = ((((!((map__43242 == null)))?((((map__43242.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43242.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43242):map__43242);
var namespace = cljs.core.get.call(null,map__43242__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__43242__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_43090,inst_43094,inst_43089,inst_43086,inst_43092,inst_43109,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_43112 = cljs.core.map.call(null,inst_43111,inst_43090);
var inst_43113 = cljs.core.pr_str.call(null,inst_43112);
var inst_43114 = figwheel.client.utils.log.call(null,inst_43113);
var inst_43115 = (function (){var all_files = inst_43086;
var res_SINGLEQUOTE_ = inst_43089;
var res = inst_43090;
var files_not_loaded = inst_43092;
var dependencies_that_loaded = inst_43094;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_43090,inst_43094,inst_43089,inst_43086,inst_43092,inst_43109,inst_43111,inst_43112,inst_43113,inst_43114,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_43090,inst_43094,inst_43089,inst_43086,inst_43092,inst_43109,inst_43111,inst_43112,inst_43113,inst_43114,state_val_43174,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_43116 = setTimeout(inst_43115,(10));
var state_43173__$1 = (function (){var statearr_43244 = state_43173;
(statearr_43244[(33)] = inst_43109);

(statearr_43244[(34)] = inst_43114);

return statearr_43244;
})();
var statearr_43245_43308 = state_43173__$1;
(statearr_43245_43308[(2)] = inst_43116);

(statearr_43245_43308[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (16))){
var state_43173__$1 = state_43173;
var statearr_43246_43309 = state_43173__$1;
(statearr_43246_43309[(2)] = reload_dependents);

(statearr_43246_43309[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (38))){
var inst_43126 = (state_43173[(16)]);
var inst_43144 = cljs.core.apply.call(null,cljs.core.hash_map,inst_43126);
var state_43173__$1 = state_43173;
var statearr_43247_43310 = state_43173__$1;
(statearr_43247_43310[(2)] = inst_43144);

(statearr_43247_43310[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (30))){
var state_43173__$1 = state_43173;
var statearr_43248_43311 = state_43173__$1;
(statearr_43248_43311[(2)] = null);

(statearr_43248_43311[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (10))){
var inst_43046 = (state_43173[(22)]);
var inst_43048 = cljs.core.chunked_seq_QMARK_.call(null,inst_43046);
var state_43173__$1 = state_43173;
if(inst_43048){
var statearr_43249_43312 = state_43173__$1;
(statearr_43249_43312[(1)] = (13));

} else {
var statearr_43250_43313 = state_43173__$1;
(statearr_43250_43313[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (18))){
var inst_43080 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
if(cljs.core.truth_(inst_43080)){
var statearr_43251_43314 = state_43173__$1;
(statearr_43251_43314[(1)] = (19));

} else {
var statearr_43252_43315 = state_43173__$1;
(statearr_43252_43315[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (42))){
var state_43173__$1 = state_43173;
var statearr_43253_43316 = state_43173__$1;
(statearr_43253_43316[(2)] = null);

(statearr_43253_43316[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (37))){
var inst_43139 = (state_43173[(2)]);
var state_43173__$1 = state_43173;
var statearr_43254_43317 = state_43173__$1;
(statearr_43254_43317[(2)] = inst_43139);

(statearr_43254_43317[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43174 === (8))){
var inst_43046 = (state_43173[(22)]);
var inst_43033 = (state_43173[(10)]);
var inst_43046__$1 = cljs.core.seq.call(null,inst_43033);
var state_43173__$1 = (function (){var statearr_43255 = state_43173;
(statearr_43255[(22)] = inst_43046__$1);

return statearr_43255;
})();
if(inst_43046__$1){
var statearr_43256_43318 = state_43173__$1;
(statearr_43256_43318[(1)] = (10));

} else {
var statearr_43257_43319 = state_43173__$1;
(statearr_43257_43319[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__30769__auto__,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto____0 = (function (){
var statearr_43258 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43258[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto__);

(statearr_43258[(1)] = (1));

return statearr_43258;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto____1 = (function (state_43173){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_43173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e43259){if((e43259 instanceof Object)){
var ex__30773__auto__ = e43259;
var statearr_43260_43320 = state_43173;
(statearr_43260_43320[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43173);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43259;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43321 = state_43173;
state_43173 = G__43321;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto__ = function(state_43173){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto____1.call(this,state_43173);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__30792__auto__ = (function (){var statearr_43261 = f__30791__auto__.call(null);
(statearr_43261[(6)] = c__30790__auto__);

return statearr_43261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__,map__43018,map__43018__$1,opts,before_jsload,on_jsload,reload_dependents,map__43019,map__43019__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__30790__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__43324,link){
var map__43325 = p__43324;
var map__43325__$1 = ((((!((map__43325 == null)))?((((map__43325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43325.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43325):map__43325);
var file = cljs.core.get.call(null,map__43325__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__43325,map__43325__$1,file){
return (function (p1__43322_SHARP_,p2__43323_SHARP_){
if(cljs.core._EQ_.call(null,p1__43322_SHARP_,p2__43323_SHARP_)){
return p1__43322_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__43325,map__43325__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__43328){
var map__43329 = p__43328;
var map__43329__$1 = ((((!((map__43329 == null)))?((((map__43329.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43329.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43329):map__43329);
var match_length = cljs.core.get.call(null,map__43329__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__43329__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__43327_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__43327_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__43331_SHARP_,p2__43332_SHARP_){
return cljs.core.assoc.call(null,p1__43331_SHARP_,cljs.core.get.call(null,p2__43332_SHARP_,key),p2__43332_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_43333 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_43333);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_43333);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__43334,p__43335){
var map__43336 = p__43334;
var map__43336__$1 = ((((!((map__43336 == null)))?((((map__43336.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43336.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43336):map__43336);
var on_cssload = cljs.core.get.call(null,map__43336__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__43337 = p__43335;
var map__43337__$1 = ((((!((map__43337 == null)))?((((map__43337.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43337.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43337):map__43337);
var files_msg = map__43337__$1;
var files = cljs.core.get.call(null,map__43337__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1503821888450
