// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e44436){if((e44436 instanceof Error)){
var e = e44436;
return "Error: Unable to stringify";
} else {
throw e44436;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__44439 = arguments.length;
switch (G__44439) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__44437_SHARP_){
if(typeof p1__44437_SHARP_ === 'string'){
return p1__44437_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__44437_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29523__auto__ = [];
var len__29516__auto___44442 = arguments.length;
var i__29517__auto___44443 = (0);
while(true){
if((i__29517__auto___44443 < len__29516__auto___44442)){
args__29523__auto__.push((arguments[i__29517__auto___44443]));

var G__44444 = (i__29517__auto___44443 + (1));
i__29517__auto___44443 = G__44444;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq44441){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44441));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29523__auto__ = [];
var len__29516__auto___44446 = arguments.length;
var i__29517__auto___44447 = (0);
while(true){
if((i__29517__auto___44447 < len__29516__auto___44446)){
args__29523__auto__.push((arguments[i__29517__auto___44447]));

var G__44448 = (i__29517__auto___44447 + (1));
i__29517__auto___44447 = G__44448;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq44445){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44445));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__44449){
var map__44450 = p__44449;
var map__44450__$1 = ((((!((map__44450 == null)))?((((map__44450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44450.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44450):map__44450);
var message = cljs.core.get.call(null,map__44450__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__44450__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28347__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28335__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28335__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28335__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__30790__auto___44529 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___44529,ch){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___44529,ch){
return (function (state_44501){
var state_val_44502 = (state_44501[(1)]);
if((state_val_44502 === (7))){
var inst_44497 = (state_44501[(2)]);
var state_44501__$1 = state_44501;
var statearr_44503_44530 = state_44501__$1;
(statearr_44503_44530[(2)] = inst_44497);

(statearr_44503_44530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (1))){
var state_44501__$1 = state_44501;
var statearr_44504_44531 = state_44501__$1;
(statearr_44504_44531[(2)] = null);

(statearr_44504_44531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (4))){
var inst_44454 = (state_44501[(7)]);
var inst_44454__$1 = (state_44501[(2)]);
var state_44501__$1 = (function (){var statearr_44505 = state_44501;
(statearr_44505[(7)] = inst_44454__$1);

return statearr_44505;
})();
if(cljs.core.truth_(inst_44454__$1)){
var statearr_44506_44532 = state_44501__$1;
(statearr_44506_44532[(1)] = (5));

} else {
var statearr_44507_44533 = state_44501__$1;
(statearr_44507_44533[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (15))){
var inst_44461 = (state_44501[(8)]);
var inst_44476 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_44461);
var inst_44477 = cljs.core.first.call(null,inst_44476);
var inst_44478 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_44477);
var inst_44479 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44478)].join('');
var inst_44480 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_44479);
var state_44501__$1 = state_44501;
var statearr_44508_44534 = state_44501__$1;
(statearr_44508_44534[(2)] = inst_44480);

(statearr_44508_44534[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (13))){
var inst_44485 = (state_44501[(2)]);
var state_44501__$1 = state_44501;
var statearr_44509_44535 = state_44501__$1;
(statearr_44509_44535[(2)] = inst_44485);

(statearr_44509_44535[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (6))){
var state_44501__$1 = state_44501;
var statearr_44510_44536 = state_44501__$1;
(statearr_44510_44536[(2)] = null);

(statearr_44510_44536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (17))){
var inst_44483 = (state_44501[(2)]);
var state_44501__$1 = state_44501;
var statearr_44511_44537 = state_44501__$1;
(statearr_44511_44537[(2)] = inst_44483);

(statearr_44511_44537[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (3))){
var inst_44499 = (state_44501[(2)]);
var state_44501__$1 = state_44501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44501__$1,inst_44499);
} else {
if((state_val_44502 === (12))){
var inst_44460 = (state_44501[(9)]);
var inst_44474 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_44460,opts);
var state_44501__$1 = state_44501;
if(cljs.core.truth_(inst_44474)){
var statearr_44512_44538 = state_44501__$1;
(statearr_44512_44538[(1)] = (15));

} else {
var statearr_44513_44539 = state_44501__$1;
(statearr_44513_44539[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (2))){
var state_44501__$1 = state_44501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44501__$1,(4),ch);
} else {
if((state_val_44502 === (11))){
var inst_44461 = (state_44501[(8)]);
var inst_44466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44467 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_44461);
var inst_44468 = cljs.core.async.timeout.call(null,(1000));
var inst_44469 = [inst_44467,inst_44468];
var inst_44470 = (new cljs.core.PersistentVector(null,2,(5),inst_44466,inst_44469,null));
var state_44501__$1 = state_44501;
return cljs.core.async.ioc_alts_BANG_.call(null,state_44501__$1,(14),inst_44470);
} else {
if((state_val_44502 === (9))){
var inst_44461 = (state_44501[(8)]);
var inst_44487 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_44488 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_44461);
var inst_44489 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_44488);
var inst_44490 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44489)].join('');
var inst_44491 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_44490);
var state_44501__$1 = (function (){var statearr_44514 = state_44501;
(statearr_44514[(10)] = inst_44487);

return statearr_44514;
})();
var statearr_44515_44540 = state_44501__$1;
(statearr_44515_44540[(2)] = inst_44491);

(statearr_44515_44540[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (5))){
var inst_44454 = (state_44501[(7)]);
var inst_44456 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_44457 = (new cljs.core.PersistentArrayMap(null,2,inst_44456,null));
var inst_44458 = (new cljs.core.PersistentHashSet(null,inst_44457,null));
var inst_44459 = figwheel.client.focus_msgs.call(null,inst_44458,inst_44454);
var inst_44460 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_44459);
var inst_44461 = cljs.core.first.call(null,inst_44459);
var inst_44462 = figwheel.client.autoload_QMARK_.call(null);
var state_44501__$1 = (function (){var statearr_44516 = state_44501;
(statearr_44516[(8)] = inst_44461);

(statearr_44516[(9)] = inst_44460);

return statearr_44516;
})();
if(cljs.core.truth_(inst_44462)){
var statearr_44517_44541 = state_44501__$1;
(statearr_44517_44541[(1)] = (8));

} else {
var statearr_44518_44542 = state_44501__$1;
(statearr_44518_44542[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (14))){
var inst_44472 = (state_44501[(2)]);
var state_44501__$1 = state_44501;
var statearr_44519_44543 = state_44501__$1;
(statearr_44519_44543[(2)] = inst_44472);

(statearr_44519_44543[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (16))){
var state_44501__$1 = state_44501;
var statearr_44520_44544 = state_44501__$1;
(statearr_44520_44544[(2)] = null);

(statearr_44520_44544[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (10))){
var inst_44493 = (state_44501[(2)]);
var state_44501__$1 = (function (){var statearr_44521 = state_44501;
(statearr_44521[(11)] = inst_44493);

return statearr_44521;
})();
var statearr_44522_44545 = state_44501__$1;
(statearr_44522_44545[(2)] = null);

(statearr_44522_44545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44502 === (8))){
var inst_44460 = (state_44501[(9)]);
var inst_44464 = figwheel.client.reload_file_state_QMARK_.call(null,inst_44460,opts);
var state_44501__$1 = state_44501;
if(cljs.core.truth_(inst_44464)){
var statearr_44523_44546 = state_44501__$1;
(statearr_44523_44546[(1)] = (11));

} else {
var statearr_44524_44547 = state_44501__$1;
(statearr_44524_44547[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___44529,ch))
;
return ((function (switch__30769__auto__,c__30790__auto___44529,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__30770__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__30770__auto____0 = (function (){
var statearr_44525 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44525[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__30770__auto__);

(statearr_44525[(1)] = (1));

return statearr_44525;
});
var figwheel$client$file_reloader_plugin_$_state_machine__30770__auto____1 = (function (state_44501){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_44501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e44526){if((e44526 instanceof Object)){
var ex__30773__auto__ = e44526;
var statearr_44527_44548 = state_44501;
(statearr_44527_44548[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44501);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44526;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44549 = state_44501;
state_44501 = G__44549;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__30770__auto__ = function(state_44501){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__30770__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__30770__auto____1.call(this,state_44501);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__30770__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__30770__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___44529,ch))
})();
var state__30792__auto__ = (function (){var statearr_44528 = f__30791__auto__.call(null);
(statearr_44528[(6)] = c__30790__auto___44529);

return statearr_44528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___44529,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__44550_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__44550_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_44552 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_44552){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e44551){if((e44551 instanceof Error)){
var e = e44551;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_44552], null));
} else {
var e = e44551;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_44552))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__44553){
var map__44554 = p__44553;
var map__44554__$1 = ((((!((map__44554 == null)))?((((map__44554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44554.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44554):map__44554);
var opts = map__44554__$1;
var build_id = cljs.core.get.call(null,map__44554__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__44554,map__44554__$1,opts,build_id){
return (function (p__44556){
var vec__44557 = p__44556;
var seq__44558 = cljs.core.seq.call(null,vec__44557);
var first__44559 = cljs.core.first.call(null,seq__44558);
var seq__44558__$1 = cljs.core.next.call(null,seq__44558);
var map__44560 = first__44559;
var map__44560__$1 = ((((!((map__44560 == null)))?((((map__44560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44560.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44560):map__44560);
var msg = map__44560__$1;
var msg_name = cljs.core.get.call(null,map__44560__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__44558__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__44557,seq__44558,first__44559,seq__44558__$1,map__44560,map__44560__$1,msg,msg_name,_,map__44554,map__44554__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__44557,seq__44558,first__44559,seq__44558__$1,map__44560,map__44560__$1,msg,msg_name,_,map__44554,map__44554__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__44554,map__44554__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__44562){
var vec__44563 = p__44562;
var seq__44564 = cljs.core.seq.call(null,vec__44563);
var first__44565 = cljs.core.first.call(null,seq__44564);
var seq__44564__$1 = cljs.core.next.call(null,seq__44564);
var map__44566 = first__44565;
var map__44566__$1 = ((((!((map__44566 == null)))?((((map__44566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44566.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44566):map__44566);
var msg = map__44566__$1;
var msg_name = cljs.core.get.call(null,map__44566__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__44564__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__44568){
var map__44569 = p__44568;
var map__44569__$1 = ((((!((map__44569 == null)))?((((map__44569.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44569.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44569):map__44569);
var on_compile_warning = cljs.core.get.call(null,map__44569__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__44569__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__44569,map__44569__$1,on_compile_warning,on_compile_fail){
return (function (p__44571){
var vec__44572 = p__44571;
var seq__44573 = cljs.core.seq.call(null,vec__44572);
var first__44574 = cljs.core.first.call(null,seq__44573);
var seq__44573__$1 = cljs.core.next.call(null,seq__44573);
var map__44575 = first__44574;
var map__44575__$1 = ((((!((map__44575 == null)))?((((map__44575.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44575.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44575):map__44575);
var msg = map__44575__$1;
var msg_name = cljs.core.get.call(null,map__44575__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__44573__$1;
var pred__44577 = cljs.core._EQ_;
var expr__44578 = msg_name;
if(cljs.core.truth_(pred__44577.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__44578))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__44577.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__44578))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__44569,map__44569__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__,msg_hist,msg_names,msg){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__,msg_hist,msg_names,msg){
return (function (state_44667){
var state_val_44668 = (state_44667[(1)]);
if((state_val_44668 === (7))){
var inst_44587 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44587)){
var statearr_44669_44716 = state_44667__$1;
(statearr_44669_44716[(1)] = (8));

} else {
var statearr_44670_44717 = state_44667__$1;
(statearr_44670_44717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (20))){
var inst_44661 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44671_44718 = state_44667__$1;
(statearr_44671_44718[(2)] = inst_44661);

(statearr_44671_44718[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (27))){
var inst_44657 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44672_44719 = state_44667__$1;
(statearr_44672_44719[(2)] = inst_44657);

(statearr_44672_44719[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (1))){
var inst_44580 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44580)){
var statearr_44673_44720 = state_44667__$1;
(statearr_44673_44720[(1)] = (2));

} else {
var statearr_44674_44721 = state_44667__$1;
(statearr_44674_44721[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (24))){
var inst_44659 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44675_44722 = state_44667__$1;
(statearr_44675_44722[(2)] = inst_44659);

(statearr_44675_44722[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (4))){
var inst_44665 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44667__$1,inst_44665);
} else {
if((state_val_44668 === (15))){
var inst_44663 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44676_44723 = state_44667__$1;
(statearr_44676_44723[(2)] = inst_44663);

(statearr_44676_44723[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (21))){
var inst_44616 = (state_44667[(2)]);
var inst_44617 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44618 = figwheel.client.auto_jump_to_error.call(null,opts,inst_44617);
var state_44667__$1 = (function (){var statearr_44677 = state_44667;
(statearr_44677[(7)] = inst_44616);

return statearr_44677;
})();
var statearr_44678_44724 = state_44667__$1;
(statearr_44678_44724[(2)] = inst_44618);

(statearr_44678_44724[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (31))){
var inst_44646 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44646)){
var statearr_44679_44725 = state_44667__$1;
(statearr_44679_44725[(1)] = (34));

} else {
var statearr_44680_44726 = state_44667__$1;
(statearr_44680_44726[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (32))){
var inst_44655 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44681_44727 = state_44667__$1;
(statearr_44681_44727[(2)] = inst_44655);

(statearr_44681_44727[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (33))){
var inst_44642 = (state_44667[(2)]);
var inst_44643 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44644 = figwheel.client.auto_jump_to_error.call(null,opts,inst_44643);
var state_44667__$1 = (function (){var statearr_44682 = state_44667;
(statearr_44682[(8)] = inst_44642);

return statearr_44682;
})();
var statearr_44683_44728 = state_44667__$1;
(statearr_44683_44728[(2)] = inst_44644);

(statearr_44683_44728[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (13))){
var inst_44601 = figwheel.client.heads_up.clear.call(null);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(16),inst_44601);
} else {
if((state_val_44668 === (22))){
var inst_44622 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44623 = figwheel.client.heads_up.append_warning_message.call(null,inst_44622);
var state_44667__$1 = state_44667;
var statearr_44684_44729 = state_44667__$1;
(statearr_44684_44729[(2)] = inst_44623);

(statearr_44684_44729[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (36))){
var inst_44653 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44685_44730 = state_44667__$1;
(statearr_44685_44730[(2)] = inst_44653);

(statearr_44685_44730[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (29))){
var inst_44633 = (state_44667[(2)]);
var inst_44634 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44635 = figwheel.client.auto_jump_to_error.call(null,opts,inst_44634);
var state_44667__$1 = (function (){var statearr_44686 = state_44667;
(statearr_44686[(9)] = inst_44633);

return statearr_44686;
})();
var statearr_44687_44731 = state_44667__$1;
(statearr_44687_44731[(2)] = inst_44635);

(statearr_44687_44731[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (6))){
var inst_44582 = (state_44667[(10)]);
var state_44667__$1 = state_44667;
var statearr_44688_44732 = state_44667__$1;
(statearr_44688_44732[(2)] = inst_44582);

(statearr_44688_44732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (28))){
var inst_44629 = (state_44667[(2)]);
var inst_44630 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44631 = figwheel.client.heads_up.display_warning.call(null,inst_44630);
var state_44667__$1 = (function (){var statearr_44689 = state_44667;
(statearr_44689[(11)] = inst_44629);

return statearr_44689;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(29),inst_44631);
} else {
if((state_val_44668 === (25))){
var inst_44627 = figwheel.client.heads_up.clear.call(null);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(28),inst_44627);
} else {
if((state_val_44668 === (34))){
var inst_44648 = figwheel.client.heads_up.flash_loaded.call(null);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(37),inst_44648);
} else {
if((state_val_44668 === (17))){
var inst_44607 = (state_44667[(2)]);
var inst_44608 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44609 = figwheel.client.auto_jump_to_error.call(null,opts,inst_44608);
var state_44667__$1 = (function (){var statearr_44690 = state_44667;
(statearr_44690[(12)] = inst_44607);

return statearr_44690;
})();
var statearr_44691_44733 = state_44667__$1;
(statearr_44691_44733[(2)] = inst_44609);

(statearr_44691_44733[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (3))){
var inst_44599 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44599)){
var statearr_44692_44734 = state_44667__$1;
(statearr_44692_44734[(1)] = (13));

} else {
var statearr_44693_44735 = state_44667__$1;
(statearr_44693_44735[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (12))){
var inst_44595 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44694_44736 = state_44667__$1;
(statearr_44694_44736[(2)] = inst_44595);

(statearr_44694_44736[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (2))){
var inst_44582 = (state_44667[(10)]);
var inst_44582__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_44667__$1 = (function (){var statearr_44695 = state_44667;
(statearr_44695[(10)] = inst_44582__$1);

return statearr_44695;
})();
if(cljs.core.truth_(inst_44582__$1)){
var statearr_44696_44737 = state_44667__$1;
(statearr_44696_44737[(1)] = (5));

} else {
var statearr_44697_44738 = state_44667__$1;
(statearr_44697_44738[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (23))){
var inst_44625 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44625)){
var statearr_44698_44739 = state_44667__$1;
(statearr_44698_44739[(1)] = (25));

} else {
var statearr_44699_44740 = state_44667__$1;
(statearr_44699_44740[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (35))){
var state_44667__$1 = state_44667;
var statearr_44700_44741 = state_44667__$1;
(statearr_44700_44741[(2)] = null);

(statearr_44700_44741[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (19))){
var inst_44620 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44620)){
var statearr_44701_44742 = state_44667__$1;
(statearr_44701_44742[(1)] = (22));

} else {
var statearr_44702_44743 = state_44667__$1;
(statearr_44702_44743[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (11))){
var inst_44591 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44703_44744 = state_44667__$1;
(statearr_44703_44744[(2)] = inst_44591);

(statearr_44703_44744[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (9))){
var inst_44593 = figwheel.client.heads_up.clear.call(null);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(12),inst_44593);
} else {
if((state_val_44668 === (5))){
var inst_44584 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_44667__$1 = state_44667;
var statearr_44704_44745 = state_44667__$1;
(statearr_44704_44745[(2)] = inst_44584);

(statearr_44704_44745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (14))){
var inst_44611 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44611)){
var statearr_44705_44746 = state_44667__$1;
(statearr_44705_44746[(1)] = (18));

} else {
var statearr_44706_44747 = state_44667__$1;
(statearr_44706_44747[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (26))){
var inst_44637 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44637)){
var statearr_44707_44748 = state_44667__$1;
(statearr_44707_44748[(1)] = (30));

} else {
var statearr_44708_44749 = state_44667__$1;
(statearr_44708_44749[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (16))){
var inst_44603 = (state_44667[(2)]);
var inst_44604 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44605 = figwheel.client.heads_up.display_exception.call(null,inst_44604);
var state_44667__$1 = (function (){var statearr_44709 = state_44667;
(statearr_44709[(13)] = inst_44603);

return statearr_44709;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(17),inst_44605);
} else {
if((state_val_44668 === (30))){
var inst_44639 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44640 = figwheel.client.heads_up.display_warning.call(null,inst_44639);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(33),inst_44640);
} else {
if((state_val_44668 === (10))){
var inst_44597 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44710_44750 = state_44667__$1;
(statearr_44710_44750[(2)] = inst_44597);

(statearr_44710_44750[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (18))){
var inst_44613 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44614 = figwheel.client.heads_up.display_exception.call(null,inst_44613);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(21),inst_44614);
} else {
if((state_val_44668 === (37))){
var inst_44650 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44711_44751 = state_44667__$1;
(statearr_44711_44751[(2)] = inst_44650);

(statearr_44711_44751[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (8))){
var inst_44589 = figwheel.client.heads_up.flash_loaded.call(null);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44667__$1,(11),inst_44589);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__30769__auto__,c__30790__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto____0 = (function (){
var statearr_44712 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44712[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto__);

(statearr_44712[(1)] = (1));

return statearr_44712;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto____1 = (function (state_44667){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_44667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e44713){if((e44713 instanceof Object)){
var ex__30773__auto__ = e44713;
var statearr_44714_44752 = state_44667;
(statearr_44714_44752[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44667);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44753 = state_44667;
state_44667 = G__44753;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto__ = function(state_44667){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto____1.call(this,state_44667);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__,msg_hist,msg_names,msg))
})();
var state__30792__auto__ = (function (){var statearr_44715 = f__30791__auto__.call(null);
(statearr_44715[(6)] = c__30790__auto__);

return statearr_44715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__,msg_hist,msg_names,msg))
);

return c__30790__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__30790__auto___44782 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___44782,ch){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___44782,ch){
return (function (state_44768){
var state_val_44769 = (state_44768[(1)]);
if((state_val_44769 === (1))){
var state_44768__$1 = state_44768;
var statearr_44770_44783 = state_44768__$1;
(statearr_44770_44783[(2)] = null);

(statearr_44770_44783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44769 === (2))){
var state_44768__$1 = state_44768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44768__$1,(4),ch);
} else {
if((state_val_44769 === (3))){
var inst_44766 = (state_44768[(2)]);
var state_44768__$1 = state_44768;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44768__$1,inst_44766);
} else {
if((state_val_44769 === (4))){
var inst_44756 = (state_44768[(7)]);
var inst_44756__$1 = (state_44768[(2)]);
var state_44768__$1 = (function (){var statearr_44771 = state_44768;
(statearr_44771[(7)] = inst_44756__$1);

return statearr_44771;
})();
if(cljs.core.truth_(inst_44756__$1)){
var statearr_44772_44784 = state_44768__$1;
(statearr_44772_44784[(1)] = (5));

} else {
var statearr_44773_44785 = state_44768__$1;
(statearr_44773_44785[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44769 === (5))){
var inst_44756 = (state_44768[(7)]);
var inst_44758 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_44756);
var state_44768__$1 = state_44768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44768__$1,(8),inst_44758);
} else {
if((state_val_44769 === (6))){
var state_44768__$1 = state_44768;
var statearr_44774_44786 = state_44768__$1;
(statearr_44774_44786[(2)] = null);

(statearr_44774_44786[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44769 === (7))){
var inst_44764 = (state_44768[(2)]);
var state_44768__$1 = state_44768;
var statearr_44775_44787 = state_44768__$1;
(statearr_44775_44787[(2)] = inst_44764);

(statearr_44775_44787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44769 === (8))){
var inst_44760 = (state_44768[(2)]);
var state_44768__$1 = (function (){var statearr_44776 = state_44768;
(statearr_44776[(8)] = inst_44760);

return statearr_44776;
})();
var statearr_44777_44788 = state_44768__$1;
(statearr_44777_44788[(2)] = null);

(statearr_44777_44788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__30790__auto___44782,ch))
;
return ((function (switch__30769__auto__,c__30790__auto___44782,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__30770__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__30770__auto____0 = (function (){
var statearr_44778 = [null,null,null,null,null,null,null,null,null];
(statearr_44778[(0)] = figwheel$client$heads_up_plugin_$_state_machine__30770__auto__);

(statearr_44778[(1)] = (1));

return statearr_44778;
});
var figwheel$client$heads_up_plugin_$_state_machine__30770__auto____1 = (function (state_44768){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_44768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e44779){if((e44779 instanceof Object)){
var ex__30773__auto__ = e44779;
var statearr_44780_44789 = state_44768;
(statearr_44780_44789[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44768);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44779;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44790 = state_44768;
state_44768 = G__44790;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__30770__auto__ = function(state_44768){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__30770__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__30770__auto____1.call(this,state_44768);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__30770__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__30770__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___44782,ch))
})();
var state__30792__auto__ = (function (){var statearr_44781 = f__30791__auto__.call(null);
(statearr_44781[(6)] = c__30790__auto___44782);

return statearr_44781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___44782,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__){
return (function (state_44796){
var state_val_44797 = (state_44796[(1)]);
if((state_val_44797 === (1))){
var inst_44791 = cljs.core.async.timeout.call(null,(3000));
var state_44796__$1 = state_44796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44796__$1,(2),inst_44791);
} else {
if((state_val_44797 === (2))){
var inst_44793 = (state_44796[(2)]);
var inst_44794 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_44796__$1 = (function (){var statearr_44798 = state_44796;
(statearr_44798[(7)] = inst_44793);

return statearr_44798;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44796__$1,inst_44794);
} else {
return null;
}
}
});})(c__30790__auto__))
;
return ((function (switch__30769__auto__,c__30790__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__30770__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__30770__auto____0 = (function (){
var statearr_44799 = [null,null,null,null,null,null,null,null];
(statearr_44799[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__30770__auto__);

(statearr_44799[(1)] = (1));

return statearr_44799;
});
var figwheel$client$enforce_project_plugin_$_state_machine__30770__auto____1 = (function (state_44796){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_44796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e44800){if((e44800 instanceof Object)){
var ex__30773__auto__ = e44800;
var statearr_44801_44803 = state_44796;
(statearr_44801_44803[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44800;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44804 = state_44796;
state_44796 = G__44804;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__30770__auto__ = function(state_44796){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__30770__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__30770__auto____1.call(this,state_44796);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__30770__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__30770__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__))
})();
var state__30792__auto__ = (function (){var statearr_44802 = f__30791__auto__.call(null);
(statearr_44802[(6)] = c__30790__auto__);

return statearr_44802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__))
);

return c__30790__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__,figwheel_version,temp__4657__auto__){
return (function (state_44811){
var state_val_44812 = (state_44811[(1)]);
if((state_val_44812 === (1))){
var inst_44805 = cljs.core.async.timeout.call(null,(2000));
var state_44811__$1 = state_44811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44811__$1,(2),inst_44805);
} else {
if((state_val_44812 === (2))){
var inst_44807 = (state_44811[(2)]);
var inst_44808 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_44809 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_44808);
var state_44811__$1 = (function (){var statearr_44813 = state_44811;
(statearr_44813[(7)] = inst_44807);

return statearr_44813;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44811__$1,inst_44809);
} else {
return null;
}
}
});})(c__30790__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__30769__auto__,c__30790__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto____0 = (function (){
var statearr_44814 = [null,null,null,null,null,null,null,null];
(statearr_44814[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto__);

(statearr_44814[(1)] = (1));

return statearr_44814;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto____1 = (function (state_44811){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_44811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e44815){if((e44815 instanceof Object)){
var ex__30773__auto__ = e44815;
var statearr_44816_44818 = state_44811;
(statearr_44816_44818[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44811);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44815;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44819 = state_44811;
state_44811 = G__44819;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto__ = function(state_44811){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto____1.call(this,state_44811);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__,figwheel_version,temp__4657__auto__))
})();
var state__30792__auto__ = (function (){var statearr_44817 = f__30791__auto__.call(null);
(statearr_44817[(6)] = c__30790__auto__);

return statearr_44817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__,figwheel_version,temp__4657__auto__))
);

return c__30790__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__44820){
var map__44821 = p__44820;
var map__44821__$1 = ((((!((map__44821 == null)))?((((map__44821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44821.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44821):map__44821);
var file = cljs.core.get.call(null,map__44821__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__44821__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__44821__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__44823 = "";
var G__44823__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44823),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__44823);
var G__44823__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44823__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__44823__$1);
if(cljs.core.truth_((function (){var and__28335__auto__ = line;
if(cljs.core.truth_(and__28335__auto__)){
return column;
} else {
return and__28335__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44823__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__44823__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__44824){
var map__44825 = p__44824;
var map__44825__$1 = ((((!((map__44825 == null)))?((((map__44825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44825.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44825):map__44825);
var ed = map__44825__$1;
var formatted_exception = cljs.core.get.call(null,map__44825__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__44825__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__44825__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__44827_44831 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__44828_44832 = null;
var count__44829_44833 = (0);
var i__44830_44834 = (0);
while(true){
if((i__44830_44834 < count__44829_44833)){
var msg_44835 = cljs.core._nth.call(null,chunk__44828_44832,i__44830_44834);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_44835);

var G__44836 = seq__44827_44831;
var G__44837 = chunk__44828_44832;
var G__44838 = count__44829_44833;
var G__44839 = (i__44830_44834 + (1));
seq__44827_44831 = G__44836;
chunk__44828_44832 = G__44837;
count__44829_44833 = G__44838;
i__44830_44834 = G__44839;
continue;
} else {
var temp__4657__auto___44840 = cljs.core.seq.call(null,seq__44827_44831);
if(temp__4657__auto___44840){
var seq__44827_44841__$1 = temp__4657__auto___44840;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44827_44841__$1)){
var c__29186__auto___44842 = cljs.core.chunk_first.call(null,seq__44827_44841__$1);
var G__44843 = cljs.core.chunk_rest.call(null,seq__44827_44841__$1);
var G__44844 = c__29186__auto___44842;
var G__44845 = cljs.core.count.call(null,c__29186__auto___44842);
var G__44846 = (0);
seq__44827_44831 = G__44843;
chunk__44828_44832 = G__44844;
count__44829_44833 = G__44845;
i__44830_44834 = G__44846;
continue;
} else {
var msg_44847 = cljs.core.first.call(null,seq__44827_44841__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_44847);

var G__44848 = cljs.core.next.call(null,seq__44827_44841__$1);
var G__44849 = null;
var G__44850 = (0);
var G__44851 = (0);
seq__44827_44831 = G__44848;
chunk__44828_44832 = G__44849;
count__44829_44833 = G__44850;
i__44830_44834 = G__44851;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__44852){
var map__44853 = p__44852;
var map__44853__$1 = ((((!((map__44853 == null)))?((((map__44853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44853.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44853):map__44853);
var w = map__44853__$1;
var message = cljs.core.get.call(null,map__44853__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28335__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28335__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28335__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__44855 = cljs.core.seq.call(null,plugins);
var chunk__44856 = null;
var count__44857 = (0);
var i__44858 = (0);
while(true){
if((i__44858 < count__44857)){
var vec__44859 = cljs.core._nth.call(null,chunk__44856,i__44858);
var k = cljs.core.nth.call(null,vec__44859,(0),null);
var plugin = cljs.core.nth.call(null,vec__44859,(1),null);
if(cljs.core.truth_(plugin)){
var pl_44865 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__44855,chunk__44856,count__44857,i__44858,pl_44865,vec__44859,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_44865.call(null,msg_hist);
});})(seq__44855,chunk__44856,count__44857,i__44858,pl_44865,vec__44859,k,plugin))
);
} else {
}

var G__44866 = seq__44855;
var G__44867 = chunk__44856;
var G__44868 = count__44857;
var G__44869 = (i__44858 + (1));
seq__44855 = G__44866;
chunk__44856 = G__44867;
count__44857 = G__44868;
i__44858 = G__44869;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__44855);
if(temp__4657__auto__){
var seq__44855__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44855__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__44855__$1);
var G__44870 = cljs.core.chunk_rest.call(null,seq__44855__$1);
var G__44871 = c__29186__auto__;
var G__44872 = cljs.core.count.call(null,c__29186__auto__);
var G__44873 = (0);
seq__44855 = G__44870;
chunk__44856 = G__44871;
count__44857 = G__44872;
i__44858 = G__44873;
continue;
} else {
var vec__44862 = cljs.core.first.call(null,seq__44855__$1);
var k = cljs.core.nth.call(null,vec__44862,(0),null);
var plugin = cljs.core.nth.call(null,vec__44862,(1),null);
if(cljs.core.truth_(plugin)){
var pl_44874 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__44855,chunk__44856,count__44857,i__44858,pl_44874,vec__44862,k,plugin,seq__44855__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_44874.call(null,msg_hist);
});})(seq__44855,chunk__44856,count__44857,i__44858,pl_44874,vec__44862,k,plugin,seq__44855__$1,temp__4657__auto__))
);
} else {
}

var G__44875 = cljs.core.next.call(null,seq__44855__$1);
var G__44876 = null;
var G__44877 = (0);
var G__44878 = (0);
seq__44855 = G__44875;
chunk__44856 = G__44876;
count__44857 = G__44877;
i__44858 = G__44878;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__44880 = arguments.length;
switch (G__44880) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__44881_44886 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__44882_44887 = null;
var count__44883_44888 = (0);
var i__44884_44889 = (0);
while(true){
if((i__44884_44889 < count__44883_44888)){
var msg_44890 = cljs.core._nth.call(null,chunk__44882_44887,i__44884_44889);
figwheel.client.socket.handle_incoming_message.call(null,msg_44890);

var G__44891 = seq__44881_44886;
var G__44892 = chunk__44882_44887;
var G__44893 = count__44883_44888;
var G__44894 = (i__44884_44889 + (1));
seq__44881_44886 = G__44891;
chunk__44882_44887 = G__44892;
count__44883_44888 = G__44893;
i__44884_44889 = G__44894;
continue;
} else {
var temp__4657__auto___44895 = cljs.core.seq.call(null,seq__44881_44886);
if(temp__4657__auto___44895){
var seq__44881_44896__$1 = temp__4657__auto___44895;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44881_44896__$1)){
var c__29186__auto___44897 = cljs.core.chunk_first.call(null,seq__44881_44896__$1);
var G__44898 = cljs.core.chunk_rest.call(null,seq__44881_44896__$1);
var G__44899 = c__29186__auto___44897;
var G__44900 = cljs.core.count.call(null,c__29186__auto___44897);
var G__44901 = (0);
seq__44881_44886 = G__44898;
chunk__44882_44887 = G__44899;
count__44883_44888 = G__44900;
i__44884_44889 = G__44901;
continue;
} else {
var msg_44902 = cljs.core.first.call(null,seq__44881_44896__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_44902);

var G__44903 = cljs.core.next.call(null,seq__44881_44896__$1);
var G__44904 = null;
var G__44905 = (0);
var G__44906 = (0);
seq__44881_44886 = G__44903;
chunk__44882_44887 = G__44904;
count__44883_44888 = G__44905;
i__44884_44889 = G__44906;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29523__auto__ = [];
var len__29516__auto___44911 = arguments.length;
var i__29517__auto___44912 = (0);
while(true){
if((i__29517__auto___44912 < len__29516__auto___44911)){
args__29523__auto__.push((arguments[i__29517__auto___44912]));

var G__44913 = (i__29517__auto___44912 + (1));
i__29517__auto___44912 = G__44913;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__44908){
var map__44909 = p__44908;
var map__44909__$1 = ((((!((map__44909 == null)))?((((map__44909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44909.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44909):map__44909);
var opts = map__44909__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq44907){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44907));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e44914){if((e44914 instanceof Error)){
var e = e44914;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e44914;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__44915){
var map__44916 = p__44915;
var map__44916__$1 = ((((!((map__44916 == null)))?((((map__44916.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44916.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44916):map__44916);
var msg_name = cljs.core.get.call(null,map__44916__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1503821890395
