// Compiled by ClojureScript 1.9.908 {}
goog.provide('cmr.client.common.util');
goog.require('cljs.core');
goog.require('cmr.client.common.const$');
goog.require('cljs.core.async');
cmr.client.common.util.default_environment_type = new cljs.core.Keyword(null,"prod","prod",1846120297);
cmr.client.common.util.get_endpoint = (function cmr$client$common$util$get_endpoint(environment_type,service_key){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(environment_type.call(null,cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[service_key,environment_type.call(null,cmr.client.common.const$.deployment_type)],null))))].join('');
});
cmr.client.common.util.get_default_endpoint = (function cmr$client$common$util$get_default_endpoint(options,service_key){
var or__28347__auto__ = new cljs.core.Keyword(null,"endpoint","endpoint",447890044).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cmr.client.common.util.get_endpoint.call(null,cmr.client.common.util.default_environment_type,service_key);
}
});
cmr.client.common.util.parse_endpoint = (function cmr$client$common$util$parse_endpoint(var_args){
var G__41507 = arguments.length;
switch (G__41507) {
case 1:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1 = (function (endpoint){
return cmr.client.common.util.parse_endpoint.call(null,endpoint,null);
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2 = (function (endpoint,service_key){
if(typeof endpoint === 'string'){
return endpoint;
} else {
return cmr.client.common.util.get_endpoint.call(null,endpoint,service_key);
}
});

cmr.client.common.util.parse_endpoint.cljs$lang$maxFixedArity = 2;

cmr.client.common.util.with_callback = (function cmr$client$common$util$with_callback(chan,callback){
var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__){
return (function (state_41521){
var state_val_41522 = (state_41521[(1)]);
if((state_val_41522 === (1))){
var state_41521__$1 = state_41521;
var statearr_41523_41534 = state_41521__$1;
(statearr_41523_41534[(2)] = null);

(statearr_41523_41534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41522 === (2))){
var state_41521__$1 = state_41521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41521__$1,(4),chan);
} else {
if((state_val_41522 === (3))){
var inst_41519 = (state_41521[(2)]);
var state_41521__$1 = state_41521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41521__$1,inst_41519);
} else {
if((state_val_41522 === (4))){
var inst_41511 = (state_41521[(7)]);
var inst_41511__$1 = (state_41521[(2)]);
var state_41521__$1 = (function (){var statearr_41524 = state_41521;
(statearr_41524[(7)] = inst_41511__$1);

return statearr_41524;
})();
if(cljs.core.truth_(inst_41511__$1)){
var statearr_41525_41535 = state_41521__$1;
(statearr_41525_41535[(1)] = (5));

} else {
var statearr_41526_41536 = state_41521__$1;
(statearr_41526_41536[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41522 === (5))){
var inst_41511 = (state_41521[(7)]);
var inst_41513 = callback.call(null,inst_41511);
var state_41521__$1 = state_41521;
var statearr_41527_41537 = state_41521__$1;
(statearr_41527_41537[(2)] = inst_41513);

(statearr_41527_41537[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41522 === (6))){
var state_41521__$1 = state_41521;
var statearr_41528_41538 = state_41521__$1;
(statearr_41528_41538[(2)] = null);

(statearr_41528_41538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41522 === (7))){
var inst_41517 = (state_41521[(2)]);
var state_41521__$1 = state_41521;
var statearr_41529_41539 = state_41521__$1;
(statearr_41529_41539[(2)] = inst_41517);

(statearr_41529_41539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30790__auto__))
;
return ((function (switch__30769__auto__,c__30790__auto__){
return (function() {
var cmr$client$common$util$with_callback_$_state_machine__30770__auto__ = null;
var cmr$client$common$util$with_callback_$_state_machine__30770__auto____0 = (function (){
var statearr_41530 = [null,null,null,null,null,null,null,null];
(statearr_41530[(0)] = cmr$client$common$util$with_callback_$_state_machine__30770__auto__);

(statearr_41530[(1)] = (1));

return statearr_41530;
});
var cmr$client$common$util$with_callback_$_state_machine__30770__auto____1 = (function (state_41521){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_41521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e41531){if((e41531 instanceof Object)){
var ex__30773__auto__ = e41531;
var statearr_41532_41540 = state_41521;
(statearr_41532_41540[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41521);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41531;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41541 = state_41521;
state_41521 = G__41541;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cmr$client$common$util$with_callback_$_state_machine__30770__auto__ = function(state_41521){
switch(arguments.length){
case 0:
return cmr$client$common$util$with_callback_$_state_machine__30770__auto____0.call(this);
case 1:
return cmr$client$common$util$with_callback_$_state_machine__30770__auto____1.call(this,state_41521);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cmr$client$common$util$with_callback_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cmr$client$common$util$with_callback_$_state_machine__30770__auto____0;
cmr$client$common$util$with_callback_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cmr$client$common$util$with_callback_$_state_machine__30770__auto____1;
return cmr$client$common$util$with_callback_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__))
})();
var state__30792__auto__ = (function (){var statearr_41533 = f__30791__auto__.call(null);
(statearr_41533[(6)] = c__30790__auto__);

return statearr_41533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__))
);

return c__30790__auto__;
});
goog.exportSymbol('cmr.client.common.util.with_callback', cmr.client.common.util.with_callback);
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `service-type` - must be one of the supported service types, notably
 *  `:ingest`, `:search`, or `:access-control`
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 *   * `options-fn` - a functin which creates the client client options, including
 *  basic defaults, for the implementation; it should be a function that in
 *  turn calls a `CMR*ClientOpions` constructor
 *   * `http-client-constructor` - a function that instrantiates the CMR HTTP
 *  client used by all CMR service type clients (different for Clojure and
 *  ClojureScript)
 * 
 *   This docstring is a bit dense; for more clarity, be sure to view the calls
 *   made to this function in both the Clojure and ClojureScript clients.
 */
cmr.client.common.util.create_service_client_constructor = (function cmr$client$common$util$create_service_client_constructor(servie_type,client_constructor_var,client_data_constructor,options_fn,http_client_constructor){
return (function() {
var G__41542 = null;
var G__41542__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__41542__1 = (function (options){
return client_constructor_var.call(null,options,cljs.core.PersistentArrayMap.EMPTY);
});
var G__41542__2 = (function (options,http_options){
var endpoint = cmr.client.common.util.get_default_endpoint.call(null,options,servie_type);
var client_options = options_fn.call(null,options);
var http_client = http_client_constructor.call(null,client_options,http_options);
return client_data_constructor.call(null,cmr.client.common.util.parse_endpoint.call(null,endpoint,servie_type),client_options,http_client);
});
G__41542 = function(options,http_options){
switch(arguments.length){
case 0:
return G__41542__0.call(this);
case 1:
return G__41542__1.call(this,options);
case 2:
return G__41542__2.call(this,options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__41542.cljs$core$IFn$_invoke$arity$0 = G__41542__0;
G__41542.cljs$core$IFn$_invoke$arity$1 = G__41542__1;
G__41542.cljs$core$IFn$_invoke$arity$2 = G__41542__2;
return G__41542;
})()
});
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 */
cmr.client.common.util.create_http_client_constructor = (function cmr$client$common$util$create_http_client_constructor(client_constructor_var,client_data_constructor){
return (function() {
var G__41543 = null;
var G__41543__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__41543__1 = (function (http_options){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY,http_options);
});
var G__41543__2 = (function (parent_client_options,http_options){
return client_data_constructor.call(null,parent_client_options,http_options);
});
G__41543 = function(parent_client_options,http_options){
switch(arguments.length){
case 0:
return G__41543__0.call(this);
case 1:
return G__41543__1.call(this,parent_client_options);
case 2:
return G__41543__2.call(this,parent_client_options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__41543.cljs$core$IFn$_invoke$arity$0 = G__41543__0;
G__41543.cljs$core$IFn$_invoke$arity$1 = G__41543__1;
G__41543.cljs$core$IFn$_invoke$arity$2 = G__41543__2;
return G__41543;
})()
});

//# sourceMappingURL=util.js.map?rel=1503821288447
