(ns cmr.client.ac.core
 (:require
  [cmr.client.base :as base]
  [cmr.client.common.util :as util]
  [cmr.client.http.core :as http]
  [cmr.client.ac.impl :as impl])
 (:import
  (cmr.client.ac.impl CMRAccessControlClientData)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Protocols &tc.   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defprotocol CMRAccessControlAPI
  (get-acls [this http-options] [this query-params http-options])
  (get-groups [this http-options] [this query-params http-options])
  (get-health [this] [this http-options])
  (get-permissions [this http-options] [this query-params http-options]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Implementation   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(extend CMRAccessControlClientData
        CMRAccessControlAPI
        impl/client-behaviour)

(extend CMRAccessControlClientData
        base/CMRClientAPI
        base/client-behaviour)

(def create-client
  (util/create-service-client-constructor
   :access-control
   #'cmr.client.ac.core/create-client
   impl/->CMRAccessControlClientData
   base/make-options
   http/create-client))
