// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__8189__auto__ = v;
if(cljs.core.truth_(and__8189__auto__)){
return (v > (0));
} else {
return and__8189__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__13515_SHARP_,p2__13514_SHARP_){
var vec__13516 = clojure.string.split.call(null,p2__13514_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__13516,(0),null);
var v = cljs.core.nth.call(null,vec__13516,(1),null);
return cljs.core.assoc.call(null,p1__13515_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__13519_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__13519_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__13520){
var vec__13521 = p__13520;
var k = cljs.core.nth.call(null,vec__13521,(0),null);
var v = cljs.core.nth.call(null,vec__13521,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__13524_SHARP_){
return ["\\",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__13524_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__8189__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__8189__auto__){
var and__8189__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__8189__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__8189__auto____$1;
}
} else {
return and__8189__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__13525_SHARP_){
return cljs_http.client.decode_body.call(null,p1__13525_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13532 = arguments.length;
var i__9371__auto___13533 = (0);
while(true){
if((i__9371__auto___13533 < len__9370__auto___13532)){
args__9377__auto__.push((arguments[i__9371__auto___13533]));

var G__13534 = (i__9371__auto___13533 + (1));
i__9371__auto___13533 = G__13534;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__13528){
var vec__13529 = p__13528;
var default_headers = cljs.core.nth.call(null,vec__13529,(0),null);
return ((function (vec__13529,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__8201__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8201__auto__)){
return or__8201__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__13529,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq13526){
var G__13527 = cljs.core.first.call(null,seq13526);
var seq13526__$1 = cljs.core.next.call(null,seq13526);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__13527,seq13526__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13541 = arguments.length;
var i__9371__auto___13542 = (0);
while(true){
if((i__9371__auto___13542 < len__9370__auto___13541)){
args__9377__auto__.push((arguments[i__9371__auto___13542]));

var G__13543 = (i__9371__auto___13542 + (1));
i__9371__auto___13542 = G__13543;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__13537){
var vec__13538 = p__13537;
var accept = cljs.core.nth.call(null,vec__13538,(0),null);
return ((function (vec__13538,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__8201__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8201__auto__)){
return or__8201__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var accept__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__13538,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq13535){
var G__13536 = cljs.core.first.call(null,seq13535);
var seq13535__$1 = cljs.core.next.call(null,seq13535);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__13536,seq13535__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13550 = arguments.length;
var i__9371__auto___13551 = (0);
while(true){
if((i__9371__auto___13551 < len__9370__auto___13550)){
args__9377__auto__.push((arguments[i__9371__auto___13551]));

var G__13552 = (i__9371__auto___13551 + (1));
i__9371__auto___13551 = G__13552;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__13546){
var vec__13547 = p__13546;
var content_type = cljs.core.nth.call(null,vec__13547,(0),null);
return ((function (vec__13547,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__8201__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8201__auto__)){
return or__8201__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__13547,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq13544){
var G__13545 = cljs.core.first.call(null,seq13544);
var seq13544__$1 = cljs.core.next.call(null,seq13544);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__13545,seq13544__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__13553 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__13553__$1 = ((((!((map__13553 == null)))?((((map__13553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13553.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13553):map__13553);
var encoding = cljs.core.get.call(null,map__13553__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__13553__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__13557 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__13557__$1 = ((((!((map__13557 == null)))?((((map__13557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13557.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13557):map__13557);
var decoding = cljs.core.get.call(null,map__13557__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__13557__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__13557,map__13557__$1,decoding,decoding_opts){
return (function (p1__13555_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__13555_SHARP_,decoding,decoding_opts);
});})(map__13557,map__13557__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__13557,map__13557__$1,decoding,decoding_opts,transit_decode){
return (function (p1__13556_SHARP_){
return cljs_http.client.decode_body.call(null,p1__13556_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__13557,map__13557__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__13559_SHARP_){
return cljs_http.client.decode_body.call(null,p1__13559_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__13560){
var map__13561 = p__13560;
var map__13561__$1 = ((((!((map__13561 == null)))?((((map__13561.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13561.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13561):map__13561);
var req = map__13561__$1;
var query_params = cljs.core.get.call(null,map__13561__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__13563){
var map__13564 = p__13563;
var map__13564__$1 = ((((!((map__13564 == null)))?((((map__13564.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13564.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13564):map__13564);
var request = map__13564__$1;
var form_params = cljs.core.get.call(null,map__13564__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__13564__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__13564__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__8189__auto__ = form_params;
if(cljs.core.truth_(and__8189__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__8189__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__13566_13576 = cljs.core.seq.call(null,params);
var chunk__13567_13577 = null;
var count__13568_13578 = (0);
var i__13569_13579 = (0);
while(true){
if((i__13569_13579 < count__13568_13578)){
var vec__13570_13580 = cljs.core._nth.call(null,chunk__13567_13577,i__13569_13579);
var k_13581 = cljs.core.nth.call(null,vec__13570_13580,(0),null);
var v_13582 = cljs.core.nth.call(null,vec__13570_13580,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_13582)){
form_data.append(cljs.core.name.call(null,k_13581),cljs.core.first.call(null,v_13582),cljs.core.second.call(null,v_13582));
} else {
form_data.append(cljs.core.name.call(null,k_13581),v_13582);
}

var G__13583 = seq__13566_13576;
var G__13584 = chunk__13567_13577;
var G__13585 = count__13568_13578;
var G__13586 = (i__13569_13579 + (1));
seq__13566_13576 = G__13583;
chunk__13567_13577 = G__13584;
count__13568_13578 = G__13585;
i__13569_13579 = G__13586;
continue;
} else {
var temp__4657__auto___13587 = cljs.core.seq.call(null,seq__13566_13576);
if(temp__4657__auto___13587){
var seq__13566_13588__$1 = temp__4657__auto___13587;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13566_13588__$1)){
var c__9040__auto___13589 = cljs.core.chunk_first.call(null,seq__13566_13588__$1);
var G__13590 = cljs.core.chunk_rest.call(null,seq__13566_13588__$1);
var G__13591 = c__9040__auto___13589;
var G__13592 = cljs.core.count.call(null,c__9040__auto___13589);
var G__13593 = (0);
seq__13566_13576 = G__13590;
chunk__13567_13577 = G__13591;
count__13568_13578 = G__13592;
i__13569_13579 = G__13593;
continue;
} else {
var vec__13573_13594 = cljs.core.first.call(null,seq__13566_13588__$1);
var k_13595 = cljs.core.nth.call(null,vec__13573_13594,(0),null);
var v_13596 = cljs.core.nth.call(null,vec__13573_13594,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_13596)){
form_data.append(cljs.core.name.call(null,k_13595),cljs.core.first.call(null,v_13596),cljs.core.second.call(null,v_13596));
} else {
form_data.append(cljs.core.name.call(null,k_13595),v_13596);
}

var G__13597 = cljs.core.next.call(null,seq__13566_13588__$1);
var G__13598 = null;
var G__13599 = (0);
var G__13600 = (0);
seq__13566_13576 = G__13597;
chunk__13567_13577 = G__13598;
count__13568_13578 = G__13599;
i__13569_13579 = G__13600;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__13601){
var map__13602 = p__13601;
var map__13602__$1 = ((((!((map__13602 == null)))?((((map__13602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13602.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13602):map__13602);
var request = map__13602__$1;
var multipart_params = cljs.core.get.call(null,map__13602__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__13602__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__8189__auto__ = multipart_params;
if(cljs.core.truth_(and__8189__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__8189__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__13604_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__13604_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__13606){
var map__13607 = p__13606;
var map__13607__$1 = ((((!((map__13607 == null)))?((((map__13607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13607.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13607):map__13607);
var req = map__13607__$1;
var query_params = cljs.core.get.call(null,map__13607__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4655__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4655__auto__,map__13607,map__13607__$1,req,query_params){
return (function (p1__13605_SHARP_){
return cljs.core.merge.call(null,p1__13605_SHARP_,query_params);
});})(spec,temp__4655__auto__,map__13607,map__13607__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13615 = arguments.length;
var i__9371__auto___13616 = (0);
while(true){
if((i__9371__auto___13616 < len__9370__auto___13615)){
args__9377__auto__.push((arguments[i__9371__auto___13616]));

var G__13617 = (i__9371__auto___13616 + (1));
i__9371__auto___13616 = G__13617;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__13611){
var vec__13612 = p__13611;
var credentials = cljs.core.nth.call(null,vec__13612,(0),null);
return ((function (vec__13612,credentials){
return (function (req){
var credentials__$1 = (function (){var or__8201__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__8201__auto__)){
return or__8201__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__13612,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq13609){
var G__13610 = cljs.core.first.call(null,seq13609);
var seq13609__$1 = cljs.core.next.call(null,seq13609);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__13610,seq13609__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13624 = arguments.length;
var i__9371__auto___13625 = (0);
while(true){
if((i__9371__auto___13625 < len__9370__auto___13624)){
args__9377__auto__.push((arguments[i__9371__auto___13625]));

var G__13626 = (i__9371__auto___13625 + (1));
i__9371__auto___13625 = G__13626;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13620){
var vec__13621 = p__13620;
var req = cljs.core.nth.call(null,vec__13621,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq13618){
var G__13619 = cljs.core.first.call(null,seq13618);
var seq13618__$1 = cljs.core.next.call(null,seq13618);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__13619,seq13618__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13633 = arguments.length;
var i__9371__auto___13634 = (0);
while(true){
if((i__9371__auto___13634 < len__9370__auto___13633)){
args__9377__auto__.push((arguments[i__9371__auto___13634]));

var G__13635 = (i__9371__auto___13634 + (1));
i__9371__auto___13634 = G__13635;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13629){
var vec__13630 = p__13629;
var req = cljs.core.nth.call(null,vec__13630,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq13627){
var G__13628 = cljs.core.first.call(null,seq13627);
var seq13627__$1 = cljs.core.next.call(null,seq13627);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__13628,seq13627__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13642 = arguments.length;
var i__9371__auto___13643 = (0);
while(true){
if((i__9371__auto___13643 < len__9370__auto___13642)){
args__9377__auto__.push((arguments[i__9371__auto___13643]));

var G__13644 = (i__9371__auto___13643 + (1));
i__9371__auto___13643 = G__13644;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13638){
var vec__13639 = p__13638;
var req = cljs.core.nth.call(null,vec__13639,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq13636){
var G__13637 = cljs.core.first.call(null,seq13636);
var seq13636__$1 = cljs.core.next.call(null,seq13636);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__13637,seq13636__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13651 = arguments.length;
var i__9371__auto___13652 = (0);
while(true){
if((i__9371__auto___13652 < len__9370__auto___13651)){
args__9377__auto__.push((arguments[i__9371__auto___13652]));

var G__13653 = (i__9371__auto___13652 + (1));
i__9371__auto___13652 = G__13653;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13647){
var vec__13648 = p__13647;
var req = cljs.core.nth.call(null,vec__13648,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq13645){
var G__13646 = cljs.core.first.call(null,seq13645);
var seq13645__$1 = cljs.core.next.call(null,seq13645);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__13646,seq13645__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13660 = arguments.length;
var i__9371__auto___13661 = (0);
while(true){
if((i__9371__auto___13661 < len__9370__auto___13660)){
args__9377__auto__.push((arguments[i__9371__auto___13661]));

var G__13662 = (i__9371__auto___13661 + (1));
i__9371__auto___13661 = G__13662;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13656){
var vec__13657 = p__13656;
var req = cljs.core.nth.call(null,vec__13657,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq13654){
var G__13655 = cljs.core.first.call(null,seq13654);
var seq13654__$1 = cljs.core.next.call(null,seq13654);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__13655,seq13654__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13669 = arguments.length;
var i__9371__auto___13670 = (0);
while(true){
if((i__9371__auto___13670 < len__9370__auto___13669)){
args__9377__auto__.push((arguments[i__9371__auto___13670]));

var G__13671 = (i__9371__auto___13670 + (1));
i__9371__auto___13670 = G__13671;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13665){
var vec__13666 = p__13665;
var req = cljs.core.nth.call(null,vec__13666,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq13663){
var G__13664 = cljs.core.first.call(null,seq13663);
var seq13663__$1 = cljs.core.next.call(null,seq13663);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__13664,seq13663__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13678 = arguments.length;
var i__9371__auto___13679 = (0);
while(true){
if((i__9371__auto___13679 < len__9370__auto___13678)){
args__9377__auto__.push((arguments[i__9371__auto___13679]));

var G__13680 = (i__9371__auto___13679 + (1));
i__9371__auto___13679 = G__13680;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13674){
var vec__13675 = p__13674;
var req = cljs.core.nth.call(null,vec__13675,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq13672){
var G__13673 = cljs.core.first.call(null,seq13672);
var seq13672__$1 = cljs.core.next.call(null,seq13672);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__13673,seq13672__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13687 = arguments.length;
var i__9371__auto___13688 = (0);
while(true){
if((i__9371__auto___13688 < len__9370__auto___13687)){
args__9377__auto__.push((arguments[i__9371__auto___13688]));

var G__13689 = (i__9371__auto___13688 + (1));
i__9371__auto___13688 = G__13689;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13683){
var vec__13684 = p__13683;
var req = cljs.core.nth.call(null,vec__13684,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq13681){
var G__13682 = cljs.core.first.call(null,seq13681);
var seq13681__$1 = cljs.core.next.call(null,seq13681);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__13682,seq13681__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__9377__auto__ = [];
var len__9370__auto___13696 = arguments.length;
var i__9371__auto___13697 = (0);
while(true){
if((i__9371__auto___13697 < len__9370__auto___13696)){
args__9377__auto__.push((arguments[i__9371__auto___13697]));

var G__13698 = (i__9371__auto___13697 + (1));
i__9371__auto___13697 = G__13698;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__13692){
var vec__13693 = p__13692;
var req = cljs.core.nth.call(null,vec__13693,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq13690){
var G__13691 = cljs.core.first.call(null,seq13690);
var seq13690__$1 = cljs.core.next.call(null,seq13690);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__13691,seq13690__$1);
});


//# sourceMappingURL=client.js.map
