// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__14074 = arguments.length;
switch (G__14074) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14075 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14075 = (function (f,blockable,meta14076){
this.f = f;
this.blockable = blockable;
this.meta14076 = meta14076;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async14075.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14077,meta14076__$1){
var self__ = this;
var _14077__$1 = this;
return (new cljs.core.async.t_cljs$core$async14075(self__.f,self__.blockable,meta14076__$1));
});

cljs.core.async.t_cljs$core$async14075.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14077){
var self__ = this;
var _14077__$1 = this;
return self__.meta14076;
});

cljs.core.async.t_cljs$core$async14075.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14075.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14075.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14075.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14075.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14076","meta14076",1164805151,null)], null);
});

cljs.core.async.t_cljs$core$async14075.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14075.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14075";

cljs.core.async.t_cljs$core$async14075.cljs$lang$ctorPrWriter = (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async14075");
});

cljs.core.async.__GT_t_cljs$core$async14075 = (function cljs$core$async$__GT_t_cljs$core$async14075(f__$1,blockable__$1,meta14076){
return (new cljs.core.async.t_cljs$core$async14075(f__$1,blockable__$1,meta14076));
});

}

return (new cljs.core.async.t_cljs$core$async14075(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__14081 = arguments.length;
switch (G__14081) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__14084 = arguments.length;
switch (G__14084) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__14087 = arguments.length;
switch (G__14087) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14089 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14089);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14089,ret){
return (function (){
return fn1.call(null,val_14089);
});})(val_14089,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__14091 = arguments.length;
switch (G__14091) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9146__auto___14093 = n;
var x_14094 = (0);
while(true){
if((x_14094 < n__9146__auto___14093)){
(a[x_14094] = (0));

var G__14095 = (x_14094 + (1));
x_14094 = G__14095;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14096 = (i + (1));
i = G__14096;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14097 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14097 = (function (flag,meta14098){
this.flag = flag;
this.meta14098 = meta14098;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async14097.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14099,meta14098__$1){
var self__ = this;
var _14099__$1 = this;
return (new cljs.core.async.t_cljs$core$async14097(self__.flag,meta14098__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14097.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14099){
var self__ = this;
var _14099__$1 = this;
return self__.meta14098;
});})(flag))
;

cljs.core.async.t_cljs$core$async14097.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14097.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14097.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14097.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14097.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14098","meta14098",1074145091,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14097.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14097.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14097";

cljs.core.async.t_cljs$core$async14097.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async14097");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14097 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14097(flag__$1,meta14098){
return (new cljs.core.async.t_cljs$core$async14097(flag__$1,meta14098));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14097(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14100 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14100 = (function (flag,cb,meta14101){
this.flag = flag;
this.cb = cb;
this.meta14101 = meta14101;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async14100.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14102,meta14101__$1){
var self__ = this;
var _14102__$1 = this;
return (new cljs.core.async.t_cljs$core$async14100(self__.flag,self__.cb,meta14101__$1));
});

cljs.core.async.t_cljs$core$async14100.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14102){
var self__ = this;
var _14102__$1 = this;
return self__.meta14101;
});

cljs.core.async.t_cljs$core$async14100.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14100.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14100.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14100.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14100.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14101","meta14101",971750051,null)], null);
});

cljs.core.async.t_cljs$core$async14100.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14100.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14100";

cljs.core.async.t_cljs$core$async14100.cljs$lang$ctorPrWriter = (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async14100");
});

cljs.core.async.__GT_t_cljs$core$async14100 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14100(flag__$1,cb__$1,meta14101){
return (new cljs.core.async.t_cljs$core$async14100(flag__$1,cb__$1,meta14101));
});

}

return (new cljs.core.async.t_cljs$core$async14100(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14103_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14103_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14104_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14104_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__8201__auto__ = wport;
if(cljs.core.truth_(or__8201__auto__)){
return or__8201__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14105 = (i + (1));
i = G__14105;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8201__auto__ = ret;
if(cljs.core.truth_(or__8201__auto__)){
return or__8201__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__8189__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__8189__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__8189__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__9377__auto__ = [];
var len__9370__auto___14111 = arguments.length;
var i__9371__auto___14112 = (0);
while(true){
if((i__9371__auto___14112 < len__9370__auto___14111)){
args__9377__auto__.push((arguments[i__9371__auto___14112]));

var G__14113 = (i__9371__auto___14112 + (1));
i__9371__auto___14112 = G__14113;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((1) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9378__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14108){
var map__14109 = p__14108;
var map__14109__$1 = ((((!((map__14109 == null)))?((((map__14109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14109.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14109):map__14109);
var opts = map__14109__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14106){
var G__14107 = cljs.core.first.call(null,seq14106);
var seq14106__$1 = cljs.core.next.call(null,seq14106);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14107,seq14106__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__14115 = arguments.length;
switch (G__14115) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11864__auto___14161 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___14161){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___14161){
return (function (state_14139){
var state_val_14140 = (state_14139[(1)]);
if((state_val_14140 === (7))){
var inst_14135 = (state_14139[(2)]);
var state_14139__$1 = state_14139;
var statearr_14141_14162 = state_14139__$1;
(statearr_14141_14162[(2)] = inst_14135);

(statearr_14141_14162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (1))){
var state_14139__$1 = state_14139;
var statearr_14142_14163 = state_14139__$1;
(statearr_14142_14163[(2)] = null);

(statearr_14142_14163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (4))){
var inst_14118 = (state_14139[(7)]);
var inst_14118__$1 = (state_14139[(2)]);
var inst_14119 = (inst_14118__$1 == null);
var state_14139__$1 = (function (){var statearr_14143 = state_14139;
(statearr_14143[(7)] = inst_14118__$1);

return statearr_14143;
})();
if(cljs.core.truth_(inst_14119)){
var statearr_14144_14164 = state_14139__$1;
(statearr_14144_14164[(1)] = (5));

} else {
var statearr_14145_14165 = state_14139__$1;
(statearr_14145_14165[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (13))){
var state_14139__$1 = state_14139;
var statearr_14146_14166 = state_14139__$1;
(statearr_14146_14166[(2)] = null);

(statearr_14146_14166[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (6))){
var inst_14118 = (state_14139[(7)]);
var state_14139__$1 = state_14139;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14139__$1,(11),to,inst_14118);
} else {
if((state_val_14140 === (3))){
var inst_14137 = (state_14139[(2)]);
var state_14139__$1 = state_14139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14139__$1,inst_14137);
} else {
if((state_val_14140 === (12))){
var state_14139__$1 = state_14139;
var statearr_14147_14167 = state_14139__$1;
(statearr_14147_14167[(2)] = null);

(statearr_14147_14167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (2))){
var state_14139__$1 = state_14139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14139__$1,(4),from);
} else {
if((state_val_14140 === (11))){
var inst_14128 = (state_14139[(2)]);
var state_14139__$1 = state_14139;
if(cljs.core.truth_(inst_14128)){
var statearr_14148_14168 = state_14139__$1;
(statearr_14148_14168[(1)] = (12));

} else {
var statearr_14149_14169 = state_14139__$1;
(statearr_14149_14169[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (9))){
var state_14139__$1 = state_14139;
var statearr_14150_14170 = state_14139__$1;
(statearr_14150_14170[(2)] = null);

(statearr_14150_14170[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (5))){
var state_14139__$1 = state_14139;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14151_14171 = state_14139__$1;
(statearr_14151_14171[(1)] = (8));

} else {
var statearr_14152_14172 = state_14139__$1;
(statearr_14152_14172[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (14))){
var inst_14133 = (state_14139[(2)]);
var state_14139__$1 = state_14139;
var statearr_14153_14173 = state_14139__$1;
(statearr_14153_14173[(2)] = inst_14133);

(statearr_14153_14173[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (10))){
var inst_14125 = (state_14139[(2)]);
var state_14139__$1 = state_14139;
var statearr_14154_14174 = state_14139__$1;
(statearr_14154_14174[(2)] = inst_14125);

(statearr_14154_14174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14140 === (8))){
var inst_14122 = cljs.core.async.close_BANG_.call(null,to);
var state_14139__$1 = state_14139;
var statearr_14155_14175 = state_14139__$1;
(statearr_14155_14175[(2)] = inst_14122);

(statearr_14155_14175[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___14161))
;
return ((function (switch__11820__auto__,c__11864__auto___14161){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_14156 = [null,null,null,null,null,null,null,null];
(statearr_14156[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_14156[(1)] = (1));

return statearr_14156;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_14139){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14157){if((e14157 instanceof Object)){
var ex__11824__auto__ = e14157;
var statearr_14158_14176 = state_14139;
(statearr_14158_14176[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14139);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14157;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14177 = state_14139;
state_14139 = G__14177;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_14139){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_14139);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___14161))
})();
var state__11866__auto__ = (function (){var statearr_14159 = f__11865__auto__.call(null);
(statearr_14159[(6)] = c__11864__auto___14161);

return statearr_14159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___14161))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14178){
var vec__14179 = p__14178;
var v = cljs.core.nth.call(null,vec__14179,(0),null);
var p = cljs.core.nth.call(null,vec__14179,(1),null);
var job = vec__14179;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11864__auto___14350 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___14350,res,vec__14179,v,p,job,jobs,results){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___14350,res,vec__14179,v,p,job,jobs,results){
return (function (state_14186){
var state_val_14187 = (state_14186[(1)]);
if((state_val_14187 === (1))){
var state_14186__$1 = state_14186;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14186__$1,(2),res,v);
} else {
if((state_val_14187 === (2))){
var inst_14183 = (state_14186[(2)]);
var inst_14184 = cljs.core.async.close_BANG_.call(null,res);
var state_14186__$1 = (function (){var statearr_14188 = state_14186;
(statearr_14188[(7)] = inst_14183);

return statearr_14188;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14186__$1,inst_14184);
} else {
return null;
}
}
});})(c__11864__auto___14350,res,vec__14179,v,p,job,jobs,results))
;
return ((function (switch__11820__auto__,c__11864__auto___14350,res,vec__14179,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0 = (function (){
var statearr_14189 = [null,null,null,null,null,null,null,null];
(statearr_14189[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__);

(statearr_14189[(1)] = (1));

return statearr_14189;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1 = (function (state_14186){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14190){if((e14190 instanceof Object)){
var ex__11824__auto__ = e14190;
var statearr_14191_14351 = state_14186;
(statearr_14191_14351[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14186);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14190;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14352 = state_14186;
state_14186 = G__14352;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = function(state_14186){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1.call(this,state_14186);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___14350,res,vec__14179,v,p,job,jobs,results))
})();
var state__11866__auto__ = (function (){var statearr_14192 = f__11865__auto__.call(null);
(statearr_14192[(6)] = c__11864__auto___14350);

return statearr_14192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___14350,res,vec__14179,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14193){
var vec__14194 = p__14193;
var v = cljs.core.nth.call(null,vec__14194,(0),null);
var p = cljs.core.nth.call(null,vec__14194,(1),null);
var job = vec__14194;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__9146__auto___14353 = n;
var __14354 = (0);
while(true){
if((__14354 < n__9146__auto___14353)){
var G__14197_14355 = type;
var G__14197_14356__$1 = (((G__14197_14355 instanceof cljs.core.Keyword))?G__14197_14355.fqn:null);
switch (G__14197_14356__$1) {
case "compute":
var c__11864__auto___14358 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14354,c__11864__auto___14358,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (__14354,c__11864__auto___14358,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async){
return (function (state_14210){
var state_val_14211 = (state_14210[(1)]);
if((state_val_14211 === (1))){
var state_14210__$1 = state_14210;
var statearr_14212_14359 = state_14210__$1;
(statearr_14212_14359[(2)] = null);

(statearr_14212_14359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14211 === (2))){
var state_14210__$1 = state_14210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14210__$1,(4),jobs);
} else {
if((state_val_14211 === (3))){
var inst_14208 = (state_14210[(2)]);
var state_14210__$1 = state_14210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14210__$1,inst_14208);
} else {
if((state_val_14211 === (4))){
var inst_14200 = (state_14210[(2)]);
var inst_14201 = process.call(null,inst_14200);
var state_14210__$1 = state_14210;
if(cljs.core.truth_(inst_14201)){
var statearr_14213_14360 = state_14210__$1;
(statearr_14213_14360[(1)] = (5));

} else {
var statearr_14214_14361 = state_14210__$1;
(statearr_14214_14361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14211 === (5))){
var state_14210__$1 = state_14210;
var statearr_14215_14362 = state_14210__$1;
(statearr_14215_14362[(2)] = null);

(statearr_14215_14362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14211 === (6))){
var state_14210__$1 = state_14210;
var statearr_14216_14363 = state_14210__$1;
(statearr_14216_14363[(2)] = null);

(statearr_14216_14363[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14211 === (7))){
var inst_14206 = (state_14210[(2)]);
var state_14210__$1 = state_14210;
var statearr_14217_14364 = state_14210__$1;
(statearr_14217_14364[(2)] = inst_14206);

(statearr_14217_14364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14354,c__11864__auto___14358,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async))
;
return ((function (__14354,switch__11820__auto__,c__11864__auto___14358,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0 = (function (){
var statearr_14218 = [null,null,null,null,null,null,null];
(statearr_14218[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__);

(statearr_14218[(1)] = (1));

return statearr_14218;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1 = (function (state_14210){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14219){if((e14219 instanceof Object)){
var ex__11824__auto__ = e14219;
var statearr_14220_14365 = state_14210;
(statearr_14220_14365[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14219;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14366 = state_14210;
state_14210 = G__14366;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = function(state_14210){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1.call(this,state_14210);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__;
})()
;})(__14354,switch__11820__auto__,c__11864__auto___14358,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async))
})();
var state__11866__auto__ = (function (){var statearr_14221 = f__11865__auto__.call(null);
(statearr_14221[(6)] = c__11864__auto___14358);

return statearr_14221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(__14354,c__11864__auto___14358,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async))
);


break;
case "async":
var c__11864__auto___14367 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14354,c__11864__auto___14367,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (__14354,c__11864__auto___14367,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async){
return (function (state_14234){
var state_val_14235 = (state_14234[(1)]);
if((state_val_14235 === (1))){
var state_14234__$1 = state_14234;
var statearr_14236_14368 = state_14234__$1;
(statearr_14236_14368[(2)] = null);

(statearr_14236_14368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14235 === (2))){
var state_14234__$1 = state_14234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14234__$1,(4),jobs);
} else {
if((state_val_14235 === (3))){
var inst_14232 = (state_14234[(2)]);
var state_14234__$1 = state_14234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14234__$1,inst_14232);
} else {
if((state_val_14235 === (4))){
var inst_14224 = (state_14234[(2)]);
var inst_14225 = async.call(null,inst_14224);
var state_14234__$1 = state_14234;
if(cljs.core.truth_(inst_14225)){
var statearr_14237_14369 = state_14234__$1;
(statearr_14237_14369[(1)] = (5));

} else {
var statearr_14238_14370 = state_14234__$1;
(statearr_14238_14370[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14235 === (5))){
var state_14234__$1 = state_14234;
var statearr_14239_14371 = state_14234__$1;
(statearr_14239_14371[(2)] = null);

(statearr_14239_14371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14235 === (6))){
var state_14234__$1 = state_14234;
var statearr_14240_14372 = state_14234__$1;
(statearr_14240_14372[(2)] = null);

(statearr_14240_14372[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14235 === (7))){
var inst_14230 = (state_14234[(2)]);
var state_14234__$1 = state_14234;
var statearr_14241_14373 = state_14234__$1;
(statearr_14241_14373[(2)] = inst_14230);

(statearr_14241_14373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14354,c__11864__auto___14367,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async))
;
return ((function (__14354,switch__11820__auto__,c__11864__auto___14367,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0 = (function (){
var statearr_14242 = [null,null,null,null,null,null,null];
(statearr_14242[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__);

(statearr_14242[(1)] = (1));

return statearr_14242;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1 = (function (state_14234){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14243){if((e14243 instanceof Object)){
var ex__11824__auto__ = e14243;
var statearr_14244_14374 = state_14234;
(statearr_14244_14374[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14234);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14243;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14375 = state_14234;
state_14234 = G__14375;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = function(state_14234){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1.call(this,state_14234);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__;
})()
;})(__14354,switch__11820__auto__,c__11864__auto___14367,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async))
})();
var state__11866__auto__ = (function (){var statearr_14245 = f__11865__auto__.call(null);
(statearr_14245[(6)] = c__11864__auto___14367);

return statearr_14245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(__14354,c__11864__auto___14367,G__14197_14355,G__14197_14356__$1,n__9146__auto___14353,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14197_14356__$1)].join('')));

}

var G__14376 = (__14354 + (1));
__14354 = G__14376;
continue;
} else {
}
break;
}

var c__11864__auto___14377 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___14377,jobs,results,process,async){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___14377,jobs,results,process,async){
return (function (state_14267){
var state_val_14268 = (state_14267[(1)]);
if((state_val_14268 === (1))){
var state_14267__$1 = state_14267;
var statearr_14269_14378 = state_14267__$1;
(statearr_14269_14378[(2)] = null);

(statearr_14269_14378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (2))){
var state_14267__$1 = state_14267;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14267__$1,(4),from);
} else {
if((state_val_14268 === (3))){
var inst_14265 = (state_14267[(2)]);
var state_14267__$1 = state_14267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14267__$1,inst_14265);
} else {
if((state_val_14268 === (4))){
var inst_14248 = (state_14267[(7)]);
var inst_14248__$1 = (state_14267[(2)]);
var inst_14249 = (inst_14248__$1 == null);
var state_14267__$1 = (function (){var statearr_14270 = state_14267;
(statearr_14270[(7)] = inst_14248__$1);

return statearr_14270;
})();
if(cljs.core.truth_(inst_14249)){
var statearr_14271_14379 = state_14267__$1;
(statearr_14271_14379[(1)] = (5));

} else {
var statearr_14272_14380 = state_14267__$1;
(statearr_14272_14380[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (5))){
var inst_14251 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14267__$1 = state_14267;
var statearr_14273_14381 = state_14267__$1;
(statearr_14273_14381[(2)] = inst_14251);

(statearr_14273_14381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (6))){
var inst_14248 = (state_14267[(7)]);
var inst_14253 = (state_14267[(8)]);
var inst_14253__$1 = cljs.core.async.chan.call(null,(1));
var inst_14254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14255 = [inst_14248,inst_14253__$1];
var inst_14256 = (new cljs.core.PersistentVector(null,2,(5),inst_14254,inst_14255,null));
var state_14267__$1 = (function (){var statearr_14274 = state_14267;
(statearr_14274[(8)] = inst_14253__$1);

return statearr_14274;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14267__$1,(8),jobs,inst_14256);
} else {
if((state_val_14268 === (7))){
var inst_14263 = (state_14267[(2)]);
var state_14267__$1 = state_14267;
var statearr_14275_14382 = state_14267__$1;
(statearr_14275_14382[(2)] = inst_14263);

(statearr_14275_14382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (8))){
var inst_14253 = (state_14267[(8)]);
var inst_14258 = (state_14267[(2)]);
var state_14267__$1 = (function (){var statearr_14276 = state_14267;
(statearr_14276[(9)] = inst_14258);

return statearr_14276;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14267__$1,(9),results,inst_14253);
} else {
if((state_val_14268 === (9))){
var inst_14260 = (state_14267[(2)]);
var state_14267__$1 = (function (){var statearr_14277 = state_14267;
(statearr_14277[(10)] = inst_14260);

return statearr_14277;
})();
var statearr_14278_14383 = state_14267__$1;
(statearr_14278_14383[(2)] = null);

(statearr_14278_14383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___14377,jobs,results,process,async))
;
return ((function (switch__11820__auto__,c__11864__auto___14377,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0 = (function (){
var statearr_14279 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14279[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__);

(statearr_14279[(1)] = (1));

return statearr_14279;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1 = (function (state_14267){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14280){if((e14280 instanceof Object)){
var ex__11824__auto__ = e14280;
var statearr_14281_14384 = state_14267;
(statearr_14281_14384[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14267);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14280;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14385 = state_14267;
state_14267 = G__14385;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = function(state_14267){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1.call(this,state_14267);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___14377,jobs,results,process,async))
})();
var state__11866__auto__ = (function (){var statearr_14282 = f__11865__auto__.call(null);
(statearr_14282[(6)] = c__11864__auto___14377);

return statearr_14282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___14377,jobs,results,process,async))
);


var c__11864__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto__,jobs,results,process,async){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto__,jobs,results,process,async){
return (function (state_14320){
var state_val_14321 = (state_14320[(1)]);
if((state_val_14321 === (7))){
var inst_14316 = (state_14320[(2)]);
var state_14320__$1 = state_14320;
var statearr_14322_14386 = state_14320__$1;
(statearr_14322_14386[(2)] = inst_14316);

(statearr_14322_14386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (20))){
var state_14320__$1 = state_14320;
var statearr_14323_14387 = state_14320__$1;
(statearr_14323_14387[(2)] = null);

(statearr_14323_14387[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (1))){
var state_14320__$1 = state_14320;
var statearr_14324_14388 = state_14320__$1;
(statearr_14324_14388[(2)] = null);

(statearr_14324_14388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (4))){
var inst_14285 = (state_14320[(7)]);
var inst_14285__$1 = (state_14320[(2)]);
var inst_14286 = (inst_14285__$1 == null);
var state_14320__$1 = (function (){var statearr_14325 = state_14320;
(statearr_14325[(7)] = inst_14285__$1);

return statearr_14325;
})();
if(cljs.core.truth_(inst_14286)){
var statearr_14326_14389 = state_14320__$1;
(statearr_14326_14389[(1)] = (5));

} else {
var statearr_14327_14390 = state_14320__$1;
(statearr_14327_14390[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (15))){
var inst_14298 = (state_14320[(8)]);
var state_14320__$1 = state_14320;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14320__$1,(18),to,inst_14298);
} else {
if((state_val_14321 === (21))){
var inst_14311 = (state_14320[(2)]);
var state_14320__$1 = state_14320;
var statearr_14328_14391 = state_14320__$1;
(statearr_14328_14391[(2)] = inst_14311);

(statearr_14328_14391[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (13))){
var inst_14313 = (state_14320[(2)]);
var state_14320__$1 = (function (){var statearr_14329 = state_14320;
(statearr_14329[(9)] = inst_14313);

return statearr_14329;
})();
var statearr_14330_14392 = state_14320__$1;
(statearr_14330_14392[(2)] = null);

(statearr_14330_14392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (6))){
var inst_14285 = (state_14320[(7)]);
var state_14320__$1 = state_14320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14320__$1,(11),inst_14285);
} else {
if((state_val_14321 === (17))){
var inst_14306 = (state_14320[(2)]);
var state_14320__$1 = state_14320;
if(cljs.core.truth_(inst_14306)){
var statearr_14331_14393 = state_14320__$1;
(statearr_14331_14393[(1)] = (19));

} else {
var statearr_14332_14394 = state_14320__$1;
(statearr_14332_14394[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (3))){
var inst_14318 = (state_14320[(2)]);
var state_14320__$1 = state_14320;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14320__$1,inst_14318);
} else {
if((state_val_14321 === (12))){
var inst_14295 = (state_14320[(10)]);
var state_14320__$1 = state_14320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14320__$1,(14),inst_14295);
} else {
if((state_val_14321 === (2))){
var state_14320__$1 = state_14320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14320__$1,(4),results);
} else {
if((state_val_14321 === (19))){
var state_14320__$1 = state_14320;
var statearr_14333_14395 = state_14320__$1;
(statearr_14333_14395[(2)] = null);

(statearr_14333_14395[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (11))){
var inst_14295 = (state_14320[(2)]);
var state_14320__$1 = (function (){var statearr_14334 = state_14320;
(statearr_14334[(10)] = inst_14295);

return statearr_14334;
})();
var statearr_14335_14396 = state_14320__$1;
(statearr_14335_14396[(2)] = null);

(statearr_14335_14396[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (9))){
var state_14320__$1 = state_14320;
var statearr_14336_14397 = state_14320__$1;
(statearr_14336_14397[(2)] = null);

(statearr_14336_14397[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (5))){
var state_14320__$1 = state_14320;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14337_14398 = state_14320__$1;
(statearr_14337_14398[(1)] = (8));

} else {
var statearr_14338_14399 = state_14320__$1;
(statearr_14338_14399[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (14))){
var inst_14298 = (state_14320[(8)]);
var inst_14300 = (state_14320[(11)]);
var inst_14298__$1 = (state_14320[(2)]);
var inst_14299 = (inst_14298__$1 == null);
var inst_14300__$1 = cljs.core.not.call(null,inst_14299);
var state_14320__$1 = (function (){var statearr_14339 = state_14320;
(statearr_14339[(8)] = inst_14298__$1);

(statearr_14339[(11)] = inst_14300__$1);

return statearr_14339;
})();
if(inst_14300__$1){
var statearr_14340_14400 = state_14320__$1;
(statearr_14340_14400[(1)] = (15));

} else {
var statearr_14341_14401 = state_14320__$1;
(statearr_14341_14401[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (16))){
var inst_14300 = (state_14320[(11)]);
var state_14320__$1 = state_14320;
var statearr_14342_14402 = state_14320__$1;
(statearr_14342_14402[(2)] = inst_14300);

(statearr_14342_14402[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (10))){
var inst_14292 = (state_14320[(2)]);
var state_14320__$1 = state_14320;
var statearr_14343_14403 = state_14320__$1;
(statearr_14343_14403[(2)] = inst_14292);

(statearr_14343_14403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (18))){
var inst_14303 = (state_14320[(2)]);
var state_14320__$1 = state_14320;
var statearr_14344_14404 = state_14320__$1;
(statearr_14344_14404[(2)] = inst_14303);

(statearr_14344_14404[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14321 === (8))){
var inst_14289 = cljs.core.async.close_BANG_.call(null,to);
var state_14320__$1 = state_14320;
var statearr_14345_14405 = state_14320__$1;
(statearr_14345_14405[(2)] = inst_14289);

(statearr_14345_14405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto__,jobs,results,process,async))
;
return ((function (switch__11820__auto__,c__11864__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0 = (function (){
var statearr_14346 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14346[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__);

(statearr_14346[(1)] = (1));

return statearr_14346;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1 = (function (state_14320){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14320);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14347){if((e14347 instanceof Object)){
var ex__11824__auto__ = e14347;
var statearr_14348_14406 = state_14320;
(statearr_14348_14406[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14320);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14347;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14407 = state_14320;
state_14320 = G__14407;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__ = function(state_14320){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1.call(this,state_14320);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto__,jobs,results,process,async))
})();
var state__11866__auto__ = (function (){var statearr_14349 = f__11865__auto__.call(null);
(statearr_14349[(6)] = c__11864__auto__);

return statearr_14349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto__,jobs,results,process,async))
);

return c__11864__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__14409 = arguments.length;
switch (G__14409) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__14412 = arguments.length;
switch (G__14412) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__14415 = arguments.length;
switch (G__14415) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11864__auto___14464 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___14464,tc,fc){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___14464,tc,fc){
return (function (state_14441){
var state_val_14442 = (state_14441[(1)]);
if((state_val_14442 === (7))){
var inst_14437 = (state_14441[(2)]);
var state_14441__$1 = state_14441;
var statearr_14443_14465 = state_14441__$1;
(statearr_14443_14465[(2)] = inst_14437);

(statearr_14443_14465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (1))){
var state_14441__$1 = state_14441;
var statearr_14444_14466 = state_14441__$1;
(statearr_14444_14466[(2)] = null);

(statearr_14444_14466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (4))){
var inst_14418 = (state_14441[(7)]);
var inst_14418__$1 = (state_14441[(2)]);
var inst_14419 = (inst_14418__$1 == null);
var state_14441__$1 = (function (){var statearr_14445 = state_14441;
(statearr_14445[(7)] = inst_14418__$1);

return statearr_14445;
})();
if(cljs.core.truth_(inst_14419)){
var statearr_14446_14467 = state_14441__$1;
(statearr_14446_14467[(1)] = (5));

} else {
var statearr_14447_14468 = state_14441__$1;
(statearr_14447_14468[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (13))){
var state_14441__$1 = state_14441;
var statearr_14448_14469 = state_14441__$1;
(statearr_14448_14469[(2)] = null);

(statearr_14448_14469[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (6))){
var inst_14418 = (state_14441[(7)]);
var inst_14424 = p.call(null,inst_14418);
var state_14441__$1 = state_14441;
if(cljs.core.truth_(inst_14424)){
var statearr_14449_14470 = state_14441__$1;
(statearr_14449_14470[(1)] = (9));

} else {
var statearr_14450_14471 = state_14441__$1;
(statearr_14450_14471[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (3))){
var inst_14439 = (state_14441[(2)]);
var state_14441__$1 = state_14441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14441__$1,inst_14439);
} else {
if((state_val_14442 === (12))){
var state_14441__$1 = state_14441;
var statearr_14451_14472 = state_14441__$1;
(statearr_14451_14472[(2)] = null);

(statearr_14451_14472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (2))){
var state_14441__$1 = state_14441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14441__$1,(4),ch);
} else {
if((state_val_14442 === (11))){
var inst_14418 = (state_14441[(7)]);
var inst_14428 = (state_14441[(2)]);
var state_14441__$1 = state_14441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14441__$1,(8),inst_14428,inst_14418);
} else {
if((state_val_14442 === (9))){
var state_14441__$1 = state_14441;
var statearr_14452_14473 = state_14441__$1;
(statearr_14452_14473[(2)] = tc);

(statearr_14452_14473[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (5))){
var inst_14421 = cljs.core.async.close_BANG_.call(null,tc);
var inst_14422 = cljs.core.async.close_BANG_.call(null,fc);
var state_14441__$1 = (function (){var statearr_14453 = state_14441;
(statearr_14453[(8)] = inst_14421);

return statearr_14453;
})();
var statearr_14454_14474 = state_14441__$1;
(statearr_14454_14474[(2)] = inst_14422);

(statearr_14454_14474[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (14))){
var inst_14435 = (state_14441[(2)]);
var state_14441__$1 = state_14441;
var statearr_14455_14475 = state_14441__$1;
(statearr_14455_14475[(2)] = inst_14435);

(statearr_14455_14475[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (10))){
var state_14441__$1 = state_14441;
var statearr_14456_14476 = state_14441__$1;
(statearr_14456_14476[(2)] = fc);

(statearr_14456_14476[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14442 === (8))){
var inst_14430 = (state_14441[(2)]);
var state_14441__$1 = state_14441;
if(cljs.core.truth_(inst_14430)){
var statearr_14457_14477 = state_14441__$1;
(statearr_14457_14477[(1)] = (12));

} else {
var statearr_14458_14478 = state_14441__$1;
(statearr_14458_14478[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___14464,tc,fc))
;
return ((function (switch__11820__auto__,c__11864__auto___14464,tc,fc){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_14459 = [null,null,null,null,null,null,null,null,null];
(statearr_14459[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_14459[(1)] = (1));

return statearr_14459;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_14441){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14460){if((e14460 instanceof Object)){
var ex__11824__auto__ = e14460;
var statearr_14461_14479 = state_14441;
(statearr_14461_14479[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14460;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14480 = state_14441;
state_14441 = G__14480;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_14441){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_14441);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___14464,tc,fc))
})();
var state__11866__auto__ = (function (){var statearr_14462 = f__11865__auto__.call(null);
(statearr_14462[(6)] = c__11864__auto___14464);

return statearr_14462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___14464,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11864__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto__){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto__){
return (function (state_14501){
var state_val_14502 = (state_14501[(1)]);
if((state_val_14502 === (7))){
var inst_14497 = (state_14501[(2)]);
var state_14501__$1 = state_14501;
var statearr_14503_14521 = state_14501__$1;
(statearr_14503_14521[(2)] = inst_14497);

(statearr_14503_14521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14502 === (1))){
var inst_14481 = init;
var state_14501__$1 = (function (){var statearr_14504 = state_14501;
(statearr_14504[(7)] = inst_14481);

return statearr_14504;
})();
var statearr_14505_14522 = state_14501__$1;
(statearr_14505_14522[(2)] = null);

(statearr_14505_14522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14502 === (4))){
var inst_14484 = (state_14501[(8)]);
var inst_14484__$1 = (state_14501[(2)]);
var inst_14485 = (inst_14484__$1 == null);
var state_14501__$1 = (function (){var statearr_14506 = state_14501;
(statearr_14506[(8)] = inst_14484__$1);

return statearr_14506;
})();
if(cljs.core.truth_(inst_14485)){
var statearr_14507_14523 = state_14501__$1;
(statearr_14507_14523[(1)] = (5));

} else {
var statearr_14508_14524 = state_14501__$1;
(statearr_14508_14524[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14502 === (6))){
var inst_14484 = (state_14501[(8)]);
var inst_14481 = (state_14501[(7)]);
var inst_14488 = (state_14501[(9)]);
var inst_14488__$1 = f.call(null,inst_14481,inst_14484);
var inst_14489 = cljs.core.reduced_QMARK_.call(null,inst_14488__$1);
var state_14501__$1 = (function (){var statearr_14509 = state_14501;
(statearr_14509[(9)] = inst_14488__$1);

return statearr_14509;
})();
if(inst_14489){
var statearr_14510_14525 = state_14501__$1;
(statearr_14510_14525[(1)] = (8));

} else {
var statearr_14511_14526 = state_14501__$1;
(statearr_14511_14526[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14502 === (3))){
var inst_14499 = (state_14501[(2)]);
var state_14501__$1 = state_14501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14501__$1,inst_14499);
} else {
if((state_val_14502 === (2))){
var state_14501__$1 = state_14501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14501__$1,(4),ch);
} else {
if((state_val_14502 === (9))){
var inst_14488 = (state_14501[(9)]);
var inst_14481 = inst_14488;
var state_14501__$1 = (function (){var statearr_14512 = state_14501;
(statearr_14512[(7)] = inst_14481);

return statearr_14512;
})();
var statearr_14513_14527 = state_14501__$1;
(statearr_14513_14527[(2)] = null);

(statearr_14513_14527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14502 === (5))){
var inst_14481 = (state_14501[(7)]);
var state_14501__$1 = state_14501;
var statearr_14514_14528 = state_14501__$1;
(statearr_14514_14528[(2)] = inst_14481);

(statearr_14514_14528[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14502 === (10))){
var inst_14495 = (state_14501[(2)]);
var state_14501__$1 = state_14501;
var statearr_14515_14529 = state_14501__$1;
(statearr_14515_14529[(2)] = inst_14495);

(statearr_14515_14529[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14502 === (8))){
var inst_14488 = (state_14501[(9)]);
var inst_14491 = cljs.core.deref.call(null,inst_14488);
var state_14501__$1 = state_14501;
var statearr_14516_14530 = state_14501__$1;
(statearr_14516_14530[(2)] = inst_14491);

(statearr_14516_14530[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto__))
;
return ((function (switch__11820__auto__,c__11864__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11821__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11821__auto____0 = (function (){
var statearr_14517 = [null,null,null,null,null,null,null,null,null,null];
(statearr_14517[(0)] = cljs$core$async$reduce_$_state_machine__11821__auto__);

(statearr_14517[(1)] = (1));

return statearr_14517;
});
var cljs$core$async$reduce_$_state_machine__11821__auto____1 = (function (state_14501){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14518){if((e14518 instanceof Object)){
var ex__11824__auto__ = e14518;
var statearr_14519_14531 = state_14501;
(statearr_14519_14531[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14501);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14518;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14532 = state_14501;
state_14501 = G__14532;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11821__auto__ = function(state_14501){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11821__auto____1.call(this,state_14501);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11821__auto____0;
cljs$core$async$reduce_$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11821__auto____1;
return cljs$core$async$reduce_$_state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto__))
})();
var state__11866__auto__ = (function (){var statearr_14520 = f__11865__auto__.call(null);
(statearr_14520[(6)] = c__11864__auto__);

return statearr_14520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto__))
);

return c__11864__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__11864__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto__,f__$1){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto__,f__$1){
return (function (state_14538){
var state_val_14539 = (state_14538[(1)]);
if((state_val_14539 === (1))){
var inst_14533 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_14538__$1 = state_14538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14538__$1,(2),inst_14533);
} else {
if((state_val_14539 === (2))){
var inst_14535 = (state_14538[(2)]);
var inst_14536 = f__$1.call(null,inst_14535);
var state_14538__$1 = state_14538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14538__$1,inst_14536);
} else {
return null;
}
}
});})(c__11864__auto__,f__$1))
;
return ((function (switch__11820__auto__,c__11864__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__11821__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11821__auto____0 = (function (){
var statearr_14540 = [null,null,null,null,null,null,null];
(statearr_14540[(0)] = cljs$core$async$transduce_$_state_machine__11821__auto__);

(statearr_14540[(1)] = (1));

return statearr_14540;
});
var cljs$core$async$transduce_$_state_machine__11821__auto____1 = (function (state_14538){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14541){if((e14541 instanceof Object)){
var ex__11824__auto__ = e14541;
var statearr_14542_14544 = state_14538;
(statearr_14542_14544[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14538);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14541;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14545 = state_14538;
state_14538 = G__14545;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11821__auto__ = function(state_14538){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11821__auto____1.call(this,state_14538);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11821__auto____0;
cljs$core$async$transduce_$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11821__auto____1;
return cljs$core$async$transduce_$_state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto__,f__$1))
})();
var state__11866__auto__ = (function (){var statearr_14543 = f__11865__auto__.call(null);
(statearr_14543[(6)] = c__11864__auto__);

return statearr_14543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto__,f__$1))
);

return c__11864__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__14547 = arguments.length;
switch (G__14547) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11864__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto__){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto__){
return (function (state_14572){
var state_val_14573 = (state_14572[(1)]);
if((state_val_14573 === (7))){
var inst_14554 = (state_14572[(2)]);
var state_14572__$1 = state_14572;
var statearr_14574_14595 = state_14572__$1;
(statearr_14574_14595[(2)] = inst_14554);

(statearr_14574_14595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (1))){
var inst_14548 = cljs.core.seq.call(null,coll);
var inst_14549 = inst_14548;
var state_14572__$1 = (function (){var statearr_14575 = state_14572;
(statearr_14575[(7)] = inst_14549);

return statearr_14575;
})();
var statearr_14576_14596 = state_14572__$1;
(statearr_14576_14596[(2)] = null);

(statearr_14576_14596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (4))){
var inst_14549 = (state_14572[(7)]);
var inst_14552 = cljs.core.first.call(null,inst_14549);
var state_14572__$1 = state_14572;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14572__$1,(7),ch,inst_14552);
} else {
if((state_val_14573 === (13))){
var inst_14566 = (state_14572[(2)]);
var state_14572__$1 = state_14572;
var statearr_14577_14597 = state_14572__$1;
(statearr_14577_14597[(2)] = inst_14566);

(statearr_14577_14597[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (6))){
var inst_14557 = (state_14572[(2)]);
var state_14572__$1 = state_14572;
if(cljs.core.truth_(inst_14557)){
var statearr_14578_14598 = state_14572__$1;
(statearr_14578_14598[(1)] = (8));

} else {
var statearr_14579_14599 = state_14572__$1;
(statearr_14579_14599[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (3))){
var inst_14570 = (state_14572[(2)]);
var state_14572__$1 = state_14572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14572__$1,inst_14570);
} else {
if((state_val_14573 === (12))){
var state_14572__$1 = state_14572;
var statearr_14580_14600 = state_14572__$1;
(statearr_14580_14600[(2)] = null);

(statearr_14580_14600[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (2))){
var inst_14549 = (state_14572[(7)]);
var state_14572__$1 = state_14572;
if(cljs.core.truth_(inst_14549)){
var statearr_14581_14601 = state_14572__$1;
(statearr_14581_14601[(1)] = (4));

} else {
var statearr_14582_14602 = state_14572__$1;
(statearr_14582_14602[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (11))){
var inst_14563 = cljs.core.async.close_BANG_.call(null,ch);
var state_14572__$1 = state_14572;
var statearr_14583_14603 = state_14572__$1;
(statearr_14583_14603[(2)] = inst_14563);

(statearr_14583_14603[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (9))){
var state_14572__$1 = state_14572;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14584_14604 = state_14572__$1;
(statearr_14584_14604[(1)] = (11));

} else {
var statearr_14585_14605 = state_14572__$1;
(statearr_14585_14605[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (5))){
var inst_14549 = (state_14572[(7)]);
var state_14572__$1 = state_14572;
var statearr_14586_14606 = state_14572__$1;
(statearr_14586_14606[(2)] = inst_14549);

(statearr_14586_14606[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (10))){
var inst_14568 = (state_14572[(2)]);
var state_14572__$1 = state_14572;
var statearr_14587_14607 = state_14572__$1;
(statearr_14587_14607[(2)] = inst_14568);

(statearr_14587_14607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14573 === (8))){
var inst_14549 = (state_14572[(7)]);
var inst_14559 = cljs.core.next.call(null,inst_14549);
var inst_14549__$1 = inst_14559;
var state_14572__$1 = (function (){var statearr_14588 = state_14572;
(statearr_14588[(7)] = inst_14549__$1);

return statearr_14588;
})();
var statearr_14589_14608 = state_14572__$1;
(statearr_14589_14608[(2)] = null);

(statearr_14589_14608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto__))
;
return ((function (switch__11820__auto__,c__11864__auto__){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_14590 = [null,null,null,null,null,null,null,null];
(statearr_14590[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_14590[(1)] = (1));

return statearr_14590;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_14572){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14591){if((e14591 instanceof Object)){
var ex__11824__auto__ = e14591;
var statearr_14592_14609 = state_14572;
(statearr_14592_14609[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14572);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14591;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14610 = state_14572;
state_14572 = G__14610;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_14572){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_14572);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto__))
})();
var state__11866__auto__ = (function (){var statearr_14593 = f__11865__auto__.call(null);
(statearr_14593[(6)] = c__11864__auto__);

return statearr_14593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto__))
);

return c__11864__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8884__auto__ = (((_ == null))?null:_);
var m__8885__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,_);
} else {
var m__8885__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8884__auto__ = (((m == null))?null:m);
var m__8885__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__8885__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8884__auto__ = (((m == null))?null:m);
var m__8885__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,m,ch);
} else {
var m__8885__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8884__auto__ = (((m == null))?null:m);
var m__8885__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,m);
} else {
var m__8885__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async14611 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14611 = (function (ch,cs,meta14612){
this.ch = ch;
this.cs = cs;
this.meta14612 = meta14612;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async14611.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_14613,meta14612__$1){
var self__ = this;
var _14613__$1 = this;
return (new cljs.core.async.t_cljs$core$async14611(self__.ch,self__.cs,meta14612__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async14611.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_14613){
var self__ = this;
var _14613__$1 = this;
return self__.meta14612;
});})(cs))
;

cljs.core.async.t_cljs$core$async14611.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14611.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async14611.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14611.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14611.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14611.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14611.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta14612","meta14612",-239603310,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async14611.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14611.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14611";

cljs.core.async.t_cljs$core$async14611.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async14611");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async14611 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async14611(ch__$1,cs__$1,meta14612){
return (new cljs.core.async.t_cljs$core$async14611(ch__$1,cs__$1,meta14612));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async14611(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11864__auto___14833 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___14833,cs,m,dchan,dctr,done){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___14833,cs,m,dchan,dctr,done){
return (function (state_14748){
var state_val_14749 = (state_14748[(1)]);
if((state_val_14749 === (7))){
var inst_14744 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14750_14834 = state_14748__$1;
(statearr_14750_14834[(2)] = inst_14744);

(statearr_14750_14834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (20))){
var inst_14647 = (state_14748[(7)]);
var inst_14659 = cljs.core.first.call(null,inst_14647);
var inst_14660 = cljs.core.nth.call(null,inst_14659,(0),null);
var inst_14661 = cljs.core.nth.call(null,inst_14659,(1),null);
var state_14748__$1 = (function (){var statearr_14751 = state_14748;
(statearr_14751[(8)] = inst_14660);

return statearr_14751;
})();
if(cljs.core.truth_(inst_14661)){
var statearr_14752_14835 = state_14748__$1;
(statearr_14752_14835[(1)] = (22));

} else {
var statearr_14753_14836 = state_14748__$1;
(statearr_14753_14836[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (27))){
var inst_14696 = (state_14748[(9)]);
var inst_14689 = (state_14748[(10)]);
var inst_14691 = (state_14748[(11)]);
var inst_14616 = (state_14748[(12)]);
var inst_14696__$1 = cljs.core._nth.call(null,inst_14689,inst_14691);
var inst_14697 = cljs.core.async.put_BANG_.call(null,inst_14696__$1,inst_14616,done);
var state_14748__$1 = (function (){var statearr_14754 = state_14748;
(statearr_14754[(9)] = inst_14696__$1);

return statearr_14754;
})();
if(cljs.core.truth_(inst_14697)){
var statearr_14755_14837 = state_14748__$1;
(statearr_14755_14837[(1)] = (30));

} else {
var statearr_14756_14838 = state_14748__$1;
(statearr_14756_14838[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (1))){
var state_14748__$1 = state_14748;
var statearr_14757_14839 = state_14748__$1;
(statearr_14757_14839[(2)] = null);

(statearr_14757_14839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (24))){
var inst_14647 = (state_14748[(7)]);
var inst_14666 = (state_14748[(2)]);
var inst_14667 = cljs.core.next.call(null,inst_14647);
var inst_14625 = inst_14667;
var inst_14626 = null;
var inst_14627 = (0);
var inst_14628 = (0);
var state_14748__$1 = (function (){var statearr_14758 = state_14748;
(statearr_14758[(13)] = inst_14627);

(statearr_14758[(14)] = inst_14626);

(statearr_14758[(15)] = inst_14628);

(statearr_14758[(16)] = inst_14666);

(statearr_14758[(17)] = inst_14625);

return statearr_14758;
})();
var statearr_14759_14840 = state_14748__$1;
(statearr_14759_14840[(2)] = null);

(statearr_14759_14840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (39))){
var state_14748__$1 = state_14748;
var statearr_14763_14841 = state_14748__$1;
(statearr_14763_14841[(2)] = null);

(statearr_14763_14841[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (4))){
var inst_14616 = (state_14748[(12)]);
var inst_14616__$1 = (state_14748[(2)]);
var inst_14617 = (inst_14616__$1 == null);
var state_14748__$1 = (function (){var statearr_14764 = state_14748;
(statearr_14764[(12)] = inst_14616__$1);

return statearr_14764;
})();
if(cljs.core.truth_(inst_14617)){
var statearr_14765_14842 = state_14748__$1;
(statearr_14765_14842[(1)] = (5));

} else {
var statearr_14766_14843 = state_14748__$1;
(statearr_14766_14843[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (15))){
var inst_14627 = (state_14748[(13)]);
var inst_14626 = (state_14748[(14)]);
var inst_14628 = (state_14748[(15)]);
var inst_14625 = (state_14748[(17)]);
var inst_14643 = (state_14748[(2)]);
var inst_14644 = (inst_14628 + (1));
var tmp14760 = inst_14627;
var tmp14761 = inst_14626;
var tmp14762 = inst_14625;
var inst_14625__$1 = tmp14762;
var inst_14626__$1 = tmp14761;
var inst_14627__$1 = tmp14760;
var inst_14628__$1 = inst_14644;
var state_14748__$1 = (function (){var statearr_14767 = state_14748;
(statearr_14767[(13)] = inst_14627__$1);

(statearr_14767[(18)] = inst_14643);

(statearr_14767[(14)] = inst_14626__$1);

(statearr_14767[(15)] = inst_14628__$1);

(statearr_14767[(17)] = inst_14625__$1);

return statearr_14767;
})();
var statearr_14768_14844 = state_14748__$1;
(statearr_14768_14844[(2)] = null);

(statearr_14768_14844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (21))){
var inst_14670 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14772_14845 = state_14748__$1;
(statearr_14772_14845[(2)] = inst_14670);

(statearr_14772_14845[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (31))){
var inst_14696 = (state_14748[(9)]);
var inst_14700 = done.call(null,null);
var inst_14701 = cljs.core.async.untap_STAR_.call(null,m,inst_14696);
var state_14748__$1 = (function (){var statearr_14773 = state_14748;
(statearr_14773[(19)] = inst_14700);

return statearr_14773;
})();
var statearr_14774_14846 = state_14748__$1;
(statearr_14774_14846[(2)] = inst_14701);

(statearr_14774_14846[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (32))){
var inst_14688 = (state_14748[(20)]);
var inst_14689 = (state_14748[(10)]);
var inst_14690 = (state_14748[(21)]);
var inst_14691 = (state_14748[(11)]);
var inst_14703 = (state_14748[(2)]);
var inst_14704 = (inst_14691 + (1));
var tmp14769 = inst_14688;
var tmp14770 = inst_14689;
var tmp14771 = inst_14690;
var inst_14688__$1 = tmp14769;
var inst_14689__$1 = tmp14770;
var inst_14690__$1 = tmp14771;
var inst_14691__$1 = inst_14704;
var state_14748__$1 = (function (){var statearr_14775 = state_14748;
(statearr_14775[(20)] = inst_14688__$1);

(statearr_14775[(22)] = inst_14703);

(statearr_14775[(10)] = inst_14689__$1);

(statearr_14775[(21)] = inst_14690__$1);

(statearr_14775[(11)] = inst_14691__$1);

return statearr_14775;
})();
var statearr_14776_14847 = state_14748__$1;
(statearr_14776_14847[(2)] = null);

(statearr_14776_14847[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (40))){
var inst_14716 = (state_14748[(23)]);
var inst_14720 = done.call(null,null);
var inst_14721 = cljs.core.async.untap_STAR_.call(null,m,inst_14716);
var state_14748__$1 = (function (){var statearr_14777 = state_14748;
(statearr_14777[(24)] = inst_14720);

return statearr_14777;
})();
var statearr_14778_14848 = state_14748__$1;
(statearr_14778_14848[(2)] = inst_14721);

(statearr_14778_14848[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (33))){
var inst_14707 = (state_14748[(25)]);
var inst_14709 = cljs.core.chunked_seq_QMARK_.call(null,inst_14707);
var state_14748__$1 = state_14748;
if(inst_14709){
var statearr_14779_14849 = state_14748__$1;
(statearr_14779_14849[(1)] = (36));

} else {
var statearr_14780_14850 = state_14748__$1;
(statearr_14780_14850[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (13))){
var inst_14637 = (state_14748[(26)]);
var inst_14640 = cljs.core.async.close_BANG_.call(null,inst_14637);
var state_14748__$1 = state_14748;
var statearr_14781_14851 = state_14748__$1;
(statearr_14781_14851[(2)] = inst_14640);

(statearr_14781_14851[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (22))){
var inst_14660 = (state_14748[(8)]);
var inst_14663 = cljs.core.async.close_BANG_.call(null,inst_14660);
var state_14748__$1 = state_14748;
var statearr_14782_14852 = state_14748__$1;
(statearr_14782_14852[(2)] = inst_14663);

(statearr_14782_14852[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (36))){
var inst_14707 = (state_14748[(25)]);
var inst_14711 = cljs.core.chunk_first.call(null,inst_14707);
var inst_14712 = cljs.core.chunk_rest.call(null,inst_14707);
var inst_14713 = cljs.core.count.call(null,inst_14711);
var inst_14688 = inst_14712;
var inst_14689 = inst_14711;
var inst_14690 = inst_14713;
var inst_14691 = (0);
var state_14748__$1 = (function (){var statearr_14783 = state_14748;
(statearr_14783[(20)] = inst_14688);

(statearr_14783[(10)] = inst_14689);

(statearr_14783[(21)] = inst_14690);

(statearr_14783[(11)] = inst_14691);

return statearr_14783;
})();
var statearr_14784_14853 = state_14748__$1;
(statearr_14784_14853[(2)] = null);

(statearr_14784_14853[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (41))){
var inst_14707 = (state_14748[(25)]);
var inst_14723 = (state_14748[(2)]);
var inst_14724 = cljs.core.next.call(null,inst_14707);
var inst_14688 = inst_14724;
var inst_14689 = null;
var inst_14690 = (0);
var inst_14691 = (0);
var state_14748__$1 = (function (){var statearr_14785 = state_14748;
(statearr_14785[(20)] = inst_14688);

(statearr_14785[(27)] = inst_14723);

(statearr_14785[(10)] = inst_14689);

(statearr_14785[(21)] = inst_14690);

(statearr_14785[(11)] = inst_14691);

return statearr_14785;
})();
var statearr_14786_14854 = state_14748__$1;
(statearr_14786_14854[(2)] = null);

(statearr_14786_14854[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (43))){
var state_14748__$1 = state_14748;
var statearr_14787_14855 = state_14748__$1;
(statearr_14787_14855[(2)] = null);

(statearr_14787_14855[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (29))){
var inst_14732 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14788_14856 = state_14748__$1;
(statearr_14788_14856[(2)] = inst_14732);

(statearr_14788_14856[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (44))){
var inst_14741 = (state_14748[(2)]);
var state_14748__$1 = (function (){var statearr_14789 = state_14748;
(statearr_14789[(28)] = inst_14741);

return statearr_14789;
})();
var statearr_14790_14857 = state_14748__$1;
(statearr_14790_14857[(2)] = null);

(statearr_14790_14857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (6))){
var inst_14680 = (state_14748[(29)]);
var inst_14679 = cljs.core.deref.call(null,cs);
var inst_14680__$1 = cljs.core.keys.call(null,inst_14679);
var inst_14681 = cljs.core.count.call(null,inst_14680__$1);
var inst_14682 = cljs.core.reset_BANG_.call(null,dctr,inst_14681);
var inst_14687 = cljs.core.seq.call(null,inst_14680__$1);
var inst_14688 = inst_14687;
var inst_14689 = null;
var inst_14690 = (0);
var inst_14691 = (0);
var state_14748__$1 = (function (){var statearr_14791 = state_14748;
(statearr_14791[(20)] = inst_14688);

(statearr_14791[(10)] = inst_14689);

(statearr_14791[(29)] = inst_14680__$1);

(statearr_14791[(30)] = inst_14682);

(statearr_14791[(21)] = inst_14690);

(statearr_14791[(11)] = inst_14691);

return statearr_14791;
})();
var statearr_14792_14858 = state_14748__$1;
(statearr_14792_14858[(2)] = null);

(statearr_14792_14858[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (28))){
var inst_14707 = (state_14748[(25)]);
var inst_14688 = (state_14748[(20)]);
var inst_14707__$1 = cljs.core.seq.call(null,inst_14688);
var state_14748__$1 = (function (){var statearr_14793 = state_14748;
(statearr_14793[(25)] = inst_14707__$1);

return statearr_14793;
})();
if(inst_14707__$1){
var statearr_14794_14859 = state_14748__$1;
(statearr_14794_14859[(1)] = (33));

} else {
var statearr_14795_14860 = state_14748__$1;
(statearr_14795_14860[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (25))){
var inst_14690 = (state_14748[(21)]);
var inst_14691 = (state_14748[(11)]);
var inst_14693 = (inst_14691 < inst_14690);
var inst_14694 = inst_14693;
var state_14748__$1 = state_14748;
if(cljs.core.truth_(inst_14694)){
var statearr_14796_14861 = state_14748__$1;
(statearr_14796_14861[(1)] = (27));

} else {
var statearr_14797_14862 = state_14748__$1;
(statearr_14797_14862[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (34))){
var state_14748__$1 = state_14748;
var statearr_14798_14863 = state_14748__$1;
(statearr_14798_14863[(2)] = null);

(statearr_14798_14863[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (17))){
var state_14748__$1 = state_14748;
var statearr_14799_14864 = state_14748__$1;
(statearr_14799_14864[(2)] = null);

(statearr_14799_14864[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (3))){
var inst_14746 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14748__$1,inst_14746);
} else {
if((state_val_14749 === (12))){
var inst_14675 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14800_14865 = state_14748__$1;
(statearr_14800_14865[(2)] = inst_14675);

(statearr_14800_14865[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (2))){
var state_14748__$1 = state_14748;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14748__$1,(4),ch);
} else {
if((state_val_14749 === (23))){
var state_14748__$1 = state_14748;
var statearr_14801_14866 = state_14748__$1;
(statearr_14801_14866[(2)] = null);

(statearr_14801_14866[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (35))){
var inst_14730 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14802_14867 = state_14748__$1;
(statearr_14802_14867[(2)] = inst_14730);

(statearr_14802_14867[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (19))){
var inst_14647 = (state_14748[(7)]);
var inst_14651 = cljs.core.chunk_first.call(null,inst_14647);
var inst_14652 = cljs.core.chunk_rest.call(null,inst_14647);
var inst_14653 = cljs.core.count.call(null,inst_14651);
var inst_14625 = inst_14652;
var inst_14626 = inst_14651;
var inst_14627 = inst_14653;
var inst_14628 = (0);
var state_14748__$1 = (function (){var statearr_14803 = state_14748;
(statearr_14803[(13)] = inst_14627);

(statearr_14803[(14)] = inst_14626);

(statearr_14803[(15)] = inst_14628);

(statearr_14803[(17)] = inst_14625);

return statearr_14803;
})();
var statearr_14804_14868 = state_14748__$1;
(statearr_14804_14868[(2)] = null);

(statearr_14804_14868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (11))){
var inst_14647 = (state_14748[(7)]);
var inst_14625 = (state_14748[(17)]);
var inst_14647__$1 = cljs.core.seq.call(null,inst_14625);
var state_14748__$1 = (function (){var statearr_14805 = state_14748;
(statearr_14805[(7)] = inst_14647__$1);

return statearr_14805;
})();
if(inst_14647__$1){
var statearr_14806_14869 = state_14748__$1;
(statearr_14806_14869[(1)] = (16));

} else {
var statearr_14807_14870 = state_14748__$1;
(statearr_14807_14870[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (9))){
var inst_14677 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14808_14871 = state_14748__$1;
(statearr_14808_14871[(2)] = inst_14677);

(statearr_14808_14871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (5))){
var inst_14623 = cljs.core.deref.call(null,cs);
var inst_14624 = cljs.core.seq.call(null,inst_14623);
var inst_14625 = inst_14624;
var inst_14626 = null;
var inst_14627 = (0);
var inst_14628 = (0);
var state_14748__$1 = (function (){var statearr_14809 = state_14748;
(statearr_14809[(13)] = inst_14627);

(statearr_14809[(14)] = inst_14626);

(statearr_14809[(15)] = inst_14628);

(statearr_14809[(17)] = inst_14625);

return statearr_14809;
})();
var statearr_14810_14872 = state_14748__$1;
(statearr_14810_14872[(2)] = null);

(statearr_14810_14872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (14))){
var state_14748__$1 = state_14748;
var statearr_14811_14873 = state_14748__$1;
(statearr_14811_14873[(2)] = null);

(statearr_14811_14873[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (45))){
var inst_14738 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14812_14874 = state_14748__$1;
(statearr_14812_14874[(2)] = inst_14738);

(statearr_14812_14874[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (26))){
var inst_14680 = (state_14748[(29)]);
var inst_14734 = (state_14748[(2)]);
var inst_14735 = cljs.core.seq.call(null,inst_14680);
var state_14748__$1 = (function (){var statearr_14813 = state_14748;
(statearr_14813[(31)] = inst_14734);

return statearr_14813;
})();
if(inst_14735){
var statearr_14814_14875 = state_14748__$1;
(statearr_14814_14875[(1)] = (42));

} else {
var statearr_14815_14876 = state_14748__$1;
(statearr_14815_14876[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (16))){
var inst_14647 = (state_14748[(7)]);
var inst_14649 = cljs.core.chunked_seq_QMARK_.call(null,inst_14647);
var state_14748__$1 = state_14748;
if(inst_14649){
var statearr_14816_14877 = state_14748__$1;
(statearr_14816_14877[(1)] = (19));

} else {
var statearr_14817_14878 = state_14748__$1;
(statearr_14817_14878[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (38))){
var inst_14727 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14818_14879 = state_14748__$1;
(statearr_14818_14879[(2)] = inst_14727);

(statearr_14818_14879[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (30))){
var state_14748__$1 = state_14748;
var statearr_14819_14880 = state_14748__$1;
(statearr_14819_14880[(2)] = null);

(statearr_14819_14880[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (10))){
var inst_14626 = (state_14748[(14)]);
var inst_14628 = (state_14748[(15)]);
var inst_14636 = cljs.core._nth.call(null,inst_14626,inst_14628);
var inst_14637 = cljs.core.nth.call(null,inst_14636,(0),null);
var inst_14638 = cljs.core.nth.call(null,inst_14636,(1),null);
var state_14748__$1 = (function (){var statearr_14820 = state_14748;
(statearr_14820[(26)] = inst_14637);

return statearr_14820;
})();
if(cljs.core.truth_(inst_14638)){
var statearr_14821_14881 = state_14748__$1;
(statearr_14821_14881[(1)] = (13));

} else {
var statearr_14822_14882 = state_14748__$1;
(statearr_14822_14882[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (18))){
var inst_14673 = (state_14748[(2)]);
var state_14748__$1 = state_14748;
var statearr_14823_14883 = state_14748__$1;
(statearr_14823_14883[(2)] = inst_14673);

(statearr_14823_14883[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (42))){
var state_14748__$1 = state_14748;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14748__$1,(45),dchan);
} else {
if((state_val_14749 === (37))){
var inst_14707 = (state_14748[(25)]);
var inst_14616 = (state_14748[(12)]);
var inst_14716 = (state_14748[(23)]);
var inst_14716__$1 = cljs.core.first.call(null,inst_14707);
var inst_14717 = cljs.core.async.put_BANG_.call(null,inst_14716__$1,inst_14616,done);
var state_14748__$1 = (function (){var statearr_14824 = state_14748;
(statearr_14824[(23)] = inst_14716__$1);

return statearr_14824;
})();
if(cljs.core.truth_(inst_14717)){
var statearr_14825_14884 = state_14748__$1;
(statearr_14825_14884[(1)] = (39));

} else {
var statearr_14826_14885 = state_14748__$1;
(statearr_14826_14885[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14749 === (8))){
var inst_14627 = (state_14748[(13)]);
var inst_14628 = (state_14748[(15)]);
var inst_14630 = (inst_14628 < inst_14627);
var inst_14631 = inst_14630;
var state_14748__$1 = state_14748;
if(cljs.core.truth_(inst_14631)){
var statearr_14827_14886 = state_14748__$1;
(statearr_14827_14886[(1)] = (10));

} else {
var statearr_14828_14887 = state_14748__$1;
(statearr_14828_14887[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___14833,cs,m,dchan,dctr,done))
;
return ((function (switch__11820__auto__,c__11864__auto___14833,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11821__auto__ = null;
var cljs$core$async$mult_$_state_machine__11821__auto____0 = (function (){
var statearr_14829 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14829[(0)] = cljs$core$async$mult_$_state_machine__11821__auto__);

(statearr_14829[(1)] = (1));

return statearr_14829;
});
var cljs$core$async$mult_$_state_machine__11821__auto____1 = (function (state_14748){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_14748);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e14830){if((e14830 instanceof Object)){
var ex__11824__auto__ = e14830;
var statearr_14831_14888 = state_14748;
(statearr_14831_14888[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14748);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14830;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14889 = state_14748;
state_14748 = G__14889;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11821__auto__ = function(state_14748){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11821__auto____1.call(this,state_14748);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11821__auto____0;
cljs$core$async$mult_$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11821__auto____1;
return cljs$core$async$mult_$_state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___14833,cs,m,dchan,dctr,done))
})();
var state__11866__auto__ = (function (){var statearr_14832 = f__11865__auto__.call(null);
(statearr_14832[(6)] = c__11864__auto___14833);

return statearr_14832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___14833,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__14891 = arguments.length;
switch (G__14891) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8884__auto__ = (((m == null))?null:m);
var m__8885__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,m,ch);
} else {
var m__8885__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8884__auto__ = (((m == null))?null:m);
var m__8885__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,m,ch);
} else {
var m__8885__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8884__auto__ = (((m == null))?null:m);
var m__8885__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,m);
} else {
var m__8885__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8884__auto__ = (((m == null))?null:m);
var m__8885__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,m,state_map);
} else {
var m__8885__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8884__auto__ = (((m == null))?null:m);
var m__8885__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,m,mode);
} else {
var m__8885__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__9377__auto__ = [];
var len__9370__auto___14903 = arguments.length;
var i__9371__auto___14904 = (0);
while(true){
if((i__9371__auto___14904 < len__9370__auto___14903)){
args__9377__auto__.push((arguments[i__9371__auto___14904]));

var G__14905 = (i__9371__auto___14904 + (1));
i__9371__auto___14904 = G__14905;
continue;
} else {
}
break;
}

var argseq__9378__auto__ = ((((3) < args__9377__auto__.length))?(new cljs.core.IndexedSeq(args__9377__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9378__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__14897){
var map__14898 = p__14897;
var map__14898__$1 = ((((!((map__14898 == null)))?((((map__14898.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14898.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14898):map__14898);
var opts = map__14898__$1;
var statearr_14900_14906 = state;
(statearr_14900_14906[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__14898,map__14898__$1,opts){
return (function (val){
var statearr_14901_14907 = state;
(statearr_14901_14907[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__14898,map__14898__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_14902_14908 = state;
(statearr_14902_14908[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq14893){
var G__14894 = cljs.core.first.call(null,seq14893);
var seq14893__$1 = cljs.core.next.call(null,seq14893);
var G__14895 = cljs.core.first.call(null,seq14893__$1);
var seq14893__$2 = cljs.core.next.call(null,seq14893__$1);
var G__14896 = cljs.core.first.call(null,seq14893__$2);
var seq14893__$3 = cljs.core.next.call(null,seq14893__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14894,G__14895,G__14896,seq14893__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async14909 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14909 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta14910){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta14910 = meta14910;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_14911,meta14910__$1){
var self__ = this;
var _14911__$1 = this;
return (new cljs.core.async.t_cljs$core$async14909(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta14910__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_14911){
var self__ = this;
var _14911__$1 = this;
return self__.meta14910;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta14910","meta14910",-1976118799,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14909.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14909.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14909";

cljs.core.async.t_cljs$core$async14909.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async14909");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async14909 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async14909(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta14910){
return (new cljs.core.async.t_cljs$core$async14909(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta14910));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async14909(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11864__auto___15073 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_15013){
var state_val_15014 = (state_15013[(1)]);
if((state_val_15014 === (7))){
var inst_14928 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
var statearr_15015_15074 = state_15013__$1;
(statearr_15015_15074[(2)] = inst_14928);

(statearr_15015_15074[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (20))){
var inst_14940 = (state_15013[(7)]);
var state_15013__$1 = state_15013;
var statearr_15016_15075 = state_15013__$1;
(statearr_15016_15075[(2)] = inst_14940);

(statearr_15016_15075[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (27))){
var state_15013__$1 = state_15013;
var statearr_15017_15076 = state_15013__$1;
(statearr_15017_15076[(2)] = null);

(statearr_15017_15076[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (1))){
var inst_14915 = (state_15013[(8)]);
var inst_14915__$1 = calc_state.call(null);
var inst_14917 = (inst_14915__$1 == null);
var inst_14918 = cljs.core.not.call(null,inst_14917);
var state_15013__$1 = (function (){var statearr_15018 = state_15013;
(statearr_15018[(8)] = inst_14915__$1);

return statearr_15018;
})();
if(inst_14918){
var statearr_15019_15077 = state_15013__$1;
(statearr_15019_15077[(1)] = (2));

} else {
var statearr_15020_15078 = state_15013__$1;
(statearr_15020_15078[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (24))){
var inst_14973 = (state_15013[(9)]);
var inst_14987 = (state_15013[(10)]);
var inst_14964 = (state_15013[(11)]);
var inst_14987__$1 = inst_14964.call(null,inst_14973);
var state_15013__$1 = (function (){var statearr_15021 = state_15013;
(statearr_15021[(10)] = inst_14987__$1);

return statearr_15021;
})();
if(cljs.core.truth_(inst_14987__$1)){
var statearr_15022_15079 = state_15013__$1;
(statearr_15022_15079[(1)] = (29));

} else {
var statearr_15023_15080 = state_15013__$1;
(statearr_15023_15080[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (4))){
var inst_14931 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
if(cljs.core.truth_(inst_14931)){
var statearr_15024_15081 = state_15013__$1;
(statearr_15024_15081[(1)] = (8));

} else {
var statearr_15025_15082 = state_15013__$1;
(statearr_15025_15082[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (15))){
var inst_14958 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
if(cljs.core.truth_(inst_14958)){
var statearr_15026_15083 = state_15013__$1;
(statearr_15026_15083[(1)] = (19));

} else {
var statearr_15027_15084 = state_15013__$1;
(statearr_15027_15084[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (21))){
var inst_14963 = (state_15013[(12)]);
var inst_14963__$1 = (state_15013[(2)]);
var inst_14964 = cljs.core.get.call(null,inst_14963__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_14965 = cljs.core.get.call(null,inst_14963__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_14966 = cljs.core.get.call(null,inst_14963__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_15013__$1 = (function (){var statearr_15028 = state_15013;
(statearr_15028[(12)] = inst_14963__$1);

(statearr_15028[(11)] = inst_14964);

(statearr_15028[(13)] = inst_14965);

return statearr_15028;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15013__$1,(22),inst_14966);
} else {
if((state_val_15014 === (31))){
var inst_14995 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
if(cljs.core.truth_(inst_14995)){
var statearr_15029_15085 = state_15013__$1;
(statearr_15029_15085[(1)] = (32));

} else {
var statearr_15030_15086 = state_15013__$1;
(statearr_15030_15086[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (32))){
var inst_14972 = (state_15013[(14)]);
var state_15013__$1 = state_15013;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15013__$1,(35),out,inst_14972);
} else {
if((state_val_15014 === (33))){
var inst_14963 = (state_15013[(12)]);
var inst_14940 = inst_14963;
var state_15013__$1 = (function (){var statearr_15031 = state_15013;
(statearr_15031[(7)] = inst_14940);

return statearr_15031;
})();
var statearr_15032_15087 = state_15013__$1;
(statearr_15032_15087[(2)] = null);

(statearr_15032_15087[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (13))){
var inst_14940 = (state_15013[(7)]);
var inst_14947 = inst_14940.cljs$lang$protocol_mask$partition0$;
var inst_14948 = (inst_14947 & (64));
var inst_14949 = inst_14940.cljs$core$ISeq$;
var inst_14950 = (cljs.core.PROTOCOL_SENTINEL === inst_14949);
var inst_14951 = (inst_14948) || (inst_14950);
var state_15013__$1 = state_15013;
if(cljs.core.truth_(inst_14951)){
var statearr_15033_15088 = state_15013__$1;
(statearr_15033_15088[(1)] = (16));

} else {
var statearr_15034_15089 = state_15013__$1;
(statearr_15034_15089[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (22))){
var inst_14973 = (state_15013[(9)]);
var inst_14972 = (state_15013[(14)]);
var inst_14971 = (state_15013[(2)]);
var inst_14972__$1 = cljs.core.nth.call(null,inst_14971,(0),null);
var inst_14973__$1 = cljs.core.nth.call(null,inst_14971,(1),null);
var inst_14974 = (inst_14972__$1 == null);
var inst_14975 = cljs.core._EQ_.call(null,inst_14973__$1,change);
var inst_14976 = (inst_14974) || (inst_14975);
var state_15013__$1 = (function (){var statearr_15035 = state_15013;
(statearr_15035[(9)] = inst_14973__$1);

(statearr_15035[(14)] = inst_14972__$1);

return statearr_15035;
})();
if(cljs.core.truth_(inst_14976)){
var statearr_15036_15090 = state_15013__$1;
(statearr_15036_15090[(1)] = (23));

} else {
var statearr_15037_15091 = state_15013__$1;
(statearr_15037_15091[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (36))){
var inst_14963 = (state_15013[(12)]);
var inst_14940 = inst_14963;
var state_15013__$1 = (function (){var statearr_15038 = state_15013;
(statearr_15038[(7)] = inst_14940);

return statearr_15038;
})();
var statearr_15039_15092 = state_15013__$1;
(statearr_15039_15092[(2)] = null);

(statearr_15039_15092[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (29))){
var inst_14987 = (state_15013[(10)]);
var state_15013__$1 = state_15013;
var statearr_15040_15093 = state_15013__$1;
(statearr_15040_15093[(2)] = inst_14987);

(statearr_15040_15093[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (6))){
var state_15013__$1 = state_15013;
var statearr_15041_15094 = state_15013__$1;
(statearr_15041_15094[(2)] = false);

(statearr_15041_15094[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (28))){
var inst_14983 = (state_15013[(2)]);
var inst_14984 = calc_state.call(null);
var inst_14940 = inst_14984;
var state_15013__$1 = (function (){var statearr_15042 = state_15013;
(statearr_15042[(7)] = inst_14940);

(statearr_15042[(15)] = inst_14983);

return statearr_15042;
})();
var statearr_15043_15095 = state_15013__$1;
(statearr_15043_15095[(2)] = null);

(statearr_15043_15095[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (25))){
var inst_15009 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
var statearr_15044_15096 = state_15013__$1;
(statearr_15044_15096[(2)] = inst_15009);

(statearr_15044_15096[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (34))){
var inst_15007 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
var statearr_15045_15097 = state_15013__$1;
(statearr_15045_15097[(2)] = inst_15007);

(statearr_15045_15097[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (17))){
var state_15013__$1 = state_15013;
var statearr_15046_15098 = state_15013__$1;
(statearr_15046_15098[(2)] = false);

(statearr_15046_15098[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (3))){
var state_15013__$1 = state_15013;
var statearr_15047_15099 = state_15013__$1;
(statearr_15047_15099[(2)] = false);

(statearr_15047_15099[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (12))){
var inst_15011 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15013__$1,inst_15011);
} else {
if((state_val_15014 === (2))){
var inst_14915 = (state_15013[(8)]);
var inst_14920 = inst_14915.cljs$lang$protocol_mask$partition0$;
var inst_14921 = (inst_14920 & (64));
var inst_14922 = inst_14915.cljs$core$ISeq$;
var inst_14923 = (cljs.core.PROTOCOL_SENTINEL === inst_14922);
var inst_14924 = (inst_14921) || (inst_14923);
var state_15013__$1 = state_15013;
if(cljs.core.truth_(inst_14924)){
var statearr_15048_15100 = state_15013__$1;
(statearr_15048_15100[(1)] = (5));

} else {
var statearr_15049_15101 = state_15013__$1;
(statearr_15049_15101[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (23))){
var inst_14972 = (state_15013[(14)]);
var inst_14978 = (inst_14972 == null);
var state_15013__$1 = state_15013;
if(cljs.core.truth_(inst_14978)){
var statearr_15050_15102 = state_15013__$1;
(statearr_15050_15102[(1)] = (26));

} else {
var statearr_15051_15103 = state_15013__$1;
(statearr_15051_15103[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (35))){
var inst_14998 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
if(cljs.core.truth_(inst_14998)){
var statearr_15052_15104 = state_15013__$1;
(statearr_15052_15104[(1)] = (36));

} else {
var statearr_15053_15105 = state_15013__$1;
(statearr_15053_15105[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (19))){
var inst_14940 = (state_15013[(7)]);
var inst_14960 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14940);
var state_15013__$1 = state_15013;
var statearr_15054_15106 = state_15013__$1;
(statearr_15054_15106[(2)] = inst_14960);

(statearr_15054_15106[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (11))){
var inst_14940 = (state_15013[(7)]);
var inst_14944 = (inst_14940 == null);
var inst_14945 = cljs.core.not.call(null,inst_14944);
var state_15013__$1 = state_15013;
if(inst_14945){
var statearr_15055_15107 = state_15013__$1;
(statearr_15055_15107[(1)] = (13));

} else {
var statearr_15056_15108 = state_15013__$1;
(statearr_15056_15108[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (9))){
var inst_14915 = (state_15013[(8)]);
var state_15013__$1 = state_15013;
var statearr_15057_15109 = state_15013__$1;
(statearr_15057_15109[(2)] = inst_14915);

(statearr_15057_15109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (5))){
var state_15013__$1 = state_15013;
var statearr_15058_15110 = state_15013__$1;
(statearr_15058_15110[(2)] = true);

(statearr_15058_15110[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (14))){
var state_15013__$1 = state_15013;
var statearr_15059_15111 = state_15013__$1;
(statearr_15059_15111[(2)] = false);

(statearr_15059_15111[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (26))){
var inst_14973 = (state_15013[(9)]);
var inst_14980 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_14973);
var state_15013__$1 = state_15013;
var statearr_15060_15112 = state_15013__$1;
(statearr_15060_15112[(2)] = inst_14980);

(statearr_15060_15112[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (16))){
var state_15013__$1 = state_15013;
var statearr_15061_15113 = state_15013__$1;
(statearr_15061_15113[(2)] = true);

(statearr_15061_15113[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (38))){
var inst_15003 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
var statearr_15062_15114 = state_15013__$1;
(statearr_15062_15114[(2)] = inst_15003);

(statearr_15062_15114[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (30))){
var inst_14973 = (state_15013[(9)]);
var inst_14964 = (state_15013[(11)]);
var inst_14965 = (state_15013[(13)]);
var inst_14990 = cljs.core.empty_QMARK_.call(null,inst_14964);
var inst_14991 = inst_14965.call(null,inst_14973);
var inst_14992 = cljs.core.not.call(null,inst_14991);
var inst_14993 = (inst_14990) && (inst_14992);
var state_15013__$1 = state_15013;
var statearr_15063_15115 = state_15013__$1;
(statearr_15063_15115[(2)] = inst_14993);

(statearr_15063_15115[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (10))){
var inst_14915 = (state_15013[(8)]);
var inst_14936 = (state_15013[(2)]);
var inst_14937 = cljs.core.get.call(null,inst_14936,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_14938 = cljs.core.get.call(null,inst_14936,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_14939 = cljs.core.get.call(null,inst_14936,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_14940 = inst_14915;
var state_15013__$1 = (function (){var statearr_15064 = state_15013;
(statearr_15064[(7)] = inst_14940);

(statearr_15064[(16)] = inst_14937);

(statearr_15064[(17)] = inst_14939);

(statearr_15064[(18)] = inst_14938);

return statearr_15064;
})();
var statearr_15065_15116 = state_15013__$1;
(statearr_15065_15116[(2)] = null);

(statearr_15065_15116[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (18))){
var inst_14955 = (state_15013[(2)]);
var state_15013__$1 = state_15013;
var statearr_15066_15117 = state_15013__$1;
(statearr_15066_15117[(2)] = inst_14955);

(statearr_15066_15117[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (37))){
var state_15013__$1 = state_15013;
var statearr_15067_15118 = state_15013__$1;
(statearr_15067_15118[(2)] = null);

(statearr_15067_15118[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15014 === (8))){
var inst_14915 = (state_15013[(8)]);
var inst_14933 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14915);
var state_15013__$1 = state_15013;
var statearr_15068_15119 = state_15013__$1;
(statearr_15068_15119[(2)] = inst_14933);

(statearr_15068_15119[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11820__auto__,c__11864__auto___15073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11821__auto__ = null;
var cljs$core$async$mix_$_state_machine__11821__auto____0 = (function (){
var statearr_15069 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15069[(0)] = cljs$core$async$mix_$_state_machine__11821__auto__);

(statearr_15069[(1)] = (1));

return statearr_15069;
});
var cljs$core$async$mix_$_state_machine__11821__auto____1 = (function (state_15013){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15013);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15070){if((e15070 instanceof Object)){
var ex__11824__auto__ = e15070;
var statearr_15071_15120 = state_15013;
(statearr_15071_15120[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15013);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15070;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15121 = state_15013;
state_15013 = G__15121;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11821__auto__ = function(state_15013){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11821__auto____1.call(this,state_15013);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11821__auto____0;
cljs$core$async$mix_$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11821__auto____1;
return cljs$core$async$mix_$_state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11866__auto__ = (function (){var statearr_15072 = f__11865__auto__.call(null);
(statearr_15072[(6)] = c__11864__auto___15073);

return statearr_15072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8884__auto__ = (((p == null))?null:p);
var m__8885__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__8885__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8884__auto__ = (((p == null))?null:p);
var m__8885__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,p,v,ch);
} else {
var m__8885__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__15123 = arguments.length;
switch (G__15123) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8884__auto__ = (((p == null))?null:p);
var m__8885__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,p);
} else {
var m__8885__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8884__auto__ = (((p == null))?null:p);
var m__8885__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8884__auto__)]);
if(!((m__8885__auto__ == null))){
return m__8885__auto__.call(null,p,v);
} else {
var m__8885__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8885__auto____$1 == null))){
return m__8885__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__15127 = arguments.length;
switch (G__15127) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8201__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__8201__auto__)){
return or__8201__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__8201__auto__,mults){
return (function (p1__15125_SHARP_){
if(cljs.core.truth_(p1__15125_SHARP_.call(null,topic))){
return p1__15125_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__15125_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__8201__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async15128 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15128 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15129){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15129 = meta15129;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_15130,meta15129__$1){
var self__ = this;
var _15130__$1 = this;
return (new cljs.core.async.t_cljs$core$async15128(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15129__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_15130){
var self__ = this;
var _15130__$1 = this;
return self__.meta15129;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15128.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15128.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta15129","meta15129",-1502579470,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15128.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15128.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15128";

cljs.core.async.t_cljs$core$async15128.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async15128");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async15128 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async15128(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15129){
return (new cljs.core.async.t_cljs$core$async15128(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15129));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async15128(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11864__auto___15248 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15248,mults,ensure_mult,p){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15248,mults,ensure_mult,p){
return (function (state_15202){
var state_val_15203 = (state_15202[(1)]);
if((state_val_15203 === (7))){
var inst_15198 = (state_15202[(2)]);
var state_15202__$1 = state_15202;
var statearr_15204_15249 = state_15202__$1;
(statearr_15204_15249[(2)] = inst_15198);

(statearr_15204_15249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (20))){
var state_15202__$1 = state_15202;
var statearr_15205_15250 = state_15202__$1;
(statearr_15205_15250[(2)] = null);

(statearr_15205_15250[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (1))){
var state_15202__$1 = state_15202;
var statearr_15206_15251 = state_15202__$1;
(statearr_15206_15251[(2)] = null);

(statearr_15206_15251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (24))){
var inst_15181 = (state_15202[(7)]);
var inst_15190 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_15181);
var state_15202__$1 = state_15202;
var statearr_15207_15252 = state_15202__$1;
(statearr_15207_15252[(2)] = inst_15190);

(statearr_15207_15252[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (4))){
var inst_15133 = (state_15202[(8)]);
var inst_15133__$1 = (state_15202[(2)]);
var inst_15134 = (inst_15133__$1 == null);
var state_15202__$1 = (function (){var statearr_15208 = state_15202;
(statearr_15208[(8)] = inst_15133__$1);

return statearr_15208;
})();
if(cljs.core.truth_(inst_15134)){
var statearr_15209_15253 = state_15202__$1;
(statearr_15209_15253[(1)] = (5));

} else {
var statearr_15210_15254 = state_15202__$1;
(statearr_15210_15254[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (15))){
var inst_15175 = (state_15202[(2)]);
var state_15202__$1 = state_15202;
var statearr_15211_15255 = state_15202__$1;
(statearr_15211_15255[(2)] = inst_15175);

(statearr_15211_15255[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (21))){
var inst_15195 = (state_15202[(2)]);
var state_15202__$1 = (function (){var statearr_15212 = state_15202;
(statearr_15212[(9)] = inst_15195);

return statearr_15212;
})();
var statearr_15213_15256 = state_15202__$1;
(statearr_15213_15256[(2)] = null);

(statearr_15213_15256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (13))){
var inst_15157 = (state_15202[(10)]);
var inst_15159 = cljs.core.chunked_seq_QMARK_.call(null,inst_15157);
var state_15202__$1 = state_15202;
if(inst_15159){
var statearr_15214_15257 = state_15202__$1;
(statearr_15214_15257[(1)] = (16));

} else {
var statearr_15215_15258 = state_15202__$1;
(statearr_15215_15258[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (22))){
var inst_15187 = (state_15202[(2)]);
var state_15202__$1 = state_15202;
if(cljs.core.truth_(inst_15187)){
var statearr_15216_15259 = state_15202__$1;
(statearr_15216_15259[(1)] = (23));

} else {
var statearr_15217_15260 = state_15202__$1;
(statearr_15217_15260[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (6))){
var inst_15181 = (state_15202[(7)]);
var inst_15183 = (state_15202[(11)]);
var inst_15133 = (state_15202[(8)]);
var inst_15181__$1 = topic_fn.call(null,inst_15133);
var inst_15182 = cljs.core.deref.call(null,mults);
var inst_15183__$1 = cljs.core.get.call(null,inst_15182,inst_15181__$1);
var state_15202__$1 = (function (){var statearr_15218 = state_15202;
(statearr_15218[(7)] = inst_15181__$1);

(statearr_15218[(11)] = inst_15183__$1);

return statearr_15218;
})();
if(cljs.core.truth_(inst_15183__$1)){
var statearr_15219_15261 = state_15202__$1;
(statearr_15219_15261[(1)] = (19));

} else {
var statearr_15220_15262 = state_15202__$1;
(statearr_15220_15262[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (25))){
var inst_15192 = (state_15202[(2)]);
var state_15202__$1 = state_15202;
var statearr_15221_15263 = state_15202__$1;
(statearr_15221_15263[(2)] = inst_15192);

(statearr_15221_15263[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (17))){
var inst_15157 = (state_15202[(10)]);
var inst_15166 = cljs.core.first.call(null,inst_15157);
var inst_15167 = cljs.core.async.muxch_STAR_.call(null,inst_15166);
var inst_15168 = cljs.core.async.close_BANG_.call(null,inst_15167);
var inst_15169 = cljs.core.next.call(null,inst_15157);
var inst_15143 = inst_15169;
var inst_15144 = null;
var inst_15145 = (0);
var inst_15146 = (0);
var state_15202__$1 = (function (){var statearr_15222 = state_15202;
(statearr_15222[(12)] = inst_15146);

(statearr_15222[(13)] = inst_15143);

(statearr_15222[(14)] = inst_15145);

(statearr_15222[(15)] = inst_15144);

(statearr_15222[(16)] = inst_15168);

return statearr_15222;
})();
var statearr_15223_15264 = state_15202__$1;
(statearr_15223_15264[(2)] = null);

(statearr_15223_15264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (3))){
var inst_15200 = (state_15202[(2)]);
var state_15202__$1 = state_15202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15202__$1,inst_15200);
} else {
if((state_val_15203 === (12))){
var inst_15177 = (state_15202[(2)]);
var state_15202__$1 = state_15202;
var statearr_15224_15265 = state_15202__$1;
(statearr_15224_15265[(2)] = inst_15177);

(statearr_15224_15265[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (2))){
var state_15202__$1 = state_15202;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15202__$1,(4),ch);
} else {
if((state_val_15203 === (23))){
var state_15202__$1 = state_15202;
var statearr_15225_15266 = state_15202__$1;
(statearr_15225_15266[(2)] = null);

(statearr_15225_15266[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (19))){
var inst_15183 = (state_15202[(11)]);
var inst_15133 = (state_15202[(8)]);
var inst_15185 = cljs.core.async.muxch_STAR_.call(null,inst_15183);
var state_15202__$1 = state_15202;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15202__$1,(22),inst_15185,inst_15133);
} else {
if((state_val_15203 === (11))){
var inst_15143 = (state_15202[(13)]);
var inst_15157 = (state_15202[(10)]);
var inst_15157__$1 = cljs.core.seq.call(null,inst_15143);
var state_15202__$1 = (function (){var statearr_15226 = state_15202;
(statearr_15226[(10)] = inst_15157__$1);

return statearr_15226;
})();
if(inst_15157__$1){
var statearr_15227_15267 = state_15202__$1;
(statearr_15227_15267[(1)] = (13));

} else {
var statearr_15228_15268 = state_15202__$1;
(statearr_15228_15268[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (9))){
var inst_15179 = (state_15202[(2)]);
var state_15202__$1 = state_15202;
var statearr_15229_15269 = state_15202__$1;
(statearr_15229_15269[(2)] = inst_15179);

(statearr_15229_15269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (5))){
var inst_15140 = cljs.core.deref.call(null,mults);
var inst_15141 = cljs.core.vals.call(null,inst_15140);
var inst_15142 = cljs.core.seq.call(null,inst_15141);
var inst_15143 = inst_15142;
var inst_15144 = null;
var inst_15145 = (0);
var inst_15146 = (0);
var state_15202__$1 = (function (){var statearr_15230 = state_15202;
(statearr_15230[(12)] = inst_15146);

(statearr_15230[(13)] = inst_15143);

(statearr_15230[(14)] = inst_15145);

(statearr_15230[(15)] = inst_15144);

return statearr_15230;
})();
var statearr_15231_15270 = state_15202__$1;
(statearr_15231_15270[(2)] = null);

(statearr_15231_15270[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (14))){
var state_15202__$1 = state_15202;
var statearr_15235_15271 = state_15202__$1;
(statearr_15235_15271[(2)] = null);

(statearr_15235_15271[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (16))){
var inst_15157 = (state_15202[(10)]);
var inst_15161 = cljs.core.chunk_first.call(null,inst_15157);
var inst_15162 = cljs.core.chunk_rest.call(null,inst_15157);
var inst_15163 = cljs.core.count.call(null,inst_15161);
var inst_15143 = inst_15162;
var inst_15144 = inst_15161;
var inst_15145 = inst_15163;
var inst_15146 = (0);
var state_15202__$1 = (function (){var statearr_15236 = state_15202;
(statearr_15236[(12)] = inst_15146);

(statearr_15236[(13)] = inst_15143);

(statearr_15236[(14)] = inst_15145);

(statearr_15236[(15)] = inst_15144);

return statearr_15236;
})();
var statearr_15237_15272 = state_15202__$1;
(statearr_15237_15272[(2)] = null);

(statearr_15237_15272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (10))){
var inst_15146 = (state_15202[(12)]);
var inst_15143 = (state_15202[(13)]);
var inst_15145 = (state_15202[(14)]);
var inst_15144 = (state_15202[(15)]);
var inst_15151 = cljs.core._nth.call(null,inst_15144,inst_15146);
var inst_15152 = cljs.core.async.muxch_STAR_.call(null,inst_15151);
var inst_15153 = cljs.core.async.close_BANG_.call(null,inst_15152);
var inst_15154 = (inst_15146 + (1));
var tmp15232 = inst_15143;
var tmp15233 = inst_15145;
var tmp15234 = inst_15144;
var inst_15143__$1 = tmp15232;
var inst_15144__$1 = tmp15234;
var inst_15145__$1 = tmp15233;
var inst_15146__$1 = inst_15154;
var state_15202__$1 = (function (){var statearr_15238 = state_15202;
(statearr_15238[(12)] = inst_15146__$1);

(statearr_15238[(13)] = inst_15143__$1);

(statearr_15238[(17)] = inst_15153);

(statearr_15238[(14)] = inst_15145__$1);

(statearr_15238[(15)] = inst_15144__$1);

return statearr_15238;
})();
var statearr_15239_15273 = state_15202__$1;
(statearr_15239_15273[(2)] = null);

(statearr_15239_15273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (18))){
var inst_15172 = (state_15202[(2)]);
var state_15202__$1 = state_15202;
var statearr_15240_15274 = state_15202__$1;
(statearr_15240_15274[(2)] = inst_15172);

(statearr_15240_15274[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15203 === (8))){
var inst_15146 = (state_15202[(12)]);
var inst_15145 = (state_15202[(14)]);
var inst_15148 = (inst_15146 < inst_15145);
var inst_15149 = inst_15148;
var state_15202__$1 = state_15202;
if(cljs.core.truth_(inst_15149)){
var statearr_15241_15275 = state_15202__$1;
(statearr_15241_15275[(1)] = (10));

} else {
var statearr_15242_15276 = state_15202__$1;
(statearr_15242_15276[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15248,mults,ensure_mult,p))
;
return ((function (switch__11820__auto__,c__11864__auto___15248,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_15243 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15243[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_15243[(1)] = (1));

return statearr_15243;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_15202){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15244){if((e15244 instanceof Object)){
var ex__11824__auto__ = e15244;
var statearr_15245_15277 = state_15202;
(statearr_15245_15277[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15202);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15244;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15278 = state_15202;
state_15202 = G__15278;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_15202){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_15202);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15248,mults,ensure_mult,p))
})();
var state__11866__auto__ = (function (){var statearr_15246 = f__11865__auto__.call(null);
(statearr_15246[(6)] = c__11864__auto___15248);

return statearr_15246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15248,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__15280 = arguments.length;
switch (G__15280) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__15283 = arguments.length;
switch (G__15283) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__15286 = arguments.length;
switch (G__15286) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11864__auto___15353 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15353,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15353,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_15325){
var state_val_15326 = (state_15325[(1)]);
if((state_val_15326 === (7))){
var state_15325__$1 = state_15325;
var statearr_15327_15354 = state_15325__$1;
(statearr_15327_15354[(2)] = null);

(statearr_15327_15354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (1))){
var state_15325__$1 = state_15325;
var statearr_15328_15355 = state_15325__$1;
(statearr_15328_15355[(2)] = null);

(statearr_15328_15355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (4))){
var inst_15289 = (state_15325[(7)]);
var inst_15291 = (inst_15289 < cnt);
var state_15325__$1 = state_15325;
if(cljs.core.truth_(inst_15291)){
var statearr_15329_15356 = state_15325__$1;
(statearr_15329_15356[(1)] = (6));

} else {
var statearr_15330_15357 = state_15325__$1;
(statearr_15330_15357[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (15))){
var inst_15321 = (state_15325[(2)]);
var state_15325__$1 = state_15325;
var statearr_15331_15358 = state_15325__$1;
(statearr_15331_15358[(2)] = inst_15321);

(statearr_15331_15358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (13))){
var inst_15314 = cljs.core.async.close_BANG_.call(null,out);
var state_15325__$1 = state_15325;
var statearr_15332_15359 = state_15325__$1;
(statearr_15332_15359[(2)] = inst_15314);

(statearr_15332_15359[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (6))){
var state_15325__$1 = state_15325;
var statearr_15333_15360 = state_15325__$1;
(statearr_15333_15360[(2)] = null);

(statearr_15333_15360[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (3))){
var inst_15323 = (state_15325[(2)]);
var state_15325__$1 = state_15325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15325__$1,inst_15323);
} else {
if((state_val_15326 === (12))){
var inst_15311 = (state_15325[(8)]);
var inst_15311__$1 = (state_15325[(2)]);
var inst_15312 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_15311__$1);
var state_15325__$1 = (function (){var statearr_15334 = state_15325;
(statearr_15334[(8)] = inst_15311__$1);

return statearr_15334;
})();
if(cljs.core.truth_(inst_15312)){
var statearr_15335_15361 = state_15325__$1;
(statearr_15335_15361[(1)] = (13));

} else {
var statearr_15336_15362 = state_15325__$1;
(statearr_15336_15362[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (2))){
var inst_15288 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_15289 = (0);
var state_15325__$1 = (function (){var statearr_15337 = state_15325;
(statearr_15337[(7)] = inst_15289);

(statearr_15337[(9)] = inst_15288);

return statearr_15337;
})();
var statearr_15338_15363 = state_15325__$1;
(statearr_15338_15363[(2)] = null);

(statearr_15338_15363[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (11))){
var inst_15289 = (state_15325[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_15325,(10),Object,null,(9));
var inst_15298 = chs__$1.call(null,inst_15289);
var inst_15299 = done.call(null,inst_15289);
var inst_15300 = cljs.core.async.take_BANG_.call(null,inst_15298,inst_15299);
var state_15325__$1 = state_15325;
var statearr_15339_15364 = state_15325__$1;
(statearr_15339_15364[(2)] = inst_15300);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15325__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (9))){
var inst_15289 = (state_15325[(7)]);
var inst_15302 = (state_15325[(2)]);
var inst_15303 = (inst_15289 + (1));
var inst_15289__$1 = inst_15303;
var state_15325__$1 = (function (){var statearr_15340 = state_15325;
(statearr_15340[(7)] = inst_15289__$1);

(statearr_15340[(10)] = inst_15302);

return statearr_15340;
})();
var statearr_15341_15365 = state_15325__$1;
(statearr_15341_15365[(2)] = null);

(statearr_15341_15365[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (5))){
var inst_15309 = (state_15325[(2)]);
var state_15325__$1 = (function (){var statearr_15342 = state_15325;
(statearr_15342[(11)] = inst_15309);

return statearr_15342;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15325__$1,(12),dchan);
} else {
if((state_val_15326 === (14))){
var inst_15311 = (state_15325[(8)]);
var inst_15316 = cljs.core.apply.call(null,f,inst_15311);
var state_15325__$1 = state_15325;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15325__$1,(16),out,inst_15316);
} else {
if((state_val_15326 === (16))){
var inst_15318 = (state_15325[(2)]);
var state_15325__$1 = (function (){var statearr_15343 = state_15325;
(statearr_15343[(12)] = inst_15318);

return statearr_15343;
})();
var statearr_15344_15366 = state_15325__$1;
(statearr_15344_15366[(2)] = null);

(statearr_15344_15366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (10))){
var inst_15293 = (state_15325[(2)]);
var inst_15294 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_15325__$1 = (function (){var statearr_15345 = state_15325;
(statearr_15345[(13)] = inst_15293);

return statearr_15345;
})();
var statearr_15346_15367 = state_15325__$1;
(statearr_15346_15367[(2)] = inst_15294);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15325__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15326 === (8))){
var inst_15307 = (state_15325[(2)]);
var state_15325__$1 = state_15325;
var statearr_15347_15368 = state_15325__$1;
(statearr_15347_15368[(2)] = inst_15307);

(statearr_15347_15368[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15353,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11820__auto__,c__11864__auto___15353,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_15348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15348[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_15348[(1)] = (1));

return statearr_15348;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_15325){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15349){if((e15349 instanceof Object)){
var ex__11824__auto__ = e15349;
var statearr_15350_15369 = state_15325;
(statearr_15350_15369[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15349;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15370 = state_15325;
state_15325 = G__15370;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_15325){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_15325);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15353,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11866__auto__ = (function (){var statearr_15351 = f__11865__auto__.call(null);
(statearr_15351[(6)] = c__11864__auto___15353);

return statearr_15351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15353,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__15373 = arguments.length;
switch (G__15373) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11864__auto___15427 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15427,out){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15427,out){
return (function (state_15405){
var state_val_15406 = (state_15405[(1)]);
if((state_val_15406 === (7))){
var inst_15385 = (state_15405[(7)]);
var inst_15384 = (state_15405[(8)]);
var inst_15384__$1 = (state_15405[(2)]);
var inst_15385__$1 = cljs.core.nth.call(null,inst_15384__$1,(0),null);
var inst_15386 = cljs.core.nth.call(null,inst_15384__$1,(1),null);
var inst_15387 = (inst_15385__$1 == null);
var state_15405__$1 = (function (){var statearr_15407 = state_15405;
(statearr_15407[(9)] = inst_15386);

(statearr_15407[(7)] = inst_15385__$1);

(statearr_15407[(8)] = inst_15384__$1);

return statearr_15407;
})();
if(cljs.core.truth_(inst_15387)){
var statearr_15408_15428 = state_15405__$1;
(statearr_15408_15428[(1)] = (8));

} else {
var statearr_15409_15429 = state_15405__$1;
(statearr_15409_15429[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (1))){
var inst_15374 = cljs.core.vec.call(null,chs);
var inst_15375 = inst_15374;
var state_15405__$1 = (function (){var statearr_15410 = state_15405;
(statearr_15410[(10)] = inst_15375);

return statearr_15410;
})();
var statearr_15411_15430 = state_15405__$1;
(statearr_15411_15430[(2)] = null);

(statearr_15411_15430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (4))){
var inst_15375 = (state_15405[(10)]);
var state_15405__$1 = state_15405;
return cljs.core.async.ioc_alts_BANG_.call(null,state_15405__$1,(7),inst_15375);
} else {
if((state_val_15406 === (6))){
var inst_15401 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
var statearr_15412_15431 = state_15405__$1;
(statearr_15412_15431[(2)] = inst_15401);

(statearr_15412_15431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (3))){
var inst_15403 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15405__$1,inst_15403);
} else {
if((state_val_15406 === (2))){
var inst_15375 = (state_15405[(10)]);
var inst_15377 = cljs.core.count.call(null,inst_15375);
var inst_15378 = (inst_15377 > (0));
var state_15405__$1 = state_15405;
if(cljs.core.truth_(inst_15378)){
var statearr_15414_15432 = state_15405__$1;
(statearr_15414_15432[(1)] = (4));

} else {
var statearr_15415_15433 = state_15405__$1;
(statearr_15415_15433[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (11))){
var inst_15375 = (state_15405[(10)]);
var inst_15394 = (state_15405[(2)]);
var tmp15413 = inst_15375;
var inst_15375__$1 = tmp15413;
var state_15405__$1 = (function (){var statearr_15416 = state_15405;
(statearr_15416[(11)] = inst_15394);

(statearr_15416[(10)] = inst_15375__$1);

return statearr_15416;
})();
var statearr_15417_15434 = state_15405__$1;
(statearr_15417_15434[(2)] = null);

(statearr_15417_15434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (9))){
var inst_15385 = (state_15405[(7)]);
var state_15405__$1 = state_15405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15405__$1,(11),out,inst_15385);
} else {
if((state_val_15406 === (5))){
var inst_15399 = cljs.core.async.close_BANG_.call(null,out);
var state_15405__$1 = state_15405;
var statearr_15418_15435 = state_15405__$1;
(statearr_15418_15435[(2)] = inst_15399);

(statearr_15418_15435[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (10))){
var inst_15397 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
var statearr_15419_15436 = state_15405__$1;
(statearr_15419_15436[(2)] = inst_15397);

(statearr_15419_15436[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (8))){
var inst_15386 = (state_15405[(9)]);
var inst_15375 = (state_15405[(10)]);
var inst_15385 = (state_15405[(7)]);
var inst_15384 = (state_15405[(8)]);
var inst_15389 = (function (){var cs = inst_15375;
var vec__15380 = inst_15384;
var v = inst_15385;
var c = inst_15386;
return ((function (cs,vec__15380,v,c,inst_15386,inst_15375,inst_15385,inst_15384,state_val_15406,c__11864__auto___15427,out){
return (function (p1__15371_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__15371_SHARP_);
});
;})(cs,vec__15380,v,c,inst_15386,inst_15375,inst_15385,inst_15384,state_val_15406,c__11864__auto___15427,out))
})();
var inst_15390 = cljs.core.filterv.call(null,inst_15389,inst_15375);
var inst_15375__$1 = inst_15390;
var state_15405__$1 = (function (){var statearr_15420 = state_15405;
(statearr_15420[(10)] = inst_15375__$1);

return statearr_15420;
})();
var statearr_15421_15437 = state_15405__$1;
(statearr_15421_15437[(2)] = null);

(statearr_15421_15437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15427,out))
;
return ((function (switch__11820__auto__,c__11864__auto___15427,out){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_15422 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15422[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_15422[(1)] = (1));

return statearr_15422;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_15405){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15423){if((e15423 instanceof Object)){
var ex__11824__auto__ = e15423;
var statearr_15424_15438 = state_15405;
(statearr_15424_15438[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15439 = state_15405;
state_15405 = G__15439;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_15405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_15405);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15427,out))
})();
var state__11866__auto__ = (function (){var statearr_15425 = f__11865__auto__.call(null);
(statearr_15425[(6)] = c__11864__auto___15427);

return statearr_15425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15427,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__15441 = arguments.length;
switch (G__15441) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11864__auto___15486 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15486,out){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15486,out){
return (function (state_15465){
var state_val_15466 = (state_15465[(1)]);
if((state_val_15466 === (7))){
var inst_15447 = (state_15465[(7)]);
var inst_15447__$1 = (state_15465[(2)]);
var inst_15448 = (inst_15447__$1 == null);
var inst_15449 = cljs.core.not.call(null,inst_15448);
var state_15465__$1 = (function (){var statearr_15467 = state_15465;
(statearr_15467[(7)] = inst_15447__$1);

return statearr_15467;
})();
if(inst_15449){
var statearr_15468_15487 = state_15465__$1;
(statearr_15468_15487[(1)] = (8));

} else {
var statearr_15469_15488 = state_15465__$1;
(statearr_15469_15488[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15466 === (1))){
var inst_15442 = (0);
var state_15465__$1 = (function (){var statearr_15470 = state_15465;
(statearr_15470[(8)] = inst_15442);

return statearr_15470;
})();
var statearr_15471_15489 = state_15465__$1;
(statearr_15471_15489[(2)] = null);

(statearr_15471_15489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15466 === (4))){
var state_15465__$1 = state_15465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15465__$1,(7),ch);
} else {
if((state_val_15466 === (6))){
var inst_15460 = (state_15465[(2)]);
var state_15465__$1 = state_15465;
var statearr_15472_15490 = state_15465__$1;
(statearr_15472_15490[(2)] = inst_15460);

(statearr_15472_15490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15466 === (3))){
var inst_15462 = (state_15465[(2)]);
var inst_15463 = cljs.core.async.close_BANG_.call(null,out);
var state_15465__$1 = (function (){var statearr_15473 = state_15465;
(statearr_15473[(9)] = inst_15462);

return statearr_15473;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15465__$1,inst_15463);
} else {
if((state_val_15466 === (2))){
var inst_15442 = (state_15465[(8)]);
var inst_15444 = (inst_15442 < n);
var state_15465__$1 = state_15465;
if(cljs.core.truth_(inst_15444)){
var statearr_15474_15491 = state_15465__$1;
(statearr_15474_15491[(1)] = (4));

} else {
var statearr_15475_15492 = state_15465__$1;
(statearr_15475_15492[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15466 === (11))){
var inst_15442 = (state_15465[(8)]);
var inst_15452 = (state_15465[(2)]);
var inst_15453 = (inst_15442 + (1));
var inst_15442__$1 = inst_15453;
var state_15465__$1 = (function (){var statearr_15476 = state_15465;
(statearr_15476[(8)] = inst_15442__$1);

(statearr_15476[(10)] = inst_15452);

return statearr_15476;
})();
var statearr_15477_15493 = state_15465__$1;
(statearr_15477_15493[(2)] = null);

(statearr_15477_15493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15466 === (9))){
var state_15465__$1 = state_15465;
var statearr_15478_15494 = state_15465__$1;
(statearr_15478_15494[(2)] = null);

(statearr_15478_15494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15466 === (5))){
var state_15465__$1 = state_15465;
var statearr_15479_15495 = state_15465__$1;
(statearr_15479_15495[(2)] = null);

(statearr_15479_15495[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15466 === (10))){
var inst_15457 = (state_15465[(2)]);
var state_15465__$1 = state_15465;
var statearr_15480_15496 = state_15465__$1;
(statearr_15480_15496[(2)] = inst_15457);

(statearr_15480_15496[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15466 === (8))){
var inst_15447 = (state_15465[(7)]);
var state_15465__$1 = state_15465;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15465__$1,(11),out,inst_15447);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15486,out))
;
return ((function (switch__11820__auto__,c__11864__auto___15486,out){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_15481 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15481[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_15481[(1)] = (1));

return statearr_15481;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_15465){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15482){if((e15482 instanceof Object)){
var ex__11824__auto__ = e15482;
var statearr_15483_15497 = state_15465;
(statearr_15483_15497[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15465);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15482;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15498 = state_15465;
state_15465 = G__15498;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_15465){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_15465);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15486,out))
})();
var state__11866__auto__ = (function (){var statearr_15484 = f__11865__auto__.call(null);
(statearr_15484[(6)] = c__11864__auto___15486);

return statearr_15484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15486,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15500 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15500 = (function (f,ch,meta15501){
this.f = f;
this.ch = ch;
this.meta15501 = meta15501;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15502,meta15501__$1){
var self__ = this;
var _15502__$1 = this;
return (new cljs.core.async.t_cljs$core$async15500(self__.f,self__.ch,meta15501__$1));
});

cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15502){
var self__ = this;
var _15502__$1 = this;
return self__.meta15501;
});

cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async15503 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15503 = (function (f,ch,meta15501,_,fn1,meta15504){
this.f = f;
this.ch = ch;
this.meta15501 = meta15501;
this._ = _;
this.fn1 = fn1;
this.meta15504 = meta15504;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async15503.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_15505,meta15504__$1){
var self__ = this;
var _15505__$1 = this;
return (new cljs.core.async.t_cljs$core$async15503(self__.f,self__.ch,self__.meta15501,self__._,self__.fn1,meta15504__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async15503.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_15505){
var self__ = this;
var _15505__$1 = this;
return self__.meta15504;
});})(___$1))
;

cljs.core.async.t_cljs$core$async15503.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15503.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15503.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async15503.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__15499_SHARP_){
return f1.call(null,(((p1__15499_SHARP_ == null))?null:self__.f.call(null,p1__15499_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async15503.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15501","meta15501",212671950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async15500","cljs.core.async/t_cljs$core$async15500",730159466,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta15504","meta15504",-1029264029,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15503.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15503.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15503";

cljs.core.async.t_cljs$core$async15503.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async15503");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async15503 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15503(f__$1,ch__$1,meta15501__$1,___$2,fn1__$1,meta15504){
return (new cljs.core.async.t_cljs$core$async15503(f__$1,ch__$1,meta15501__$1,___$2,fn1__$1,meta15504));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async15503(self__.f,self__.ch,self__.meta15501,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8189__auto__ = ret;
if(cljs.core.truth_(and__8189__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__8189__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15500.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async15500.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15501","meta15501",212671950,null)], null);
});

cljs.core.async.t_cljs$core$async15500.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15500.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15500";

cljs.core.async.t_cljs$core$async15500.cljs$lang$ctorPrWriter = (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async15500");
});

cljs.core.async.__GT_t_cljs$core$async15500 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15500(f__$1,ch__$1,meta15501){
return (new cljs.core.async.t_cljs$core$async15500(f__$1,ch__$1,meta15501));
});

}

return (new cljs.core.async.t_cljs$core$async15500(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15506 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15506 = (function (f,ch,meta15507){
this.f = f;
this.ch = ch;
this.meta15507 = meta15507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async15506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15508,meta15507__$1){
var self__ = this;
var _15508__$1 = this;
return (new cljs.core.async.t_cljs$core$async15506(self__.f,self__.ch,meta15507__$1));
});

cljs.core.async.t_cljs$core$async15506.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15508){
var self__ = this;
var _15508__$1 = this;
return self__.meta15507;
});

cljs.core.async.t_cljs$core$async15506.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15506.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15506.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15506.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15506.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15506.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async15506.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15507","meta15507",-141147750,null)], null);
});

cljs.core.async.t_cljs$core$async15506.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15506.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15506";

cljs.core.async.t_cljs$core$async15506.cljs$lang$ctorPrWriter = (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async15506");
});

cljs.core.async.__GT_t_cljs$core$async15506 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async15506(f__$1,ch__$1,meta15507){
return (new cljs.core.async.t_cljs$core$async15506(f__$1,ch__$1,meta15507));
});

}

return (new cljs.core.async.t_cljs$core$async15506(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async15509 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15509 = (function (p,ch,meta15510){
this.p = p;
this.ch = ch;
this.meta15510 = meta15510;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15511,meta15510__$1){
var self__ = this;
var _15511__$1 = this;
return (new cljs.core.async.t_cljs$core$async15509(self__.p,self__.ch,meta15510__$1));
});

cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15511){
var self__ = this;
var _15511__$1 = this;
return self__.meta15510;
});

cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15509.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async15509.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15510","meta15510",116160749,null)], null);
});

cljs.core.async.t_cljs$core$async15509.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15509.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15509";

cljs.core.async.t_cljs$core$async15509.cljs$lang$ctorPrWriter = (function (this__8826__auto__,writer__8827__auto__,opt__8828__auto__){
return cljs.core._write.call(null,writer__8827__auto__,"cljs.core.async/t_cljs$core$async15509");
});

cljs.core.async.__GT_t_cljs$core$async15509 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async15509(p__$1,ch__$1,meta15510){
return (new cljs.core.async.t_cljs$core$async15509(p__$1,ch__$1,meta15510));
});

}

return (new cljs.core.async.t_cljs$core$async15509(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__15513 = arguments.length;
switch (G__15513) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11864__auto___15553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15553,out){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15553,out){
return (function (state_15534){
var state_val_15535 = (state_15534[(1)]);
if((state_val_15535 === (7))){
var inst_15530 = (state_15534[(2)]);
var state_15534__$1 = state_15534;
var statearr_15536_15554 = state_15534__$1;
(statearr_15536_15554[(2)] = inst_15530);

(statearr_15536_15554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15535 === (1))){
var state_15534__$1 = state_15534;
var statearr_15537_15555 = state_15534__$1;
(statearr_15537_15555[(2)] = null);

(statearr_15537_15555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15535 === (4))){
var inst_15516 = (state_15534[(7)]);
var inst_15516__$1 = (state_15534[(2)]);
var inst_15517 = (inst_15516__$1 == null);
var state_15534__$1 = (function (){var statearr_15538 = state_15534;
(statearr_15538[(7)] = inst_15516__$1);

return statearr_15538;
})();
if(cljs.core.truth_(inst_15517)){
var statearr_15539_15556 = state_15534__$1;
(statearr_15539_15556[(1)] = (5));

} else {
var statearr_15540_15557 = state_15534__$1;
(statearr_15540_15557[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15535 === (6))){
var inst_15516 = (state_15534[(7)]);
var inst_15521 = p.call(null,inst_15516);
var state_15534__$1 = state_15534;
if(cljs.core.truth_(inst_15521)){
var statearr_15541_15558 = state_15534__$1;
(statearr_15541_15558[(1)] = (8));

} else {
var statearr_15542_15559 = state_15534__$1;
(statearr_15542_15559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15535 === (3))){
var inst_15532 = (state_15534[(2)]);
var state_15534__$1 = state_15534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15534__$1,inst_15532);
} else {
if((state_val_15535 === (2))){
var state_15534__$1 = state_15534;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15534__$1,(4),ch);
} else {
if((state_val_15535 === (11))){
var inst_15524 = (state_15534[(2)]);
var state_15534__$1 = state_15534;
var statearr_15543_15560 = state_15534__$1;
(statearr_15543_15560[(2)] = inst_15524);

(statearr_15543_15560[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15535 === (9))){
var state_15534__$1 = state_15534;
var statearr_15544_15561 = state_15534__$1;
(statearr_15544_15561[(2)] = null);

(statearr_15544_15561[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15535 === (5))){
var inst_15519 = cljs.core.async.close_BANG_.call(null,out);
var state_15534__$1 = state_15534;
var statearr_15545_15562 = state_15534__$1;
(statearr_15545_15562[(2)] = inst_15519);

(statearr_15545_15562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15535 === (10))){
var inst_15527 = (state_15534[(2)]);
var state_15534__$1 = (function (){var statearr_15546 = state_15534;
(statearr_15546[(8)] = inst_15527);

return statearr_15546;
})();
var statearr_15547_15563 = state_15534__$1;
(statearr_15547_15563[(2)] = null);

(statearr_15547_15563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15535 === (8))){
var inst_15516 = (state_15534[(7)]);
var state_15534__$1 = state_15534;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15534__$1,(11),out,inst_15516);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15553,out))
;
return ((function (switch__11820__auto__,c__11864__auto___15553,out){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_15548 = [null,null,null,null,null,null,null,null,null];
(statearr_15548[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_15548[(1)] = (1));

return statearr_15548;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_15534){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15549){if((e15549 instanceof Object)){
var ex__11824__auto__ = e15549;
var statearr_15550_15564 = state_15534;
(statearr_15550_15564[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15534);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15549;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15565 = state_15534;
state_15534 = G__15565;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_15534){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_15534);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15553,out))
})();
var state__11866__auto__ = (function (){var statearr_15551 = f__11865__auto__.call(null);
(statearr_15551[(6)] = c__11864__auto___15553);

return statearr_15551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15553,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__15567 = arguments.length;
switch (G__15567) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11864__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto__){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto__){
return (function (state_15630){
var state_val_15631 = (state_15630[(1)]);
if((state_val_15631 === (7))){
var inst_15626 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
var statearr_15632_15670 = state_15630__$1;
(statearr_15632_15670[(2)] = inst_15626);

(statearr_15632_15670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (20))){
var inst_15596 = (state_15630[(7)]);
var inst_15607 = (state_15630[(2)]);
var inst_15608 = cljs.core.next.call(null,inst_15596);
var inst_15582 = inst_15608;
var inst_15583 = null;
var inst_15584 = (0);
var inst_15585 = (0);
var state_15630__$1 = (function (){var statearr_15633 = state_15630;
(statearr_15633[(8)] = inst_15585);

(statearr_15633[(9)] = inst_15584);

(statearr_15633[(10)] = inst_15607);

(statearr_15633[(11)] = inst_15583);

(statearr_15633[(12)] = inst_15582);

return statearr_15633;
})();
var statearr_15634_15671 = state_15630__$1;
(statearr_15634_15671[(2)] = null);

(statearr_15634_15671[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (1))){
var state_15630__$1 = state_15630;
var statearr_15635_15672 = state_15630__$1;
(statearr_15635_15672[(2)] = null);

(statearr_15635_15672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (4))){
var inst_15571 = (state_15630[(13)]);
var inst_15571__$1 = (state_15630[(2)]);
var inst_15572 = (inst_15571__$1 == null);
var state_15630__$1 = (function (){var statearr_15636 = state_15630;
(statearr_15636[(13)] = inst_15571__$1);

return statearr_15636;
})();
if(cljs.core.truth_(inst_15572)){
var statearr_15637_15673 = state_15630__$1;
(statearr_15637_15673[(1)] = (5));

} else {
var statearr_15638_15674 = state_15630__$1;
(statearr_15638_15674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (15))){
var state_15630__$1 = state_15630;
var statearr_15642_15675 = state_15630__$1;
(statearr_15642_15675[(2)] = null);

(statearr_15642_15675[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (21))){
var state_15630__$1 = state_15630;
var statearr_15643_15676 = state_15630__$1;
(statearr_15643_15676[(2)] = null);

(statearr_15643_15676[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (13))){
var inst_15585 = (state_15630[(8)]);
var inst_15584 = (state_15630[(9)]);
var inst_15583 = (state_15630[(11)]);
var inst_15582 = (state_15630[(12)]);
var inst_15592 = (state_15630[(2)]);
var inst_15593 = (inst_15585 + (1));
var tmp15639 = inst_15584;
var tmp15640 = inst_15583;
var tmp15641 = inst_15582;
var inst_15582__$1 = tmp15641;
var inst_15583__$1 = tmp15640;
var inst_15584__$1 = tmp15639;
var inst_15585__$1 = inst_15593;
var state_15630__$1 = (function (){var statearr_15644 = state_15630;
(statearr_15644[(8)] = inst_15585__$1);

(statearr_15644[(9)] = inst_15584__$1);

(statearr_15644[(11)] = inst_15583__$1);

(statearr_15644[(14)] = inst_15592);

(statearr_15644[(12)] = inst_15582__$1);

return statearr_15644;
})();
var statearr_15645_15677 = state_15630__$1;
(statearr_15645_15677[(2)] = null);

(statearr_15645_15677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (22))){
var state_15630__$1 = state_15630;
var statearr_15646_15678 = state_15630__$1;
(statearr_15646_15678[(2)] = null);

(statearr_15646_15678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (6))){
var inst_15571 = (state_15630[(13)]);
var inst_15580 = f.call(null,inst_15571);
var inst_15581 = cljs.core.seq.call(null,inst_15580);
var inst_15582 = inst_15581;
var inst_15583 = null;
var inst_15584 = (0);
var inst_15585 = (0);
var state_15630__$1 = (function (){var statearr_15647 = state_15630;
(statearr_15647[(8)] = inst_15585);

(statearr_15647[(9)] = inst_15584);

(statearr_15647[(11)] = inst_15583);

(statearr_15647[(12)] = inst_15582);

return statearr_15647;
})();
var statearr_15648_15679 = state_15630__$1;
(statearr_15648_15679[(2)] = null);

(statearr_15648_15679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (17))){
var inst_15596 = (state_15630[(7)]);
var inst_15600 = cljs.core.chunk_first.call(null,inst_15596);
var inst_15601 = cljs.core.chunk_rest.call(null,inst_15596);
var inst_15602 = cljs.core.count.call(null,inst_15600);
var inst_15582 = inst_15601;
var inst_15583 = inst_15600;
var inst_15584 = inst_15602;
var inst_15585 = (0);
var state_15630__$1 = (function (){var statearr_15649 = state_15630;
(statearr_15649[(8)] = inst_15585);

(statearr_15649[(9)] = inst_15584);

(statearr_15649[(11)] = inst_15583);

(statearr_15649[(12)] = inst_15582);

return statearr_15649;
})();
var statearr_15650_15680 = state_15630__$1;
(statearr_15650_15680[(2)] = null);

(statearr_15650_15680[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (3))){
var inst_15628 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15630__$1,inst_15628);
} else {
if((state_val_15631 === (12))){
var inst_15616 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
var statearr_15651_15681 = state_15630__$1;
(statearr_15651_15681[(2)] = inst_15616);

(statearr_15651_15681[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (2))){
var state_15630__$1 = state_15630;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15630__$1,(4),in$);
} else {
if((state_val_15631 === (23))){
var inst_15624 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
var statearr_15652_15682 = state_15630__$1;
(statearr_15652_15682[(2)] = inst_15624);

(statearr_15652_15682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (19))){
var inst_15611 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
var statearr_15653_15683 = state_15630__$1;
(statearr_15653_15683[(2)] = inst_15611);

(statearr_15653_15683[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (11))){
var inst_15596 = (state_15630[(7)]);
var inst_15582 = (state_15630[(12)]);
var inst_15596__$1 = cljs.core.seq.call(null,inst_15582);
var state_15630__$1 = (function (){var statearr_15654 = state_15630;
(statearr_15654[(7)] = inst_15596__$1);

return statearr_15654;
})();
if(inst_15596__$1){
var statearr_15655_15684 = state_15630__$1;
(statearr_15655_15684[(1)] = (14));

} else {
var statearr_15656_15685 = state_15630__$1;
(statearr_15656_15685[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (9))){
var inst_15618 = (state_15630[(2)]);
var inst_15619 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_15630__$1 = (function (){var statearr_15657 = state_15630;
(statearr_15657[(15)] = inst_15618);

return statearr_15657;
})();
if(cljs.core.truth_(inst_15619)){
var statearr_15658_15686 = state_15630__$1;
(statearr_15658_15686[(1)] = (21));

} else {
var statearr_15659_15687 = state_15630__$1;
(statearr_15659_15687[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (5))){
var inst_15574 = cljs.core.async.close_BANG_.call(null,out);
var state_15630__$1 = state_15630;
var statearr_15660_15688 = state_15630__$1;
(statearr_15660_15688[(2)] = inst_15574);

(statearr_15660_15688[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (14))){
var inst_15596 = (state_15630[(7)]);
var inst_15598 = cljs.core.chunked_seq_QMARK_.call(null,inst_15596);
var state_15630__$1 = state_15630;
if(inst_15598){
var statearr_15661_15689 = state_15630__$1;
(statearr_15661_15689[(1)] = (17));

} else {
var statearr_15662_15690 = state_15630__$1;
(statearr_15662_15690[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (16))){
var inst_15614 = (state_15630[(2)]);
var state_15630__$1 = state_15630;
var statearr_15663_15691 = state_15630__$1;
(statearr_15663_15691[(2)] = inst_15614);

(statearr_15663_15691[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15631 === (10))){
var inst_15585 = (state_15630[(8)]);
var inst_15583 = (state_15630[(11)]);
var inst_15590 = cljs.core._nth.call(null,inst_15583,inst_15585);
var state_15630__$1 = state_15630;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15630__$1,(13),out,inst_15590);
} else {
if((state_val_15631 === (18))){
var inst_15596 = (state_15630[(7)]);
var inst_15605 = cljs.core.first.call(null,inst_15596);
var state_15630__$1 = state_15630;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15630__$1,(20),out,inst_15605);
} else {
if((state_val_15631 === (8))){
var inst_15585 = (state_15630[(8)]);
var inst_15584 = (state_15630[(9)]);
var inst_15587 = (inst_15585 < inst_15584);
var inst_15588 = inst_15587;
var state_15630__$1 = state_15630;
if(cljs.core.truth_(inst_15588)){
var statearr_15664_15692 = state_15630__$1;
(statearr_15664_15692[(1)] = (10));

} else {
var statearr_15665_15693 = state_15630__$1;
(statearr_15665_15693[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto__))
;
return ((function (switch__11820__auto__,c__11864__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11821__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11821__auto____0 = (function (){
var statearr_15666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15666[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11821__auto__);

(statearr_15666[(1)] = (1));

return statearr_15666;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11821__auto____1 = (function (state_15630){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15630);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15667){if((e15667 instanceof Object)){
var ex__11824__auto__ = e15667;
var statearr_15668_15694 = state_15630;
(statearr_15668_15694[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15630);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15667;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15695 = state_15630;
state_15630 = G__15695;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11821__auto__ = function(state_15630){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11821__auto____1.call(this,state_15630);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11821__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11821__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto__))
})();
var state__11866__auto__ = (function (){var statearr_15669 = f__11865__auto__.call(null);
(statearr_15669[(6)] = c__11864__auto__);

return statearr_15669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto__))
);

return c__11864__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__15697 = arguments.length;
switch (G__15697) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__15700 = arguments.length;
switch (G__15700) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__15703 = arguments.length;
switch (G__15703) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11864__auto___15750 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15750,out){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15750,out){
return (function (state_15727){
var state_val_15728 = (state_15727[(1)]);
if((state_val_15728 === (7))){
var inst_15722 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15729_15751 = state_15727__$1;
(statearr_15729_15751[(2)] = inst_15722);

(statearr_15729_15751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (1))){
var inst_15704 = null;
var state_15727__$1 = (function (){var statearr_15730 = state_15727;
(statearr_15730[(7)] = inst_15704);

return statearr_15730;
})();
var statearr_15731_15752 = state_15727__$1;
(statearr_15731_15752[(2)] = null);

(statearr_15731_15752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (4))){
var inst_15707 = (state_15727[(8)]);
var inst_15707__$1 = (state_15727[(2)]);
var inst_15708 = (inst_15707__$1 == null);
var inst_15709 = cljs.core.not.call(null,inst_15708);
var state_15727__$1 = (function (){var statearr_15732 = state_15727;
(statearr_15732[(8)] = inst_15707__$1);

return statearr_15732;
})();
if(inst_15709){
var statearr_15733_15753 = state_15727__$1;
(statearr_15733_15753[(1)] = (5));

} else {
var statearr_15734_15754 = state_15727__$1;
(statearr_15734_15754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (6))){
var state_15727__$1 = state_15727;
var statearr_15735_15755 = state_15727__$1;
(statearr_15735_15755[(2)] = null);

(statearr_15735_15755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (3))){
var inst_15724 = (state_15727[(2)]);
var inst_15725 = cljs.core.async.close_BANG_.call(null,out);
var state_15727__$1 = (function (){var statearr_15736 = state_15727;
(statearr_15736[(9)] = inst_15724);

return statearr_15736;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15727__$1,inst_15725);
} else {
if((state_val_15728 === (2))){
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15727__$1,(4),ch);
} else {
if((state_val_15728 === (11))){
var inst_15707 = (state_15727[(8)]);
var inst_15716 = (state_15727[(2)]);
var inst_15704 = inst_15707;
var state_15727__$1 = (function (){var statearr_15737 = state_15727;
(statearr_15737[(10)] = inst_15716);

(statearr_15737[(7)] = inst_15704);

return statearr_15737;
})();
var statearr_15738_15756 = state_15727__$1;
(statearr_15738_15756[(2)] = null);

(statearr_15738_15756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (9))){
var inst_15707 = (state_15727[(8)]);
var state_15727__$1 = state_15727;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15727__$1,(11),out,inst_15707);
} else {
if((state_val_15728 === (5))){
var inst_15707 = (state_15727[(8)]);
var inst_15704 = (state_15727[(7)]);
var inst_15711 = cljs.core._EQ_.call(null,inst_15707,inst_15704);
var state_15727__$1 = state_15727;
if(inst_15711){
var statearr_15740_15757 = state_15727__$1;
(statearr_15740_15757[(1)] = (8));

} else {
var statearr_15741_15758 = state_15727__$1;
(statearr_15741_15758[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (10))){
var inst_15719 = (state_15727[(2)]);
var state_15727__$1 = state_15727;
var statearr_15742_15759 = state_15727__$1;
(statearr_15742_15759[(2)] = inst_15719);

(statearr_15742_15759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15728 === (8))){
var inst_15704 = (state_15727[(7)]);
var tmp15739 = inst_15704;
var inst_15704__$1 = tmp15739;
var state_15727__$1 = (function (){var statearr_15743 = state_15727;
(statearr_15743[(7)] = inst_15704__$1);

return statearr_15743;
})();
var statearr_15744_15760 = state_15727__$1;
(statearr_15744_15760[(2)] = null);

(statearr_15744_15760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15750,out))
;
return ((function (switch__11820__auto__,c__11864__auto___15750,out){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_15745 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15745[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_15745[(1)] = (1));

return statearr_15745;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_15727){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15727);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15746){if((e15746 instanceof Object)){
var ex__11824__auto__ = e15746;
var statearr_15747_15761 = state_15727;
(statearr_15747_15761[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15727);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15746;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15762 = state_15727;
state_15727 = G__15762;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_15727){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_15727);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15750,out))
})();
var state__11866__auto__ = (function (){var statearr_15748 = f__11865__auto__.call(null);
(statearr_15748[(6)] = c__11864__auto___15750);

return statearr_15748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15750,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__15764 = arguments.length;
switch (G__15764) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11864__auto___15830 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15830,out){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15830,out){
return (function (state_15802){
var state_val_15803 = (state_15802[(1)]);
if((state_val_15803 === (7))){
var inst_15798 = (state_15802[(2)]);
var state_15802__$1 = state_15802;
var statearr_15804_15831 = state_15802__$1;
(statearr_15804_15831[(2)] = inst_15798);

(statearr_15804_15831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (1))){
var inst_15765 = (new Array(n));
var inst_15766 = inst_15765;
var inst_15767 = (0);
var state_15802__$1 = (function (){var statearr_15805 = state_15802;
(statearr_15805[(7)] = inst_15766);

(statearr_15805[(8)] = inst_15767);

return statearr_15805;
})();
var statearr_15806_15832 = state_15802__$1;
(statearr_15806_15832[(2)] = null);

(statearr_15806_15832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (4))){
var inst_15770 = (state_15802[(9)]);
var inst_15770__$1 = (state_15802[(2)]);
var inst_15771 = (inst_15770__$1 == null);
var inst_15772 = cljs.core.not.call(null,inst_15771);
var state_15802__$1 = (function (){var statearr_15807 = state_15802;
(statearr_15807[(9)] = inst_15770__$1);

return statearr_15807;
})();
if(inst_15772){
var statearr_15808_15833 = state_15802__$1;
(statearr_15808_15833[(1)] = (5));

} else {
var statearr_15809_15834 = state_15802__$1;
(statearr_15809_15834[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (15))){
var inst_15792 = (state_15802[(2)]);
var state_15802__$1 = state_15802;
var statearr_15810_15835 = state_15802__$1;
(statearr_15810_15835[(2)] = inst_15792);

(statearr_15810_15835[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (13))){
var state_15802__$1 = state_15802;
var statearr_15811_15836 = state_15802__$1;
(statearr_15811_15836[(2)] = null);

(statearr_15811_15836[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (6))){
var inst_15767 = (state_15802[(8)]);
var inst_15788 = (inst_15767 > (0));
var state_15802__$1 = state_15802;
if(cljs.core.truth_(inst_15788)){
var statearr_15812_15837 = state_15802__$1;
(statearr_15812_15837[(1)] = (12));

} else {
var statearr_15813_15838 = state_15802__$1;
(statearr_15813_15838[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (3))){
var inst_15800 = (state_15802[(2)]);
var state_15802__$1 = state_15802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15802__$1,inst_15800);
} else {
if((state_val_15803 === (12))){
var inst_15766 = (state_15802[(7)]);
var inst_15790 = cljs.core.vec.call(null,inst_15766);
var state_15802__$1 = state_15802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15802__$1,(15),out,inst_15790);
} else {
if((state_val_15803 === (2))){
var state_15802__$1 = state_15802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15802__$1,(4),ch);
} else {
if((state_val_15803 === (11))){
var inst_15782 = (state_15802[(2)]);
var inst_15783 = (new Array(n));
var inst_15766 = inst_15783;
var inst_15767 = (0);
var state_15802__$1 = (function (){var statearr_15814 = state_15802;
(statearr_15814[(10)] = inst_15782);

(statearr_15814[(7)] = inst_15766);

(statearr_15814[(8)] = inst_15767);

return statearr_15814;
})();
var statearr_15815_15839 = state_15802__$1;
(statearr_15815_15839[(2)] = null);

(statearr_15815_15839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (9))){
var inst_15766 = (state_15802[(7)]);
var inst_15780 = cljs.core.vec.call(null,inst_15766);
var state_15802__$1 = state_15802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15802__$1,(11),out,inst_15780);
} else {
if((state_val_15803 === (5))){
var inst_15766 = (state_15802[(7)]);
var inst_15767 = (state_15802[(8)]);
var inst_15775 = (state_15802[(11)]);
var inst_15770 = (state_15802[(9)]);
var inst_15774 = (inst_15766[inst_15767] = inst_15770);
var inst_15775__$1 = (inst_15767 + (1));
var inst_15776 = (inst_15775__$1 < n);
var state_15802__$1 = (function (){var statearr_15816 = state_15802;
(statearr_15816[(12)] = inst_15774);

(statearr_15816[(11)] = inst_15775__$1);

return statearr_15816;
})();
if(cljs.core.truth_(inst_15776)){
var statearr_15817_15840 = state_15802__$1;
(statearr_15817_15840[(1)] = (8));

} else {
var statearr_15818_15841 = state_15802__$1;
(statearr_15818_15841[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (14))){
var inst_15795 = (state_15802[(2)]);
var inst_15796 = cljs.core.async.close_BANG_.call(null,out);
var state_15802__$1 = (function (){var statearr_15820 = state_15802;
(statearr_15820[(13)] = inst_15795);

return statearr_15820;
})();
var statearr_15821_15842 = state_15802__$1;
(statearr_15821_15842[(2)] = inst_15796);

(statearr_15821_15842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (10))){
var inst_15786 = (state_15802[(2)]);
var state_15802__$1 = state_15802;
var statearr_15822_15843 = state_15802__$1;
(statearr_15822_15843[(2)] = inst_15786);

(statearr_15822_15843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15803 === (8))){
var inst_15766 = (state_15802[(7)]);
var inst_15775 = (state_15802[(11)]);
var tmp15819 = inst_15766;
var inst_15766__$1 = tmp15819;
var inst_15767 = inst_15775;
var state_15802__$1 = (function (){var statearr_15823 = state_15802;
(statearr_15823[(7)] = inst_15766__$1);

(statearr_15823[(8)] = inst_15767);

return statearr_15823;
})();
var statearr_15824_15844 = state_15802__$1;
(statearr_15824_15844[(2)] = null);

(statearr_15824_15844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15830,out))
;
return ((function (switch__11820__auto__,c__11864__auto___15830,out){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_15825 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15825[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_15825[(1)] = (1));

return statearr_15825;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_15802){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15826){if((e15826 instanceof Object)){
var ex__11824__auto__ = e15826;
var statearr_15827_15845 = state_15802;
(statearr_15827_15845[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15826;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15846 = state_15802;
state_15802 = G__15846;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_15802){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_15802);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15830,out))
})();
var state__11866__auto__ = (function (){var statearr_15828 = f__11865__auto__.call(null);
(statearr_15828[(6)] = c__11864__auto___15830);

return statearr_15828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15830,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__15848 = arguments.length;
switch (G__15848) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11864__auto___15918 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11864__auto___15918,out){
return (function (){
var f__11865__auto__ = (function (){var switch__11820__auto__ = ((function (c__11864__auto___15918,out){
return (function (state_15890){
var state_val_15891 = (state_15890[(1)]);
if((state_val_15891 === (7))){
var inst_15886 = (state_15890[(2)]);
var state_15890__$1 = state_15890;
var statearr_15892_15919 = state_15890__$1;
(statearr_15892_15919[(2)] = inst_15886);

(statearr_15892_15919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (1))){
var inst_15849 = [];
var inst_15850 = inst_15849;
var inst_15851 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_15890__$1 = (function (){var statearr_15893 = state_15890;
(statearr_15893[(7)] = inst_15851);

(statearr_15893[(8)] = inst_15850);

return statearr_15893;
})();
var statearr_15894_15920 = state_15890__$1;
(statearr_15894_15920[(2)] = null);

(statearr_15894_15920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (4))){
var inst_15854 = (state_15890[(9)]);
var inst_15854__$1 = (state_15890[(2)]);
var inst_15855 = (inst_15854__$1 == null);
var inst_15856 = cljs.core.not.call(null,inst_15855);
var state_15890__$1 = (function (){var statearr_15895 = state_15890;
(statearr_15895[(9)] = inst_15854__$1);

return statearr_15895;
})();
if(inst_15856){
var statearr_15896_15921 = state_15890__$1;
(statearr_15896_15921[(1)] = (5));

} else {
var statearr_15897_15922 = state_15890__$1;
(statearr_15897_15922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (15))){
var inst_15880 = (state_15890[(2)]);
var state_15890__$1 = state_15890;
var statearr_15898_15923 = state_15890__$1;
(statearr_15898_15923[(2)] = inst_15880);

(statearr_15898_15923[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (13))){
var state_15890__$1 = state_15890;
var statearr_15899_15924 = state_15890__$1;
(statearr_15899_15924[(2)] = null);

(statearr_15899_15924[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (6))){
var inst_15850 = (state_15890[(8)]);
var inst_15875 = inst_15850.length;
var inst_15876 = (inst_15875 > (0));
var state_15890__$1 = state_15890;
if(cljs.core.truth_(inst_15876)){
var statearr_15900_15925 = state_15890__$1;
(statearr_15900_15925[(1)] = (12));

} else {
var statearr_15901_15926 = state_15890__$1;
(statearr_15901_15926[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (3))){
var inst_15888 = (state_15890[(2)]);
var state_15890__$1 = state_15890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15890__$1,inst_15888);
} else {
if((state_val_15891 === (12))){
var inst_15850 = (state_15890[(8)]);
var inst_15878 = cljs.core.vec.call(null,inst_15850);
var state_15890__$1 = state_15890;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15890__$1,(15),out,inst_15878);
} else {
if((state_val_15891 === (2))){
var state_15890__$1 = state_15890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15890__$1,(4),ch);
} else {
if((state_val_15891 === (11))){
var inst_15858 = (state_15890[(10)]);
var inst_15854 = (state_15890[(9)]);
var inst_15868 = (state_15890[(2)]);
var inst_15869 = [];
var inst_15870 = inst_15869.push(inst_15854);
var inst_15850 = inst_15869;
var inst_15851 = inst_15858;
var state_15890__$1 = (function (){var statearr_15902 = state_15890;
(statearr_15902[(7)] = inst_15851);

(statearr_15902[(8)] = inst_15850);

(statearr_15902[(11)] = inst_15870);

(statearr_15902[(12)] = inst_15868);

return statearr_15902;
})();
var statearr_15903_15927 = state_15890__$1;
(statearr_15903_15927[(2)] = null);

(statearr_15903_15927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (9))){
var inst_15850 = (state_15890[(8)]);
var inst_15866 = cljs.core.vec.call(null,inst_15850);
var state_15890__$1 = state_15890;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15890__$1,(11),out,inst_15866);
} else {
if((state_val_15891 === (5))){
var inst_15858 = (state_15890[(10)]);
var inst_15851 = (state_15890[(7)]);
var inst_15854 = (state_15890[(9)]);
var inst_15858__$1 = f.call(null,inst_15854);
var inst_15859 = cljs.core._EQ_.call(null,inst_15858__$1,inst_15851);
var inst_15860 = cljs.core.keyword_identical_QMARK_.call(null,inst_15851,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_15861 = (inst_15859) || (inst_15860);
var state_15890__$1 = (function (){var statearr_15904 = state_15890;
(statearr_15904[(10)] = inst_15858__$1);

return statearr_15904;
})();
if(cljs.core.truth_(inst_15861)){
var statearr_15905_15928 = state_15890__$1;
(statearr_15905_15928[(1)] = (8));

} else {
var statearr_15906_15929 = state_15890__$1;
(statearr_15906_15929[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (14))){
var inst_15883 = (state_15890[(2)]);
var inst_15884 = cljs.core.async.close_BANG_.call(null,out);
var state_15890__$1 = (function (){var statearr_15908 = state_15890;
(statearr_15908[(13)] = inst_15883);

return statearr_15908;
})();
var statearr_15909_15930 = state_15890__$1;
(statearr_15909_15930[(2)] = inst_15884);

(statearr_15909_15930[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (10))){
var inst_15873 = (state_15890[(2)]);
var state_15890__$1 = state_15890;
var statearr_15910_15931 = state_15890__$1;
(statearr_15910_15931[(2)] = inst_15873);

(statearr_15910_15931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15891 === (8))){
var inst_15858 = (state_15890[(10)]);
var inst_15850 = (state_15890[(8)]);
var inst_15854 = (state_15890[(9)]);
var inst_15863 = inst_15850.push(inst_15854);
var tmp15907 = inst_15850;
var inst_15850__$1 = tmp15907;
var inst_15851 = inst_15858;
var state_15890__$1 = (function (){var statearr_15911 = state_15890;
(statearr_15911[(7)] = inst_15851);

(statearr_15911[(14)] = inst_15863);

(statearr_15911[(8)] = inst_15850__$1);

return statearr_15911;
})();
var statearr_15912_15932 = state_15890__$1;
(statearr_15912_15932[(2)] = null);

(statearr_15912_15932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11864__auto___15918,out))
;
return ((function (switch__11820__auto__,c__11864__auto___15918,out){
return (function() {
var cljs$core$async$state_machine__11821__auto__ = null;
var cljs$core$async$state_machine__11821__auto____0 = (function (){
var statearr_15913 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15913[(0)] = cljs$core$async$state_machine__11821__auto__);

(statearr_15913[(1)] = (1));

return statearr_15913;
});
var cljs$core$async$state_machine__11821__auto____1 = (function (state_15890){
while(true){
var ret_value__11822__auto__ = (function (){try{while(true){
var result__11823__auto__ = switch__11820__auto__.call(null,state_15890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11823__auto__;
}
break;
}
}catch (e15914){if((e15914 instanceof Object)){
var ex__11824__auto__ = e15914;
var statearr_15915_15933 = state_15890;
(statearr_15915_15933[(5)] = ex__11824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15890);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15914;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15934 = state_15890;
state_15890 = G__15934;
continue;
} else {
return ret_value__11822__auto__;
}
break;
}
});
cljs$core$async$state_machine__11821__auto__ = function(state_15890){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11821__auto____1.call(this,state_15890);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11821__auto____0;
cljs$core$async$state_machine__11821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11821__auto____1;
return cljs$core$async$state_machine__11821__auto__;
})()
;})(switch__11820__auto__,c__11864__auto___15918,out))
})();
var state__11866__auto__ = (function (){var statearr_15916 = f__11865__auto__.call(null);
(statearr_15916[(6)] = c__11864__auto___15918);

return statearr_15916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11866__auto__);
});})(c__11864__auto___15918,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
