(ns cmr.client.http.core
  (:require
   [cmr.client.http.impl.util :as util]
   #?(:clj [cmr.client.http.impl.cljhttp :as http
                                         :refer [->HTTPClientData]]
      :cljs [cljs-http.client :as http]
      :cljs [cmr.client.http.impl.cljshttp :as cljshttp
                                           :refer [->HTTPClientData]]))
  #?(:clj
    (:import (cmr.client.http.impl.cljhttp HTTPClientData)))
  (:refer-clojure :exclude [get]))

(defprotocol HTTPClient
  "A common interface for both Clojure and ClojureScript HTTP clients."
  (get [this url] [this url opts])
  (head [this url] [this url opts])
  (put [this url] [this url opts])
  (post [this url] [this url opts])
  (delete [this url] [this url opts])
  (copy [this url] [this url opts])
  (move [this url] [this url opts])
  (patch [this url] [this url opts])
  (options [this url] [this url opts]))

#?(:clj
(extend HTTPClientData
        HTTPClient
        http/client-behaviour))

#?(:cljs
(extend-type cljshttp/HTTPClientData
  HTTPClient
  (get
    ([this url]
      (get this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))
  (head
    ([this url]
      (head this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))
  (put
    ([this url]
      (put this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))
  (post
    ([this url]
      (post this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))
  (delete
    ([this url]
      (delete this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))
  (copy
    ([this url]
      (copy this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))
  (move
    ([this url]
      (move this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))
  (patch
    ([this url]
      (patch this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))
  (options
    ([this url]
      (options this url (util/get-default-options this)))
    ([this url options]
      :not-implemented))))

(defn create-client
  ([]
   (create-client {}))
  ([http-options]
   (create-client {} http-options))
  ([parent-client-options http-options]
   (->HTTPClientData parent-client-options
                     http-options)))
