// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30992 = arguments.length;
switch (G__30992) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30993 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30993 = (function (f,blockable,meta30994){
this.f = f;
this.blockable = blockable;
this.meta30994 = meta30994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async30993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30995,meta30994__$1){
var self__ = this;
var _30995__$1 = this;
return (new cljs.core.async.t_cljs$core$async30993(self__.f,self__.blockable,meta30994__$1));
});

cljs.core.async.t_cljs$core$async30993.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30995){
var self__ = this;
var _30995__$1 = this;
return self__.meta30994;
});

cljs.core.async.t_cljs$core$async30993.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30993.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30993.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30993.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30993.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30994","meta30994",-1214546775,null)], null);
});

cljs.core.async.t_cljs$core$async30993.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30993.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30993";

cljs.core.async.t_cljs$core$async30993.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async30993");
});

cljs.core.async.__GT_t_cljs$core$async30993 = (function cljs$core$async$__GT_t_cljs$core$async30993(f__$1,blockable__$1,meta30994){
return (new cljs.core.async.t_cljs$core$async30993(f__$1,blockable__$1,meta30994));
});

}

return (new cljs.core.async.t_cljs$core$async30993(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30999 = arguments.length;
switch (G__30999) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31002 = arguments.length;
switch (G__31002) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31005 = arguments.length;
switch (G__31005) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_31007 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_31007);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_31007,ret){
return (function (){
return fn1.call(null,val_31007);
});})(val_31007,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31009 = arguments.length;
switch (G__31009) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29292__auto___31011 = n;
var x_31012 = (0);
while(true){
if((x_31012 < n__29292__auto___31011)){
(a[x_31012] = (0));

var G__31013 = (x_31012 + (1));
x_31012 = G__31013;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__31014 = (i + (1));
i = G__31014;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async31015 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31015 = (function (flag,meta31016){
this.flag = flag;
this.meta31016 = meta31016;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31015.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31017,meta31016__$1){
var self__ = this;
var _31017__$1 = this;
return (new cljs.core.async.t_cljs$core$async31015(self__.flag,meta31016__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31015.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31017){
var self__ = this;
var _31017__$1 = this;
return self__.meta31016;
});})(flag))
;

cljs.core.async.t_cljs$core$async31015.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31015.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async31015.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31015.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31015.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31016","meta31016",-2058839427,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31015.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31015.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31015";

cljs.core.async.t_cljs$core$async31015.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async31015");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31015 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31015(flag__$1,meta31016){
return (new cljs.core.async.t_cljs$core$async31015(flag__$1,meta31016));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31015(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31018 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31018 = (function (flag,cb,meta31019){
this.flag = flag;
this.cb = cb;
this.meta31019 = meta31019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31020,meta31019__$1){
var self__ = this;
var _31020__$1 = this;
return (new cljs.core.async.t_cljs$core$async31018(self__.flag,self__.cb,meta31019__$1));
});

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31020){
var self__ = this;
var _31020__$1 = this;
return self__.meta31019;
});

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31018.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31019","meta31019",-1541130720,null)], null);
});

cljs.core.async.t_cljs$core$async31018.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31018";

cljs.core.async.t_cljs$core$async31018.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async31018");
});

cljs.core.async.__GT_t_cljs$core$async31018 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31018(flag__$1,cb__$1,meta31019){
return (new cljs.core.async.t_cljs$core$async31018(flag__$1,cb__$1,meta31019));
});

}

return (new cljs.core.async.t_cljs$core$async31018(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31021_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31021_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31022_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31022_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28347__auto__ = wport;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31023 = (i + (1));
i = G__31023;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28347__auto__ = ret;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28335__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28335__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28335__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29523__auto__ = [];
var len__29516__auto___31029 = arguments.length;
var i__29517__auto___31030 = (0);
while(true){
if((i__29517__auto___31030 < len__29516__auto___31029)){
args__29523__auto__.push((arguments[i__29517__auto___31030]));

var G__31031 = (i__29517__auto___31030 + (1));
i__29517__auto___31030 = G__31031;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31026){
var map__31027 = p__31026;
var map__31027__$1 = ((((!((map__31027 == null)))?((((map__31027.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31027.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31027):map__31027);
var opts = map__31027__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31024){
var G__31025 = cljs.core.first.call(null,seq31024);
var seq31024__$1 = cljs.core.next.call(null,seq31024);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31025,seq31024__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31033 = arguments.length;
switch (G__31033) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30946__auto___31079 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___31079){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___31079){
return (function (state_31057){
var state_val_31058 = (state_31057[(1)]);
if((state_val_31058 === (7))){
var inst_31053 = (state_31057[(2)]);
var state_31057__$1 = state_31057;
var statearr_31059_31080 = state_31057__$1;
(statearr_31059_31080[(2)] = inst_31053);

(statearr_31059_31080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (1))){
var state_31057__$1 = state_31057;
var statearr_31060_31081 = state_31057__$1;
(statearr_31060_31081[(2)] = null);

(statearr_31060_31081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (4))){
var inst_31036 = (state_31057[(7)]);
var inst_31036__$1 = (state_31057[(2)]);
var inst_31037 = (inst_31036__$1 == null);
var state_31057__$1 = (function (){var statearr_31061 = state_31057;
(statearr_31061[(7)] = inst_31036__$1);

return statearr_31061;
})();
if(cljs.core.truth_(inst_31037)){
var statearr_31062_31082 = state_31057__$1;
(statearr_31062_31082[(1)] = (5));

} else {
var statearr_31063_31083 = state_31057__$1;
(statearr_31063_31083[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (13))){
var state_31057__$1 = state_31057;
var statearr_31064_31084 = state_31057__$1;
(statearr_31064_31084[(2)] = null);

(statearr_31064_31084[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (6))){
var inst_31036 = (state_31057[(7)]);
var state_31057__$1 = state_31057;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31057__$1,(11),to,inst_31036);
} else {
if((state_val_31058 === (3))){
var inst_31055 = (state_31057[(2)]);
var state_31057__$1 = state_31057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31057__$1,inst_31055);
} else {
if((state_val_31058 === (12))){
var state_31057__$1 = state_31057;
var statearr_31065_31085 = state_31057__$1;
(statearr_31065_31085[(2)] = null);

(statearr_31065_31085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (2))){
var state_31057__$1 = state_31057;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31057__$1,(4),from);
} else {
if((state_val_31058 === (11))){
var inst_31046 = (state_31057[(2)]);
var state_31057__$1 = state_31057;
if(cljs.core.truth_(inst_31046)){
var statearr_31066_31086 = state_31057__$1;
(statearr_31066_31086[(1)] = (12));

} else {
var statearr_31067_31087 = state_31057__$1;
(statearr_31067_31087[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (9))){
var state_31057__$1 = state_31057;
var statearr_31068_31088 = state_31057__$1;
(statearr_31068_31088[(2)] = null);

(statearr_31068_31088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (5))){
var state_31057__$1 = state_31057;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31069_31089 = state_31057__$1;
(statearr_31069_31089[(1)] = (8));

} else {
var statearr_31070_31090 = state_31057__$1;
(statearr_31070_31090[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (14))){
var inst_31051 = (state_31057[(2)]);
var state_31057__$1 = state_31057;
var statearr_31071_31091 = state_31057__$1;
(statearr_31071_31091[(2)] = inst_31051);

(statearr_31071_31091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (10))){
var inst_31043 = (state_31057[(2)]);
var state_31057__$1 = state_31057;
var statearr_31072_31092 = state_31057__$1;
(statearr_31072_31092[(2)] = inst_31043);

(statearr_31072_31092[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31058 === (8))){
var inst_31040 = cljs.core.async.close_BANG_.call(null,to);
var state_31057__$1 = state_31057;
var statearr_31073_31093 = state_31057__$1;
(statearr_31073_31093[(2)] = inst_31040);

(statearr_31073_31093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___31079))
;
return ((function (switch__30858__auto__,c__30946__auto___31079){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_31074 = [null,null,null,null,null,null,null,null];
(statearr_31074[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_31074[(1)] = (1));

return statearr_31074;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_31057){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31075){if((e31075 instanceof Object)){
var ex__30862__auto__ = e31075;
var statearr_31076_31094 = state_31057;
(statearr_31076_31094[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31057);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31075;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31095 = state_31057;
state_31057 = G__31095;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_31057){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_31057);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___31079))
})();
var state__30948__auto__ = (function (){var statearr_31077 = f__30947__auto__.call(null);
(statearr_31077[(6)] = c__30946__auto___31079);

return statearr_31077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___31079))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31096){
var vec__31097 = p__31096;
var v = cljs.core.nth.call(null,vec__31097,(0),null);
var p = cljs.core.nth.call(null,vec__31097,(1),null);
var job = vec__31097;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30946__auto___31268 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___31268,res,vec__31097,v,p,job,jobs,results){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___31268,res,vec__31097,v,p,job,jobs,results){
return (function (state_31104){
var state_val_31105 = (state_31104[(1)]);
if((state_val_31105 === (1))){
var state_31104__$1 = state_31104;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31104__$1,(2),res,v);
} else {
if((state_val_31105 === (2))){
var inst_31101 = (state_31104[(2)]);
var inst_31102 = cljs.core.async.close_BANG_.call(null,res);
var state_31104__$1 = (function (){var statearr_31106 = state_31104;
(statearr_31106[(7)] = inst_31101);

return statearr_31106;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31104__$1,inst_31102);
} else {
return null;
}
}
});})(c__30946__auto___31268,res,vec__31097,v,p,job,jobs,results))
;
return ((function (switch__30858__auto__,c__30946__auto___31268,res,vec__31097,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0 = (function (){
var statearr_31107 = [null,null,null,null,null,null,null,null];
(statearr_31107[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__);

(statearr_31107[(1)] = (1));

return statearr_31107;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1 = (function (state_31104){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31108){if((e31108 instanceof Object)){
var ex__30862__auto__ = e31108;
var statearr_31109_31269 = state_31104;
(statearr_31109_31269[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31104);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31108;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31270 = state_31104;
state_31104 = G__31270;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = function(state_31104){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1.call(this,state_31104);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___31268,res,vec__31097,v,p,job,jobs,results))
})();
var state__30948__auto__ = (function (){var statearr_31110 = f__30947__auto__.call(null);
(statearr_31110[(6)] = c__30946__auto___31268);

return statearr_31110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___31268,res,vec__31097,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31111){
var vec__31112 = p__31111;
var v = cljs.core.nth.call(null,vec__31112,(0),null);
var p = cljs.core.nth.call(null,vec__31112,(1),null);
var job = vec__31112;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29292__auto___31271 = n;
var __31272 = (0);
while(true){
if((__31272 < n__29292__auto___31271)){
var G__31115_31273 = type;
var G__31115_31274__$1 = (((G__31115_31273 instanceof cljs.core.Keyword))?G__31115_31273.fqn:null);
switch (G__31115_31274__$1) {
case "compute":
var c__30946__auto___31276 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31272,c__30946__auto___31276,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (__31272,c__30946__auto___31276,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async){
return (function (state_31128){
var state_val_31129 = (state_31128[(1)]);
if((state_val_31129 === (1))){
var state_31128__$1 = state_31128;
var statearr_31130_31277 = state_31128__$1;
(statearr_31130_31277[(2)] = null);

(statearr_31130_31277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31129 === (2))){
var state_31128__$1 = state_31128;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31128__$1,(4),jobs);
} else {
if((state_val_31129 === (3))){
var inst_31126 = (state_31128[(2)]);
var state_31128__$1 = state_31128;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31128__$1,inst_31126);
} else {
if((state_val_31129 === (4))){
var inst_31118 = (state_31128[(2)]);
var inst_31119 = process.call(null,inst_31118);
var state_31128__$1 = state_31128;
if(cljs.core.truth_(inst_31119)){
var statearr_31131_31278 = state_31128__$1;
(statearr_31131_31278[(1)] = (5));

} else {
var statearr_31132_31279 = state_31128__$1;
(statearr_31132_31279[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31129 === (5))){
var state_31128__$1 = state_31128;
var statearr_31133_31280 = state_31128__$1;
(statearr_31133_31280[(2)] = null);

(statearr_31133_31280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31129 === (6))){
var state_31128__$1 = state_31128;
var statearr_31134_31281 = state_31128__$1;
(statearr_31134_31281[(2)] = null);

(statearr_31134_31281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31129 === (7))){
var inst_31124 = (state_31128[(2)]);
var state_31128__$1 = state_31128;
var statearr_31135_31282 = state_31128__$1;
(statearr_31135_31282[(2)] = inst_31124);

(statearr_31135_31282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31272,c__30946__auto___31276,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async))
;
return ((function (__31272,switch__30858__auto__,c__30946__auto___31276,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0 = (function (){
var statearr_31136 = [null,null,null,null,null,null,null];
(statearr_31136[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__);

(statearr_31136[(1)] = (1));

return statearr_31136;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1 = (function (state_31128){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31137){if((e31137 instanceof Object)){
var ex__30862__auto__ = e31137;
var statearr_31138_31283 = state_31128;
(statearr_31138_31283[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31128);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31137;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31284 = state_31128;
state_31128 = G__31284;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = function(state_31128){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1.call(this,state_31128);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__;
})()
;})(__31272,switch__30858__auto__,c__30946__auto___31276,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async))
})();
var state__30948__auto__ = (function (){var statearr_31139 = f__30947__auto__.call(null);
(statearr_31139[(6)] = c__30946__auto___31276);

return statearr_31139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(__31272,c__30946__auto___31276,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async))
);


break;
case "async":
var c__30946__auto___31285 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31272,c__30946__auto___31285,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (__31272,c__30946__auto___31285,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async){
return (function (state_31152){
var state_val_31153 = (state_31152[(1)]);
if((state_val_31153 === (1))){
var state_31152__$1 = state_31152;
var statearr_31154_31286 = state_31152__$1;
(statearr_31154_31286[(2)] = null);

(statearr_31154_31286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31153 === (2))){
var state_31152__$1 = state_31152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31152__$1,(4),jobs);
} else {
if((state_val_31153 === (3))){
var inst_31150 = (state_31152[(2)]);
var state_31152__$1 = state_31152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31152__$1,inst_31150);
} else {
if((state_val_31153 === (4))){
var inst_31142 = (state_31152[(2)]);
var inst_31143 = async.call(null,inst_31142);
var state_31152__$1 = state_31152;
if(cljs.core.truth_(inst_31143)){
var statearr_31155_31287 = state_31152__$1;
(statearr_31155_31287[(1)] = (5));

} else {
var statearr_31156_31288 = state_31152__$1;
(statearr_31156_31288[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31153 === (5))){
var state_31152__$1 = state_31152;
var statearr_31157_31289 = state_31152__$1;
(statearr_31157_31289[(2)] = null);

(statearr_31157_31289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31153 === (6))){
var state_31152__$1 = state_31152;
var statearr_31158_31290 = state_31152__$1;
(statearr_31158_31290[(2)] = null);

(statearr_31158_31290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31153 === (7))){
var inst_31148 = (state_31152[(2)]);
var state_31152__$1 = state_31152;
var statearr_31159_31291 = state_31152__$1;
(statearr_31159_31291[(2)] = inst_31148);

(statearr_31159_31291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31272,c__30946__auto___31285,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async))
;
return ((function (__31272,switch__30858__auto__,c__30946__auto___31285,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0 = (function (){
var statearr_31160 = [null,null,null,null,null,null,null];
(statearr_31160[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__);

(statearr_31160[(1)] = (1));

return statearr_31160;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1 = (function (state_31152){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31161){if((e31161 instanceof Object)){
var ex__30862__auto__ = e31161;
var statearr_31162_31292 = state_31152;
(statearr_31162_31292[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31152);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31161;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31293 = state_31152;
state_31152 = G__31293;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = function(state_31152){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1.call(this,state_31152);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__;
})()
;})(__31272,switch__30858__auto__,c__30946__auto___31285,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async))
})();
var state__30948__auto__ = (function (){var statearr_31163 = f__30947__auto__.call(null);
(statearr_31163[(6)] = c__30946__auto___31285);

return statearr_31163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(__31272,c__30946__auto___31285,G__31115_31273,G__31115_31274__$1,n__29292__auto___31271,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31115_31274__$1)].join('')));

}

var G__31294 = (__31272 + (1));
__31272 = G__31294;
continue;
} else {
}
break;
}

var c__30946__auto___31295 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___31295,jobs,results,process,async){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___31295,jobs,results,process,async){
return (function (state_31185){
var state_val_31186 = (state_31185[(1)]);
if((state_val_31186 === (1))){
var state_31185__$1 = state_31185;
var statearr_31187_31296 = state_31185__$1;
(statearr_31187_31296[(2)] = null);

(statearr_31187_31296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31186 === (2))){
var state_31185__$1 = state_31185;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31185__$1,(4),from);
} else {
if((state_val_31186 === (3))){
var inst_31183 = (state_31185[(2)]);
var state_31185__$1 = state_31185;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31185__$1,inst_31183);
} else {
if((state_val_31186 === (4))){
var inst_31166 = (state_31185[(7)]);
var inst_31166__$1 = (state_31185[(2)]);
var inst_31167 = (inst_31166__$1 == null);
var state_31185__$1 = (function (){var statearr_31188 = state_31185;
(statearr_31188[(7)] = inst_31166__$1);

return statearr_31188;
})();
if(cljs.core.truth_(inst_31167)){
var statearr_31189_31297 = state_31185__$1;
(statearr_31189_31297[(1)] = (5));

} else {
var statearr_31190_31298 = state_31185__$1;
(statearr_31190_31298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31186 === (5))){
var inst_31169 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31185__$1 = state_31185;
var statearr_31191_31299 = state_31185__$1;
(statearr_31191_31299[(2)] = inst_31169);

(statearr_31191_31299[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31186 === (6))){
var inst_31171 = (state_31185[(8)]);
var inst_31166 = (state_31185[(7)]);
var inst_31171__$1 = cljs.core.async.chan.call(null,(1));
var inst_31172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31173 = [inst_31166,inst_31171__$1];
var inst_31174 = (new cljs.core.PersistentVector(null,2,(5),inst_31172,inst_31173,null));
var state_31185__$1 = (function (){var statearr_31192 = state_31185;
(statearr_31192[(8)] = inst_31171__$1);

return statearr_31192;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31185__$1,(8),jobs,inst_31174);
} else {
if((state_val_31186 === (7))){
var inst_31181 = (state_31185[(2)]);
var state_31185__$1 = state_31185;
var statearr_31193_31300 = state_31185__$1;
(statearr_31193_31300[(2)] = inst_31181);

(statearr_31193_31300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31186 === (8))){
var inst_31171 = (state_31185[(8)]);
var inst_31176 = (state_31185[(2)]);
var state_31185__$1 = (function (){var statearr_31194 = state_31185;
(statearr_31194[(9)] = inst_31176);

return statearr_31194;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31185__$1,(9),results,inst_31171);
} else {
if((state_val_31186 === (9))){
var inst_31178 = (state_31185[(2)]);
var state_31185__$1 = (function (){var statearr_31195 = state_31185;
(statearr_31195[(10)] = inst_31178);

return statearr_31195;
})();
var statearr_31196_31301 = state_31185__$1;
(statearr_31196_31301[(2)] = null);

(statearr_31196_31301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___31295,jobs,results,process,async))
;
return ((function (switch__30858__auto__,c__30946__auto___31295,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0 = (function (){
var statearr_31197 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31197[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__);

(statearr_31197[(1)] = (1));

return statearr_31197;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1 = (function (state_31185){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31185);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31198){if((e31198 instanceof Object)){
var ex__30862__auto__ = e31198;
var statearr_31199_31302 = state_31185;
(statearr_31199_31302[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31185);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31198;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31303 = state_31185;
state_31185 = G__31303;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = function(state_31185){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1.call(this,state_31185);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___31295,jobs,results,process,async))
})();
var state__30948__auto__ = (function (){var statearr_31200 = f__30947__auto__.call(null);
(statearr_31200[(6)] = c__30946__auto___31295);

return statearr_31200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___31295,jobs,results,process,async))
);


var c__30946__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto__,jobs,results,process,async){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto__,jobs,results,process,async){
return (function (state_31238){
var state_val_31239 = (state_31238[(1)]);
if((state_val_31239 === (7))){
var inst_31234 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
var statearr_31240_31304 = state_31238__$1;
(statearr_31240_31304[(2)] = inst_31234);

(statearr_31240_31304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (20))){
var state_31238__$1 = state_31238;
var statearr_31241_31305 = state_31238__$1;
(statearr_31241_31305[(2)] = null);

(statearr_31241_31305[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (1))){
var state_31238__$1 = state_31238;
var statearr_31242_31306 = state_31238__$1;
(statearr_31242_31306[(2)] = null);

(statearr_31242_31306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (4))){
var inst_31203 = (state_31238[(7)]);
var inst_31203__$1 = (state_31238[(2)]);
var inst_31204 = (inst_31203__$1 == null);
var state_31238__$1 = (function (){var statearr_31243 = state_31238;
(statearr_31243[(7)] = inst_31203__$1);

return statearr_31243;
})();
if(cljs.core.truth_(inst_31204)){
var statearr_31244_31307 = state_31238__$1;
(statearr_31244_31307[(1)] = (5));

} else {
var statearr_31245_31308 = state_31238__$1;
(statearr_31245_31308[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (15))){
var inst_31216 = (state_31238[(8)]);
var state_31238__$1 = state_31238;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31238__$1,(18),to,inst_31216);
} else {
if((state_val_31239 === (21))){
var inst_31229 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
var statearr_31246_31309 = state_31238__$1;
(statearr_31246_31309[(2)] = inst_31229);

(statearr_31246_31309[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (13))){
var inst_31231 = (state_31238[(2)]);
var state_31238__$1 = (function (){var statearr_31247 = state_31238;
(statearr_31247[(9)] = inst_31231);

return statearr_31247;
})();
var statearr_31248_31310 = state_31238__$1;
(statearr_31248_31310[(2)] = null);

(statearr_31248_31310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (6))){
var inst_31203 = (state_31238[(7)]);
var state_31238__$1 = state_31238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31238__$1,(11),inst_31203);
} else {
if((state_val_31239 === (17))){
var inst_31224 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
if(cljs.core.truth_(inst_31224)){
var statearr_31249_31311 = state_31238__$1;
(statearr_31249_31311[(1)] = (19));

} else {
var statearr_31250_31312 = state_31238__$1;
(statearr_31250_31312[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (3))){
var inst_31236 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31238__$1,inst_31236);
} else {
if((state_val_31239 === (12))){
var inst_31213 = (state_31238[(10)]);
var state_31238__$1 = state_31238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31238__$1,(14),inst_31213);
} else {
if((state_val_31239 === (2))){
var state_31238__$1 = state_31238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31238__$1,(4),results);
} else {
if((state_val_31239 === (19))){
var state_31238__$1 = state_31238;
var statearr_31251_31313 = state_31238__$1;
(statearr_31251_31313[(2)] = null);

(statearr_31251_31313[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (11))){
var inst_31213 = (state_31238[(2)]);
var state_31238__$1 = (function (){var statearr_31252 = state_31238;
(statearr_31252[(10)] = inst_31213);

return statearr_31252;
})();
var statearr_31253_31314 = state_31238__$1;
(statearr_31253_31314[(2)] = null);

(statearr_31253_31314[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (9))){
var state_31238__$1 = state_31238;
var statearr_31254_31315 = state_31238__$1;
(statearr_31254_31315[(2)] = null);

(statearr_31254_31315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (5))){
var state_31238__$1 = state_31238;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31255_31316 = state_31238__$1;
(statearr_31255_31316[(1)] = (8));

} else {
var statearr_31256_31317 = state_31238__$1;
(statearr_31256_31317[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (14))){
var inst_31218 = (state_31238[(11)]);
var inst_31216 = (state_31238[(8)]);
var inst_31216__$1 = (state_31238[(2)]);
var inst_31217 = (inst_31216__$1 == null);
var inst_31218__$1 = cljs.core.not.call(null,inst_31217);
var state_31238__$1 = (function (){var statearr_31257 = state_31238;
(statearr_31257[(11)] = inst_31218__$1);

(statearr_31257[(8)] = inst_31216__$1);

return statearr_31257;
})();
if(inst_31218__$1){
var statearr_31258_31318 = state_31238__$1;
(statearr_31258_31318[(1)] = (15));

} else {
var statearr_31259_31319 = state_31238__$1;
(statearr_31259_31319[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (16))){
var inst_31218 = (state_31238[(11)]);
var state_31238__$1 = state_31238;
var statearr_31260_31320 = state_31238__$1;
(statearr_31260_31320[(2)] = inst_31218);

(statearr_31260_31320[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (10))){
var inst_31210 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
var statearr_31261_31321 = state_31238__$1;
(statearr_31261_31321[(2)] = inst_31210);

(statearr_31261_31321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (18))){
var inst_31221 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
var statearr_31262_31322 = state_31238__$1;
(statearr_31262_31322[(2)] = inst_31221);

(statearr_31262_31322[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (8))){
var inst_31207 = cljs.core.async.close_BANG_.call(null,to);
var state_31238__$1 = state_31238;
var statearr_31263_31323 = state_31238__$1;
(statearr_31263_31323[(2)] = inst_31207);

(statearr_31263_31323[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto__,jobs,results,process,async))
;
return ((function (switch__30858__auto__,c__30946__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0 = (function (){
var statearr_31264 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31264[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__);

(statearr_31264[(1)] = (1));

return statearr_31264;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1 = (function (state_31238){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31265){if((e31265 instanceof Object)){
var ex__30862__auto__ = e31265;
var statearr_31266_31324 = state_31238;
(statearr_31266_31324[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31238);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31265;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31325 = state_31238;
state_31238 = G__31325;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__ = function(state_31238){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1.call(this,state_31238);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30859__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto__,jobs,results,process,async))
})();
var state__30948__auto__ = (function (){var statearr_31267 = f__30947__auto__.call(null);
(statearr_31267[(6)] = c__30946__auto__);

return statearr_31267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto__,jobs,results,process,async))
);

return c__30946__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31327 = arguments.length;
switch (G__31327) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31330 = arguments.length;
switch (G__31330) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31333 = arguments.length;
switch (G__31333) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30946__auto___31382 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___31382,tc,fc){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___31382,tc,fc){
return (function (state_31359){
var state_val_31360 = (state_31359[(1)]);
if((state_val_31360 === (7))){
var inst_31355 = (state_31359[(2)]);
var state_31359__$1 = state_31359;
var statearr_31361_31383 = state_31359__$1;
(statearr_31361_31383[(2)] = inst_31355);

(statearr_31361_31383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (1))){
var state_31359__$1 = state_31359;
var statearr_31362_31384 = state_31359__$1;
(statearr_31362_31384[(2)] = null);

(statearr_31362_31384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (4))){
var inst_31336 = (state_31359[(7)]);
var inst_31336__$1 = (state_31359[(2)]);
var inst_31337 = (inst_31336__$1 == null);
var state_31359__$1 = (function (){var statearr_31363 = state_31359;
(statearr_31363[(7)] = inst_31336__$1);

return statearr_31363;
})();
if(cljs.core.truth_(inst_31337)){
var statearr_31364_31385 = state_31359__$1;
(statearr_31364_31385[(1)] = (5));

} else {
var statearr_31365_31386 = state_31359__$1;
(statearr_31365_31386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (13))){
var state_31359__$1 = state_31359;
var statearr_31366_31387 = state_31359__$1;
(statearr_31366_31387[(2)] = null);

(statearr_31366_31387[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (6))){
var inst_31336 = (state_31359[(7)]);
var inst_31342 = p.call(null,inst_31336);
var state_31359__$1 = state_31359;
if(cljs.core.truth_(inst_31342)){
var statearr_31367_31388 = state_31359__$1;
(statearr_31367_31388[(1)] = (9));

} else {
var statearr_31368_31389 = state_31359__$1;
(statearr_31368_31389[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (3))){
var inst_31357 = (state_31359[(2)]);
var state_31359__$1 = state_31359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31359__$1,inst_31357);
} else {
if((state_val_31360 === (12))){
var state_31359__$1 = state_31359;
var statearr_31369_31390 = state_31359__$1;
(statearr_31369_31390[(2)] = null);

(statearr_31369_31390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (2))){
var state_31359__$1 = state_31359;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31359__$1,(4),ch);
} else {
if((state_val_31360 === (11))){
var inst_31336 = (state_31359[(7)]);
var inst_31346 = (state_31359[(2)]);
var state_31359__$1 = state_31359;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31359__$1,(8),inst_31346,inst_31336);
} else {
if((state_val_31360 === (9))){
var state_31359__$1 = state_31359;
var statearr_31370_31391 = state_31359__$1;
(statearr_31370_31391[(2)] = tc);

(statearr_31370_31391[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (5))){
var inst_31339 = cljs.core.async.close_BANG_.call(null,tc);
var inst_31340 = cljs.core.async.close_BANG_.call(null,fc);
var state_31359__$1 = (function (){var statearr_31371 = state_31359;
(statearr_31371[(8)] = inst_31339);

return statearr_31371;
})();
var statearr_31372_31392 = state_31359__$1;
(statearr_31372_31392[(2)] = inst_31340);

(statearr_31372_31392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (14))){
var inst_31353 = (state_31359[(2)]);
var state_31359__$1 = state_31359;
var statearr_31373_31393 = state_31359__$1;
(statearr_31373_31393[(2)] = inst_31353);

(statearr_31373_31393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (10))){
var state_31359__$1 = state_31359;
var statearr_31374_31394 = state_31359__$1;
(statearr_31374_31394[(2)] = fc);

(statearr_31374_31394[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31360 === (8))){
var inst_31348 = (state_31359[(2)]);
var state_31359__$1 = state_31359;
if(cljs.core.truth_(inst_31348)){
var statearr_31375_31395 = state_31359__$1;
(statearr_31375_31395[(1)] = (12));

} else {
var statearr_31376_31396 = state_31359__$1;
(statearr_31376_31396[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___31382,tc,fc))
;
return ((function (switch__30858__auto__,c__30946__auto___31382,tc,fc){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_31377 = [null,null,null,null,null,null,null,null,null];
(statearr_31377[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_31377[(1)] = (1));

return statearr_31377;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_31359){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31378){if((e31378 instanceof Object)){
var ex__30862__auto__ = e31378;
var statearr_31379_31397 = state_31359;
(statearr_31379_31397[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31359);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31378;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31398 = state_31359;
state_31359 = G__31398;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_31359){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_31359);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___31382,tc,fc))
})();
var state__30948__auto__ = (function (){var statearr_31380 = f__30947__auto__.call(null);
(statearr_31380[(6)] = c__30946__auto___31382);

return statearr_31380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___31382,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30946__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto__){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto__){
return (function (state_31419){
var state_val_31420 = (state_31419[(1)]);
if((state_val_31420 === (7))){
var inst_31415 = (state_31419[(2)]);
var state_31419__$1 = state_31419;
var statearr_31421_31439 = state_31419__$1;
(statearr_31421_31439[(2)] = inst_31415);

(statearr_31421_31439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31420 === (1))){
var inst_31399 = init;
var state_31419__$1 = (function (){var statearr_31422 = state_31419;
(statearr_31422[(7)] = inst_31399);

return statearr_31422;
})();
var statearr_31423_31440 = state_31419__$1;
(statearr_31423_31440[(2)] = null);

(statearr_31423_31440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31420 === (4))){
var inst_31402 = (state_31419[(8)]);
var inst_31402__$1 = (state_31419[(2)]);
var inst_31403 = (inst_31402__$1 == null);
var state_31419__$1 = (function (){var statearr_31424 = state_31419;
(statearr_31424[(8)] = inst_31402__$1);

return statearr_31424;
})();
if(cljs.core.truth_(inst_31403)){
var statearr_31425_31441 = state_31419__$1;
(statearr_31425_31441[(1)] = (5));

} else {
var statearr_31426_31442 = state_31419__$1;
(statearr_31426_31442[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31420 === (6))){
var inst_31399 = (state_31419[(7)]);
var inst_31402 = (state_31419[(8)]);
var inst_31406 = (state_31419[(9)]);
var inst_31406__$1 = f.call(null,inst_31399,inst_31402);
var inst_31407 = cljs.core.reduced_QMARK_.call(null,inst_31406__$1);
var state_31419__$1 = (function (){var statearr_31427 = state_31419;
(statearr_31427[(9)] = inst_31406__$1);

return statearr_31427;
})();
if(inst_31407){
var statearr_31428_31443 = state_31419__$1;
(statearr_31428_31443[(1)] = (8));

} else {
var statearr_31429_31444 = state_31419__$1;
(statearr_31429_31444[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31420 === (3))){
var inst_31417 = (state_31419[(2)]);
var state_31419__$1 = state_31419;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31419__$1,inst_31417);
} else {
if((state_val_31420 === (2))){
var state_31419__$1 = state_31419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31419__$1,(4),ch);
} else {
if((state_val_31420 === (9))){
var inst_31406 = (state_31419[(9)]);
var inst_31399 = inst_31406;
var state_31419__$1 = (function (){var statearr_31430 = state_31419;
(statearr_31430[(7)] = inst_31399);

return statearr_31430;
})();
var statearr_31431_31445 = state_31419__$1;
(statearr_31431_31445[(2)] = null);

(statearr_31431_31445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31420 === (5))){
var inst_31399 = (state_31419[(7)]);
var state_31419__$1 = state_31419;
var statearr_31432_31446 = state_31419__$1;
(statearr_31432_31446[(2)] = inst_31399);

(statearr_31432_31446[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31420 === (10))){
var inst_31413 = (state_31419[(2)]);
var state_31419__$1 = state_31419;
var statearr_31433_31447 = state_31419__$1;
(statearr_31433_31447[(2)] = inst_31413);

(statearr_31433_31447[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31420 === (8))){
var inst_31406 = (state_31419[(9)]);
var inst_31409 = cljs.core.deref.call(null,inst_31406);
var state_31419__$1 = state_31419;
var statearr_31434_31448 = state_31419__$1;
(statearr_31434_31448[(2)] = inst_31409);

(statearr_31434_31448[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto__))
;
return ((function (switch__30858__auto__,c__30946__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__30859__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30859__auto____0 = (function (){
var statearr_31435 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31435[(0)] = cljs$core$async$reduce_$_state_machine__30859__auto__);

(statearr_31435[(1)] = (1));

return statearr_31435;
});
var cljs$core$async$reduce_$_state_machine__30859__auto____1 = (function (state_31419){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31419);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31436){if((e31436 instanceof Object)){
var ex__30862__auto__ = e31436;
var statearr_31437_31449 = state_31419;
(statearr_31437_31449[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31419);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31436;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31450 = state_31419;
state_31419 = G__31450;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30859__auto__ = function(state_31419){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30859__auto____1.call(this,state_31419);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30859__auto____0;
cljs$core$async$reduce_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30859__auto____1;
return cljs$core$async$reduce_$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto__))
})();
var state__30948__auto__ = (function (){var statearr_31438 = f__30947__auto__.call(null);
(statearr_31438[(6)] = c__30946__auto__);

return statearr_31438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto__))
);

return c__30946__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__30946__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto__,f__$1){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto__,f__$1){
return (function (state_31456){
var state_val_31457 = (state_31456[(1)]);
if((state_val_31457 === (1))){
var inst_31451 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_31456__$1 = state_31456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31456__$1,(2),inst_31451);
} else {
if((state_val_31457 === (2))){
var inst_31453 = (state_31456[(2)]);
var inst_31454 = f__$1.call(null,inst_31453);
var state_31456__$1 = state_31456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31456__$1,inst_31454);
} else {
return null;
}
}
});})(c__30946__auto__,f__$1))
;
return ((function (switch__30858__auto__,c__30946__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__30859__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30859__auto____0 = (function (){
var statearr_31458 = [null,null,null,null,null,null,null];
(statearr_31458[(0)] = cljs$core$async$transduce_$_state_machine__30859__auto__);

(statearr_31458[(1)] = (1));

return statearr_31458;
});
var cljs$core$async$transduce_$_state_machine__30859__auto____1 = (function (state_31456){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31459){if((e31459 instanceof Object)){
var ex__30862__auto__ = e31459;
var statearr_31460_31462 = state_31456;
(statearr_31460_31462[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31456);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31459;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31463 = state_31456;
state_31456 = G__31463;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30859__auto__ = function(state_31456){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30859__auto____1.call(this,state_31456);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30859__auto____0;
cljs$core$async$transduce_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30859__auto____1;
return cljs$core$async$transduce_$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto__,f__$1))
})();
var state__30948__auto__ = (function (){var statearr_31461 = f__30947__auto__.call(null);
(statearr_31461[(6)] = c__30946__auto__);

return statearr_31461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto__,f__$1))
);

return c__30946__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31465 = arguments.length;
switch (G__31465) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30946__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto__){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto__){
return (function (state_31490){
var state_val_31491 = (state_31490[(1)]);
if((state_val_31491 === (7))){
var inst_31472 = (state_31490[(2)]);
var state_31490__$1 = state_31490;
var statearr_31492_31513 = state_31490__$1;
(statearr_31492_31513[(2)] = inst_31472);

(statearr_31492_31513[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (1))){
var inst_31466 = cljs.core.seq.call(null,coll);
var inst_31467 = inst_31466;
var state_31490__$1 = (function (){var statearr_31493 = state_31490;
(statearr_31493[(7)] = inst_31467);

return statearr_31493;
})();
var statearr_31494_31514 = state_31490__$1;
(statearr_31494_31514[(2)] = null);

(statearr_31494_31514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (4))){
var inst_31467 = (state_31490[(7)]);
var inst_31470 = cljs.core.first.call(null,inst_31467);
var state_31490__$1 = state_31490;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31490__$1,(7),ch,inst_31470);
} else {
if((state_val_31491 === (13))){
var inst_31484 = (state_31490[(2)]);
var state_31490__$1 = state_31490;
var statearr_31495_31515 = state_31490__$1;
(statearr_31495_31515[(2)] = inst_31484);

(statearr_31495_31515[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (6))){
var inst_31475 = (state_31490[(2)]);
var state_31490__$1 = state_31490;
if(cljs.core.truth_(inst_31475)){
var statearr_31496_31516 = state_31490__$1;
(statearr_31496_31516[(1)] = (8));

} else {
var statearr_31497_31517 = state_31490__$1;
(statearr_31497_31517[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (3))){
var inst_31488 = (state_31490[(2)]);
var state_31490__$1 = state_31490;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31490__$1,inst_31488);
} else {
if((state_val_31491 === (12))){
var state_31490__$1 = state_31490;
var statearr_31498_31518 = state_31490__$1;
(statearr_31498_31518[(2)] = null);

(statearr_31498_31518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (2))){
var inst_31467 = (state_31490[(7)]);
var state_31490__$1 = state_31490;
if(cljs.core.truth_(inst_31467)){
var statearr_31499_31519 = state_31490__$1;
(statearr_31499_31519[(1)] = (4));

} else {
var statearr_31500_31520 = state_31490__$1;
(statearr_31500_31520[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (11))){
var inst_31481 = cljs.core.async.close_BANG_.call(null,ch);
var state_31490__$1 = state_31490;
var statearr_31501_31521 = state_31490__$1;
(statearr_31501_31521[(2)] = inst_31481);

(statearr_31501_31521[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (9))){
var state_31490__$1 = state_31490;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31502_31522 = state_31490__$1;
(statearr_31502_31522[(1)] = (11));

} else {
var statearr_31503_31523 = state_31490__$1;
(statearr_31503_31523[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (5))){
var inst_31467 = (state_31490[(7)]);
var state_31490__$1 = state_31490;
var statearr_31504_31524 = state_31490__$1;
(statearr_31504_31524[(2)] = inst_31467);

(statearr_31504_31524[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (10))){
var inst_31486 = (state_31490[(2)]);
var state_31490__$1 = state_31490;
var statearr_31505_31525 = state_31490__$1;
(statearr_31505_31525[(2)] = inst_31486);

(statearr_31505_31525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31491 === (8))){
var inst_31467 = (state_31490[(7)]);
var inst_31477 = cljs.core.next.call(null,inst_31467);
var inst_31467__$1 = inst_31477;
var state_31490__$1 = (function (){var statearr_31506 = state_31490;
(statearr_31506[(7)] = inst_31467__$1);

return statearr_31506;
})();
var statearr_31507_31526 = state_31490__$1;
(statearr_31507_31526[(2)] = null);

(statearr_31507_31526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto__))
;
return ((function (switch__30858__auto__,c__30946__auto__){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_31508 = [null,null,null,null,null,null,null,null];
(statearr_31508[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_31508[(1)] = (1));

return statearr_31508;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_31490){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31490);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31509){if((e31509 instanceof Object)){
var ex__30862__auto__ = e31509;
var statearr_31510_31527 = state_31490;
(statearr_31510_31527[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31490);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31528 = state_31490;
state_31490 = G__31528;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_31490){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_31490);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto__))
})();
var state__30948__auto__ = (function (){var statearr_31511 = f__30947__auto__.call(null);
(statearr_31511[(6)] = c__30946__auto__);

return statearr_31511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto__))
);

return c__30946__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__29030__auto__ = (((_ == null))?null:_);
var m__29031__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,_);
} else {
var m__29031__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__29031__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m);
} else {
var m__29031__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31529 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31529 = (function (ch,cs,meta31530){
this.ch = ch;
this.cs = cs;
this.meta31530 = meta31530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31531,meta31530__$1){
var self__ = this;
var _31531__$1 = this;
return (new cljs.core.async.t_cljs$core$async31529(self__.ch,self__.cs,meta31530__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31529.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31531){
var self__ = this;
var _31531__$1 = this;
return self__.meta31530;
});})(cs))
;

cljs.core.async.t_cljs$core$async31529.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31529.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31529.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31529.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31529.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31529.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31529.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31530","meta31530",586508120,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31529.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31529.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31529";

cljs.core.async.t_cljs$core$async31529.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async31529");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31529 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31529(ch__$1,cs__$1,meta31530){
return (new cljs.core.async.t_cljs$core$async31529(ch__$1,cs__$1,meta31530));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31529(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30946__auto___31751 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___31751,cs,m,dchan,dctr,done){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___31751,cs,m,dchan,dctr,done){
return (function (state_31666){
var state_val_31667 = (state_31666[(1)]);
if((state_val_31667 === (7))){
var inst_31662 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31668_31752 = state_31666__$1;
(statearr_31668_31752[(2)] = inst_31662);

(statearr_31668_31752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (20))){
var inst_31565 = (state_31666[(7)]);
var inst_31577 = cljs.core.first.call(null,inst_31565);
var inst_31578 = cljs.core.nth.call(null,inst_31577,(0),null);
var inst_31579 = cljs.core.nth.call(null,inst_31577,(1),null);
var state_31666__$1 = (function (){var statearr_31669 = state_31666;
(statearr_31669[(8)] = inst_31578);

return statearr_31669;
})();
if(cljs.core.truth_(inst_31579)){
var statearr_31670_31753 = state_31666__$1;
(statearr_31670_31753[(1)] = (22));

} else {
var statearr_31671_31754 = state_31666__$1;
(statearr_31671_31754[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (27))){
var inst_31614 = (state_31666[(9)]);
var inst_31607 = (state_31666[(10)]);
var inst_31609 = (state_31666[(11)]);
var inst_31534 = (state_31666[(12)]);
var inst_31614__$1 = cljs.core._nth.call(null,inst_31607,inst_31609);
var inst_31615 = cljs.core.async.put_BANG_.call(null,inst_31614__$1,inst_31534,done);
var state_31666__$1 = (function (){var statearr_31672 = state_31666;
(statearr_31672[(9)] = inst_31614__$1);

return statearr_31672;
})();
if(cljs.core.truth_(inst_31615)){
var statearr_31673_31755 = state_31666__$1;
(statearr_31673_31755[(1)] = (30));

} else {
var statearr_31674_31756 = state_31666__$1;
(statearr_31674_31756[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (1))){
var state_31666__$1 = state_31666;
var statearr_31675_31757 = state_31666__$1;
(statearr_31675_31757[(2)] = null);

(statearr_31675_31757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (24))){
var inst_31565 = (state_31666[(7)]);
var inst_31584 = (state_31666[(2)]);
var inst_31585 = cljs.core.next.call(null,inst_31565);
var inst_31543 = inst_31585;
var inst_31544 = null;
var inst_31545 = (0);
var inst_31546 = (0);
var state_31666__$1 = (function (){var statearr_31676 = state_31666;
(statearr_31676[(13)] = inst_31545);

(statearr_31676[(14)] = inst_31543);

(statearr_31676[(15)] = inst_31546);

(statearr_31676[(16)] = inst_31584);

(statearr_31676[(17)] = inst_31544);

return statearr_31676;
})();
var statearr_31677_31758 = state_31666__$1;
(statearr_31677_31758[(2)] = null);

(statearr_31677_31758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (39))){
var state_31666__$1 = state_31666;
var statearr_31681_31759 = state_31666__$1;
(statearr_31681_31759[(2)] = null);

(statearr_31681_31759[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (4))){
var inst_31534 = (state_31666[(12)]);
var inst_31534__$1 = (state_31666[(2)]);
var inst_31535 = (inst_31534__$1 == null);
var state_31666__$1 = (function (){var statearr_31682 = state_31666;
(statearr_31682[(12)] = inst_31534__$1);

return statearr_31682;
})();
if(cljs.core.truth_(inst_31535)){
var statearr_31683_31760 = state_31666__$1;
(statearr_31683_31760[(1)] = (5));

} else {
var statearr_31684_31761 = state_31666__$1;
(statearr_31684_31761[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (15))){
var inst_31545 = (state_31666[(13)]);
var inst_31543 = (state_31666[(14)]);
var inst_31546 = (state_31666[(15)]);
var inst_31544 = (state_31666[(17)]);
var inst_31561 = (state_31666[(2)]);
var inst_31562 = (inst_31546 + (1));
var tmp31678 = inst_31545;
var tmp31679 = inst_31543;
var tmp31680 = inst_31544;
var inst_31543__$1 = tmp31679;
var inst_31544__$1 = tmp31680;
var inst_31545__$1 = tmp31678;
var inst_31546__$1 = inst_31562;
var state_31666__$1 = (function (){var statearr_31685 = state_31666;
(statearr_31685[(18)] = inst_31561);

(statearr_31685[(13)] = inst_31545__$1);

(statearr_31685[(14)] = inst_31543__$1);

(statearr_31685[(15)] = inst_31546__$1);

(statearr_31685[(17)] = inst_31544__$1);

return statearr_31685;
})();
var statearr_31686_31762 = state_31666__$1;
(statearr_31686_31762[(2)] = null);

(statearr_31686_31762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (21))){
var inst_31588 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31690_31763 = state_31666__$1;
(statearr_31690_31763[(2)] = inst_31588);

(statearr_31690_31763[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (31))){
var inst_31614 = (state_31666[(9)]);
var inst_31618 = done.call(null,null);
var inst_31619 = cljs.core.async.untap_STAR_.call(null,m,inst_31614);
var state_31666__$1 = (function (){var statearr_31691 = state_31666;
(statearr_31691[(19)] = inst_31618);

return statearr_31691;
})();
var statearr_31692_31764 = state_31666__$1;
(statearr_31692_31764[(2)] = inst_31619);

(statearr_31692_31764[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (32))){
var inst_31606 = (state_31666[(20)]);
var inst_31607 = (state_31666[(10)]);
var inst_31609 = (state_31666[(11)]);
var inst_31608 = (state_31666[(21)]);
var inst_31621 = (state_31666[(2)]);
var inst_31622 = (inst_31609 + (1));
var tmp31687 = inst_31606;
var tmp31688 = inst_31607;
var tmp31689 = inst_31608;
var inst_31606__$1 = tmp31687;
var inst_31607__$1 = tmp31688;
var inst_31608__$1 = tmp31689;
var inst_31609__$1 = inst_31622;
var state_31666__$1 = (function (){var statearr_31693 = state_31666;
(statearr_31693[(22)] = inst_31621);

(statearr_31693[(20)] = inst_31606__$1);

(statearr_31693[(10)] = inst_31607__$1);

(statearr_31693[(11)] = inst_31609__$1);

(statearr_31693[(21)] = inst_31608__$1);

return statearr_31693;
})();
var statearr_31694_31765 = state_31666__$1;
(statearr_31694_31765[(2)] = null);

(statearr_31694_31765[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (40))){
var inst_31634 = (state_31666[(23)]);
var inst_31638 = done.call(null,null);
var inst_31639 = cljs.core.async.untap_STAR_.call(null,m,inst_31634);
var state_31666__$1 = (function (){var statearr_31695 = state_31666;
(statearr_31695[(24)] = inst_31638);

return statearr_31695;
})();
var statearr_31696_31766 = state_31666__$1;
(statearr_31696_31766[(2)] = inst_31639);

(statearr_31696_31766[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (33))){
var inst_31625 = (state_31666[(25)]);
var inst_31627 = cljs.core.chunked_seq_QMARK_.call(null,inst_31625);
var state_31666__$1 = state_31666;
if(inst_31627){
var statearr_31697_31767 = state_31666__$1;
(statearr_31697_31767[(1)] = (36));

} else {
var statearr_31698_31768 = state_31666__$1;
(statearr_31698_31768[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (13))){
var inst_31555 = (state_31666[(26)]);
var inst_31558 = cljs.core.async.close_BANG_.call(null,inst_31555);
var state_31666__$1 = state_31666;
var statearr_31699_31769 = state_31666__$1;
(statearr_31699_31769[(2)] = inst_31558);

(statearr_31699_31769[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (22))){
var inst_31578 = (state_31666[(8)]);
var inst_31581 = cljs.core.async.close_BANG_.call(null,inst_31578);
var state_31666__$1 = state_31666;
var statearr_31700_31770 = state_31666__$1;
(statearr_31700_31770[(2)] = inst_31581);

(statearr_31700_31770[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (36))){
var inst_31625 = (state_31666[(25)]);
var inst_31629 = cljs.core.chunk_first.call(null,inst_31625);
var inst_31630 = cljs.core.chunk_rest.call(null,inst_31625);
var inst_31631 = cljs.core.count.call(null,inst_31629);
var inst_31606 = inst_31630;
var inst_31607 = inst_31629;
var inst_31608 = inst_31631;
var inst_31609 = (0);
var state_31666__$1 = (function (){var statearr_31701 = state_31666;
(statearr_31701[(20)] = inst_31606);

(statearr_31701[(10)] = inst_31607);

(statearr_31701[(11)] = inst_31609);

(statearr_31701[(21)] = inst_31608);

return statearr_31701;
})();
var statearr_31702_31771 = state_31666__$1;
(statearr_31702_31771[(2)] = null);

(statearr_31702_31771[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (41))){
var inst_31625 = (state_31666[(25)]);
var inst_31641 = (state_31666[(2)]);
var inst_31642 = cljs.core.next.call(null,inst_31625);
var inst_31606 = inst_31642;
var inst_31607 = null;
var inst_31608 = (0);
var inst_31609 = (0);
var state_31666__$1 = (function (){var statearr_31703 = state_31666;
(statearr_31703[(20)] = inst_31606);

(statearr_31703[(10)] = inst_31607);

(statearr_31703[(27)] = inst_31641);

(statearr_31703[(11)] = inst_31609);

(statearr_31703[(21)] = inst_31608);

return statearr_31703;
})();
var statearr_31704_31772 = state_31666__$1;
(statearr_31704_31772[(2)] = null);

(statearr_31704_31772[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (43))){
var state_31666__$1 = state_31666;
var statearr_31705_31773 = state_31666__$1;
(statearr_31705_31773[(2)] = null);

(statearr_31705_31773[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (29))){
var inst_31650 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31706_31774 = state_31666__$1;
(statearr_31706_31774[(2)] = inst_31650);

(statearr_31706_31774[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (44))){
var inst_31659 = (state_31666[(2)]);
var state_31666__$1 = (function (){var statearr_31707 = state_31666;
(statearr_31707[(28)] = inst_31659);

return statearr_31707;
})();
var statearr_31708_31775 = state_31666__$1;
(statearr_31708_31775[(2)] = null);

(statearr_31708_31775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (6))){
var inst_31598 = (state_31666[(29)]);
var inst_31597 = cljs.core.deref.call(null,cs);
var inst_31598__$1 = cljs.core.keys.call(null,inst_31597);
var inst_31599 = cljs.core.count.call(null,inst_31598__$1);
var inst_31600 = cljs.core.reset_BANG_.call(null,dctr,inst_31599);
var inst_31605 = cljs.core.seq.call(null,inst_31598__$1);
var inst_31606 = inst_31605;
var inst_31607 = null;
var inst_31608 = (0);
var inst_31609 = (0);
var state_31666__$1 = (function (){var statearr_31709 = state_31666;
(statearr_31709[(20)] = inst_31606);

(statearr_31709[(10)] = inst_31607);

(statearr_31709[(29)] = inst_31598__$1);

(statearr_31709[(30)] = inst_31600);

(statearr_31709[(11)] = inst_31609);

(statearr_31709[(21)] = inst_31608);

return statearr_31709;
})();
var statearr_31710_31776 = state_31666__$1;
(statearr_31710_31776[(2)] = null);

(statearr_31710_31776[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (28))){
var inst_31606 = (state_31666[(20)]);
var inst_31625 = (state_31666[(25)]);
var inst_31625__$1 = cljs.core.seq.call(null,inst_31606);
var state_31666__$1 = (function (){var statearr_31711 = state_31666;
(statearr_31711[(25)] = inst_31625__$1);

return statearr_31711;
})();
if(inst_31625__$1){
var statearr_31712_31777 = state_31666__$1;
(statearr_31712_31777[(1)] = (33));

} else {
var statearr_31713_31778 = state_31666__$1;
(statearr_31713_31778[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (25))){
var inst_31609 = (state_31666[(11)]);
var inst_31608 = (state_31666[(21)]);
var inst_31611 = (inst_31609 < inst_31608);
var inst_31612 = inst_31611;
var state_31666__$1 = state_31666;
if(cljs.core.truth_(inst_31612)){
var statearr_31714_31779 = state_31666__$1;
(statearr_31714_31779[(1)] = (27));

} else {
var statearr_31715_31780 = state_31666__$1;
(statearr_31715_31780[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (34))){
var state_31666__$1 = state_31666;
var statearr_31716_31781 = state_31666__$1;
(statearr_31716_31781[(2)] = null);

(statearr_31716_31781[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (17))){
var state_31666__$1 = state_31666;
var statearr_31717_31782 = state_31666__$1;
(statearr_31717_31782[(2)] = null);

(statearr_31717_31782[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (3))){
var inst_31664 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31666__$1,inst_31664);
} else {
if((state_val_31667 === (12))){
var inst_31593 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31718_31783 = state_31666__$1;
(statearr_31718_31783[(2)] = inst_31593);

(statearr_31718_31783[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (2))){
var state_31666__$1 = state_31666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31666__$1,(4),ch);
} else {
if((state_val_31667 === (23))){
var state_31666__$1 = state_31666;
var statearr_31719_31784 = state_31666__$1;
(statearr_31719_31784[(2)] = null);

(statearr_31719_31784[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (35))){
var inst_31648 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31720_31785 = state_31666__$1;
(statearr_31720_31785[(2)] = inst_31648);

(statearr_31720_31785[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (19))){
var inst_31565 = (state_31666[(7)]);
var inst_31569 = cljs.core.chunk_first.call(null,inst_31565);
var inst_31570 = cljs.core.chunk_rest.call(null,inst_31565);
var inst_31571 = cljs.core.count.call(null,inst_31569);
var inst_31543 = inst_31570;
var inst_31544 = inst_31569;
var inst_31545 = inst_31571;
var inst_31546 = (0);
var state_31666__$1 = (function (){var statearr_31721 = state_31666;
(statearr_31721[(13)] = inst_31545);

(statearr_31721[(14)] = inst_31543);

(statearr_31721[(15)] = inst_31546);

(statearr_31721[(17)] = inst_31544);

return statearr_31721;
})();
var statearr_31722_31786 = state_31666__$1;
(statearr_31722_31786[(2)] = null);

(statearr_31722_31786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (11))){
var inst_31543 = (state_31666[(14)]);
var inst_31565 = (state_31666[(7)]);
var inst_31565__$1 = cljs.core.seq.call(null,inst_31543);
var state_31666__$1 = (function (){var statearr_31723 = state_31666;
(statearr_31723[(7)] = inst_31565__$1);

return statearr_31723;
})();
if(inst_31565__$1){
var statearr_31724_31787 = state_31666__$1;
(statearr_31724_31787[(1)] = (16));

} else {
var statearr_31725_31788 = state_31666__$1;
(statearr_31725_31788[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (9))){
var inst_31595 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31726_31789 = state_31666__$1;
(statearr_31726_31789[(2)] = inst_31595);

(statearr_31726_31789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (5))){
var inst_31541 = cljs.core.deref.call(null,cs);
var inst_31542 = cljs.core.seq.call(null,inst_31541);
var inst_31543 = inst_31542;
var inst_31544 = null;
var inst_31545 = (0);
var inst_31546 = (0);
var state_31666__$1 = (function (){var statearr_31727 = state_31666;
(statearr_31727[(13)] = inst_31545);

(statearr_31727[(14)] = inst_31543);

(statearr_31727[(15)] = inst_31546);

(statearr_31727[(17)] = inst_31544);

return statearr_31727;
})();
var statearr_31728_31790 = state_31666__$1;
(statearr_31728_31790[(2)] = null);

(statearr_31728_31790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (14))){
var state_31666__$1 = state_31666;
var statearr_31729_31791 = state_31666__$1;
(statearr_31729_31791[(2)] = null);

(statearr_31729_31791[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (45))){
var inst_31656 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31730_31792 = state_31666__$1;
(statearr_31730_31792[(2)] = inst_31656);

(statearr_31730_31792[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (26))){
var inst_31598 = (state_31666[(29)]);
var inst_31652 = (state_31666[(2)]);
var inst_31653 = cljs.core.seq.call(null,inst_31598);
var state_31666__$1 = (function (){var statearr_31731 = state_31666;
(statearr_31731[(31)] = inst_31652);

return statearr_31731;
})();
if(inst_31653){
var statearr_31732_31793 = state_31666__$1;
(statearr_31732_31793[(1)] = (42));

} else {
var statearr_31733_31794 = state_31666__$1;
(statearr_31733_31794[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (16))){
var inst_31565 = (state_31666[(7)]);
var inst_31567 = cljs.core.chunked_seq_QMARK_.call(null,inst_31565);
var state_31666__$1 = state_31666;
if(inst_31567){
var statearr_31734_31795 = state_31666__$1;
(statearr_31734_31795[(1)] = (19));

} else {
var statearr_31735_31796 = state_31666__$1;
(statearr_31735_31796[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (38))){
var inst_31645 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31736_31797 = state_31666__$1;
(statearr_31736_31797[(2)] = inst_31645);

(statearr_31736_31797[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (30))){
var state_31666__$1 = state_31666;
var statearr_31737_31798 = state_31666__$1;
(statearr_31737_31798[(2)] = null);

(statearr_31737_31798[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (10))){
var inst_31546 = (state_31666[(15)]);
var inst_31544 = (state_31666[(17)]);
var inst_31554 = cljs.core._nth.call(null,inst_31544,inst_31546);
var inst_31555 = cljs.core.nth.call(null,inst_31554,(0),null);
var inst_31556 = cljs.core.nth.call(null,inst_31554,(1),null);
var state_31666__$1 = (function (){var statearr_31738 = state_31666;
(statearr_31738[(26)] = inst_31555);

return statearr_31738;
})();
if(cljs.core.truth_(inst_31556)){
var statearr_31739_31799 = state_31666__$1;
(statearr_31739_31799[(1)] = (13));

} else {
var statearr_31740_31800 = state_31666__$1;
(statearr_31740_31800[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (18))){
var inst_31591 = (state_31666[(2)]);
var state_31666__$1 = state_31666;
var statearr_31741_31801 = state_31666__$1;
(statearr_31741_31801[(2)] = inst_31591);

(statearr_31741_31801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (42))){
var state_31666__$1 = state_31666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31666__$1,(45),dchan);
} else {
if((state_val_31667 === (37))){
var inst_31625 = (state_31666[(25)]);
var inst_31634 = (state_31666[(23)]);
var inst_31534 = (state_31666[(12)]);
var inst_31634__$1 = cljs.core.first.call(null,inst_31625);
var inst_31635 = cljs.core.async.put_BANG_.call(null,inst_31634__$1,inst_31534,done);
var state_31666__$1 = (function (){var statearr_31742 = state_31666;
(statearr_31742[(23)] = inst_31634__$1);

return statearr_31742;
})();
if(cljs.core.truth_(inst_31635)){
var statearr_31743_31802 = state_31666__$1;
(statearr_31743_31802[(1)] = (39));

} else {
var statearr_31744_31803 = state_31666__$1;
(statearr_31744_31803[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31667 === (8))){
var inst_31545 = (state_31666[(13)]);
var inst_31546 = (state_31666[(15)]);
var inst_31548 = (inst_31546 < inst_31545);
var inst_31549 = inst_31548;
var state_31666__$1 = state_31666;
if(cljs.core.truth_(inst_31549)){
var statearr_31745_31804 = state_31666__$1;
(statearr_31745_31804[(1)] = (10));

} else {
var statearr_31746_31805 = state_31666__$1;
(statearr_31746_31805[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___31751,cs,m,dchan,dctr,done))
;
return ((function (switch__30858__auto__,c__30946__auto___31751,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__30859__auto__ = null;
var cljs$core$async$mult_$_state_machine__30859__auto____0 = (function (){
var statearr_31747 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31747[(0)] = cljs$core$async$mult_$_state_machine__30859__auto__);

(statearr_31747[(1)] = (1));

return statearr_31747;
});
var cljs$core$async$mult_$_state_machine__30859__auto____1 = (function (state_31666){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31748){if((e31748 instanceof Object)){
var ex__30862__auto__ = e31748;
var statearr_31749_31806 = state_31666;
(statearr_31749_31806[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31666);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31748;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31807 = state_31666;
state_31666 = G__31807;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30859__auto__ = function(state_31666){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30859__auto____1.call(this,state_31666);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30859__auto____0;
cljs$core$async$mult_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30859__auto____1;
return cljs$core$async$mult_$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___31751,cs,m,dchan,dctr,done))
})();
var state__30948__auto__ = (function (){var statearr_31750 = f__30947__auto__.call(null);
(statearr_31750[(6)] = c__30946__auto___31751);

return statearr_31750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___31751,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31809 = arguments.length;
switch (G__31809) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m);
} else {
var m__29031__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,state_map);
} else {
var m__29031__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,mode);
} else {
var m__29031__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29523__auto__ = [];
var len__29516__auto___31821 = arguments.length;
var i__29517__auto___31822 = (0);
while(true){
if((i__29517__auto___31822 < len__29516__auto___31821)){
args__29523__auto__.push((arguments[i__29517__auto___31822]));

var G__31823 = (i__29517__auto___31822 + (1));
i__29517__auto___31822 = G__31823;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((3) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29524__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31815){
var map__31816 = p__31815;
var map__31816__$1 = ((((!((map__31816 == null)))?((((map__31816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31816.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31816):map__31816);
var opts = map__31816__$1;
var statearr_31818_31824 = state;
(statearr_31818_31824[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__31816,map__31816__$1,opts){
return (function (val){
var statearr_31819_31825 = state;
(statearr_31819_31825[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31816,map__31816__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_31820_31826 = state;
(statearr_31820_31826[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31811){
var G__31812 = cljs.core.first.call(null,seq31811);
var seq31811__$1 = cljs.core.next.call(null,seq31811);
var G__31813 = cljs.core.first.call(null,seq31811__$1);
var seq31811__$2 = cljs.core.next.call(null,seq31811__$1);
var G__31814 = cljs.core.first.call(null,seq31811__$2);
var seq31811__$3 = cljs.core.next.call(null,seq31811__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31812,G__31813,G__31814,seq31811__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31827 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31827 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31828){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31828 = meta31828;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31829,meta31828__$1){
var self__ = this;
var _31829__$1 = this;
return (new cljs.core.async.t_cljs$core$async31827(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31828__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31829){
var self__ = this;
var _31829__$1 = this;
return self__.meta31828;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31828","meta31828",1655046407,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31827.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31827.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31827";

cljs.core.async.t_cljs$core$async31827.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async31827");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31827 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31827(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31828){
return (new cljs.core.async.t_cljs$core$async31827(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31828));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31827(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30946__auto___31991 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___31991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___31991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31931){
var state_val_31932 = (state_31931[(1)]);
if((state_val_31932 === (7))){
var inst_31846 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
var statearr_31933_31992 = state_31931__$1;
(statearr_31933_31992[(2)] = inst_31846);

(statearr_31933_31992[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (20))){
var inst_31858 = (state_31931[(7)]);
var state_31931__$1 = state_31931;
var statearr_31934_31993 = state_31931__$1;
(statearr_31934_31993[(2)] = inst_31858);

(statearr_31934_31993[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (27))){
var state_31931__$1 = state_31931;
var statearr_31935_31994 = state_31931__$1;
(statearr_31935_31994[(2)] = null);

(statearr_31935_31994[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (1))){
var inst_31833 = (state_31931[(8)]);
var inst_31833__$1 = calc_state.call(null);
var inst_31835 = (inst_31833__$1 == null);
var inst_31836 = cljs.core.not.call(null,inst_31835);
var state_31931__$1 = (function (){var statearr_31936 = state_31931;
(statearr_31936[(8)] = inst_31833__$1);

return statearr_31936;
})();
if(inst_31836){
var statearr_31937_31995 = state_31931__$1;
(statearr_31937_31995[(1)] = (2));

} else {
var statearr_31938_31996 = state_31931__$1;
(statearr_31938_31996[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (24))){
var inst_31905 = (state_31931[(9)]);
var inst_31882 = (state_31931[(10)]);
var inst_31891 = (state_31931[(11)]);
var inst_31905__$1 = inst_31882.call(null,inst_31891);
var state_31931__$1 = (function (){var statearr_31939 = state_31931;
(statearr_31939[(9)] = inst_31905__$1);

return statearr_31939;
})();
if(cljs.core.truth_(inst_31905__$1)){
var statearr_31940_31997 = state_31931__$1;
(statearr_31940_31997[(1)] = (29));

} else {
var statearr_31941_31998 = state_31931__$1;
(statearr_31941_31998[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (4))){
var inst_31849 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
if(cljs.core.truth_(inst_31849)){
var statearr_31942_31999 = state_31931__$1;
(statearr_31942_31999[(1)] = (8));

} else {
var statearr_31943_32000 = state_31931__$1;
(statearr_31943_32000[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (15))){
var inst_31876 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
if(cljs.core.truth_(inst_31876)){
var statearr_31944_32001 = state_31931__$1;
(statearr_31944_32001[(1)] = (19));

} else {
var statearr_31945_32002 = state_31931__$1;
(statearr_31945_32002[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (21))){
var inst_31881 = (state_31931[(12)]);
var inst_31881__$1 = (state_31931[(2)]);
var inst_31882 = cljs.core.get.call(null,inst_31881__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31883 = cljs.core.get.call(null,inst_31881__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31884 = cljs.core.get.call(null,inst_31881__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31931__$1 = (function (){var statearr_31946 = state_31931;
(statearr_31946[(13)] = inst_31883);

(statearr_31946[(12)] = inst_31881__$1);

(statearr_31946[(10)] = inst_31882);

return statearr_31946;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31931__$1,(22),inst_31884);
} else {
if((state_val_31932 === (31))){
var inst_31913 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
if(cljs.core.truth_(inst_31913)){
var statearr_31947_32003 = state_31931__$1;
(statearr_31947_32003[(1)] = (32));

} else {
var statearr_31948_32004 = state_31931__$1;
(statearr_31948_32004[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (32))){
var inst_31890 = (state_31931[(14)]);
var state_31931__$1 = state_31931;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31931__$1,(35),out,inst_31890);
} else {
if((state_val_31932 === (33))){
var inst_31881 = (state_31931[(12)]);
var inst_31858 = inst_31881;
var state_31931__$1 = (function (){var statearr_31949 = state_31931;
(statearr_31949[(7)] = inst_31858);

return statearr_31949;
})();
var statearr_31950_32005 = state_31931__$1;
(statearr_31950_32005[(2)] = null);

(statearr_31950_32005[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (13))){
var inst_31858 = (state_31931[(7)]);
var inst_31865 = inst_31858.cljs$lang$protocol_mask$partition0$;
var inst_31866 = (inst_31865 & (64));
var inst_31867 = inst_31858.cljs$core$ISeq$;
var inst_31868 = (cljs.core.PROTOCOL_SENTINEL === inst_31867);
var inst_31869 = (inst_31866) || (inst_31868);
var state_31931__$1 = state_31931;
if(cljs.core.truth_(inst_31869)){
var statearr_31951_32006 = state_31931__$1;
(statearr_31951_32006[(1)] = (16));

} else {
var statearr_31952_32007 = state_31931__$1;
(statearr_31952_32007[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (22))){
var inst_31891 = (state_31931[(11)]);
var inst_31890 = (state_31931[(14)]);
var inst_31889 = (state_31931[(2)]);
var inst_31890__$1 = cljs.core.nth.call(null,inst_31889,(0),null);
var inst_31891__$1 = cljs.core.nth.call(null,inst_31889,(1),null);
var inst_31892 = (inst_31890__$1 == null);
var inst_31893 = cljs.core._EQ_.call(null,inst_31891__$1,change);
var inst_31894 = (inst_31892) || (inst_31893);
var state_31931__$1 = (function (){var statearr_31953 = state_31931;
(statearr_31953[(11)] = inst_31891__$1);

(statearr_31953[(14)] = inst_31890__$1);

return statearr_31953;
})();
if(cljs.core.truth_(inst_31894)){
var statearr_31954_32008 = state_31931__$1;
(statearr_31954_32008[(1)] = (23));

} else {
var statearr_31955_32009 = state_31931__$1;
(statearr_31955_32009[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (36))){
var inst_31881 = (state_31931[(12)]);
var inst_31858 = inst_31881;
var state_31931__$1 = (function (){var statearr_31956 = state_31931;
(statearr_31956[(7)] = inst_31858);

return statearr_31956;
})();
var statearr_31957_32010 = state_31931__$1;
(statearr_31957_32010[(2)] = null);

(statearr_31957_32010[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (29))){
var inst_31905 = (state_31931[(9)]);
var state_31931__$1 = state_31931;
var statearr_31958_32011 = state_31931__$1;
(statearr_31958_32011[(2)] = inst_31905);

(statearr_31958_32011[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (6))){
var state_31931__$1 = state_31931;
var statearr_31959_32012 = state_31931__$1;
(statearr_31959_32012[(2)] = false);

(statearr_31959_32012[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (28))){
var inst_31901 = (state_31931[(2)]);
var inst_31902 = calc_state.call(null);
var inst_31858 = inst_31902;
var state_31931__$1 = (function (){var statearr_31960 = state_31931;
(statearr_31960[(7)] = inst_31858);

(statearr_31960[(15)] = inst_31901);

return statearr_31960;
})();
var statearr_31961_32013 = state_31931__$1;
(statearr_31961_32013[(2)] = null);

(statearr_31961_32013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (25))){
var inst_31927 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
var statearr_31962_32014 = state_31931__$1;
(statearr_31962_32014[(2)] = inst_31927);

(statearr_31962_32014[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (34))){
var inst_31925 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
var statearr_31963_32015 = state_31931__$1;
(statearr_31963_32015[(2)] = inst_31925);

(statearr_31963_32015[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (17))){
var state_31931__$1 = state_31931;
var statearr_31964_32016 = state_31931__$1;
(statearr_31964_32016[(2)] = false);

(statearr_31964_32016[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (3))){
var state_31931__$1 = state_31931;
var statearr_31965_32017 = state_31931__$1;
(statearr_31965_32017[(2)] = false);

(statearr_31965_32017[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (12))){
var inst_31929 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31931__$1,inst_31929);
} else {
if((state_val_31932 === (2))){
var inst_31833 = (state_31931[(8)]);
var inst_31838 = inst_31833.cljs$lang$protocol_mask$partition0$;
var inst_31839 = (inst_31838 & (64));
var inst_31840 = inst_31833.cljs$core$ISeq$;
var inst_31841 = (cljs.core.PROTOCOL_SENTINEL === inst_31840);
var inst_31842 = (inst_31839) || (inst_31841);
var state_31931__$1 = state_31931;
if(cljs.core.truth_(inst_31842)){
var statearr_31966_32018 = state_31931__$1;
(statearr_31966_32018[(1)] = (5));

} else {
var statearr_31967_32019 = state_31931__$1;
(statearr_31967_32019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (23))){
var inst_31890 = (state_31931[(14)]);
var inst_31896 = (inst_31890 == null);
var state_31931__$1 = state_31931;
if(cljs.core.truth_(inst_31896)){
var statearr_31968_32020 = state_31931__$1;
(statearr_31968_32020[(1)] = (26));

} else {
var statearr_31969_32021 = state_31931__$1;
(statearr_31969_32021[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (35))){
var inst_31916 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
if(cljs.core.truth_(inst_31916)){
var statearr_31970_32022 = state_31931__$1;
(statearr_31970_32022[(1)] = (36));

} else {
var statearr_31971_32023 = state_31931__$1;
(statearr_31971_32023[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (19))){
var inst_31858 = (state_31931[(7)]);
var inst_31878 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31858);
var state_31931__$1 = state_31931;
var statearr_31972_32024 = state_31931__$1;
(statearr_31972_32024[(2)] = inst_31878);

(statearr_31972_32024[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (11))){
var inst_31858 = (state_31931[(7)]);
var inst_31862 = (inst_31858 == null);
var inst_31863 = cljs.core.not.call(null,inst_31862);
var state_31931__$1 = state_31931;
if(inst_31863){
var statearr_31973_32025 = state_31931__$1;
(statearr_31973_32025[(1)] = (13));

} else {
var statearr_31974_32026 = state_31931__$1;
(statearr_31974_32026[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (9))){
var inst_31833 = (state_31931[(8)]);
var state_31931__$1 = state_31931;
var statearr_31975_32027 = state_31931__$1;
(statearr_31975_32027[(2)] = inst_31833);

(statearr_31975_32027[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (5))){
var state_31931__$1 = state_31931;
var statearr_31976_32028 = state_31931__$1;
(statearr_31976_32028[(2)] = true);

(statearr_31976_32028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (14))){
var state_31931__$1 = state_31931;
var statearr_31977_32029 = state_31931__$1;
(statearr_31977_32029[(2)] = false);

(statearr_31977_32029[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (26))){
var inst_31891 = (state_31931[(11)]);
var inst_31898 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31891);
var state_31931__$1 = state_31931;
var statearr_31978_32030 = state_31931__$1;
(statearr_31978_32030[(2)] = inst_31898);

(statearr_31978_32030[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (16))){
var state_31931__$1 = state_31931;
var statearr_31979_32031 = state_31931__$1;
(statearr_31979_32031[(2)] = true);

(statearr_31979_32031[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (38))){
var inst_31921 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
var statearr_31980_32032 = state_31931__$1;
(statearr_31980_32032[(2)] = inst_31921);

(statearr_31980_32032[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (30))){
var inst_31883 = (state_31931[(13)]);
var inst_31882 = (state_31931[(10)]);
var inst_31891 = (state_31931[(11)]);
var inst_31908 = cljs.core.empty_QMARK_.call(null,inst_31882);
var inst_31909 = inst_31883.call(null,inst_31891);
var inst_31910 = cljs.core.not.call(null,inst_31909);
var inst_31911 = (inst_31908) && (inst_31910);
var state_31931__$1 = state_31931;
var statearr_31981_32033 = state_31931__$1;
(statearr_31981_32033[(2)] = inst_31911);

(statearr_31981_32033[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (10))){
var inst_31833 = (state_31931[(8)]);
var inst_31854 = (state_31931[(2)]);
var inst_31855 = cljs.core.get.call(null,inst_31854,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31856 = cljs.core.get.call(null,inst_31854,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31857 = cljs.core.get.call(null,inst_31854,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31858 = inst_31833;
var state_31931__$1 = (function (){var statearr_31982 = state_31931;
(statearr_31982[(16)] = inst_31856);

(statearr_31982[(17)] = inst_31855);

(statearr_31982[(18)] = inst_31857);

(statearr_31982[(7)] = inst_31858);

return statearr_31982;
})();
var statearr_31983_32034 = state_31931__$1;
(statearr_31983_32034[(2)] = null);

(statearr_31983_32034[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (18))){
var inst_31873 = (state_31931[(2)]);
var state_31931__$1 = state_31931;
var statearr_31984_32035 = state_31931__$1;
(statearr_31984_32035[(2)] = inst_31873);

(statearr_31984_32035[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (37))){
var state_31931__$1 = state_31931;
var statearr_31985_32036 = state_31931__$1;
(statearr_31985_32036[(2)] = null);

(statearr_31985_32036[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31932 === (8))){
var inst_31833 = (state_31931[(8)]);
var inst_31851 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31833);
var state_31931__$1 = state_31931;
var statearr_31986_32037 = state_31931__$1;
(statearr_31986_32037[(2)] = inst_31851);

(statearr_31986_32037[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___31991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__30858__auto__,c__30946__auto___31991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__30859__auto__ = null;
var cljs$core$async$mix_$_state_machine__30859__auto____0 = (function (){
var statearr_31987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31987[(0)] = cljs$core$async$mix_$_state_machine__30859__auto__);

(statearr_31987[(1)] = (1));

return statearr_31987;
});
var cljs$core$async$mix_$_state_machine__30859__auto____1 = (function (state_31931){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_31931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e31988){if((e31988 instanceof Object)){
var ex__30862__auto__ = e31988;
var statearr_31989_32038 = state_31931;
(statearr_31989_32038[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31988;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32039 = state_31931;
state_31931 = G__32039;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30859__auto__ = function(state_31931){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30859__auto____1.call(this,state_31931);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30859__auto____0;
cljs$core$async$mix_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30859__auto____1;
return cljs$core$async$mix_$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___31991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30948__auto__ = (function (){var statearr_31990 = f__30947__auto__.call(null);
(statearr_31990[(6)] = c__30946__auto___31991);

return statearr_31990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___31991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__29031__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32041 = arguments.length;
switch (G__32041) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32045 = arguments.length;
switch (G__32045) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28347__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28347__auto__,mults){
return (function (p1__32043_SHARP_){
if(cljs.core.truth_(p1__32043_SHARP_.call(null,topic))){
return p1__32043_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__32043_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28347__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32046 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32046 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32047){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32047 = meta32047;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32048,meta32047__$1){
var self__ = this;
var _32048__$1 = this;
return (new cljs.core.async.t_cljs$core$async32046(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32047__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32048){
var self__ = this;
var _32048__$1 = this;
return self__.meta32047;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32046.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32046.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32047","meta32047",1763155522,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32046.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32046.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32046";

cljs.core.async.t_cljs$core$async32046.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async32046");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32046 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32046(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32047){
return (new cljs.core.async.t_cljs$core$async32046(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32047));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32046(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30946__auto___32166 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___32166,mults,ensure_mult,p){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___32166,mults,ensure_mult,p){
return (function (state_32120){
var state_val_32121 = (state_32120[(1)]);
if((state_val_32121 === (7))){
var inst_32116 = (state_32120[(2)]);
var state_32120__$1 = state_32120;
var statearr_32122_32167 = state_32120__$1;
(statearr_32122_32167[(2)] = inst_32116);

(statearr_32122_32167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (20))){
var state_32120__$1 = state_32120;
var statearr_32123_32168 = state_32120__$1;
(statearr_32123_32168[(2)] = null);

(statearr_32123_32168[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (1))){
var state_32120__$1 = state_32120;
var statearr_32124_32169 = state_32120__$1;
(statearr_32124_32169[(2)] = null);

(statearr_32124_32169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (24))){
var inst_32099 = (state_32120[(7)]);
var inst_32108 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32099);
var state_32120__$1 = state_32120;
var statearr_32125_32170 = state_32120__$1;
(statearr_32125_32170[(2)] = inst_32108);

(statearr_32125_32170[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (4))){
var inst_32051 = (state_32120[(8)]);
var inst_32051__$1 = (state_32120[(2)]);
var inst_32052 = (inst_32051__$1 == null);
var state_32120__$1 = (function (){var statearr_32126 = state_32120;
(statearr_32126[(8)] = inst_32051__$1);

return statearr_32126;
})();
if(cljs.core.truth_(inst_32052)){
var statearr_32127_32171 = state_32120__$1;
(statearr_32127_32171[(1)] = (5));

} else {
var statearr_32128_32172 = state_32120__$1;
(statearr_32128_32172[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (15))){
var inst_32093 = (state_32120[(2)]);
var state_32120__$1 = state_32120;
var statearr_32129_32173 = state_32120__$1;
(statearr_32129_32173[(2)] = inst_32093);

(statearr_32129_32173[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (21))){
var inst_32113 = (state_32120[(2)]);
var state_32120__$1 = (function (){var statearr_32130 = state_32120;
(statearr_32130[(9)] = inst_32113);

return statearr_32130;
})();
var statearr_32131_32174 = state_32120__$1;
(statearr_32131_32174[(2)] = null);

(statearr_32131_32174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (13))){
var inst_32075 = (state_32120[(10)]);
var inst_32077 = cljs.core.chunked_seq_QMARK_.call(null,inst_32075);
var state_32120__$1 = state_32120;
if(inst_32077){
var statearr_32132_32175 = state_32120__$1;
(statearr_32132_32175[(1)] = (16));

} else {
var statearr_32133_32176 = state_32120__$1;
(statearr_32133_32176[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (22))){
var inst_32105 = (state_32120[(2)]);
var state_32120__$1 = state_32120;
if(cljs.core.truth_(inst_32105)){
var statearr_32134_32177 = state_32120__$1;
(statearr_32134_32177[(1)] = (23));

} else {
var statearr_32135_32178 = state_32120__$1;
(statearr_32135_32178[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (6))){
var inst_32101 = (state_32120[(11)]);
var inst_32099 = (state_32120[(7)]);
var inst_32051 = (state_32120[(8)]);
var inst_32099__$1 = topic_fn.call(null,inst_32051);
var inst_32100 = cljs.core.deref.call(null,mults);
var inst_32101__$1 = cljs.core.get.call(null,inst_32100,inst_32099__$1);
var state_32120__$1 = (function (){var statearr_32136 = state_32120;
(statearr_32136[(11)] = inst_32101__$1);

(statearr_32136[(7)] = inst_32099__$1);

return statearr_32136;
})();
if(cljs.core.truth_(inst_32101__$1)){
var statearr_32137_32179 = state_32120__$1;
(statearr_32137_32179[(1)] = (19));

} else {
var statearr_32138_32180 = state_32120__$1;
(statearr_32138_32180[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (25))){
var inst_32110 = (state_32120[(2)]);
var state_32120__$1 = state_32120;
var statearr_32139_32181 = state_32120__$1;
(statearr_32139_32181[(2)] = inst_32110);

(statearr_32139_32181[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (17))){
var inst_32075 = (state_32120[(10)]);
var inst_32084 = cljs.core.first.call(null,inst_32075);
var inst_32085 = cljs.core.async.muxch_STAR_.call(null,inst_32084);
var inst_32086 = cljs.core.async.close_BANG_.call(null,inst_32085);
var inst_32087 = cljs.core.next.call(null,inst_32075);
var inst_32061 = inst_32087;
var inst_32062 = null;
var inst_32063 = (0);
var inst_32064 = (0);
var state_32120__$1 = (function (){var statearr_32140 = state_32120;
(statearr_32140[(12)] = inst_32064);

(statearr_32140[(13)] = inst_32086);

(statearr_32140[(14)] = inst_32061);

(statearr_32140[(15)] = inst_32062);

(statearr_32140[(16)] = inst_32063);

return statearr_32140;
})();
var statearr_32141_32182 = state_32120__$1;
(statearr_32141_32182[(2)] = null);

(statearr_32141_32182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (3))){
var inst_32118 = (state_32120[(2)]);
var state_32120__$1 = state_32120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32120__$1,inst_32118);
} else {
if((state_val_32121 === (12))){
var inst_32095 = (state_32120[(2)]);
var state_32120__$1 = state_32120;
var statearr_32142_32183 = state_32120__$1;
(statearr_32142_32183[(2)] = inst_32095);

(statearr_32142_32183[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (2))){
var state_32120__$1 = state_32120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32120__$1,(4),ch);
} else {
if((state_val_32121 === (23))){
var state_32120__$1 = state_32120;
var statearr_32143_32184 = state_32120__$1;
(statearr_32143_32184[(2)] = null);

(statearr_32143_32184[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (19))){
var inst_32101 = (state_32120[(11)]);
var inst_32051 = (state_32120[(8)]);
var inst_32103 = cljs.core.async.muxch_STAR_.call(null,inst_32101);
var state_32120__$1 = state_32120;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32120__$1,(22),inst_32103,inst_32051);
} else {
if((state_val_32121 === (11))){
var inst_32075 = (state_32120[(10)]);
var inst_32061 = (state_32120[(14)]);
var inst_32075__$1 = cljs.core.seq.call(null,inst_32061);
var state_32120__$1 = (function (){var statearr_32144 = state_32120;
(statearr_32144[(10)] = inst_32075__$1);

return statearr_32144;
})();
if(inst_32075__$1){
var statearr_32145_32185 = state_32120__$1;
(statearr_32145_32185[(1)] = (13));

} else {
var statearr_32146_32186 = state_32120__$1;
(statearr_32146_32186[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (9))){
var inst_32097 = (state_32120[(2)]);
var state_32120__$1 = state_32120;
var statearr_32147_32187 = state_32120__$1;
(statearr_32147_32187[(2)] = inst_32097);

(statearr_32147_32187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (5))){
var inst_32058 = cljs.core.deref.call(null,mults);
var inst_32059 = cljs.core.vals.call(null,inst_32058);
var inst_32060 = cljs.core.seq.call(null,inst_32059);
var inst_32061 = inst_32060;
var inst_32062 = null;
var inst_32063 = (0);
var inst_32064 = (0);
var state_32120__$1 = (function (){var statearr_32148 = state_32120;
(statearr_32148[(12)] = inst_32064);

(statearr_32148[(14)] = inst_32061);

(statearr_32148[(15)] = inst_32062);

(statearr_32148[(16)] = inst_32063);

return statearr_32148;
})();
var statearr_32149_32188 = state_32120__$1;
(statearr_32149_32188[(2)] = null);

(statearr_32149_32188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (14))){
var state_32120__$1 = state_32120;
var statearr_32153_32189 = state_32120__$1;
(statearr_32153_32189[(2)] = null);

(statearr_32153_32189[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (16))){
var inst_32075 = (state_32120[(10)]);
var inst_32079 = cljs.core.chunk_first.call(null,inst_32075);
var inst_32080 = cljs.core.chunk_rest.call(null,inst_32075);
var inst_32081 = cljs.core.count.call(null,inst_32079);
var inst_32061 = inst_32080;
var inst_32062 = inst_32079;
var inst_32063 = inst_32081;
var inst_32064 = (0);
var state_32120__$1 = (function (){var statearr_32154 = state_32120;
(statearr_32154[(12)] = inst_32064);

(statearr_32154[(14)] = inst_32061);

(statearr_32154[(15)] = inst_32062);

(statearr_32154[(16)] = inst_32063);

return statearr_32154;
})();
var statearr_32155_32190 = state_32120__$1;
(statearr_32155_32190[(2)] = null);

(statearr_32155_32190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (10))){
var inst_32064 = (state_32120[(12)]);
var inst_32061 = (state_32120[(14)]);
var inst_32062 = (state_32120[(15)]);
var inst_32063 = (state_32120[(16)]);
var inst_32069 = cljs.core._nth.call(null,inst_32062,inst_32064);
var inst_32070 = cljs.core.async.muxch_STAR_.call(null,inst_32069);
var inst_32071 = cljs.core.async.close_BANG_.call(null,inst_32070);
var inst_32072 = (inst_32064 + (1));
var tmp32150 = inst_32061;
var tmp32151 = inst_32062;
var tmp32152 = inst_32063;
var inst_32061__$1 = tmp32150;
var inst_32062__$1 = tmp32151;
var inst_32063__$1 = tmp32152;
var inst_32064__$1 = inst_32072;
var state_32120__$1 = (function (){var statearr_32156 = state_32120;
(statearr_32156[(12)] = inst_32064__$1);

(statearr_32156[(17)] = inst_32071);

(statearr_32156[(14)] = inst_32061__$1);

(statearr_32156[(15)] = inst_32062__$1);

(statearr_32156[(16)] = inst_32063__$1);

return statearr_32156;
})();
var statearr_32157_32191 = state_32120__$1;
(statearr_32157_32191[(2)] = null);

(statearr_32157_32191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (18))){
var inst_32090 = (state_32120[(2)]);
var state_32120__$1 = state_32120;
var statearr_32158_32192 = state_32120__$1;
(statearr_32158_32192[(2)] = inst_32090);

(statearr_32158_32192[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32121 === (8))){
var inst_32064 = (state_32120[(12)]);
var inst_32063 = (state_32120[(16)]);
var inst_32066 = (inst_32064 < inst_32063);
var inst_32067 = inst_32066;
var state_32120__$1 = state_32120;
if(cljs.core.truth_(inst_32067)){
var statearr_32159_32193 = state_32120__$1;
(statearr_32159_32193[(1)] = (10));

} else {
var statearr_32160_32194 = state_32120__$1;
(statearr_32160_32194[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___32166,mults,ensure_mult,p))
;
return ((function (switch__30858__auto__,c__30946__auto___32166,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_32161 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32161[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_32161[(1)] = (1));

return statearr_32161;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_32120){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32162){if((e32162 instanceof Object)){
var ex__30862__auto__ = e32162;
var statearr_32163_32195 = state_32120;
(statearr_32163_32195[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32162;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32196 = state_32120;
state_32120 = G__32196;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_32120){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_32120);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___32166,mults,ensure_mult,p))
})();
var state__30948__auto__ = (function (){var statearr_32164 = f__30947__auto__.call(null);
(statearr_32164[(6)] = c__30946__auto___32166);

return statearr_32164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___32166,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32198 = arguments.length;
switch (G__32198) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32201 = arguments.length;
switch (G__32201) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32204 = arguments.length;
switch (G__32204) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30946__auto___32271 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___32271,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___32271,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32243){
var state_val_32244 = (state_32243[(1)]);
if((state_val_32244 === (7))){
var state_32243__$1 = state_32243;
var statearr_32245_32272 = state_32243__$1;
(statearr_32245_32272[(2)] = null);

(statearr_32245_32272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (1))){
var state_32243__$1 = state_32243;
var statearr_32246_32273 = state_32243__$1;
(statearr_32246_32273[(2)] = null);

(statearr_32246_32273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (4))){
var inst_32207 = (state_32243[(7)]);
var inst_32209 = (inst_32207 < cnt);
var state_32243__$1 = state_32243;
if(cljs.core.truth_(inst_32209)){
var statearr_32247_32274 = state_32243__$1;
(statearr_32247_32274[(1)] = (6));

} else {
var statearr_32248_32275 = state_32243__$1;
(statearr_32248_32275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (15))){
var inst_32239 = (state_32243[(2)]);
var state_32243__$1 = state_32243;
var statearr_32249_32276 = state_32243__$1;
(statearr_32249_32276[(2)] = inst_32239);

(statearr_32249_32276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (13))){
var inst_32232 = cljs.core.async.close_BANG_.call(null,out);
var state_32243__$1 = state_32243;
var statearr_32250_32277 = state_32243__$1;
(statearr_32250_32277[(2)] = inst_32232);

(statearr_32250_32277[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (6))){
var state_32243__$1 = state_32243;
var statearr_32251_32278 = state_32243__$1;
(statearr_32251_32278[(2)] = null);

(statearr_32251_32278[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (3))){
var inst_32241 = (state_32243[(2)]);
var state_32243__$1 = state_32243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32243__$1,inst_32241);
} else {
if((state_val_32244 === (12))){
var inst_32229 = (state_32243[(8)]);
var inst_32229__$1 = (state_32243[(2)]);
var inst_32230 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32229__$1);
var state_32243__$1 = (function (){var statearr_32252 = state_32243;
(statearr_32252[(8)] = inst_32229__$1);

return statearr_32252;
})();
if(cljs.core.truth_(inst_32230)){
var statearr_32253_32279 = state_32243__$1;
(statearr_32253_32279[(1)] = (13));

} else {
var statearr_32254_32280 = state_32243__$1;
(statearr_32254_32280[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (2))){
var inst_32206 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32207 = (0);
var state_32243__$1 = (function (){var statearr_32255 = state_32243;
(statearr_32255[(7)] = inst_32207);

(statearr_32255[(9)] = inst_32206);

return statearr_32255;
})();
var statearr_32256_32281 = state_32243__$1;
(statearr_32256_32281[(2)] = null);

(statearr_32256_32281[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (11))){
var inst_32207 = (state_32243[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32243,(10),Object,null,(9));
var inst_32216 = chs__$1.call(null,inst_32207);
var inst_32217 = done.call(null,inst_32207);
var inst_32218 = cljs.core.async.take_BANG_.call(null,inst_32216,inst_32217);
var state_32243__$1 = state_32243;
var statearr_32257_32282 = state_32243__$1;
(statearr_32257_32282[(2)] = inst_32218);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32243__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (9))){
var inst_32207 = (state_32243[(7)]);
var inst_32220 = (state_32243[(2)]);
var inst_32221 = (inst_32207 + (1));
var inst_32207__$1 = inst_32221;
var state_32243__$1 = (function (){var statearr_32258 = state_32243;
(statearr_32258[(7)] = inst_32207__$1);

(statearr_32258[(10)] = inst_32220);

return statearr_32258;
})();
var statearr_32259_32283 = state_32243__$1;
(statearr_32259_32283[(2)] = null);

(statearr_32259_32283[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (5))){
var inst_32227 = (state_32243[(2)]);
var state_32243__$1 = (function (){var statearr_32260 = state_32243;
(statearr_32260[(11)] = inst_32227);

return statearr_32260;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32243__$1,(12),dchan);
} else {
if((state_val_32244 === (14))){
var inst_32229 = (state_32243[(8)]);
var inst_32234 = cljs.core.apply.call(null,f,inst_32229);
var state_32243__$1 = state_32243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32243__$1,(16),out,inst_32234);
} else {
if((state_val_32244 === (16))){
var inst_32236 = (state_32243[(2)]);
var state_32243__$1 = (function (){var statearr_32261 = state_32243;
(statearr_32261[(12)] = inst_32236);

return statearr_32261;
})();
var statearr_32262_32284 = state_32243__$1;
(statearr_32262_32284[(2)] = null);

(statearr_32262_32284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (10))){
var inst_32211 = (state_32243[(2)]);
var inst_32212 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32243__$1 = (function (){var statearr_32263 = state_32243;
(statearr_32263[(13)] = inst_32211);

return statearr_32263;
})();
var statearr_32264_32285 = state_32243__$1;
(statearr_32264_32285[(2)] = inst_32212);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32243__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32244 === (8))){
var inst_32225 = (state_32243[(2)]);
var state_32243__$1 = state_32243;
var statearr_32265_32286 = state_32243__$1;
(statearr_32265_32286[(2)] = inst_32225);

(statearr_32265_32286[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___32271,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__30858__auto__,c__30946__auto___32271,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_32266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32266[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_32266[(1)] = (1));

return statearr_32266;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_32243){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32267){if((e32267 instanceof Object)){
var ex__30862__auto__ = e32267;
var statearr_32268_32287 = state_32243;
(statearr_32268_32287[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32267;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32288 = state_32243;
state_32243 = G__32288;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_32243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_32243);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___32271,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30948__auto__ = (function (){var statearr_32269 = f__30947__auto__.call(null);
(statearr_32269[(6)] = c__30946__auto___32271);

return statearr_32269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___32271,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32291 = arguments.length;
switch (G__32291) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30946__auto___32345 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___32345,out){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___32345,out){
return (function (state_32323){
var state_val_32324 = (state_32323[(1)]);
if((state_val_32324 === (7))){
var inst_32303 = (state_32323[(7)]);
var inst_32302 = (state_32323[(8)]);
var inst_32302__$1 = (state_32323[(2)]);
var inst_32303__$1 = cljs.core.nth.call(null,inst_32302__$1,(0),null);
var inst_32304 = cljs.core.nth.call(null,inst_32302__$1,(1),null);
var inst_32305 = (inst_32303__$1 == null);
var state_32323__$1 = (function (){var statearr_32325 = state_32323;
(statearr_32325[(7)] = inst_32303__$1);

(statearr_32325[(8)] = inst_32302__$1);

(statearr_32325[(9)] = inst_32304);

return statearr_32325;
})();
if(cljs.core.truth_(inst_32305)){
var statearr_32326_32346 = state_32323__$1;
(statearr_32326_32346[(1)] = (8));

} else {
var statearr_32327_32347 = state_32323__$1;
(statearr_32327_32347[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32324 === (1))){
var inst_32292 = cljs.core.vec.call(null,chs);
var inst_32293 = inst_32292;
var state_32323__$1 = (function (){var statearr_32328 = state_32323;
(statearr_32328[(10)] = inst_32293);

return statearr_32328;
})();
var statearr_32329_32348 = state_32323__$1;
(statearr_32329_32348[(2)] = null);

(statearr_32329_32348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32324 === (4))){
var inst_32293 = (state_32323[(10)]);
var state_32323__$1 = state_32323;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32323__$1,(7),inst_32293);
} else {
if((state_val_32324 === (6))){
var inst_32319 = (state_32323[(2)]);
var state_32323__$1 = state_32323;
var statearr_32330_32349 = state_32323__$1;
(statearr_32330_32349[(2)] = inst_32319);

(statearr_32330_32349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32324 === (3))){
var inst_32321 = (state_32323[(2)]);
var state_32323__$1 = state_32323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32323__$1,inst_32321);
} else {
if((state_val_32324 === (2))){
var inst_32293 = (state_32323[(10)]);
var inst_32295 = cljs.core.count.call(null,inst_32293);
var inst_32296 = (inst_32295 > (0));
var state_32323__$1 = state_32323;
if(cljs.core.truth_(inst_32296)){
var statearr_32332_32350 = state_32323__$1;
(statearr_32332_32350[(1)] = (4));

} else {
var statearr_32333_32351 = state_32323__$1;
(statearr_32333_32351[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32324 === (11))){
var inst_32293 = (state_32323[(10)]);
var inst_32312 = (state_32323[(2)]);
var tmp32331 = inst_32293;
var inst_32293__$1 = tmp32331;
var state_32323__$1 = (function (){var statearr_32334 = state_32323;
(statearr_32334[(10)] = inst_32293__$1);

(statearr_32334[(11)] = inst_32312);

return statearr_32334;
})();
var statearr_32335_32352 = state_32323__$1;
(statearr_32335_32352[(2)] = null);

(statearr_32335_32352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32324 === (9))){
var inst_32303 = (state_32323[(7)]);
var state_32323__$1 = state_32323;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32323__$1,(11),out,inst_32303);
} else {
if((state_val_32324 === (5))){
var inst_32317 = cljs.core.async.close_BANG_.call(null,out);
var state_32323__$1 = state_32323;
var statearr_32336_32353 = state_32323__$1;
(statearr_32336_32353[(2)] = inst_32317);

(statearr_32336_32353[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32324 === (10))){
var inst_32315 = (state_32323[(2)]);
var state_32323__$1 = state_32323;
var statearr_32337_32354 = state_32323__$1;
(statearr_32337_32354[(2)] = inst_32315);

(statearr_32337_32354[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32324 === (8))){
var inst_32303 = (state_32323[(7)]);
var inst_32293 = (state_32323[(10)]);
var inst_32302 = (state_32323[(8)]);
var inst_32304 = (state_32323[(9)]);
var inst_32307 = (function (){var cs = inst_32293;
var vec__32298 = inst_32302;
var v = inst_32303;
var c = inst_32304;
return ((function (cs,vec__32298,v,c,inst_32303,inst_32293,inst_32302,inst_32304,state_val_32324,c__30946__auto___32345,out){
return (function (p1__32289_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32289_SHARP_);
});
;})(cs,vec__32298,v,c,inst_32303,inst_32293,inst_32302,inst_32304,state_val_32324,c__30946__auto___32345,out))
})();
var inst_32308 = cljs.core.filterv.call(null,inst_32307,inst_32293);
var inst_32293__$1 = inst_32308;
var state_32323__$1 = (function (){var statearr_32338 = state_32323;
(statearr_32338[(10)] = inst_32293__$1);

return statearr_32338;
})();
var statearr_32339_32355 = state_32323__$1;
(statearr_32339_32355[(2)] = null);

(statearr_32339_32355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___32345,out))
;
return ((function (switch__30858__auto__,c__30946__auto___32345,out){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_32340 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32340[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_32340[(1)] = (1));

return statearr_32340;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_32323){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32341){if((e32341 instanceof Object)){
var ex__30862__auto__ = e32341;
var statearr_32342_32356 = state_32323;
(statearr_32342_32356[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32323);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32341;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32357 = state_32323;
state_32323 = G__32357;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_32323){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_32323);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___32345,out))
})();
var state__30948__auto__ = (function (){var statearr_32343 = f__30947__auto__.call(null);
(statearr_32343[(6)] = c__30946__auto___32345);

return statearr_32343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___32345,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32359 = arguments.length;
switch (G__32359) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30946__auto___32404 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___32404,out){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___32404,out){
return (function (state_32383){
var state_val_32384 = (state_32383[(1)]);
if((state_val_32384 === (7))){
var inst_32365 = (state_32383[(7)]);
var inst_32365__$1 = (state_32383[(2)]);
var inst_32366 = (inst_32365__$1 == null);
var inst_32367 = cljs.core.not.call(null,inst_32366);
var state_32383__$1 = (function (){var statearr_32385 = state_32383;
(statearr_32385[(7)] = inst_32365__$1);

return statearr_32385;
})();
if(inst_32367){
var statearr_32386_32405 = state_32383__$1;
(statearr_32386_32405[(1)] = (8));

} else {
var statearr_32387_32406 = state_32383__$1;
(statearr_32387_32406[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32384 === (1))){
var inst_32360 = (0);
var state_32383__$1 = (function (){var statearr_32388 = state_32383;
(statearr_32388[(8)] = inst_32360);

return statearr_32388;
})();
var statearr_32389_32407 = state_32383__$1;
(statearr_32389_32407[(2)] = null);

(statearr_32389_32407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32384 === (4))){
var state_32383__$1 = state_32383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32383__$1,(7),ch);
} else {
if((state_val_32384 === (6))){
var inst_32378 = (state_32383[(2)]);
var state_32383__$1 = state_32383;
var statearr_32390_32408 = state_32383__$1;
(statearr_32390_32408[(2)] = inst_32378);

(statearr_32390_32408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32384 === (3))){
var inst_32380 = (state_32383[(2)]);
var inst_32381 = cljs.core.async.close_BANG_.call(null,out);
var state_32383__$1 = (function (){var statearr_32391 = state_32383;
(statearr_32391[(9)] = inst_32380);

return statearr_32391;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32383__$1,inst_32381);
} else {
if((state_val_32384 === (2))){
var inst_32360 = (state_32383[(8)]);
var inst_32362 = (inst_32360 < n);
var state_32383__$1 = state_32383;
if(cljs.core.truth_(inst_32362)){
var statearr_32392_32409 = state_32383__$1;
(statearr_32392_32409[(1)] = (4));

} else {
var statearr_32393_32410 = state_32383__$1;
(statearr_32393_32410[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32384 === (11))){
var inst_32360 = (state_32383[(8)]);
var inst_32370 = (state_32383[(2)]);
var inst_32371 = (inst_32360 + (1));
var inst_32360__$1 = inst_32371;
var state_32383__$1 = (function (){var statearr_32394 = state_32383;
(statearr_32394[(10)] = inst_32370);

(statearr_32394[(8)] = inst_32360__$1);

return statearr_32394;
})();
var statearr_32395_32411 = state_32383__$1;
(statearr_32395_32411[(2)] = null);

(statearr_32395_32411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32384 === (9))){
var state_32383__$1 = state_32383;
var statearr_32396_32412 = state_32383__$1;
(statearr_32396_32412[(2)] = null);

(statearr_32396_32412[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32384 === (5))){
var state_32383__$1 = state_32383;
var statearr_32397_32413 = state_32383__$1;
(statearr_32397_32413[(2)] = null);

(statearr_32397_32413[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32384 === (10))){
var inst_32375 = (state_32383[(2)]);
var state_32383__$1 = state_32383;
var statearr_32398_32414 = state_32383__$1;
(statearr_32398_32414[(2)] = inst_32375);

(statearr_32398_32414[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32384 === (8))){
var inst_32365 = (state_32383[(7)]);
var state_32383__$1 = state_32383;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32383__$1,(11),out,inst_32365);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___32404,out))
;
return ((function (switch__30858__auto__,c__30946__auto___32404,out){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_32399 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32399[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_32399[(1)] = (1));

return statearr_32399;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_32383){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32400){if((e32400 instanceof Object)){
var ex__30862__auto__ = e32400;
var statearr_32401_32415 = state_32383;
(statearr_32401_32415[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32383);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32400;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32416 = state_32383;
state_32383 = G__32416;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_32383){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_32383);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___32404,out))
})();
var state__30948__auto__ = (function (){var statearr_32402 = f__30947__auto__.call(null);
(statearr_32402[(6)] = c__30946__auto___32404);

return statearr_32402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___32404,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32418 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32418 = (function (f,ch,meta32419){
this.f = f;
this.ch = ch;
this.meta32419 = meta32419;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32420,meta32419__$1){
var self__ = this;
var _32420__$1 = this;
return (new cljs.core.async.t_cljs$core$async32418(self__.f,self__.ch,meta32419__$1));
});

cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32420){
var self__ = this;
var _32420__$1 = this;
return self__.meta32419;
});

cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32421 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32421 = (function (f,ch,meta32419,_,fn1,meta32422){
this.f = f;
this.ch = ch;
this.meta32419 = meta32419;
this._ = _;
this.fn1 = fn1;
this.meta32422 = meta32422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32423,meta32422__$1){
var self__ = this;
var _32423__$1 = this;
return (new cljs.core.async.t_cljs$core$async32421(self__.f,self__.ch,self__.meta32419,self__._,self__.fn1,meta32422__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32423){
var self__ = this;
var _32423__$1 = this;
return self__.meta32422;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32417_SHARP_){
return f1.call(null,(((p1__32417_SHARP_ == null))?null:self__.f.call(null,p1__32417_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32421.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32419","meta32419",-1868550293,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32418","cljs.core.async/t_cljs$core$async32418",-486510406,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32422","meta32422",-1284506072,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32421.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32421";

cljs.core.async.t_cljs$core$async32421.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async32421");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32421 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32421(f__$1,ch__$1,meta32419__$1,___$2,fn1__$1,meta32422){
return (new cljs.core.async.t_cljs$core$async32421(f__$1,ch__$1,meta32419__$1,___$2,fn1__$1,meta32422));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32421(self__.f,self__.ch,self__.meta32419,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28335__auto__ = ret;
if(cljs.core.truth_(and__28335__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28335__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32418.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32418.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32419","meta32419",-1868550293,null)], null);
});

cljs.core.async.t_cljs$core$async32418.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32418.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32418";

cljs.core.async.t_cljs$core$async32418.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async32418");
});

cljs.core.async.__GT_t_cljs$core$async32418 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32418(f__$1,ch__$1,meta32419){
return (new cljs.core.async.t_cljs$core$async32418(f__$1,ch__$1,meta32419));
});

}

return (new cljs.core.async.t_cljs$core$async32418(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32424 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32424 = (function (f,ch,meta32425){
this.f = f;
this.ch = ch;
this.meta32425 = meta32425;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32426,meta32425__$1){
var self__ = this;
var _32426__$1 = this;
return (new cljs.core.async.t_cljs$core$async32424(self__.f,self__.ch,meta32425__$1));
});

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32426){
var self__ = this;
var _32426__$1 = this;
return self__.meta32425;
});

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32424.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32425","meta32425",1287755393,null)], null);
});

cljs.core.async.t_cljs$core$async32424.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32424.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32424";

cljs.core.async.t_cljs$core$async32424.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async32424");
});

cljs.core.async.__GT_t_cljs$core$async32424 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32424(f__$1,ch__$1,meta32425){
return (new cljs.core.async.t_cljs$core$async32424(f__$1,ch__$1,meta32425));
});

}

return (new cljs.core.async.t_cljs$core$async32424(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32427 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32427 = (function (p,ch,meta32428){
this.p = p;
this.ch = ch;
this.meta32428 = meta32428;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32429,meta32428__$1){
var self__ = this;
var _32429__$1 = this;
return (new cljs.core.async.t_cljs$core$async32427(self__.p,self__.ch,meta32428__$1));
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32429){
var self__ = this;
var _32429__$1 = this;
return self__.meta32428;
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32427.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32428","meta32428",1933681999,null)], null);
});

cljs.core.async.t_cljs$core$async32427.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32427.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32427";

cljs.core.async.t_cljs$core$async32427.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async32427");
});

cljs.core.async.__GT_t_cljs$core$async32427 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32427(p__$1,ch__$1,meta32428){
return (new cljs.core.async.t_cljs$core$async32427(p__$1,ch__$1,meta32428));
});

}

return (new cljs.core.async.t_cljs$core$async32427(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32431 = arguments.length;
switch (G__32431) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30946__auto___32471 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___32471,out){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___32471,out){
return (function (state_32452){
var state_val_32453 = (state_32452[(1)]);
if((state_val_32453 === (7))){
var inst_32448 = (state_32452[(2)]);
var state_32452__$1 = state_32452;
var statearr_32454_32472 = state_32452__$1;
(statearr_32454_32472[(2)] = inst_32448);

(statearr_32454_32472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32453 === (1))){
var state_32452__$1 = state_32452;
var statearr_32455_32473 = state_32452__$1;
(statearr_32455_32473[(2)] = null);

(statearr_32455_32473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32453 === (4))){
var inst_32434 = (state_32452[(7)]);
var inst_32434__$1 = (state_32452[(2)]);
var inst_32435 = (inst_32434__$1 == null);
var state_32452__$1 = (function (){var statearr_32456 = state_32452;
(statearr_32456[(7)] = inst_32434__$1);

return statearr_32456;
})();
if(cljs.core.truth_(inst_32435)){
var statearr_32457_32474 = state_32452__$1;
(statearr_32457_32474[(1)] = (5));

} else {
var statearr_32458_32475 = state_32452__$1;
(statearr_32458_32475[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32453 === (6))){
var inst_32434 = (state_32452[(7)]);
var inst_32439 = p.call(null,inst_32434);
var state_32452__$1 = state_32452;
if(cljs.core.truth_(inst_32439)){
var statearr_32459_32476 = state_32452__$1;
(statearr_32459_32476[(1)] = (8));

} else {
var statearr_32460_32477 = state_32452__$1;
(statearr_32460_32477[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32453 === (3))){
var inst_32450 = (state_32452[(2)]);
var state_32452__$1 = state_32452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32452__$1,inst_32450);
} else {
if((state_val_32453 === (2))){
var state_32452__$1 = state_32452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32452__$1,(4),ch);
} else {
if((state_val_32453 === (11))){
var inst_32442 = (state_32452[(2)]);
var state_32452__$1 = state_32452;
var statearr_32461_32478 = state_32452__$1;
(statearr_32461_32478[(2)] = inst_32442);

(statearr_32461_32478[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32453 === (9))){
var state_32452__$1 = state_32452;
var statearr_32462_32479 = state_32452__$1;
(statearr_32462_32479[(2)] = null);

(statearr_32462_32479[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32453 === (5))){
var inst_32437 = cljs.core.async.close_BANG_.call(null,out);
var state_32452__$1 = state_32452;
var statearr_32463_32480 = state_32452__$1;
(statearr_32463_32480[(2)] = inst_32437);

(statearr_32463_32480[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32453 === (10))){
var inst_32445 = (state_32452[(2)]);
var state_32452__$1 = (function (){var statearr_32464 = state_32452;
(statearr_32464[(8)] = inst_32445);

return statearr_32464;
})();
var statearr_32465_32481 = state_32452__$1;
(statearr_32465_32481[(2)] = null);

(statearr_32465_32481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32453 === (8))){
var inst_32434 = (state_32452[(7)]);
var state_32452__$1 = state_32452;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32452__$1,(11),out,inst_32434);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___32471,out))
;
return ((function (switch__30858__auto__,c__30946__auto___32471,out){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_32466 = [null,null,null,null,null,null,null,null,null];
(statearr_32466[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_32466[(1)] = (1));

return statearr_32466;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_32452){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32467){if((e32467 instanceof Object)){
var ex__30862__auto__ = e32467;
var statearr_32468_32482 = state_32452;
(statearr_32468_32482[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32452);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32467;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32483 = state_32452;
state_32452 = G__32483;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_32452){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_32452);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___32471,out))
})();
var state__30948__auto__ = (function (){var statearr_32469 = f__30947__auto__.call(null);
(statearr_32469[(6)] = c__30946__auto___32471);

return statearr_32469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___32471,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32485 = arguments.length;
switch (G__32485) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30946__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto__){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto__){
return (function (state_32548){
var state_val_32549 = (state_32548[(1)]);
if((state_val_32549 === (7))){
var inst_32544 = (state_32548[(2)]);
var state_32548__$1 = state_32548;
var statearr_32550_32588 = state_32548__$1;
(statearr_32550_32588[(2)] = inst_32544);

(statearr_32550_32588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (20))){
var inst_32514 = (state_32548[(7)]);
var inst_32525 = (state_32548[(2)]);
var inst_32526 = cljs.core.next.call(null,inst_32514);
var inst_32500 = inst_32526;
var inst_32501 = null;
var inst_32502 = (0);
var inst_32503 = (0);
var state_32548__$1 = (function (){var statearr_32551 = state_32548;
(statearr_32551[(8)] = inst_32502);

(statearr_32551[(9)] = inst_32503);

(statearr_32551[(10)] = inst_32500);

(statearr_32551[(11)] = inst_32501);

(statearr_32551[(12)] = inst_32525);

return statearr_32551;
})();
var statearr_32552_32589 = state_32548__$1;
(statearr_32552_32589[(2)] = null);

(statearr_32552_32589[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (1))){
var state_32548__$1 = state_32548;
var statearr_32553_32590 = state_32548__$1;
(statearr_32553_32590[(2)] = null);

(statearr_32553_32590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (4))){
var inst_32489 = (state_32548[(13)]);
var inst_32489__$1 = (state_32548[(2)]);
var inst_32490 = (inst_32489__$1 == null);
var state_32548__$1 = (function (){var statearr_32554 = state_32548;
(statearr_32554[(13)] = inst_32489__$1);

return statearr_32554;
})();
if(cljs.core.truth_(inst_32490)){
var statearr_32555_32591 = state_32548__$1;
(statearr_32555_32591[(1)] = (5));

} else {
var statearr_32556_32592 = state_32548__$1;
(statearr_32556_32592[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (15))){
var state_32548__$1 = state_32548;
var statearr_32560_32593 = state_32548__$1;
(statearr_32560_32593[(2)] = null);

(statearr_32560_32593[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (21))){
var state_32548__$1 = state_32548;
var statearr_32561_32594 = state_32548__$1;
(statearr_32561_32594[(2)] = null);

(statearr_32561_32594[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (13))){
var inst_32502 = (state_32548[(8)]);
var inst_32503 = (state_32548[(9)]);
var inst_32500 = (state_32548[(10)]);
var inst_32501 = (state_32548[(11)]);
var inst_32510 = (state_32548[(2)]);
var inst_32511 = (inst_32503 + (1));
var tmp32557 = inst_32502;
var tmp32558 = inst_32500;
var tmp32559 = inst_32501;
var inst_32500__$1 = tmp32558;
var inst_32501__$1 = tmp32559;
var inst_32502__$1 = tmp32557;
var inst_32503__$1 = inst_32511;
var state_32548__$1 = (function (){var statearr_32562 = state_32548;
(statearr_32562[(8)] = inst_32502__$1);

(statearr_32562[(9)] = inst_32503__$1);

(statearr_32562[(10)] = inst_32500__$1);

(statearr_32562[(11)] = inst_32501__$1);

(statearr_32562[(14)] = inst_32510);

return statearr_32562;
})();
var statearr_32563_32595 = state_32548__$1;
(statearr_32563_32595[(2)] = null);

(statearr_32563_32595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (22))){
var state_32548__$1 = state_32548;
var statearr_32564_32596 = state_32548__$1;
(statearr_32564_32596[(2)] = null);

(statearr_32564_32596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (6))){
var inst_32489 = (state_32548[(13)]);
var inst_32498 = f.call(null,inst_32489);
var inst_32499 = cljs.core.seq.call(null,inst_32498);
var inst_32500 = inst_32499;
var inst_32501 = null;
var inst_32502 = (0);
var inst_32503 = (0);
var state_32548__$1 = (function (){var statearr_32565 = state_32548;
(statearr_32565[(8)] = inst_32502);

(statearr_32565[(9)] = inst_32503);

(statearr_32565[(10)] = inst_32500);

(statearr_32565[(11)] = inst_32501);

return statearr_32565;
})();
var statearr_32566_32597 = state_32548__$1;
(statearr_32566_32597[(2)] = null);

(statearr_32566_32597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (17))){
var inst_32514 = (state_32548[(7)]);
var inst_32518 = cljs.core.chunk_first.call(null,inst_32514);
var inst_32519 = cljs.core.chunk_rest.call(null,inst_32514);
var inst_32520 = cljs.core.count.call(null,inst_32518);
var inst_32500 = inst_32519;
var inst_32501 = inst_32518;
var inst_32502 = inst_32520;
var inst_32503 = (0);
var state_32548__$1 = (function (){var statearr_32567 = state_32548;
(statearr_32567[(8)] = inst_32502);

(statearr_32567[(9)] = inst_32503);

(statearr_32567[(10)] = inst_32500);

(statearr_32567[(11)] = inst_32501);

return statearr_32567;
})();
var statearr_32568_32598 = state_32548__$1;
(statearr_32568_32598[(2)] = null);

(statearr_32568_32598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (3))){
var inst_32546 = (state_32548[(2)]);
var state_32548__$1 = state_32548;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32548__$1,inst_32546);
} else {
if((state_val_32549 === (12))){
var inst_32534 = (state_32548[(2)]);
var state_32548__$1 = state_32548;
var statearr_32569_32599 = state_32548__$1;
(statearr_32569_32599[(2)] = inst_32534);

(statearr_32569_32599[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (2))){
var state_32548__$1 = state_32548;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32548__$1,(4),in$);
} else {
if((state_val_32549 === (23))){
var inst_32542 = (state_32548[(2)]);
var state_32548__$1 = state_32548;
var statearr_32570_32600 = state_32548__$1;
(statearr_32570_32600[(2)] = inst_32542);

(statearr_32570_32600[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (19))){
var inst_32529 = (state_32548[(2)]);
var state_32548__$1 = state_32548;
var statearr_32571_32601 = state_32548__$1;
(statearr_32571_32601[(2)] = inst_32529);

(statearr_32571_32601[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (11))){
var inst_32514 = (state_32548[(7)]);
var inst_32500 = (state_32548[(10)]);
var inst_32514__$1 = cljs.core.seq.call(null,inst_32500);
var state_32548__$1 = (function (){var statearr_32572 = state_32548;
(statearr_32572[(7)] = inst_32514__$1);

return statearr_32572;
})();
if(inst_32514__$1){
var statearr_32573_32602 = state_32548__$1;
(statearr_32573_32602[(1)] = (14));

} else {
var statearr_32574_32603 = state_32548__$1;
(statearr_32574_32603[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (9))){
var inst_32536 = (state_32548[(2)]);
var inst_32537 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32548__$1 = (function (){var statearr_32575 = state_32548;
(statearr_32575[(15)] = inst_32536);

return statearr_32575;
})();
if(cljs.core.truth_(inst_32537)){
var statearr_32576_32604 = state_32548__$1;
(statearr_32576_32604[(1)] = (21));

} else {
var statearr_32577_32605 = state_32548__$1;
(statearr_32577_32605[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (5))){
var inst_32492 = cljs.core.async.close_BANG_.call(null,out);
var state_32548__$1 = state_32548;
var statearr_32578_32606 = state_32548__$1;
(statearr_32578_32606[(2)] = inst_32492);

(statearr_32578_32606[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (14))){
var inst_32514 = (state_32548[(7)]);
var inst_32516 = cljs.core.chunked_seq_QMARK_.call(null,inst_32514);
var state_32548__$1 = state_32548;
if(inst_32516){
var statearr_32579_32607 = state_32548__$1;
(statearr_32579_32607[(1)] = (17));

} else {
var statearr_32580_32608 = state_32548__$1;
(statearr_32580_32608[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (16))){
var inst_32532 = (state_32548[(2)]);
var state_32548__$1 = state_32548;
var statearr_32581_32609 = state_32548__$1;
(statearr_32581_32609[(2)] = inst_32532);

(statearr_32581_32609[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32549 === (10))){
var inst_32503 = (state_32548[(9)]);
var inst_32501 = (state_32548[(11)]);
var inst_32508 = cljs.core._nth.call(null,inst_32501,inst_32503);
var state_32548__$1 = state_32548;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32548__$1,(13),out,inst_32508);
} else {
if((state_val_32549 === (18))){
var inst_32514 = (state_32548[(7)]);
var inst_32523 = cljs.core.first.call(null,inst_32514);
var state_32548__$1 = state_32548;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32548__$1,(20),out,inst_32523);
} else {
if((state_val_32549 === (8))){
var inst_32502 = (state_32548[(8)]);
var inst_32503 = (state_32548[(9)]);
var inst_32505 = (inst_32503 < inst_32502);
var inst_32506 = inst_32505;
var state_32548__$1 = state_32548;
if(cljs.core.truth_(inst_32506)){
var statearr_32582_32610 = state_32548__$1;
(statearr_32582_32610[(1)] = (10));

} else {
var statearr_32583_32611 = state_32548__$1;
(statearr_32583_32611[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto__))
;
return ((function (switch__30858__auto__,c__30946__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30859__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30859__auto____0 = (function (){
var statearr_32584 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32584[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30859__auto__);

(statearr_32584[(1)] = (1));

return statearr_32584;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30859__auto____1 = (function (state_32548){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32585){if((e32585 instanceof Object)){
var ex__30862__auto__ = e32585;
var statearr_32586_32612 = state_32548;
(statearr_32586_32612[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32548);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32585;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32613 = state_32548;
state_32548 = G__32613;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30859__auto__ = function(state_32548){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30859__auto____1.call(this,state_32548);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30859__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30859__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto__))
})();
var state__30948__auto__ = (function (){var statearr_32587 = f__30947__auto__.call(null);
(statearr_32587[(6)] = c__30946__auto__);

return statearr_32587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto__))
);

return c__30946__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32615 = arguments.length;
switch (G__32615) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32618 = arguments.length;
switch (G__32618) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32621 = arguments.length;
switch (G__32621) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30946__auto___32668 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___32668,out){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___32668,out){
return (function (state_32645){
var state_val_32646 = (state_32645[(1)]);
if((state_val_32646 === (7))){
var inst_32640 = (state_32645[(2)]);
var state_32645__$1 = state_32645;
var statearr_32647_32669 = state_32645__$1;
(statearr_32647_32669[(2)] = inst_32640);

(statearr_32647_32669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32646 === (1))){
var inst_32622 = null;
var state_32645__$1 = (function (){var statearr_32648 = state_32645;
(statearr_32648[(7)] = inst_32622);

return statearr_32648;
})();
var statearr_32649_32670 = state_32645__$1;
(statearr_32649_32670[(2)] = null);

(statearr_32649_32670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32646 === (4))){
var inst_32625 = (state_32645[(8)]);
var inst_32625__$1 = (state_32645[(2)]);
var inst_32626 = (inst_32625__$1 == null);
var inst_32627 = cljs.core.not.call(null,inst_32626);
var state_32645__$1 = (function (){var statearr_32650 = state_32645;
(statearr_32650[(8)] = inst_32625__$1);

return statearr_32650;
})();
if(inst_32627){
var statearr_32651_32671 = state_32645__$1;
(statearr_32651_32671[(1)] = (5));

} else {
var statearr_32652_32672 = state_32645__$1;
(statearr_32652_32672[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32646 === (6))){
var state_32645__$1 = state_32645;
var statearr_32653_32673 = state_32645__$1;
(statearr_32653_32673[(2)] = null);

(statearr_32653_32673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32646 === (3))){
var inst_32642 = (state_32645[(2)]);
var inst_32643 = cljs.core.async.close_BANG_.call(null,out);
var state_32645__$1 = (function (){var statearr_32654 = state_32645;
(statearr_32654[(9)] = inst_32642);

return statearr_32654;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32645__$1,inst_32643);
} else {
if((state_val_32646 === (2))){
var state_32645__$1 = state_32645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32645__$1,(4),ch);
} else {
if((state_val_32646 === (11))){
var inst_32625 = (state_32645[(8)]);
var inst_32634 = (state_32645[(2)]);
var inst_32622 = inst_32625;
var state_32645__$1 = (function (){var statearr_32655 = state_32645;
(statearr_32655[(10)] = inst_32634);

(statearr_32655[(7)] = inst_32622);

return statearr_32655;
})();
var statearr_32656_32674 = state_32645__$1;
(statearr_32656_32674[(2)] = null);

(statearr_32656_32674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32646 === (9))){
var inst_32625 = (state_32645[(8)]);
var state_32645__$1 = state_32645;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32645__$1,(11),out,inst_32625);
} else {
if((state_val_32646 === (5))){
var inst_32625 = (state_32645[(8)]);
var inst_32622 = (state_32645[(7)]);
var inst_32629 = cljs.core._EQ_.call(null,inst_32625,inst_32622);
var state_32645__$1 = state_32645;
if(inst_32629){
var statearr_32658_32675 = state_32645__$1;
(statearr_32658_32675[(1)] = (8));

} else {
var statearr_32659_32676 = state_32645__$1;
(statearr_32659_32676[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32646 === (10))){
var inst_32637 = (state_32645[(2)]);
var state_32645__$1 = state_32645;
var statearr_32660_32677 = state_32645__$1;
(statearr_32660_32677[(2)] = inst_32637);

(statearr_32660_32677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32646 === (8))){
var inst_32622 = (state_32645[(7)]);
var tmp32657 = inst_32622;
var inst_32622__$1 = tmp32657;
var state_32645__$1 = (function (){var statearr_32661 = state_32645;
(statearr_32661[(7)] = inst_32622__$1);

return statearr_32661;
})();
var statearr_32662_32678 = state_32645__$1;
(statearr_32662_32678[(2)] = null);

(statearr_32662_32678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___32668,out))
;
return ((function (switch__30858__auto__,c__30946__auto___32668,out){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_32663 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32663[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_32663[(1)] = (1));

return statearr_32663;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_32645){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32645);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32664){if((e32664 instanceof Object)){
var ex__30862__auto__ = e32664;
var statearr_32665_32679 = state_32645;
(statearr_32665_32679[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32645);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32664;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32680 = state_32645;
state_32645 = G__32680;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_32645){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_32645);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___32668,out))
})();
var state__30948__auto__ = (function (){var statearr_32666 = f__30947__auto__.call(null);
(statearr_32666[(6)] = c__30946__auto___32668);

return statearr_32666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___32668,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32682 = arguments.length;
switch (G__32682) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30946__auto___32748 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___32748,out){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___32748,out){
return (function (state_32720){
var state_val_32721 = (state_32720[(1)]);
if((state_val_32721 === (7))){
var inst_32716 = (state_32720[(2)]);
var state_32720__$1 = state_32720;
var statearr_32722_32749 = state_32720__$1;
(statearr_32722_32749[(2)] = inst_32716);

(statearr_32722_32749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (1))){
var inst_32683 = (new Array(n));
var inst_32684 = inst_32683;
var inst_32685 = (0);
var state_32720__$1 = (function (){var statearr_32723 = state_32720;
(statearr_32723[(7)] = inst_32684);

(statearr_32723[(8)] = inst_32685);

return statearr_32723;
})();
var statearr_32724_32750 = state_32720__$1;
(statearr_32724_32750[(2)] = null);

(statearr_32724_32750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (4))){
var inst_32688 = (state_32720[(9)]);
var inst_32688__$1 = (state_32720[(2)]);
var inst_32689 = (inst_32688__$1 == null);
var inst_32690 = cljs.core.not.call(null,inst_32689);
var state_32720__$1 = (function (){var statearr_32725 = state_32720;
(statearr_32725[(9)] = inst_32688__$1);

return statearr_32725;
})();
if(inst_32690){
var statearr_32726_32751 = state_32720__$1;
(statearr_32726_32751[(1)] = (5));

} else {
var statearr_32727_32752 = state_32720__$1;
(statearr_32727_32752[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (15))){
var inst_32710 = (state_32720[(2)]);
var state_32720__$1 = state_32720;
var statearr_32728_32753 = state_32720__$1;
(statearr_32728_32753[(2)] = inst_32710);

(statearr_32728_32753[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (13))){
var state_32720__$1 = state_32720;
var statearr_32729_32754 = state_32720__$1;
(statearr_32729_32754[(2)] = null);

(statearr_32729_32754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (6))){
var inst_32685 = (state_32720[(8)]);
var inst_32706 = (inst_32685 > (0));
var state_32720__$1 = state_32720;
if(cljs.core.truth_(inst_32706)){
var statearr_32730_32755 = state_32720__$1;
(statearr_32730_32755[(1)] = (12));

} else {
var statearr_32731_32756 = state_32720__$1;
(statearr_32731_32756[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (3))){
var inst_32718 = (state_32720[(2)]);
var state_32720__$1 = state_32720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32720__$1,inst_32718);
} else {
if((state_val_32721 === (12))){
var inst_32684 = (state_32720[(7)]);
var inst_32708 = cljs.core.vec.call(null,inst_32684);
var state_32720__$1 = state_32720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32720__$1,(15),out,inst_32708);
} else {
if((state_val_32721 === (2))){
var state_32720__$1 = state_32720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32720__$1,(4),ch);
} else {
if((state_val_32721 === (11))){
var inst_32700 = (state_32720[(2)]);
var inst_32701 = (new Array(n));
var inst_32684 = inst_32701;
var inst_32685 = (0);
var state_32720__$1 = (function (){var statearr_32732 = state_32720;
(statearr_32732[(10)] = inst_32700);

(statearr_32732[(7)] = inst_32684);

(statearr_32732[(8)] = inst_32685);

return statearr_32732;
})();
var statearr_32733_32757 = state_32720__$1;
(statearr_32733_32757[(2)] = null);

(statearr_32733_32757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (9))){
var inst_32684 = (state_32720[(7)]);
var inst_32698 = cljs.core.vec.call(null,inst_32684);
var state_32720__$1 = state_32720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32720__$1,(11),out,inst_32698);
} else {
if((state_val_32721 === (5))){
var inst_32693 = (state_32720[(11)]);
var inst_32688 = (state_32720[(9)]);
var inst_32684 = (state_32720[(7)]);
var inst_32685 = (state_32720[(8)]);
var inst_32692 = (inst_32684[inst_32685] = inst_32688);
var inst_32693__$1 = (inst_32685 + (1));
var inst_32694 = (inst_32693__$1 < n);
var state_32720__$1 = (function (){var statearr_32734 = state_32720;
(statearr_32734[(11)] = inst_32693__$1);

(statearr_32734[(12)] = inst_32692);

return statearr_32734;
})();
if(cljs.core.truth_(inst_32694)){
var statearr_32735_32758 = state_32720__$1;
(statearr_32735_32758[(1)] = (8));

} else {
var statearr_32736_32759 = state_32720__$1;
(statearr_32736_32759[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (14))){
var inst_32713 = (state_32720[(2)]);
var inst_32714 = cljs.core.async.close_BANG_.call(null,out);
var state_32720__$1 = (function (){var statearr_32738 = state_32720;
(statearr_32738[(13)] = inst_32713);

return statearr_32738;
})();
var statearr_32739_32760 = state_32720__$1;
(statearr_32739_32760[(2)] = inst_32714);

(statearr_32739_32760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (10))){
var inst_32704 = (state_32720[(2)]);
var state_32720__$1 = state_32720;
var statearr_32740_32761 = state_32720__$1;
(statearr_32740_32761[(2)] = inst_32704);

(statearr_32740_32761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32721 === (8))){
var inst_32693 = (state_32720[(11)]);
var inst_32684 = (state_32720[(7)]);
var tmp32737 = inst_32684;
var inst_32684__$1 = tmp32737;
var inst_32685 = inst_32693;
var state_32720__$1 = (function (){var statearr_32741 = state_32720;
(statearr_32741[(7)] = inst_32684__$1);

(statearr_32741[(8)] = inst_32685);

return statearr_32741;
})();
var statearr_32742_32762 = state_32720__$1;
(statearr_32742_32762[(2)] = null);

(statearr_32742_32762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___32748,out))
;
return ((function (switch__30858__auto__,c__30946__auto___32748,out){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_32743 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32743[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_32743[(1)] = (1));

return statearr_32743;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_32720){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32744){if((e32744 instanceof Object)){
var ex__30862__auto__ = e32744;
var statearr_32745_32763 = state_32720;
(statearr_32745_32763[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32720);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32744;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32764 = state_32720;
state_32720 = G__32764;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_32720){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_32720);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___32748,out))
})();
var state__30948__auto__ = (function (){var statearr_32746 = f__30947__auto__.call(null);
(statearr_32746[(6)] = c__30946__auto___32748);

return statearr_32746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___32748,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32766 = arguments.length;
switch (G__32766) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30946__auto___32836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___32836,out){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___32836,out){
return (function (state_32808){
var state_val_32809 = (state_32808[(1)]);
if((state_val_32809 === (7))){
var inst_32804 = (state_32808[(2)]);
var state_32808__$1 = state_32808;
var statearr_32810_32837 = state_32808__$1;
(statearr_32810_32837[(2)] = inst_32804);

(statearr_32810_32837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (1))){
var inst_32767 = [];
var inst_32768 = inst_32767;
var inst_32769 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32808__$1 = (function (){var statearr_32811 = state_32808;
(statearr_32811[(7)] = inst_32769);

(statearr_32811[(8)] = inst_32768);

return statearr_32811;
})();
var statearr_32812_32838 = state_32808__$1;
(statearr_32812_32838[(2)] = null);

(statearr_32812_32838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (4))){
var inst_32772 = (state_32808[(9)]);
var inst_32772__$1 = (state_32808[(2)]);
var inst_32773 = (inst_32772__$1 == null);
var inst_32774 = cljs.core.not.call(null,inst_32773);
var state_32808__$1 = (function (){var statearr_32813 = state_32808;
(statearr_32813[(9)] = inst_32772__$1);

return statearr_32813;
})();
if(inst_32774){
var statearr_32814_32839 = state_32808__$1;
(statearr_32814_32839[(1)] = (5));

} else {
var statearr_32815_32840 = state_32808__$1;
(statearr_32815_32840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (15))){
var inst_32798 = (state_32808[(2)]);
var state_32808__$1 = state_32808;
var statearr_32816_32841 = state_32808__$1;
(statearr_32816_32841[(2)] = inst_32798);

(statearr_32816_32841[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (13))){
var state_32808__$1 = state_32808;
var statearr_32817_32842 = state_32808__$1;
(statearr_32817_32842[(2)] = null);

(statearr_32817_32842[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (6))){
var inst_32768 = (state_32808[(8)]);
var inst_32793 = inst_32768.length;
var inst_32794 = (inst_32793 > (0));
var state_32808__$1 = state_32808;
if(cljs.core.truth_(inst_32794)){
var statearr_32818_32843 = state_32808__$1;
(statearr_32818_32843[(1)] = (12));

} else {
var statearr_32819_32844 = state_32808__$1;
(statearr_32819_32844[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (3))){
var inst_32806 = (state_32808[(2)]);
var state_32808__$1 = state_32808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32808__$1,inst_32806);
} else {
if((state_val_32809 === (12))){
var inst_32768 = (state_32808[(8)]);
var inst_32796 = cljs.core.vec.call(null,inst_32768);
var state_32808__$1 = state_32808;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32808__$1,(15),out,inst_32796);
} else {
if((state_val_32809 === (2))){
var state_32808__$1 = state_32808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32808__$1,(4),ch);
} else {
if((state_val_32809 === (11))){
var inst_32776 = (state_32808[(10)]);
var inst_32772 = (state_32808[(9)]);
var inst_32786 = (state_32808[(2)]);
var inst_32787 = [];
var inst_32788 = inst_32787.push(inst_32772);
var inst_32768 = inst_32787;
var inst_32769 = inst_32776;
var state_32808__$1 = (function (){var statearr_32820 = state_32808;
(statearr_32820[(7)] = inst_32769);

(statearr_32820[(8)] = inst_32768);

(statearr_32820[(11)] = inst_32788);

(statearr_32820[(12)] = inst_32786);

return statearr_32820;
})();
var statearr_32821_32845 = state_32808__$1;
(statearr_32821_32845[(2)] = null);

(statearr_32821_32845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (9))){
var inst_32768 = (state_32808[(8)]);
var inst_32784 = cljs.core.vec.call(null,inst_32768);
var state_32808__$1 = state_32808;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32808__$1,(11),out,inst_32784);
} else {
if((state_val_32809 === (5))){
var inst_32769 = (state_32808[(7)]);
var inst_32776 = (state_32808[(10)]);
var inst_32772 = (state_32808[(9)]);
var inst_32776__$1 = f.call(null,inst_32772);
var inst_32777 = cljs.core._EQ_.call(null,inst_32776__$1,inst_32769);
var inst_32778 = cljs.core.keyword_identical_QMARK_.call(null,inst_32769,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32779 = (inst_32777) || (inst_32778);
var state_32808__$1 = (function (){var statearr_32822 = state_32808;
(statearr_32822[(10)] = inst_32776__$1);

return statearr_32822;
})();
if(cljs.core.truth_(inst_32779)){
var statearr_32823_32846 = state_32808__$1;
(statearr_32823_32846[(1)] = (8));

} else {
var statearr_32824_32847 = state_32808__$1;
(statearr_32824_32847[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (14))){
var inst_32801 = (state_32808[(2)]);
var inst_32802 = cljs.core.async.close_BANG_.call(null,out);
var state_32808__$1 = (function (){var statearr_32826 = state_32808;
(statearr_32826[(13)] = inst_32801);

return statearr_32826;
})();
var statearr_32827_32848 = state_32808__$1;
(statearr_32827_32848[(2)] = inst_32802);

(statearr_32827_32848[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (10))){
var inst_32791 = (state_32808[(2)]);
var state_32808__$1 = state_32808;
var statearr_32828_32849 = state_32808__$1;
(statearr_32828_32849[(2)] = inst_32791);

(statearr_32828_32849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32809 === (8))){
var inst_32776 = (state_32808[(10)]);
var inst_32768 = (state_32808[(8)]);
var inst_32772 = (state_32808[(9)]);
var inst_32781 = inst_32768.push(inst_32772);
var tmp32825 = inst_32768;
var inst_32768__$1 = tmp32825;
var inst_32769 = inst_32776;
var state_32808__$1 = (function (){var statearr_32829 = state_32808;
(statearr_32829[(7)] = inst_32769);

(statearr_32829[(14)] = inst_32781);

(statearr_32829[(8)] = inst_32768__$1);

return statearr_32829;
})();
var statearr_32830_32850 = state_32808__$1;
(statearr_32830_32850[(2)] = null);

(statearr_32830_32850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto___32836,out))
;
return ((function (switch__30858__auto__,c__30946__auto___32836,out){
return (function() {
var cljs$core$async$state_machine__30859__auto__ = null;
var cljs$core$async$state_machine__30859__auto____0 = (function (){
var statearr_32831 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32831[(0)] = cljs$core$async$state_machine__30859__auto__);

(statearr_32831[(1)] = (1));

return statearr_32831;
});
var cljs$core$async$state_machine__30859__auto____1 = (function (state_32808){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_32808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e32832){if((e32832 instanceof Object)){
var ex__30862__auto__ = e32832;
var statearr_32833_32851 = state_32808;
(statearr_32833_32851[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32808);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32832;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32852 = state_32808;
state_32808 = G__32852;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
cljs$core$async$state_machine__30859__auto__ = function(state_32808){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30859__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30859__auto____1.call(this,state_32808);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30859__auto____0;
cljs$core$async$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30859__auto____1;
return cljs$core$async$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___32836,out))
})();
var state__30948__auto__ = (function (){var statearr_32834 = f__30947__auto__.call(null);
(statearr_32834[(6)] = c__30946__auto___32836);

return statearr_32834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___32836,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1503639568291
