/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.management;

import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.schema.VertexLabelMaker;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagementTest
extends TitanGraphBaseTest {
    private static final Logger log = LoggerFactory.getLogger(ManagementTest.class);
    private static final Set<String> ILLEGAL_USER_DEFINED_NAMES = ImmutableSet.of((Object)"~key", (Object)"~value", (Object)"~id", (Object)"~nid", (Object)"~label", (Object)"~adjacent", (Object[])new String[]{"~timestamp", "~ttl", "~visibility", "key", "vertex", "edge", "element", "property", "label", "~T$VertexExists", "~T$SchemaName", "~T$SchemaDefinitionProperty", "~T$SchemaCategory", "~T$SchemaDefinitionDescription", "~T$SchemaUpdateTimestamp", "~T$SchemaRelated", "~T$VertexLabel"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReservedNamesRejectedForPropertyKeys() {
        for (String s : ILLEGAL_USER_DEFINED_NAMES) {
            TitanManagement tm = this.graph.openManagement();
            try {
                tm.makePropertyKey(s);
                Assert.fail((String)("Property key  \"" + s + "\" must be rejected"));
            }
            catch (IllegalArgumentException e) {
                log.debug("Caught expected exception", (Throwable)e);
            }
            finally {
                tm.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReservedNamesRejectedForEdgeLabels() {
        for (String s : ILLEGAL_USER_DEFINED_NAMES) {
            TitanManagement tm = this.graph.openManagement();
            try {
                tm.makeEdgeLabel(s);
                Assert.fail((String)("Edge label \"" + s + "\" must be rejected"));
            }
            catch (IllegalArgumentException e) {
                log.debug("Caught expected exception", (Throwable)e);
            }
            finally {
                tm.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReservedNamesRejectedForVertexLabels() {
        for (String s : ILLEGAL_USER_DEFINED_NAMES) {
            TitanManagement tm = this.graph.openManagement();
            VertexLabelMaker vlm = null;
            try {
                vlm = tm.makeVertexLabel(s);
                Assert.fail((String)("Vertex label \"" + s + "\" must be rejected"));
            }
            catch (IllegalArgumentException e) {
                log.debug("Caught expected exception", (Throwable)e);
            }
            finally {
                tm.commit();
            }
        }
    }
}

