/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanGraphTransaction;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.log.LogManager;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLogManager;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.internal.Order;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.thinkaurelius.titan.testutil.TestGraphConfigs;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class TitanGraphBaseTest {
    public static final String LABEL_NAME = T.label.getAccessor();
    public static final String ID_NAME = T.id.getAccessor();
    public WriteConfiguration config;
    public BasicConfiguration readConfig;
    public StandardTitanGraph graph;
    public StoreFeatures features;
    public TitanTransaction tx;
    public TitanManagement mgmt;
    public Map<String, LogManager> logManagers;
    private KeyColumnValueStoreManager logStoreManager = null;
    public static final int DEFAULT_THREAD_COUNT = 4;

    public abstract WriteConfiguration getConfiguration();

    public Configuration getConfig() {
        return new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config.copy(), BasicConfiguration.Restriction.NONE);
    }

    public static void clearGraph(WriteConfiguration config) throws BackendException {
        ModifiableConfiguration adjustedConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config.copy(), BasicConfiguration.Restriction.NONE);
        adjustedConfig.set(GraphDatabaseConfiguration.LOCK_LOCAL_MEDIATOR_GROUP, (Object)"tmp", new String[0]);
        adjustedConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"inst", new String[0]);
        Backend backend = new Backend((Configuration)adjustedConfig);
        backend.initialize((Configuration)adjustedConfig);
        backend.clearStorage();
    }

    @Before
    public void setUp() throws Exception {
        this.config = this.getConfiguration();
        TestGraphConfigs.applyOverrides(this.config);
        Preconditions.checkNotNull((Object)this.config);
        TitanGraphBaseTest.clearGraph(this.config);
        this.readConfig = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config, BasicConfiguration.Restriction.NONE);
        this.open(this.config);
        this.logManagers = new HashMap<String, LogManager>();
    }

    public void open(WriteConfiguration config) {
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)config);
        this.features = this.graph.getConfiguration().getStoreFeatures();
        this.tx = this.graph.newTransaction();
        this.mgmt = this.graph.openManagement();
    }

    @After
    public void tearDown() throws Exception {
        this.close();
        this.closeLogs();
    }

    public void finishSchema() {
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.commit();
        }
        this.mgmt = this.graph.openManagement();
        this.newTx();
        this.graph.tx().commit();
    }

    public void close() {
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.rollback();
        }
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        if (null != this.graph && this.graph.isOpen()) {
            this.graph.close();
        }
    }

    public void newTx() {
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        this.tx = this.graph.newTransaction();
    }

    public static Map<TestConfigOption, Object> validateConfigOptions(Object ... settings) {
        Preconditions.checkArgument((settings.length % 2 == 0 ? 1 : 0) != 0, (String)"Expected even number of settings: %s", (Object[])settings);
        HashMap options = Maps.newHashMap();
        for (int i = 0; i < settings.length; i += 2) {
            Preconditions.checkArgument((boolean)(settings[i] instanceof TestConfigOption), (String)"Expected configuration option but got: %s", (Object[])new Object[]{settings[i]});
            Preconditions.checkNotNull((Object)settings[i + 1], (String)"Null setting at position [%s]", (Object[])new Object[]{i + 1});
            options.put((TestConfigOption)settings[i], settings[i + 1]);
        }
        return options;
    }

    public void clopen(Object ... settings) {
        this.config = this.getConfiguration();
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.rollback();
        }
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        if (settings != null && settings.length > 0) {
            Map<TestConfigOption, Object> options = TitanGraphBaseTest.validateConfigOptions(settings);
            TitanManagement gconf = null;
            ModifiableConfiguration lconf = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.config, BasicConfiguration.Restriction.LOCAL);
            for (Map.Entry<TestConfigOption, Object> option : options.entrySet()) {
                if (option.getKey().option.isLocal()) {
                    lconf.set(option.getKey().option, option.getValue(), option.getKey().umbrella);
                    continue;
                }
                if (gconf == null) {
                    gconf = this.graph.openManagement();
                }
                gconf.set(ConfigElement.getPath((ConfigElement)option.getKey().option, (String[])option.getKey().umbrella), option.getValue());
            }
            if (gconf != null) {
                gconf.commit();
            }
            lconf.close();
        }
        if (null != this.graph && null != this.graph.tx() && this.graph.tx().isOpen()) {
            this.graph.tx().commit();
        }
        if (null != this.graph && this.graph.isOpen()) {
            this.graph.close();
        }
        Preconditions.checkNotNull((Object)this.config);
        this.open(this.config);
    }

    public static final TestConfigOption option(ConfigOption option, String ... umbrella) {
        return new TestConfigOption(option, umbrella);
    }

    private void closeLogs() {
        try {
            for (LogManager lm : this.logManagers.values()) {
                lm.close();
            }
            this.logManagers.clear();
            if (this.logStoreManager != null) {
                this.logStoreManager.close();
                this.logStoreManager = null;
            }
        }
        catch (BackendException e) {
            throw new TitanException((Throwable)e);
        }
    }

    public void closeLogManager(String logManagerName) {
        if (this.logManagers.containsKey(logManagerName)) {
            try {
                this.logManagers.remove(logManagerName).close();
            }
            catch (BackendException e) {
                throw new TitanException("Could not close log manager " + logManagerName, (Throwable)e);
            }
        }
    }

    public Log openUserLog(String identifier) {
        return this.openLog("user", "ulog_" + identifier);
    }

    public Log openTxLog() {
        return this.openLog("tx", "txlog");
    }

    private Log openLog(String logManagerName, String logName) {
        try {
            StoreFeatures f;
            boolean part;
            ModifiableConfiguration configuration = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.config.copy(), BasicConfiguration.Restriction.NONE);
            configuration.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"reader", new String[0]);
            configuration.set(GraphDatabaseConfiguration.LOG_READ_INTERVAL, (Object)Duration.ofMillis(500L), new String[]{logManagerName});
            if (this.logStoreManager == null) {
                this.logStoreManager = Backend.getStorageManager((Configuration)configuration);
            }
            boolean bl = part = (f = this.logStoreManager.getFeatures()).isDistributed() && f.isKeyOrdered();
            if (part) {
                for (String logname : new String[]{"user", "tx", "titan"}) {
                    configuration.set(KCVSLogManager.LOG_MAX_PARTITIONS, (Object)8, new String[]{logname});
                }
            }
            assert (this.logStoreManager != null);
            if (!this.logManagers.containsKey(logManagerName)) {
                Configuration logConfig = configuration.restrictTo(new String[]{logManagerName});
                Preconditions.checkArgument((boolean)((String)logConfig.get(GraphDatabaseConfiguration.LOG_BACKEND, new String[0])).equals(GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue()));
                this.logManagers.put(logManagerName, (LogManager)new KCVSLogManager(this.logStoreManager, logConfig));
            }
            assert (this.logManagers.containsKey(logManagerName));
            return this.logManagers.get(logManagerName).openLog(logName);
        }
        catch (BackendException e) {
            throw new TitanException("Could not open log: " + logName, (Throwable)e);
        }
    }

    public PropertyKey makeVertexIndexedKey(String name, Class datatype) {
        PropertyKey key = this.mgmt.makePropertyKey(name).dataType(datatype).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(name, Vertex.class).addKey(key).buildCompositeIndex();
        return key;
    }

    public PropertyKey makeVertexIndexedUniqueKey(String name, Class datatype) {
        PropertyKey key = this.mgmt.makePropertyKey(name).dataType(datatype).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(name, Vertex.class).addKey(key).unique().buildCompositeIndex();
        return key;
    }

    public void createExternalVertexIndex(PropertyKey key, String backingIndex) {
        this.createExternalIndex(key, Vertex.class, backingIndex);
    }

    public void createExternalEdgeIndex(PropertyKey key, String backingIndex) {
        this.createExternalIndex(key, Edge.class, backingIndex);
    }

    public TitanGraphIndex getExternalIndex(Class<? extends Element> clazz, String backingIndex) {
        String prefix;
        if (Vertex.class.isAssignableFrom(clazz)) {
            prefix = "v";
        } else if (Edge.class.isAssignableFrom(clazz)) {
            prefix = "e";
        } else if (TitanVertexProperty.class.isAssignableFrom(clazz)) {
            prefix = "p";
        } else {
            throw new AssertionError((Object)clazz.toString());
        }
        String indexName = prefix + backingIndex;
        TitanGraphIndex index = this.mgmt.getGraphIndex(indexName);
        if (index == null) {
            index = this.mgmt.buildIndex(indexName, clazz).buildMixedIndex(backingIndex);
        }
        return index;
    }

    private void createExternalIndex(PropertyKey key, Class<? extends Element> clazz, String backingIndex) {
        this.mgmt.addIndexKey(this.getExternalIndex(clazz, backingIndex), key, new Parameter[0]);
    }

    public PropertyKey makeKey(String name, Class datatype) {
        PropertyKey key = this.mgmt.makePropertyKey(name).dataType(datatype).cardinality(Cardinality.SINGLE).make();
        return key;
    }

    public EdgeLabel makeLabel(String name) {
        return this.mgmt.makeEdgeLabel(name).make();
    }

    public EdgeLabel makeKeyedEdgeLabel(String name, PropertyKey sort, PropertyKey signature) {
        EdgeLabel relType = ((StandardEdgeLabelMaker)this.tx.makeEdgeLabel(name)).sortKey(new PropertyKey[]{sort}).signature(new PropertyKey[]{signature}).directed().make();
        return relType;
    }

    public static int getThreadCount() {
        String s = System.getProperty("titan.test.threads");
        if (null != s) {
            return Integer.valueOf(s);
        }
        return 4;
    }

    public static int wrapAround(int value, int maxValue) {
        if ((value %= maxValue) < 0) {
            value += maxValue;
        }
        return value;
    }

    public TitanVertex getVertex(String key, Object value) {
        return TitanGraphBaseTest.getVertex(this.tx, key, value);
    }

    public TitanVertex getVertex(PropertyKey key, Object value) {
        return TitanGraphBaseTest.getVertex(this.tx, key, value);
    }

    public static TitanVertex getVertex(TitanTransaction tx, String key, Object value) {
        return TitanGraphBaseTest.getOnlyElement(tx.query().has(key, value).vertices(), null);
    }

    public static TitanVertex getVertex(TitanTransaction tx, PropertyKey key, Object value) {
        return TitanGraphBaseTest.getVertex(tx, key.name(), value);
    }

    public static double round(double d) {
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    public static TitanVertex getOnlyVertex(TitanGraphQuery<?> query) {
        return (TitanVertex)TitanGraphBaseTest.getOnlyElement(query.vertices());
    }

    public static TitanEdge getOnlyEdge(TitanVertexQuery<?> query) {
        return (TitanEdge)TitanGraphBaseTest.getOnlyElement(query.edges());
    }

    public static <E> E getOnlyElement(Iterable<E> traversal) {
        return TitanGraphBaseTest.getOnlyElement(traversal.iterator());
    }

    public static <E> E getOnlyElement(Iterator<E> traversal) {
        if (!traversal.hasNext()) {
            throw new NoSuchElementException();
        }
        return TitanGraphBaseTest.getOnlyElement(traversal, null);
    }

    public static <E> E getOnlyElement(Iterable<E> traversal, E defaultElement) {
        return TitanGraphBaseTest.getOnlyElement(traversal.iterator(), defaultElement);
    }

    public static <E> E getOnlyElement(Iterator<E> traversal, E defaultElement) {
        if (!traversal.hasNext()) {
            return defaultElement;
        }
        E result = traversal.next();
        if (traversal.hasNext()) {
            throw new IllegalArgumentException("Traversal contains more than 1 element: " + result + ", " + traversal.next());
        }
        return result;
    }

    public static void assertMissing(TitanGraphTransaction g, Object vid) {
        Assert.assertFalse((boolean)g.vertices(new Object[]{vid}).hasNext());
    }

    public static TitanVertex getV(TitanGraphTransaction g, Object vid) {
        if (!g.vertices(new Object[]{vid}).hasNext()) {
            return null;
        }
        return (TitanVertex)g.vertices(new Object[]{vid}).next();
    }

    public static TitanEdge getE(TitanGraphTransaction g, Object eid) {
        if (!g.edges(new Object[]{eid}).hasNext()) {
            return null;
        }
        return (TitanEdge)g.edges(new Object[]{eid}).next();
    }

    public static String n(Object obj) {
        if (obj instanceof RelationType) {
            return ((RelationType)obj).name();
        }
        return obj.toString();
    }

    public static long getId(Element e) {
        return ((TitanElement)e).longId();
    }

    public static void verifyElementOrder(Iterable<? extends Element> elements, String key, Order order, int expectedCount) {
        TitanGraphBaseTest.verifyElementOrder(elements.iterator(), key, order, expectedCount);
    }

    public static void verifyElementOrder(Iterator<? extends Element> elements, String key, Order order, int expectedCount) {
        Comparable previous = null;
        int count = 0;
        while (elements.hasNext()) {
            Element element = elements.next();
            Comparable current = (Comparable)element.value(key);
            if (previous != null) {
                int cmp = previous.compareTo(current);
                Assert.assertTrue((String)(previous + " <> " + current + " @ " + count), (boolean)(order == Order.ASC ? cmp <= 0 : cmp >= 0));
            }
            previous = current;
            ++count;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
    }

    public static <T> Stream<T> asStream(Iterator<T> source) {
        Iterable iterable = () -> source;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static final class TestConfigOption {
        public final ConfigOption option;
        public final String[] umbrella;

        public TestConfigOption(ConfigOption option, String ... umbrella) {
            Preconditions.checkNotNull((Object)option);
            this.option = option;
            if (umbrella == null) {
                umbrella = new String[]{};
            }
            this.umbrella = umbrella;
        }
    }
}

