/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.StorageSetup;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.IDAuthority;
import com.thinkaurelius.titan.diskstorage.IDBlock;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.idmanagement.ConflictAvoidanceMode;
import com.thinkaurelius.titan.diskstorage.idmanagement.ConsistentKeyIDAuthority;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreManager;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDBlockSizer;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPoolExhaustedException;
import com.thinkaurelius.titan.testutil.TestGraphConfigs;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class IDAuthorityTest {
    private static final Logger log = LoggerFactory.getLogger(IDAuthorityTest.class);
    public static final int CONCURRENCY = 8;
    public static final int MAX_NUM_PARTITIONS = 4;
    public static final String DB_NAME = "test";
    public static final Duration GET_ID_BLOCK_TIMEOUT = Duration.ofMillis(300000L);
    public KeyColumnValueStoreManager[] manager;
    public IDAuthority[] idAuthorities;
    public WriteConfiguration baseStoreConfiguration;
    public final int uidBitWidth;
    public final boolean hasFixedUid;
    public final boolean hasEmptyUid;
    public final long blockSize;
    public final long idUpperBoundBitWidth;
    public final long idUpperBound;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        ModifiableConfiguration c = IDAuthorityTest.getBasicConfig();
        configurations.add(new Object[]{c.getConfiguration()});
        c = IDAuthorityTest.getBasicConfig();
        c.set(GraphDatabaseConfiguration.IDAUTHORITY_CAV_BITS, (Object)9, new String[0]);
        c.set(GraphDatabaseConfiguration.IDAUTHORITY_CAV_TAG, (Object)511, new String[0]);
        configurations.add(new Object[]{c.getConfiguration()});
        c = IDAuthorityTest.getBasicConfig();
        c.set(GraphDatabaseConfiguration.IDAUTHORITY_CAV_RETRIES, (Object)10, new String[0]);
        c.set(GraphDatabaseConfiguration.IDAUTHORITY_WAIT, (Object)Duration.ofMillis(10L), new String[0]);
        c.set(GraphDatabaseConfiguration.IDAUTHORITY_CAV_BITS, (Object)7, new String[0]);
        c.set(GraphDatabaseConfiguration.IDAUTHORITY_CONFLICT_AVOIDANCE, (Object)ConflictAvoidanceMode.GLOBAL_AUTO, new String[0]);
        configurations.add(new Object[]{c.getConfiguration()});
        return configurations;
    }

    public static ModifiableConfiguration getBasicConfig() {
        ModifiableConfiguration c = GraphDatabaseConfiguration.buildGraphConfiguration();
        c.set(GraphDatabaseConfiguration.IDAUTHORITY_WAIT, (Object)Duration.ofMillis(100L), new String[0]);
        c.set(GraphDatabaseConfiguration.IDS_BLOCK_SIZE, (Object)400, new String[0]);
        return c;
    }

    public IDAuthorityTest(WriteConfiguration baseConfig) {
        Preconditions.checkNotNull((Object)baseConfig);
        TestGraphConfigs.applyOverrides(baseConfig);
        this.baseStoreConfiguration = baseConfig;
        ModifiableConfiguration config = StorageSetup.getConfig(baseConfig);
        this.uidBitWidth = (Integer)config.get(GraphDatabaseConfiguration.IDAUTHORITY_CAV_BITS, new String[0]);
        this.hasFixedUid = !ConflictAvoidanceMode.GLOBAL_AUTO.equals(config.get(GraphDatabaseConfiguration.IDAUTHORITY_CONFLICT_AVOIDANCE, new String[0]));
        this.hasEmptyUid = this.uidBitWidth == 0;
        this.blockSize = ((Integer)config.get(GraphDatabaseConfiguration.IDS_BLOCK_SIZE, new String[0])).intValue();
        this.idUpperBoundBitWidth = 30L;
        this.idUpperBound = 1L << (int)this.idUpperBoundBitWidth;
    }

    @Before
    public void setUp() throws Exception {
        KeyColumnValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        this.open();
    }

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    public void open() throws BackendException {
        this.manager = new KeyColumnValueStoreManager[8];
        this.idAuthorities = new IDAuthority[8];
        for (int i = 0; i < 8; ++i) {
            ModifiableConfiguration sc = StorageSetup.getConfig(this.baseStoreConfiguration.copy());
            sc.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_SUFFIX, (Object)((short)i), new String[0]);
            if (!sc.has(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0])) {
                String uniqueGraphId = GraphDatabaseConfiguration.getOrGenerateUniqueInstanceId((Configuration)sc);
                log.debug("Setting unique instance id: {}", (Object)uniqueGraphId);
                sc.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)uniqueGraphId, new String[0]);
            }
            sc.set(GraphDatabaseConfiguration.CLUSTER_MAX_PARTITIONS, (Object)4, new String[0]);
            this.manager[i] = this.openStorageManager();
            StoreFeatures storeFeatures = this.manager[i].getFeatures();
            KeyColumnValueStore idStore = this.manager[i].openDatabase("ids");
            if (!storeFeatures.isKeyConsistent()) {
                throw new IllegalArgumentException("Cannot open id store");
            }
            this.idAuthorities[i] = new ConsistentKeyIDAuthority(idStore, (StoreManager)this.manager[i], (Configuration)sc);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.close();
    }

    public void close() throws BackendException {
        for (int i = 0; i < 8; ++i) {
            this.idAuthorities[i].close();
            this.manager[i].close();
        }
    }

    private void checkBlock(IDBlock block) {
        Assert.assertTrue((this.blockSize < 10000L ? 1 : 0) != 0);
        LongHashSet ids = new LongHashSet((int)this.blockSize);
        this.checkBlock(block, (LongSet)ids);
    }

    private void checkBlock(IDBlock block, LongSet ids) {
        Assert.assertEquals((long)this.blockSize, (long)block.numIds());
        int i = 0;
        while ((long)i < this.blockSize) {
            long id = block.getId((long)i);
            Assert.assertEquals((long)id, (long)block.getId((long)i));
            Assert.assertFalse((boolean)ids.contains(id));
            Assert.assertTrue((id < this.idUpperBound ? 1 : 0) != 0);
            Assert.assertTrue((id > 0L ? 1 : 0) != 0);
            ids.add(id);
            ++i;
        }
        if (this.hasEmptyUid) {
            Assert.assertEquals((long)(this.blockSize - 1L), (long)(block.getId(block.numIds() - 1L) - block.getId(0L)));
        }
        try {
            block.getId(this.blockSize);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testAuthorityUniqueIDsAreDistinct() {
        HashSet<String> uids = new HashSet<String>();
        String uidErrorMessage = "Uniqueness failure detected for config option " + GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID.getName();
        for (int i = 0; i < 8; ++i) {
            String uid = this.idAuthorities[i].getUniqueID();
            Assert.assertTrue((String)uidErrorMessage, (!uids.contains(uid) ? 1 : 0) != 0);
            uids.add(uid);
        }
        Assert.assertEquals((String)uidErrorMessage, (long)8L, (long)uids.size());
    }

    @Test
    public void testSimpleIDAcquisition() throws BackendException {
        InnerIDBlockSizer blockSizer = new InnerIDBlockSizer();
        this.idAuthorities[0].setIDBlockSizer((IDBlockSizer)blockSizer);
        int numTrials = 100;
        LongHashSet ids = new LongHashSet((int)this.blockSize * numTrials);
        long previous = 0L;
        for (int i = 0; i < numTrials; ++i) {
            IDBlock block = this.idAuthorities[0].getIDBlock(0, 0, GET_ID_BLOCK_TIMEOUT);
            this.checkBlock(block, (LongSet)ids);
            if (!this.hasEmptyUid) continue;
            if (previous != 0L) {
                Assert.assertEquals((long)(previous + 1L), (long)block.getId(0L));
            }
            previous = block.getId(block.numIds() - 1L);
        }
    }

    @Test
    public void testIDExhaustion() throws BackendException {
        int chunks = 30;
        IDBlockSizer blockSizer = new IDBlockSizer(){

            public long getBlockSize(int idNamespace) {
                return ((1L << (int)(IDAuthorityTest.this.idUpperBoundBitWidth - (long)IDAuthorityTest.this.uidBitWidth)) - 1L) / 30L;
            }

            public long getIdUpperBound(int idNamespace) {
                return IDAuthorityTest.this.idUpperBound;
            }
        };
        this.idAuthorities[0].setIDBlockSizer(blockSizer);
        if (this.hasFixedUid) {
            for (int i = 0; i < 30; ++i) {
                this.idAuthorities[0].getIDBlock(0, 0, GET_ID_BLOCK_TIMEOUT);
            }
            try {
                this.idAuthorities[0].getIDBlock(0, 0, GET_ID_BLOCK_TIMEOUT);
                Assert.fail();
            }
            catch (IDPoolExhaustedException i) {}
        } else {
            int i;
            for (i = 0; i < 30 * Math.max(1, (1 << this.uidBitWidth) / 10); ++i) {
                this.idAuthorities[0].getIDBlock(0, 0, GET_ID_BLOCK_TIMEOUT);
            }
            try {
                for (i = 0; i < 30 * Math.max(1, (1 << this.uidBitWidth) * 9 / 10); ++i) {
                    this.idAuthorities[0].getIDBlock(0, 0, GET_ID_BLOCK_TIMEOUT);
                }
                Assert.fail();
            }
            catch (IDPoolExhaustedException iDPoolExhaustedException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLocalPartitionAcquisition() throws BackendException {
        for (int c = 0; c < 8; ++c) {
            if (!this.manager[c].getFeatures().hasLocalKeyPartition()) continue;
            try {
                List partitions = this.idAuthorities[c].getLocalIDPartition();
                for (KeyRange range : partitions) {
                    Assert.assertEquals((long)range.getStart().length(), (long)range.getEnd().length());
                    for (int i = 0; i < 2; ++i) {
                        Assert.assertTrue((range.getAt(i).length() >= 4 ? 1 : 0) != 0);
                    }
                }
                continue;
            }
            catch (UnsupportedOperationException e) {
                Assert.fail();
            }
        }
    }

    @Test
    public void testManyThreadsOneIDAuthority() throws BackendException, InterruptedException, ExecutionException {
        ExecutorService es = Executors.newFixedThreadPool(8);
        final IDAuthority targetAuthority = this.idAuthorities[0];
        targetAuthority.setIDBlockSizer((IDBlockSizer)new InnerIDBlockSizer());
        boolean targetPartition = false;
        int targetNamespace = 2;
        final ConcurrentLinkedQueue blocks = new ConcurrentLinkedQueue();
        int blocksPerThread = 40;
        Assert.assertTrue((boolean)true);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(8);
        for (int c = 0; c < 8; ++c) {
            futures.add(es.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        this.getBlock();
                    }
                    catch (BackendException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }

                private void getBlock() throws BackendException {
                    for (int i = 0; i < 40; ++i) {
                        IDBlock block = targetAuthority.getIDBlock(0, 2, GET_ID_BLOCK_TIMEOUT);
                        Assert.assertNotNull((Object)block);
                        blocks.add(block);
                    }
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        es.shutdownNow();
        Assert.assertEquals((long)320L, (long)blocks.size());
        LongHashSet ids = new LongHashSet((int)this.blockSize * 40 * 8);
        for (IDBlock block : blocks) {
            this.checkBlock(block, (LongSet)ids);
        }
    }

    @Test
    public void testMultiIDAcquisition() throws Throwable {
        int numPartitions = 4;
        int numAcquisitionsPerThreadPartition = 100;
        InnerIDBlockSizer blockSizer = new InnerIDBlockSizer();
        for (int i = 0; i < 8; ++i) {
            this.idAuthorities[i].setIDBlockSizer((IDBlockSizer)blockSizer);
        }
        ArrayList ids = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            ids.add(new ConcurrentLinkedQueue());
        }
        int maxIterations = 800;
        ArrayList futures = new ArrayList(8);
        ExecutorService es = Executors.newFixedThreadPool(8);
        HashSet<String> uids = new HashSet<String>(8);
        for (int i = 0; i < 8; ++i) {
            IDAuthority iDAuthority = this.idAuthorities[i];
            IDStressor stressRunnable = new IDStressor(100, 4, 800, iDAuthority, ids);
            uids.add(iDAuthority.getUniqueID());
            futures.add(es.submit(stressRunnable));
        }
        Assert.assertEquals((long)8L, (long)uids.size());
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        for (int i = 0; i < 4; ++i) {
            ConcurrentLinkedQueue concurrentLinkedQueue = (ConcurrentLinkedQueue)ids.get(i);
            Assert.assertEquals((long)800L, (long)concurrentLinkedQueue.size());
            LongHashSet idset = new LongHashSet((int)this.blockSize * concurrentLinkedQueue.size());
            for (IDBlock block : concurrentLinkedQueue) {
                this.checkBlock(block, (LongSet)idset);
            }
        }
        es.shutdownNow();
    }

    private class IDStressor
    implements Runnable {
        private final int numRounds;
        private final int numPartitions;
        private final int maxIterations;
        private final IDAuthority authority;
        private final List<ConcurrentLinkedQueue<IDBlock>> allocatedBlocks;
        private static final long sleepMS = 250L;

        private IDStressor(int numRounds, int numPartitions, int maxIterations, IDAuthority authority, List<ConcurrentLinkedQueue<IDBlock>> ids) {
            this.numRounds = numRounds;
            this.numPartitions = numPartitions;
            this.maxIterations = maxIterations;
            this.authority = authority;
            this.allocatedBlocks = ids;
        }

        @Override
        public void run() {
            try {
                this.runInterruptible();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private void runInterruptible() throws InterruptedException {
            int iterations = 0;
            long[] lastStart = new long[this.numPartitions];
            for (int i = 0; i < this.numPartitions; ++i) {
                lastStart[i] = Long.MIN_VALUE;
            }
            for (int j = 0; j < this.numRounds; ++j) {
                for (int p = 0; p < this.numPartitions; ++p) {
                    IDBlock block;
                    if (this.maxIterations < ++iterations) {
                        this.throwIterationsExceededException();
                    }
                    if (null == (block = this.allocate(p))) {
                        Thread.sleep(250L);
                        --p;
                        continue;
                    }
                    this.allocatedBlocks.get(p).add(block);
                    if (!IDAuthorityTest.this.hasEmptyUid) continue;
                    long start = block.getId(0L);
                    Assert.assertTrue((String)("Previous block start " + lastStart[p] + " exceeds next block start " + start), (lastStart[p] <= start ? 1 : 0) != 0);
                    lastStart[p] = start;
                }
            }
        }

        private IDBlock allocate(int partitionIndex) {
            IDBlock block;
            try {
                block = this.authority.getIDBlock(partitionIndex, partitionIndex, GET_ID_BLOCK_TIMEOUT);
            }
            catch (BackendException e) {
                log.error("Unexpected exception while getting ID block", (Throwable)e);
                return null;
            }
            if (IDAuthorityTest.this.hasEmptyUid) {
                Assert.assertEquals((long)(block.getId(0L) + IDAuthorityTest.this.blockSize - 1L), (long)block.getId(IDAuthorityTest.this.blockSize - 1L));
            }
            log.trace("Obtained ID block {}", (Object)block);
            return block;
        }

        private boolean throwIterationsExceededException() {
            throw new RuntimeException("Exceeded maximum ID allocation iteration count (" + this.maxIterations + "); too many timeouts?");
        }
    }

    private class InnerIDBlockSizer
    implements IDBlockSizer {
        private InnerIDBlockSizer() {
        }

        public long getBlockSize(int idNamespace) {
            return IDAuthorityTest.this.blockSize;
        }

        public long getIdUpperBound(int idNamespace) {
            return IDAuthorityTest.this.idUpperBound;
        }
    }
}

