/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.olap;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class PageRankVertexProgram
extends StaticVertexProgram<Double> {
    public static final String PAGE_RANK = "titan.pageRank.pageRank";
    public static final String OUTGOING_EDGE_COUNT = "titan.pageRank.edgeCount";
    private static final String DAMPING_FACTOR = "titan.pageRank.dampingFactor";
    private static final String MAX_ITERATIONS = "titan.pageRank.maxIterations";
    private static final String VERTEX_COUNT = "titan.pageRank.vertexCount";
    private double dampingFactor;
    private int maxIterations;
    private long vertexCount;
    private MessageScope.Local<Double> outE = MessageScope.Local.of(() -> __.outE((String[])new String[0]));
    private MessageScope.Local<Double> inE = MessageScope.Local.of(() -> __.inE((String[])new String[0]));
    private static final Set<String> COMPUTE_KEYS = ImmutableSet.of((Object)"titan.pageRank.pageRank", (Object)"titan.pageRank.edgeCount");

    public void loadState(Graph graph, Configuration configuration) {
        this.dampingFactor = configuration.getDouble(DAMPING_FACTOR, 0.85);
        this.maxIterations = configuration.getInt(MAX_ITERATIONS, 10);
        this.vertexCount = configuration.getLong(VERTEX_COUNT, 1L);
    }

    public void storeState(Configuration configuration) {
        configuration.setProperty("gremlin.vertexProgram", (Object)PageRankVertexProgram.class.getName());
        configuration.setProperty(DAMPING_FACTOR, (Object)this.dampingFactor);
        configuration.setProperty(MAX_ITERATIONS, (Object)this.maxIterations);
        configuration.setProperty(VERTEX_COUNT, (Object)this.vertexCount);
    }

    public Set<String> getElementComputeKeys() {
        return COMPUTE_KEYS;
    }

    public void setup(Memory memory) {
    }

    public void execute(Vertex vertex, Messenger<Double> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            messenger.sendMessage(this.inE, (Object)1.0);
        } else if (1 == memory.getIteration()) {
            double initialPageRank = 1.0 / (double)this.vertexCount;
            double edgeCount = IteratorUtils.stream((Iterator)messenger.receiveMessages()).reduce(0.0, (a, b) -> a + b);
            vertex.property(VertexProperty.Cardinality.single, PAGE_RANK, (Object)initialPageRank, new Object[0]);
            vertex.property(VertexProperty.Cardinality.single, OUTGOING_EDGE_COUNT, (Object)edgeCount, new Object[0]);
            messenger.sendMessage(this.outE, (Object)(initialPageRank / edgeCount));
        } else {
            double newPageRank = IteratorUtils.stream((Iterator)messenger.receiveMessages()).reduce(0.0, (a, b) -> a + b);
            newPageRank = this.dampingFactor * newPageRank + (1.0 - this.dampingFactor) / (double)this.vertexCount;
            vertex.property(VertexProperty.Cardinality.single, PAGE_RANK, (Object)newPageRank, new Object[0]);
            messenger.sendMessage(this.outE, (Object)(newPageRank / (Double)vertex.value(OUTGOING_EDGE_COUNT)));
        }
    }

    public boolean terminate(Memory memory) {
        return memory.getIteration() >= this.maxIterations;
    }

    public Set<MessageScope> getMessageScopes(Memory memory) {
        return ImmutableSet.of(this.outE, this.inE);
    }

    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.ORIGINAL;
    }

    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.VERTEX_PROPERTIES;
    }

    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            public boolean requiresLocalMessageScopes() {
                return true;
            }

            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(PageRankVertexProgram.class);
        }

        public Builder vertexCount(long vertexCount) {
            this.configuration.setProperty(PageRankVertexProgram.VERTEX_COUNT, (Object)vertexCount);
            return this;
        }

        public Builder dampingFactor(double dampingFactor) {
            this.configuration.setProperty(PageRankVertexProgram.DAMPING_FACTOR, (Object)dampingFactor);
            return this;
        }

        public Builder iterations(int iterations) {
            this.configuration.setProperty(PageRankVertexProgram.MAX_ITERATIONS, (Object)iterations);
            return this;
        }
    }
}

