/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.olap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanGraphComputer;
import com.thinkaurelius.titan.core.TitanGraphTransaction;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanJob;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.olap.QueryContainer;
import com.thinkaurelius.titan.graphdb.olap.VertexJobConverter;
import com.thinkaurelius.titan.graphdb.olap.VertexScanJob;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraGraphComputer;
import com.thinkaurelius.titan.graphdb.olap.job.GhostVertexRemover;
import com.thinkaurelius.titan.olap.PageRankMapReduce;
import com.thinkaurelius.titan.olap.PageRankVertexProgram;
import com.thinkaurelius.titan.olap.ShortestDistanceMapReduce;
import com.thinkaurelius.titan.olap.ShortestDistanceVertexProgram;
import com.thinkaurelius.titan.testutil.TitanAssert;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OLAPTest
extends TitanGraphBaseTest {
    private static final double EPSILON = 1.0E-5;
    private static final Random random = new Random();
    private static final Logger log = LoggerFactory.getLogger(OLAPTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    private ScanMetrics executeScanJob(VertexScanJob job) throws Exception {
        return this.executeScanJob(VertexJobConverter.convert((TitanGraph)this.graph, (VertexScanJob)job));
    }

    private ScanMetrics executeScanJob(ScanJob job) throws Exception {
        return (ScanMetrics)this.graph.getBackend().buildEdgeScanJob().setNumProcessingThreads(2).setWorkBlockSize(100).setJob(job).execute().get();
    }

    private int generateRandomGraph(int numV) {
        int i;
        this.mgmt.makePropertyKey("uid").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.makePropertyKey("values").cardinality(Cardinality.LIST).dataType(Integer.class).make();
        this.mgmt.makePropertyKey("numvals").dataType(Integer.class).make();
        this.finishSchema();
        int numE = 0;
        TitanVertex[] vs = new TitanVertex[numV];
        for (i = 0; i < numV; ++i) {
            vs[i] = this.tx.addVertex(new Object[]{"uid", i + 1});
            int numVals = random.nextInt(5) + 1;
            vs[i].property(VertexProperty.Cardinality.single, "numvals", (Object)numVals, new Object[0]);
            for (int j = 0; j < numVals; ++j) {
                vs[i].property("values", (Object)random.nextInt(100));
            }
        }
        for (i = 0; i < numV; ++i) {
            int edges = i + 1;
            TitanVertex v = vs[i];
            for (int j = 0; j < edges; ++j) {
                TitanVertex u = vs[random.nextInt(numV)];
                v.addEdge("knows", (Vertex)u, new Object[0]);
                ++numE;
            }
        }
        Assert.assertEquals((long)(numV * (numV + 1)), (long)(numE * 2));
        return numE;
    }

    @Test
    public void testVertexScan() throws Exception {
        int numV = 100;
        int numE = this.generateRandomGraph(numV);
        String DEGREE_COUNT = "degree";
        String VERTEX_COUNT = "numV";
        this.clopen(new Object[0]);
        ScanMetrics result1 = this.executeScanJob(new VertexScanJob(){

            public void process(TitanVertex vertex, ScanMetrics metrics) {
                long outDegree = vertex.query().labels(new String[]{"knows"}).direction(Direction.OUT).edgeCount();
                Assert.assertEquals((long)0L, (long)vertex.query().labels(new String[]{"knows"}).direction(Direction.IN).edgeCount());
                Assert.assertEquals((long)1L, (long)vertex.query().labels(new String[]{"uid"}).propertyCount());
                Assert.assertTrue(((Integer)vertex.property("uid").orElse((Object)0) > 0 ? 1 : 0) != 0);
                metrics.incrementCustom("degree", outDegree);
                metrics.incrementCustom("numV");
            }

            public void getQueries(QueryContainer queries) {
                queries.addQuery().labels(new String[]{"knows"}).direction(Direction.OUT).edges();
                queries.addQuery().keys(new String[]{"uid"}).properties();
            }

            public VertexScanJob clone() {
                return this;
            }
        });
        Assert.assertEquals((long)numV, (long)result1.getCustom("numV"));
        Assert.assertEquals((long)numE, (long)result1.getCustom("degree"));
        ScanMetrics result2 = this.executeScanJob(new VertexScanJob(){

            public void process(TitanVertex vertex, ScanMetrics metrics) {
                metrics.incrementCustom("numV");
                Assert.assertEquals((long)1L, (long)vertex.query().labels(new String[]{"numvals"}).propertyCount());
                int numvals = (Integer)vertex.value("numvals");
                Assert.assertEquals((long)numvals, (long)vertex.query().labels(new String[]{"values"}).propertyCount());
            }

            public void getQueries(QueryContainer queries) {
                queries.addQuery().keys(new String[]{"values"}).properties();
                queries.addQuery().keys(new String[]{"numvals"}).properties();
            }

            public VertexScanJob clone() {
                return this;
            }
        });
        Assert.assertEquals((long)numV, (long)result2.getCustom("numV"));
    }

    @Test
    public void removeGhostVertices() throws Exception {
        TitanVertex v1 = this.tx.addVertex("person");
        v1.property("name", (Object)"stephen");
        TitanVertex v2 = this.tx.addVertex("person");
        v1.property("name", (Object)"marko");
        TitanVertex v3 = this.tx.addVertex("person");
        v1.property("name", (Object)"dan");
        v2.addEdge("knows", (Vertex)v3, new Object[0]);
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        this.newTx();
        long v3id = OLAPTest.getId((Element)v3);
        long v1id = OLAPTest.getId((Element)v1);
        Assert.assertTrue((v3id > 0L ? 1 : 0) != 0);
        v3 = OLAPTest.getV((TitanGraphTransaction)this.tx, v3id);
        Assert.assertNotNull((Object)v3);
        v3.remove();
        this.tx.commit();
        TitanTransaction xx = this.graph.buildTransaction().checkExternalVertexExistence(false).start();
        v3 = OLAPTest.getV((TitanGraphTransaction)xx, v3id);
        Assert.assertNotNull((Object)v3);
        v1 = OLAPTest.getV((TitanGraphTransaction)xx, v1id);
        Assert.assertNotNull((Object)v1);
        v3.property("name", (Object)"deleted");
        v3.addEdge("knows", (Vertex)v1, new Object[0]);
        xx.commit();
        this.newTx();
        Assert.assertNull((Object)OLAPTest.getV((TitanGraphTransaction)this.tx, v3id));
        v1 = OLAPTest.getV((TitanGraphTransaction)this.tx, v1id);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((long)v3id, (long)((TitanVertex)v1.query().direction(Direction.IN).labels(new String[]{"knows"}).vertices().iterator().next()).longId());
        this.tx.commit();
        this.mgmt.commit();
        ScanMetrics result = this.executeScanJob((ScanJob)new GhostVertexRemover((TitanGraph)this.graph));
        Assert.assertEquals((long)1L, (long)result.getCustom("removed-vertices"));
        Assert.assertEquals((long)2L, (long)result.getCustom("removed-relations"));
        Assert.assertEquals((long)0L, (long)result.getCustom("skipped-ghosts"));
    }

    @Test
    public void testBasicComputeJob() throws Exception {
        GraphTraversalSource g = (GraphTraversalSource)this.graph.traversal((TraversalSource.Builder)GraphTraversalSource.computer());
        System.out.println(g.V(new Object[0]).count().next());
    }

    @Test
    public void degreeCounting() throws Exception {
        int numV = 200;
        int numE = this.generateRandomGraph(numV);
        this.clopen(new Object[0]);
        FulgoraGraphComputer computer = this.graph.compute();
        computer.resultMode(TitanGraphComputer.ResultMode.NONE);
        computer.workers(4);
        computer.program((VertexProgram)new DegreeCounter());
        computer.mapReduce((MapReduce)new DegreeMapper());
        ComputerResult result = (ComputerResult)computer.submit().get();
        System.out.println("Execution time (ms) [" + numV + "|" + numE + "]: " + result.memory().getRuntime());
        Assert.assertTrue((boolean)result.memory().exists("degrees"));
        Map degrees = (Map)result.memory().get("degrees");
        Assert.assertNotNull((Object)degrees);
        Assert.assertEquals((long)numV, (long)degrees.size());
        int totalCount = 0;
        for (Map.Entry entry : degrees.entrySet()) {
            int degree = (Integer)entry.getValue();
            TitanVertex v = OLAPTest.getV((TitanGraphTransaction)this.tx, (long)((Long)entry.getKey()));
            int count = (Integer)v.value("uid");
            Assert.assertEquals((long)count, (long)degree);
            totalCount += degree;
        }
        Assert.assertEquals((long)(numV * (numV + 1) / 2), (long)totalCount);
        Assert.assertEquals((long)1L, (long)result.memory().getIteration());
    }

    @Test
    public void vertexProgramExceptionPropagatesToCaller() throws InterruptedException {
        int numV = 100;
        int numE = this.generateRandomGraph(numV);
        this.clopen(new Object[0]);
        FulgoraGraphComputer computer = this.graph.compute();
        computer.resultMode(TitanGraphComputer.ResultMode.NONE);
        computer.workers(1);
        computer.program((VertexProgram)new ExceptionProgram());
        try {
            computer.submit().get();
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void degreeCountingDistance() throws Exception {
        int numV = 100;
        int numE = this.generateRandomGraph(numV);
        this.clopen(new Object[0]);
        for (TitanGraphComputer.ResultMode mode : TitanGraphComputer.ResultMode.values()) {
            FulgoraGraphComputer computer = this.graph.compute();
            computer.resultMode(mode);
            computer.workers(1);
            computer.program((VertexProgram)new DegreeCounter(2));
            ComputerResult result = (ComputerResult)computer.submit().get();
            System.out.println("Execution time (ms) [" + numV + "|" + numE + "]: " + result.memory().getRuntime());
            Assert.assertEquals((long)2L, (long)result.memory().getIteration());
            TitanGraphTransaction gview = null;
            switch (mode) {
                case LOCALTX: {
                    gview = (TitanGraphTransaction)result.graph();
                    break;
                }
                case PERSIST: {
                    this.newTx();
                    gview = this.tx;
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new AssertionError(mode);
                }
            }
            if (gview == null) continue;
            for (TitanVertex v : gview.query().vertices()) {
                long degree2 = ((Integer)v.value("degree")).longValue();
                long actualDegree2 = 0L;
                for (TitanVertex w : v.query().direction(Direction.OUT).vertices()) {
                    actualDegree2 += (long)Iterables.size((Iterable)w.query().direction(Direction.OUT).vertices());
                }
                Assert.assertEquals((long)actualDegree2, (long)degree2);
            }
            if (mode != TitanGraphComputer.ResultMode.LOCALTX) continue;
            Assert.assertTrue((boolean)(gview instanceof TitanTransaction));
            ((TitanTransaction)gview).rollback();
        }
    }

    private void expand(Vertex v, int distance, int diameter, int branch) {
        v.property(VertexProperty.Cardinality.single, "distance", (Object)distance, new Object[0]);
        if (distance < diameter) {
            TitanVertex previous = null;
            for (int i = 0; i < branch; ++i) {
                TitanVertex u = this.tx.addVertex(new Object[0]);
                u.addEdge("likes", v, new Object[0]);
                log.debug("likes {}->{}", u.id(), v.id());
                previous = u;
                this.expand((Vertex)u, distance + 1, diameter, branch);
            }
        }
    }

    @Test
    public void testPageRank() throws ExecutionException, InterruptedException {
        this.mgmt.makePropertyKey("distance").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.makeEdgeLabel("likes").multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        int branch = 6;
        int diameter = 5;
        double alpha = 0.85;
        int numV = (int)((Math.pow(6.0, 6.0) - 1.0) / 5.0);
        TitanVertex v = this.tx.addVertex(new Object[0]);
        this.expand((Vertex)v, 0, 5, 6);
        this.clopen(new Object[0]);
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        log.debug("PR test numV: {}", (Object)numV);
        this.newTx();
        double[] correctPR = new double[6];
        for (int i = 5; i >= 0; --i) {
            double pr = 0.15000000000000002 / (double)numV;
            if (i < 5) {
                pr += 5.1 * correctPR[i + 1];
            }
            log.debug("diameter={} pr={}", (Object)5, (Object)pr);
            correctPR[i] = pr;
        }
        double correctPRSum = 0.0;
        Iterator iv = this.tx.query().vertices().iterator();
        while (iv.hasNext()) {
            correctPRSum += correctPR[(Integer)((TitanVertex)iv.next()).value("distance")];
        }
        FulgoraGraphComputer computer = this.graph.compute();
        computer.resultMode(TitanGraphComputer.ResultMode.NONE);
        computer.workers(4);
        computer.program(PageRankVertexProgram.build().iterations(10).vertexCount(numV).dampingFactor(0.85).create((Graph)this.graph));
        computer.mapReduce((MapReduce)PageRankMapReduce.build().create());
        ComputerResult result = (ComputerResult)computer.submit().get();
        Iterator ranks = (Iterator)result.memory().get("pageRank");
        Assert.assertNotNull((Object)ranks);
        int vertexCounter = 0;
        double computedPRSum = 0.0;
        correctPRSum = 0.0;
        HashSet<Long> vertexIDs = new HashSet<Long>(numV);
        while (ranks.hasNext()) {
            KeyValue rank = (KeyValue)ranks.next();
            Long vertexID = (Long)rank.getKey();
            Double computedPR = (Double)rank.getValue();
            Assert.assertNotNull((Object)vertexID);
            Assert.assertNotNull((Object)computedPR);
            TitanVertex u = OLAPTest.getV((TitanGraphTransaction)this.tx, vertexID);
            int distance = (Integer)u.value("distance");
            ++vertexCounter;
            computedPRSum += computedPR.doubleValue();
            correctPRSum += correctPR[distance];
            Assert.assertFalse((boolean)vertexIDs.contains(vertexID));
            vertexIDs.add(vertexID);
            log.debug("vertexID={} computedPR={}", (Object)vertexID, (Object)computedPR);
        }
        Assert.assertEquals((long)numV, (long)vertexCounter);
        Assert.assertEquals((double)correctPRSum, (double)computedPRSum, (double)0.001);
    }

    @Test
    public void testShortestDistance() throws Exception {
        PropertyKey distance = this.mgmt.makePropertyKey("distance").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{distance}).multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        int maxDepth = 16;
        int maxBranch = 5;
        TitanVertex vertex = this.tx.addVertex(new Object[0]);
        int numV = this.growVertex((Vertex)vertex, 0, maxDepth, maxBranch);
        int numE = numV - 1;
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        TitanAssert.assertCount(numE, this.tx.query().edges());
        log.debug("seed inE count: {}", (Object)vertex.query().direction(Direction.IN).edgeCount());
        log.debug("seed outE count: {}", (Object)vertex.query().direction(Direction.OUT).edgeCount());
        this.clopen(new Object[0]);
        FulgoraGraphComputer computer = this.graph.compute();
        computer.resultMode(TitanGraphComputer.ResultMode.NONE);
        computer.workers(4);
        computer.program(ShortestDistanceVertexProgram.build().seed((Long)vertex.id()).maxDepth(maxDepth + 4).create((Graph)this.graph));
        computer.mapReduce((MapReduce)ShortestDistanceMapReduce.build().create());
        ComputerResult result = (ComputerResult)computer.submit().get();
        Iterator distances = (Iterator)result.memory().get("shortestDistance");
        int vertexCount = 0;
        while (distances.hasNext()) {
            KeyValue kv = (KeyValue)distances.next();
            long dist = (Long)kv.getValue();
            Assert.assertTrue((String)("Invalid distance: " + dist), (dist >= 0L && dist < Integer.MAX_VALUE ? 1 : 0) != 0);
            TitanVertex v = OLAPTest.getV((TitanGraphTransaction)this.tx, kv.getKey());
            Assert.assertEquals((long)((Integer)v.value("distance")).intValue(), (long)dist);
            ++vertexCount;
        }
        Assert.assertEquals((long)numV, (long)vertexCount);
        Assert.assertTrue((0 < vertexCount ? 1 : 0) != 0);
    }

    private int growVertex(Vertex vertex, int depth, int maxDepth, int maxBranch) {
        vertex.property(VertexProperty.Cardinality.single, "distance", (Object)depth, new Object[0]);
        int total = 1;
        if (depth >= maxDepth) {
            return total;
        }
        for (int i = 0; i < random.nextInt(maxBranch) + 1; ++i) {
            int dist = random.nextInt(3) + 1;
            TitanVertex n = this.tx.addVertex(new Object[0]);
            n.addEdge("connect", vertex, new Object[]{"distance", dist});
            total += this.growVertex((Vertex)n, depth + dist, maxDepth, maxBranch);
        }
        return total;
    }

    public static class Degree {
        public int in;
        public int out;
        public int both;
        public int prop;

        public Degree(int in, int out, int prop) {
            this.in = in;
            this.out = out;
            this.both = in + out;
            this.prop = prop;
        }

        public Degree() {
            this(0, 0, 0);
        }

        public void add(Degree d) {
            this.in += d.in;
            this.out += d.out;
            this.both += d.both;
            this.prop += d.prop;
        }
    }

    public static class DegreeMapper
    extends StaticMapReduce<Long, Integer, Long, Integer, Map<Long, Integer>> {
        public static final String DEGREE_RESULT = "degrees";

        public boolean doStage(MapReduce.Stage stage) {
            return stage == MapReduce.Stage.MAP;
        }

        public void map(Vertex vertex, MapReduce.MapEmitter<Long, Integer> emitter) {
            emitter.emit((Object)((Long)vertex.id()), vertex.value("degree"));
        }

        public Map<Long, Integer> generateFinalResult(Iterator<KeyValue<Long, Integer>> keyValues) {
            HashMap<Long, Integer> result = new HashMap<Long, Integer>();
            while (keyValues.hasNext()) {
                KeyValue<Long, Integer> r = keyValues.next();
                result.put((Long)r.getKey(), (Integer)r.getValue());
            }
            return result;
        }

        public String getMemoryKey() {
            return DEGREE_RESULT;
        }
    }

    public static class DegreeCounter
    extends StaticVertexProgram<Integer> {
        public static final String DEGREE = "degree";
        public static final MessageCombiner<Integer> ADDITION = (MessageCombiner & Serializable)(a, b) -> a + b;
        public static final MessageScope.Local<Integer> DEG_MSG = MessageScope.Local.of(() -> __.inE((String[])new String[0]));
        private final int length;

        public DegreeCounter() {
            this(1);
        }

        public DegreeCounter(int length) {
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0);
            this.length = length;
        }

        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger<Integer> messenger, Memory memory) {
            if (memory.isInitialIteration()) {
                messenger.sendMessage(DEG_MSG, (Object)1);
            } else {
                int degree = IteratorUtils.stream((Iterator)messenger.receiveMessages()).reduce(0, (a, b) -> a + b);
                vertex.property(VertexProperty.Cardinality.single, DEGREE, (Object)degree, new Object[0]);
                if (memory.getIteration() < this.length) {
                    messenger.sendMessage(DEG_MSG, (Object)degree);
                }
            }
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() >= this.length;
        }

        public Set<String> getElementComputeKeys() {
            return ImmutableSet.of((Object)DEGREE);
        }

        public Optional<MessageCombiner<Integer>> getMessageCombiner() {
            return Optional.of(ADDITION);
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            if (memory.getIteration() < this.length) {
                return ImmutableSet.of(DEG_MSG);
            }
            return Collections.EMPTY_SET;
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }

        public VertexProgram.Features getFeatures() {
            return new VertexProgram.Features(){

                public boolean requiresLocalMessageScopes() {
                    return true;
                }

                public boolean requiresVertexPropertyAddition() {
                    return true;
                }
            };
        }
    }

    public static class ExceptionProgram
    extends StaticVertexProgram<Integer> {
        public void setup(Memory memory) {
        }

        public void execute(Vertex vertex, Messenger<Integer> messenger, Memory memory) {
            throw new NullPointerException();
        }

        public boolean terminate(Memory memory) {
            return memory.getIteration() > 1;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return ImmutableSet.of();
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.VERTEX_PROPERTIES;
        }

        public VertexProgram.Features getFeatures() {
            return new VertexProgram.Features(){

                public boolean requiresLocalMessageScopes() {
                    return true;
                }

                public boolean requiresVertexPropertyAddition() {
                    return true;
                }
            };
        }
    }
}

