/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanGraphTransaction;
import com.thinkaurelius.titan.core.TitanIndexQuery;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.log.TransactionRecovery;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.core.util.ManagementUtil;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLog;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.example.GraphOfTheGodsFactory;
import com.thinkaurelius.titan.graphdb.TestMockIndexProvider;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.TitanGraphTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.management.GraphIndexStatusWatcher;
import com.thinkaurelius.titan.graphdb.database.management.ManagementSystem;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.Order;
import com.thinkaurelius.titan.graphdb.log.StandardTransactionLogProcessor;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.thinkaurelius.titan.testcategory.BrittleTests;
import com.thinkaurelius.titan.testutil.TestGraphConfigs;
import com.thinkaurelius.titan.testutil.TitanAssert;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanIndexTest
extends TitanGraphBaseTest {
    public static final String INDEX = "search";
    public static final String VINDEX = "vsearch";
    public static final String EINDEX = "esearch";
    public static final String PINDEX = "psearch";
    public final boolean supportsGeoPoint;
    public final boolean supportsNumeric;
    public final boolean supportsText;
    public IndexFeatures indexFeatures;
    private static final Logger log = LoggerFactory.getLogger(TitanIndexTest.class);
    @Rule
    public TestName methodName = new TestName();

    protected TitanIndexTest(boolean supportsGeoPoint, boolean supportsNumeric, boolean supportsText) {
        this.supportsGeoPoint = supportsGeoPoint;
        this.supportsNumeric = supportsNumeric;
        this.supportsText = supportsText;
    }

    private Parameter getStringMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.STRING)) {
            return Mapping.STRING.asParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.asParameter();
        }
        throw new AssertionError((Object)"String mapping not supported");
    }

    private Parameter getTextMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXT)) {
            return Mapping.TEXT.asParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.asParameter();
        }
        throw new AssertionError((Object)"Text mapping not supported");
    }

    private Parameter getFieldMap(PropertyKey key) {
        return ParameterType.MAPPED_NAME.getParameter((Object)key.name());
    }

    public abstract boolean supportsLuceneStyleQueries();

    public abstract boolean supportsWildcardQuery();

    @Override
    public void open(WriteConfiguration config) {
        super.open(config);
        this.indexFeatures = (IndexFeatures)this.graph.getBackend().getIndexFeatures().get(INDEX);
    }

    @Override
    public void clopen(Object ... settings) {
        this.graph.tx().commit();
        super.clopen(settings);
    }

    @Test
    public void testGraphOfTheGods() {
        GraphOfTheGodsFactory.load((TitanGraph)this.graph);
        TitanIndexTest.assertGraphOfTheGods((TitanGraph)this.graph);
    }

    public static void assertGraphOfTheGods(TitanGraph gotg) {
        TitanAssert.assertCount(12L, gotg.query().vertices());
        TitanAssert.assertCount(3L, gotg.query().has(LABEL_NAME, (Object)"god").vertices());
        TitanVertex h = TitanIndexTest.getOnlyVertex(gotg.query().has("name", (Object)"hercules"));
        Assert.assertEquals((long)30L, (long)((Integer)h.value("age")).intValue());
        Assert.assertEquals((Object)"demigod", (Object)h.label());
        TitanAssert.assertCount(5L, h.query().direction(Direction.BOTH).edges());
        gotg.tx().commit();
    }

    @Test
    public void testSimpleUpdate() {
        PropertyKey name = this.makeKey("name", String.class);
        EdgeLabel knows = this.makeLabel("knows");
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("namee", Edge.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        TitanVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        TitanEdge e = v.addEdge("knows", (Vertex)v, new Object[]{"name", "Hulu Bubab"});
        TitanAssert.assertCount(1L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"marko").vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new long[0])) {
            Assert.assertEquals((Object)"Marko Rodriguez", (Object)u.value("name"));
        }
        this.clopen(new Object[0]);
        TitanAssert.assertCount(1L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"marko").vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new long[0])) {
            Assert.assertEquals((Object)"Marko Rodriguez", (Object)u.value("name"));
        }
        v = TitanIndexTest.getOnlyVertex(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.single, "name", (Object)"Marko", new Object[0]);
        e = TitanIndexTest.getOnlyEdge(v.query().direction(Direction.OUT));
        e.property("name", (Object)"Tubu Rubu");
        TitanAssert.assertCount(1L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"marko").vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Rubu").edges());
        TitanAssert.assertCount(0L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new long[0])) {
            Assert.assertEquals((Object)"Marko", (Object)u.value("name"));
        }
        this.clopen(new Object[0]);
        TitanAssert.assertCount(1L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"marko").vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Rubu").edges());
        TitanAssert.assertCount(0L, this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new long[0])) {
            Assert.assertEquals((Object)"Marko", (Object)u.value("name"));
        }
    }

    @Test
    public void testIndexing() {
        int i;
        double offset;
        int i2;
        int numV;
        PropertyKey text = this.makeKey("text", String.class);
        this.createExternalVertexIndex(text, INDEX);
        this.createExternalEdgeIndex(text, INDEX);
        PropertyKey location = this.makeKey("location", Geoshape.class);
        this.createExternalVertexIndex(location, INDEX);
        this.createExternalEdgeIndex(location, INDEX);
        PropertyKey boundary = this.makeKey("boundary", Geoshape.class);
        this.mgmt.addIndexKey(this.getExternalIndex(Vertex.class, INDEX), boundary, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.PREFIX_TREE), Parameter.of((String)"index-geo-dist-error-pct", (Object)0.0025)});
        this.mgmt.addIndexKey(this.getExternalIndex(Edge.class, INDEX), boundary, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.PREFIX_TREE), Parameter.of((String)"index-geo-dist-error-pct", (Object)0.0025)});
        PropertyKey time = this.makeKey("time", Long.class);
        this.createExternalVertexIndex(time, INDEX);
        this.createExternalEdgeIndex(time, INDEX);
        PropertyKey category = this.makeKey("category", Integer.class);
        this.mgmt.buildIndex("vcategory", Vertex.class).addKey(category).buildCompositeIndex();
        this.mgmt.buildIndex("ecategory", Edge.class).addKey(category).buildCompositeIndex();
        PropertyKey group = this.makeKey("group", Byte.class);
        this.createExternalVertexIndex(group, INDEX);
        this.createExternalEdgeIndex(group, INDEX);
        PropertyKey id = this.makeVertexIndexedKey("uid", Integer.class);
        EdgeLabel knows = ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{time}).signature(new PropertyKey[]{location, boundary}).make();
        this.finishSchema();
        this.clopen(new Object[0]);
        String[] words = new String[]{"world", "aurelius", "titan", "graph"};
        int numCategories = 5;
        int numGroups = 10;
        int originalNumV = numV = 100;
        for (i2 = 0; i2 < numV; ++i2) {
            TitanVertex v = this.tx.addVertex(new Object[0]);
            v.property(VertexProperty.Cardinality.single, "uid", (Object)i2, new Object[0]);
            v.property(VertexProperty.Cardinality.single, "category", (Object)(i2 % numCategories), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "group", (Object)(i2 % numGroups), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "text", (Object)("Vertex " + words[i2 % words.length]), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "time", (Object)i2, new Object[0]);
            offset = (double)(i2 % 2 == 0 ? 1 : -1) * ((double)i2 * 50.0 / (double)numV);
            v.property(VertexProperty.Cardinality.single, "location", (Object)Geoshape.point((double)(0.0 + offset), (double)(0.0 + offset)), new Object[0]);
            if (i2 % 2 == 0) {
                v.property(VertexProperty.Cardinality.single, "boundary", (Object)Geoshape.line((double[])new double[]{offset - 0.1, offset - 0.1, offset + 0.1, offset - 0.1, offset + 0.1, offset + 0.1, offset - 0.1, offset + 0.1}), new Object[0]);
            } else {
                v.property(VertexProperty.Cardinality.single, "boundary", (Object)Geoshape.polygon((double[])new double[]{offset - 0.1, offset - 0.1, offset + 0.1, offset - 0.1, offset + 0.1, offset + 0.1, offset - 0.1, offset + 0.1, offset - 0.1, offset - 0.1}), new Object[0]);
            }
            TitanEdge e = v.addEdge("knows", (Vertex)this.getVertex("uid", (Object)Math.max(0, i2 - 1)), new Object[0]);
            e.property("text", (Object)("Vertex " + words[i2 % words.length]));
            e.property("time", (Object)i2);
            e.property("category", (Object)(i2 % numCategories));
            e.property("group", (Object)(i2 % numGroups));
            e.property("location", (Object)Geoshape.point((double)(0.0 + offset), (double)(0.0 + offset)));
            if (i2 % 2 == 0) {
                e.property("boundary", (Object)Geoshape.line((double[])new double[]{offset - 0.1, offset - 0.1, offset + 0.1, offset - 0.1, offset + 0.1, offset + 0.1, offset - 0.1, offset + 0.1}));
                continue;
            }
            e.property("boundary", (Object)Geoshape.polygon((double[])new double[]{offset - 0.1, offset - 0.1, offset + 0.1, offset - 0.1, offset + 0.1, offset + 0.1, offset - 0.1, offset + 0.1, offset - 0.1, offset - 0.1}));
        }
        for (i2 = 0; i2 < words.length; ++i2) {
            int expectedSize = numV / words.length;
            TitanAssert.assertCount(expectedSize, this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i2]).vertices());
            TitanAssert.assertCount(expectedSize, this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i2]).edges());
            for (String orderKey : new String[]{"time", "category"}) {
                for (Order order : Order.values()) {
                    for (TitanGraphQuery traversal : ImmutableList.of((Object)this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i2]).orderBy(orderKey, order.getTP()), (Object)this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i2]).orderBy(orderKey, order.getTP()))) {
                        TitanIndexTest.verifyElementOrder(traversal.vertices(), orderKey, order, expectedSize);
                    }
                }
            }
        }
        TitanAssert.assertCount(3L, this.tx.query().has("group", (Object)3).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(3).vertices());
        TitanAssert.assertCount(3L, this.tx.query().has("group", (Object)3).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(3).edges());
        for (i2 = 0; i2 < numV / 2; i2 += numV / 10) {
            TitanAssert.assertCount(i2, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i2).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)(i2 + i2)).vertices());
            TitanAssert.assertCount(i2, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i2).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)(i2 + i2)).edges());
        }
        for (i2 = 0; i2 < numV; i2 += 5) {
            this.testGeo(i2, originalNumV, numV, "location", "boundary");
        }
        TitanAssert.assertCount(4L, this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).vertices());
        TitanAssert.assertCount(4L, this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).edges());
        TitanAssert.assertCount(5L, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)10).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)30).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        offset = 950.0 / (double)originalNumV;
        double distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        TitanAssert.assertCount(5L, this.tx.query().has("location", (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        TitanAssert.assertCount(5L, this.tx.query().has("boundary", (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        TitanAssert.assertCount(numV, this.tx.query().edges());
        this.clopen(new Object[0]);
        for (i2 = 0; i2 < words.length; ++i2) {
            int expectedSize = numV / words.length;
            TitanAssert.assertCount(expectedSize, this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i2]).vertices());
            TitanAssert.assertCount(expectedSize, this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i2]).edges());
            for (String orderKey : new String[]{"time", "category"}) {
                for (Order order : Order.values()) {
                    for (TitanGraphQuery traversal : ImmutableList.of((Object)this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i2]).orderBy(orderKey, order.getTP()), (Object)this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i2]).orderBy(orderKey, order.getTP()))) {
                        TitanIndexTest.verifyElementOrder(traversal.vertices(), orderKey, order, expectedSize);
                    }
                }
            }
        }
        TitanAssert.assertCount(3L, this.tx.query().has("group", (Object)3).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(3).vertices());
        TitanAssert.assertCount(3L, this.tx.query().has("group", (Object)3).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(3).edges());
        for (i2 = 0; i2 < numV / 2; i2 += numV / 10) {
            TitanAssert.assertCount(i2, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i2).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)(i2 + i2)).vertices());
            TitanAssert.assertCount(i2, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i2).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)(i2 + i2)).edges());
        }
        for (i2 = 0; i2 < numV; i2 += 5) {
            this.testGeo(i2, originalNumV, numV, "location", "boundary");
        }
        TitanAssert.assertCount(4L, this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).vertices());
        TitanAssert.assertCount(4L, this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).edges());
        TitanAssert.assertCount(5L, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)10).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)30).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        offset = 950.0 / (double)originalNumV;
        distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        TitanAssert.assertCount(5L, this.tx.query().has("location", (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        TitanAssert.assertCount(5L, this.tx.query().has("boundary", (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        TitanAssert.assertCount(numV, this.tx.query().edges());
        this.newTx();
        int numDelete = 12;
        for (i = numV - numDelete; i < numV; ++i) {
            this.getVertex("uid", (Object)i).remove();
        }
        numV -= numDelete;
        for (i = 0; i < words.length; ++i) {
            TitanAssert.assertCount(numV / words.length, this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i]).vertices());
            TitanAssert.assertCount(numV / words.length, this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)words[i]).edges());
        }
        for (i = 0; i < numV / 2; i += numV / 10) {
            TitanAssert.assertCount(i, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)(i + i)).vertices());
            TitanAssert.assertCount(i, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)(i + i)).edges());
        }
        for (i = 0; i < numV; i += 5) {
            this.testGeo(i, originalNumV, numV, "location", "boundary");
        }
        TitanAssert.assertCount(5L, this.tx.query().has("time", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)10).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)30).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        offset = 950.0 / (double)originalNumV;
        distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        TitanAssert.assertCount(5L, this.tx.query().has("location", (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        TitanAssert.assertCount(5L, this.tx.query().has("boundary", (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (TitanPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        TitanAssert.assertCount(numV, this.tx.query().edges());
    }

    @Test
    public void testBooleanIndexing() {
        PropertyKey name = this.makeKey("visible", Boolean.class);
        this.mgmt.buildIndex("booleanIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("visible", (Object)true);
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("visible", (Object)false);
        TitanAssert.assertCount(2L, this.graph.vertices(new Object[0]));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)true)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)false)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("visible", (TitanPredicate)Cmp.NOT_EQUAL, (Object)true)));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("visible", (TitanPredicate)Cmp.NOT_EQUAL, (Object)false)));
        this.clopen(new Object[0]);
        TitanAssert.assertCount(2L, this.graph.vertices(new Object[0]));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)true)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)false)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("visible", (TitanPredicate)Cmp.NOT_EQUAL, (Object)true)));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("visible", (TitanPredicate)Cmp.NOT_EQUAL, (Object)false)));
    }

    @Test
    public void testDateIndexing() {
        PropertyKey name = this.makeKey("date", Date.class);
        this.mgmt.buildIndex("dateIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("date", (Object)new Date(1L));
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("date", (Object)new Date(2000L));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("date", (TitanPredicate)Cmp.EQUAL, (Object)new Date(1L))));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("date", (TitanPredicate)Cmp.GREATER_THAN, (Object)new Date(1L))));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new TitanVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)new Date(1L)).vertices()));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("date", (TitanPredicate)Cmp.LESS_THAN, (Object)new Date(2000L))));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new TitanVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (TitanPredicate)Cmp.LESS_THAN_EQUAL, (Object)new Date(2000L)).vertices()));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("date", (TitanPredicate)Cmp.NOT_EQUAL, (Object)new Date(1L))));
        this.clopen(new Object[0]);
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("date", (TitanPredicate)Cmp.EQUAL, (Object)new Date(1L))));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("date", (TitanPredicate)Cmp.GREATER_THAN, (Object)new Date(1L))));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new TitanVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)new Date(1L)).vertices()));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("date", (TitanPredicate)Cmp.LESS_THAN, (Object)new Date(2000L))));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new TitanVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (TitanPredicate)Cmp.LESS_THAN_EQUAL, (Object)new Date(2000L)).vertices()));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("date", (TitanPredicate)Cmp.NOT_EQUAL, (Object)new Date(1L))));
    }

    @Test
    public void testInstantIndexing() {
        PropertyKey name = this.makeKey("instant", Instant.class);
        this.mgmt.buildIndex("instantIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        Instant firstTimestamp = Instant.ofEpochMilli(1L);
        Instant secondTimestamp = Instant.ofEpochMilli(2000L);
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("instant", (Object)firstTimestamp);
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("instant", (Object)secondTimestamp);
        this.testInstant(firstTimestamp, secondTimestamp, v1, v2);
        firstTimestamp = Instant.ofEpochSecond(0L, 1L);
        v1 = (TitanVertex)this.graph.vertices(new Object[]{v1.id()}).next();
        v1.property("instant", (Object)firstTimestamp);
        if (this.indexFeatures.supportsNanoseconds()) {
            this.testInstant(firstTimestamp, secondTimestamp, v1, v2);
        } else {
            this.clopen(new Object[0]);
            try {
                Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
                Assert.fail((String)"Should have failed to update the index");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void testInstant(Instant firstTimestamp, Instant secondTimestamp, TitanVertex v1, TitanVertex v2) {
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.GREATER_THAN, (Object)firstTimestamp)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new TitanVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)firstTimestamp).vertices()));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.LESS_THAN, (Object)secondTimestamp)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new TitanVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (TitanPredicate)Cmp.LESS_THAN_EQUAL, (Object)secondTimestamp).vertices()));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.NOT_EQUAL, (Object)firstTimestamp)));
        this.clopen(new Object[0]);
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.GREATER_THAN, (Object)firstTimestamp)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new TitanVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)firstTimestamp).vertices()));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.LESS_THAN, (Object)secondTimestamp)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new TitanVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (TitanPredicate)Cmp.LESS_THAN_EQUAL, (Object)secondTimestamp).vertices()));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("instant", (TitanPredicate)Cmp.NOT_EQUAL, (Object)firstTimestamp)));
    }

    @Test
    public void testUUIDIndexing() {
        PropertyKey name = this.makeKey("uid", UUID.class);
        this.mgmt.buildIndex("uuidIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        UUID uid1 = UUID.randomUUID();
        UUID uid2 = UUID.randomUUID();
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("uid", (Object)uid1);
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("uid", (Object)uid2);
        TitanAssert.assertCount(2L, this.graph.query().vertices());
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid1)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid2)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("uid", (TitanPredicate)Cmp.NOT_EQUAL, (Object)uid1)));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("uid", (TitanPredicate)Cmp.NOT_EQUAL, (Object)uid2)));
        this.clopen(new Object[0]);
        TitanAssert.assertCount(2L, this.graph.query().vertices());
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid1)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid2)));
        Assert.assertEquals((Object)v2, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("uid", (TitanPredicate)Cmp.NOT_EQUAL, (Object)uid1)));
        Assert.assertEquals((Object)v1, (Object)TitanIndexTest.getOnlyVertex(this.graph.query().has("uid", (TitanPredicate)Cmp.NOT_EQUAL, (Object)uid2)));
    }

    @Test
    public void testConditionalIndexing() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("org").make();
        TitanGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
        TitanGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).indexOnly((TitanSchemaType)person).addKey(text, new Parameter[]{this.getTextMapping()}).addKey(weight).buildMixedIndex(INDEX);
        TitanGraphIndex index3 = this.mgmt.buildIndex("index3", Vertex.class).indexOnly((TitanSchemaType)org).addKey(text, new Parameter[]{this.getTextMapping()}).addKey(weight).buildMixedIndex(INDEX);
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("index1"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("index"));
        TitanAssert.assertCount(3L, this.mgmt.getGraphIndexes(Vertex.class));
        Assert.assertNull((Object)this.mgmt.getGraphIndex("indexx"));
        name = this.mgmt.getPropertyKey("name");
        weight = this.mgmt.getPropertyKey("weight");
        text = this.mgmt.getPropertyKey("text");
        person = this.mgmt.getVertexLabel("person");
        org = this.mgmt.getVertexLabel("org");
        index1 = this.mgmt.getGraphIndex("index1");
        index2 = this.mgmt.getGraphIndex("index2");
        index3 = this.mgmt.getGraphIndex("index3");
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(index1.getIndexedElement()));
        Assert.assertEquals((Object)"index2", (Object)index2.name());
        Assert.assertEquals((Object)INDEX, (Object)index3.getBackingIndex());
        Assert.assertFalse((boolean)index2.isUnique());
        Assert.assertEquals((long)2L, (long)index3.getFieldKeys().length);
        Assert.assertEquals((long)1L, (long)index1.getFieldKeys().length);
        Assert.assertEquals((long)3L, (long)index3.getParametersFor(text).length);
        Assert.assertEquals((long)2L, (long)index3.getParametersFor(weight).length);
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildMixedIndex(INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.addIndexKey(index2, weight, new Parameter[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("index1"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("index"));
        TitanAssert.assertCount(3L, this.mgmt.getGraphIndexes(Vertex.class));
        Assert.assertNull((Object)this.mgmt.getGraphIndex("indexx"));
        name = this.mgmt.getPropertyKey("name");
        weight = this.mgmt.getPropertyKey("weight");
        text = this.mgmt.getPropertyKey("text");
        person = this.mgmt.getVertexLabel("person");
        org = this.mgmt.getVertexLabel("org");
        index1 = this.mgmt.getGraphIndex("index1");
        index2 = this.mgmt.getGraphIndex("index2");
        index3 = this.mgmt.getGraphIndex("index3");
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(index1.getIndexedElement()));
        Assert.assertEquals((Object)"index2", (Object)index2.name());
        Assert.assertEquals((Object)INDEX, (Object)index3.getBackingIndex());
        Assert.assertFalse((boolean)index2.isUnique());
        Assert.assertEquals((long)2L, (long)index3.getFieldKeys().length);
        Assert.assertEquals((long)1L, (long)index1.getFieldKeys().length);
        Assert.assertEquals((long)3L, (long)index3.getParametersFor(text).length);
        Assert.assertEquals((long)2L, (long)index3.getParametersFor(weight).length);
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildMixedIndex(INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.addIndexKey(index2, weight, new Parameter[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        weight = this.tx.getPropertyKey("weight");
        int numV = 200;
        String[] strs = new String[]{"houseboat", "humanoid", "differential", "extraordinary"};
        String[] strs2 = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            strs2[i] = strs[i] + " " + strs[i];
        }
        int modulo = 5;
        assert (200 % (5 * strs.length * 2) == 0);
        for (int i = 0; i < 200; ++i) {
            TitanVertex v = this.tx.addVertex(i % 2 == 0 ? "person" : "org");
            v.property("name", (Object)strs[i % strs.length]);
            v.property("text", (Object)strs[i % strs.length]);
            v.property("weight", (Object)((double)(i % 5) + 0.5));
        }
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.DESC, index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"org"), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[1]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"org").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.DESC, index3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)2.5).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / (5 * strs.length), new boolean[]{true, true}, index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, true}, index1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, index1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index1.name(), index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.ASC, index1.name(), index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, false}, weight, Order.ASC, new String[0]);
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.DESC, index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"org"), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[1]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"org").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.DESC, index3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)2.5).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / (5 * strs.length), new boolean[]{true, true}, index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, true}, index1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, index1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index1.name(), index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(LABEL_NAME, (TitanPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.ASC, index1.name(), index2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, false}, weight, Order.ASC, new String[0]);
    }

    @Test
    public void testCompositeAndMixedIndexing() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey text = this.makeKey("text", String.class);
        PropertyKey flag = this.makeKey("flag", Boolean.class);
        TitanGraphIndex composite = this.mgmt.buildIndex("composite", Vertex.class).addKey(name).addKey(weight).buildCompositeIndex();
        TitanGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(weight).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        mixed.name();
        composite.name();
        this.finishSchema();
        int numV = 100;
        String[] strs = new String[]{"houseboat", "humanoid", "differential", "extraordinary"};
        String[] strs2 = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            strs2[i] = strs[i] + " " + strs[i];
        }
        int modulo = 5;
        int divisor = 5 * strs.length;
        for (int i = 0; i < 100; ++i) {
            TitanVertex v = this.tx.addVertex(new Object[0]);
            v.property("name", (Object)strs[i % strs.length]);
            v.property("text", (Object)strs[i % strs.length]);
            v.property("weight", (Object)((double)(i % 5) + 0.5));
            v.property("flag", (Object)true);
        }
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, mixed.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("flag"), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{false, true}, mixed.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, composite.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, composite.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)2.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)2.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)3.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name(), composite.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)3.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name(), composite.name());
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, mixed.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("flag"), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{false, true}, mixed.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, composite.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, composite.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)2.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)2.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)3.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name(), composite.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)3.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name(), composite.name());
    }

    private void setupChainGraph(int numV, String[] strs, boolean sameNameMapping) {
        this.clopen(TitanIndexTest.option(GraphDatabaseConfiguration.INDEX_NAME_MAPPING, INDEX), sameNameMapping);
        TitanGraphIndex vindex = this.getExternalIndex(Vertex.class, INDEX);
        TitanGraphIndex eindex = this.getExternalIndex(Edge.class, INDEX);
        TitanGraphIndex pindex = this.getExternalIndex(TitanVertexProperty.class, INDEX);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.addIndexKey(vindex, name, new Parameter[]{this.getStringMapping()});
        this.mgmt.addIndexKey(eindex, name, new Parameter[]{this.getStringMapping()});
        this.mgmt.addIndexKey(pindex, name, new Parameter[]{this.getStringMapping(), Parameter.of((String)"mapped-name", (Object)"xstr")});
        PropertyKey text = this.makeKey("text", String.class);
        this.mgmt.addIndexKey(vindex, text, new Parameter[]{this.getTextMapping(), Parameter.of((String)"mapped-name", (Object)"xtext")});
        this.mgmt.addIndexKey(eindex, text, new Parameter[]{this.getTextMapping()});
        this.mgmt.addIndexKey(pindex, text, new Parameter[]{this.getTextMapping()});
        this.mgmt.makeEdgeLabel("knows").signature(new PropertyKey[]{name}).make();
        this.mgmt.makePropertyKey("uid").dataType(String.class).signature(new PropertyKey[]{text}).make();
        this.finishSchema();
        TitanVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            TitanVertex v = this.graph.addVertex(new Object[]{"name", strs[i % strs.length], "text", strs[i % strs.length]});
            TitanEdge e = v.addEdge("knows", (Vertex)(previous == null ? v : previous), new Object[]{"name", strs[i % strs.length], "text", strs[i % strs.length]});
            TitanVertexProperty p = v.property("uid", (Object)("v" + i), new Object[]{"name", strs[i % strs.length], "text", strs[i % strs.length]});
            previous = v;
        }
    }

    @Test
    public void testIndexParameters() {
        int numV = 1000;
        String[] strs = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(numV, strs, false);
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.VERTEX, numV / strs.length * 2, new boolean[]{true, true}, VINDEX);
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks").vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"farm").vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"beautiful").vertices());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.VERTEX, numV / strs.length, new boolean[]{true, true}, VINDEX);
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").vertices());
        TitanAssert.assertCount(0L, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"lolipop").vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).vertices());
        TitanAssert.assertCount(numV / strs.length * (strs.length - 1), this.graph.query().has("name", (TitanPredicate)Cmp.NOT_EQUAL, (Object)strs[2]).vertices());
        TitanAssert.assertCount(0L, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"farm").vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"ducks").vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("name", (TitanPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").vertices());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.EDGE, numV / strs.length * 2, new boolean[]{true, true}, EINDEX);
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks").edges());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"farm").edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"beautiful").edges());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.EDGE, numV / strs.length, new boolean[]{true, true}, EINDEX);
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").edges());
        TitanAssert.assertCount(0L, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"lolipop").edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).edges());
        TitanAssert.assertCount(numV / strs.length * (strs.length - 1), this.graph.query().has("name", (TitanPredicate)Cmp.NOT_EQUAL, (Object)strs[2]).edges());
        TitanAssert.assertCount(0L, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"farm").edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"ducks").edges());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("name", (TitanPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").edges());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.PROPERTY, numV / strs.length * 2, new boolean[]{true, true}, PINDEX);
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks").properties());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"farm").properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"beautiful").properties());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.PROPERTY, numV / strs.length, new boolean[]{true, true}, PINDEX);
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").properties());
        TitanAssert.assertCount(0L, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"lolipop").properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).properties());
        TitanAssert.assertCount(numV / strs.length * (strs.length - 1), this.graph.query().has(LABEL_NAME, (Object)"uid").has("name", (TitanPredicate)Cmp.NOT_EQUAL, (Object)strs[2]).properties());
        TitanAssert.assertCount(0L, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"farm").properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"ducks").properties());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("name", (TitanPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").properties());
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.VERTEX, numV / strs.length * 2, new boolean[]{true, true}, VINDEX);
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks").vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"farm").vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"beautiful").vertices());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.VERTEX, numV / strs.length, new boolean[]{true, true}, VINDEX);
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").vertices());
        TitanAssert.assertCount(0L, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"lolipop").vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).vertices());
        TitanAssert.assertCount(numV / strs.length * (strs.length - 1), this.graph.query().has("name", (TitanPredicate)Cmp.NOT_EQUAL, (Object)strs[2]).vertices());
        TitanAssert.assertCount(0L, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"farm").vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"ducks").vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("name", (TitanPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").vertices());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.EDGE, numV / strs.length * 2, new boolean[]{true, true}, EINDEX);
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks").edges());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"farm").edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"beautiful").edges());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.EDGE, numV / strs.length, new boolean[]{true, true}, EINDEX);
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").edges());
        TitanAssert.assertCount(0L, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"lolipop").edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).edges());
        TitanAssert.assertCount(numV / strs.length * (strs.length - 1), this.graph.query().has("name", (TitanPredicate)Cmp.NOT_EQUAL, (Object)strs[2]).edges());
        TitanAssert.assertCount(0L, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"farm").edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"ducks").edges());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("name", (TitanPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").edges());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.PROPERTY, numV / strs.length * 2, new boolean[]{true, true}, PINDEX);
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"ducks").properties());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"farm").properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"beautiful").properties());
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.PROPERTY, numV / strs.length, new boolean[]{true, true}, PINDEX);
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").properties());
        TitanAssert.assertCount(0L, this.graph.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"lolipop").properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)strs[1]).properties());
        TitanAssert.assertCount(numV / strs.length * (strs.length - 1), this.graph.query().has(LABEL_NAME, (Object)"uid").has("name", (TitanPredicate)Cmp.NOT_EQUAL, (Object)strs[2]).properties());
        TitanAssert.assertCount(0L, this.graph.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"farm").properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"ducks").properties());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.query().has("name", (TitanPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").properties());
        if (this.supportsLuceneStyleQueries()) {
            TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(VINDEX, "xtext:ducks").vertices());
            TitanAssert.assertCount(0L, this.graph.indexQuery(EINDEX, "xtext:ducks").edges());
        }
    }

    @Test
    public void testRawQueries() {
        if (!this.supportsLuceneStyleQueries()) {
            return;
        }
        int numV = 1000;
        String[] strs = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(numV, strs, true);
        this.clopen(new Object[0]);
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(VINDEX, "v.text:ducks").vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(VINDEX, "v.text:(farm uncle berry)").vertices());
        TitanAssert.assertCount(numV / strs.length, this.graph.indexQuery(VINDEX, "v.text:(farm uncle berry) AND v.name:\"Uncle Berry has a farm\"").vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(VINDEX, "v.text:(beautiful are ducks)").vertices());
        TitanAssert.assertCount(numV / strs.length * 2 - 10, this.graph.indexQuery(VINDEX, "v.text:(beautiful are ducks)").offset(10).vertices());
        TitanAssert.assertCount(10L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).vertices());
        TitanAssert.assertCount(10L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(10).vertices());
        TitanAssert.assertCount(0L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(numV).vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(VINDEX, "xtext:ducks").vertices());
        TitanAssert.assertCount(0L, this.graph.indexQuery(VINDEX, "text:ducks").vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(VINDEX, "$v$text:ducks").setElementIdentifier("$v$").vertices());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(EINDEX, "e.text:ducks").edges());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(EINDEX, "e.text:(farm uncle berry)").edges());
        TitanAssert.assertCount(numV / strs.length, this.graph.indexQuery(EINDEX, "e.text:(farm uncle berry) AND e.name:\"Uncle Berry has a farm\"").edges());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(EINDEX, "e.text:(beautiful are ducks)").edges());
        TitanAssert.assertCount(numV / strs.length * 2 - 10, this.graph.indexQuery(EINDEX, "e.text:(beautiful are ducks)").offset(10).edges());
        TitanAssert.assertCount(10L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).edges());
        TitanAssert.assertCount(10L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(10).edges());
        TitanAssert.assertCount(0L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(numV).edges());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(EINDEX, "text:ducks").edges());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(PINDEX, "p.text:ducks").properties());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(PINDEX, "p.text:(farm uncle berry)").properties());
        TitanAssert.assertCount(numV / strs.length, this.graph.indexQuery(PINDEX, "p.text:(farm uncle berry) AND p.name:\"Uncle Berry has a farm\"").properties());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(PINDEX, "p.text:(beautiful are ducks)").properties());
        TitanAssert.assertCount(numV / strs.length * 2 - 10, this.graph.indexQuery(PINDEX, "p.text:(beautiful are ducks)").offset(10).properties());
        TitanAssert.assertCount(10L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).properties());
        TitanAssert.assertCount(10L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(10).properties());
        TitanAssert.assertCount(0L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(numV).properties());
        TitanAssert.assertCount(numV / strs.length * 2, this.graph.indexQuery(PINDEX, "text:ducks").properties());
    }

    @Test
    public void testDualMapping() {
        if (!this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        TitanGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(name, new Parameter[]{Mapping.TEXTSTRING.asParameter()}).buildMixedIndex(INDEX);
        mixed.name();
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "Long John Don"});
        this.tx.addVertex(new Object[]{"name", "Long Little Lewis"});
        this.tx.addVertex(new Object[]{"name", "Middle Sister Mabel"});
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"Long John Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Long"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Long Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"Lon"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS_REGEX, (Object)"Lit*le"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.REGEX, (Object)"Long.*"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"Middle"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        for (Vertex u : this.tx.getVertices(new long[0])) {
            String n = (String)u.value("name");
            if (n.endsWith("Don")) {
                u.remove();
                continue;
            }
            if (n.endsWith("Lewis")) {
                u.property(VertexProperty.Cardinality.single, "name", (Object)"Big Brother Bob", new Object[0]);
                continue;
            }
            if (!n.endsWith("Mabel")) continue;
            u.property("name").remove();
        }
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Long"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"Big"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"Big"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.PREFIX, (Object)"Middle"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mixed");
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testIndexReplay() throws Exception {
        TimestampProvider times = this.graph.getConfiguration().getTimestampProvider();
        Instant startTime = times.getTime();
        this.clopen(TitanIndexTest.option(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, new String[0]), true, TitanIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "tx"), Duration.ofMillis(50L), TitanIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "tx"), Duration.ofMillis(250L), TitanIndexTest.option(GraphDatabaseConfiguration.MAX_COMMIT_TIME, new String[0]), Duration.ofSeconds(1L), TitanIndexTest.option(GraphDatabaseConfiguration.STORAGE_WRITE_WAITTIME, new String[0]), Duration.ofMillis(300L), TitanIndexTest.option(TestMockIndexProvider.INDEX_BACKEND_PROXY, INDEX), this.readConfig.get(GraphDatabaseConfiguration.INDEX_BACKEND, new String[]{INDEX}), TitanIndexTest.option(GraphDatabaseConfiguration.INDEX_BACKEND, INDEX), TestMockIndexProvider.class.getName(), TitanIndexTest.option(TestMockIndexProvider.INDEX_MOCK_FAILADD, INDEX), true);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey age = this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("mi", Vertex.class).addKey(name, new Parameter[]{this.getTextMapping()}).addKey(age).buildMixedIndex(INDEX);
        this.finishSchema();
        TitanVertex[] vs = new TitanVertex[4];
        vs[0] = this.tx.addVertex(new Object[]{"name", "Big Boy Bobson", "age", 55});
        this.newTx();
        vs[1] = this.tx.addVertex(new Object[]{"name", "Long Little Lewis", "age", 35});
        vs[2] = this.tx.addVertex(new Object[]{"name", "Tall Long Tiger", "age", 75});
        vs[3] = this.tx.addVertex(new Object[]{"name", "Long John Don", "age", 15});
        this.newTx();
        vs[2] = TitanIndexTest.getV((TitanGraphTransaction)this.tx, vs[2]);
        vs[2].remove();
        vs[3] = TitanIndexTest.getV((TitanGraphTransaction)this.tx, vs[3]);
        vs[3].property(VertexProperty.Cardinality.single, "name", (Object)"Bad Boy Badsy", new Object[0]);
        vs[3].property("age").remove();
        this.newTx();
        vs[0] = TitanIndexTest.getV((TitanGraphTransaction)this.tx, vs[0]);
        vs[0].property(VertexProperty.Cardinality.single, "age", (Object)66, new Object[0]);
        this.newTx();
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"boy"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mi");
        TransactionRecovery recovery = TitanFactory.startTransactionRecovery((TitanGraph)this.graph, (Instant)startTime);
        Thread.sleep(12000L);
        recovery.shutdown();
        long[] recoveryStats = ((StandardTransactionLogProcessor)recovery).getStatistics();
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"boy"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"long"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"long").interval("age", (Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(40)), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().has("age", (Object)75), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"boy").interval("age", (Comparable)Integer.valueOf(60), (Comparable)Integer.valueOf(70)), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("age", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mi");
        Assert.assertEquals((long)1L, (long)recoveryStats[0]);
        Assert.assertEquals((long)4L, (long)recoveryStats[1]);
    }

    @Test
    public void testIndexUpdatesWithoutReindex() throws InterruptedException, ExecutionException {
        Object[] settings = new Object[]{TitanIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "titan"), Duration.ofMillis(0L), TitanIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "titan"), Duration.ofMillis(50L), TitanIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "titan"), Duration.ofMillis(250L)};
        this.clopen(settings);
        String defText = "Mountain rocks are great friends";
        int defTime = 5;
        double defHeight = 101.1;
        String[] defPhones = new String[]{"1234", "5678"};
        this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        this.mgmt.makePropertyKey("height").dataType(Double.class).make();
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            this.mgmt.makePropertyKey("phone").dataType(String.class).cardinality(Cardinality.LIST).make();
        }
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(text, new Parameter[]{this.getTextMapping(), this.getFieldMap(text)}).buildMixedIndex(INDEX);
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            TitanGraphTest.evaluateQuery(this.tx.query().has("phone", (TitanPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
            TitanGraphTest.evaluateQuery(this.tx.query().has("phone", (TitanPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        }
        this.newTx();
        this.finishSchema();
        PropertyKey time = this.mgmt.getPropertyKey("time");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), time, new Parameter[]{this.getFieldMap(time)});
        this.finishSchema();
        this.newTx();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.tx.commit();
        Assert.assertNull((Object)this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX));
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.REGISTER_INDEX).get();
        this.mgmt.commit();
        ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((TitanGraph)this.graph, (String)"theIndex").timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        this.finishSchema();
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX).get();
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 3, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            TitanGraphTest.evaluateQuery(this.tx.query().has("phone", (TitanPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
            TitanGraphTest.evaluateQuery(this.tx.query().has("phone", (TitanPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        }
        this.newTx();
        this.finishSchema();
        PropertyKey height = this.mgmt.getPropertyKey("height");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), height, new Parameter[0]);
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            PropertyKey phone = this.mgmt.getPropertyKey("phone");
            this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), phone, new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)});
        }
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.tx.commit();
        this.mgmt.commit();
        ManagementUtil.awaitGraphIndexUpdate((TitanGraph)this.graph, (String)"theIndex", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        TitanGraphIndex index = this.mgmt.getGraphIndex("theIndex");
        for (PropertyKey key : index.getFieldKeys()) {
            Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)index.getIndexStatus(key));
        }
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 4, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            TitanGraphTest.evaluateQuery(this.tx.query().has("phone", (TitanPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
            TitanGraphTest.evaluateQuery(this.tx.query().has("phone", (TitanPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        }
        this.newTx();
        this.finishSchema();
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.REINDEX).get();
        this.mgmt.commit();
        this.finishSchema();
        this.clopen(settings);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            TitanGraphTest.evaluateQuery(this.tx.query().has("phone", (TitanPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
            TitanGraphTest.evaluateQuery(this.tx.query().has("phone", (TitanPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        }
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.DISABLE_INDEX).get();
        this.tx.commit();
        this.mgmt.commit();
        ManagementUtil.awaitGraphIndexUpdate((TitanGraph)this.graph, (String)"theIndex", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        index = this.mgmt.getGraphIndex("theIndex");
        for (PropertyKey key : index.getFieldKeys()) {
            Assert.assertEquals((Object)SchemaStatus.DISABLED, (Object)index.getIndexStatus(key));
        }
        this.newTx();
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{false, true}, new String[0]);
    }

    private void addVertex(int time, String text, double height, String[] phones) {
        this.newTx();
        TitanVertex v = this.tx.addVertex(new Object[]{"text", text, "time", time, "height", height});
        for (String phone : phones) {
            v.property("phone", (Object)phone);
        }
        this.newTx();
    }

    @Test
    public void testVertexTTLWithMixedIndices() throws Exception {
        if (!this.features.hasCellTTL() || !this.indexFeatures.supportsDocumentTTL()) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel event = this.mgmt.makeVertexLabel("event").setStatic().make();
        int eventTTLSeconds = (int)TestGraphConfigs.getTTL(TimeUnit.SECONDS);
        this.mgmt.setTTL((TitanSchemaType)event, Duration.ofSeconds(eventTTLSeconds));
        this.mgmt.buildIndex("index1", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).addKey(time).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("index2", Vertex.class).indexOnly((TitanSchemaType)event).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)name));
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)time));
        Assert.assertEquals((Object)Duration.ofSeconds(eventTTLSeconds), (Object)this.mgmt.getTTL((TitanSchemaType)event));
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertex("event");
        v1.property(VertexProperty.Cardinality.single, "name", (Object)"first event", new Object[0]);
        v1.property(VertexProperty.Cardinality.single, "text", (Object)"this text will help to identify the first event", new Object[0]);
        long time1 = System.currentTimeMillis();
        v1.property(VertexProperty.Cardinality.single, "time", (Object)time1, new Object[0]);
        TitanVertex v2 = this.tx.addVertex("event");
        v2.property(VertexProperty.Cardinality.single, "name", (Object)"second event", new Object[0]);
        v2.property(VertexProperty.Cardinality.single, "text", (Object)"this text won't match", new Object[0]);
        long time2 = time1 + 1L;
        v2.property(VertexProperty.Cardinality.single, "time", (Object)time2, new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.VERTEX, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "index2");
        this.clopen(new Object[0]);
        Object v1Id = v1.id();
        Object v2Id = v2.id();
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.VERTEX, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "index2");
        v1 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v1Id);
        v2 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v1Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)eventTTLSeconds * 1.25), TimeUnit.SECONDS));
        this.clopen(new Object[0]);
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)eventTTLSeconds * 1.25), TimeUnit.SECONDS));
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "index2");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.VERTEX, 0, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v1Id);
        v2 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v2Id);
        Assert.assertNull((Object)v1);
        Assert.assertNull((Object)v2);
    }

    @Test
    public void testEdgeTTLWithMixedIndices() throws Exception {
        if (!this.features.hasCellTTL() || !this.indexFeatures.supportsDocumentTTL()) {
            return;
        }
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        PropertyKey time = this.makeKey("time", Long.class);
        EdgeLabel label = this.mgmt.makeEdgeLabel("likes").make();
        int likesTTLSeconds = (int)TestGraphConfigs.getTTL(TimeUnit.SECONDS);
        this.mgmt.setTTL((TitanSchemaType)label, Duration.ofSeconds(likesTTLSeconds));
        this.mgmt.buildIndex("index1", Edge.class).addKey(name, new Parameter[]{this.getStringMapping()}).addKey(time).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("index2", Edge.class).indexOnly((TitanSchemaType)label).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)name));
        Assert.assertEquals((Object)Duration.ofSeconds(likesTTLSeconds), (Object)this.mgmt.getTTL((TitanSchemaType)label));
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertex(new Object[0]);
        TitanVertex v2 = this.tx.addVertex(new Object[0]);
        TitanVertex v3 = this.tx.addVertex(new Object[0]);
        TitanEdge e1 = v1.addEdge("likes", (Vertex)v2, new Object[]{"name", "v1 likes v2", "text", "this will help to identify the edge"});
        long time1 = System.currentTimeMillis();
        e1.property("time", (Object)time1);
        TitanEdge e2 = v2.addEdge("likes", (Vertex)v3, new Object[]{"name", "v2 likes v3", "text", "this won't match anything"});
        long time2 = time1 + 1L;
        e2.property("time", (Object)time2);
        this.tx.commit();
        this.clopen(new Object[0]);
        Object e1Id = e1.id();
        Object e2Id = e2.id();
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"likes"), ElementCategory.EDGE, 1, new boolean[]{true, true}, "index2");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2 likes v3").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.EDGE, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v1.id());
        v2 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v2.id());
        v3 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v3.id());
        e1 = TitanIndexTest.getE((TitanGraphTransaction)this.tx, e1Id);
        e2 = TitanIndexTest.getE((TitanGraphTransaction)this.tx, e1Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNotNull((Object)v3);
        Assert.assertNotNull((Object)e1);
        Assert.assertNotNull((Object)e2);
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.OUT).edges());
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)likesTTLSeconds * 1.25), TimeUnit.SECONDS));
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"likes"), ElementCategory.EDGE, 0, new boolean[]{true, true}, "index2");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2 likes v3").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), ElementCategory.EDGE, 0, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v1.id());
        v2 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v2.id());
        v3 = TitanIndexTest.getV((TitanGraphTransaction)this.tx, v3.id());
        e1 = TitanIndexTest.getE((TitanGraphTransaction)this.tx, e1Id);
        e2 = TitanIndexTest.getE((TitanGraphTransaction)this.tx, e1Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNotNull((Object)v3);
        Assert.assertNull((Object)e1);
        Assert.assertNull((Object)e2);
        TitanAssert.assertEmpty(v1.query().direction(Direction.OUT).edges());
        TitanAssert.assertEmpty(v2.query().direction(Direction.OUT).edges());
    }

    @Test
    public void testDeleteVertexThenDeleteProperty() throws BackendException {
        this.testNestedWrites("x", null);
    }

    @Test
    public void testDeleteVertexThenAddProperty() throws BackendException {
        this.testNestedWrites(null, "y");
    }

    @Test
    public void testDeleteVertexThenModifyProperty() throws BackendException {
        this.testNestedWrites("x", "y");
    }

    @Test
    public void testIndexQueryWithScore() throws InterruptedException {
        PropertyKey textKey = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        this.mgmt.buildIndex("store1", Vertex.class).addKey(textKey).buildMixedIndex(INDEX);
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertex(new Object[0]);
        TitanVertex v2 = this.tx.addVertex(new Object[0]);
        TitanVertex v3 = this.tx.addVertex(new Object[0]);
        v1.property("text", (Object)"Hello Hello Hello Hello Hello Hello Hello Hello");
        v2.property("text", (Object)"Hello abab abab fsdfsd sfdfsd sdffs fsdsdf fdf fsdfsd aera fsad abab abab fsdfsd sfdf");
        v3.property("text", (Object)"Hello");
        this.tx.commit();
        Thread.sleep(5000L);
        HashSet<Double> scores = new HashSet<Double>();
        for (TitanIndexQuery.Result r : this.graph.indexQuery("store1", "v.text:(Hello)").vertices()) {
            scores.add(r.getScore());
        }
        Assert.assertEquals((long)3L, (long)scores.size());
    }

    @Test
    public void testContainsWithMultipleValues() throws Exception {
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.buildIndex("store1", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertex(new Object[0]);
        v1.property("name", (Object)"hercules was here");
        this.tx.commit();
        Thread.sleep(2000L);
        TitanVertex r = (TitanVertex)Iterables.get((Iterable)this.graph.query().has("name", (TitanPredicate)Text.CONTAINS, (Object)"hercules here").vertices(), (int)0);
        Assert.assertEquals((Object)r.property("name").value(), (Object)"hercules was here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNestedWrites(String initialValue, String updatedValue) throws BackendException {
        Backend b = null;
        try {
            b = this.graph.getConfiguration().getBackend();
            if (b.getStoreFeatures().hasTxIsolation()) {
                log.info("Skipping " + this.getClass().getSimpleName() + "." + this.methodName.getMethodName());
                return;
            }
        }
        finally {
            if (null != b) {
                b.close();
            }
        }
        String propName = "foo";
        PropertyKey prop = this.makeKey("foo", String.class);
        this.createExternalVertexIndex(prop, INDEX);
        this.finishSchema();
        TitanVertex v = this.graph.addVertex(new Object[0]);
        if (null != initialValue) {
            v.property(VertexProperty.Cardinality.single, "foo", (Object)initialValue, new Object[0]);
        }
        this.graph.tx().commit();
        Object id = v.id();
        TitanTransaction vertexDeleter = this.graph.newTransaction();
        TitanTransaction propDeleter = this.graph.newTransaction();
        TitanIndexTest.getV((TitanGraphTransaction)vertexDeleter, id).remove();
        if (null == updatedValue) {
            TitanIndexTest.getV((TitanGraphTransaction)propDeleter, id).property("foo").remove();
        } else {
            TitanIndexTest.getV((TitanGraphTransaction)propDeleter, id).property(VertexProperty.Cardinality.single, "foo", (Object)updatedValue, new Object[0]);
        }
        vertexDeleter.commit();
        propDeleter.commit();
        this.graph.tx().rollback();
        Assert.assertEquals(null, (Object)TitanIndexTest.getV((TitanGraphTransaction)this.graph, id));
        TitanAssert.assertEmpty(this.graph.query().has("foo").vertices());
        if (null != updatedValue) {
            TitanAssert.assertEmpty(this.graph.query().has("foo", (Object)updatedValue).vertices());
        }
        this.graph.tx().rollback();
    }

    @Test
    public void testWidcardQuery() {
        if (this.supportsWildcardQuery()) {
            PropertyKey p1 = this.makeKey("p1", String.class);
            PropertyKey p2 = this.makeKey("p2", String.class);
            this.mgmt.buildIndex("mixedIndex", Vertex.class).addKey(p1).addKey(p2).buildMixedIndex(INDEX);
            this.finishSchema();
            this.clopen(new Object[0]);
            TitanVertex v1 = this.graph.addVertex(new Object[0]);
            v1.property("p1", (Object)"test1");
            v1.property("p2", (Object)"test2");
            this.clopen(new Object[0]);
            Assert.assertEquals((Object)v1, (Object)((TitanIndexQuery.Result)this.graph.indexQuery("mixedIndex", "v.*:\"test1\"").vertices().iterator().next()).getElement());
            Assert.assertEquals((Object)v1, (Object)((TitanIndexQuery.Result)this.graph.indexQuery("mixedIndex", "v.*:\"test2\"").vertices().iterator().next()).getElement());
        }
    }

    @Test
    public void testListIndexing() {
        this.testIndexing(Cardinality.LIST);
    }

    protected abstract boolean supportsCollections();

    @Test
    public void testSetIndexing() {
        this.testIndexing(Cardinality.SET);
    }

    private void testIndexing(Cardinality cardinality) {
        if (this.supportsCollections()) {
            PropertyKey stringProperty = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(cardinality).make();
            PropertyKey intProperty = this.mgmt.makePropertyKey("age").dataType(Integer.class).cardinality(cardinality).make();
            PropertyKey longProperty = this.mgmt.makePropertyKey("long").dataType(Long.class).cardinality(cardinality).make();
            PropertyKey uuidProperty = this.mgmt.makePropertyKey("uuid").dataType(UUID.class).cardinality(cardinality).make();
            PropertyKey geopointProperty = this.mgmt.makePropertyKey("geopoint").dataType(Geoshape.class).cardinality(cardinality).make();
            this.mgmt.buildIndex("collectionIndex", Vertex.class).addKey(stringProperty, new Parameter[]{this.getStringMapping()}).addKey(intProperty).addKey(longProperty).addKey(uuidProperty).addKey(geopointProperty).buildMixedIndex(INDEX);
            this.finishSchema();
            this.testCollection(cardinality, "name", "Totoro", "Hiro");
            this.testCollection(cardinality, "age", 1, 2);
            this.testCollection(cardinality, "long", 1L, 2L);
            this.testCollection(cardinality, "uuid", UUID.randomUUID(), UUID.randomUUID());
            this.testCollection(cardinality, "geopoint", Geoshape.point((double)1.0, (double)1.0), Geoshape.point((double)2.0, (double)2.0));
        } else {
            try {
                PropertyKey stringProperty = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(cardinality).make();
                this.mgmt.buildIndex("collectionIndex", Vertex.class).addKey(stringProperty, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
                Assert.fail((String)"Should have thrown an exception");
            }
            catch (TitanException titanException) {
                // empty catch block
            }
        }
    }

    private void testCollection(Cardinality cardinality, String property, Object value1, Object value2) {
        this.clopen(new Object[0]);
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property(property, value1);
        this.clopen(new Object[0]);
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        v1 = TitanIndexTest.getV((TitanGraphTransaction)this.graph, v1.id());
        v1.property(property, value2);
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        v1 = TitanIndexTest.getV((TitanGraphTransaction)this.graph, v1.id());
        v1.properties(new String[]{property}).forEachRemaining(p -> {
            if (p.value().equals(value1)) {
                p.remove();
            }
        });
        Assert.assertFalse((boolean)this.graph.query().has(property, value1).vertices().iterator().hasNext());
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        Assert.assertFalse((boolean)this.graph.query().has(property, value1).vertices().iterator().hasNext());
        v1 = TitanIndexTest.getV((TitanGraphTransaction)this.graph, v1.id());
        v1.property(property, value1);
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        v1 = TitanIndexTest.getV((TitanGraphTransaction)this.graph, v1.id());
        v1.property(property, value1);
        Assert.assertEquals((long)(Cardinality.SET.equals((Object)cardinality) ? 2L : 3L), (long)Iterators.size((Iterator)TitanIndexTest.getOnlyVertex(this.graph.query().has(property, value1)).properties(new String[]{property})));
        this.clopen(new Object[0]);
        Assert.assertEquals((long)(Cardinality.SET.equals((Object)cardinality) ? 2L : 3L), (long)Iterators.size((Iterator)TitanIndexTest.getOnlyVertex(this.graph.query().has(property, value1)).properties(new String[]{property})));
        this.graph.vertices(new Object[0]).forEachRemaining(v -> v.remove());
        v1 = this.graph.addVertex(new Object[0]);
        v1.property(property, value1);
        v1.property(property, value2);
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        if (value1 instanceof Geoshape) {
            Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)1.0, (double)1.0, (double)0.1)).vertices()));
            Assert.assertEquals((Object)v1, TitanIndexTest.getOnlyElement(this.graph.query().has(property, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)2.0, (double)2.0, (double)0.1)).vertices()));
        }
    }

    private void testGeo(int i, int origNumV, int numV, String geoPointProperty, String geoShapeProperty) {
        double offset = (double)i * 50.0 / (double)origNumV;
        double bufferKm = 20.0;
        double distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + bufferKm;
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        if (i > 0) {
            TitanAssert.assertCount(i, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)(distance - bufferKm))).vertices());
            TitanAssert.assertCount(i, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)(distance - bufferKm))).edges());
        }
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        TitanAssert.assertCount(i % 2, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.CONTAINS, (Object)Geoshape.point((double)(-offset), (double)(-offset))).vertices());
        TitanAssert.assertCount(i % 2, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.CONTAINS, (Object)Geoshape.point((double)(-offset), (double)(-offset))).edges());
        double buffer = bufferKm / 111.0;
        double min = -Math.abs(offset);
        double max = Math.abs(offset);
        Geoshape bufferedBox = Geoshape.box((double)(min - buffer), (double)(min - buffer), (double)(max + buffer), (double)(max + buffer));
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.WITHIN, (Object)bufferedBox).vertices());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.WITHIN, (Object)bufferedBox).edges());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.INTERSECT, (Object)bufferedBox).vertices());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.INTERSECT, (Object)bufferedBox).edges());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.DISJOINT, (Object)bufferedBox).vertices());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoPointProperty, (TitanPredicate)Geo.DISJOINT, (Object)bufferedBox).edges());
        if (i > 0) {
            Geoshape exactBox = Geoshape.box((double)min, (double)min, (double)max, (double)max);
            TitanAssert.assertCount(i, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.WITHIN, (Object)exactBox).vertices());
            TitanAssert.assertCount(i, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.WITHIN, (Object)exactBox).edges());
        }
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.INTERSECT, (Object)bufferedBox).vertices());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.INTERSECT, (Object)bufferedBox).edges());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.DISJOINT, (Object)bufferedBox).vertices());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.DISJOINT, (Object)bufferedBox).edges());
        Geoshape bufferedPoly = Geoshape.polygon((double[])new double[]{min - buffer, min - buffer, max + buffer, min - buffer, max + buffer, max + buffer, min - buffer, max + buffer, min - buffer, min - buffer});
        if (i > 0) {
            Geoshape exactPoly = Geoshape.polygon((double[])new double[]{min, min, max, min, max, max, min, max, min, min});
            TitanAssert.assertCount(i, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.WITHIN, (Object)exactPoly).vertices());
            TitanAssert.assertCount(i, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.WITHIN, (Object)exactPoly).edges());
        }
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.INTERSECT, (Object)bufferedPoly).vertices());
        TitanAssert.assertCount(i + 1, this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.INTERSECT, (Object)bufferedPoly).edges());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.DISJOINT, (Object)bufferedPoly).vertices());
        TitanAssert.assertCount(numV - (i + 1), this.tx.query().has(geoShapeProperty, (TitanPredicate)Geo.DISJOINT, (Object)bufferedPoly).edges());
    }
}

