/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.SchemaViolationException;
import com.thinkaurelius.titan.core.TitanConfigurationException;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanGraphTransaction;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Contain;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.log.Change;
import com.thinkaurelius.titan.core.log.ChangeProcessor;
import com.thinkaurelius.titan.core.log.ChangeState;
import com.thinkaurelius.titan.core.log.LogProcessorFramework;
import com.thinkaurelius.titan.core.log.TransactionId;
import com.thinkaurelius.titan.core.log.TransactionRecovery;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.core.util.ManagementUtil;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.log.Message;
import com.thinkaurelius.titan.diskstorage.log.MessageReader;
import com.thinkaurelius.titan.diskstorage.log.ReadMarker;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLog;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.example.GraphOfTheGodsFactory;
import com.thinkaurelius.titan.graphdb.TestMockLog;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.log.LogTxMeta;
import com.thinkaurelius.titan.graphdb.database.log.LogTxStatus;
import com.thinkaurelius.titan.graphdb.database.log.TransactionLogHeader;
import com.thinkaurelius.titan.graphdb.database.management.GraphIndexStatusWatcher;
import com.thinkaurelius.titan.graphdb.database.management.ManagementSystem;
import com.thinkaurelius.titan.graphdb.database.management.RelationIndexStatusWatcher;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.Order;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.log.StandardTransactionLogProcessor;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.graph.GraphCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.profile.QueryProfiler;
import com.thinkaurelius.titan.graphdb.query.profile.SimpleQueryProfiler;
import com.thinkaurelius.titan.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.schema.EdgeLabelDefinition;
import com.thinkaurelius.titan.graphdb.schema.PropertyKeyDefinition;
import com.thinkaurelius.titan.graphdb.schema.SchemaContainer;
import com.thinkaurelius.titan.graphdb.schema.VertexLabelDefinition;
import com.thinkaurelius.titan.graphdb.serializer.SpecialInt;
import com.thinkaurelius.titan.graphdb.serializer.SpecialIntSerializer;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanGraphStep;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanPropertiesStep;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanVertexStep;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.thinkaurelius.titan.graphdb.types.StandardPropertyKeyMaker;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.thinkaurelius.titan.testcategory.BrittleTests;
import com.thinkaurelius.titan.testutil.TestGraphConfigs;
import com.thinkaurelius.titan.testutil.TitanAssert;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanGraphTest
extends TitanGraphBaseTest {
    private Logger log = LoggerFactory.getLogger(TitanGraphTest.class);

    protected abstract boolean isLockingOptimistic();

    @Test
    public void testOpenClose() {
    }

    @Test
    public void testBasic() {
        PropertyKey uid = this.makeVertexIndexedUniqueKey("name", String.class);
        this.finishSchema();
        TitanVertex n1 = this.tx.addVertex(new Object[0]);
        uid = this.tx.getPropertyKey("name");
        n1.property(uid.name(), (Object)"abcd");
        this.clopen(new Object[0]);
        long nid = n1.longId();
        uid = this.tx.getPropertyKey("name");
        Assert.assertTrue((TitanGraphTest.getV((TitanGraphTransaction)this.tx, nid) != null ? 1 : 0) != 0);
        Assert.assertTrue((TitanGraphTest.getV((TitanGraphTransaction)this.tx, uid.longId()) != null ? 1 : 0) != 0);
        TitanGraphTest.assertMissing((TitanGraphTransaction)this.tx, nid + 64L);
        uid = this.tx.getPropertyKey(uid.name());
        n1 = TitanGraphTest.getV((TitanGraphTransaction)this.tx, nid);
        Assert.assertEquals((Object)n1, (Object)TitanGraphTest.getOnlyVertex(this.tx.query().has(uid.name(), (Object)"abcd")));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)n1.query().relations()));
        Assert.assertEquals((Object)"abcd", (Object)n1.value(uid.name()));
        TitanAssert.assertCount(1L, this.tx.query().vertices());
        this.close();
        TitanCleanup.clear((TitanGraph)this.graph);
        this.open(this.config);
        TitanAssert.assertEmpty(this.tx.query().vertices());
    }

    @Test
    public void testVertexRemoval() {
        String namen = "name";
        this.makeVertexIndexedUniqueKey("name", String.class);
        this.finishSchema();
        TitanVertex v1 = this.graph.addVertex(new Object[]{"name", "v1"});
        TitanVertex v2 = this.graph.addVertex(new Object[]{"name", "v2"});
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        TitanAssert.assertCount(2L, this.graph.query().vertices());
        TitanAssert.assertCount(1L, this.graph.query().has("name", (Object)"v2").vertices());
        this.clopen(new Object[0]);
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v1);
        v2 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v2);
        TitanAssert.assertCount(1L, v1.query().direction(Direction.BOTH).edges());
        TitanAssert.assertCount(1L, v2.query().direction(Direction.BOTH).edges());
        v2.remove();
        TitanAssert.assertCount(0L, v1.query().direction(Direction.BOTH).edges());
        try {
            TitanAssert.assertCount(0L, v2.query().direction(Direction.BOTH).edges());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TitanAssert.assertCount(1L, this.graph.query().vertices());
        TitanAssert.assertCount(1L, this.graph.query().has("name", (Object)"v1").vertices());
        TitanAssert.assertCount(0L, this.graph.query().has("name", (Object)"v2").vertices());
        this.graph.tx().commit();
        TitanGraphTest.assertMissing((TitanGraphTransaction)this.graph, v2);
        TitanAssert.assertCount(1L, this.graph.query().vertices());
        TitanAssert.assertCount(1L, this.graph.query().has("name", (Object)"v1").vertices());
        TitanAssert.assertCount(0L, this.graph.query().has("name", (Object)"v2").vertices());
    }

    @Test
    public void testGlobalIteration() {
        int i;
        int numV = 50;
        int deleteV = 5;
        TitanVertex previous = this.tx.addVertex(new Object[]{"count", 0});
        for (int i2 = 1; i2 < numV; ++i2) {
            TitanVertex next = this.tx.addVertex(new Object[]{"count", i2});
            previous.addEdge("next", (Vertex)next, new Object[0]);
            previous = next;
        }
        int numE = numV - 1;
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        TitanAssert.assertCount(numE, this.tx.query().edges());
        TitanAssert.assertCount(numE, this.tx.query().edges());
        this.clopen(new Object[0]);
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        TitanAssert.assertCount(numV, this.tx.query().vertices());
        TitanAssert.assertCount(numE, this.tx.query().edges());
        TitanAssert.assertCount(numE, this.tx.query().edges());
        for (TitanVertex v : this.tx.query().limit(deleteV).vertices()) {
            v.remove();
        }
        for (i = 0; i < 10; ++i) {
            TitanAssert.assertCount(numV - deleteV, this.tx.query().vertices());
            TitanAssert.assertCount(numV - deleteV, this.tx.query().has("count", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0).vertices());
        }
        this.clopen(new Object[0]);
        for (i = 0; i < 10; ++i) {
            TitanAssert.assertCount(numV - deleteV, this.tx.query().vertices());
            TitanAssert.assertCount(numV - deleteV, this.tx.query().has("count", (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0).vertices());
        }
    }

    @Test
    public void testMediumCreateRetrieve() {
        TitanVertex n;
        int i;
        this.makeLabel("connect");
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey id = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{id}).signature(new PropertyKey[]{weight}).make();
        this.finishSchema();
        int noVertices = 500;
        String[] names = new String[noVertices];
        int[] ids = new int[noVertices];
        TitanVertex[] nodes = new TitanVertex[noVertices];
        long[] nodeIds = new long[noVertices];
        List[] nodeEdges = new List[noVertices];
        for (int i2 = 0; i2 < noVertices; ++i2) {
            names[i2] = "vertex" + i2;
            ids[i2] = i2;
            nodes[i2] = this.tx.addVertex(new Object[]{"name", names[i2], "uid", ids[i2]});
            if ((i2 + 1) % 100 != 0) continue;
            this.log.debug("Added 100 nodes");
        }
        this.log.debug("Nodes created");
        int[] connectOff = new int[]{-100, -34, -4, 10, 20};
        int[] knowsOff = new int[]{-400, -18, 8, 232, 334};
        for (int i3 = 0; i3 < noVertices; ++i3) {
            TitanVertex n2 = nodes[i3];
            nodeEdges[i3] = new ArrayList(10);
            for (int c : connectOff) {
                TitanEdge r = n2.addEdge("connect", (Vertex)nodes[TitanGraphTest.wrapAround(i3 + c, noVertices)], new Object[0]);
                nodeEdges[i3].add(r);
            }
            for (int k : knowsOff) {
                TitanVertex n22 = nodes[TitanGraphTest.wrapAround(i3 + k, noVertices)];
                TitanEdge r = n2.addEdge("knows", (Vertex)n22, new Object[]{"uid", ((Number)n2.value("uid")).intValue() + ((Number)n22.value("uid")).intValue(), "weight", (double)k * 1.5, "name", i3 + "-" + k});
                nodeEdges[i3].add(r);
            }
            if (i3 % 100 != 99) continue;
            this.log.debug(".");
        }
        this.tx.commit();
        this.tx = null;
        Set[] nodeEdgeIds = new Set[noVertices];
        for (i = 0; i < noVertices; ++i) {
            nodeIds[i] = (Long)nodes[i].id();
            nodeEdgeIds[i] = new HashSet(10);
            Object object = nodeEdges[i].iterator();
            while (object.hasNext()) {
                Object r = object.next();
                nodeEdgeIds[i].add(((TitanEdge)r).longId());
            }
        }
        this.clopen(new Object[0]);
        nodes = new TitanVertex[noVertices];
        for (i = 0; i < noVertices; ++i) {
            n = this.getVertex("uid", (Object)ids[i]);
            Assert.assertEquals((Object)n, (Object)this.getVertex("name", (Object)names[i]));
            Assert.assertEquals((Object)names[i], (Object)n.value("name"));
            nodes[i] = n;
            Assert.assertEquals((long)nodeIds[i], (long)n.longId());
        }
        for (i = 0; i < noVertices; ++i) {
            n = nodes[i];
            TitanAssert.assertCount(connectOff.length + knowsOff.length, n.query().direction(Direction.OUT).edges());
            TitanAssert.assertCount(connectOff.length, n.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
            TitanAssert.assertCount(connectOff.length * 2, n.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
            TitanAssert.assertCount(knowsOff.length * 2, n.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            TitanAssert.assertCount(connectOff.length + knowsOff.length, n.query().direction(Direction.OUT).edges());
            TitanAssert.assertCount(2L, n.properties(new String[0]));
            for (TitanEdge r : n.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges()) {
                TitanVertex n2 = r.vertex(Direction.IN);
                int idsum = ((Number)n.value("uid")).intValue() + ((Number)n2.value("uid")).intValue();
                Assert.assertEquals((long)idsum, (long)((Number)r.value("uid")).intValue());
                double k = ((Number)r.value("weight")).doubleValue() / 1.5;
                int ki = (int)k;
                Assert.assertEquals((Object)(i + "-" + ki), (Object)r.value("name"));
            }
            HashSet<Long> edgeIds = new HashSet<Long>(10);
            for (TitanEdge r : n.query().direction(Direction.OUT).edges()) {
                edgeIds.add(r.longId());
            }
            Assert.assertTrue((String)(edgeIds + " vs " + nodeEdgeIds[i]), (boolean)edgeIds.equals(nodeEdgeIds[i]));
        }
        this.newTx();
        long[] vids1 = new long[noVertices / 10];
        for (int i4 = 0; i4 < vids1.length; ++i4) {
            vids1[i4] = nodeIds[i4];
        }
        this.verifyVerticesRetrieval(vids1, Lists.newArrayList((Iterable)this.tx.getVertices(vids1)));
        this.verifyVerticesRetrieval(vids1, Lists.newArrayList((Iterable)this.tx.getVertices(vids1)));
        long[] vids2 = new long[noVertices / 10 * 2];
        for (int i5 = 0; i5 < vids2.length; ++i5) {
            vids2[i5] = nodeIds[i5];
        }
        this.verifyVerticesRetrieval(vids2, Lists.newArrayList((Iterable)this.tx.getVertices(vids2)));
    }

    private void verifyVerticesRetrieval(long[] vids, List<TitanVertex> vs) {
        Assert.assertEquals((long)vids.length, (long)vs.size());
        HashSet vset = new HashSet(vs.size());
        vs.forEach(v -> vset.add((Long)v.id()));
        for (int i = 0; i < vids.length; ++i) {
            Assert.assertTrue((boolean)vset.contains(vids[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaTypes() {
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", String.class);
        PropertyKey someid = this.makeVertexIndexedKey("someid", Object.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        PropertyKey value = this.mgmt.makePropertyKey("value").dataType(Double.class).signature(new PropertyKey[]{weight}).cardinality(Cardinality.LIST).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").make();
        EdgeLabel link = this.mgmt.makeEdgeLabel("link").unidirected().multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{uid}).multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel parent = this.mgmt.makeEdgeLabel("parent").multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        EdgeLabel spouse = this.mgmt.makeEdgeLabel("spouse").multiplicity(Multiplicity.ONE2ONE).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel tag = this.mgmt.makeVertexLabel("tag").make();
        VertexLabel tweet = this.mgmt.makeVertexLabel("tweet").setStatic().make();
        Assert.assertTrue((boolean)this.mgmt.isOpen());
        Assert.assertEquals((Object)"weight", (Object)weight.toString());
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("weight"));
        Assert.assertTrue((boolean)this.mgmt.containsPropertyKey("weight"));
        Assert.assertFalse((boolean)this.mgmt.containsEdgeLabel("weight"));
        Assert.assertTrue((boolean)this.mgmt.containsEdgeLabel("connect"));
        Assert.assertFalse((boolean)this.mgmt.containsPropertyKey("connect"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationType("bla"));
        Assert.assertNull((Object)this.mgmt.getPropertyKey("bla"));
        Assert.assertNull((Object)this.mgmt.getEdgeLabel("bla"));
        Assert.assertNotNull((Object)this.mgmt.getPropertyKey("weight"));
        Assert.assertNotNull((Object)this.mgmt.getEdgeLabel("connect"));
        Assert.assertTrue((boolean)weight.isPropertyKey());
        Assert.assertFalse((boolean)weight.isEdgeLabel());
        Assert.assertEquals((Object)Cardinality.SINGLE, (Object)weight.cardinality());
        Assert.assertEquals((Object)Cardinality.SINGLE, (Object)someid.cardinality());
        Assert.assertEquals((Object)Cardinality.SET, (Object)name.cardinality());
        Assert.assertEquals((Object)Cardinality.LIST, (Object)value.cardinality());
        Assert.assertEquals(Object.class, (Object)someid.dataType());
        Assert.assertEquals(Float.class, (Object)weight.dataType());
        long[] sig = ((InternalRelationType)value).getSignature();
        Assert.assertEquals((long)1L, (long)sig.length);
        Assert.assertEquals((long)weight.longId(), (long)sig[0]);
        Assert.assertTrue((boolean)this.mgmt.getGraphIndex(uid.name()).isUnique());
        Assert.assertFalse((boolean)this.mgmt.getGraphIndex(someid.name()).isUnique());
        Assert.assertEquals((Object)"friend", (Object)friend.name());
        Assert.assertTrue((boolean)friend.isEdgeLabel());
        Assert.assertFalse((boolean)friend.isPropertyKey());
        Assert.assertEquals((Object)Multiplicity.ONE2ONE, (Object)spouse.multiplicity());
        Assert.assertEquals((Object)Multiplicity.ONE2MANY, (Object)child.multiplicity());
        Assert.assertEquals((Object)Multiplicity.MANY2ONE, (Object)parent.multiplicity());
        Assert.assertEquals((Object)Multiplicity.MULTI, (Object)friend.multiplicity());
        Assert.assertEquals((Object)Multiplicity.SIMPLE, (Object)connect.multiplicity());
        Assert.assertTrue((boolean)link.isUnidirected());
        Assert.assertFalse((boolean)link.isDirected());
        Assert.assertFalse((boolean)child.isUnidirected());
        Assert.assertTrue((boolean)spouse.isDirected());
        Assert.assertFalse((boolean)((InternalRelationType)friend).isInvisibleType());
        Assert.assertTrue((boolean)((InternalRelationType)friend).isInvisible());
        Assert.assertEquals((long)0L, (long)((InternalRelationType)friend).getSignature().length);
        sig = ((InternalRelationType)connect).getSignature();
        Assert.assertEquals((long)1L, (long)sig.length);
        Assert.assertEquals((long)uid.longId(), (long)sig[0]);
        Assert.assertEquals((long)0L, (long)((InternalRelationType)friend).getSortKey().length);
        Assert.assertEquals((Object)Order.DEFAULT, (Object)((InternalRelationType)friend).getSortOrder());
        Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)((InternalRelationType)friend).getStatus());
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(PropertyKey.class)));
        Assert.assertEquals((long)6L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(EdgeLabel.class)));
        Assert.assertEquals((long)11L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(RelationType.class)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getVertexLabels()));
        Assert.assertEquals((Object)"tweet", (Object)tweet.name());
        Assert.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.mgmt.containsVertexLabel("bla"));
        Assert.assertFalse((boolean)person.isPartitioned());
        Assert.assertFalse((boolean)person.isStatic());
        Assert.assertFalse((boolean)tag.isPartitioned());
        Assert.assertTrue((boolean)tweet.isStatic());
        try {
            this.mgmt.makePropertyKey("fid").make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.makeEdgeLabel("link").unidirected().make();
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).sortKey(new PropertyKey[]{someid, weight}).signature(new PropertyKey[]{someid}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.SIMPLE).sortKey(new PropertyKey[]{weight}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.MANY2ONE).sortKey(new PropertyKey[]{weight}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.makeVertexLabel("tweet").make();
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.makeEdgeLabel("test").signature(new PropertyKey[]{someid}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        weight = this.mgmt.getPropertyKey("weight");
        uid = this.mgmt.getPropertyKey("uid");
        someid = this.mgmt.getPropertyKey("someid");
        name = this.mgmt.getPropertyKey("name");
        value = this.mgmt.getPropertyKey("value");
        friend = this.mgmt.getEdgeLabel("friend");
        link = this.mgmt.getEdgeLabel("link");
        connect = this.mgmt.getEdgeLabel("connect");
        parent = this.mgmt.getEdgeLabel("parent");
        child = this.mgmt.getEdgeLabel("child");
        spouse = this.mgmt.getEdgeLabel("spouse");
        person = this.mgmt.getVertexLabel("person");
        tag = this.mgmt.getVertexLabel("tag");
        tweet = this.mgmt.getVertexLabel("tweet");
        Assert.assertTrue((boolean)this.mgmt.isOpen());
        Assert.assertEquals((Object)"weight", (Object)weight.toString());
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("weight"));
        Assert.assertTrue((boolean)this.mgmt.containsPropertyKey("weight"));
        Assert.assertFalse((boolean)this.mgmt.containsEdgeLabel("weight"));
        Assert.assertTrue((boolean)this.mgmt.containsEdgeLabel("connect"));
        Assert.assertFalse((boolean)this.mgmt.containsPropertyKey("connect"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationType("bla"));
        Assert.assertNull((Object)this.mgmt.getPropertyKey("bla"));
        Assert.assertNull((Object)this.mgmt.getEdgeLabel("bla"));
        Assert.assertNotNull((Object)this.mgmt.getPropertyKey("weight"));
        Assert.assertNotNull((Object)this.mgmt.getEdgeLabel("connect"));
        Assert.assertTrue((boolean)weight.isPropertyKey());
        Assert.assertFalse((boolean)weight.isEdgeLabel());
        Assert.assertEquals((Object)Cardinality.SINGLE, (Object)weight.cardinality());
        Assert.assertEquals((Object)Cardinality.SINGLE, (Object)someid.cardinality());
        Assert.assertEquals((Object)Cardinality.SET, (Object)name.cardinality());
        Assert.assertEquals((Object)Cardinality.LIST, (Object)value.cardinality());
        Assert.assertEquals(Object.class, (Object)someid.dataType());
        Assert.assertEquals(Float.class, (Object)weight.dataType());
        sig = ((InternalRelationType)value).getSignature();
        Assert.assertEquals((long)1L, (long)sig.length);
        Assert.assertEquals((long)weight.longId(), (long)sig[0]);
        Assert.assertTrue((boolean)this.mgmt.getGraphIndex(uid.name()).isUnique());
        Assert.assertFalse((boolean)this.mgmt.getGraphIndex(someid.name()).isUnique());
        Assert.assertEquals((Object)"friend", (Object)friend.name());
        Assert.assertTrue((boolean)friend.isEdgeLabel());
        Assert.assertFalse((boolean)friend.isPropertyKey());
        Assert.assertEquals((Object)Multiplicity.ONE2ONE, (Object)spouse.multiplicity());
        Assert.assertEquals((Object)Multiplicity.ONE2MANY, (Object)child.multiplicity());
        Assert.assertEquals((Object)Multiplicity.MANY2ONE, (Object)parent.multiplicity());
        Assert.assertEquals((Object)Multiplicity.MULTI, (Object)friend.multiplicity());
        Assert.assertEquals((Object)Multiplicity.SIMPLE, (Object)connect.multiplicity());
        Assert.assertTrue((boolean)link.isUnidirected());
        Assert.assertFalse((boolean)link.isDirected());
        Assert.assertFalse((boolean)child.isUnidirected());
        Assert.assertTrue((boolean)spouse.isDirected());
        Assert.assertFalse((boolean)((InternalRelationType)friend).isInvisibleType());
        Assert.assertTrue((boolean)((InternalRelationType)friend).isInvisible());
        Assert.assertEquals((long)0L, (long)((InternalRelationType)friend).getSignature().length);
        sig = ((InternalRelationType)connect).getSignature();
        Assert.assertEquals((long)1L, (long)sig.length);
        Assert.assertEquals((long)uid.longId(), (long)sig[0]);
        Assert.assertEquals((long)0L, (long)((InternalRelationType)friend).getSortKey().length);
        Assert.assertEquals((Object)Order.DEFAULT, (Object)((InternalRelationType)friend).getSortOrder());
        Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)((InternalRelationType)friend).getStatus());
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(PropertyKey.class)));
        Assert.assertEquals((long)6L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(EdgeLabel.class)));
        Assert.assertEquals((long)11L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(RelationType.class)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getVertexLabels()));
        Assert.assertEquals((Object)"tweet", (Object)tweet.name());
        Assert.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.mgmt.containsVertexLabel("bla"));
        Assert.assertFalse((boolean)person.isPartitioned());
        Assert.assertFalse((boolean)person.isStatic());
        Assert.assertFalse((boolean)tag.isPartitioned());
        Assert.assertTrue((boolean)tweet.isStatic());
        try {
            this.mgmt.makePropertyKey("fid").make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.makeEdgeLabel("link").unidirected().make();
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).sortKey(new PropertyKey[]{someid, weight}).signature(new PropertyKey[]{someid}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.SIMPLE).sortKey(new PropertyKey[]{weight}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.MANY2ONE).sortKey(new PropertyKey[]{weight}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.makeVertexLabel("tweet").make();
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.makeEdgeLabel("test").signature(new PropertyKey[]{someid}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.clopen(new Object[0]);
        TitanAssert.assertEmpty(this.tx.query().has("uid", (Object)"v1").vertices());
        TitanVertex v = this.tx.addVertex(new Object[0]);
        v.property("uid", (Object)"v1");
        v.property("weight", (Object)1.5);
        v.property("someid", (Object)"Hello");
        v.property("name", (Object)"Bob");
        v.property("name", (Object)"John");
        TitanVertexProperty p = v.property("value", (Object)11);
        p.property("weight", (Object)22);
        v.property("value", (Object)33.3, new Object[]{"weight", 66.6});
        v.property("value", (Object)11, new Object[]{"weight", 22});
        TitanVertex v12 = this.tx.addVertex("person");
        TitanVertex v13 = this.tx.addVertex("person");
        v12.property("uid", (Object)"v12");
        v13.property("uid", (Object)"v13");
        v12.addEdge("parent", (Vertex)v, new Object[]{"weight", 4.5});
        v13.addEdge("parent", (Vertex)v, new Object[]{"weight", 4.5});
        v.addEdge("child", (Vertex)v12, new Object[0]);
        v.addEdge("child", (Vertex)v13, new Object[0]);
        v.addEdge("spouse", (Vertex)v12, new Object[0]);
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v.addEdge("connect", (Vertex)v12, new Object[]{"uid", "e1"});
        v.addEdge("link", (Vertex)v13, new Object[0]);
        TitanVertex v2 = this.tx.addVertex("tweet");
        v2.addEdge("link", (Vertex)v13, new Object[0]);
        v12.addEdge("connect", (Vertex)v2, new Object[0]);
        Assert.assertEquals((Object)v, (Object)((Vertex)TitanGraphTest.getOnlyElement(this.tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v1").vertices())));
        v = TitanGraphTest.getOnlyVertex(this.tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v1"));
        v12 = TitanGraphTest.getOnlyVertex(this.tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v12"));
        v13 = TitanGraphTest.getOnlyVertex(this.tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v13"));
        try {
            v.property("weight", (Object)"x");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.property(VertexProperty.Cardinality.list, "name", (Object)"John", new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.property("link", (Object)v);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        v.property(VertexProperty.Cardinality.single, "weight", (Object)1.0, new Object[0]);
        TitanAssert.assertCount(1L, v.properties(new String[]{"weight"}));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)0.5, new Object[0]);
        Assert.assertEquals((double)0.5, (double)((Float)v.value("weight")).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"v1", (Object)v.value("uid"));
        TitanAssert.assertCount(2L, v.properties(new String[]{"name"}));
        for (TitanVertexProperty prop : v.query().labels(new String[]{"name"}).properties()) {
            String nstr = (String)prop.value();
            Assert.assertTrue((nstr.equals("Bob") || nstr.equals("John") ? 1 : 0) != 0);
        }
        Assert.assertTrue((TitanAssert.size(v.properties(new String[]{"value"})) >= 3 ? 1 : 0) != 0);
        for (TitanVertexProperty prop : v.query().labels(new String[]{"value"}).properties()) {
            double prec = (Double)prop.value();
            Assert.assertEquals((double)(prec * 2.0), (double)((Number)prop.value("weight")).doubleValue(), (double)1.0E-5);
        }
        p = v.property("value", (Object)44.4, new Object[]{"weight", 88.8});
        Assert.assertEquals((Object)v, (Object)((Vertex)TitanGraphTest.getOnlyElement(this.tx.query().has("someid", (TitanPredicate)Cmp.EQUAL, (Object)"Hello").vertices())));
        try {
            v12.addEdge("parent", (Vertex)v13, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge("child", (Vertex)v12, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge("spouse", (Vertex)v12, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.addEdge("spouse", (Vertex)v13, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        TitanAssert.assertCount(2L, v.query().direction(Direction.IN).labels(new String[]{"parent"}).edges());
        TitanAssert.assertCount(1L, v12.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        TitanAssert.assertCount(1L, v13.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        Assert.assertEquals((Object)v12, TitanGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"spouse"}).vertices()));
        TitanEdge edge = (TitanEdge)TitanGraphTest.getOnlyElement(v.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
        Assert.assertEquals((long)1L, (long)edge.keys().size());
        Assert.assertEquals((Object)"e1", (Object)edge.value("uid"));
        try {
            v.addEdge("connect", (Vertex)v12, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        TitanAssert.assertCount(1L, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        TitanAssert.assertCount(0L, v13.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v2 = (TitanVertex)TitanGraphTest.getOnlyElement(v12.query().direction(Direction.OUT).labels(new String[]{"connect"}).vertices());
        Assert.assertEquals((Object)v13, TitanGraphTest.getOnlyElement(v2.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices()));
        Assert.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.label());
        Assert.assertEquals((Object)"person", (Object)v12.label());
        Assert.assertEquals((Object)"person", (Object)v13.label());
        TitanAssert.assertCount(4L, this.tx.query().vertices());
        this.clopen(new Object[0]);
        Assert.assertEquals((Object)v, (Object)TitanGraphTest.getOnlyVertex(this.tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v1")));
        v = TitanGraphTest.getOnlyVertex(this.tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v1"));
        v12 = TitanGraphTest.getOnlyVertex(this.tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v12"));
        v13 = TitanGraphTest.getOnlyVertex(this.tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v13"));
        try {
            v.property("weight", (Object)"x");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.property(VertexProperty.Cardinality.list, "name", (Object)"John", new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.property("link", (Object)v);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        v.property(VertexProperty.Cardinality.single, "weight", (Object)1.0, new Object[0]);
        TitanAssert.assertCount(1L, v.properties(new String[]{"weight"}));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)0.5, new Object[0]);
        Assert.assertEquals((double)0.5, (double)((Float)v.value("weight")).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"v1", (Object)v.value("uid"));
        TitanAssert.assertCount(2L, v.properties(new String[]{"name"}));
        for (TitanVertexProperty prop : v.query().labels(new String[]{"name"}).properties()) {
            String nstr = (String)prop.value();
            Assert.assertTrue((nstr.equals("Bob") || nstr.equals("John") ? 1 : 0) != 0);
        }
        Assert.assertTrue((Iterables.size((Iterable)v.query().labels(new String[]{"value"}).properties()) >= 3 ? 1 : 0) != 0);
        for (TitanVertexProperty prop : v.query().labels(new String[]{"value"}).properties()) {
            double prec = (Double)prop.value();
            Assert.assertEquals((double)(prec * 2.0), (double)((Number)prop.value("weight")).doubleValue(), (double)1.0E-5);
        }
        p = v.property("value", (Object)44.4, new Object[]{"weight", 88.8});
        Assert.assertEquals((Object)v, (Object)((Vertex)TitanGraphTest.getOnlyElement(this.tx.query().has("someid", (TitanPredicate)Cmp.EQUAL, (Object)"Hello").vertices())));
        try {
            v12.addEdge("parent", (Vertex)v13, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge("child", (Vertex)v12, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge("spouse", (Vertex)v12, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.addEdge("spouse", (Vertex)v13, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        TitanAssert.assertCount(2L, v.query().direction(Direction.IN).labels(new String[]{"parent"}).edges());
        TitanAssert.assertCount(1L, v12.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        TitanAssert.assertCount(1L, v13.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        Assert.assertEquals((Object)v12, TitanGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"spouse"}).vertices()));
        edge = (TitanEdge)TitanGraphTest.getOnlyElement(v.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
        Assert.assertEquals((long)1L, (long)edge.keys().size());
        Assert.assertEquals((Object)"e1", (Object)edge.value("uid"));
        try {
            v.addEdge("connect", (Vertex)v12, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        TitanAssert.assertCount(1L, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        TitanAssert.assertCount(0L, v13.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v2 = (TitanVertex)TitanGraphTest.getOnlyElement(v12.query().direction(Direction.OUT).labels(new String[]{"connect"}).vertices());
        Assert.assertEquals((Object)v13, TitanGraphTest.getOnlyElement(v2.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices()));
        Assert.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.label());
        Assert.assertEquals((Object)"person", (Object)v12.label());
        Assert.assertEquals((Object)"person", (Object)v13.label());
        TitanAssert.assertCount(4L, this.tx.query().vertices());
        TitanTransaction tx2 = this.graph.newTransaction();
        try {
            TitanVertex vx = tx2.addVertex(new Object[0]);
            try {
                vx.property(VertexProperty.Cardinality.single, "uid", (Object)"v1", new Object[0]);
                Assert.fail();
            }
            catch (SchemaViolationException prop) {
                // empty catch block
            }
            vx.property(VertexProperty.Cardinality.single, "uid", (Object)"unique", new Object[0]);
            TitanVertex vx2 = tx2.addVertex(new Object[0]);
            try {
                vx2.property(VertexProperty.Cardinality.single, "uid", (Object)"unique", new Object[0]);
                Assert.fail();
            }
            catch (SchemaViolationException prec) {
                // empty catch block
            }
        }
        finally {
            tx2.rollback();
        }
        v2 = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v2);
        Assert.assertEquals((Object)"tweet", (Object)v2.label());
        try {
            v2.property(VertexProperty.Cardinality.single, "weight", (Object)11, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException vx) {
            // empty catch block
        }
        try {
            v2.addEdge("friend", (Vertex)v12, new Object[0]);
            Assert.fail();
        }
        catch (SchemaViolationException vx) {
            // empty catch block
        }
        TitanGraphTest.getV((TitanGraphTransaction)this.tx, v13).remove();
        TitanAssert.assertCount(1L, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        SchemaContainer schemaContainer = new SchemaContainer((TitanGraph)this.graph);
        Assert.assertTrue((boolean)schemaContainer.containsRelationType("weight"));
        Assert.assertTrue((boolean)schemaContainer.containsRelationType("friend"));
        Assert.assertTrue((boolean)schemaContainer.containsVertexLabel("person"));
        VertexLabelDefinition vld = schemaContainer.getVertexLabel("tag");
        Assert.assertFalse((boolean)vld.isPartitioned());
        Assert.assertFalse((boolean)vld.isStatic());
        PropertyKeyDefinition pkd = schemaContainer.getPropertyKey("name");
        Assert.assertEquals((Object)Cardinality.SET, (Object)pkd.getCardinality());
        Assert.assertEquals(String.class, (Object)pkd.getDataType());
        EdgeLabelDefinition eld = schemaContainer.getEdgeLabel("child");
        Assert.assertEquals((Object)"child", (Object)eld.getName());
        Assert.assertEquals((long)child.longId(), (long)eld.getLongId());
        Assert.assertEquals((Object)Multiplicity.ONE2MANY, (Object)eld.getMultiplicity());
        Assert.assertFalse((boolean)eld.isUnidirected());
    }

    @Test
    public void testDataTypes() throws Exception {
        Object value;
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.CUSTOM_ATTRIBUTE_CLASS, "attribute10"), SpecialInt.class.getCanonicalName(), TitanGraphTest.option(GraphDatabaseConfiguration.CUSTOM_SERIALIZER_CLASS, "attribute10"), SpecialIntSerializer.class.getCanonicalName());
        PropertyKey num = this.makeKey("num", SpecialInt.class);
        PropertyKey barr = this.makeKey("barr", byte[].class);
        PropertyKey boolval = this.makeKey("boolval", Boolean.class);
        PropertyKey birthday = this.makeKey("birthday", Instant.class);
        PropertyKey location = this.makeKey("location", Geoshape.class);
        PropertyKey boundary = this.makeKey("boundary", Geoshape.class);
        PropertyKey precise = this.makeKey("precise", Double.class);
        PropertyKey any = this.mgmt.makePropertyKey("any").cardinality(Cardinality.LIST).dataType(Object.class).make();
        try {
            this.makeKey("pint", Integer.TYPE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.makeKey("number", Number.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        boolval = this.tx.getPropertyKey("boolval");
        num = this.tx.getPropertyKey("num");
        barr = this.tx.getPropertyKey("barr");
        birthday = this.tx.getPropertyKey("birthday");
        location = this.tx.getPropertyKey("location");
        boundary = this.tx.getPropertyKey("boundary");
        precise = this.tx.getPropertyKey("precise");
        any = this.tx.getPropertyKey("any");
        Assert.assertEquals(Boolean.class, (Object)boolval.dataType());
        Assert.assertEquals(byte[].class, (Object)barr.dataType());
        Assert.assertEquals(Object.class, (Object)any.dataType());
        Instant c = Instant.ofEpochSecond(1429225756L);
        Geoshape point = Geoshape.point((double)10.0, (double)10.0);
        Geoshape shape = Geoshape.box((double)10.0, (double)10.0, (double)20.0, (double)20.0);
        TitanVertex v = this.tx.addVertex(new Object[0]);
        v.property(TitanGraphTest.n(boolval), (Object)true);
        v.property(VertexProperty.Cardinality.single, TitanGraphTest.n(birthday), (Object)c, new Object[0]);
        v.property(VertexProperty.Cardinality.single, TitanGraphTest.n(num), (Object)new SpecialInt(10), new Object[0]);
        v.property(VertexProperty.Cardinality.single, TitanGraphTest.n(barr), (Object)new byte[]{1, 2, 3, 4}, new Object[0]);
        v.property(VertexProperty.Cardinality.single, TitanGraphTest.n(location), (Object)point, new Object[0]);
        v.property(VertexProperty.Cardinality.single, TitanGraphTest.n(boundary), (Object)shape, new Object[0]);
        v.property(VertexProperty.Cardinality.single, TitanGraphTest.n(precise), (Object)10.12345, new Object[0]);
        v.property(TitanGraphTest.n(any), (Object)"Hello");
        v.property(TitanGraphTest.n(any), (Object)10L);
        int[] testarr = new int[]{5, 6, 7};
        v.property(TitanGraphTest.n(any), (Object)testarr);
        Assert.assertTrue((boolean)((Boolean)v.value("boolval")));
        Assert.assertEquals((long)10L, (long)((SpecialInt)v.value("num")).getValue());
        Assert.assertEquals((Object)c, (Object)v.value("birthday"));
        Assert.assertEquals((long)4L, (long)((byte[])v.value("barr")).length);
        Assert.assertEquals((Object)point, (Object)v.value("location"));
        Assert.assertEquals((Object)shape, (Object)v.value("boundary"));
        Assert.assertEquals((double)10.12345, (double)((Double)v.value("precise")), (double)1.0E-6);
        TitanAssert.assertCount(3L, v.properties(new String[]{"any"}));
        for (TitanVertexProperty prop : v.query().labels(new String[]{"any"}).properties()) {
            value = prop.value();
            if (value instanceof String) {
                Assert.assertEquals((Object)"Hello", (Object)value);
                continue;
            }
            if (value instanceof Long) {
                Assert.assertEquals((Object)10L, (Object)value);
                continue;
            }
            if (value.getClass().isArray()) {
                Assert.assertTrue((boolean)Arrays.equals(testarr, (int[])value));
                continue;
            }
            Assert.fail();
        }
        this.clopen(new Object[0]);
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        Assert.assertTrue((boolean)((Boolean)v.value("boolval")));
        Assert.assertEquals((long)10L, (long)((SpecialInt)v.value("num")).getValue());
        Assert.assertEquals((Object)c, (Object)v.value("birthday"));
        Assert.assertEquals((long)4L, (long)((byte[])v.value("barr")).length);
        Assert.assertEquals((Object)point, (Object)v.value("location"));
        Assert.assertEquals((Object)shape, (Object)v.value("boundary"));
        Assert.assertEquals((double)10.12345, (double)((Double)v.value("precise")), (double)1.0E-6);
        TitanAssert.assertCount(3L, v.properties(new String[]{"any"}));
        for (TitanVertexProperty prop : v.query().labels(new String[]{"any"}).properties()) {
            value = prop.value();
            if (value instanceof String) {
                Assert.assertEquals((Object)"Hello", (Object)value);
                continue;
            }
            if (value instanceof Long) {
                Assert.assertEquals((Object)10L, (Object)value);
                continue;
            }
            if (value.getClass().isArray()) {
                Assert.assertTrue((boolean)Arrays.equals(testarr, (int[])value));
                continue;
            }
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionalScopeOfSchemaTypes() {
        TitanVertex v2;
        this.makeVertexIndexedUniqueKey("domain", String.class);
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertex(new Object[0]);
        try {
            v1.property(VertexProperty.Cardinality.single, "domain", (Object)"unique1", new Object[0]);
        }
        catch (SchemaViolationException schemaViolationException) {
        }
        finally {
            this.tx.rollback();
            this.tx = null;
        }
        this.newTx();
        v1 = this.tx.addVertex(new Object[0]);
        v1.property("domain", (Object)"unique1");
        try {
            v2 = this.tx.addVertex(new Object[0]);
            v2.property("domain", (Object)"unique1");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
        }
        finally {
            this.tx.rollback();
            this.tx = null;
        }
        this.newTx();
        this.clopen(new Object[0]);
        v1 = this.tx.addVertex(new Object[0]);
        v1.property("domain", (Object)"unique1");
        TitanAssert.assertCount(1L, this.tx.query().has("domain", (Object)"unique1").vertices());
        try {
            v2 = this.tx.addVertex(new Object[0]);
            v2.property("domain", (Object)"unique1");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
        }
        finally {
            this.tx.rollback();
            this.tx = null;
        }
        this.newTx();
    }

    @Test
    public void testAutomaticTypeCreation() {
        Assert.assertFalse((boolean)this.tx.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.tx.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.tx.containsRelationType("value"));
        Assert.assertNull((Object)this.tx.getPropertyKey("value"));
        PropertyKey value = this.tx.getOrCreatePropertyKey("value");
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)this.tx.containsRelationType("value"));
        TitanVertex v = this.tx.addVertex("person");
        Assert.assertTrue((boolean)this.tx.containsVertexLabel("person"));
        Assert.assertEquals((Object)"person", (Object)v.label());
        Assert.assertFalse((boolean)this.tx.containsRelationType("knows"));
        TitanEdge e = v.addEdge("knows", (Vertex)v, new Object[0]);
        Assert.assertTrue((boolean)this.tx.containsRelationType("knows"));
        Assert.assertNotNull((Object)this.tx.getEdgeLabel(e.label()));
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none");
        Assert.assertTrue((boolean)this.tx.containsRelationType("value"));
        Assert.assertTrue((boolean)this.tx.containsVertexLabel("person"));
        Assert.assertTrue((boolean)this.tx.containsRelationType("knows"));
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        try {
            this.tx.addVertex("org");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            v.property("bla", (Object)5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            v.addEdge("blub", (Vertex)v, new Object[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSchemaNameChange() {
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.buildEdgeIndex(knows, "byTime", Direction.BOTH, new PropertyKey[]{time});
        this.mgmt.buildIndex("timeIndex", Vertex.class).addKey(time).buildCompositeIndex();
        this.mgmt.makeVertexLabel("people").make();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex("people");
        v.property(VertexProperty.Cardinality.single, "time", (Object)5, new Object[0]);
        v.addEdge("knows", (Vertex)v, new Object[]{"time", 11});
        this.newTx();
        v = (TitanVertex)TitanGraphTest.getOnlyElement(this.tx.query().has("time", (Object)5).vertices());
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"people", (Object)v.label());
        Assert.assertEquals((long)5L, (long)((Integer)v.value("time")).intValue());
        TitanAssert.assertCount(1L, v.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
        TitanAssert.assertCount(1L, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).has("time", (Object)11).edges());
        this.newTx();
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("knows"));
        knows = this.mgmt.getEdgeLabel("knows");
        this.mgmt.changeName((TitanSchemaElement)knows, "know");
        Assert.assertEquals((Object)"know", (Object)knows.name());
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "byTime"));
        RelationTypeIndex rindex = this.mgmt.getRelationIndex((RelationType)knows, "byTime");
        Assert.assertEquals((Object)"byTime", (Object)rindex.name());
        this.mgmt.changeName((TitanSchemaElement)rindex, "overTime");
        Assert.assertEquals((Object)"overTime", (Object)rindex.name());
        Assert.assertTrue((boolean)this.mgmt.containsVertexLabel("people"));
        VertexLabel vl = this.mgmt.getVertexLabel("people");
        this.mgmt.changeName((TitanSchemaElement)vl, "person");
        Assert.assertEquals((Object)"person", (Object)vl.name());
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("timeIndex"));
        TitanGraphIndex gindex = this.mgmt.getGraphIndex("timeIndex");
        this.mgmt.changeName((TitanSchemaElement)gindex, "byTime");
        Assert.assertEquals((Object)"byTime", (Object)gindex.name());
        this.finishSchema();
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("know"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationType("knows"));
        knows = this.mgmt.getEdgeLabel("know");
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "overTime"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "byTime"));
        Assert.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.mgmt.containsVertexLabel("people"));
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("byTime"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("timeIndex"));
        this.newTx();
        v = (TitanVertex)TitanGraphTest.getOnlyElement(this.tx.query().has("time", (Object)5).vertices());
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"person", (Object)v.label());
        Assert.assertEquals((long)5L, (long)((Integer)v.value("time")).intValue());
        TitanAssert.assertCount(1L, v.query().direction(Direction.IN).labels(new String[]{"know"}).edges());
        TitanAssert.assertCount(0L, v.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
        TitanAssert.assertCount(1L, v.query().direction(Direction.OUT).labels(new String[]{"know"}).has("time", (Object)11).edges());
    }

    @Test
    public void testGotGIndexRemoval() throws InterruptedException, ExecutionException {
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "titan"), Duration.ZERO, TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "titan"), Duration.ofMillis(50L), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "titan"), Duration.ofMillis(250L));
        String name = "name";
        GraphOfTheGodsFactory.loadWithoutMixedIndex((TitanGraph)this.graph, (boolean)true);
        this.newTx();
        this.finishSchema();
        TitanGraphIndex gindex = this.mgmt.getGraphIndex("name");
        Assert.assertNotNull((Object)gindex);
        Assert.assertEquals((long)1L, (long)gindex.getFieldKeys().length);
        Assert.assertEquals((Object)"name", (Object)gindex.getFieldKeys()[0].name());
        Assert.assertEquals((Object)"internalindex", (Object)gindex.getBackingIndex());
        Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)gindex.getIndexStatus(gindex.getFieldKeys()[0]));
        this.finishSchema();
        gindex = this.mgmt.getGraphIndex("name");
        this.mgmt.updateIndex((TitanIndex)gindex, SchemaAction.DISABLE_INDEX);
        this.mgmt.commit();
        this.tx.commit();
        ManagementUtil.awaitGraphIndexUpdate((TitanGraph)this.graph, (String)"name", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        gindex = this.mgmt.getGraphIndex("name");
        this.mgmt.updateIndex((TitanIndex)gindex, SchemaAction.REMOVE_INDEX);
        TitanManagement.IndexJobFuture gmetrics = this.mgmt.getIndexJobStatus((TitanIndex)gindex);
        this.finishSchema();
        Assert.assertNotEquals((long)0L, (long)((ScanMetrics)gmetrics.get()).getCustom("deletes"));
    }

    @Test
    public void testIndexUpdatesWithReindexAndRemove() throws InterruptedException, ExecutionException {
        TitanVertex o;
        int i;
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "titan"), Duration.ofMillis(0L), TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "titan"), Duration.ofMillis(50L), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "titan"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        PropertyKey sensor = this.mgmt.makePropertyKey("sensor").dataType(Double.class).cardinality(Cardinality.LIST).make();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex(new Object[0]);
        for (i = 0; i < 10; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
            v.property("name", (Object)("v" + i));
            o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        this.newTx();
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, new String[0]);
        this.newTx();
        this.finishSchema();
        sensor = this.mgmt.getPropertyKey("sensor");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        friend = this.mgmt.getEdgeLabel("friend");
        this.mgmt.buildPropertyIndex(sensor, "byTime", org.apache.tinkerpop.gremlin.process.traversal.Order.decr, new PropertyKey[]{time});
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.decr, new PropertyKey[]{time});
        this.mgmt.buildIndex("bySensorReading", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        this.newTx();
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        for (i = 100; i < 110; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
            v.property("name", (Object)("v" + i));
            o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        this.tx.commit();
        RelationTypeIndex pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        RelationTypeIndex eindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        TitanGraphIndex gindex = this.mgmt.getGraphIndex("bySensorReading");
        try {
            this.mgmt.updateIndex((TitanIndex)pindex, SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException i2) {
            // empty catch block
        }
        try {
            this.mgmt.updateIndex((TitanIndex)eindex, SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException i2) {
            // empty catch block
        }
        try {
            this.mgmt.updateIndex((TitanIndex)gindex, SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException i2) {
            // empty catch block
        }
        this.mgmt.commit();
        ManagementUtil.awaitVertexIndexUpdate((TitanGraph)this.graph, (String)"byTime", (String)"sensor", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        ManagementUtil.awaitGraphIndexUpdate((TitanGraph)this.graph, (String)"bySensorReading", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        eindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        gindex = this.mgmt.getGraphIndex("bySensorReading");
        Assert.assertEquals((Object)SchemaStatus.REGISTERED, (Object)pindex.getIndexStatus());
        Assert.assertEquals((Object)SchemaStatus.REGISTERED, (Object)eindex.getIndexStatus());
        Assert.assertEquals((Object)SchemaStatus.REGISTERED, (Object)gindex.getIndexStatus(gindex.getFieldKeys()[0]));
        this.finishSchema();
        eindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        this.mgmt.updateIndex((TitanIndex)eindex, SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        Assert.assertTrue((boolean)((RelationIndexStatusWatcher)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((TitanGraph)this.graph, (String)"byTime", (String)"friend").status(SchemaStatus.ENABLED)).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        ScanMetrics reindexSensorByTime = (ScanMetrics)this.mgmt.updateIndex((TitanIndex)pindex, SchemaAction.REINDEX).get();
        this.finishSchema();
        gindex = this.mgmt.getGraphIndex("bySensorReading");
        ScanMetrics reindexBySensorReading = (ScanMetrics)this.mgmt.updateIndex((TitanIndex)gindex, SchemaAction.REINDEX).get();
        this.finishSchema();
        Assert.assertNotEquals((long)0L, (long)reindexSensorByTime.getCustom("adds"));
        Assert.assertNotEquals((long)0L, (long)reindexBySensorReading.getCustom("adds"));
        pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        eindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        gindex = this.mgmt.getGraphIndex("bySensorReading");
        Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)eindex.getIndexStatus());
        Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)pindex.getIndexStatus());
        Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)gindex.getIndexStatus(gindex.getFieldKeys()[0]));
        this.newTx();
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        for (int i3 = 200; i3 < 210; ++i3) {
            v.property("sensor", (Object)i3, new Object[]{"time", i3});
            v.property("name", (Object)("v" + i3));
            TitanVertex o2 = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o2, new Object[]{"time", i3});
        }
        this.newTx();
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 0, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        this.finishSchema();
        eindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        ScanMetrics reindexFriendByTime = (ScanMetrics)this.mgmt.updateIndex((TitanIndex)eindex, SchemaAction.REINDEX).get();
        this.finishSchema();
        Assert.assertNotEquals((long)0L, (long)reindexFriendByTime.getCustom("adds"));
        this.finishSchema();
        this.newTx();
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        gindex = this.mgmt.getGraphIndex("bySensorReading");
        this.mgmt.updateIndex((TitanIndex)pindex, SchemaAction.DISABLE_INDEX);
        this.mgmt.updateIndex((TitanIndex)gindex, SchemaAction.DISABLE_INDEX);
        this.mgmt.commit();
        this.tx.commit();
        ManagementUtil.awaitVertexIndexUpdate((TitanGraph)this.graph, (String)"byTime", (String)"sensor", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        ManagementUtil.awaitGraphIndexUpdate((TitanGraph)this.graph, (String)"bySensorReading", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        gindex = this.mgmt.getGraphIndex("bySensorReading");
        Assert.assertEquals((Object)SchemaStatus.DISABLED, (Object)pindex.getIndexStatus());
        Assert.assertEquals((Object)SchemaStatus.DISABLED, (Object)gindex.getIndexStatus(gindex.getFieldKeys()[0]));
        this.finishSchema();
        this.newTx();
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.tx.commit();
        this.finishSchema();
        pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        gindex = this.mgmt.getGraphIndex("bySensorReading");
        ScanMetrics pmetrics = (ScanMetrics)this.mgmt.updateIndex((TitanIndex)pindex, SchemaAction.REMOVE_INDEX).get();
        ScanMetrics gmetrics = (ScanMetrics)this.mgmt.updateIndex((TitanIndex)gindex, SchemaAction.REMOVE_INDEX).get();
        this.finishSchema();
        Assert.assertEquals((long)30L, (long)pmetrics.getCustom("deletes"));
        Assert.assertEquals((long)30L, (long)gmetrics.getCustom("deletes"));
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testIndexUpdateSyncWithMultipleInstances() throws InterruptedException {
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "titan"), Duration.ofMillis(0L), TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "titan"), Duration.ofMillis(50L), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "titan"), Duration.ofMillis(250L));
        StandardTitanGraph graph2 = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)this.config);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "v1"});
        this.newTx();
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanTransaction tx2 = graph2.newTransaction();
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(this.mgmt.getPropertyKey("name")).buildCompositeIndex();
        this.mgmt.commit();
        TitanTransaction tx3 = graph2.newTransaction();
        tx3.addVertex(new Object[]{"name", "v2"});
        tx3.commit();
        this.newTx();
        this.tx.addVertex(new Object[]{"name", "v3"});
        this.tx.commit();
        Thread.sleep(2000L);
        this.finishSchema();
        try {
            this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        tx2.commit();
        this.mgmt.rollback();
        Assert.assertTrue((boolean)((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((TitanGraph)this.graph, (String)"theIndex").status(SchemaStatus.REGISTERED)).timeout(TestGraphConfigs.getSchemaConvergenceTime(ChronoUnit.SECONDS), (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        this.finishSchema();
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        tx2 = graph2.newTransaction();
        tx2.addVertex(new Object[]{"name", "v4"});
        tx2.commit();
        this.newTx();
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v3"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v4"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        Thread.sleep(2000L);
        tx2 = graph2.newTransaction();
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v2"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v3"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v4"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        tx2.commit();
        Set openInstances = this.mgmt.getOpenInstances();
        Assert.assertEquals((long)2L, (long)openInstances.size());
        Assert.assertTrue((boolean)openInstances.contains(this.graph.getConfiguration().getUniqueGraphId() + "(current)"));
        Assert.assertTrue((boolean)openInstances.contains(graph2.getConfiguration().getUniqueGraphId()));
        try {
            this.mgmt.forceCloseInstance(this.graph.getConfiguration().getUniqueGraphId());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.forceCloseInstance(graph2.getConfiguration().getUniqueGraphId());
        graph2.close();
    }

    @Test
    public void testPropertyCardinality() {
        PropertyKey uid = this.mgmt.makePropertyKey("uid").dataType(Long.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("byUid", Vertex.class).addKey(uid).unique().buildCompositeIndex();
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertex(new Object[0]);
        v1.property("name", (Object)"name1");
        TitanVertex v2 = this.tx.addVertex(new Object[0]);
        v2.property("uid", (Object)512);
        this.newTx();
        v1 = this.tx.getVertex(v1.longId());
        v1.property("name", (Object)"name2");
        v2 = this.tx.getVertex(v2.longId());
        v2.property("uid", (Object)512);
        this.newTx();
        TitanAssert.assertCount(0L, this.tx.query().has("name", (Object)"name1").vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("name", (Object)"name2").vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("uid", (Object)512).vertices());
    }

    @Test
    public void testImplicitKey() {
        TitanVertex v = this.graph.addVertex(new Object[]{"name", "Dan"});
        TitanVertex u = this.graph.addVertex(new Object[0]);
        TitanEdge e = v.addEdge("knows", (Vertex)u, new Object[0]);
        this.graph.tx().commit();
        RelationIdentifier eid = (RelationIdentifier)e.id();
        Assert.assertEquals((Object)v.id(), (Object)v.value(ID_NAME));
        Assert.assertEquals((Object)eid, (Object)e.value(ID_NAME));
        Assert.assertEquals((Object)"knows", (Object)e.value(LABEL_NAME));
        Assert.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.value(LABEL_NAME));
        TitanAssert.assertCount(1L, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has(ID_NAME, (Object)eid).edges());
        TitanAssert.assertCount(0L, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has(ID_NAME, (Object)RelationIdentifier.get((long[])new long[]{4L, 5L, 6L, 7L})).edges());
        TitanAssert.assertCount(1L, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has("~nid", (Object)eid.getRelationId()).edges());
        TitanAssert.assertCount(0L, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has("~nid", (Object)110111).edges());
        Assert.assertNotNull((Object)TitanGraphTest.getE((TitanGraphTransaction)this.graph, eid));
        Assert.assertEquals((Object)eid, (Object)TitanGraphTest.getE((TitanGraphTransaction)this.graph, eid).id());
        Assert.assertEquals((long)1L, (long)v.query().direction(Direction.BOTH).has("~adjacent", u.id()).edgeCount());
        TitanAssert.assertCount(1L, v.query().direction(Direction.BOTH).has("~adjacent", (Object)((int)TitanGraphTest.getId((Element)u))).edges());
        try {
            TitanAssert.assertCount(0L, v.query().direction(Direction.BOTH).has("~adjacent", (Object)110111).edges());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayEqualityUsingImplicitKey() {
        TitanVertex v = this.graph.addVertex(new Object[0]);
        byte[] singleDimension = new byte[]{127, 0, 0, 1};
        byte[] singleDimensionCopy = new byte[]{127, 0, 0, 1};
        String singlePropName = "single";
        v.property("single", (Object)singleDimension);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimension).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimensionCopy).vertices()));
        this.graph.tx().commit();
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimension).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimensionCopy).vertices()));
    }

    @Test
    public void testSelfLoop() {
        TitanVertex v = this.tx.addVertex(new Object[0]);
        v.addEdge("self", (Vertex)v, new Object[0]);
        TitanAssert.assertCount(1L, v.query().direction(Direction.OUT).labels(new String[]{"self"}).edges());
        TitanAssert.assertCount(1L, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        TitanAssert.assertCount(2L, v.query().direction(Direction.BOTH).labels(new String[]{"self"}).edges());
        this.clopen(new Object[0]);
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        Assert.assertNotNull((Object)v);
        TitanAssert.assertCount(1L, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        TitanAssert.assertCount(1L, v.query().direction(Direction.OUT).labels(new String[]{"self"}).edges());
        TitanAssert.assertCount(1L, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        TitanAssert.assertCount(2L, v.query().direction(Direction.BOTH).labels(new String[]{"self"}).edges());
    }

    @Test
    public void testThreadBoundTx() {
        PropertyKey t = this.mgmt.makePropertyKey("type").dataType(Integer.class).make();
        this.mgmt.buildIndex("etype", Edge.class).addKey(t).buildCompositeIndex();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friend")).sortKey(new PropertyKey[]{t}).make();
        this.finishSchema();
        TitanVertex v1 = this.graph.addVertex(new Object[]{"name", "Vertex1", "age", 35});
        TitanVertex v2 = this.graph.addVertex(new Object[]{"name", "Vertex2", "age", 45});
        TitanVertex v3 = this.graph.addVertex(new Object[]{"name", "Vertex3", "age", 55});
        TitanEdge e1 = v1.addEdge("knows", (Vertex)v2, new Object[]{"time", 5});
        TitanEdge e2 = v2.addEdge("knows", (Vertex)v3, new Object[]{"time", 15});
        TitanEdge e3 = v3.addEdge("knows", (Vertex)v1, new Object[]{"time", 25});
        TitanEdge e4 = v2.addEdge("friend", (Vertex)v2, new Object[]{"type", 1});
        for (TitanVertex v : new TitanVertex[]{v1, v2, v3}) {
            TitanAssert.assertCount(2L, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            TitanAssert.assertCount(1L, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            TitanEdge tmpE = (TitanEdge)TitanGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assert.assertEquals((long)5L, (long)((Integer)tmpE.value("time") % 10));
        }
        e3.property("time", (Object)35);
        Assert.assertEquals((long)35L, (long)((Integer)e3.value("time")).intValue());
        v1.addEdge("friend", (Vertex)v2, new Object[]{"type", 0});
        this.graph.tx().commit();
        e4.property("type", (Object)2);
        TitanEdge ef = (TitanEdge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"friend"}).edges());
        Assert.assertEquals((Object)ef, (Object)((Edge)TitanGraphTest.getOnlyElement(this.graph.query().has("type", (Object)0).edges())));
        ef.property("type", (Object)1);
        this.graph.tx().commit();
        Assert.assertEquals((long)35L, (long)((Integer)e3.value("time")).intValue());
        e3 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, e3);
        e3.property("time", (Object)45);
        Assert.assertEquals((long)45L, (long)((Integer)e3.value("time")).intValue());
        Assert.assertEquals((long)15L, (long)((Integer)e2.value("time")).intValue());
        e2.property("time", (Object)25);
        Assert.assertEquals((long)25L, (long)((Integer)e2.value("time")).intValue());
        Assert.assertEquals((long)35L, (long)((Integer)v1.value("age")).intValue());
        Assert.assertEquals((long)55L, (long)((Integer)v3.value("age")).intValue());
        v3.property("age", (Object)65);
        Assert.assertEquals((long)65L, (long)((Integer)v3.value("age")).intValue());
        e1 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, e1);
        for (TitanVertex v : new TitanVertex[]{v1, v2, v3}) {
            TitanAssert.assertCount(2L, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            TitanAssert.assertCount(1L, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assert.assertEquals((long)5L, (long)((Integer)((TitanEdge)TitanGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges())).value("time") % 10));
        }
        this.graph.tx().commit();
        VertexProperty prop = (VertexProperty)v1.properties(new String[0]).next();
        Assert.assertTrue((TitanGraphTest.getId((Element)prop) > 0L ? 1 : 0) != 0);
        prop = (VertexProperty)((Iterable)this.graph.multiQuery(new TitanVertex[]{v1}).properties().values().iterator().next()).iterator().next();
        Assert.assertTrue((TitanGraphTest.getId((Element)prop) > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)45L, (long)((Integer)e3.value("time")).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)e1.value("time")).intValue());
        Assert.assertEquals((long)35L, (long)((Integer)v1.value("age")).intValue());
        Assert.assertEquals((long)65L, (long)((Integer)v3.value("age")).intValue());
        for (TitanVertex v : new TitanVertex[]{v1, v2, v3}) {
            TitanAssert.assertCount(2L, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            TitanAssert.assertCount(1L, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assert.assertEquals((long)5L, (long)((Integer)((TitanEdge)TitanGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges())).value("time") % 10));
        }
        this.graph.tx().commit();
        v1 = this.graph.addVertex(new Object[0]);
        v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        v3 = this.graph.addVertex(new Object[0]);
        TitanEdge e = v1.addEdge("knows", (Vertex)v3, new Object[0]);
        Assert.assertFalse((boolean)e.property("age").isPresent());
    }

    @Test
    public void testNestedTransactions() {
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        this.newTx();
        TitanVertex v2 = this.tx.addVertex(new Object[0]);
        v2.property("name", (Object)"foo");
        this.tx.commit();
        v1.addEdge("related", (Vertex)this.graph.traversal().V(new Object[]{v2}).next(), new Object[0]);
        this.graph.tx().commit();
        TitanAssert.assertCount(1L, v1.edges(Direction.OUT, new String[0]));
    }

    @Test
    public void testStaleVertex() {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey age = this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).unique().buildCompositeIndex();
        this.finishSchema();
        TitanVertex cartman = this.graph.addVertex(new Object[]{"name", "cartman", "age", 10});
        TitanVertex stan = this.graph.addVertex(new Object[]{"name", "stan", "age", 8});
        this.graph.tx().commit();
        cartman = (TitanVertex)TitanGraphTest.getOnlyElement(this.graph.query().has("name", (Object)"cartman").vertices());
        this.graph.tx().commit();
        TitanVertexProperty p = (TitanVertexProperty)cartman.properties(new String[0]).next();
        Assert.assertTrue((Long.valueOf(p.longId()) > 0L ? 1 : 0) != 0);
        this.graph.tx().commit();
    }

    @Test
    public void testTransactionIsolation() {
        this.makeLabel("knows");
        this.finishSchema();
        TitanTransaction tx1 = this.graph.newTransaction();
        TitanTransaction tx2 = this.graph.newTransaction();
        TitanVertex v11 = tx1.addVertex(new Object[0]);
        TitanVertex v12 = tx1.addVertex(new Object[0]);
        v11.addEdge("knows", (Vertex)v12, new Object[0]);
        TitanVertex v21 = tx2.addVertex(new Object[0]);
        try {
            v21.addEdge("knows", (Vertex)v11, new Object[0]);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TitanVertex v22 = tx2.addVertex(new Object[0]);
        v21.addEdge("knows", (Vertex)v22, new Object[0]);
        tx2.commit();
        try {
            v22.addEdge("knows", (Vertex)v21, new Object[0]);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        tx1.rollback();
        try {
            v11.property(VertexProperty.Cardinality.single, "test", (Object)5, new Object[0]);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.newTx();
        v21 = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v21);
        this.tx.makeEdgeLabel("link").unidirected().make();
        TitanVertex v3 = this.tx.addVertex(new Object[0]);
        v21.addEdge("link", (Vertex)v3, new Object[0]);
        this.newTx();
        v21 = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v21);
        v3 = (TitanVertex)TitanGraphTest.getOnlyElement(v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assert.assertFalse((boolean)v3.isRemoved());
        v3.remove();
        this.newTx();
        v21 = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v21);
        v3 = (TitanVertex)TitanGraphTest.getOnlyElement(v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assert.assertFalse((boolean)v3.isRemoved());
        this.newTx();
        TitanTransaction tx3 = this.graph.buildTransaction().checkInternalVertexExistence(true).start();
        v21 = TitanGraphTest.getV((TitanGraphTransaction)tx3, v21);
        v3 = (TitanVertex)TitanGraphTest.getOnlyElement(v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assert.assertTrue((boolean)v3.isRemoved());
        tx3.commit();
    }

    @Test
    public <V> void testMultivaluedVertexProperty() {
        String foo = "foo";
        String bar = "bar";
        String weight = "weight";
        ImmutableList values = ImmutableList.of((Object)"four", (Object)"score", (Object)"and", (Object)"seven");
        Assert.assertTrue((String)"Values list must have multiple elements for this test to make sense", (2 <= values.size() ? 1 : 0) != 0);
        PropertyKey w = this.makeKey("weight", Integer.class);
        PropertyKey f = ((StandardPropertyKeyMaker)this.mgmt.makePropertyKey("foo")).dataType(String.class).cardinality(Cardinality.LIST).sortKey(new PropertyKey[]{w}).sortOrder(Order.DESC).make();
        this.mgmt.buildIndex("foo", Vertex.class).addKey(f).buildCompositeIndex();
        PropertyKey b = this.mgmt.makePropertyKey("bar").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildIndex("bar", Vertex.class).addKey(b).buildCompositeIndex();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex(new Object[0]);
        int i = 0;
        for (String s : values) {
            v.property("foo", (Object)s, new Object[]{"weight", ++i});
            v.property("bar", (Object)s, new Object[]{"weight", i});
        }
        TitanAssert.assertCount(values.size(), v.properties(new String[]{"foo"}));
        TitanAssert.assertCount(values.size(), v.properties(new String[]{"bar"}));
        for (String prop : new String[]{"foo", "bar"}) {
            int sum = 0;
            int index = values.size();
            for (TitanVertexProperty p2 : v.query().labels(new String[]{"foo"}).properties()) {
                Assert.assertTrue((boolean)values.contains(p2.value()));
                int wint = (Integer)p2.value("weight");
                sum += wint;
                if (prop == "foo") {
                    Assert.assertEquals((long)index, (long)wint);
                }
                --index;
            }
            Assert.assertEquals((long)(values.size() * (values.size() + 1) / 2), (long)sum);
        }
        TitanAssert.assertCount(1L, this.tx.query().has("foo", values.get(1)).vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("foo", values.get(3)).vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("bar", values.get(1)).vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("bar", values.get(3)).vertices());
        TitanGraphTest.asStream(v.properties(new String[]{"foo"})).forEach(p -> p.remove());
        TitanAssert.assertEmpty(v.properties(new String[]{"foo"}));
        this.clopen(new Object[0]);
        TitanAssert.assertCount(0L, this.tx.query().has("foo", values.get(1)).vertices());
        TitanAssert.assertCount(0L, this.tx.query().has("foo", values.get(3)).vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("bar", values.get(1)).vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("bar", values.get(3)).vertices());
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        TitanAssert.assertEmpty(v.properties(new String[]{"foo"}));
        TitanAssert.assertCount(values.size(), v.properties(new String[]{"bar"}));
        for (String s : values) {
            v.property("foo", (Object)s);
        }
        TitanAssert.assertCount(values.size(), v.properties(new String[]{"foo"}));
        TitanGraphTest.asStream(v.properties(new String[]{"foo"})).forEach(p -> p.remove());
        TitanAssert.assertEmpty(v.properties(new String[]{"foo"}));
    }

    @Test
    public void testLocalGraphConfiguration() {
        this.setIllegalGraphOption(GraphDatabaseConfiguration.STORAGE_READONLY, ConfigOption.Type.LOCAL, true);
    }

    @Test
    public void testMaskableGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.DB_CACHE, ConfigOption.Type.MASKABLE, true, false);
    }

    @Test
    public void testGlobalGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, ConfigOption.Type.GLOBAL, true, false);
    }

    @Test
    public void testGlobalOfflineGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.DB_CACHE_TIME, ConfigOption.Type.GLOBAL_OFFLINE, 500L, 777L);
    }

    @Test
    public void testFixedGraphConfig() {
        this.setIllegalGraphOption(GraphDatabaseConfiguration.INITIAL_TITAN_VERSION, ConfigOption.Type.FIXED, "foo");
    }

    @Test
    public void testManagedOptionMasking() throws BackendException {
        Duration customCommitTime = Duration.ofMillis(456L);
        Preconditions.checkState((true == (Boolean)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getDefaultValue() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getType().equals((Object)ConfigOption.Type.MASKABLE));
        Preconditions.checkState((!customCommitTime.equals(GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue()) ? 1 : 0) != 0);
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)false);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        try {
            this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
            Assert.fail((String)"Masking managed config options should be disabled in this configuration");
        }
        catch (TitanConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0])));
        }
        this.close();
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        Assert.assertEquals((Object)GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue(), (Object)this.graph.getConfiguration().getMaxCommitTime());
        this.graph.getBackend().clearStorage();
        try {
            this.graph.close();
        }
        catch (Throwable t) {
            this.log.debug("Swallowing throwable during shutdown after clearing backend storage", t);
        }
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)false);
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        this.close();
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        try {
            this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
            Assert.fail((String)"Masking managed config options should be disabled in this configuration");
        }
        catch (TitanConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0])));
        }
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        Assert.assertEquals((Object)GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue(), (Object)this.graph.getConfiguration().getMaxCommitTime());
    }

    @Test
    public void testTransactionConfiguration() {
        block2: {
            TitanTransaction readOnlyTx = this.graph.buildTransaction().readOnly().start();
            try {
                readOnlyTx.addVertex(new Object[0]);
                readOnlyTx.commit();
                Assert.fail((String)"Read-only transactions should not be able to add a vertex and commit");
            }
            catch (Throwable t) {
                if (!readOnlyTx.isOpen()) break block2;
                readOnlyTx.rollback();
            }
        }
        String logID = "spam";
        StandardTitanTx customLogIDTx = (StandardTitanTx)this.graph.buildTransaction().logIdentifier(logID).start();
        Assert.assertEquals((Object)logID, (Object)customLogIDTx.getConfiguration().getLogIdentifier());
        customLogIDTx.rollback();
        Instant customTimestamp = Instant.ofEpochMilli(-42L);
        StandardTitanTx customTimeTx = (StandardTitanTx)this.graph.buildTransaction().commitTime(customTimestamp).start();
        Assert.assertTrue((boolean)customTimeTx.getConfiguration().hasCommitTime());
        Assert.assertEquals((Object)customTimestamp, (Object)customTimeTx.getConfiguration().getCommitTime());
        customTimeTx.rollback();
    }

    private <T> void setAndCheckGraphOption(ConfigOption<T> opt, ConfigOption.Type requiredType, T firstValue, T secondValue) {
        Preconditions.checkState((boolean)opt.getType().equals((Object)requiredType));
        EnumSet<ConfigOption.Type> allowedTypes = EnumSet.of(ConfigOption.Type.GLOBAL, ConfigOption.Type.GLOBAL_OFFLINE, ConfigOption.Type.MASKABLE);
        Preconditions.checkState((boolean)allowedTypes.contains(opt.getType()));
        Preconditions.checkArgument((!firstValue.equals(secondValue) ? 1 : 0) != 0);
        String path = ConfigElement.getPath(opt, (String[])new String[0]);
        this.mgmt.set(path, firstValue);
        Assert.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        this.tx.rollback();
        this.mgmt.commit();
        this.clopen(new Object[0]);
        this.tx.rollback();
        Assert.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        this.mgmt.set(path, secondValue);
        Assert.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        this.mgmt.commit();
        this.clopen(new Object[0]);
        this.tx.rollback();
        Assert.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        TitanGraph g2 = TitanFactory.open((ReadConfiguration)this.config);
        TitanManagement m2 = g2.openManagement();
        Assert.assertEquals((Object)secondValue.toString(), (Object)m2.get(path));
        if (opt.getType().equals((Object)ConfigOption.Type.GLOBAL_OFFLINE)) {
            try {
                this.mgmt.set(path, firstValue);
                this.mgmt.commit();
                Assert.fail((String)("Option " + path + " with type " + ConfigOption.Type.GLOBAL_OFFLINE + " should not be modifiable with concurrent instances"));
            }
            catch (RuntimeException e) {
                this.log.debug("Caught expected exception", (Throwable)e);
            }
            Assert.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        } else {
            this.mgmt.set(path, firstValue);
            Assert.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
            this.mgmt.commit();
            this.clopen(new Object[0]);
            Assert.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        }
        m2.rollback();
        g2.close();
    }

    private <T> void setIllegalGraphOption(ConfigOption<T> opt, ConfigOption.Type requiredType, T attemptedValue) {
        ConfigOption.Type type = opt.getType();
        Preconditions.checkState((boolean)type.equals((Object)requiredType));
        Preconditions.checkArgument((requiredType.equals((Object)ConfigOption.Type.LOCAL) || requiredType.equals((Object)ConfigOption.Type.FIXED) ? 1 : 0) != 0);
        String path = ConfigElement.getPath(opt, (String[])new String[0]);
        try {
            this.mgmt.get(path);
        }
        catch (Throwable t) {
            this.log.debug("Caught expected exception", t);
        }
        try {
            this.mgmt.set(path, attemptedValue);
            this.mgmt.commit();
            Assert.fail((String)("Option " + path + " with type " + type + " should not be modifiable in the persistent graph config"));
        }
        catch (Throwable t) {
            this.log.debug("Caught expected exception", t);
        }
    }

    @Test
    public void testConsistencyEnforcement() {
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.setConsistency((TitanSchemaElement)uid, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)name, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel spouse = this.mgmt.makeEdgeLabel("spouse").multiplicity(Multiplicity.ONE2ONE).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").multiplicity(Multiplicity.MULTI).make();
        EdgeLabel related = this.mgmt.makeEdgeLabel("related").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.setConsistency((TitanSchemaElement)knows, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)spouse, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)related, ConsistencyModifier.FORK);
        this.finishSchema();
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        TitanVertex v1 = this.tx.addVertex(new Object[]{"uid", 1});
        TitanVertex v2 = this.tx.addVertex(new Object[]{"uid", 2});
        TitanVertex v3 = this.tx.addVertex(new Object[]{"uid", 3});
        TitanEdge e1 = v1.addEdge(connect.name(), (Vertex)v2, new Object[]{name.name(), "e1"});
        TitanEdge e2 = v1.addEdge(related.name(), (Vertex)v2, new Object[]{name.name(), "e2"});
        this.newTx();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v1);
        long e1id = TitanGraphTest.getId((Element)e1);
        long e2id = TitanGraphTest.getId((Element)e2);
        e1 = (Edge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
        Assert.assertEquals((Object)"e1", (Object)e1.value("name"));
        Assert.assertEquals((long)e1id, (long)TitanGraphTest.getId((Element)e1));
        e2 = (Edge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"related"}).edges());
        Assert.assertEquals((Object)"e2", (Object)e2.value("name"));
        Assert.assertEquals((long)e2id, (long)TitanGraphTest.getId((Element)e2));
        e1.property("name", (Object)"e1.2");
        e2.property("name", (Object)"e2.2");
        this.newTx();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v1);
        e1 = (Edge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
        Assert.assertEquals((Object)"e1.2", (Object)e1.value("name"));
        Assert.assertEquals((long)e1id, (long)TitanGraphTest.getId((Element)e1));
        e2 = (Edge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"related"}).edges());
        Assert.assertEquals((Object)"e2.2", (Object)e2.value("name"));
        Assert.assertNotEquals((long)e2id, (long)TitanGraphTest.getId((Element)e2));
        this.clopen(new Object[0]);
        final Random random = new Random();
        final long[] vids = new long[]{TitanGraphTest.getId((Element)v1), TitanGraphTest.getId((Element)v2), TitanGraphTest.getId((Element)v3)};
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){
            private int pos = 0;

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, vids[this.pos++]);
                u.property(VertexProperty.Cardinality.single, "uid", (Object)5, new Object[0]);
            }
        });
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, vids[0]);
                u.property(VertexProperty.Cardinality.single, "name", (Object)("v" + random.nextInt(10)), new Object[0]);
            }
        });
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u1 = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, vids[0]);
                TitanVertex u2 = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, vids[1]);
                u1.addEdge("knows", (Vertex)u2, new Object[0]);
            }
        });
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){
            private int pos = 1;

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u1 = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, vids[0]);
                TitanVertex u2 = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, vids[this.pos++]);
                u1.addEdge("spouse", (Vertex)u2, new Object[0]);
            }
        });
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){
            private int pos = 1;

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u1 = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, vids[this.pos++]);
                TitanVertex u2 = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, vids[0]);
                u1.addEdge("spouse", (Vertex)u2, new Object[0]);
            }
        });
        try {
            this.mgmt.setConsistency((TitanSchemaElement)this.mgmt.getPropertyKey("name"), ConsistencyModifier.FORK);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void executeLockConflictingTransactionJobs(TitanGraph graph, TransactionJob job) {
        TitanTransaction tx1 = graph.newTransaction();
        TitanTransaction tx2 = graph.newTransaction();
        job.run(tx1);
        job.run(tx2);
        if (this.isLockingOptimistic()) {
            tx1.commit();
            try {
                tx2.commit();
                Assert.fail((String)"Storage backend does not abort conflicting transactions");
            }
            catch (TitanException titanException) {}
        } else {
            try {
                tx1.commit();
                Assert.fail((String)"Storage backend does not abort conflicting transactions");
            }
            catch (TitanException titanException) {
                // empty catch block
            }
            tx2.commit();
        }
    }

    @Test
    public void testConcurrentConsistencyEnforcement() throws Exception {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        TitanGraphIndex nameIndex = this.mgmt.buildIndex("name", Vertex.class).addKey(name).unique().buildCompositeIndex();
        this.mgmt.setConsistency((TitanSchemaElement)nameIndex, ConsistencyModifier.LOCK);
        EdgeLabel married = this.mgmt.makeEdgeLabel("married").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.setConsistency((TitanSchemaElement)married, ConsistencyModifier.LOCK);
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        TitanVertex baseV = this.tx.addVertex(new Object[]{"name", "base"});
        this.newTx();
        final long baseVid = TitanGraphTest.getId((Element)baseV);
        String nameA = "a";
        String nameB = "b";
        int parallelThreads = 4;
        AtomicInteger totalExe = new AtomicInteger();
        int numSuccess = this.executeParallelTransactions(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex a = tx.addVertex(new Object[0]);
                TitanVertex base = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, baseVid);
                base.addEdge("married", (Vertex)a, new Object[0]);
            }
        }, 4);
        Assert.assertTrue((String)("At most 1 tx should succeed: " + numSuccess), (numSuccess <= 1 ? 1 : 0) != 0);
        numSuccess = this.executeParallelTransactions(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex a = tx.addVertex(new Object[]{"name", "a"});
                TitanVertex b = tx.addVertex(new Object[]{"name", "b"});
                b.addEdge("friend", (Vertex)b, new Object[0]);
            }
        }, 4);
        this.newTx();
        long numA = Iterables.size((Iterable)this.tx.query().has("name", (Object)"a").vertices());
        long numB = Iterables.size((Iterable)this.tx.query().has("name", (Object)"b").vertices());
        Assert.assertTrue((String)("At most 1 tx should succeed: " + numSuccess), (numSuccess <= 1 ? 1 : 0) != 0);
        Assert.assertTrue((numA <= 1L ? 1 : 0) != 0);
        Assert.assertTrue((numB <= 1L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failTransactionOnCommit(TransactionJob job) {
        TitanTransaction tx = this.graph.newTransaction();
        try {
            job.run(tx);
            tx.commit();
            Assert.fail();
        }
        catch (Exception exception) {
        }
        finally {
            if (tx.isOpen()) {
                tx.rollback();
            }
        }
    }

    private int executeSerialTransaction(TransactionJob job, int number) {
        AtomicInteger txSuccess = new AtomicInteger(0);
        for (int i = 0; i < number; ++i) {
            TitanTransaction tx = this.graph.newTransaction();
            try {
                job.run(tx);
                tx.commit();
                txSuccess.incrementAndGet();
                continue;
            }
            catch (Exception ex) {
                tx.rollback();
                ex.printStackTrace();
            }
        }
        return txSuccess.get();
    }

    private int executeParallelTransactions(final TransactionJob job, int number) {
        final CountDownLatch startLatch = new CountDownLatch(number);
        final CountDownLatch finishLatch = new CountDownLatch(number);
        final AtomicInteger txSuccess = new AtomicInteger(0);
        for (int i = 0; i < number; ++i) {
            new Thread(){

                @Override
                public void run() {
                    this.awaitAllThreadsReady();
                    TitanTransaction tx = TitanGraphTest.this.graph.newTransaction();
                    try {
                        job.run(tx);
                        tx.commit();
                        txSuccess.incrementAndGet();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (tx.isOpen()) {
                            tx.rollback();
                        }
                    }
                    finally {
                        finishLatch.countDown();
                    }
                }

                private void awaitAllThreadsReady() {
                    startLatch.countDown();
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        try {
            finishLatch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return txSuccess.get();
    }

    @Test
    public void testVertexCentricQuery() {
        this.testVertexCentricQuery(10000);
    }

    public void testVertexCentricQuery(int noVertices) {
        int nowTime3;
        int i;
        VertexList vl;
        int i2;
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey time = this.makeKey("time", Integer.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey number = this.makeKey("number", Long.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("connect")).sortKey(new PropertyKey[]{time}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("connectDesc")).sortKey(new PropertyKey[]{time}).sortOrder(Order.DESC).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friend")).sortKey(new PropertyKey[]{weight, time}).sortOrder(Order.ASC).signature(new PropertyKey[]{number}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friendDesc")).sortKey(new PropertyKey[]{weight, time}).sortOrder(Order.DESC).signature(new PropertyKey[]{number}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{number, weight}).make();
        this.mgmt.makeEdgeLabel("follows").make();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex(new Object[]{"name", "v"});
        TitanVertex u = this.tx.addVertex(new Object[]{"name", "u"});
        Assert.assertEquals((long)0L, (long)((noVertices - 1) % 3));
        TitanVertex[] vs = new TitanVertex[noVertices];
        for (int i3 = 1; i3 < noVertices; ++i3) {
            vs[i3] = this.tx.addVertex(new Object[]{"name", "v" + i3});
        }
        EdgeLabel[] labelsV = new EdgeLabel[]{this.tx.getEdgeLabel("connect"), this.tx.getEdgeLabel("friend"), this.tx.getEdgeLabel("knows")};
        EdgeLabel[] labelsU = new EdgeLabel[]{this.tx.getEdgeLabel("connectDesc"), this.tx.getEdgeLabel("friendDesc"), this.tx.getEdgeLabel("knows")};
        for (int i4 = 1; i4 < noVertices; ++i4) {
            for (TitanVertex vertex : new TitanVertex[]{v, u}) {
                for (Direction d : new Direction[]{Direction.OUT, Direction.IN}) {
                    EdgeLabel label = vertex == v ? labelsV[i4 % 3] : labelsU[i4 % 3];
                    TitanEdge e = d == Direction.OUT ? vertex.addEdge(TitanGraphTest.n(label), (Vertex)vs[i4], new Object[0]) : vs[i4].addEdge(TitanGraphTest.n(label), (Vertex)vertex, new Object[0]);
                    e.property("time", (Object)i4);
                    e.property("weight", (Object)((double)(i4 % 4) + 0.5));
                    e.property("name", (Object)("e" + i4));
                    e.property("number", (Object)(i4 % 5));
                }
            }
        }
        int edgesPerLabel = noVertices / 3;
        this.clopen(new Object[0]);
        long[] vidsubset = new long[28];
        for (i2 = 0; i2 < vidsubset.length; ++i2) {
            vidsubset[i2] = vs[i2 + 3].longId();
        }
        Arrays.sort(vidsubset);
        this.clopen(new Object[0]);
        for (i2 = 1; i2 < noVertices; ++i2) {
            vs[i2] = TitanGraphTest.getV((TitanGraphTransaction)this.tx, vs[i2].longId());
        }
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v.longId());
        u = TitanGraphTest.getV((TitanGraphTransaction)this.tx, u.longId());
        Object[] qvs = new TitanVertex[]{vs[6], vs[9], vs[12], vs[15], vs[60]};
        TitanAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assert.assertEquals((long)1L, (long)v.query().propertyCount());
        Assert.assertEquals((long)10L, (long)TitanAssert.size(v.query().labels(new String[]{"connect"}).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)TitanAssert.size(u.query().labels(new String[]{"connectDesc"}).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)TitanAssert.size(v.query().labels(new String[]{"connect"}).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)TitanAssert.size(u.query().labels(new String[]{"connectDesc"}).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        int lastTime = 0;
        for (TitanEdge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges()) {
            int nowTime2 = (Integer)e.value("time");
            Assert.assertTrue((String)(lastTime + " vs. " + nowTime2), (lastTime <= nowTime2 ? 1 : 0) != 0);
            lastTime = nowTime2;
        }
        lastTime = Integer.MAX_VALUE;
        for (TitanEdge e : u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).limit(20).edges()) {
            int nowTime3 = (Integer)e.value("time");
            Assert.assertTrue((String)(lastTime + " vs. " + nowTime3), (lastTime >= nowTime3 ? 1 : 0) != 0);
            lastTime = nowTime3;
        }
        Assert.assertEquals((long)10L, (long)TitanAssert.size(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)TitanAssert.size(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Iterator outer = v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges().iterator();
        for (TitanEdge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(10).edges()) {
            Assert.assertEquals((Object)e, outer.next());
        }
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Object)15).has("weight", (Object)3.5), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        Assert.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assert.assertEquals((long)10L, (long)u.query().labels(new String[]{"connectDesc"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", null).edgeCount());
        Assert.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds().size());
        Assert.assertEquals((long)(edgesPerLabel - 10), (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)31).count());
        Assert.assertEquals((long)10L, (long)TitanAssert.size(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertices()));
        Assert.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).limit(3).count());
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).limit(3), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5)), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5, (Object)2.5)).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)), RelationCategory.EDGE, 7, 3, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5)), RelationCategory.EDGE, 1667, 2, new boolean[]{true, true});
        Assert.assertEquals((long)3L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assert.assertEquals((long)1L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assert.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assert.assertEquals((long)4L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.LESS_THAN_EQUAL, (Object)10).edgeCount());
        Assert.assertEquals((long)(edgesPerLabel - 4), (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)10).edgeCount());
        Assert.assertEquals((long)20L, (long)v.query().labels(new String[]{"friend", "connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).edgeCount());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)).edgeCount());
        Assert.assertEquals((long)((int)Math.floor((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(2.1), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assert.assertEquals((long)20L, (long)TitanAssert.size(v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertices()));
        Assert.assertEquals((long)20L, (long)TitanAssert.size(v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertexIds()));
        Assert.assertEquals((long)30L, (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assert.assertEquals((long)(noVertices - 2), (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assert.assertEquals((long)0L, (long)v.query().has("age", null).labels(new String[]{"undefined"}).direction(Direction.OUT).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.IN).adjacent((Vertex)vs[11]).edgeCount());
        Assert.assertEquals((long)2L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).has("weight", (Object)3.5).edgeCount());
        Assert.assertEquals((long)2L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[8]).has("time", (Object)8).edgeCount());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).edgeCount());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).edgeCount());
        Assert.assertEquals((long)(2 * edgesPerLabel), (long)v.query().labels(new String[]{"connect"}).direction(Direction.BOTH).edgeCount());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).has("undefined", null).direction(Direction.OUT).edgeCount());
        Assert.assertEquals((long)(2 * (int)Math.ceil((double)(noVertices - 1) / 4.0)), (long)TitanAssert.size(v.query().labels(new String[]{"connect", "friend", "knows"}).has("weight", (Object)1.5).vertexIds()));
        Assert.assertEquals((long)1L, (long)v.query().direction(Direction.IN).has("time", (Object)1).edgeCount());
        Assert.assertEquals((long)10L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).edgeCount());
        Assert.assertEquals((long)9L, (long)v.query().direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (TitanPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assert.assertEquals((long)9L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (TitanPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assert.assertEquals((long)(noVertices - 1), (long)TitanAssert.size(v.query().direction(Direction.OUT).vertices()));
        Assert.assertEquals((long)(noVertices - 1), (long)TitanAssert.size(v.query().direction(Direction.IN).vertices()));
        for (Direction dir : new Direction[]{Direction.IN, Direction.OUT}) {
            vl = v.query().labels(new String[0]).direction(dir).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds();
            vl.sort();
            for (i = 0; i < vl.size(); ++i) {
                Assert.assertEquals((long)vidsubset[i], (long)vl.getID(i));
            }
        }
        TitanAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assert.assertEquals((long)1L, (long)TitanAssert.size(v.query().properties()));
        Assert.assertEquals((long)1L, (long)TitanAssert.size(v.query().keys(new String[]{"name"}).properties()));
        Map results = this.tx.multiQuery((TitanVertex[])qvs).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)1L, (long)TitanAssert.size(result));
        }
        results = this.tx.multiQuery((Collection)Sets.newHashSet((Object[])qvs)).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)2L, (long)TitanAssert.size(result));
        }
        results = this.tx.multiQuery((TitanVertex[])qvs).labels(new String[]{"knows"}).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)0L, (long)TitanAssert.size(result));
        }
        results = this.tx.multiQuery((TitanVertex[])qvs).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)4L, (long)TitanAssert.size(result));
        }
        Map results2 = this.tx.multiQuery((TitanVertex[])qvs).properties();
        for (Iterable result : results2.values()) {
            Assert.assertEquals((long)1L, (long)TitanAssert.size(result));
        }
        results2 = this.tx.multiQuery((TitanVertex[])qvs).keys(new String[]{"name"}).properties();
        for (Iterable result : results2.values()) {
            Assert.assertEquals((long)1L, (long)TitanAssert.size(result));
        }
        this.clopen(new Object[0]);
        for (int i5 = 1; i5 < noVertices; ++i5) {
            vs[i5] = TitanGraphTest.getV((TitanGraphTransaction)this.tx, vs[i5].longId());
        }
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v.longId());
        u = TitanGraphTest.getV((TitanGraphTransaction)this.tx, u.longId());
        qvs = new TitanVertex[]{vs[6], vs[9], vs[12], vs[15], vs[60]};
        Assert.assertEquals((long)10L, (long)TitanAssert.size(v.query().labels(new String[]{"connect"}).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)TitanAssert.size(u.query().labels(new String[]{"connectDesc"}).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)TitanAssert.size(v.query().labels(new String[]{"connect"}).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)TitanAssert.size(u.query().labels(new String[]{"connectDesc"}).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        lastTime = 0;
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges()) {
            nowTime3 = (Integer)e.value("time");
            Assert.assertTrue((String)(lastTime + " vs. " + nowTime3), (lastTime <= nowTime3 ? 1 : 0) != 0);
            lastTime = nowTime3;
        }
        lastTime = Integer.MAX_VALUE;
        for (Edge e : u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).limit(20).edges()) {
            nowTime3 = (Integer)e.value("time");
            Assert.assertTrue((String)(lastTime + " vs. " + nowTime3), (lastTime >= nowTime3 ? 1 : 0) != 0);
            lastTime = nowTime3;
        }
        Assert.assertEquals((long)10L, (long)TitanAssert.size(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)TitanAssert.size(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        outer = v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges().iterator();
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(10).edges()) {
            Assert.assertEquals((Object)e, outer.next());
        }
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Object)15).has("weight", (Object)3.5), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        Assert.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assert.assertEquals((long)10L, (long)u.query().labels(new String[]{"connectDesc"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", null).edgeCount());
        Assert.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds().size());
        Assert.assertEquals((long)(edgesPerLabel - 10), (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)31).count());
        Assert.assertEquals((long)10L, (long)TitanAssert.size(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertices()));
        Assert.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).limit(3).count());
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).limit(3), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5)), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5, (Object)2.5)).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)), RelationCategory.EDGE, 7, 3, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5)), RelationCategory.EDGE, 1667, 2, new boolean[]{true, true});
        Assert.assertEquals((long)3L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assert.assertEquals((long)1L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assert.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assert.assertEquals((long)4L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.LESS_THAN_EQUAL, (Object)10).edgeCount());
        Assert.assertEquals((long)(edgesPerLabel - 4), (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)10).edgeCount());
        Assert.assertEquals((long)20L, (long)v.query().labels(new String[]{"friend", "connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).edgeCount());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)).edgeCount());
        Assert.assertEquals((long)((int)Math.floor((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(2.1), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assert.assertEquals((long)20L, (long)TitanAssert.size(v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertices()));
        Assert.assertEquals((long)20L, (long)TitanAssert.size(v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertexIds()));
        Assert.assertEquals((long)30L, (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assert.assertEquals((long)(noVertices - 2), (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assert.assertEquals((long)0L, (long)v.query().has("age", null).labels(new String[]{"undefined"}).direction(Direction.OUT).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.IN).adjacent((Vertex)vs[11]).edgeCount());
        Assert.assertEquals((long)2L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).has("weight", (Object)3.5).edgeCount());
        Assert.assertEquals((long)2L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[8]).has("time", (Object)8).edgeCount());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).edgeCount());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).edgeCount());
        Assert.assertEquals((long)(2 * edgesPerLabel), (long)v.query().labels(new String[]{"connect"}).direction(Direction.BOTH).edgeCount());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).has("undefined", null).direction(Direction.OUT).edgeCount());
        Assert.assertEquals((long)(2 * (int)Math.ceil((double)(noVertices - 1) / 4.0)), (long)TitanAssert.size(v.query().labels(new String[]{"connect", "friend", "knows"}).has("weight", (Object)1.5).vertexIds()));
        Assert.assertEquals((long)1L, (long)v.query().direction(Direction.IN).has("time", (Object)1).edgeCount());
        Assert.assertEquals((long)10L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).edgeCount());
        Assert.assertEquals((long)9L, (long)v.query().direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (TitanPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assert.assertEquals((long)9L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (TitanPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assert.assertEquals((long)(noVertices - 1), (long)TitanAssert.size(v.query().direction(Direction.OUT).vertices()));
        Assert.assertEquals((long)(noVertices - 1), (long)TitanAssert.size(v.query().direction(Direction.IN).vertices()));
        for (Direction dir : new Direction[]{Direction.IN, Direction.OUT}) {
            vl = v.query().labels(new String[0]).direction(dir).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds();
            vl.sort();
            for (i = 0; i < vl.size(); ++i) {
                Assert.assertEquals((long)vidsubset[i], (long)vl.getID(i));
            }
        }
        TitanAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assert.assertEquals((long)1L, (long)TitanAssert.size(v.query().properties()));
        Assert.assertEquals((long)1L, (long)TitanAssert.size(v.query().keys(new String[]{"name"}).properties()));
        results = this.tx.multiQuery((TitanVertex[])qvs).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)1L, (long)TitanAssert.size(result));
        }
        results = this.tx.multiQuery((Collection)Sets.newHashSet((Object[])qvs)).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)2L, (long)TitanAssert.size(result));
        }
        results = this.tx.multiQuery((TitanVertex[])qvs).labels(new String[]{"knows"}).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)0L, (long)TitanAssert.size(result));
        }
        results = this.tx.multiQuery((TitanVertex[])qvs).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)4L, (long)TitanAssert.size(result));
        }
        results2 = this.tx.multiQuery((TitanVertex[])qvs).properties();
        for (Iterable result : results2.values()) {
            Assert.assertEquals((long)1L, (long)TitanAssert.size(result));
        }
        results2 = this.tx.multiQuery((TitanVertex[])qvs).keys(new String[]{"name"}).properties();
        for (Iterable result : results2.values()) {
            Assert.assertEquals((long)1L, (long)TitanAssert.size(result));
        }
        this.newTx();
        v = (TitanVertex)TitanGraphTest.getOnlyElement(this.tx.query().has("name", (Object)"v").vertices());
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).limit(2).vertexIds().size());
        Assert.assertEquals((long)10L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).vertexIds().size());
        this.newTx();
        v = (TitanVertex)TitanGraphTest.getOnlyElement(this.tx.query().has("name", (Object)"v").vertices());
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).limit(2).edgeCount());
        Assert.assertEquals((long)10L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).edgeCount());
        this.newTx();
        TitanVertex[] qvs2 = new TitanVertex[qvs.length + 2];
        qvs2[0] = this.tx.addVertex(new Object[0]);
        for (int i6 = 0; i6 < qvs.length; ++i6) {
            qvs2[i6 + 1] = TitanGraphTest.getV((TitanGraphTransaction)this.tx, qvs[i6].longId());
        }
        qvs2[qvs2.length - 1] = this.tx.addVertex(new Object[0]);
        qvs2[0].addEdge("connect", (Vertex)qvs2[qvs2.length - 1], new Object[0]);
        qvs2[qvs2.length - 1].addEdge("connect", (Vertex)qvs2[0], new Object[0]);
        results = this.tx.multiQuery(qvs2).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)1L, (long)TitanAssert.size(result));
        }
    }

    @Test
    public void testRelationTypeIndexes() {
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.LIST).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{time}).make();
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        EdgeLabel link = this.mgmt.makeEdgeLabel("link").unidirected().make();
        RelationTypeIndex name1 = this.mgmt.buildPropertyIndex(name, "weightDesc", new PropertyKey[]{weight});
        RelationTypeIndex connect1 = this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.incr, new PropertyKey[]{weight});
        RelationTypeIndex connect2 = this.mgmt.buildEdgeIndex(connect, "weightDesc", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.decr, new PropertyKey[]{weight});
        RelationTypeIndex connect3 = this.mgmt.buildEdgeIndex(connect, "time+weight", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.decr, new PropertyKey[]{time, weight});
        RelationTypeIndex child1 = this.mgmt.buildEdgeIndex(child, "time", Direction.OUT, new PropertyKey[]{time});
        RelationTypeIndex link1 = this.mgmt.buildEdgeIndex(link, "time", Direction.OUT, new PropertyKey[]{time});
        String name1n = name1.name();
        String connect1n = connect1.name();
        String connect2n = connect2.name();
        String connect3n = connect3.name();
        String child1n = child1.name();
        String link1n = link1.name();
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)name, "weightDesc"));
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)connect, "weightDesc"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)child, "weightDesc"));
        Assert.assertEquals((Object)"time+weight", (Object)this.mgmt.getRelationIndex((RelationType)connect, "time+weight").name());
        Assert.assertNotNull((Object)this.mgmt.getRelationIndex((RelationType)link, "time"));
        Assert.assertNull((Object)this.mgmt.getRelationIndex((RelationType)name, "time"));
        Assert.assertEquals((long)1L, (long)TitanAssert.size(this.mgmt.getRelationIndexes((RelationType)child)));
        Assert.assertEquals((long)3L, (long)TitanAssert.size(this.mgmt.getRelationIndexes((RelationType)connect)));
        Assert.assertEquals((long)0L, (long)TitanAssert.size(this.mgmt.getRelationIndexes((RelationType)weight)));
        try {
            this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.OUT, new PropertyKey[]{time});
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(child, "blablub", Direction.IN, new PropertyKey[]{time});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(link, "blablub", Direction.BOTH, new PropertyKey[]{time});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        weight = this.mgmt.getPropertyKey("weight");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        connect = this.mgmt.getEdgeLabel("connect");
        child = this.mgmt.getEdgeLabel("child");
        link = this.mgmt.getEdgeLabel("link");
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)name, "weightDesc"));
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)connect, "weightDesc"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)child, "weightDesc"));
        Assert.assertEquals((Object)"time+weight", (Object)this.mgmt.getRelationIndex((RelationType)connect, "time+weight").name());
        Assert.assertNotNull((Object)this.mgmt.getRelationIndex((RelationType)link, "time"));
        Assert.assertNull((Object)this.mgmt.getRelationIndex((RelationType)name, "time"));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)child)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)connect)));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)weight)));
        try {
            this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.OUT, new PropertyKey[]{time});
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(child, "blablub", Direction.IN, new PropertyKey[]{time});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(link, "blablub", Direction.BOTH, new PropertyKey[]{time});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.rollback();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        int numV = 100;
        TitanVertex v = this.tx.addVertex(new Object[0]);
        TitanVertex[] ns = new TitanVertex[100];
        for (int i = 0; i < 100; ++i) {
            double w = (double)i * 0.5 % 5.0;
            long t = (i + 77) % 100;
            TitanVertexProperty p = v.property("name", (Object)("v" + i), new Object[]{"weight", w, "time", t});
            ns[i] = this.tx.addVertex(new Object[0]);
            for (String label : new String[]{"connect", "child", "link"}) {
                TitanEdge titanEdge = v.addEdge(label, (Vertex)ns[i], new Object[]{"weight", w, "time", t});
            }
        }
        TitanVertex u = ns[0];
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        u = TitanGraphTest.getV((TitanGraphTransaction)this.tx, u);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (TitanPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (TitanPredicate)Cmp.LESS_THAN, (Object)0.9).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), RelationCategory.PROPERTY, 20, 1, new boolean[]{true, true}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("weight", (Comparable)Double.valueOf(1.1), (Comparable)Double.valueOf(2.2)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 1, 1, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}), RelationCategory.PROPERTY, 100, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 2, new boolean[0]);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 20, 2, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH), RelationCategory.EDGE, 100, 1, new boolean[]{true, true});
        VertexList vl = v.query().labels(new String[]{"child"}).direction(Direction.BOTH).vertexIds();
        Assert.assertEquals((long)100L, (long)vl.size());
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        vl = v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT).vertexIds();
        Assert.assertEquals((long)20L, (long)vl.size());
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, time, Order.ASC);
        vl = v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).vertexIds();
        Assert.assertEquals((long)10L, (long)vl.size());
        Assert.assertFalse((boolean)vl.isSorted());
        Assert.assertFalse((boolean)this.isSortedByID(vl));
        vl.sort();
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.BOTH), RelationCategory.EDGE, 1, 2, new boolean[0]);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 10, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(2.75)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 30, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 1, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), RelationCategory.EDGE, 1, 1, new boolean[]{true, false}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0.0).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        u = TitanGraphTest.getV((TitanGraphTransaction)this.tx, u);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (TitanPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (TitanPredicate)Cmp.LESS_THAN, (Object)0.9).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), RelationCategory.PROPERTY, 20, 1, new boolean[]{true, true}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("weight", (Comparable)Double.valueOf(1.1), (Comparable)Double.valueOf(2.2)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 1, 1, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}), RelationCategory.PROPERTY, 100, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 2, new boolean[0]);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 20, 2, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH), RelationCategory.EDGE, 100, 1, new boolean[]{true, true});
        vl = v.query().labels(new String[]{"child"}).direction(Direction.BOTH).vertexIds();
        Assert.assertEquals((long)100L, (long)vl.size());
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        vl = v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT).vertexIds();
        Assert.assertEquals((long)20L, (long)vl.size());
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, time, Order.ASC);
        vl = v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).vertexIds();
        Assert.assertEquals((long)10L, (long)vl.size());
        Assert.assertFalse((boolean)vl.isSorted());
        Assert.assertFalse((boolean)this.isSortedByID(vl));
        vl.sort();
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.BOTH), RelationCategory.EDGE, 1, 2, new boolean[0]);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 10, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(2.75)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 30, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.EDGE, 1, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.incr), RelationCategory.EDGE, 1, 1, new boolean[]{true, false}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0.0).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        for (TitanVertexProperty p : v.query().labels(new String[]{"name"}).properties()) {
            if ((Long)p.value("time") >= 50L) continue;
            p.remove();
        }
        for (TitanEdge e : v.query().direction(Direction.BOTH).edges()) {
            if ((Long)e.value("time") >= 50L) continue;
            e.remove();
        }
        ns = new TitanVertex[150];
        for (int i = 100; i < 150; ++i) {
            double w = (double)i * 0.5 % 5.0;
            long t = i;
            v.property("name", (Object)("v" + i), new Object[]{"weight", w, "time", t});
            ns[i] = this.tx.addVertex(new Object[0]);
            for (String label : new String[]{"connect", "child", "link"}) {
                TitanEdge titanEdge = v.addEdge(label, (Vertex)ns[i], new Object[]{"weight", w, "time", t});
            }
        }
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (TitanPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(110)).limit(5), RelationCategory.PROPERTY, 5, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 0, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)105), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(5), RelationCategory.EDGE, 0, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(110), (Comparable)Integer.valueOf(120)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        this.newTx();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, v);
        u = TitanGraphTest.getV((TitanGraphTransaction)this.tx, u);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (TitanPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(110)).limit(5), RelationCategory.PROPERTY, 5, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 0, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (TitanPredicate)Cmp.EQUAL, (Object)105), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(5), RelationCategory.EDGE, 0, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(110), (Comparable)Integer.valueOf(120)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
    }

    private boolean isSortedByID(VertexList vl) {
        for (int i = 1; i < vl.size(); ++i) {
            if (vl.getID(i - 1) <= vl.getID(i)) continue;
            return false;
        }
        return true;
    }

    public static void evaluateQuery(TitanVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, numSubQueries, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of());
    }

    public static void evaluateQuery(TitanVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs, PropertyKey orderKey, Order order) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, numSubQueries, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey, (Object)order));
    }

    public static void evaluateQuery(TitanVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs, Map<PropertyKey, Order> orderMap) {
        Iterable result;
        SimpleQueryProfiler profiler = new SimpleQueryProfiler();
        ((BasicVertexCentricQueryBuilder)query).profiler((QueryProfiler)profiler);
        switch (resultType) {
            case PROPERTY: {
                result = query.properties();
                break;
            }
            case EDGE: {
                result = query.edges();
                break;
            }
            case RELATION: {
                result = query.relations();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        OrderList orders = (OrderList)profiler.getAnnotation("orders");
        int no = 0;
        TitanElement previous = null;
        for (TitanElement e : result) {
            Assert.assertNotNull((Object)e);
            ++no;
            if (previous != null && !orders.isEmpty()) {
                Assert.assertTrue((orders.compare(previous, e) <= 0 ? 1 : 0) != 0);
            }
            previous = e;
        }
        Assert.assertEquals((long)expectedResults, (long)no);
        Assert.assertNotNull((Object)orders);
        Assert.assertEquals((long)orderMap.size(), (long)orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            Assert.assertEquals((Object)orderMap.get(orders.getKey(i)), (Object)orders.getOrder(i));
        }
        for (PropertyKey key : orderMap.keySet()) {
            Assert.assertTrue((boolean)orders.containsKey(key));
        }
        Assert.assertEquals((Object)1, (Object)((Number)profiler.getAnnotation("vertices")));
        int subQueryCounter = 0;
        for (SimpleQueryProfiler subProfiler : profiler) {
            Assert.assertNotNull((Object)subProfiler);
            if (subProfiler.getGroupName().equals("optimization")) continue;
            if (subQuerySpecs.length == 2) {
                Assert.assertEquals((Object)subQuerySpecs[0], (Object)((Boolean)subProfiler.getAnnotation("isFitted")));
                Assert.assertEquals((Object)subQuerySpecs[1], (Object)((Boolean)subProfiler.getAnnotation("isOrdered")));
            }
            ++subQueryCounter;
        }
        Assert.assertEquals((long)numSubQueries, (long)subQueryCounter);
    }

    @Test
    public void testEdgesExceedCacheSize() {
        int numEdges = this.graph.getConfiguration().getTxVertexCacheSize();
        TitanVertex parentVertex = this.graph.addVertex(new Object[0]);
        for (int i = 0; i < numEdges; ++i) {
            TitanVertex childVertex = this.graph.addVertex(new Object[0]);
            parentVertex.addEdge("friend", (Vertex)childVertex, new Object[0]);
        }
        this.graph.tx().commit();
        TitanAssert.assertCount(numEdges, parentVertex.query().direction(Direction.OUT).edges());
        ((TitanEdge)parentVertex.query().direction(Direction.OUT).edges().iterator().next()).remove();
        TitanAssert.assertCount(numEdges - 1, parentVertex.query().direction(Direction.OUT).edges());
        TitanAssert.assertCount(numEdges - 1, parentVertex.query().direction(Direction.OUT).edges());
    }

    @Test
    public void testTinkerPopCardinality() {
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").cardinality(Cardinality.SINGLE).dataType(String.class).make();
        PropertyKey names = this.mgmt.makePropertyKey("names").cardinality(Cardinality.LIST).dataType(String.class).make();
        this.mgmt.buildIndex("byId", Vertex.class).addKey(id).buildCompositeIndex();
        this.finishSchema();
        TitanVertex v = this.graph.addVertex(new Object[]{"id", 1});
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t1", new Object[0]);
        this.graph.addVertex(new Object[]{"id", 2, "names", "n1", "names", "n2"});
        this.graph.tx().commit();
        GraphTraversalSource gts = this.graph.traversal();
        v = (Vertex)gts.V(new Object[0]).has("id", (Object)1).next();
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t2", new Object[0]);
        v = (Vertex)gts.V(new Object[0]).has("id", (Object)1).next();
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t3", new Object[0]);
        TitanAssert.assertCount(1L, gts.V(new Object[]{v}).properties(new String[]{"name"}));
        TitanAssert.assertCount(2L, gts.V(new Object[0]).has("id", (Object)2).properties(new String[]{"names"}));
        TitanAssert.assertCount(2L, gts.V(new Object[0]).hasLabel(new String[]{"vertex"}));
    }

    @Test
    public void testTinkerPopOptimizationStrategies() {
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        PropertyKey weight = this.mgmt.makePropertyKey("weight").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.buildIndex("byId", Vertex.class).addKey(id).buildCompositeIndex();
        this.mgmt.buildIndex("byWeight", Vertex.class).addKey(weight).buildCompositeIndex();
        this.mgmt.buildIndex("byIdWeight", Vertex.class).addKey(id).addKey(weight).buildCompositeIndex();
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.buildEdgeIndex(knows, "byWeightDecr", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.decr, new PropertyKey[]{weight});
        this.mgmt.buildEdgeIndex(knows, "byWeightIncr", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.incr, new PropertyKey[]{weight});
        PropertyKey names = this.mgmt.makePropertyKey("names").cardinality(Cardinality.LIST).dataType(String.class).make();
        this.mgmt.buildPropertyIndex(names, "namesByWeight", org.apache.tinkerpop.gremlin.process.traversal.Order.decr, new PropertyKey[]{weight});
        this.finishSchema();
        int numV = 100;
        TitanVertex[] vs = new TitanVertex[numV];
        for (int i = 0; i < numV; ++i) {
            vs[i] = this.graph.addVertex(new Object[]{"id", i, "weight", i % 5});
        }
        int superV = 10;
        int sid = -1;
        TitanVertex[] sv = new TitanVertex[superV];
        for (int i = 0; i < superV; ++i) {
            sv[i] = this.graph.addVertex(new Object[]{"id", sid});
            for (int j = 0; j < numV; ++j) {
                sv[i].addEdge("knows", (Vertex)vs[j], new Object[]{"weight", j % 5});
                sv[i].property(VertexProperty.Cardinality.list, "names", (Object)("n" + j), new Object[]{"weight", j % 5});
            }
        }
        GraphTraversalSource gts = this.graph.traversal();
        TitanGraphTest.assertNumStep(numV / 5, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).has("weight", (Object)1), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(numV, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(numV, 1, gts.V(new Object[]{sv[0]}).out(new String[]{"knows"}), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(10, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).limit(10L)), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(10, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).range(10L, 20L)), LocalStep.class);
        TitanGraphTest.assertNumStep(numV, 2, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.decr), TitanVertexStep.class, OrderGlobalStep.class);
        TitanGraphTest.assertNumStep(10, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10L)), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(numV / 5, 2, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).has("weight", (Object)1).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.incr), TitanVertexStep.class, OrderGlobalStep.class);
        TitanGraphTest.assertNumStep(10, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", (Object)1).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(10L)), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(5, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", (Object)1).has("weight", (Object)1).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.incr).range(10L, 15L)), LocalStep.class);
        TitanGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).filter((Traversal)__.inV().is((Object)vs[50])), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).filter((Traversal)__.otherV().is((Object)vs[50])), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(1, 1, gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).filter((Traversal)__.otherV().is((Object)vs[50])), TitanVertexStep.class);
        TitanGraphTest.assertNumStep(1, 2, gts.V(new Object[]{sv[0]}).bothE(new String[]{"knows"}).filter((Traversal)__.inV().is((Object)vs[50])), TitanVertexStep.class, TraversalFilterStep.class);
        TitanGraphTest.assertNumStep(numV / 5, 1, gts.V(new Object[]{sv[0]}).properties(new String[]{"names"}).has("weight", (Object)1), TitanPropertiesStep.class);
        TitanGraphTest.assertNumStep(numV, 1, gts.V(new Object[]{sv[0]}).properties(new String[]{"names"}), TitanPropertiesStep.class);
        TitanGraphTest.assertNumStep(10, 1, gts.V(new Object[]{sv[0]}).local((Traversal)__.properties((String[])new String[]{"names"}).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10L)), TitanPropertiesStep.class);
        TitanGraphTest.assertNumStep(numV, 2, gts.V(new Object[]{sv[0]}).outE(new String[]{"knows"}).values(new String[]{"weight"}), TitanVertexStep.class, TitanPropertiesStep.class);
        TitanGraphTest.assertNumStep(1, 1, gts.V(new Object[0]).has("id", (Object)(numV / 5)), TitanGraphStep.class);
        TitanGraphTest.assertNumStep(1, 1, gts.V(new Object[0]).has("id", (Object)(numV / 5)).has("weight", (Object)(numV / 5 % 5)), TitanGraphStep.class);
        TitanGraphTest.assertNumStep(numV / 5, 1, gts.V(new Object[0]).has("weight", (Object)1), TitanGraphStep.class);
        TitanGraphTest.assertNumStep(10, 1, gts.V(new Object[0]).has("weight", (Object)1).range(0L, 10L), TitanGraphStep.class);
        TitanGraphTest.assertNumStep(superV, 1, gts.V(new Object[0]).has("id", (Object)sid), TitanGraphStep.class);
        TitanGraphTest.assertNumStep(1, 1, gts.V(new Object[0]).has("id", (Object)(numV / 5)).as("x", new String[0]), TitanGraphStep.class);
        TitanGraphTest.assertNumStep(1, 1, gts.V(new Object[0]).has("id", (Object)(numV / 5)).has("weight", (Object)(numV / 5 % 5)).as("x", new String[0]), TitanGraphStep.class);
        TitanGraphTest.assertNumStep(superV * (numV / 5), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", (Object)1), TitanGraphStep.class, TitanVertexStep.class);
        TitanGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)), TitanGraphStep.class, TitanVertexStep.class);
        TitanGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)), TitanGraphStep.class, TitanVertexStep.class);
        TitanGraphTest.assertNumStep(superV * 10, 2, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)).limit(10L)), TitanGraphStep.class, TitanVertexStep.class);
        TitanGraphTest.assertNumStep(superV * 10, 2, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10L)), TitanGraphStep.class, TitanVertexStep.class);
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true);
        gts = this.graph.traversal();
        TitanGraphTest.assertNumStep(superV * (numV / 5), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", (Object)1), TitanGraphStep.class, TitanVertexStep.class);
        TitanGraphTest.assertNumStep(superV * (numV / 5 * 2), 2, gts.V(new Object[0]).has("id", (Object)sid).outE(new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)), TitanGraphStep.class, TitanVertexStep.class);
        TitanGraphTest.assertNumStep(superV * 10, 2, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)).limit(10L)), TitanGraphStep.class, TitanVertexStep.class);
        TitanGraphTest.assertNumStep(superV * 10, 2, gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10L)), TitanGraphStep.class, TitanVertexStep.class);
        TitanGraphTest.assertNumStep(superV * numV, 2, gts.V(new Object[0]).has("id", (Object)sid).values(new String[]{"names"}), TitanGraphStep.class, TitanPropertiesStep.class);
        GraphTraversal t = gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.between((Object)1, (Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10L)).profile();
        TitanAssert.assertCount(superV * 10, t);
        TraversalMetrics metrics = (TraversalMetrics)t.asAdmin().getSideEffects().get("~metrics").get();
        TitanGraphTest.verifyMetrics(metrics.getMetrics(0), true, false);
        TitanGraphTest.verifyMetrics(metrics.getMetrics(1), true, true);
        t = gts.V(new Object[0]).has("id", (Object)sid).values(new String[]{"names"}).profile();
        TitanAssert.assertCount(superV * numV, t);
        metrics = (TraversalMetrics)t.asAdmin().getSideEffects().get("~metrics").get();
        TitanGraphTest.verifyMetrics(metrics.getMetrics(0), true, false);
        TitanGraphTest.verifyMetrics(metrics.getMetrics(1), true, true);
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true);
        gts = this.graph.traversal();
        t = gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(10L)).profile();
        TitanAssert.assertCount(superV * 10, t);
        metrics = (TraversalMetrics)t.asAdmin().getSideEffects().get("~metrics").get();
        TitanGraphTest.verifyMetrics(metrics.getMetrics(0), false, false);
        TitanGraphTest.verifyMetrics(metrics.getMetrics(1), false, true);
        t = gts.V(new Object[0]).has("id", (Object)sid).values(new String[]{"names"}).profile();
        TitanAssert.assertCount(superV * numV, t);
        metrics = (TraversalMetrics)t.asAdmin().getSideEffects().get("~metrics").get();
        TitanGraphTest.verifyMetrics(metrics.getMetrics(0), false, false);
        TitanGraphTest.verifyMetrics(metrics.getMetrics(1), false, true);
    }

    private static void assertNumStep(int expectedResults, int expectedSteps, GraphTraversal traversal, Class<? extends Step> ... expectedStepTypes) {
        int num = 0;
        while (traversal.hasNext()) {
            traversal.next();
            ++num;
        }
        Assert.assertEquals((long)expectedResults, (long)num);
        List steps = traversal.asAdmin().getSteps();
        HashSet expSteps = Sets.newHashSet((Object[])expectedStepTypes);
        int numSteps = 0;
        for (Step s : steps) {
            if (s.getClass().equals(GraphStep.class) || s.getClass().equals(StartStep.class)) continue;
            Assert.assertTrue((String)s.getClass().getName(), (boolean)expSteps.contains(s.getClass()));
            ++numSteps;
        }
        Assert.assertEquals((long)expectedSteps, (long)numSteps);
    }

    private static void verifyMetrics(Metrics metric, boolean fromCache, boolean multiQuery) {
        Assert.assertTrue((metric.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((metric.getCount("elementCount") > 0L ? 1 : 0) != 0);
        String hasMultiQuery = (String)metric.getAnnotation("multi");
        Assert.assertTrue((boolean)(multiQuery ? hasMultiQuery.equalsIgnoreCase("true") : hasMultiQuery == null));
        block8: for (Metrics submetric : metric.getNested()) {
            Assert.assertTrue((submetric.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            switch (submetric.getName()) {
                case "optimization": {
                    Assert.assertNull((Object)submetric.getCount("elementCount"));
                    continue block8;
                }
                case "backend-query": {
                    if (fromCache) {
                        Assert.assertFalse((String)"Should not execute backend-queries when cached", (boolean)true);
                    }
                    Assert.assertTrue((submetric.getCount("elementCount") > 0L ? 1 : 0) != 0);
                    continue block8;
                }
            }
            Assert.assertFalse((String)("Unrecognized nested query: " + submetric.getName()), (boolean)true);
        }
    }

    @Test
    public void testSimpleTinkerPopTraversal() {
        TitanVertex v1 = this.graph.addVertex(new Object[]{"name", "josh"});
        TitanVertex v2 = this.graph.addVertex(new Object[]{"name", "lop"});
        v1.addEdge("created", (Vertex)v2, new Object[0]);
        Object id = ((Edge)this.graph.traversal().V(new Object[0]).has("name", (Object)"josh").outE(new String[]{"created"}).as("e", new String[0]).inV().has("name", (Object)"lop").select("e").next()).id();
        Assert.assertNotNull((Object)id);
    }

    @Test
    public void simpleLogTest() throws InterruptedException {
        this.simpleLogTest(false);
    }

    @Test
    public void simpleLogTestWithFailure() throws InterruptedException {
        this.simpleLogTest(true);
    }

    public void simpleLogTest(final boolean withLogFailure) throws InterruptedException {
        String userlogName = "test";
        final Serializer serializer = this.graph.getDataSerializer();
        EdgeSerializer edgeSerializer = this.graph.getEdgeSerializer();
        final TimestampProvider times = this.graph.getConfiguration().getTimestampProvider();
        final Instant startTime = times.getTime();
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, new String[0]), true, TitanGraphTest.option(GraphDatabaseConfiguration.LOG_BACKEND, "user"), withLogFailure ? TestMockLog.class.getName() : GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue(), TitanGraphTest.option(TestMockLog.LOG_MOCK_FAILADD, "user"), withLogFailure, TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "user"), Duration.ofMillis(50L), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "user"), Duration.ofMillis(250L), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "user"), Duration.ofMillis(100L), TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "tx"), Duration.ofMillis(50L), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "tx"), Duration.ofMillis(250L), TitanGraphTest.option(GraphDatabaseConfiguration.MAX_COMMIT_TIME, new String[0]), Duration.ofSeconds(1L));
        final String instanceid = this.graph.getConfiguration().getUniqueGraphId();
        PropertyKey weight = this.tx.makePropertyKey("weight").dataType(Float.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel knows = this.tx.makeEdgeLabel("knows").make();
        TitanVertex n1 = this.tx.addVertex(new Object[]{"weight", 10.5});
        this.newTx();
        final Instant[] txTimes = new Instant[4];
        txTimes[0] = times.getTime();
        TitanTransaction tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        TitanVertex v1 = tx2.addVertex(new Object[]{"weight", 111.1});
        v1.addEdge("knows", (Vertex)v1, new Object[0]);
        tx2.commit();
        final long v1id = TitanGraphTest.getId((Element)v1);
        txTimes[1] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        TitanVertex v2 = tx2.addVertex(new Object[]{"weight", 222.2});
        v2.addEdge("knows", (Vertex)TitanGraphTest.getV((TitanGraphTransaction)tx2, v1id), new Object[0]);
        tx2.commit();
        final long v2id = TitanGraphTest.getId((Element)v2);
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)tx2, v1id);
        Assert.assertEquals((double)111.1, (double)((Float)v1.value("weight")).doubleValue(), (double)0.01);
        Assert.assertEquals((double)222.2, (double)((Float)TitanGraphTest.getV((TitanGraphTransaction)tx2, v2).value("weight")).doubleValue(), (double)0.01);
        tx2.commit();
        txTimes[2] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v2 = TitanGraphTest.getV((TitanGraphTransaction)tx2, v2id);
        Assert.assertEquals((double)222.2, (double)((Float)v2.value("weight")).doubleValue(), (double)0.01);
        v2.remove();
        tx2.commit();
        txTimes[3] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)tx2, v1id);
        Assert.assertEquals((double)111.1, (double)((Float)v1.value("weight")).doubleValue(), (double)0.01);
        Edge e = (Edge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assert.assertFalse((boolean)e.property("weight").isPresent());
        e.property("weight", (Object)44.4);
        tx2.commit();
        this.close();
        final Instant endTime = times.getTime();
        ReadMarker startMarker = ReadMarker.fromTime((Instant)startTime);
        Log txlog = this.openTxLog();
        Log userLog = this.openUserLog("test");
        final EnumMap<LogTxStatus, AtomicInteger> txMsgCounter = new EnumMap<LogTxStatus, AtomicInteger>(LogTxStatus.class);
        for (LogTxStatus status : LogTxStatus.values()) {
            txMsgCounter.put(status, new AtomicInteger(0));
        }
        final AtomicInteger userlogMeta = new AtomicInteger(0);
        txlog.registerReader(startMarker, new MessageReader[]{new MessageReader(){

            public void read(Message message) {
                Instant msgTime = message.getTimestamp();
                Assert.assertTrue((msgTime.isAfter(startTime) || msgTime.equals(startTime) ? 1 : 0) != 0);
                Assert.assertNotNull((Object)message.getSenderId());
                TransactionLogHeader.Entry txEntry = TransactionLogHeader.parse((StaticBuffer)message.getContent(), (Serializer)serializer, (TimestampProvider)times);
                TransactionLogHeader header = txEntry.getHeader();
                Assert.assertTrue((header.getTimestamp().isAfter(startTime) || header.getTimestamp().equals(startTime) ? 1 : 0) != 0);
                Assert.assertTrue((header.getTimestamp().isBefore(msgTime) || header.getTimestamp().equals(msgTime) ? 1 : 0) != 0);
                Assert.assertNotNull((Object)txEntry.getMetadata());
                Assert.assertNull(txEntry.getMetadata().get(LogTxMeta.GROUPNAME));
                LogTxStatus status = txEntry.getStatus();
                if (status == LogTxStatus.PRECOMMIT) {
                    Assert.assertTrue((boolean)txEntry.hasContent());
                    Object logid = txEntry.getMetadata().get(LogTxMeta.LOG_ID);
                    if (logid != null) {
                        Assert.assertTrue((boolean)(logid instanceof String));
                        Assert.assertEquals((Object)"test", logid);
                        userlogMeta.incrementAndGet();
                    }
                } else if (withLogFailure) {
                    Assert.assertTrue((status.isPrimarySuccess() || status == LogTxStatus.SECONDARY_FAILURE ? 1 : 0) != 0);
                    if (status == LogTxStatus.SECONDARY_FAILURE) {
                        TransactionLogHeader.SecondaryFailures secFail = txEntry.getContentAsSecondaryFailures(serializer);
                        Assert.assertTrue((boolean)secFail.failedIndexes.isEmpty());
                        Assert.assertTrue((boolean)secFail.userLogFailure);
                    }
                } else {
                    Assert.assertFalse((boolean)txEntry.hasContent());
                    Assert.assertTrue((boolean)status.isSuccess());
                }
                ((AtomicInteger)txMsgCounter.get(txEntry.getStatus())).incrementAndGet();
            }
        }});
        final EnumMap<Change, AtomicInteger> userChangeCounter = new EnumMap<Change, AtomicInteger>(Change.class);
        for (Change change : Change.values()) {
            userChangeCounter.put(change, new AtomicInteger(0));
        }
        final AtomicInteger userLogMsgCounter = new AtomicInteger(0);
        userLog.registerReader(startMarker, new MessageReader[]{new MessageReader(){

            public void read(Message message) {
                Instant msgTime = message.getTimestamp();
                Assert.assertTrue((msgTime.isAfter(startTime) || msgTime.equals(startTime) ? 1 : 0) != 0);
                Assert.assertNotNull((Object)message.getSenderId());
                StaticBuffer content = message.getContent();
                Assert.assertTrue((content != null && content.length() > 0 ? 1 : 0) != 0);
                TransactionLogHeader.Entry txentry = TransactionLogHeader.parse((StaticBuffer)content, (Serializer)serializer, (TimestampProvider)times);
                Instant txTime = txentry.getHeader().getTimestamp();
                Assert.assertTrue((txTime.isBefore(msgTime) || txTime.equals(msgTime) ? 1 : 0) != 0);
                Assert.assertTrue((txTime.isAfter(startTime) || txTime.equals(msgTime) ? 1 : 0) != 0);
                long txid = txentry.getHeader().getId();
                Assert.assertTrue((txid > 0L ? 1 : 0) != 0);
                for (TransactionLogHeader.Modification modification : txentry.getContentAsModifications(serializer)) {
                    Assert.assertTrue((modification.state == Change.ADDED || modification.state == Change.REMOVED ? 1 : 0) != 0);
                    ((AtomicInteger)userChangeCounter.get(modification.state)).incrementAndGet();
                }
                userLogMsgCounter.incrementAndGet();
            }
        }});
        Thread.sleep(4000L);
        Assert.assertEquals((long)5L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.PRECOMMIT)).get());
        Assert.assertEquals((long)4L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.PRIMARY_SUCCESS)).get());
        Assert.assertEquals((long)1L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.COMPLETE_SUCCESS)).get());
        Assert.assertEquals((long)4L, (long)userlogMeta.get());
        if (withLogFailure) {
            Assert.assertEquals((long)4L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.SECONDARY_FAILURE)).get());
        } else {
            Assert.assertEquals((long)4L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.SECONDARY_SUCCESS)).get());
        }
        if (withLogFailure) {
            Assert.assertEquals((long)0L, (long)userLogMsgCounter.get());
        } else {
            Assert.assertEquals((long)4L, (long)userLogMsgCounter.get());
            Assert.assertEquals((long)7L, (long)((AtomicInteger)userChangeCounter.get(Change.ADDED)).get());
            Assert.assertEquals((long)4L, (long)((AtomicInteger)userChangeCounter.get(Change.REMOVED)).get());
        }
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.VERBOSE_TX_RECOVERY, new String[0]), true);
        TransactionRecovery recovery = TitanFactory.startTransactionRecovery((TitanGraph)this.graph, (Instant)startTime);
        final AtomicInteger userLogCount = new AtomicInteger(0);
        LogProcessorFramework userlogs = TitanFactory.openTransactionLog((TitanGraph)this.graph);
        userlogs.addLogProcessor("test").setStartTime(startTime).setRetryAttempts(1).addProcessor(new ChangeProcessor(){

            public void process(TitanTransaction tx, TransactionId txId, ChangeState changes) {
                TitanVertex v;
                int txNo;
                Assert.assertEquals((Object)instanceid, (Object)txId.getInstanceId());
                Assert.assertTrue((txId.getTransactionId() > 0L && txId.getTransactionId() < 100L ? 1 : 0) != 0);
                Instant txTime = txId.getTransactionTime();
                Assert.assertTrue((String)String.format("tx timestamp %s not between start %s and end time %s", txTime, startTime, endTime), (!(!txTime.isAfter(startTime) && !txTime.equals(startTime) || !txTime.isBefore(endTime) && !txTime.equals(endTime)) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)tx.containsRelationType("knows"));
                Assert.assertTrue((boolean)tx.containsRelationType("weight"));
                EdgeLabel knows = tx.getEdgeLabel("knows");
                PropertyKey weight = tx.getPropertyKey("weight");
                Instant txTimeMicro = txId.getTransactionTime();
                if (txTimeMicro.isBefore(txTimes[1])) {
                    txNo = 1;
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{knows})));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{weight})));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                    v = (TitanVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ADDED));
                    Assert.assertEquals((long)v1id, (long)TitanGraphBaseTest.getId((Element)v));
                    VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.ADDED, new String[]{"weight"}));
                    Assert.assertEquals((double)111.1, (double)((Float)p.value()).doubleValue(), (double)0.01);
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
                } else if (txTimeMicro.isBefore(txTimes[2])) {
                    txNo = 2;
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{knows})));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{weight})));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                    v = (TitanVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ADDED));
                    Assert.assertEquals((long)v2id, (long)TitanGraphBaseTest.getId((Element)v));
                    VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.ADDED, new String[]{"weight"}));
                    Assert.assertEquals((double)222.2, (double)((Float)p.value()).doubleValue(), (double)0.01);
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
                } else if (txTimeMicro.isBefore(txTimes[3])) {
                    txNo = 3;
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{knows})));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{weight})));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                    v = (TitanVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.REMOVED));
                    Assert.assertEquals((long)v2id, (long)TitanGraphBaseTest.getId((Element)v));
                    VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.REMOVED, new String[]{"weight"}));
                    Assert.assertEquals((double)222.2, (double)((Float)p.value()).doubleValue(), (double)0.01);
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.REMOVED, Direction.OUT, new String[0])));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
                } else {
                    txNo = 4;
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{knows})));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                    v = (TitanVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ANY));
                    Assert.assertEquals((long)v1id, (long)TitanGraphBaseTest.getId((Element)v));
                    TitanEdge e = (TitanEdge)Iterables.getOnlyElement((Iterable)changes.getEdges((Vertex)v, Change.REMOVED, Direction.OUT, new String[]{"knows"}));
                    Assert.assertFalse((boolean)e.property("weight").isPresent());
                    Assert.assertEquals((Object)v, (Object)e.vertex(Direction.IN));
                    e = (TitanEdge)Iterables.getOnlyElement((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[]{"knows"}));
                    Assert.assertEquals((double)44.4, (double)((Float)e.value("weight")).doubleValue(), (double)0.01);
                    Assert.assertEquals((Object)v, (Object)e.vertex(Direction.IN));
                }
                TitanVertex v1 = TitanGraphBaseTest.getV((TitanGraphTransaction)tx, v1id);
                Assert.assertNotNull((Object)v1);
                Assert.assertTrue((boolean)v1.isLoaded());
                if (txNo != 2) {
                    TitanGraphBaseTest.assertMissing((TitanGraphTransaction)tx, v2id);
                }
                Assert.assertEquals((double)111.1, (double)((Float)v1.value("weight")).doubleValue(), (double)0.01);
                TitanAssert.assertCount(1L, v1.query().direction(Direction.OUT).edges());
                userLogCount.incrementAndGet();
            }
        }).build();
        Thread.sleep(22000L);
        recovery.shutdown();
        long[] recoveryStats = ((StandardTransactionLogProcessor)recovery).getStatistics();
        if (withLogFailure) {
            Assert.assertEquals((long)1L, (long)recoveryStats[0]);
            Assert.assertEquals((long)4L, (long)recoveryStats[1]);
        } else {
            Assert.assertEquals((long)5L, (long)recoveryStats[0]);
            Assert.assertEquals((long)0L, (long)recoveryStats[1]);
        }
        userlogs.removeLogProcessor("test");
        userlogs.shutdown();
        Assert.assertEquals((long)4L, (long)userLogCount.get());
    }

    @Test
    public void testGlobalGraphIndexingAndQueriesForInternalIndexes() {
        TitanEdge titanEdge;
        TitanVertex u;
        String txt;
        long t;
        double w;
        TitanVertexProperty p2;
        TitanVertexProperty p1;
        int i;
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.LIST).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{weight}).make();
        EdgeLabel related = this.mgmt.makeEdgeLabel("related").signature(new PropertyKey[]{time}).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel organization = this.mgmt.makeVertexLabel("organization").make();
        TitanGraphIndex edge1 = this.mgmt.buildIndex("edge1", Edge.class).addKey(time).addKey(weight).buildCompositeIndex();
        TitanGraphIndex edge2 = this.mgmt.buildIndex("edge2", Edge.class).indexOnly((TitanSchemaType)connect).addKey(text).buildCompositeIndex();
        TitanGraphIndex prop1 = this.mgmt.buildIndex("prop1", TitanVertexProperty.class).addKey(time).buildCompositeIndex();
        TitanGraphIndex prop2 = this.mgmt.buildIndex("prop2", TitanVertexProperty.class).addKey(weight).addKey(text).buildCompositeIndex();
        TitanGraphIndex vertex1 = this.mgmt.buildIndex("vertex1", Vertex.class).addKey(time).indexOnly((TitanSchemaType)person).unique().buildCompositeIndex();
        TitanGraphIndex vertex12 = this.mgmt.buildIndex("vertex12", Vertex.class).addKey(text).indexOnly((TitanSchemaType)person).buildCompositeIndex();
        TitanGraphIndex vertex2 = this.mgmt.buildIndex("vertex2", Vertex.class).addKey(time).addKey(name).indexOnly((TitanSchemaType)organization).buildCompositeIndex();
        TitanGraphIndex vertex3 = this.mgmt.buildIndex("vertex3", Vertex.class).addKey(name).buildCompositeIndex();
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("name"));
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("prop1"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("prop3"));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Edge.class)));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(TitanVertexProperty.class)));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assert.assertNull((Object)this.mgmt.getGraphIndex("balblub"));
        edge1 = this.mgmt.getGraphIndex("edge1");
        edge2 = this.mgmt.getGraphIndex("edge2");
        prop1 = this.mgmt.getGraphIndex("prop1");
        prop2 = this.mgmt.getGraphIndex("prop2");
        vertex1 = this.mgmt.getGraphIndex("vertex1");
        vertex12 = this.mgmt.getGraphIndex("vertex12");
        vertex2 = this.mgmt.getGraphIndex("vertex2");
        vertex3 = this.mgmt.getGraphIndex("vertex3");
        Assert.assertTrue((boolean)vertex1.isUnique());
        Assert.assertFalse((boolean)edge2.isUnique());
        Assert.assertEquals((Object)"prop1", (Object)prop1.name());
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(vertex3.getIndexedElement()));
        Assert.assertTrue((boolean)TitanVertexProperty.class.isAssignableFrom(prop1.getIndexedElement()));
        Assert.assertTrue((boolean)Edge.class.isAssignableFrom(edge2.getIndexedElement()));
        Assert.assertEquals((long)2L, (long)vertex2.getFieldKeys().length);
        Assert.assertEquals((long)1L, (long)vertex1.getFieldKeys().length);
        try {
            this.mgmt.buildIndex("blablub", Vertex.class).addKey(text, new Parameter[]{Mapping.TEXT.asParameter()}).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edge1", Vertex.class).addKey(weight).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("jupdup", Vertex.class).addKey((PropertyKey)ImplicitKey.ID).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edgexyz", Edge.class).addKey(time).unique().buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        text = this.mgmt.getPropertyKey("text");
        time = this.mgmt.getPropertyKey("time");
        weight = this.mgmt.getPropertyKey("weight");
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("name"));
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("prop1"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("prop3"));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Edge.class)));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(TitanVertexProperty.class)));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assert.assertNull((Object)this.mgmt.getGraphIndex("balblub"));
        edge1 = this.mgmt.getGraphIndex("edge1");
        edge2 = this.mgmt.getGraphIndex("edge2");
        prop1 = this.mgmt.getGraphIndex("prop1");
        prop2 = this.mgmt.getGraphIndex("prop2");
        vertex1 = this.mgmt.getGraphIndex("vertex1");
        vertex12 = this.mgmt.getGraphIndex("vertex12");
        vertex2 = this.mgmt.getGraphIndex("vertex2");
        vertex3 = this.mgmt.getGraphIndex("vertex3");
        Assert.assertTrue((boolean)vertex1.isUnique());
        Assert.assertFalse((boolean)edge2.isUnique());
        Assert.assertEquals((Object)"prop1", (Object)prop1.name());
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(vertex3.getIndexedElement()));
        Assert.assertTrue((boolean)TitanVertexProperty.class.isAssignableFrom(prop1.getIndexedElement()));
        Assert.assertTrue((boolean)Edge.class.isAssignableFrom(edge2.getIndexedElement()));
        Assert.assertEquals((long)2L, (long)vertex2.getFieldKeys().length);
        Assert.assertEquals((long)1L, (long)vertex1.getFieldKeys().length);
        try {
            this.mgmt.buildIndex("blablub", Vertex.class).addKey(text, new Parameter[]{Mapping.TEXT.asParameter()}).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edge1", Vertex.class).addKey(weight).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("jupdup", Vertex.class).addKey((PropertyKey)ImplicitKey.ID).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edgexyz", Edge.class).addKey(time).unique().buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int numV = 100;
        boolean sorted = true;
        TitanVertex[] ns = new TitanVertex[100];
        String[] strs = new String[]{"aaa", "bbb", "ccc", "ddd"};
        for (i = 0; i < 100; ++i) {
            ns[i] = this.tx.addVertex(i % 2 == 0 ? "person" : "organization");
            p1 = ns[i].property("name", (Object)("v" + i));
            p2 = ns[i].property("name", (Object)("u" + i % 5));
            w = (double)i * 0.5 % 5.0;
            t = i;
            txt = strs[i % strs.length];
            ns[i].property(VertexProperty.Cardinality.single, "weight", (Object)w, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "time", (Object)t, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "text", (Object)txt, new Object[0]);
            for (VertexProperty p : new VertexProperty[]{p1, p2}) {
                p.property("weight", (Object)w);
                p.property("time", (Object)t);
                p.property("text", (Object)txt);
            }
            u = ns[i > 0 ? i - 1 : i];
            String[] stringArray = new String[]{"connect", "related"};
            int n = stringArray.length;
            for (int p = 0; p < n; ++p) {
                String label = stringArray[p];
                Object[] objectArray = new Object[6];
                objectArray[0] = "weight";
                double d = w;
                w = d + 1.0;
                objectArray[1] = d % 5.0;
                objectArray[2] = "time";
                objectArray[3] = t;
                objectArray[4] = "text";
                objectArray[5] = txt;
                titanEdge = ns[i].addEdge(label, (Vertex)u, objectArray);
            }
        }
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)10).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)10, (Object)20, (Object)30)).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 3, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)10).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0).has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[10 % strs.length]), ElementCategory.EDGE, 1, new boolean[]{false, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)10).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)20).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)20).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)3), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(LABEL_NAME, (Object)"connect"), ElementCategory.EDGE, 100 / strs.length, new boolean[]{true, true}, edge2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.EDGE, 100 / strs.length * 2, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)50), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0.0).has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.PROPERTY, 10, new boolean[]{true, true}, prop2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0.0).has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("time", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop2.name(), prop1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.PROPERTY, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)50).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, vertex12.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex12.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(LABEL_NAME, (Object)"person").has("time", (TitanPredicate)Cmp.EQUAL, (Object)2), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex12.name(), vertex1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)51).has("name", (TitanPredicate)Cmp.EQUAL, (Object)"v51").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)51).has("name", (TitanPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)51, (Object)61, (Object)71, (Object)31, (Object)41)).has("name", (TitanPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, vertex2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Contain.IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 0, new boolean[]{true, false}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(LABEL_NAME, (Object)"person").has("time", (TitanPredicate)Contain.NOT_IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, vertex12.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)51).has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"v1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, vertex3.name());
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)10).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)10, (Object)20, (Object)30)).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 3, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)10).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0).has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[10 % strs.length]), ElementCategory.EDGE, 1, new boolean[]{false, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)10).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)20).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)20).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)3), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(LABEL_NAME, (Object)"connect"), ElementCategory.EDGE, 100 / strs.length, new boolean[]{true, true}, edge2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.EDGE, 100 / strs.length * 2, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)50), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0.0).has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.PROPERTY, 10, new boolean[]{true, true}, prop2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0.0).has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("time", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop2.name(), prop1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.PROPERTY, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)50).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, vertex12.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex12.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(LABEL_NAME, (Object)"person").has("time", (TitanPredicate)Cmp.EQUAL, (Object)2), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex12.name(), vertex1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)51).has("name", (TitanPredicate)Cmp.EQUAL, (Object)"v51").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)51).has("name", (TitanPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)51, (Object)61, (Object)71, (Object)31, (Object)41)).has("name", (TitanPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, vertex2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)51).has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"v1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, vertex3.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Contain.IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 0, new boolean[]{true, false}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(LABEL_NAME, (Object)"person").has("time", (TitanPredicate)Contain.NOT_IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, vertex12.name());
        for (i = 0; i < 50; ++i) {
            TitanVertex v = TitanGraphTest.getV((TitanGraphTransaction)this.tx, ns[i]);
            v.remove();
        }
        ns = new TitanVertex[150];
        for (i = 100; i < 150; ++i) {
            ns[i] = this.tx.addVertex(i % 2 == 0 ? "person" : "organization");
            p1 = ns[i].property("name", (Object)("v" + i));
            p2 = ns[i].property("name", (Object)("u" + i % 5));
            w = (double)i * 0.5 % 5.0;
            t = i;
            txt = strs[i % strs.length];
            ns[i].property(VertexProperty.Cardinality.single, "weight", (Object)w, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "time", (Object)t, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "text", (Object)txt, new Object[0]);
            for (VertexProperty p : new TitanVertex[]{p1, p2}) {
                p.property("weight", (Object)w);
                p.property("time", (Object)t);
                p.property("text", (Object)txt);
            }
            u = ns[i > 100 ? i - 1 : i];
            for (String label : new String[]{"connect", "related"}) {
                Object[] objectArray = new Object[6];
                objectArray[0] = "weight";
                double d = w;
                w = d + 1.0;
                objectArray[1] = d % 5.0;
                objectArray[2] = "time";
                objectArray[3] = t;
                objectArray[4] = "text";
                objectArray[5] = txt;
                titanEdge = ns[i].addEdge(label, (Vertex)u, objectArray);
            }
        }
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)10).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)110).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)20), ElementCategory.PROPERTY, 0, new boolean[]{true, true}, prop1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)120), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)30).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)130).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        this.newTx();
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)10).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)110).has("weight", (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("weight", (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)20), ElementCategory.PROPERTY, 0, new boolean[]{true, true}, prop1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)120), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)30).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (TitanPredicate)Cmp.EQUAL, (Object)130).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (TitanPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
    }

    @Test
    public void testIndexUniqueness() {
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("organization").make();
        TitanGraphIndex vindex1 = this.mgmt.buildIndex("vindex1", Vertex.class).addKey(time).indexOnly((TitanSchemaType)person).unique().buildCompositeIndex();
        TitanGraphIndex vindex2 = this.mgmt.buildIndex("vindex2", Vertex.class).addKey(time).addKey(text).unique().buildCompositeIndex();
        this.finishSchema();
        this.failTransactionOnCommit(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex v0 = tx.addVertex("person");
                v0.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
                TitanVertex v1 = tx.addVertex("person");
                v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
            }
        });
        TitanVertex v0 = this.tx.addVertex("person");
        v0.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        this.newTx();
        this.failTransactionOnCommit(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex v1 = tx.addVertex("person");
                v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
            }
        });
        TitanVertex v1 = this.tx.addVertex("organization");
        v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        this.newTx();
        this.failTransactionOnCommit(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex v0 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
                TitanVertex v1 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
            }
        });
        v0 = this.tx.addVertex(new Object[]{"time", 2, "text", "hello"});
        this.newTx();
        this.failTransactionOnCommit(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex v1 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
            }
        });
    }

    public static void evaluateQuery(TitanGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, PropertyKey orderKey1, Order order1, String ... intersectingIndexes) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey1, (Object)order1), intersectingIndexes);
    }

    public static void evaluateQuery(TitanGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, PropertyKey orderKey1, Order order1, PropertyKey orderKey2, Order order2, String ... intersectingIndexes) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey1, (Object)order1, (Object)orderKey2, (Object)order2), intersectingIndexes);
    }

    public static void evaluateQuery(TitanGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, String ... intersectingIndexes) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of(), intersectingIndexes);
    }

    public static void evaluateQuery(TitanGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, Map<PropertyKey, Order> orderMap, String ... intersectingIndexes) {
        Iterable result;
        if (intersectingIndexes == null) {
            intersectingIndexes = new String[]{};
        }
        SimpleQueryProfiler profiler = new SimpleQueryProfiler();
        ((GraphCentricQueryBuilder)query).profiler((QueryProfiler)profiler);
        switch (resultType) {
            case PROPERTY: {
                result = query.properties();
                break;
            }
            case EDGE: {
                result = query.edges();
                break;
            }
            case VERTEX: {
                result = query.vertices();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        OrderList orders = (OrderList)profiler.getAnnotation("orders");
        int no = 0;
        TitanElement previous = null;
        for (TitanElement e : result) {
            Assert.assertNotNull((Object)e);
            ++no;
            if (previous != null && !orders.isEmpty()) {
                Assert.assertTrue((orders.compare(previous, e) <= 0 ? 1 : 0) != 0);
            }
            previous = e;
        }
        Assert.assertEquals((long)expectedResults, (long)no);
        Assert.assertNotNull((Object)orders);
        Assert.assertEquals((long)orderMap.size(), (long)orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            Assert.assertEquals((Object)orderMap.get(orders.getKey(i)), (Object)orders.getOrder(i));
        }
        for (PropertyKey key : orderMap.keySet()) {
            Assert.assertTrue((boolean)orders.containsKey(key));
        }
        SimpleQueryProfiler subp = (SimpleQueryProfiler)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)profiler, p -> !p.getGroupName().equals("optimization")));
        if (subQuerySpecs.length == 2) {
            Assert.assertEquals((Object)subQuerySpecs[0], (Object)((Boolean)subp.getAnnotation("isFitted")));
            Assert.assertEquals((Object)subQuerySpecs[1], (Object)((Boolean)subp.getAnnotation("isOrdered")));
        }
        HashSet<Object> indexNames = new HashSet<Object>();
        int indexQueries = 0;
        boolean fullscan = false;
        for (SimpleQueryProfiler indexp : subp) {
            if (indexp.getAnnotation("fullscan") != null) {
                fullscan = true;
                continue;
            }
            indexNames.add(indexp.getAnnotation("index"));
            ++indexQueries;
        }
        if (indexQueries > 0) {
            Assert.assertFalse((boolean)fullscan);
        }
        if (fullscan) {
            Assert.assertTrue((intersectingIndexes.length == 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)intersectingIndexes.length, (long)indexQueries);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])intersectingIndexes), indexNames);
    }

    @Test
    public void testForceIndexUsage() {
        PropertyKey age = this.makeKey("age", Integer.class);
        PropertyKey time = this.makeKey("time", Long.class);
        this.mgmt.buildIndex("time", Vertex.class).addKey(time).buildCompositeIndex();
        this.finishSchema();
        for (int i = 1; i <= 10; ++i) {
            TitanVertex titanVertex = this.tx.addVertex(new Object[]{"time", i, "age", i});
        }
        TitanAssert.assertCount(1L, this.tx.query().has("time", (Object)5).vertices());
        TitanAssert.assertCount(1L, this.tx.query().has("age", (Object)6).vertices());
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        TitanAssert.assertCount(1L, this.tx.query().has("time", (Object)5).vertices());
        try {
            TitanAssert.assertCount(1L, this.tx.query().has("age", (Object)6).vertices());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testLargeJointIndexRetrieval() {
        this.makeVertexIndexedKey("sid", Integer.class);
        this.makeVertexIndexedKey("color", String.class);
        this.finishSchema();
        int sids = 17;
        String[] colors = new String[]{"blue", "red", "yellow", "brown", "green", "orange", "purple"};
        int multiplier = 200;
        int numV = sids * colors.length * multiplier;
        for (int i = 0; i < numV; ++i) {
            TitanVertex titanVertex = this.graph.addVertex(new Object[]{"color", colors[i % colors.length], "sid", i % sids});
        }
        this.clopen(new Object[0]);
        TitanAssert.assertCount(numV / sids, this.graph.query().has("sid", (Object)8).vertices());
        TitanAssert.assertCount(numV / colors.length, this.graph.query().has("color", (Object)colors[2]).vertices());
        TitanAssert.assertCount(multiplier, this.graph.query().has("sid", (Object)11).has("color", (Object)colors[3]).vertices());
    }

    @Test
    public void testIndexQueryWithLabelsAndContainsIN() {
        String labelName = "labelName";
        VertexLabel label = this.mgmt.makeVertexLabel(labelName).make();
        PropertyKey uid = this.mgmt.makePropertyKey("uid").dataType(String.class).make();
        TitanGraphIndex uidCompositeIndex = this.mgmt.buildIndex("uidIndex", Vertex.class).indexOnly((TitanSchemaType)label).addKey(uid).unique().buildCompositeIndex();
        this.mgmt.setConsistency((TitanSchemaElement)uidCompositeIndex, ConsistencyModifier.LOCK);
        this.finishSchema();
        TitanVertex foo = this.graph.addVertex(labelName);
        TitanVertex bar = this.graph.addVertex(labelName);
        foo.property("uid", (Object)"foo");
        bar.property("uid", (Object)"bar");
        this.graph.tx().commit();
        Iterable vertexes = this.graph.query().has("uid", (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)"foo", (Object)"bar")).has(LABEL_NAME, (Object)labelName).vertices();
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)vertexes));
        for (TitanVertex v : vertexes) {
            Assert.assertEquals((Object)labelName, (Object)v.vertexLabel().name());
        }
    }

    @Test
    public void testLimitWithMixedIndexCoverage() {
        String vt = "vt";
        String fn = "firstname";
        String user = "user";
        String alice = "alice";
        String bob = "bob";
        PropertyKey vtk = this.makeVertexIndexedKey("vt", String.class);
        PropertyKey fnk = this.makeKey("firstname", String.class);
        this.finishSchema();
        TitanVertex a = this.tx.addVertex(new Object[]{"vt", "user", "firstname", "alice"});
        TitanVertex b = this.tx.addVertex(new Object[]{"vt", "user", "firstname", "bob"});
        TitanVertex v = (TitanVertex)TitanGraphTest.getOnlyElement(this.tx.query().has("vt", (Object)"user").has("firstname", (Object)"bob").limit(1).vertices());
        Assert.assertEquals((Object)"bob", (Object)v.value("firstname"));
        Assert.assertEquals((Object)"user", (Object)v.value("vt"));
        v = (TitanVertex)TitanGraphTest.getOnlyElement(this.tx.query().has("vt", (Object)"user").has("firstname", (Object)"alice").limit(1).vertices());
        Assert.assertEquals((Object)"alice", (Object)v.value("firstname"));
        Assert.assertEquals((Object)"user", (Object)v.value("vt"));
        this.tx.commit();
        this.tx = this.graph.newTransaction();
        v = (TitanVertex)TitanGraphTest.getOnlyElement(this.tx.query().has("vt", (Object)"user").has("firstname", (Object)"bob").limit(1).vertices());
        Assert.assertEquals((Object)"bob", (Object)v.value("firstname"));
        Assert.assertEquals((Object)"user", (Object)v.value("vt"));
        v = (TitanVertex)TitanGraphTest.getOnlyElement(this.tx.query().has("vt", (Object)"user").has("firstname", (Object)"alice").limit(1).vertices());
        Assert.assertEquals((Object)"alice", (Object)v.value("firstname"));
        Assert.assertEquals((Object)"user", (Object)v.value("vt"));
    }

    @Test
    public void testWithoutIndex() {
        PropertyKey kid = this.mgmt.makePropertyKey("kid").dataType(Long.class).make();
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.makeEdgeLabel("knows").signature(new PropertyKey[]{kid}).make();
        this.finishSchema();
        Random random = new Random();
        int numV = 1000;
        TitanVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            TitanVertex v = this.graph.addVertex(new Object[]{"kid", random.nextInt(numV), "name", "v" + i});
            if (previous != null) {
                TitanEdge titanEdge = v.addEdge("knows", (Vertex)previous, new Object[]{"kid", random.nextInt(numV / 2)});
            }
            previous = v;
        }
        TitanGraphTest.verifyElementOrder(this.graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(500).vertices(), "kid", Order.ASC, 500);
        TitanGraphTest.verifyElementOrder(this.graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(300).edges(), "kid", Order.ASC, 300);
        TitanGraphTest.verifyElementOrder(this.graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(400).vertices(), "kid", Order.DESC, 400);
        TitanGraphTest.verifyElementOrder(this.graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(200).edges(), "kid", Order.DESC, 200);
        this.clopen(new Object[0]);
        TitanGraphTest.verifyElementOrder(this.graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(500).vertices(), "kid", Order.ASC, 500);
        TitanGraphTest.verifyElementOrder(this.graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.incr).limit(300).edges(), "kid", Order.ASC, 300);
        TitanGraphTest.verifyElementOrder(this.graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(400).vertices(), "kid", Order.DESC, 400);
        TitanGraphTest.verifyElementOrder(this.graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.decr).limit(200).edges(), "kid", Order.DESC, 200);
    }

    @Test
    public void testHasNot() {
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        TitanVertex v2 = (TitanVertex)this.graph.query().hasNot("abcd").vertices().iterator().next();
        Assert.assertEquals((Object)v1, (Object)v2);
        v2 = (TitanVertex)this.graph.query().hasNot("abcd", (Object)true).vertices().iterator().next();
        Assert.assertEquals((Object)v1, (Object)v2);
    }

    @Test
    public void testVertexCentricIndexWithNull() {
        EdgeLabel bought = this.makeLabel("bought");
        PropertyKey time = this.makeKey("time", Long.class);
        this.mgmt.buildEdgeIndex(bought, "byTimeDesc", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.decr, new PropertyKey[]{time});
        this.mgmt.buildEdgeIndex(bought, "byTimeIncr", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.incr, new PropertyKey[]{time});
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertex(new Object[0]);
        TitanVertex v2 = this.tx.addVertex(new Object[0]);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)1);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)2);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)3);
        v1.addEdge("bought", (Vertex)v2, new Object[0]);
        v1.addEdge("bought", (Vertex)v2, new Object[0]);
        Assert.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).edgeCount());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Object)1).edgeCount());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)3).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)1).edgeCount());
        Assert.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)5).edgeCount());
        Assert.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)0).edgeCount());
        Assert.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)3).edgeCount());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)2).edgeCount());
        Assert.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).hasNot("time").edgeCount());
        Assert.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).edgeCount());
        this.newTx();
        v1 = this.tx.getVertex(v1.longId());
        Assert.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).edgeCount());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Object)1).edgeCount());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)3).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)1).edgeCount());
        Assert.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)5).edgeCount());
        Assert.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)0).edgeCount());
        Assert.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.LESS_THAN, (Object)3).edgeCount());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (TitanPredicate)Cmp.GREATER_THAN, (Object)2).edgeCount());
        Assert.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).hasNot("time").edgeCount());
        Assert.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).edgeCount());
    }

    @Test
    public void testCreateDelete() {
        this.makeKey("weight", Double.class);
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{uid}).sortOrder(Order.DESC).directed().make();
        this.mgmt.makeEdgeLabel("father").multiplicity(Multiplicity.MANY2ONE).make();
        this.finishSchema();
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        TitanVertex v3 = this.graph.addVertex(new Object[]{"uid", 445});
        TitanEdge e = v3.addEdge("knows", (Vertex)v1, new Object[]{"uid", 111});
        TitanEdge e2 = v1.addEdge("friend", (Vertex)v3, new Object[0]);
        Assert.assertEquals((long)111L, (long)((Integer)e.value("uid")).intValue());
        this.graph.tx().commit();
        v3 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v3);
        Assert.assertEquals((long)445L, (long)((Integer)v3.value("uid")).intValue());
        e = (Edge)TitanGraphTest.getOnlyElement(v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assert.assertEquals((long)111L, (long)((Integer)e.value("uid")).intValue());
        Assert.assertEquals((Object)e, (Object)TitanGraphTest.getE((TitanGraphTransaction)this.graph, e.id()));
        Assert.assertEquals((Object)e, (Object)TitanGraphTest.getE((TitanGraphTransaction)this.graph, e.id().toString()));
        VertexProperty p = (VertexProperty)TitanGraphTest.getOnlyElement(v3.properties(new String[]{"uid"}));
        p.remove();
        v3.property("uid", (Object)353);
        e = (Edge)TitanGraphTest.getOnlyElement(v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        e.property("uid", (Object)222);
        e2 = (Edge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"friend"}).edges());
        e2.property("uid", (Object)1);
        e2.property("weight", (Object)2.0);
        Assert.assertEquals((long)1L, (long)((Integer)e2.value("uid")).intValue());
        Assert.assertEquals((double)2.0, (double)((Double)e2.value("weight")), (double)1.0E-4);
        this.clopen(new Object[0]);
        v3 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v3.id());
        Assert.assertEquals((long)353L, (long)((Integer)v3.value("uid")).intValue());
        e = (Edge)TitanGraphTest.getOnlyElement(v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assert.assertEquals((long)222L, (long)((Integer)e.value("uid")).intValue());
    }

    @Test
    public void testEdgeTTLTiming() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        EdgeLabel label1 = this.mgmt.makeEdgeLabel("likes").make();
        int ttl1 = 1;
        int ttl2 = 4;
        this.mgmt.setTTL((TitanSchemaType)label1, Duration.ofSeconds(ttl1));
        EdgeLabel label2 = this.mgmt.makeEdgeLabel("dislikes").make();
        this.mgmt.setTTL((TitanSchemaType)label2, Duration.ofSeconds(ttl2));
        EdgeLabel label3 = this.mgmt.makeEdgeLabel("indifferentTo").make();
        Assert.assertEquals((Object)Duration.ofSeconds(ttl1), (Object)this.mgmt.getTTL((TitanSchemaType)label1));
        Assert.assertEquals((Object)Duration.ofSeconds(ttl2), (Object)this.mgmt.getTTL((TitanSchemaType)label2));
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)label3));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        TitanVertex v3 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        v2.addEdge("dislikes", (Vertex)v1, new Object[0]);
        v3.addEdge("indifferentTo", (Vertex)v1, new Object[0]);
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        TitanAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        long commitTime = System.currentTimeMillis();
        this.graph.tx().commit();
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        TitanAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        Thread.sleep(commitTime + ((long)ttl1 * 1000L + 200L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        TitanAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        TitanAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        Thread.sleep(commitTime + ((long)ttl2 * 1000L + 500L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        TitanAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
        TitanAssert.assertEmpty(v2.query().direction(Direction.OUT).vertices());
        TitanAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
    }

    @Test
    public void testEdgeTTLWithTransactions() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        EdgeLabel label1 = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((TitanSchemaType)label1, Duration.ofSeconds(1L));
        Assert.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((TitanSchemaType)label1));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        Thread.sleep(1001L);
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        this.graph.tx().commit();
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        Thread.sleep(1001L);
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        this.graph.tx().rollback();
        TitanAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testEdgeTTLWithIndex() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        int ttl = 1;
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        EdgeLabel wavedAt = this.mgmt.makeEdgeLabel("wavedAt").signature(new PropertyKey[]{time}).make();
        this.mgmt.buildEdgeIndex(wavedAt, "timeindex", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.decr, new PropertyKey[]{time});
        this.mgmt.buildIndex("edge-time", Edge.class).addKey(time).buildCompositeIndex();
        this.mgmt.setTTL((TitanSchemaType)wavedAt, Duration.ofSeconds(ttl));
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)time));
        Assert.assertEquals((Object)Duration.ofSeconds(ttl), (Object)this.mgmt.getTTL((TitanSchemaType)wavedAt));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("wavedAt", (Vertex)v2, new Object[]{"time", 42});
        Assert.assertTrue((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        TitanAssert.assertNotEmpty(this.graph.query().has("time", (Object)42).edges());
        this.graph.tx().commit();
        long commitTime = System.currentTimeMillis();
        Assert.assertTrue((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        TitanAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        TitanAssert.assertNotEmpty(this.graph.query().has("time", (Object)42).edges());
        Thread.sleep(commitTime + ((long)ttl * 1000L + 100L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        Assert.assertFalse((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        TitanAssert.assertEmpty(v1.query().direction(Direction.OUT).edges());
        TitanAssert.assertEmpty(this.graph.query().has("time", (Object)42).edges());
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testPropertyTTLTiming() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey place = this.mgmt.makePropertyKey("place").dataType(String.class).make();
        this.mgmt.setTTL((TitanSchemaType)name, Duration.ofSeconds(42L));
        this.mgmt.setTTL((TitanSchemaType)place, Duration.ofSeconds(1L));
        TitanGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name).buildCompositeIndex();
        TitanGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).addKey(name).addKey(place).buildCompositeIndex();
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((TitanSchemaType)label1, Duration.ofSeconds(2L));
        Assert.assertEquals((Object)Duration.ofSeconds(42L), (Object)this.mgmt.getTTL((TitanSchemaType)name));
        Assert.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((TitanSchemaType)place));
        Assert.assertEquals((Object)Duration.ofSeconds(2L), (Object)this.mgmt.getTTL((TitanSchemaType)label1));
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertex(new Object[]{T.label, "event", "name", "some event", "place", "somewhere"});
        this.tx.commit();
        Object id = v1.id();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, id);
        Assert.assertNotNull((Object)v1);
        TitanAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        TitanAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, id);
        Assert.assertNotNull((Object)v1);
        TitanAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        TitanAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        TitanAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        TitanAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, id);
        Assert.assertNull((Object)v1);
    }

    @Test
    public void testVertexTTLWithCompositeIndex() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Long.class).make();
        TitanGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name).buildCompositeIndex();
        TitanGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).addKey(name).addKey(time).buildCompositeIndex();
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((TitanSchemaType)label1, Duration.ofSeconds(1L));
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)name));
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)time));
        Assert.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((TitanSchemaType)label1));
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertex(new Object[]{T.label, "event", "name", "some event", "time", System.currentTimeMillis()});
        this.tx.commit();
        Object id = v1.id();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, id);
        Assert.assertNotNull((Object)v1);
        TitanAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, id);
        Assert.assertNull((Object)v1);
        TitanAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").vertices());
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testEdgeTTLLimitedByVertexTTL() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        Boolean dbCache = (Boolean)this.config.get("cache.db-cache", Boolean.class);
        if (null == dbCache) {
            dbCache = false;
        }
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((TitanSchemaType)likes, Duration.ofSeconds(42L));
        EdgeLabel dislikes = this.mgmt.makeEdgeLabel("dislikes").make();
        this.mgmt.setTTL((TitanSchemaType)dislikes, Duration.ofSeconds(1L));
        EdgeLabel indifferentTo = this.mgmt.makeEdgeLabel("indifferentTo").make();
        VertexLabel label1 = this.mgmt.makeVertexLabel("person").setStatic().make();
        this.mgmt.setTTL((TitanSchemaType)label1, Duration.ofSeconds(2L));
        Assert.assertEquals((Object)Duration.ofSeconds(42L), (Object)this.mgmt.getTTL((TitanSchemaType)likes));
        Assert.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((TitanSchemaType)dislikes));
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)indifferentTo));
        Assert.assertEquals((Object)Duration.ofSeconds(2L), (Object)this.mgmt.getTTL((TitanSchemaType)label1));
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertex("person");
        TitanVertex v2 = this.tx.addVertex(new Object[0]);
        TitanEdge v1LikesV2 = v1.addEdge("likes", (Vertex)v2, new Object[0]);
        TitanEdge v1DislikesV2 = v1.addEdge("dislikes", (Vertex)v2, new Object[0]);
        TitanEdge v1IndifferentToV2 = v1.addEdge("indifferentTo", (Vertex)v2, new Object[0]);
        this.tx.commit();
        long commitTime = System.currentTimeMillis();
        Object v1Id = v1.id();
        Object v2id = v2.id();
        Object v1LikesV2Id = v1LikesV2.id();
        Object v1DislikesV2Id = v1DislikesV2.id();
        Object v1IndifferentToV2Id = v1IndifferentToV2.id();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v1Id);
        v2 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v2id);
        v1LikesV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1IndifferentToV2Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNotNull((Object)v1LikesV2);
        Assert.assertNotNull((Object)v1DislikesV2);
        Assert.assertNotNull((Object)v1IndifferentToV2);
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        Thread.sleep(commitTime + 1001L - System.currentTimeMillis());
        this.graph.tx().rollback();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v1Id);
        v2 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v2id);
        v1LikesV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1IndifferentToV2Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNotNull((Object)v1LikesV2);
        Assert.assertNull((Object)v1DislikesV2);
        Assert.assertNotNull((Object)v1IndifferentToV2);
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
        TitanAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
        TitanAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        Thread.sleep(commitTime + 2001L - System.currentTimeMillis());
        this.graph.tx().rollback();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v1Id);
        v2 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v2id);
        v1LikesV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = TitanGraphTest.getE((TitanGraphTransaction)this.graph, v1IndifferentToV2Id);
        Assert.assertNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNull((Object)v1LikesV2);
        Assert.assertNull((Object)v1DislikesV2);
        Assert.assertNull((Object)v1IndifferentToV2);
        if (!dbCache.booleanValue()) {
            TitanAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
            TitanAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
            TitanAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSettingTTLOnUnsupportedType() throws Exception {
        if (!this.features.hasCellTTL()) {
            throw new IllegalArgumentException();
        }
        ImplicitKey type = ImplicitKey.ID;
        this.mgmt.setTTL((TitanSchemaType)type, Duration.ZERO);
    }

    @Test
    public void testUnsettingTTL() throws InterruptedException {
        if (!this.features.hasCellTTL()) {
            return;
        }
        int initialTTLMillis = 2000;
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((TitanSchemaType)likes, Duration.ofMillis(initialTTLMillis));
        this.mgmt.commit();
        this.graph.tx().rollback();
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Thread.sleep((long)Math.ceil((double)initialTTLMillis * 1.25));
        Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        this.mgmt.setTTL((TitanSchemaType)this.mgmt.getEdgeLabel("likes"), Duration.ZERO);
        this.mgmt.commit();
        Thread.sleep(1L);
        Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        v1 = this.graph.addVertex(new Object[0]);
        v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Thread.sleep((long)Math.ceil((double)initialTTLMillis * 1.25));
        Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        this.graph.tx().rollback();
    }

    @Test
    public void testGettingUndefinedEdgeLabelTTL() {
        if (!this.features.hasCellTTL()) {
            return;
        }
        this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.commit();
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)this.mgmt.getEdgeLabel("likes")));
        this.mgmt.rollback();
    }

    @Test
    public void testGettingUndefinedVertexLabelTTL() {
        if (!this.features.hasCellTTL()) {
            return;
        }
        this.mgmt.makeVertexLabel("foo").make();
        this.mgmt.commit();
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)this.mgmt.getVertexLabel("foo")));
        this.mgmt.rollback();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetTTLFromUnsupportedType() throws Exception {
        if (!this.features.hasCellTTL()) {
            throw new IllegalArgumentException();
        }
        ImplicitKey type = ImplicitKey.ID;
        this.mgmt.getTTL((TitanSchemaType)type);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSettingTTLOnNonStaticVertexLabel() throws Exception {
        if (!this.features.hasCellTTL()) {
            throw new IllegalArgumentException();
        }
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").make();
        this.mgmt.setTTL((TitanSchemaType)label1, Duration.ofSeconds(42L));
    }

    @Test
    public void testEdgeTTLImplicitKey() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        Assert.assertEquals((Object)"~ttl", (Object)ImplicitKey.TTL.name());
        int ttl = 86400;
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        EdgeLabel hasLiked = this.mgmt.makeEdgeLabel("hasLiked").make();
        this.mgmt.setTTL((TitanSchemaType)likes, Duration.ofSeconds(ttl));
        Assert.assertEquals((Object)Duration.ofSeconds(ttl), (Object)this.mgmt.getTTL((TitanSchemaType)likes));
        Assert.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((TitanSchemaType)hasLiked));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(new Object[0]);
        TitanVertex v2 = this.graph.addVertex(new Object[0]);
        TitanEdge e1 = v1.addEdge("likes", (Vertex)v2, new Object[0]);
        TitanEdge e2 = v1.addEdge("hasLiked", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Duration d = (Duration)e1.value("~ttl");
        Assert.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        e1 = (Edge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"likes"}).edges());
        d = (Duration)e1.value("~ttl");
        Assert.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        e1 = (Edge)TitanGraphTest.getOnlyElement(v1.query().direction(Direction.OUT).labels(new String[]{"likes"}).edges());
        d = (Duration)e1.value("~ttl");
        Assert.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        d = (Duration)e2.value("~ttl");
        Assert.assertEquals((Object)Duration.ZERO, (Object)d);
    }

    @Test
    public void testVertexTTLImplicitKey() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        int ttl1 = 1;
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((TitanSchemaType)label1, Duration.ofSeconds(ttl1));
        Assert.assertEquals((Object)Duration.ofSeconds(ttl1), (Object)this.mgmt.getTTL((TitanSchemaType)label1));
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertex("event");
        TitanVertex v2 = this.tx.addVertex(new Object[0]);
        this.tx.commit();
        Object v1id = v1.id();
        Object v2id = v2.id();
        v1 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v1id);
        v2 = TitanGraphTest.getV((TitanGraphTransaction)this.graph, v2id);
        Duration d = (Duration)v1.value("~ttl");
        Assert.assertEquals((Object)Duration.ofSeconds(1L), (Object)d);
        d = (Duration)v2.value("~ttl");
        Assert.assertEquals((Object)Duration.ZERO, (Object)d);
    }

    private static interface TransactionJob {
        public void run(TitanTransaction var1);
    }
}

