/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.testutil;

import com.carrotsearch.junitbenchmarks.AutocloseConsumer;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.IResultsConsumer;
import com.carrotsearch.junitbenchmarks.Result;
import com.carrotsearch.junitbenchmarks.WriterConsumer;
import com.carrotsearch.junitbenchmarks.XMLConsumer;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.testutil.CsvConsumer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitBenchmarkProvider {
    public static final String ENV_EFFORT_GENERATE = "JUB_EFFORT_GENERATE";
    public static final String ENV_EFFORT_FILE = "JUB_EFFORT_FILE";
    public static final String ENV_DEFAULT_ROUNDS = "JUB_DEFAULT_ROUNDS";
    public static final String ENV_WARMUP_ROUNDS = "JUB_WARMUP_ROUNDS";
    public static final String ENV_TARGET_RUNTIME_MS = "JUB_TARGET_RUNTIME_MS";
    public static final String DEFAULT_EFFORT_FILE = "../titan-test/data/jub-effort.txt";
    public static final long TARGET_RUNTIME_MS;
    public static final int DEFAULT_ROUNDS;
    public static final int WARMUP_ROUNDS;
    private static final Map<String, Integer> efforts;
    private static final Logger log;

    public static TestRule get() {
        return new AdjustableRoundsBenchmarkRule(efforts, JUnitBenchmarkProvider.getConsumers(new IResultsConsumer[0]));
    }

    public static TestRule get(IResultsConsumer ... additionalConsumers) {
        return new AdjustableRoundsBenchmarkRule(efforts, JUnitBenchmarkProvider.getConsumers(additionalConsumers));
    }

    private static Map<String, Integer> loadScalarsFromEnvironment() {
        String file = JUnitBenchmarkProvider.getEffortFilePath();
        File f = new File(file);
        if (!f.canRead()) {
            log.error("Can't read JUnitBenchmarks effort file {}, no effort multipliers loaded.", (Object)file);
            return ImmutableMap.of();
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            Map<String, Integer> map = JUnitBenchmarkProvider.loadScalarsUnsafe(file, reader);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static IResultsConsumer[] getConsumers(IResultsConsumer ... additional) {
        try {
            return JUnitBenchmarkProvider.getConsumersUnsafe(additional);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static IResultsConsumer[] getConsumersUnsafe(IResultsConsumer ... additional) throws IOException {
        ArrayList<Object> consumers = new ArrayList<Object>();
        consumers.add(new XMLConsumer(new File("jub." + Math.abs(System.nanoTime()) + ".xml")));
        consumers.add(new WriterConsumer());
        consumers.add(new CsvConsumer("target/jub.csv"));
        if (null != System.getenv(ENV_EFFORT_GENERATE)) {
            String file = JUnitBenchmarkProvider.getEffortFilePath();
            FileWriter writer = new FileWriter(file, true);
            log.info("Opened " + file + " for appending");
            consumers.add(new TimeScaleConsumer(writer));
        }
        for (IResultsConsumer c : additional) {
            consumers.add(c);
        }
        return consumers.toArray(new IResultsConsumer[consumers.size()]);
    }

    private static String getEffortFilePath() {
        String file = System.getenv(ENV_EFFORT_FILE);
        if (null == file) {
            log.debug("Env variable JUB_EFFORT_FILE was null");
            log.debug("Defaulting to JUB effort scalar file ../titan-test/data/jub-effort.txt");
            file = DEFAULT_EFFORT_FILE;
        }
        return file;
    }

    private static Map<String, Integer> loadScalarsUnsafe(String filename, BufferedReader reader) throws IOException {
        String line;
        int ln = 0;
        int tokensPerLine = 2;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        while (null != (line = reader.readLine())) {
            Double scalar;
            ++ln;
            String[] tokens = line.split(" ");
            if (2 != tokens.length) {
                log.warn("Parse error at {}:{}: required {} tokens, but found {} (skipping this line)", new Object[]{filename, ln, 2, tokens.length});
                continue;
            }
            int t = 0;
            String name = tokens[t++];
            String rawscalar = tokens[t++];
            assert (2 == t);
            assert (null != name);
            if (0 == name.length()) {
                log.warn("Parse error at {}:{}: zero-length method name (skipping this line)", (Object)filename, (Object)ln);
                continue;
            }
            assert (0 < name.length());
            try {
                scalar = Double.valueOf(rawscalar);
            }
            catch (Exception e) {
                log.warn("Parse error at {}:{}: failed to convert string \"{}\" to a double (skipping this line)", new Object[]{filename, ln, rawscalar});
                log.warn("Double parsing exception stacktrace follows", (Throwable)e);
                continue;
            }
            if (0.0 > scalar) {
                log.warn("Parse error at {}:{}: read negative method scalar {} (skipping this line)", new Object[]{filename, ln, scalar});
                continue;
            }
            assert (null != scalar);
            builder.put((Object)name, (Object)Double.valueOf(Math.ceil(scalar)).intValue());
        }
        return builder.build();
    }

    private static BenchmarkOptions getDefaultBenchmarkOptions(int rounds) {
        return (BenchmarkOptions)Proxy.newProxyInstance(JUnitBenchmarkProvider.class.getClassLoader(), new Class[]{BenchmarkOptions.class}, (InvocationHandler)new DefaultBenchmarkOptionsHandler(rounds));
    }

    private static BenchmarkOptions getWrappedBenchmarkOptions(BenchmarkOptions base, int rounds) {
        return (BenchmarkOptions)Proxy.newProxyInstance(JUnitBenchmarkProvider.class.getClassLoader(), new Class[]{BenchmarkOptions.class}, (InvocationHandler)new WrappedBenchmarkOptionsHandler(base, rounds));
    }

    private static int loadIntFromEnvironment(String envKey, int dfl) {
        String s = System.getenv(envKey);
        if (null != s) {
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException e) {
                log.warn("Could not interpret value \"{}\" for environment variable {} as an integer", new Object[]{s, envKey, e});
            }
        } else {
            log.debug("Using default value {} for environment variable {}", (Object)dfl, (Object)envKey);
        }
        return dfl;
    }

    static {
        log = LoggerFactory.getLogger(JUnitBenchmarkProvider.class);
        efforts = JUnitBenchmarkProvider.loadScalarsFromEnvironment();
        DEFAULT_ROUNDS = JUnitBenchmarkProvider.loadIntFromEnvironment(ENV_DEFAULT_ROUNDS, 1);
        WARMUP_ROUNDS = JUnitBenchmarkProvider.loadIntFromEnvironment(ENV_WARMUP_ROUNDS, 1);
        TARGET_RUNTIME_MS = JUnitBenchmarkProvider.loadIntFromEnvironment(ENV_TARGET_RUNTIME_MS, 5000);
    }

    private static class WrappedBenchmarkOptionsHandler
    implements InvocationHandler {
        private final Object base;
        private final int rounds;

        public WrappedBenchmarkOptionsHandler(Object base, int rounds) {
            this.base = base;
            this.rounds = rounds;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (method.getName().equals("benchmarkRounds")) {
                log.trace("Intercepted benchmarkRounds() invocation: returning {}", (Object)this.rounds);
                return this.rounds;
            }
            if (method.getName().equals("warmupRounds")) {
                log.trace("Intercepted warmupRounds() invocation: returning {}", (Object)WARMUP_ROUNDS);
                return WARMUP_ROUNDS;
            }
            log.trace("Delegating intercepted invocation of method {} to wrapped base instance {}", (Object)method.getName(), this.base);
            return method.invoke(this.base, args);
        }
    }

    private static class DefaultBenchmarkOptionsHandler
    implements InvocationHandler {
        private final int rounds;

        public DefaultBenchmarkOptionsHandler(int rounds) {
            this.rounds = rounds;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (method.getName().equals("benchmarkRounds")) {
                log.trace("Intercepted benchmarkRounds() invocation: returning {}", (Object)this.rounds);
                return this.rounds;
            }
            if (method.getName().equals("warmupRounds")) {
                log.trace("Intercepted warmupRounds() invocation: returning {}", (Object)WARMUP_ROUNDS);
                return WARMUP_ROUNDS;
            }
            if (method.getName().equals("annotationType")) {
                return BenchmarkOptions.class;
            }
            log.trace("Returning default value for method intercepted invocation of method {}", (Object)method.getName());
            return method.getDefaultValue();
        }
    }

    private static class AdjustableRoundsBenchmarkRule
    implements TestRule {
        private final BenchmarkRule rule;
        private final Map<String, Integer> efforts;

        public AdjustableRoundsBenchmarkRule(Map<String, Integer> efforts, IResultsConsumer ... consumers) {
            this.rule = new BenchmarkRule(consumers);
            this.efforts = efforts;
        }

        public Statement apply(Statement base, Description description) {
            Class clazz = description.getTestClass();
            String mname = description.getMethodName();
            Collection annotations = description.getAnnotations();
            int rounds = this.getRoundsForFullMethodName(clazz.getCanonicalName() + "." + mname);
            ArrayList<Object> modifiedAnnotations = new ArrayList<Object>(annotations.size());
            boolean hit = false;
            for (Annotation a : annotations) {
                if (a.annotationType().equals(BenchmarkOptions.class)) {
                    BenchmarkOptions old = (BenchmarkOptions)a;
                    BenchmarkOptions replacement = JUnitBenchmarkProvider.getWrappedBenchmarkOptions(old, rounds);
                    modifiedAnnotations.add(replacement);
                    log.debug("Modified BenchmarkOptions annotation on {}", (Object)mname);
                    hit = true;
                    continue;
                }
                modifiedAnnotations.add(a);
                log.debug("Kept annotation {} with annotation type {} on {}", new Object[]{a, a.annotationType(), mname});
            }
            if (!hit) {
                BenchmarkOptions opts = JUnitBenchmarkProvider.getDefaultBenchmarkOptions(rounds);
                modifiedAnnotations.add(opts);
                log.debug("Added BenchmarkOptions {} with annotation type {} to {}", new Object[]{opts, opts.annotationType(), mname});
            }
            Description roundsAdjustedDesc = Description.createTestDescription((Class)clazz, (String)mname, (Annotation[])modifiedAnnotations.toArray(new Annotation[modifiedAnnotations.size()]));
            return this.rule.apply(base, roundsAdjustedDesc);
        }

        private int getRoundsForFullMethodName(String fullname) {
            Integer r = this.efforts.get(fullname);
            if (null == r) {
                r = DEFAULT_ROUNDS;
                log.warn("Applying default iteration count ({}) to method {}", (Object)r, (Object)fullname);
            } else {
                log.debug("Loaded iteration count {} on method {}", (Object)r, (Object)fullname);
            }
            return r;
        }
    }

    private static class TimeScaleConsumer
    extends AutocloseConsumer
    implements Closeable {
        Writer writer;

        public TimeScaleConsumer(Writer writer) {
            this.writer = writer;
        }

        public void accept(Result result) throws IOException {
            double millis = 1000.0 * result.roundAverage.avg;
            double scalar = Math.max(1.0, (double)TARGET_RUNTIME_MS / Math.max(1.0, millis));
            String testClass = result.getTestClassName();
            String testName = result.getTestMethodName();
            this.writer.write(String.format("%s.%s %.3f%n", testClass, testName, scalar));
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

