/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.olap;

import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class ShortestDistanceMapReduce
extends StaticMapReduce<Object, Long, Object, Long, Iterator<KeyValue<Object, Long>>> {
    public static final String SHORTEST_DISTANCE_MEMORY_KEY = "titan.shortestDistanceMapReduce.memoryKey";
    public static final String DEFAULT_MEMORY_KEY = "shortestDistance";
    private String memoryKey = "shortestDistance";

    private ShortestDistanceMapReduce() {
    }

    private ShortestDistanceMapReduce(String memoryKey) {
        this.memoryKey = memoryKey;
    }

    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty(SHORTEST_DISTANCE_MEMORY_KEY, (Object)this.memoryKey);
    }

    public void loadState(Graph graph, Configuration configuration) {
        this.memoryKey = configuration.getString(SHORTEST_DISTANCE_MEMORY_KEY, DEFAULT_MEMORY_KEY);
    }

    public boolean doStage(MapReduce.Stage stage) {
        return stage.equals((Object)MapReduce.Stage.MAP);
    }

    public void map(Vertex vertex, MapReduce.MapEmitter<Object, Long> emitter) {
        VertexProperty distance = vertex.property("titan.shortestDistanceVertexProgram.distance");
        if (distance.isPresent()) {
            emitter.emit(vertex.id(), (Object)((Long)distance.value()));
        }
    }

    public Iterator<KeyValue<Object, Long>> generateFinalResult(Iterator<KeyValue<Object, Long>> keyValues) {
        return keyValues;
    }

    public String getMemoryKey() {
        return this.memoryKey;
    }

    public String toString() {
        return StringFactory.mapReduceString((MapReduce)this, (String)this.memoryKey);
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        private String memoryKey = "shortestDistance";

        private Builder() {
        }

        public Builder memoryKey(String memoryKey) {
            this.memoryKey = memoryKey;
            return this;
        }

        public ShortestDistanceMapReduce create() {
            return new ShortestDistanceMapReduce(this.memoryKey);
        }
    }
}

