/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.LongArrayList;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanGraphComputer;
import com.thinkaurelius.titan.core.TitanGraphTransaction;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.idassigner.VertexIDAssigner;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PropertyPlacementStrategy;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.SimpleBulkPlacementStrategy;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraGraphComputer;
import com.thinkaurelius.titan.olap.OLAPTest;
import com.thinkaurelius.titan.testutil.TitanAssert;
import com.thinkaurelius.titan.util.datastructures.AbstractLongListUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanPartitionGraphTest
extends TitanGraphBaseTest {
    private static final Logger log = LoggerFactory.getLogger(TitanPartitionGraphTest.class);
    static final Random random = new Random();
    static final int numPartitions = 8;
    private IDManager idManager;

    public abstract WriteConfiguration getBaseConfiguration();

    @Override
    public WriteConfiguration getConfiguration() {
        WriteConfiguration config = this.getBaseConfiguration();
        ModifiableConfiguration mconf = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
        mconf.set(GraphDatabaseConfiguration.CLUSTER_MAX_PARTITIONS, (Object)8, new String[0]);
        mconf.set(SimpleBulkPlacementStrategy.CONCURRENT_PARTITIONS, (Object)24, new String[0]);
        return config;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.idManager = this.graph.getIDManager();
    }

    @Test
    public void testPartitionHashes() {
        Assert.assertEquals((long)8L, (long)this.idManager.getPartitionBound());
        HashSet hashs = Sets.newHashSet();
        for (long i = 1L; i < this.idManager.getPartitionBound() * 2L; ++i) {
            hashs.add(this.idManager.getPartitionHashForId(i));
        }
        Assert.assertTrue(((long)hashs.size() > this.idManager.getPartitionBound() / 2L ? 1 : 0) != 0);
        Assert.assertNotEquals((long)this.idManager.getPartitionHashForId(101L), (long)this.idManager.getPartitionHashForId(102L));
    }

    @Test
    public void testVertexPartitioning() throws Exception {
        TitanVertex g;
        int i;
        Object[] options = new Object[]{TitanPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), false};
        this.clopen(options);
        PropertyKey gid = this.makeVertexIndexedUniqueKey("gid", Integer.class);
        PropertyKey sig = this.makeKey("sig", Integer.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
        EdgeLabel knows = this.makeLabel("knows");
        EdgeLabel base = this.makeLabel("base");
        EdgeLabel one = this.mgmt.makeEdgeLabel("one").multiplicity(Multiplicity.ONE2ONE).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel group = this.mgmt.makeVertexLabel("group").partition().make();
        this.finishSchema();
        ImmutableSet names = ImmutableSet.of((Object)"Marko", (Object)"Dan", (Object)"Stephen", (Object)"Daniel", (Object)"Josh", (Object)"Thad", (Object[])new String[]{"Pavel", "Matthias"});
        int numG = 10;
        long[] gids = new long[10];
        for (i = 0; i < 10; ++i) {
            g = this.tx.addVertex("group");
            g.property(VertexProperty.Cardinality.single, "gid", (Object)i, new Object[0]);
            g.property(VertexProperty.Cardinality.single, "sig", (Object)0, new Object[0]);
            for (String n : names) {
                g.property("name", (Object)n);
            }
            Assert.assertEquals((long)i, (long)((Integer)g.value("gid")).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)g.value("sig")).intValue());
            Assert.assertEquals((Object)"group", (Object)g.label());
            TitanAssert.assertCount(names.size(), g.properties(new String[]{"name"}));
            Assert.assertTrue((TitanPartitionGraphTest.getId((Element)g) > 0L ? 1 : 0) != 0);
            gids[i] = TitanPartitionGraphTest.getId((Element)g);
            if (i > 0) {
                g.addEdge("base", (Vertex)TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gids[0]), new Object[0]);
            }
            if (i % 2 != 1) continue;
            g.addEdge("one", (Vertex)TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gids[i - 1]), new Object[0]);
        }
        for (i = 0; i < 10; ++i) {
            g = TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gids[i]);
            TitanAssert.assertCount(1L, g.query().direction(Direction.BOTH).labels(new String[]{"one"}).edges());
            TitanAssert.assertCount(1L, g.query().direction(i % 2 == 0 ? Direction.IN : Direction.OUT).labels(new String[]{"one"}).edges());
            TitanAssert.assertCount(0L, g.query().direction(i % 2 == 1 ? Direction.IN : Direction.OUT).labels(new String[]{"one"}).edges());
            if (i > 0) {
                TitanAssert.assertCount(1L, g.query().direction(Direction.OUT).labels(new String[]{"base"}).edges());
                continue;
            }
            TitanAssert.assertCount(9L, g.query().direction(Direction.IN).labels(new String[]{"base"}).edges());
        }
        this.newTx();
        for (i = 0; i < 10; ++i) {
            long gId = gids[i];
            Assert.assertTrue((boolean)this.idManager.isPartitionedVertex(gId));
            Assert.assertEquals((long)this.idManager.getCanonicalVertexId(gId), (long)gId);
            TitanVertex g2 = TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gId);
            int canonicalPartition = this.getPartitionID(g2);
            Assert.assertEquals((Object)g2, (Object)((Vertex)TitanPartitionGraphTest.getOnlyElement(this.tx.query().has("gid", (Object)i).vertices())));
            Assert.assertEquals((long)i, (long)((Integer)g2.value("gid")).intValue());
            TitanAssert.assertCount(names.size(), g2.properties(new String[]{"name"}));
            TitanVertexProperty p = (TitanVertexProperty)TitanPartitionGraphTest.getOnlyElement(g2.properties(new String[]{"gid"}));
            Assert.assertEquals((long)canonicalPartition, (long)this.getPartitionID((TitanRelation)p));
            Iterator niter = g2.properties(new String[]{"name"});
            while (niter.hasNext()) {
                Assert.assertEquals((long)canonicalPartition, (long)this.getPartitionID((TitanVertex)((VertexProperty)niter.next()).element()));
            }
            TitanAssert.assertCount(1L, g2.query().direction(Direction.BOTH).labels(new String[]{"one"}).edges());
            TitanAssert.assertCount(1L, g2.query().direction(i % 2 == 0 ? Direction.IN : Direction.OUT).labels(new String[]{"one"}).edges());
            TitanAssert.assertCount(0L, g2.query().direction(i % 2 == 1 ? Direction.IN : Direction.OUT).labels(new String[]{"one"}).edges());
            if (i > 0) {
                TitanAssert.assertCount(1L, g2.query().direction(Direction.OUT).labels(new String[]{"base"}).edges());
                continue;
            }
            TitanAssert.assertCount(9L, g2.query().direction(Direction.IN).labels(new String[]{"base"}).edges());
        }
        this.clopen(options);
        int numTx = 100;
        int vPerTx = 10;
        HashMultiset partitions = HashMultiset.create();
        for (int t = 1; t <= 100; ++t) {
            TitanVertex g1 = TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gids[0]);
            TitanVertex g2 = TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gids[1]);
            Assert.assertNotNull((Object)g1);
            TitanVertex[] vs = new TitanVertex[10];
            for (int vi = 0; vi < 10; ++vi) {
                vs[vi] = this.tx.addVertex("person");
                vs[vi].property(VertexProperty.Cardinality.single, "sig", (Object)t, new Object[0]);
                TitanEdge e = vs[vi].addEdge("knows", (Vertex)g1, new Object[0]);
                e.property("sig", (Object)t);
                e = g1.addEdge("knows", (Vertex)vs[vi], new Object[0]);
                e.property("sig", (Object)t);
                if (vi % 2 != 0) continue;
                e = vs[vi].addEdge("knows", (Vertex)g2, new Object[0]);
                e.property("sig", (Object)t);
            }
            this.newTx();
            TitanTransaction txx = this.graph.buildTransaction().readOnly().start();
            g1 = TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gids[0]);
            g2 = TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gids[1]);
            int partition = -1;
            for (int vi = 0; vi < 10; ++vi) {
                Assert.assertTrue((boolean)vs[vi].hasId());
                int pid = this.getPartitionID(vs[vi]);
                if (partition < 0) {
                    partition = pid;
                } else {
                    Assert.assertEquals((long)partition, (long)pid);
                }
                int numRels = 0;
                TitanVertex v = TitanPartitionGraphTest.getV((TitanGraphTransaction)txx, vs[vi].longId());
                for (TitanRelation r : v.query().relations()) {
                    ++numRels;
                    Assert.assertEquals((long)partition, (long)this.getPartitionID(r));
                    if (!(r instanceof TitanEdge)) continue;
                    TitanVertex o = ((TitanEdge)r).otherVertex((Vertex)v);
                    Assert.assertTrue((o.equals(g1) || o.equals(g2) ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)(3 + (vi % 2 == 0 ? 1 : 0)), (long)numRels);
            }
            partitions.add((Object)partition);
            txx.commit();
        }
        Assert.assertTrue((partitions.elementSet().size() >= 3 ? 1 : 0) != 0);
        this.newTx();
        TitanVertex g1 = TitanPartitionGraphTest.getV((TitanGraphTransaction)this.tx, gids[0]);
        Assert.assertEquals((long)0L, (long)((Integer)g1.value("gid")).intValue());
        Assert.assertEquals((Object)"group", (Object)g1.label());
        TitanAssert.assertCount(names.size(), g1.properties(new String[]{"name"}));
        TitanAssert.assertCount(1000L, g1.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        TitanAssert.assertCount(1000L, g1.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
        TitanAssert.assertCount(2000L, g1.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
        TitanAssert.assertCount(1010L, this.tx.query().vertices());
        this.newTx();
        for (int t = 0; t < 10; ++t) {
            int numP = random.nextInt(3) + 1;
            HashSet parts = Sets.newHashSet();
            int numV = 0;
            while (parts.size() < numP) {
                int part = (Integer)Iterables.get((Iterable)partitions.elementSet(), (int)random.nextInt(partitions.elementSet().size()));
                if (!parts.add(part)) continue;
                numV += partitions.count((Object)part);
            }
            numV *= 10;
            int[] partarr = new int[numP];
            int i2 = 0;
            for (Integer part : parts) {
                partarr[i2++] = part;
            }
            TitanTransaction tx2 = this.graph.buildTransaction().restrictedPartitions(partarr).readOnly().start();
            g1 = TitanPartitionGraphTest.getV((TitanGraphTransaction)tx2, gids[0]);
            Assert.assertEquals((long)0L, (long)((Integer)g1.value("gid")).intValue());
            Assert.assertEquals((Object)"group", (Object)g1.label());
            Assert.assertTrue((names.size() >= TitanAssert.size(g1.properties(new String[]{"name"})) ? 1 : 0) != 0);
            TitanAssert.assertCount(numV, g1.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            TitanAssert.assertCount(numV, g1.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
            TitanAssert.assertCount(numV * 2, g1.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            TitanVertex g2 = TitanPartitionGraphTest.getV((TitanGraphTransaction)tx2, gids[1]);
            VertexList v1 = g1.query().direction(Direction.IN).labels(new String[]{"knows"}).vertexIds();
            VertexList v2 = g2.query().direction(Direction.IN).labels(new String[]{"knows"}).vertexIds();
            Assert.assertEquals((long)numV, (long)v1.size());
            Assert.assertEquals((long)(numV / 2), (long)v2.size());
            v1.sort();
            v2.sort();
            LongArrayList al1 = v1.getIDs();
            LongArrayList al2 = v2.getIDs();
            Assert.assertTrue((boolean)AbstractLongListUtil.isSorted((LongArrayList)al1));
            Assert.assertTrue((boolean)AbstractLongListUtil.isSorted((LongArrayList)al2));
            LongArrayList alr = AbstractLongListUtil.mergeJoin((LongArrayList)al1, (LongArrayList)al2, (boolean)false);
            Assert.assertEquals((long)(numV / 2), (long)alr.size());
            tx2.commit();
        }
    }

    private int setupGroupClusters(int[] groupDegrees, CommitMode commitMode) {
        this.mgmt.makeVertexLabel("person").make();
        this.mgmt.makeVertexLabel("group").partition().make();
        this.makeVertexIndexedKey("groupid", String.class);
        this.makeKey("name", String.class);
        this.makeKey("clusterId", String.class);
        this.makeLabel("member");
        this.makeLabel("contain");
        this.finishSchema();
        int numVertices = 0;
        TitanVertex[] groups = new TitanVertex[groupDegrees.length];
        for (int i = 0; i < groupDegrees.length; ++i) {
            groups[i] = this.tx.addVertex("group");
            groups[i].property("groupid", (Object)("group" + i));
            ++numVertices;
            if (commitMode == CommitMode.PER_VERTEX) {
                this.newTx();
            }
            for (int noEdges = 0; noEdges < groupDegrees[i]; ++noEdges) {
                TitanVertex g = TitanPartitionGraphTest.vInTx(groups[i], this.tx);
                TitanVertex p = this.tx.addVertex(new Object[]{"name", "person" + i + ":" + noEdges, "clusterId", "group" + i});
                ++numVertices;
                p.addEdge("member", (Vertex)g, new Object[0]);
                g.addEdge("contain", (Vertex)p, new Object[0]);
                if (commitMode != CommitMode.PER_VERTEX) continue;
                this.newTx();
            }
            if (commitMode != CommitMode.PER_CLUSTER) continue;
            this.newTx();
        }
        this.newTx();
        return numVertices;
    }

    private static TitanVertex vInTx(TitanVertex v, TitanTransaction tx) {
        if (!v.hasId()) {
            return v;
        }
        return tx.getVertex(v.longId());
    }

    @Test
    public void testPartitionSpreadFlushBatch() {
        this.testPartitionSpread(true, true);
    }

    @Test
    public void testPartitionSpreadFlushNoBatch() {
        this.testPartitionSpread(true, false);
    }

    @Test
    public void testPartitionSpreadNoFlushBatch() {
        this.testPartitionSpread(false, true);
    }

    @Test
    public void testPartitionSpreadNoFlushNoBatch() {
        this.testPartitionSpread(false, false);
    }

    private void testPartitionSpread(boolean flush, boolean batchCommit) {
        Object[] options = new Object[]{TitanPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), flush};
        this.clopen(options);
        int[] groupDegrees = new int[]{10, 15, 10, 17, 10, 4, 7, 20, 11};
        int numVertices = this.setupGroupClusters(groupDegrees, batchCommit ? CommitMode.BATCH : CommitMode.PER_VERTEX);
        IntHashSet partitionIds = new IntHashSet(numVertices);
        for (int i = 0; i < groupDegrees.length; ++i) {
            TitanVertex g = TitanPartitionGraphTest.getOnlyVertex(this.tx.query().has("groupid", (Object)("group" + i)));
            TitanAssert.assertCount(groupDegrees[i], g.edges(Direction.OUT, new String[]{"contain"}));
            TitanAssert.assertCount(groupDegrees[i], g.edges(Direction.IN, new String[]{"member"}));
            TitanAssert.assertCount(groupDegrees[i], g.query().direction(Direction.OUT).edges());
            TitanAssert.assertCount(groupDegrees[i], g.query().direction(Direction.IN).edges());
            TitanAssert.assertCount(groupDegrees[i] * 2, g.query().edges());
            for (TitanVertex v : g.query().direction(Direction.IN).labels(new String[]{"member"}).vertices()) {
                int pid = this.getPartitionID(v);
                partitionIds.add(pid);
                Assert.assertEquals((Object)g, TitanPartitionGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"member"}).vertices()));
                VertexList vlist = v.query().direction(Direction.IN).labels(new String[]{"contain"}).vertexIds();
                Assert.assertEquals((long)1L, (long)vlist.size());
                Assert.assertEquals((long)pid, (long)this.idManager.getPartitionId(vlist.getID(0)));
                Assert.assertEquals((Object)g, (Object)vlist.get(0));
            }
        }
        if (flush || !batchCommit) {
            Assert.assertTrue((partitionIds.size() > 4 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)1L, (long)partitionIds.size());
        }
    }

    @Test
    public void testVertexPartitionOlapBatch() throws Exception {
        this.testVertexPartitionOlap(CommitMode.BATCH);
    }

    @Test
    public void testVertexPartitionOlapCluster() throws Exception {
        this.testVertexPartitionOlap(CommitMode.PER_CLUSTER);
    }

    @Test
    public void testVertexPartitionOlapIndividual() throws Exception {
        this.testVertexPartitionOlap(CommitMode.PER_VERTEX);
    }

    private void testVertexPartitionOlap(CommitMode commitMode) throws Exception {
        Object[] options = new Object[]{TitanPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), false};
        this.clopen(options);
        int[] groupDegrees = new int[]{2};
        int numVertices = this.setupGroupClusters(groupDegrees, commitMode);
        HashMap<Long, Integer> degreeMap = new HashMap<Long, Integer>(groupDegrees.length);
        for (int i = 0; i < groupDegrees.length; ++i) {
            degreeMap.put(TitanPartitionGraphTest.getOnlyVertex(this.tx.query().has("groupid", (Object)("group" + i))).longId(), groupDegrees[i]);
        }
        this.clopen(options);
        TitanGraphComputer computer = (TitanGraphComputer)this.graph.compute(FulgoraGraphComputer.class);
        computer.resultMode(TitanGraphComputer.ResultMode.NONE);
        computer.workers(1);
        computer.program((VertexProgram)new OLAPTest.DegreeCounter());
        computer.mapReduce((MapReduce)new OLAPTest.DegreeMapper());
        ComputerResult result = (ComputerResult)computer.submit().get();
        Assert.assertTrue((boolean)result.memory().exists("degrees"));
        Map degrees = (Map)result.memory().get("degrees");
        Assert.assertNotNull((Object)degrees);
        Assert.assertEquals((long)numVertices, (long)degrees.size());
        IDManager idManager = this.graph.getIDManager();
        for (Map.Entry entry : degrees.entrySet()) {
            long vid = (Long)entry.getKey();
            Integer degree = (Integer)entry.getValue();
            if (idManager.isPartitionedVertex(vid)) {
                Assert.assertEquals(degreeMap.get(vid), (Object)degree);
                continue;
            }
            Assert.assertEquals((long)1L, (long)degree.intValue());
        }
    }

    @Test
    public void testVLabelOnOrderedStorage() {
        String label = "pl";
        this.mgmt.makeVertexLabel("pl").partition().make();
        this.mgmt.commit();
        this.graph.tx().rollback();
        this.graph.addVertex("pl");
        this.graph.tx().commit();
        this.mgmt = this.graph.openManagement();
        VertexLabel vl = this.mgmt.getVertexLabel("pl");
        Assert.assertTrue((boolean)vl.isPartitioned());
        this.mgmt.rollback();
    }

    @Test
    public void testKeybasedGraphPartitioning() {
        Object[] options = new Object[]{TitanPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), false, TitanPartitionGraphTest.option(VertexIDAssigner.PLACEMENT_STRATEGY, new String[0]), PropertyPlacementStrategy.class.getName(), TitanPartitionGraphTest.option(PropertyPlacementStrategy.PARTITION_KEY, new String[0]), "clusterId"};
        this.clopen(options);
        int[] groupDegrees = new int[]{5, 5, 5, 5, 5, 5, 5, 5};
        int numVertices = this.setupGroupClusters(groupDegrees, CommitMode.PER_VERTEX);
        IntHashSet partitionIds = new IntHashSet(numVertices);
        for (int i = 0; i < groupDegrees.length; ++i) {
            TitanVertex g = TitanPartitionGraphTest.getOnlyVertex(this.tx.query().has("groupid", (Object)("group" + i)));
            int partitionId = -1;
            for (TitanVertex v : g.query().direction(Direction.IN).labels(new String[]{"member"}).vertices()) {
                if (partitionId < 0) {
                    partitionId = this.getPartitionID(v);
                }
                Assert.assertEquals((long)partitionId, (long)this.getPartitionID(v));
                partitionIds.add(partitionId);
            }
        }
        Assert.assertTrue((partitionIds.size() > 4 ? 1 : 0) != 0);
    }

    public int getPartitionID(TitanVertex vertex) {
        long p = this.idManager.getPartitionId(vertex.longId());
        Assert.assertTrue((p >= 0L && p < this.idManager.getPartitionBound() && p < Integer.MAX_VALUE ? 1 : 0) != 0);
        return (int)p;
    }

    public int getPartitionID(TitanRelation relation) {
        long p = relation.longId() & this.idManager.getPartitionBound() - 1L;
        Assert.assertTrue((p >= 0L && p < this.idManager.getPartitionBound() && p < Integer.MAX_VALUE ? 1 : 0) != 0);
        return (int)p;
    }

    private static enum CommitMode {
        BATCH,
        PER_VERTEX,
        PER_CLUSTER;

    }
}

