/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.GroovySpeedTestSupport;
import com.thinkaurelius.titan.graphdb.util.ElementHelper;
import com.thinkaurelius.titan.testcategory.PerformanceTests;
import com.thinkaurelius.titan.testutil.JUnitBenchmarkProvider;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.invoke.CallSite;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@BenchmarkOptions(warmupRounds=1, benchmarkRounds=1)
@Category(value={PerformanceTests.class})
public abstract class TitanGraphSpeedTest
extends GroovySpeedTestSupport {
    private static final Logger log;
    @Rule
    public TestRule benchmark;
    private static final /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public TitanGraphSpeedTest(WriteConfiguration conf) throws BackendException {
        super(conf);
        CallSite callSite = IndyInterface.bootstrap("invoke", "get", 0, JUnitBenchmarkProvider.class);
        this.benchmark = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Test
    public void testVertexUidLookup() throws Exception {
        class _testVertexUidLookup_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testVertexUidLookup_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tx, Object vertex) {
                return IndyInterface.bootstrap("invoke", "assertNotNull", 0, Assert.class, vertex);
            }

            public Object call(Object tx, Object vertex) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, vertex);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testVertexUidLookup_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "sequentialUidTask", 2, this, new _testVertexUidLookup_closure1(this, this));
    }

    @Test
    public void testVertexCentricIndexQuery() {
        long maxUid = $const$0;
        long minUid = 1L;
        IndyInterface.bootstrap("invoke", "checkArgument", 0, Preconditions.class, ScriptBytecodeAdapter.compareLessThanEqual((Object)IndyInterface.bootstrap("invoke", "minus", 0, maxUid, minUid), (Object)IndyInterface.bootstrap("getProperty", "VERTEX_COUNT", 12, this)));
        class _testVertexCentricIndexQuery_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testVertexCentricIndexQuery_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object v, Object indexLabel, Object indexPK) {
                CallSite callSite;
                CallSite callSite2;
                CallSite callSite3;
                CallSite c = IndyInterface.bootstrap("invoke", "count", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "outE", 0, v, indexLabel), indexPK, IndyInterface.bootstrap("getProperty", "gte", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), 25), indexPK, IndyInterface.bootstrap("getProperty", "lt", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), 75));
                IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, 50, c);
                c = callSite3 = IndyInterface.bootstrap("invoke", "count", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "outE", 0, v, indexLabel), indexPK, IndyInterface.bootstrap("getProperty", "gte", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), 125), indexPK, IndyInterface.bootstrap("getProperty", "lt", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), 225));
                IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, 100, c);
                c = callSite2 = IndyInterface.bootstrap("invoke", "count", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "outE", 0, v, indexLabel), indexPK, IndyInterface.bootstrap("getProperty", "gte", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), 500), indexPK, IndyInterface.bootstrap("getProperty", "lt", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), 1000));
                IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, 500, c);
                c = callSite = IndyInterface.bootstrap("invoke", "count", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "outE", 0, v, indexLabel), indexPK, IndyInterface.bootstrap("getProperty", "gt", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), false), indexPK, IndyInterface.bootstrap("getProperty", "lt", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), 2));
                return IndyInterface.bootstrap("invoke", "assertEquals", 0, Assert.class, true, c);
            }

            public Object call(Object v, Object indexLabel, Object indexPK) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, v, indexLabel, indexPK);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testVertexCentricIndexQuery_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "supernodeTask", 2, this, new _testVertexCentricIndexQuery_closure2(this, this));
    }

    @Test
    public void testLabeledEdgeTraversal() {
        Reference i = new Reference((Object)0);
        class _testLabeledEdgeTraversal_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference i;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testLabeledEdgeTraversal_closure3(Object _outerInstance, Object _thisObject, Reference i) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.i = reference = i;
            }

            public Object doCall(Object v, Object indexLabel, Object indexPK) {
                Object object = this.i.get();
                this.i.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, object)));
                int start = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, 100, object));
                int end = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, start, 99));
                CallSite c = IndyInterface.bootstrap("invoke", "count", 0, IndyInterface.bootstrap("invoke", "outE", 0, IndyInterface.bootstrap("invoke", "inV", 0, IndyInterface.bootstrap("invoke", "outE", 0, IndyInterface.bootstrap("invoke", "inV", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "outE", 0, v, indexLabel), ScriptBytecodeAdapter.createRange((Object)start, (Object)end, (boolean)true))), indexLabel)), indexLabel));
                return IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, ScriptBytecodeAdapter.compareLessThan((Object)0, (Object)c));
            }

            public Object call(Object v, Object indexLabel, Object indexPK) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, v, indexLabel, indexPK);
            }

            public Integer getI() {
                return IndyInterface.bootstrap("cast", "()", 0, this.i.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testLabeledEdgeTraversal_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "supernodeTask", 2, this, new _testLabeledEdgeTraversal_closure3(this, this, i));
    }

    @Test
    public void testEdgeTraversalUsingVertexCentricIndex() {
        class _testEdgeTraversalUsingVertexCentricIndex_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testEdgeTraversalUsingVertexCentricIndex_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object v, Object label, Object pkey) {
                CallSite c = IndyInterface.bootstrap("invoke", "count", 0, IndyInterface.bootstrap("invoke", "outE", 0, IndyInterface.bootstrap("invoke", "inV", 0, IndyInterface.bootstrap("invoke", "outE", 0, IndyInterface.bootstrap("invoke", "inV", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "outE", 0, v, label), pkey, IndyInterface.bootstrap("getProperty", "gte", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), false), pkey, IndyInterface.bootstrap("getProperty", "lte", 0, IndyInterface.bootstrap("getProperty", "T", 12, this)), 100)), label)), label));
                return IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, ScriptBytecodeAdapter.compareLessThan((Object)0, (Object)c));
            }

            public Object call(Object v, Object label, Object pkey) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, v, label, pkey);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testEdgeTraversalUsingVertexCentricIndex_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "supernodeTask", 2, this, new _testEdgeTraversalUsingVertexCentricIndex_closure4(this, this));
    }

    @Test
    public void testLimitedGlobalEdgePropertyQuery() {
        class _testLimitedGlobalEdgePropertyQuery_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testLimitedGlobalEdgePropertyQuery_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tx, Object indexedPropName, Object indexedPropVal) {
                int n = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, Iterables.class, IndyInterface.bootstrap("invoke", "edges", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "limit", 0, IndyInterface.bootstrap("invoke", "query", 0, tx), true), indexedPropName, indexedPropVal))));
                IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, 0 <= n);
                return IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, n <= 1);
            }

            public Object call(Object tx, Object indexedPropName, Object indexedPropVal) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, indexedPropName, indexedPropVal);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testLimitedGlobalEdgePropertyQuery_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "standardIndexEdgeTask", 2, this, new _testLimitedGlobalEdgePropertyQuery_closure5(this, this));
    }

    @Test
    public void testLimitedGlobalVertexPropertyQuery() {
        class _testLimitedGlobalVertexPropertyQuery_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testLimitedGlobalVertexPropertyQuery_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tx, Object indexedPropName, Object indexedPropVal) {
                int n = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, Iterables.class, IndyInterface.bootstrap("invoke", "vertices", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "limit", 0, IndyInterface.bootstrap("invoke", "query", 0, tx), true), indexedPropName, indexedPropVal))));
                IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, 0 <= n);
                return IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, n <= 1);
            }

            public Object call(Object tx, Object indexedPropName, Object indexedPropVal) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, indexedPropName, indexedPropVal);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testLimitedGlobalVertexPropertyQuery_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "standardIndexVertexTask", 2, this, new _testLimitedGlobalVertexPropertyQuery_closure6(this, this));
    }

    @Test
    public void testGlobalVertexPropertyQuery() {
        class _testGlobalVertexPropertyQuery_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testGlobalVertexPropertyQuery_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tx, Object indexedPropName, Object indexedPropVal) {
                int n = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, Iterables.class, IndyInterface.bootstrap("invoke", "vertices", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "query", 0, tx), indexedPropName, indexedPropVal))));
                return IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, 0 < n);
            }

            public Object call(Object tx, Object indexedPropName, Object indexedPropVal) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, indexedPropName, indexedPropVal);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testGlobalVertexPropertyQuery_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "standardIndexVertexTask", 2, this, new _testGlobalVertexPropertyQuery_closure7(this, this));
    }

    @Test
    public void testGlobalEdgePropertyQuery() {
        class _testGlobalEdgePropertyQuery_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testGlobalEdgePropertyQuery_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tx, Object indexedPropName, Object indexedPropVal) {
                int n = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, Iterables.class, IndyInterface.bootstrap("invoke", "edges", 0, IndyInterface.bootstrap("invoke", "has", 0, IndyInterface.bootstrap("invoke", "query", 0, tx), indexedPropName, indexedPropVal))));
                return IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, 0 < n);
            }

            public Object call(Object tx, Object indexedPropName, Object indexedPropVal) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, indexedPropName, indexedPropVal);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testGlobalEdgePropertyQuery_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "standardIndexEdgeTask", 2, this, new _testGlobalEdgePropertyQuery_closure8(this, this));
    }

    @Test
    public void testMultiVertexQuery() {
        IndyInterface.bootstrap("invoke", "chunkedSequentialUidTask", 2, this, 50, 50, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"multiVertexQueryTask"));
    }

    @Test
    public void testPathologicalMultiVertexQuery() {
        IndyInterface.bootstrap("invoke", "chunkedSequentialUidTask", 2, this, true, 50, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"multiVertexQueryTask"));
    }

    @Test
    public void testSingleVertexQuery() {
        IndyInterface.bootstrap("invoke", "sequentialUidTask", 2, this, 50, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"singleVertexQueryTask"));
    }

    @Test
    public void testSingleVertexMultiProperty() {
        class _testSingleVertexMultiProperty_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testSingleVertexMultiProperty_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tx, Object v) {
                int c = 0;
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getVertexPropKeys", 0, IndyInterface.bootstrap("getProperty", "schema", 12, this)))) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "valueOrNull", 0, v, IndyInterface.bootstrap("invoke", "getVertexPropertyName", 0, IndyInterface.bootstrap("getProperty", "schema", 12, this), i)), null)) {
                        int n = c;
                        c = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                    }
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                }
                CallSite k = IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "getPropertyKeys", 0, ElementHelper.class, v), true);
                IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, k, "vs"), c), ScriptBytecodeAdapter.compareLessThanEqual((Object)k, (Object)c));
                return IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, 0 <= c);
            }

            public Object call(Object tx, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testSingleVertexMultiProperty_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "sequentialUidTask", 2, this, 50, new _testSingleVertexMultiProperty_closure9(this, this));
    }

    @Test
    public void testSingleVertexProperty() {
        class _testSingleVertexProperty_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testSingleVertexProperty_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tx, Object v) {
                return IndyInterface.bootstrap("invoke", "assertNotNull", 0, Assert.class, IndyInterface.bootstrap("invoke", "valueOrNull", 0, v, IndyInterface.bootstrap("getProperty", "UID_PROP", 0, IndyInterface.bootstrap("getProperty", "Schema", 12, this))));
            }

            public Object call(Object tx, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testSingleVertexProperty_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "sequentialUidTask", 2, this, 50, new _testSingleVertexProperty_closure10(this, this));
    }

    @Test
    public void testZVertexPropertyModification() {
        Reference propsModified = new Reference((Object)0);
        Reference visited = new Reference((Object)0);
        Reference n = new Reference((Object)314159);
        class _testZVertexPropertyModification_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference visited;
            private /* synthetic */ Reference propsModified;
            private /* synthetic */ Reference n;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testZVertexPropertyModification_closure11(Object _outerInstance, Object _thisObject, Reference visited, Reference propsModified, Reference n) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.visited = reference3 = visited;
                this.propsModified = reference2 = propsModified;
                this.n = reference = n;
            }

            public Object doCall(Object tx, Object vertex) {
                Object object = this.visited.get();
                this.visited.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, object)));
                Object p = null;
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "getPropertyKeys", 0, ElementHelper.class, IndyInterface.bootstrap("getProperty", "v", 12, this))));
                while (callSite.hasNext()) {
                    p = callSite.next();
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equals", 0, p, IndyInterface.bootstrap("getProperty", "UID_PROP", 0, IndyInterface.bootstrap("getProperty", "Schema", 12, this)))) != false) continue;
                    int old = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "valueOrNull", 0, vertex, p));
                    IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("invoke", "property", 0, vertex, p));
                    IndyInterface.bootstrap("invoke", "property", 0, vertex, p, IndyInterface.bootstrap("invoke", "multiply", 0, old, this.n.get()));
                    this.n.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "multiply", 0, this.n.get(), this.n.get())));
                    Object object2 = this.propsModified.get();
                    this.propsModified.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, object2)));
                    break;
                }
                return null;
            }

            public Object call(Object tx, Object vertex) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, vertex);
            }

            public Integer getVisited() {
                return IndyInterface.bootstrap("cast", "()", 0, this.visited.get());
            }

            public Integer getPropsModified() {
                return IndyInterface.bootstrap("cast", "()", 0, this.propsModified.get());
            }

            public Integer getN() {
                return IndyInterface.bootstrap("cast", "()", 0, this.n.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testZVertexPropertyModification_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "sequentialUidTask", 2, this, new _testZVertexPropertyModification_closure11(this, this, visited, propsModified, n));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, ScriptBytecodeAdapter.compareLessThan((Object)0, (Object)((Integer)propsModified.get())));
    }

    @Test
    public void testZEdgeAddition() {
        Reference edgesAdded = new Reference((Object)0);
        Reference skipped = new Reference((Object)0);
        Reference last = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, Integer.valueOf(-1)));
        Reference labelName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getEdgeLabelName", 0, IndyInterface.bootstrap("getProperty", "schema", 12, this), false)));
        class _testZEdgeAddition_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference last;
            private /* synthetic */ Reference edgesAdded;
            private /* synthetic */ Reference labelName;
            private /* synthetic */ Reference skipped;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _testZEdgeAddition_closure12(Object _outerInstance, Object _thisObject, Reference last, Reference edgesAdded, Reference labelName, Reference skipped) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.last = reference4 = last;
                this.edgesAdded = reference3 = edgesAdded;
                this.labelName = reference2 = labelName;
                this.skipped = reference = skipped;
            }

            public Object doCall(Object tx, Object vertex) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)-1, (Object)this.last.get()) && ScriptBytecodeAdapter.compareNotEqual((Object)this.last.get(), (Object)IndyInterface.bootstrap("invoke", "id", 0, vertex))) {
                    CallSite target = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "v", 0, tx, this.last.get()));
                    IndyInterface.bootstrap("invoke", "addEdge", 0, vertex, this.labelName.get(), target);
                    Object object = this.edgesAdded.get();
                    this.edgesAdded.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, object)));
                } else {
                    Object object = this.skipped.get();
                    this.skipped.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, object)));
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "id", 0, vertex);
                this.last.set((Object)IndyInterface.bootstrap("cast", "()", 0, callSite));
                return callSite;
            }

            public Object call(Object tx, Object vertex) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tx, vertex);
            }

            public Long getLast() {
                return IndyInterface.bootstrap("cast", "()", 0, this.last.get());
            }

            public Integer getEdgesAdded() {
                return IndyInterface.bootstrap("cast", "()", 0, this.edgesAdded.get());
            }

            public String getLabelName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.labelName.get());
            }

            public Integer getSkipped() {
                return IndyInterface.bootstrap("cast", "()", 0, this.skipped.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testZEdgeAddition_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        IndyInterface.bootstrap("invoke", "sequentialUidTask", 2, this, new _testZEdgeAddition_closure12(this, this, last, edgesAdded, labelName, skipped));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, ScriptBytecodeAdapter.compareLessThan((Object)0, (Object)IndyInterface.bootstrap("invoke", "plus", 0, (Integer)edgesAdded.get(), (Integer)skipped.get())));
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, ScriptBytecodeAdapter.compareGreaterThan((Object)((Integer)edgesAdded.get()), (Object)((Integer)skipped.get())));
    }

    @Test
    public void testNoop() {
        IndyInterface.bootstrap("invoke", "debug", 0, log, "Noop test executed");
    }

    private void multiVertexQueryTask(TitanTransaction tx, TitanVertex[] vbuf, int vcount) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)vcount, (Object)IndyInterface.bootstrap("getProperty", "length", 0, vbuf))) {
            TitanVertex[] newbuf = new TitanVertex[vcount];
            int i = 0;
            while (i < vcount) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, vbuf, i);
                IndyInterface.bootstrap("invoke", "putAt", 0, newbuf, i, callSite);
                IndyInterface.bootstrap("invoke", "checkArgument", 0, Preconditions.class, ScriptBytecodeAdapter.compareNotEqual(null, (Object)IndyInterface.bootstrap("invoke", "getAt", 0, newbuf, i)));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            }
            TitanVertex[] titanVertexArray = newbuf;
            vbuf = IndyInterface.bootstrap("cast", "()", 0, titanVertexArray);
        }
        int n = 0;
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("getProperty", "edgeLabels", 4, IndyInterface.bootstrap("getProperty", "schema", 12, this)))) {
            CallSite m = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "edges", 0, IndyInterface.bootstrap("invoke", "labels", 0, IndyInterface.bootstrap("invoke", "multiQuery", 0, tx, vbuf), IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "edgeLabelNames", 4, IndyInterface.bootstrap("getProperty", "schema", 12, this)), i))));
            CallSite iter = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "values", 0, m)));
            while (callSite.hasNext()) {
                iter = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite e = null;
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, iter));
                while (callSite2.hasNext()) {
                    e = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                    int n2 = n;
                    n = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n2));
                }
            }
            int n3 = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n3));
        }
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, 0 < n);
    }

    private void singleVertexQueryTask(TitanTransaction tx, TitanVertex v) {
        int n = 0;
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("getProperty", "edgeLabels", 4, IndyInterface.bootstrap("getProperty", "schema", 12, this)))) {
            CallSite iter = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "edges", 0, IndyInterface.bootstrap("invoke", "labels", 0, IndyInterface.bootstrap("invoke", "query", 0, v), IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "edgeLabelNames", 4, IndyInterface.bootstrap("getProperty", "schema", 12, this)), i)))));
            while (callSite.hasNext()) {
                iter = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                int n2 = n;
                n = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n2));
            }
            int n3 = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n3));
        }
        IndyInterface.bootstrap("invoke", "assertTrue", 0, Assert.class, 0 < n);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TitanGraphSpeedTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        $const$0 = l = 1000L;
    }

    static {
        TitanGraphSpeedTest.__$swapInit();
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, TitanGraphSpeedTest.class);
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

