/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan;

import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.LongObjectMap;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.Nullable;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class TestByteBuffer {
    private static final int NUM = 1000;
    private static final double FRACTION = 0.2;
    private static final int ROUNDSIZE = 5;
    private static final int TRIALS = 5;
    private static final boolean CHECK_VALUE = true;
    private static final Random random = new Random();

    public static void main(String[] args) {
        SummaryStatistics statObject = new SummaryStatistics();
        SummaryStatistics statByte = new SummaryStatistics();
        for (int i = 0; i < 10; ++i) {
            statByte.addValue((double)TestByteBuffer.testByte());
            statObject.addValue((double)TestByteBuffer.testObject());
        }
        System.out.println("Time (ms) Object: " + statObject.getMean() + " | " + statObject.getStandardDeviation());
        System.out.println("Time (ms) Byte: " + statByte.getMean() + " | " + statByte.getStandardDeviation());
    }

    private static long testObject() {
        int i;
        EdgeVertex[] vertices = new EdgeVertex[1000];
        for (i = 0; i < 1000; ++i) {
            vertices[i] = new EdgeVertex(i);
        }
        for (i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
                if (i == j || !(Math.random() < 0.2)) continue;
                Edge e = new Edge(vertices[i], "connect", vertices[j]);
                e.setProperty("number", random.nextInt(5));
                vertices[i].addOutEdge(e);
            }
        }
        long time = System.currentTimeMillis();
        long sum = 0L;
        for (int t = 0; t < 5; ++t) {
            for (int i2 = 0; i2 < 1000; ++i2) {
                for (Vertex v : vertices[i2].getNeighbors(0)) {
                    sum += v.getId();
                }
            }
        }
        time = System.currentTimeMillis() - time;
        return time;
    }

    private static long testByte() {
        int i;
        LongObjectHashMap tx = new LongObjectHashMap(1000);
        for (i = 0; i < 1000; ++i) {
            tx.put((long)i, new ConcurrentSkipListSet());
        }
        for (i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
                if (i == j || !(Math.random() < 0.2)) continue;
                ByteBuffer key = ByteBuffer.allocate(16);
                key.putLong(5L).putLong(j).flip();
                ByteBuffer value = ByteBuffer.allocate(4);
                value.putInt(random.nextInt(5)).flip();
                ((ConcurrentSkipListSet)tx.get((long)i)).add(new ByteEntry(key, value));
            }
        }
        long time = System.currentTimeMillis();
        long sum = 0L;
        for (int t = 0; t < 5; ++t) {
            for (int i2 = 0; i2 < 1000; ++i2) {
                for (Vertex v : new ByteVertex(i2, (LongObjectMap<ConcurrentSkipListSet<ByteEntry>>)tx).getNeighbors(0)) {
                    sum += v.getId();
                }
            }
        }
        time = System.currentTimeMillis() - time;
        return time;
    }

    static class ByteEntry
    implements Comparable<ByteEntry> {
        final ByteBuffer key;
        final ByteBuffer value;

        ByteEntry(ByteBuffer key, ByteBuffer value) {
            this.value = value;
            this.key = key;
        }

        @Override
        public int compareTo(ByteEntry byteEntry) {
            return this.key.compareTo(byteEntry.key);
        }
    }

    static class Edge {
        private final Vertex start;
        private final Vertex end;
        private final String label;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        Edge(Vertex start, String label, Vertex end) {
            this.label = label;
            this.end = end;
            this.start = start;
        }

        public String getLabel() {
            return this.label;
        }

        void setProperty(String key, Object value) {
            this.properties.put(key, value);
        }

        public Object getProperty(String key) {
            return this.properties.get(key);
        }

        public Vertex getStart() {
            return this.start;
        }

        public Vertex getEnd() {
            return this.end;
        }

        public Vertex getOther(Vertex v) {
            if (this.start.equals(v)) {
                return this.end;
            }
            if (this.end.equals(v)) {
                return this.start;
            }
            throw new IllegalArgumentException();
        }
    }

    static class ByteVertex
    extends Vertex {
        private final LongObjectMap<ConcurrentSkipListSet<ByteEntry>> tx;
        private final SortedSet<ByteEntry> set;

        ByteVertex(long id, LongObjectMap<ConcurrentSkipListSet<ByteEntry>> tx) {
            super(id);
            this.tx = tx;
            this.set = (SortedSet)tx.get(id);
        }

        @Override
        public Iterable<Vertex> getNeighbors(final int value) {
            return Iterables.transform((Iterable)Iterables.filter(this.set, (Predicate)new Predicate<ByteEntry>(){

                public boolean apply(@Nullable ByteEntry entry) {
                    return entry.value.getInt(0) == value;
                }
            }), (Function)new Function<ByteEntry, Vertex>(){

                public Vertex apply(@Nullable ByteEntry entry) {
                    return new ByteVertex(entry.key.getLong(8), (LongObjectMap<ConcurrentSkipListSet<ByteEntry>>)tx);
                }
            });
        }
    }

    static class EdgeVertex
    extends Vertex {
        private SortedSet<Edge> outEdges = new ConcurrentSkipListSet<Edge>(new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                return e1.getEnd().compareTo(e2.getEnd());
            }
        });

        EdgeVertex(long id) {
            super(id);
        }

        @Override
        public Iterable<Vertex> getNeighbors(final int value) {
            return Iterables.transform((Iterable)Iterables.filter(this.outEdges, (Predicate)new Predicate<Edge>(){

                public boolean apply(@Nullable Edge edge) {
                    return (Integer)edge.getProperty("number") == value;
                }
            }), (Function)new Function<Edge, Vertex>(){

                public Vertex apply(@Nullable Edge edge) {
                    return edge.getEnd();
                }
            });
        }

        void addOutEdge(Edge e) {
            this.outEdges.add(e);
        }
    }

    static abstract class Vertex
    implements Comparable<Vertex> {
        protected final long id;

        Vertex(long id) {
            this.id = id;
        }

        @Override
        public int compareTo(Vertex vertex) {
            return Long.valueOf(this.id).compareTo(vertex.id);
        }

        public long getId() {
            return this.id;
        }

        public abstract Iterable<Vertex> getNeighbors(int var1);
    }
}

