/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.hbase;

import com.thinkaurelius.titan.diskstorage.hbase.AdminMask;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAdmin0_96
implements AdminMask {
    private static final Logger log = LoggerFactory.getLogger(HBaseAdmin0_96.class);
    private final HBaseAdmin adm;

    public HBaseAdmin0_96(HBaseAdmin adm) {
        this.adm = adm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTable(String tableName, long timestamp) throws IOException {
        if (!this.adm.tableExists(tableName)) {
            log.debug("clearStorage() called before table {} was created, skipping.", (Object)tableName);
            return;
        }
        HTable table = null;
        try {
            table = new HTable(this.adm.getConfiguration(), tableName);
            Scan scan = new Scan();
            scan.setBatch(100);
            scan.setCacheBlocks(false);
            scan.setCaching(2000);
            scan.setTimeRange(0L, Long.MAX_VALUE);
            scan.setMaxVersions(1);
            ResultScanner scanner = null;
            try {
                scanner = table.getScanner(scan);
                for (Result res : scanner) {
                    Delete d = new Delete(res.getRow());
                    d.setTimestamp(timestamp);
                    table.delete(d);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)scanner);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(table);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)table);
    }

    @Override
    public HTableDescriptor getTableDescriptor(String tableName) throws TableNotFoundException, IOException {
        return this.adm.getTableDescriptor(tableName.getBytes());
    }

    @Override
    public boolean tableExists(String tableName) throws IOException {
        return this.adm.tableExists(tableName);
    }

    @Override
    public void createTable(HTableDescriptor desc) throws IOException {
        this.adm.createTable(desc);
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.adm.createTable(desc, startKey, endKey, numRegions);
    }

    @Override
    public int getEstimatedRegionServerCount() {
        int serverCount = -1;
        try {
            serverCount = this.adm.getClusterStatus().getServers().size();
            log.debug("Read {} servers from HBase ClusterStatus", (Object)serverCount);
        }
        catch (IOException e) {
            log.debug("Unable to retrieve HBase cluster status", (Throwable)e);
        }
        return serverCount;
    }

    @Override
    public void disableTable(String tableName) throws IOException {
        this.adm.disableTable(tableName);
    }

    @Override
    public void enableTable(String tableName) throws IOException {
        this.adm.enableTable(tableName);
    }

    @Override
    public boolean isTableDisabled(String tableName) throws IOException {
        return this.adm.isTableDisabled(tableName);
    }

    @Override
    public void addColumn(String tableName, HColumnDescriptor columnDescriptor) throws IOException {
        this.adm.addColumn(tableName, columnDescriptor);
    }

    @Override
    public void close() throws IOException {
        this.adm.close();
    }
}

