/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.hbase;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.hbase.ConnectionMask;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseStoreManager;
import com.thinkaurelius.titan.diskstorage.hbase.TableMask;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVSUtil;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntryList;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseKeyColumnValueStore
implements KeyColumnValueStore {
    private static final Logger logger = LoggerFactory.getLogger(HBaseKeyColumnValueStore.class);
    private final String tableName;
    private final HBaseStoreManager storeManager;
    private final String storeName;
    private final byte[] columnFamilyBytes;
    private final HBaseGetter entryGetter;
    private final ConnectionMask cnx;

    HBaseKeyColumnValueStore(HBaseStoreManager storeManager, ConnectionMask cnx, String tableName, String columnFamily, String storeName) {
        this.storeManager = storeManager;
        this.cnx = cnx;
        this.tableName = tableName;
        this.storeName = storeName;
        this.columnFamilyBytes = columnFamily.getBytes();
        this.entryGetter = new HBaseGetter(storeManager.getMetaDataSchema(storeName));
    }

    public void close() throws BackendException {
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        Map<StaticBuffer, EntryList> result = this.getHelper(Arrays.asList(query.getKey()), HBaseKeyColumnValueStore.getFilter((SliceQuery)query));
        return (EntryList)Iterables.getOnlyElement(result.values(), (Object)EntryList.EMPTY_LIST);
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        return this.getHelper(keys, HBaseKeyColumnValueStore.getFilter(query));
    }

    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        ImmutableMap mutations = ImmutableMap.of((Object)key, (Object)new KCVMutation(additions, deletions));
        this.mutateMany((Map<StaticBuffer, KCVMutation>)mutations, txh);
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws BackendException {
        return this.executeKeySliceQuery((byte[])query.getKeyStart().as(StaticBuffer.ARRAY_FACTORY), (byte[])query.getKeyEnd().as(StaticBuffer.ARRAY_FACTORY), new FilterList(FilterList.Operator.MUST_PASS_ALL), (SliceQuery)query);
    }

    public String getName() {
        return this.storeName;
    }

    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws BackendException {
        return this.executeKeySliceQuery(new FilterList(FilterList.Operator.MUST_PASS_ALL), query);
    }

    public static Filter getFilter(SliceQuery query) {
        byte[] colStartBytes = query.getSliceStart().length() > 0 ? (byte[])query.getSliceStart().as(StaticBuffer.ARRAY_FACTORY) : null;
        byte[] colEndBytes = query.getSliceEnd().length() > 0 ? (byte[])query.getSliceEnd().as(StaticBuffer.ARRAY_FACTORY) : null;
        ColumnRangeFilter filter = new ColumnRangeFilter(colStartBytes, true, colEndBytes, false);
        if (query.hasLimit()) {
            filter = new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{filter, new ColumnPaginationFilter(query.getLimit(), 0)});
        }
        logger.debug("Generated HBase Filter {}", (Object)filter);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<StaticBuffer, EntryList> getHelper(List<StaticBuffer> keys, Filter getFilter) throws BackendException {
        ArrayList<Get> requests = new ArrayList<Get>(keys.size());
        for (StaticBuffer key : keys) {
            Get g = new Get((byte[])key.as(StaticBuffer.ARRAY_FACTORY)).addFamily(this.columnFamilyBytes).setFilter(getFilter);
            try {
                g.setTimeRange(0L, Long.MAX_VALUE);
            }
            catch (IOException e) {
                throw new PermanentBackendException((Throwable)e);
            }
            requests.add(g);
        }
        HashMap<StaticBuffer, EntryList> resultMap = new HashMap<StaticBuffer, EntryList>(keys.size());
        try {
            TableMask table = null;
            Result[] results = null;
            try {
                table = this.cnx.getTable(this.tableName);
                results = table.get(requests);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(table);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)table);
            if (results == null) {
                return KCVSUtil.emptyResults(keys);
            }
            assert (results.length == keys.size());
            for (int i = 0; i < results.length; ++i) {
                Result result = results[i];
                NavigableMap f = result.getMap();
                if (f == null) {
                    resultMap.put(keys.get(i), (EntryList)EntryList.EMPTY_LIST);
                    continue;
                }
                NavigableMap r = (NavigableMap)f.get(this.columnFamilyBytes);
                resultMap.put(keys.get(i), (EntryList)(r == null ? EntryList.EMPTY_LIST : StaticArrayEntryList.ofBytes(r.entrySet(), (StaticArrayEntry.GetColVal)this.entryGetter)));
            }
            return resultMap;
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
    }

    private void mutateMany(Map<StaticBuffer, KCVMutation> mutations, StoreTransaction txh) throws BackendException {
        this.storeManager.mutateMany((Map<String, Map<StaticBuffer, KCVMutation>>)ImmutableMap.of((Object)this.storeName, mutations), txh);
    }

    private KeyIterator executeKeySliceQuery(FilterList filters, @Nullable SliceQuery columnSlice) throws BackendException {
        return this.executeKeySliceQuery(null, null, filters, columnSlice);
    }

    private KeyIterator executeKeySliceQuery(@Nullable byte[] startKey, @Nullable byte[] endKey, FilterList filters, @Nullable SliceQuery columnSlice) throws BackendException {
        Scan scan = new Scan().addFamily(this.columnFamilyBytes);
        try {
            scan.setTimeRange(0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        if (startKey != null) {
            scan.setStartRow(startKey);
        }
        if (endKey != null) {
            scan.setStopRow(endKey);
        }
        if (columnSlice != null) {
            filters.addFilter(HBaseKeyColumnValueStore.getFilter(columnSlice));
        }
        TableMask table = null;
        try {
            table = this.cnx.getTable(this.tableName);
            return new RowIterator(table, table.getScanner(scan.setFilter((Filter)filters)), this.columnFamilyBytes);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(table);
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private static class HBaseGetter
    implements StaticArrayEntry.GetColVal<Map.Entry<byte[], NavigableMap<Long, byte[]>>, byte[]> {
        private final EntryMetaData[] schema;

        private HBaseGetter(EntryMetaData[] schema) {
            this.schema = schema;
        }

        public byte[] getColumn(Map.Entry<byte[], NavigableMap<Long, byte[]>> element) {
            return element.getKey();
        }

        public byte[] getValue(Map.Entry<byte[], NavigableMap<Long, byte[]>> element) {
            return element.getValue().lastEntry().getValue();
        }

        public EntryMetaData[] getMetaSchema(Map.Entry<byte[], NavigableMap<Long, byte[]>> element) {
            return this.schema;
        }

        public Object getMetaData(Map.Entry<byte[], NavigableMap<Long, byte[]>> element, EntryMetaData meta) {
            switch (meta) {
                case TIMESTAMP: {
                    return element.getValue().lastEntry().getKey();
                }
            }
            throw new UnsupportedOperationException("Unsupported meta data: " + meta);
        }
    }

    private class RowIterator
    implements KeyIterator {
        private final Closeable table;
        private final Iterator<Result> rows;
        private final byte[] columnFamilyBytes;
        private Result currentRow;
        private boolean isClosed;

        public RowIterator(Closeable table, ResultScanner rows, byte[] columnFamilyBytes) {
            this.table = table;
            this.columnFamilyBytes = Arrays.copyOf(columnFamilyBytes, columnFamilyBytes.length);
            this.rows = Iterators.filter((Iterator)rows.iterator(), result -> null != result && null != result.getRow());
        }

        public RecordIterator<Entry> getEntries() {
            this.ensureOpen();
            return new RecordIterator<Entry>(){
                private final Iterator<Map.Entry<byte[], NavigableMap<Long, byte[]>>> kv;
                {
                    this.kv = ((NavigableMap)RowIterator.this.currentRow.getMap().get(RowIterator.this.columnFamilyBytes)).entrySet().iterator();
                }

                public boolean hasNext() {
                    RowIterator.this.ensureOpen();
                    return this.kv.hasNext();
                }

                public Entry next() {
                    RowIterator.this.ensureOpen();
                    return StaticArrayEntry.ofBytes(this.kv.next(), (StaticArrayEntry.GetColVal)HBaseKeyColumnValueStore.this.entryGetter);
                }

                public void close() {
                    RowIterator.this.isClosed = true;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean hasNext() {
            this.ensureOpen();
            return this.rows.hasNext();
        }

        public StaticBuffer next() {
            this.ensureOpen();
            this.currentRow = this.rows.next();
            return StaticArrayBuffer.of((byte[])this.currentRow.getRow());
        }

        public void close() {
            IOUtils.closeQuietly((Closeable)this.table);
            this.isClosed = true;
            logger.debug("RowIterator closed table {}", (Object)this.table);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void ensureOpen() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed.");
            }
        }
    }
}

