/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.compat.h1;

import com.thinkaurelius.titan.hadoop.config.job.AbstractDistCacheConfigurer;
import com.thinkaurelius.titan.hadoop.config.job.JobClasspathConfigurer;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;

public class DistCacheConfigurer
extends AbstractDistCacheConfigurer
implements JobClasspathConfigurer {
    public DistCacheConfigurer(String mapredJarFilename) {
        super(mapredJarFilename);
    }

    @Override
    public void configure(Job job) throws IOException {
        for (Path p : this.getLocalPaths()) {
            Configuration conf = job.getConfiguration();
            FileSystem jobFS = FileSystem.get((Configuration)conf);
            LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
            Path stagedPath = this.uploadFileIfNecessary((FileSystem)localFS, p, jobFS);
            DistributedCache.addFileToClassPath((Path)stagedPath, (Configuration)conf, (FileSystem)jobFS);
        }
        String mj = this.getMapredJar();
        if (null != mj) {
            job.getConfiguration().set("mapred.jar", mj);
        }
    }
}

