/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.embedded.CassandraEmbeddedStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.thrift.CassandraThriftStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.olap.job.IndexRemoveJob;
import com.thinkaurelius.titan.graphdb.olap.job.IndexRepairJob;
import com.thinkaurelius.titan.graphdb.olap.job.IndexUpdateJob;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.cassandra.CassandraBinaryInputFormat;
import com.thinkaurelius.titan.hadoop.formats.hbase.HBaseBinaryInputFormat;
import com.thinkaurelius.titan.hadoop.scan.HadoopScanMapper;
import com.thinkaurelius.titan.hadoop.scan.HadoopScanRunner;
import com.thinkaurelius.titan.hadoop.scan.HadoopVertexScanMapper;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceIndexManagement {
    private static final Logger log = LoggerFactory.getLogger(MapReduceIndexManagement.class);
    private final StandardTitanGraph graph;
    private static final EnumSet<SchemaAction> SUPPORTED_ACTIONS = EnumSet.of(SchemaAction.REINDEX, SchemaAction.REMOVE_INDEX);
    private static final String SUPPORTED_ACTIONS_STRING = Joiner.on((String)", ").join(SUPPORTED_ACTIONS);
    private static final Set<Class<? extends KeyColumnValueStoreManager>> CASSANDRA_STORE_MANAGER_CLASSES = ImmutableSet.of(CassandraEmbeddedStoreManager.class, AstyanaxStoreManager.class, CassandraThriftStoreManager.class);
    private static final Set<Class<? extends KeyColumnValueStoreManager>> HBASE_STORE_MANAGER_CLASSES = ImmutableSet.of(HBaseStoreManager.class);

    public MapReduceIndexManagement(TitanGraph g) {
        this.graph = (StandardTitanGraph)g;
    }

    public TitanManagement.IndexJobFuture updateIndex(TitanIndex index, SchemaAction updateAction) throws BackendException {
        Class inputFormat;
        String readCF;
        Class mapperClass;
        Class<IndexRepairJob> indexJobClass;
        Preconditions.checkNotNull((Object)index, (String)"Index parameter must not be null", (Object[])new Object[]{index});
        Preconditions.checkNotNull((Object)updateAction, (String)"%s parameter must not be null", (Object[])new Object[]{SchemaAction.class.getSimpleName()});
        Preconditions.checkArgument((boolean)SUPPORTED_ACTIONS.contains(updateAction), (String)"Only these %s parameters are supported: %s (was given %s)", (Object[])new Object[]{SchemaAction.class.getSimpleName(), SUPPORTED_ACTIONS_STRING, updateAction});
        Preconditions.checkArgument((RelationTypeIndex.class.isAssignableFrom(index.getClass()) || TitanGraphIndex.class.isAssignableFrom(index.getClass()) ? 1 : 0) != 0, (String)"Index %s has class %s: must be a %s or %s (or subtype)", (Object[])new Object[]{index.getClass(), RelationTypeIndex.class.getSimpleName(), TitanGraphIndex.class.getSimpleName()});
        Configuration hadoopConf = new Configuration();
        ModifiableHadoopConfiguration titanmrConf = ModifiableHadoopConfiguration.of(TitanHadoopConfiguration.MAPRED_NS, hadoopConf);
        if (updateAction.equals((Object)SchemaAction.REINDEX)) {
            indexJobClass = IndexRepairJob.class;
            mapperClass = HadoopVertexScanMapper.class;
        } else if (updateAction.equals((Object)SchemaAction.REMOVE_INDEX)) {
            indexJobClass = IndexRemoveJob.class;
            mapperClass = HadoopScanMapper.class;
        } else {
            throw new IllegalStateException("Unrecognized " + SchemaAction.class.getSimpleName() + ": " + updateAction);
        }
        if (RelationTypeIndex.class.isAssignableFrom(index.getClass())) {
            readCF = "edgestore";
        } else {
            TitanGraphIndex gindex = (TitanGraphIndex)index;
            if (gindex.isMixedIndex() && !updateAction.equals((Object)SchemaAction.REINDEX)) {
                throw new UnsupportedOperationException("External mixed indexes must be removed in the indexing system directly.");
            }
            Preconditions.checkState((boolean)TitanGraphIndex.class.isAssignableFrom(index.getClass()));
            readCF = updateAction.equals((Object)SchemaAction.REMOVE_INDEX) ? "graphindex" : "edgestore";
        }
        titanmrConf.set(TitanHadoopConfiguration.COLUMN_FAMILY_NAME, readCF, new String[0]);
        Class storeManagerClass = this.graph.getBackend().getStoreManagerClass();
        if (CASSANDRA_STORE_MANAGER_CLASSES.contains(storeManagerClass)) {
            inputFormat = CassandraBinaryInputFormat.class;
            IPartitioner part = ((AbstractCassandraStoreManager)this.graph.getBackend().getStoreManager()).getCassandraPartitioner();
            hadoopConf.set("cassandra.input.partitioner.class", part.getClass().getName());
        } else if (HBASE_STORE_MANAGER_CLASSES.contains(storeManagerClass)) {
            inputFormat = HBaseBinaryInputFormat.class;
        } else {
            throw new IllegalArgumentException("Store manager class " + storeManagerClass + "is not supported");
        }
        String indexName = index.name();
        String relationTypeName = RelationTypeIndex.class.isAssignableFrom(index.getClass()) ? ((RelationTypeIndex)index).getType().name() : "";
        Preconditions.checkNotNull((Object)indexName);
        titanmrConf.set(TitanHadoopConfiguration.SCAN_JOB_CLASS, indexJobClass.getName(), new String[0]);
        MapReduceIndexManagement.copyIndexJobKeys(hadoopConf, indexName, relationTypeName);
        titanmrConf.set(TitanHadoopConfiguration.SCAN_JOB_CONFIG_ROOT, GraphDatabaseConfiguration.class.getName() + "#JOB_NS", new String[0]);
        org.apache.commons.configuration.Configuration localbc = this.graph.getConfiguration().getLocalConfiguration();
        localbc.clearProperty("gremlin.graph");
        MapReduceIndexManagement.copyInputKeys(hadoopConf, localbc);
        String jobName = HadoopScanMapper.class.getSimpleName() + "[" + indexJobClass.getSimpleName() + "]";
        try {
            return new CompletedJobFuture(HadoopScanRunner.runJob(hadoopConf, inputFormat, jobName, mapperClass));
        }
        catch (Exception e) {
            return new FailedJobFuture(e);
        }
    }

    private static void copyInputKeys(Configuration hadoopConf, org.apache.commons.configuration.Configuration source) {
        Iterator keyIter = source.getKeys();
        while (keyIter.hasNext()) {
            ConfigElement.PathIdentifier pid;
            String key = (String)keyIter.next();
            try {
                pid = ConfigElement.parse((ConfigNamespace)GraphDatabaseConfiguration.ROOT_NS, (String)key);
            }
            catch (RuntimeException e) {
                log.debug("[inputkeys] Skipping {}", (Object)key, (Object)e);
                continue;
            }
            if (!pid.element.isOption()) continue;
            String k = ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + "." + key;
            String v = source.getProperty(key).toString();
            hadoopConf.set(k, v);
            log.debug("[inputkeys] Set {}={}", (Object)k, (Object)v);
        }
    }

    private static void copyIndexJobKeys(Configuration hadoopConf, String indexName, String relationType) {
        hadoopConf.set(ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.SCAN_JOB_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + "." + ConfigElement.getPath((ConfigElement)IndexUpdateJob.INDEX_NAME, (String[])new String[0]), indexName);
        hadoopConf.set(ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.SCAN_JOB_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + "." + ConfigElement.getPath((ConfigElement)IndexUpdateJob.INDEX_RELATION_TYPE, (String[])new String[0]), relationType);
        hadoopConf.set(ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.SCAN_JOB_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + "." + ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.JOB_START_TIME, (String[])new String[0]), String.valueOf(System.currentTimeMillis()));
    }

    private static class FailedJobFuture
    implements TitanManagement.IndexJobFuture {
        private final Throwable cause;

        public FailedJobFuture(Throwable cause) {
            this.cause = cause;
        }

        public ScanMetrics getIntermediateResult() throws ExecutionException {
            throw new ExecutionException(this.cause);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public ScanMetrics get() throws InterruptedException, ExecutionException {
            throw new ExecutionException(this.cause);
        }

        public ScanMetrics get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new ExecutionException(this.cause);
        }
    }

    private static class CompletedJobFuture
    implements TitanManagement.IndexJobFuture {
        private final ScanMetrics completedJobMetrics;

        private CompletedJobFuture(ScanMetrics completedJobMetrics) {
            this.completedJobMetrics = completedJobMetrics;
        }

        public ScanMetrics getIntermediateResult() {
            return this.completedJobMetrics;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public ScanMetrics get() throws InterruptedException, ExecutionException {
            return this.completedJobMetrics;
        }

        public ScanMetrics get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.completedJobMetrics;
        }
    }
}

