/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.hadoop.formats.util.GiraphRecordReader;
import com.thinkaurelius.titan.hadoop.formats.util.TitanVertexDeserializer;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetup;
import com.thinkaurelius.titan.util.system.ConfigurationUtil;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;

public abstract class GiraphInputFormat
extends InputFormat<NullWritable, VertexWritable>
implements Configurable {
    private final InputFormat<StaticBuffer, Iterable<Entry>> inputFormat;
    private static final RefCountedCloseable<TitanVertexDeserializer> refCounter = new RefCountedCloseable(conf -> {
        String titanVersion = "current";
        String className = "com.thinkaurelius.titan.hadoop.formats.util.input.current.TitanHadoopSetupImpl";
        TitanHadoopSetup ts = (TitanHadoopSetup)ConfigurationUtil.instantiate((String)className, (Object[])new Object[]{conf}, (Class[])new Class[]{Configuration.class});
        return new TitanVertexDeserializer(ts);
    });

    public GiraphInputFormat(InputFormat<StaticBuffer, Iterable<Entry>> inputFormat) {
        this.inputFormat = inputFormat;
        Preconditions.checkState((boolean)Configurable.class.isAssignableFrom(inputFormat.getClass()));
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        return this.inputFormat.getSplits(context);
    }

    public RecordReader<NullWritable, VertexWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new GiraphRecordReader(refCounter, (RecordReader<StaticBuffer, Iterable<Entry>>)this.inputFormat.createRecordReader(split, context));
    }

    public void setConf(Configuration conf) {
        ((Configurable)this.inputFormat).setConf(conf);
        refCounter.setBuilderConfiguration(conf);
    }

    public Configuration getConf() {
        return ((Configurable)this.inputFormat).getConf();
    }

    public static class RefCountedCloseable<T extends AutoCloseable> {
        private T current;
        private long refCount;
        private final Function<Configuration, T> builder;
        private Configuration configuration;

        public RefCountedCloseable(Function<Configuration, T> builder) {
            this.builder = builder;
        }

        public synchronized void setBuilderConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public synchronized T acquire() {
            if (null == this.current) {
                Preconditions.checkState((0L == this.refCount ? 1 : 0) != 0);
                this.current = (AutoCloseable)this.builder.apply((Object)this.configuration);
            }
            ++this.refCount;
            return this.current;
        }

        public synchronized void release() throws Exception {
            Preconditions.checkState((null != this.current ? 1 : 0) != 0);
            Preconditions.checkState((0L < this.refCount ? 1 : 0) != 0);
            --this.refCount;
            if (0L == this.refCount) {
                this.current.close();
                this.current = null;
            }
        }
    }
}

