/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats;

import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanH1RecordWriter
extends RecordWriter<NullWritable, VertexWritable> {
    private static final Logger log = LoggerFactory.getLogger(TitanH1RecordWriter.class);
    private final TaskAttemptContext taskAttemptContext;
    private final StandardTitanTx tx;
    private final Set<String> persistableKeys;

    public TitanH1RecordWriter(TaskAttemptContext taskAttemptContext, StandardTitanTx tx, Set<String> persistableKeys) {
        this.taskAttemptContext = taskAttemptContext;
        this.tx = tx;
        this.persistableKeys = persistableKeys;
    }

    public void write(NullWritable key, VertexWritable value) throws IOException, InterruptedException {
        Object vertexID = value.get().id();
        Vertex vertex = (Vertex)this.tx.vertices(new Object[]{vertexID}).next();
        Iterator vpIter = value.get().properties(new String[0]);
        while (vpIter.hasNext()) {
            VertexProperty vp = (VertexProperty)vpIter.next();
            if (!this.persistableKeys.isEmpty() && !this.persistableKeys.contains(vp.key())) {
                log.debug("[vid {}] skipping key {}", vertexID, (Object)vp.key());
                continue;
            }
            vertex.property(vp.key(), vp.value());
            log.debug("[vid {}] set {}={}", new Object[]{vertexID, vp.key(), vp.value()});
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
    }
}

