/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.HBaseStorageSetup;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.hadoop.AbstractInputFormatIT;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class HBaseInputFormatIT
extends AbstractInputFormatIT {
    @BeforeClass
    public static void startHBase() throws IOException, BackendException {
        HBaseStorageSetup.startHBase();
    }

    @AfterClass
    public static void stopHBase() {
        if (VersionInfo.getVersion().startsWith("0.96")) {
            HBaseStorageSetup.killIfRunning();
        }
    }

    @Override
    protected Graph getGraph() throws IOException, ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration("target/test-classes/hbase-read.properties");
        Path baseOutDir = Paths.get((String)config.getProperty("gremlin.hadoop.outputLocation"), new String[0]);
        baseOutDir.toFile().mkdirs();
        String outDir = Files.createTempDirectory(baseOutDir, null, new FileAttribute[0]).toAbsolutePath().toString();
        config.setProperty("gremlin.hadoop.outputLocation", (Object)outDir);
        return GraphFactory.open((Configuration)config);
    }

    public WriteConfiguration getConfiguration() {
        return HBaseStorageSetup.getHBaseGraphConfiguration();
    }
}

