/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.example.GraphOfTheGodsFactory;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.spark.process.computer.SparkGraphComputer;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractInputFormatIT
extends TitanGraphBaseTest {
    @Before
    public void setup() throws IOException {
        FileUtils.deleteDirectory((File)new File("output"));
    }

    @Test
    public void testReadGraphOfTheGods() throws Exception {
        GraphOfTheGodsFactory.load((TitanGraph)this.graph, null, (boolean)true);
        Assert.assertEquals((long)12L, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        Graph g = this.getGraph();
        GraphTraversalSource t = (GraphTraversalSource)g.traversal((TraversalSource.Builder)GraphTraversalSource.computer(SparkGraphComputer.class));
        Assert.assertEquals((long)12L, (long)((Long)t.V(new Object[0]).count().next()));
    }

    @Test
    public void testReadWideVertexWithManyProperties() throws Exception {
        int numProps = 65536;
        long numV = 1L;
        this.mgmt.makePropertyKey("p").cardinality(Cardinality.LIST).dataType(Integer.class).make();
        this.mgmt.commit();
        this.finishSchema();
        int j = 0;
        while ((long)j < numV) {
            TitanVertex v = this.graph.addVertex(new Object[0]);
            for (int i = 0; i < numProps; ++i) {
                v.property("p", (Object)i);
            }
            ++j;
        }
        this.graph.tx().commit();
        Assert.assertEquals((long)numV, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        Map propertiesOnVertex = (Map)this.graph.traversal().V(new Object[0]).valueMap(new String[0]).next();
        List valuesOnP = (List)propertiesOnVertex.values().iterator().next();
        Assert.assertEquals((long)numProps, (long)valuesOnP.size());
        Graph g = this.getGraph();
        GraphTraversalSource t = (GraphTraversalSource)g.traversal((TraversalSource.Builder)GraphTraversalSource.computer(SparkGraphComputer.class));
        Assert.assertEquals((long)numV, (long)((Long)t.V(new Object[0]).count().next()));
        propertiesOnVertex = (Map)t.V(new Object[0]).valueMap(new String[0]).next();
        valuesOnP = (List)propertiesOnVertex.values().iterator().next();
        Assert.assertEquals((long)numProps, (long)valuesOnP.size());
    }

    @Test
    public void testReadSelfEdge() throws Exception {
        GraphOfTheGodsFactory.load((TitanGraph)this.graph, null, (boolean)true);
        Assert.assertEquals((long)12L, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        TitanVertex sky = (TitanVertex)this.graph.query().has("name", (Object)"sky").vertices().iterator().next();
        Assert.assertNotNull((Object)sky);
        Assert.assertEquals((Object)"sky", (Object)sky.value("name"));
        Assert.assertEquals((long)1L, (long)sky.query().direction(Direction.IN).edgeCount());
        Assert.assertEquals((long)0L, (long)sky.query().direction(Direction.OUT).edgeCount());
        Assert.assertEquals((long)1L, (long)sky.query().direction(Direction.BOTH).edgeCount());
        sky.addEdge("lives", (Vertex)sky, new Object[]{"reason", "testReadSelfEdge"});
        Assert.assertEquals((long)2L, (long)sky.query().direction(Direction.IN).edgeCount());
        Assert.assertEquals((long)1L, (long)sky.query().direction(Direction.OUT).edgeCount());
        Assert.assertEquals((long)3L, (long)sky.query().direction(Direction.BOTH).edgeCount());
        this.graph.tx().commit();
        Graph g = this.getGraph();
        GraphTraversalSource t = (GraphTraversalSource)g.traversal((TraversalSource.Builder)GraphTraversalSource.computer(SparkGraphComputer.class));
        GraphTraversal edgeIdIter = t.V(new Object[0]).has("name", (Object)"sky").bothE(new String[0]).id();
        Assert.assertNotNull((Object)edgeIdIter);
        Assert.assertTrue((boolean)edgeIdIter.hasNext());
        HashSet edges = Sets.newHashSet((Iterator)edgeIdIter);
        Assert.assertEquals((long)2L, (long)edges.size());
    }

    protected abstract Graph getGraph() throws IOException, ConfigurationException;
}

