/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.example.GraphOfTheGodsFactory;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.database.management.GraphIndexStatusWatcher;
import com.thinkaurelius.titan.graphdb.database.management.ManagementSystem;
import com.thinkaurelius.titan.graphdb.database.management.RelationIndexStatusWatcher;
import com.thinkaurelius.titan.hadoop.MapReduceIndexManagement;
import java.util.concurrent.ExecutionException;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractIndexManagementIT
extends TitanGraphBaseTest {
    @Test
    public void testRemoveGraphIndex() throws InterruptedException, BackendException, ExecutionException {
        this.tx.commit();
        this.mgmt.commit();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((TitanGraph)this.graph, (boolean)true);
        TitanManagement m = this.graph.openManagement();
        TitanGraphIndex nameIndex = m.getGraphIndex("name");
        m.updateIndex((TitanIndex)nameIndex, SchemaAction.DISABLE_INDEX);
        m.commit();
        this.graph.tx().commit();
        Assert.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((TitanGraph)this.graph, (String)"name").status(SchemaStatus.DISABLED)).call().getSucceeded());
        MapReduceIndexManagement mri = new MapReduceIndexManagement((TitanGraph)this.graph);
        m = this.graph.openManagement();
        TitanGraphIndex index = m.getGraphIndex("name");
        ScanMetrics metrics = (ScanMetrics)mri.updateIndex((TitanIndex)index, SchemaAction.REMOVE_INDEX).get();
        Assert.assertEquals((long)12L, (long)metrics.getCustom("deletes"));
    }

    @Test
    public void testRemoveRelationIndex() throws InterruptedException, BackendException, ExecutionException {
        this.tx.commit();
        this.mgmt.commit();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((TitanGraph)this.graph, (boolean)true);
        TitanManagement m = this.graph.openManagement();
        RelationType battled = m.getRelationType("battled");
        RelationTypeIndex battlesByTime = m.getRelationIndex(battled, "battlesByTime");
        m.updateIndex((TitanIndex)battlesByTime, SchemaAction.DISABLE_INDEX);
        m.commit();
        this.graph.tx().commit();
        Assert.assertTrue((boolean)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((TitanGraph)this.graph, (String)"battlesByTime", (String)"battled").status(SchemaStatus.DISABLED)).call().getSucceeded());
        MapReduceIndexManagement mri = new MapReduceIndexManagement((TitanGraph)this.graph);
        m = this.graph.openManagement();
        battled = m.getRelationType("battled");
        battlesByTime = m.getRelationIndex(battled, "battlesByTime");
        ScanMetrics metrics = (ScanMetrics)mri.updateIndex((TitanIndex)battlesByTime, SchemaAction.REMOVE_INDEX).get();
        Assert.assertEquals((long)6L, (long)metrics.getCustom("deletes"));
    }

    @Test
    public void testRepairGraphIndex() throws InterruptedException, BackendException, ExecutionException {
        this.tx.commit();
        this.mgmt.commit();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((TitanGraph)this.graph, (boolean)true);
        TitanManagement m = this.graph.openManagement();
        PropertyKey age = m.getPropertyKey("age");
        m.buildIndex("verticesByAge", Vertex.class).addKey(age).buildCompositeIndex();
        m.commit();
        this.graph.tx().commit();
        Assert.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((TitanGraph)this.graph, (String)"verticesByAge").status(SchemaStatus.REGISTERED)).call().getSucceeded());
        m = this.graph.openManagement();
        TitanGraphIndex index = m.getGraphIndex("verticesByAge");
        m.updateIndex((TitanIndex)index, SchemaAction.ENABLE_INDEX);
        m.commit();
        this.graph.tx().commit();
        Assert.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((TitanGraph)this.graph, (String)"verticesByAge").status(SchemaStatus.ENABLED)).call().getSucceeded());
        Assert.assertFalse((boolean)this.graph.query().has("age", (Object)10000).vertices().iterator().hasNext());
        MapReduceIndexManagement mri = new MapReduceIndexManagement((TitanGraph)this.graph);
        m = this.graph.openManagement();
        index = m.getGraphIndex("verticesByAge");
        ScanMetrics metrics = (ScanMetrics)mri.updateIndex((TitanIndex)index, SchemaAction.REINDEX).get();
        Assert.assertEquals((long)6L, (long)metrics.getCustom("adds"));
        Iterable hits = this.graph.query().has("age", (Object)4500).vertices();
        Assert.assertNotNull((Object)hits);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)hits));
        TitanVertex v = (TitanVertex)Iterables.getOnlyElement((Iterable)hits);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"neptune", (Object)v.value("name"));
    }

    @Test
    public void testRepairRelationIndex() throws InterruptedException, BackendException, ExecutionException {
        this.tx.commit();
        this.mgmt.commit();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((TitanGraph)this.graph, (boolean)true);
        TitanManagement m = this.graph.openManagement();
        PropertyKey reason = m.getPropertyKey("reason");
        EdgeLabel lives = m.getEdgeLabel("lives");
        m.buildEdgeIndex(lives, "livesByReason", Direction.BOTH, Order.decr, new PropertyKey[]{reason});
        m.commit();
        this.graph.tx().commit();
        Assert.assertTrue((boolean)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((TitanGraph)this.graph, (String)"livesByReason", (String)"lives").status(SchemaStatus.REGISTERED)).call().getSucceeded());
        m = this.graph.openManagement();
        RelationTypeIndex index = m.getRelationIndex(m.getRelationType("lives"), "livesByReason");
        m.updateIndex((TitanIndex)index, SchemaAction.ENABLE_INDEX);
        m.commit();
        this.graph.tx().commit();
        Assert.assertTrue((boolean)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((TitanGraph)this.graph, (String)"livesByReason", (String)"lives").status(SchemaStatus.ENABLED)).call().getSucceeded());
        MapReduceIndexManagement mri = new MapReduceIndexManagement((TitanGraph)this.graph);
        m = this.graph.openManagement();
        index = m.getRelationIndex(m.getRelationType("lives"), "livesByReason");
        ScanMetrics metrics = (ScanMetrics)mri.updateIndex((TitanIndex)index, SchemaAction.REINDEX).get();
        Assert.assertEquals((long)8L, (long)metrics.getCustom("adds"));
    }
}

