/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.thinkaurelius.titan.BerkeleyStorageSetup;
import com.thinkaurelius.titan.StorageSetup;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex;
import com.thinkaurelius.titan.example.GraphOfTheGodsFactory;
import com.thinkaurelius.titan.graphdb.TitanIndexTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.File;
import org.junit.Test;

public class BerkeleyElasticsearchTest
extends TitanIndexTest {
    public BerkeleyElasticsearchTest() {
        super(true, true, true);
    }

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = BerkeleyStorageSetup.getBerkeleyJEConfiguration();
        config.set(GraphDatabaseConfiguration.INDEX_BACKEND, (Object)"elasticsearch", new String[]{"search"});
        config.set(ElasticSearchIndex.LOCAL_MODE, (Object)true, new String[]{"search"});
        config.set(ElasticSearchIndex.CLIENT_ONLY, (Object)false, new String[]{"search"});
        config.set(GraphDatabaseConfiguration.INDEX_DIRECTORY, (Object)StorageSetup.getHomeDir((String)"es"), new String[]{"search"});
        return config.getConfiguration();
    }

    public boolean supportsLuceneStyleQueries() {
        return true;
    }

    public boolean supportsWildcardQuery() {
        return true;
    }

    protected boolean supportsCollections() {
        return true;
    }

    @Test
    public void testGraphOfTheGodsFactoryCreate() {
        File bdbtmp = new File("target/gotgfactory");
        IOUtils.deleteDirectory((File)bdbtmp, (boolean)true);
        TitanGraph gotg = GraphOfTheGodsFactory.create((String)bdbtmp.getPath());
        TitanIndexTest.assertGraphOfTheGods((TitanGraph)gotg);
        gotg.close();
    }
}

