/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchStatus {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchStatus.class);
    private final File file;
    private final int pid;

    public ElasticsearchStatus(File file, int pid) {
        Preconditions.checkNotNull((Object)file);
        this.file = file;
        this.pid = pid;
    }

    public int getPid() {
        return this.pid;
    }

    public File getFile() {
        return this.file;
    }

    public static ElasticsearchStatus write(String path, int pid) {
        File f = new File(path);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(String.format("%d", pid).getBytes());
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fos);
        return new ElasticsearchStatus(f, pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ElasticsearchStatus read(String path) {
        ElasticsearchStatus elasticsearchStatus;
        File pid = new File(path);
        if (!pid.exists()) {
            log.info("ES pidfile {} does not exist", (Object)path);
            return null;
        }
        BufferedReader pidReader = null;
        try {
            pidReader = new BufferedReader(new FileReader(pid));
            ElasticsearchStatus s = ElasticsearchStatus.parsePidFile(pid, pidReader);
            log.info("Read ES pid {} from {}", (Object)pid, (Object)path);
            elasticsearchStatus = s;
        }
        catch (IOException e) {
            try {
                log.warn("Assuming ES is not running", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pidReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)pidReader);
            return null;
        }
        IOUtils.closeQuietly((Closeable)pidReader);
        return elasticsearchStatus;
    }

    private static ElasticsearchStatus parsePidFile(File f, BufferedReader br) throws IOException {
        int pid;
        String l = br.readLine();
        if (null == l || "".equals(l.trim())) {
            throw new IOException("Empty HBase statusfile " + f);
        }
        try {
            pid = Integer.valueOf(l.trim());
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return new ElasticsearchStatus(f, pid);
    }
}

