/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;

public class ElementHelper {
    public static Iterable<Object> getValues(TitanElement element, PropertyKey key) {
        if (element instanceof TitanRelation) {
            Object value = element.valueOrNull(key);
            if (value == null) {
                return Collections.EMPTY_LIST;
            }
            return ImmutableList.of(value);
        }
        assert (element instanceof TitanVertex);
        return Iterables.transform(((TitanVertex)element).query().keys(new String[]{key.name()}).properties(), (Function)new Function<TitanVertexProperty, Object>(){

            @Nullable
            public Object apply(@Nullable TitanVertexProperty titanProperty) {
                return titanProperty.value();
            }
        });
    }

    public static long getCompareId(Element element) {
        Object id = element.id();
        if (id instanceof Long) {
            return (Long)id;
        }
        if (id instanceof RelationIdentifier) {
            return ((RelationIdentifier)id).getRelationId();
        }
        throw new IllegalArgumentException("Element identifier has unrecognized type: " + id);
    }

    public static void attachProperties(TitanRelation element, Object ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            return;
        }
        org.apache.tinkerpop.gremlin.structure.util.ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (org.apache.tinkerpop.gremlin.structure.util.ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Edge.Exceptions.userSuppliedIdsNotSupported();
        }
        if (org.apache.tinkerpop.gremlin.structure.util.ElementHelper.getLabelValue((Object[])keyValues).isPresent()) {
            throw new IllegalArgumentException("Cannot provide label as argument");
        }
        org.apache.tinkerpop.gremlin.structure.util.ElementHelper.attachProperties((Element)element, (Object[])keyValues);
    }

    public static void attachProperties(TitanVertex vertex, Object ... propertyKeyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"vertex");
        }
        for (int i = 0; i < propertyKeyValues.length; i += 2) {
            if (propertyKeyValues[i].equals(T.id) || propertyKeyValues[i].equals(T.label)) continue;
            vertex.property((String)propertyKeyValues[i], propertyKeyValues[i + 1]);
        }
    }

    public static Set<String> getPropertyKeys(TitanVertex v) {
        HashSet<String> s = new HashSet<String>();
        v.query().properties().forEach(p -> s.add(p.propertyKey().name()));
        return s;
    }
}

