/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalVertexLabel;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.internal.Token;
import com.thinkaurelius.titan.graphdb.types.system.BaseRelationType;
import com.thinkaurelius.titan.graphdb.types.system.EmptyRelationType;
import com.thinkaurelius.titan.graphdb.types.system.SystemRelationType;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;

public class ImplicitKey
extends EmptyRelationType
implements SystemRelationType,
PropertyKey {
    public static final ImplicitKey ID = new ImplicitKey(1001L, T.id.getAccessor(), Object.class);
    public static final ImplicitKey TITANID = new ImplicitKey(1002L, Token.makeSystemName("nid"), Long.class);
    public static final ImplicitKey LABEL = new ImplicitKey(11L, T.label.getAccessor(), String.class);
    public static final ImplicitKey KEY = new ImplicitKey(12L, T.key.getAccessor(), String.class);
    public static final ImplicitKey VALUE = new ImplicitKey(13L, T.value.getAccessor(), Object.class);
    public static final ImplicitKey ADJACENT_ID = new ImplicitKey(1003L, Token.makeSystemName("adjacent"), Long.class);
    public static final ImplicitKey TIMESTAMP = new ImplicitKey(5L, Token.makeSystemName("timestamp"), Instant.class);
    public static final ImplicitKey VISIBILITY = new ImplicitKey(6L, Token.makeSystemName("visibility"), String.class);
    public static final ImplicitKey TTL = new ImplicitKey(7L, Token.makeSystemName("ttl"), Duration.class);
    public static final Map<EntryMetaData, ImplicitKey> MetaData2ImplicitKey = ImmutableMap.of((Object)((Object)EntryMetaData.TIMESTAMP), (Object)TIMESTAMP, (Object)((Object)EntryMetaData.TTL), (Object)TTL, (Object)((Object)EntryMetaData.VISIBILITY), (Object)VISIBILITY);
    private final Class<?> datatype;
    private final String name;
    private final long id;

    private ImplicitKey(long id, String name, Class<?> datatype) {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)name) && datatype != null && id > 0L ? 1 : 0) != 0);
        assert (Token.isSystemName(name));
        this.datatype = datatype;
        this.name = name;
        this.id = BaseRelationType.getSystemTypeId(id, TitanSchemaCategory.PROPERTYKEY);
    }

    public <O> O computeProperty(InternalElement e) {
        if (this == ID) {
            return (O)e.id();
        }
        if (this == TITANID) {
            return (O)Long.valueOf(e.longId());
        }
        if (this == LABEL) {
            return (O)e.label();
        }
        if (this == KEY) {
            if (e instanceof TitanProperty) {
                return (O)((TitanProperty)((Object)e)).key();
            }
            return null;
        }
        if (this == VALUE) {
            if (e instanceof TitanProperty) {
                return (O)((TitanProperty)((Object)e)).value();
            }
            return null;
        }
        if (this == TIMESTAMP || this == VISIBILITY) {
            if (e instanceof InternalRelation) {
                InternalRelation r = (InternalRelation)e;
                if (this == VISIBILITY) {
                    return r.getValueDirect(this);
                }
                assert (this == TIMESTAMP);
                Long time = (Long)r.getValueDirect(this);
                if (time == null) {
                    return null;
                }
                return (O)r.tx().getConfiguration().getTimestampProvider().getTime(time);
            }
            return null;
        }
        if (this == TTL) {
            int ttl = e instanceof InternalRelation ? ((InternalRelationType)((InternalRelation)e).getType()).getTTL() : (e instanceof InternalVertex ? ((InternalVertexLabel)((InternalVertex)e).vertexLabel()).getTTL() : 0);
            return (O)Duration.ofSeconds(ttl);
        }
        throw new AssertionError((Object)("Implicit key property is undefined: " + this.name()));
    }

    @Override
    public Class<?> dataType() {
        return this.datatype;
    }

    @Override
    public Cardinality cardinality() {
        return Cardinality.SINGLE;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isPropertyKey() {
        return true;
    }

    @Override
    public boolean isEdgeLabel() {
        return false;
    }

    @Override
    public boolean isInvisibleType() {
        return false;
    }

    @Override
    public Multiplicity multiplicity() {
        return Multiplicity.convert(this.cardinality());
    }

    @Override
    public ConsistencyModifier getConsistencyModifier() {
        return ConsistencyModifier.DEFAULT;
    }

    @Override
    public boolean isUnidirected(Direction dir) {
        return dir == Direction.OUT;
    }

    @Override
    public long longId() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return this.id > 0L;
    }

    @Override
    public void setId(long id) {
        throw new IllegalStateException("SystemType has already been assigned an id");
    }

    @Override
    public String toString() {
        return this.name;
    }
}

