/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionDescription;
import com.thinkaurelius.titan.graphdb.types.system.BaseRelationType;
import java.util.Collections;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class BaseKey
extends BaseRelationType
implements PropertyKey {
    public static final BaseKey VertexExists = new BaseKey("VertexExists", Boolean.class, 1, Index.NONE, Cardinality.SINGLE);
    public static final BaseKey SchemaName = new BaseKey("SchemaName", String.class, 32, Index.UNIQUE, Cardinality.SINGLE);
    public static final BaseKey SchemaDefinitionProperty = new BaseKey("SchemaDefinitionProperty", Object.class, 33, Index.NONE, Cardinality.LIST);
    public static final BaseKey SchemaCategory = new BaseKey("SchemaCategory", TitanSchemaCategory.class, 34, Index.STANDARD, Cardinality.SINGLE);
    public static final BaseKey SchemaDefinitionDesc = new BaseKey("SchemaDefinitionDescription", TypeDefinitionDescription.class, 35, Index.NONE, Cardinality.SINGLE);
    public static final BaseKey SchemaUpdateTime = new BaseKey("SchemaUpdateTimestamp", Long.class, 36, Index.NONE, Cardinality.SINGLE);
    private final Class<?> dataType;
    private final Index index;
    private final Cardinality cardinality;
    private final CompositeIndexType indexDef = new CompositeIndexType(){
        private final IndexField[] fields;
        {
            this.fields = new IndexField[]{IndexField.of(BaseKey.this)};
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public long getID() {
            return BaseKey.this.longId();
        }

        @Override
        public IndexField[] getFieldKeys() {
            return this.fields;
        }

        @Override
        public IndexField getField(PropertyKey key) {
            if (key.equals(BaseKey.this)) {
                return this.fields[0];
            }
            return null;
        }

        @Override
        public boolean indexesKey(PropertyKey key) {
            return this.getField(key) != null;
        }

        @Override
        public Cardinality getCardinality() {
            switch (BaseKey.this.index) {
                case UNIQUE: {
                    return Cardinality.SINGLE;
                }
                case STANDARD: {
                    return Cardinality.LIST;
                }
            }
            throw new AssertionError();
        }

        @Override
        public ConsistencyModifier getConsistencyModifier() {
            return ConsistencyModifier.LOCK;
        }

        @Override
        public ElementCategory getElement() {
            return ElementCategory.VERTEX;
        }

        @Override
        public boolean hasSchemaTypeConstraint() {
            return false;
        }

        @Override
        public TitanSchemaType getSchemaTypeConstraint() {
            return null;
        }

        @Override
        public boolean isCompositeIndex() {
            return true;
        }

        @Override
        public boolean isMixedIndex() {
            return false;
        }

        @Override
        public String getBackingIndexName() {
            return "internalindex";
        }

        @Override
        public String getName() {
            return "SystemIndex#" + BaseKey.this.name();
        }

        @Override
        public SchemaStatus getStatus() {
            return SchemaStatus.ENABLED;
        }

        @Override
        public void resetCache() {
        }
    };

    private BaseKey(String name, Class<?> dataType, int id, Index index, Cardinality cardinality) {
        super(name, id, TitanSchemaCategory.PROPERTYKEY);
        Preconditions.checkArgument((index != null && cardinality != null ? 1 : 0) != 0);
        this.dataType = dataType;
        this.index = index;
        this.cardinality = cardinality;
    }

    @Override
    public Class<?> dataType() {
        return this.dataType;
    }

    @Override
    public final boolean isPropertyKey() {
        return true;
    }

    @Override
    public final boolean isEdgeLabel() {
        return false;
    }

    @Override
    public Multiplicity multiplicity() {
        return Multiplicity.convert(this.cardinality());
    }

    @Override
    public boolean isUnidirected(Direction dir) {
        return dir == Direction.OUT;
    }

    @Override
    public Cardinality cardinality() {
        return this.cardinality;
    }

    @Override
    public Iterable<IndexType> getKeyIndexes() {
        if (this.index == Index.NONE) {
            return Collections.EMPTY_LIST;
        }
        return ImmutableList.of((Object)this.indexDef);
    }

    private static enum Index {
        NONE,
        STANDARD,
        UNIQUE;

    }
}

