/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.CacheEdge;
import com.thinkaurelius.titan.graphdb.relations.CacheVertexProperty;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.transaction.VertexFactory;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.graphdb.types.TypeUtil;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class RelationConstructor {
    public static RelationCache readRelationCache(Entry data, StandardTitanTx tx) {
        return tx.getEdgeSerializer().readRelation(data, false, tx);
    }

    public static Iterable<TitanRelation> readRelation(final InternalVertex vertex, final Iterable<Entry> data, final StandardTitanTx tx) {
        return new Iterable<TitanRelation>(){

            @Override
            public Iterator<TitanRelation> iterator() {
                return new Iterator<TitanRelation>(){
                    Iterator<Entry> iter;
                    TitanRelation current;
                    {
                        this.iter = data.iterator();
                        this.current = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public TitanRelation next() {
                        this.current = RelationConstructor.readRelation(vertex, this.iter.next(), tx);
                        return this.current;
                    }

                    @Override
                    public void remove() {
                        Preconditions.checkState((this.current != null ? 1 : 0) != 0);
                        this.current.remove();
                    }
                };
            }
        };
    }

    public static InternalRelation readRelation(InternalVertex vertex, Entry data, StandardTitanTx tx) {
        RelationCache relation = tx.getEdgeSerializer().readRelation(data, true, tx);
        return RelationConstructor.readRelation(vertex, relation, data, (TypeInspector)tx, (VertexFactory)tx);
    }

    public static InternalRelation readRelation(InternalVertex vertex, Entry data, EdgeSerializer serializer, TypeInspector types, VertexFactory vertexFac) {
        RelationCache relation = serializer.readRelation(data, true, types);
        return RelationConstructor.readRelation(vertex, relation, data, types, vertexFac);
    }

    private static InternalRelation readRelation(InternalVertex vertex, RelationCache relation, Entry data, TypeInspector types, VertexFactory vertexFac) {
        InternalRelationType type = TypeUtil.getBaseType((InternalRelationType)types.getExistingRelationType(relation.typeId));
        if (type.isPropertyKey()) {
            assert (relation.direction == Direction.OUT);
            return new CacheVertexProperty(relation.relationId, (PropertyKey)((Object)type), vertex, relation.getValue(), data);
        }
        if (type.isEdgeLabel()) {
            InternalVertex otherVertex = vertexFac.getInternalVertex(relation.getOtherVertexId());
            switch (relation.direction) {
                case IN: {
                    return new CacheEdge(relation.relationId, (EdgeLabel)((Object)type), otherVertex, vertex, data);
                }
                case OUT: {
                    return new CacheEdge(relation.relationId, (EdgeLabel)((Object)type), vertex, otherVertex, data);
                }
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }
}

