/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop.optimize;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.BaseVertexQuery;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanMultiVertexQuery;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.profile.QueryProfiler;
import com.thinkaurelius.titan.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.HasStepFolder;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.MultiQueriable;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanTraversalUtil;
import com.thinkaurelius.titan.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class TitanVertexStep<E extends Element>
extends VertexStep<E>
implements HasStepFolder<Vertex, E>,
Profiling,
MultiQueriable<Vertex, E> {
    private boolean initialized = false;
    private boolean useMultiQuery = false;
    private Map<TitanVertex, Iterable<? extends TitanElement>> multiQueryResults = null;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private final List<HasContainer> hasContainers;
    private int limit = Integer.MAX_VALUE;
    private List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();

    public TitanVertexStep(VertexStep<E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnClass(), originalStep.getDirection(), originalStep.getEdgeLabels());
        originalStep.getLabels().forEach(arg_0 -> ((TitanVertexStep)this).addLabel(arg_0));
        this.hasContainers = new ArrayList<HasContainer>();
        this.limit = Integer.MAX_VALUE;
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
    }

    public <Q extends BaseVertexQuery> Q makeQuery(Q query) {
        query.labels(this.getEdgeLabels());
        query.direction(this.getDirection());
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), TitanPredicate.Converter.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.limit != Integer.MAX_VALUE) {
            query.limit(this.limit);
        }
        ((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
        return query;
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        if (this.useMultiQuery) {
            if (!this.starts.hasNext()) {
                throw FastNoSuchElementException.instance();
            }
            TitanMultiVertexQuery<? extends TitanMultiVertexQuery> mquery = TitanTraversalUtil.getTx(this.traversal).multiQuery(new TitanVertex[0]);
            ArrayList vertices = new ArrayList();
            this.starts.forEachRemaining(v -> {
                vertices.add(v);
                mquery.addVertex((Vertex)v.get());
            });
            this.starts.add(vertices.iterator());
            assert (vertices.size() > 0);
            this.makeQuery(mquery);
            this.multiQueryResults = Vertex.class.isAssignableFrom(this.getReturnClass()) ? mquery.vertices() : mquery.edges();
        }
    }

    protected Traverser.Admin<E> processNextStart() {
        if (!this.initialized) {
            this.initialize();
        }
        return super.processNextStart();
    }

    protected Iterator<E> flatMap(Traverser.Admin<Vertex> traverser) {
        if (this.useMultiQuery) {
            assert (this.multiQueryResults != null);
            return this.multiQueryResults.get(traverser.get()).iterator();
        }
        TitanVertexQuery<? extends TitanVertexQuery> query = this.makeQuery(TitanTraversalUtil.getTitanVertex(traverser).query());
        return Vertex.class.isAssignableFrom(this.getReturnClass()) ? query.vertices().iterator() : query.edges().iterator();
    }

    public void reset() {
        super.reset();
        this.initialized = false;
    }

    public TitanVertexStep<E> clone() {
        TitanVertexStep clone = (TitanVertexStep)super.clone();
        clone.initialized = false;
        return clone;
    }

    @Override
    public void addAll(Iterable<HasContainer> has) {
        Iterables.addAll(this.hasContainers, has);
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

