/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop.optimize;

import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.AdjacentVertexFilterOptimizerStrategy;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.HasStepFolder;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.MultiQueriable;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanPropertiesStep;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanTraversalUtil;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanVertexStep;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class TitanLocalQueryOptimizerStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final TitanLocalQueryOptimizerStrategy INSTANCE = new TitanLocalQueryOptimizerStrategy();
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = Collections.singleton(AdjacentVertexFilterOptimizerStrategy.class);

    private TitanLocalQueryOptimizerStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!traversal.getGraph().isPresent()) {
            return;
        }
        Graph graph = (Graph)traversal.getGraph().get();
        StandardTitanGraph titanGraph = graph instanceof StandardTitanTx ? ((StandardTitanTx)graph).getGraph() : (StandardTitanGraph)graph;
        boolean useMultiQuery = !TraversalHelper.onGraphComputer(traversal) && titanGraph.getConfiguration().useMultiQuery();
        TraversalHelper.getStepsOfClass(VertexStep.class, traversal).forEach(originalStep -> {
            TitanVertexStep vstep = new TitanVertexStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, vstep, (Traversal.Admin)traversal);
            if (TitanTraversalUtil.isEdgeReturnStep(vstep)) {
                HasStepFolder.foldInHasContainer(vstep, traversal);
            }
            assert (TitanTraversalUtil.isEdgeReturnStep(vstep) || TitanTraversalUtil.isVertexReturnStep(vstep));
            Step nextStep = TitanTraversalUtil.getNextNonIdentityStep(vstep);
            if (nextStep instanceof RangeGlobalStep) {
                int limit = QueryUtil.convertLimit(((RangeGlobalStep)nextStep).getHighRange());
                vstep.setLimit(QueryUtil.mergeLimits(limit, vstep.getLimit()));
            }
            if (useMultiQuery) {
                vstep.setUseMultiQuery(true);
            }
        });
        TraversalHelper.getStepsOfClass(PropertiesStep.class, traversal).forEach(originalStep -> {
            TitanPropertiesStep vstep = new TitanPropertiesStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, vstep, (Traversal.Admin)traversal);
            if (vstep.getReturnType().forProperties()) {
                HasStepFolder.foldInHasContainer(vstep, traversal);
            }
            if (useMultiQuery) {
                vstep.setUseMultiQuery(true);
            }
        });
        TraversalHelper.getStepsOfClass(LocalStep.class, traversal).forEach(localStep -> {
            MultiQueriable vstep;
            Traversal.Admin localTraversal = (Traversal.Admin)localStep.getLocalChildren().get(0);
            Step localStart = localTraversal.getStartStep();
            if (localStart instanceof VertexStep) {
                vstep = new TitanVertexStep((VertexStep)localStart);
                TraversalHelper.replaceStep((Step)localStart, vstep, (Traversal.Admin)localTraversal);
                if (TitanTraversalUtil.isEdgeReturnStep(vstep)) {
                    HasStepFolder.foldInHasContainer(vstep, localTraversal);
                    HasStepFolder.foldInOrder(vstep, localTraversal, traversal, false);
                }
                HasStepFolder.foldInRange(vstep, localTraversal);
                TitanLocalQueryOptimizerStrategy.unfoldLocalTraversal(traversal, localStep, localTraversal, vstep, useMultiQuery);
            }
            if (localStart instanceof PropertiesStep) {
                vstep = new TitanPropertiesStep((PropertiesStep)localStart);
                TraversalHelper.replaceStep((Step)localStart, vstep, (Traversal.Admin)localTraversal);
                if (vstep.getReturnType().forProperties()) {
                    HasStepFolder.foldInHasContainer(vstep, localTraversal);
                    HasStepFolder.foldInOrder(vstep, localTraversal, traversal, false);
                }
                HasStepFolder.foldInRange(vstep, localTraversal);
                TitanLocalQueryOptimizerStrategy.unfoldLocalTraversal(traversal, localStep, localTraversal, vstep, useMultiQuery);
            }
        });
    }

    private static void unfoldLocalTraversal(Traversal.Admin<?, ?> traversal, LocalStep<?, ?> localStep, Traversal.Admin localTraversal, MultiQueriable vstep, boolean useMultiQuery) {
        assert (localTraversal.asAdmin().getSteps().size() > 0);
        if (localTraversal.asAdmin().getSteps().size() == 1) {
            assert (localTraversal.getStartStep() == vstep);
            vstep.setTraversal(traversal);
            TraversalHelper.replaceStep(localStep, (Step)vstep, traversal);
            if (useMultiQuery) {
                vstep.setUseMultiQuery(true);
            }
        }
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static TitanLocalQueryOptimizerStrategy instance() {
        return INSTANCE;
    }
}

