/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop.optimize;

import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanTraversalUtil;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Ranging;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.javatuples.Pair;

public interface HasStepFolder<S, E>
extends Step<S, E> {
    public void addAll(Iterable<HasContainer> var1);

    public void orderBy(String var1, Order var2);

    public void setLimit(int var1);

    public int getLimit();

    public static boolean validTitanHas(HasContainer has) {
        return TitanPredicate.Converter.supports(has.getBiPredicate());
    }

    public static boolean validTitanHas(Iterable<HasContainer> has) {
        for (HasContainer h : has) {
            if (HasStepFolder.validTitanHas(h)) continue;
            return false;
        }
        return true;
    }

    public static boolean validTitanOrder(OrderGlobalStep ostep, Traversal rootTraversal, boolean isVertexOrder) {
        for (Pair comp : ostep.getComparators()) {
            String key;
            if (!(comp.getValue1() instanceof ElementValueComparator)) {
                return false;
            }
            ElementValueComparator evc = (ElementValueComparator)comp.getValue1();
            if (!(evc.getValueComparator() instanceof Order)) {
                return false;
            }
            TitanTransaction tx = TitanTraversalUtil.getTx(rootTraversal.asAdmin());
            PropertyKey pkey = tx.getPropertyKey(key = evc.getPropertyKey());
            if (pkey == null || !Comparable.class.isAssignableFrom(pkey.dataType())) {
                return false;
            }
            if (!isVertexOrder || pkey.cardinality() == Cardinality.SINGLE) continue;
            return false;
        }
        return true;
    }

    public static void foldInHasContainer(HasStepFolder titanStep, Traversal.Admin<?, ?> traversal) {
        Step currentStep = titanStep.getNextStep();
        while (true) {
            if (currentStep instanceof HasContainerHolder) {
                List containers = ((HasContainerHolder)currentStep).getHasContainers();
                if (HasStepFolder.validTitanHas(containers)) {
                    titanStep.addAll(containers);
                    currentStep.getLabels().forEach(arg_0 -> ((HasStepFolder)titanStep).addLabel(arg_0));
                    traversal.removeStep(currentStep);
                }
            } else if (!(currentStep instanceof IdentityStep)) break;
            currentStep = currentStep.getNextStep();
        }
    }

    public static void foldInOrder(HasStepFolder titanStep, Traversal.Admin<?, ?> traversal, Traversal<?, ?> rootTraversal, boolean isVertexOrder) {
        Step currentStep = titanStep.getNextStep();
        OrderGlobalStep lastOrder = null;
        while (true) {
            if (currentStep instanceof OrderGlobalStep) {
                if (lastOrder != null) {
                    lastOrder.getLabels().forEach(arg_0 -> ((HasStepFolder)titanStep).addLabel(arg_0));
                    traversal.removeStep((Step)lastOrder);
                }
                lastOrder = (OrderGlobalStep)currentStep;
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof HasStep)) break;
            currentStep = currentStep.getNextStep();
        }
        if (lastOrder != null && lastOrder instanceof OrderGlobalStep && HasStepFolder.validTitanOrder(lastOrder, rootTraversal, isVertexOrder)) {
            for (Pair comp : lastOrder.getComparators()) {
                ElementValueComparator evc = (ElementValueComparator)comp.getValue1();
                titanStep.orderBy(evc.getPropertyKey(), (Order)evc.getValueComparator());
            }
            lastOrder.getLabels().forEach(arg_0 -> ((HasStepFolder)titanStep).addLabel(arg_0));
            traversal.removeStep((Step)lastOrder);
        }
    }

    public static <E extends Ranging> void foldInRange(HasStepFolder titanStep, Traversal.Admin<?, ?> traversal) {
        Step nextStep = TitanTraversalUtil.getNextNonIdentityStep(titanStep);
        if (nextStep instanceof RangeGlobalStep) {
            RangeGlobalStep range = (RangeGlobalStep)nextStep;
            int limit = QueryUtil.convertLimit(range.getHighRange());
            titanStep.setLimit(QueryUtil.mergeLimits(limit, titanStep.getLimit()));
            if (range.getLowRange() == 0L) {
                nextStep.getLabels().forEach(arg_0 -> ((HasStepFolder)titanStep).addLabel(arg_0));
                traversal.removeStep(nextStep);
            }
        }
    }

    public static class OrderEntry {
        public final String key;
        public final Order order;

        public OrderEntry(String key, Order order) {
            this.key = key;
            this.order = order;
        }
    }
}

