/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanIndexQuery;
import com.thinkaurelius.titan.core.TitanMultiVertexQuery;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.schema.EdgeLabelMaker;
import com.thinkaurelius.titan.core.schema.PropertyKeyMaker;
import com.thinkaurelius.titan.core.schema.VertexLabelMaker;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraGraphComputer;
import com.thinkaurelius.titan.graphdb.tinkerpop.TitanBlueprintsTransaction;
import com.thinkaurelius.titan.graphdb.tinkerpop.TitanGraphVariables;
import com.thinkaurelius.titan.graphdb.tinkerpop.TitanIoRegistry;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadLocalTransaction;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanBlueprintsGraph
implements TitanGraph {
    private static final Logger log = LoggerFactory.getLogger(TitanBlueprintsGraph.class);
    final GraphTransaction tinkerpopTxContainer = new GraphTransaction();
    private ThreadLocal<TitanBlueprintsTransaction> txs = new ThreadLocal<TitanBlueprintsTransaction>(){

        @Override
        protected TitanBlueprintsTransaction initialValue() {
            return null;
        }
    };

    public abstract TitanTransaction newThreadBoundTransaction();

    private TitanBlueprintsTransaction getAutoStartTx() {
        if (this.txs == null) {
            throw new IllegalStateException("Graph has been closed");
        }
        this.tinkerpopTxContainer.readWrite();
        TitanBlueprintsTransaction tx = this.txs.get();
        Preconditions.checkState((tx != null ? 1 : 0) != 0, (Object)"Invalid read-write behavior configured: Should either open transaction or throw exception.");
        return tx;
    }

    private TitanBlueprintsTransaction startNewTx() {
        TitanBlueprintsTransaction tx = this.txs.get();
        if (tx != null && tx.isOpen()) {
            throw Transaction.Exceptions.transactionAlreadyOpen();
        }
        tx = (TitanBlueprintsTransaction)this.newThreadBoundTransaction();
        this.txs.set(tx);
        log.debug("Created new thread-bound transaction {}", (Object)tx);
        return tx;
    }

    public TitanTransaction getCurrentThreadTx() {
        return this.getAutoStartTx();
    }

    @Override
    public synchronized void close() {
        this.txs = null;
    }

    public Transaction tx() {
        return this.tinkerpopTxContainer;
    }

    public String toString() {
        GraphDatabaseConfiguration config = ((StandardTitanGraph)this).getConfiguration();
        return StringFactory.graphString((Graph)this, (String)config.getBackendDescription());
    }

    public Graph.Variables variables() {
        return new TitanGraphVariables(((StandardTitanGraph)this).getBackend().getUserConfiguration());
    }

    public Configuration configuration() {
        GraphDatabaseConfiguration config = ((StandardTitanGraph)this).getConfiguration();
        return config.getConfigurationAtOpen();
    }

    public <I extends Io> I io(Io.Builder<I> builder) {
        return (I)builder.graph((Graph)this).registry((IoRegistry)TitanIoRegistry.getInstance()).create();
    }

    @Override
    public TitanVertex addVertex(Object ... keyValues) {
        return this.getAutoStartTx().addVertex(keyValues);
    }

    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return this.getAutoStartTx().vertices(vertexIds);
    }

    public Iterator<Edge> edges(Object ... edgeIds) {
        return this.getAutoStartTx().edges(edgeIds);
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        if (!graphComputerClass.equals(FulgoraGraphComputer.class)) {
            throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(graphComputerClass);
        }
        return (C)this.compute();
    }

    public FulgoraGraphComputer compute() throws IllegalArgumentException {
        StandardTitanGraph graph = (StandardTitanGraph)this;
        return new FulgoraGraphComputer(graph, graph.getConfiguration().getConfiguration());
    }

    @Override
    public TitanVertex addVertex(String vertexLabel) {
        return this.getAutoStartTx().addVertex(vertexLabel);
    }

    @Override
    public TitanGraphQuery<? extends TitanGraphQuery> query() {
        return this.getAutoStartTx().query();
    }

    @Override
    public TitanIndexQuery indexQuery(String indexName, String query) {
        return this.getAutoStartTx().indexQuery(indexName, query);
    }

    @Deprecated
    public TitanMultiVertexQuery multiQuery(TitanVertex ... vertices) {
        return this.getAutoStartTx().multiQuery(vertices);
    }

    @Deprecated
    public TitanMultiVertexQuery multiQuery(Collection<TitanVertex> vertices) {
        return this.getAutoStartTx().multiQuery(vertices);
    }

    @Override
    public PropertyKeyMaker makePropertyKey(String name) {
        return this.getAutoStartTx().makePropertyKey(name);
    }

    @Override
    public EdgeLabelMaker makeEdgeLabel(String name) {
        return this.getAutoStartTx().makeEdgeLabel(name);
    }

    @Override
    public VertexLabelMaker makeVertexLabel(String name) {
        return this.getAutoStartTx().makeVertexLabel(name);
    }

    @Override
    public boolean containsPropertyKey(String name) {
        return this.getAutoStartTx().containsPropertyKey(name);
    }

    @Override
    public PropertyKey getOrCreatePropertyKey(String name) {
        return this.getAutoStartTx().getOrCreatePropertyKey(name);
    }

    @Override
    public PropertyKey getPropertyKey(String name) {
        return this.getAutoStartTx().getPropertyKey(name);
    }

    @Override
    public boolean containsEdgeLabel(String name) {
        return this.getAutoStartTx().containsEdgeLabel(name);
    }

    @Override
    public EdgeLabel getOrCreateEdgeLabel(String name) {
        return this.getAutoStartTx().getOrCreateEdgeLabel(name);
    }

    @Override
    public EdgeLabel getEdgeLabel(String name) {
        return this.getAutoStartTx().getEdgeLabel(name);
    }

    @Override
    public boolean containsRelationType(String name) {
        return this.getAutoStartTx().containsRelationType(name);
    }

    @Override
    public RelationType getRelationType(String name) {
        return this.getAutoStartTx().getRelationType(name);
    }

    @Override
    public boolean containsVertexLabel(String name) {
        return this.getAutoStartTx().containsVertexLabel(name);
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        return this.getAutoStartTx().getVertexLabel(name);
    }

    @Override
    public VertexLabel getOrCreateVertexLabel(String name) {
        return this.getAutoStartTx().getOrCreateVertexLabel(name);
    }

    class GraphTransaction
    extends AbstractThreadLocalTransaction {
        public GraphTransaction() {
            super((Graph)TitanBlueprintsGraph.this);
        }

        public void doOpen() {
            TitanBlueprintsGraph.this.startNewTx();
        }

        public void doCommit() {
            TitanBlueprintsGraph.this.getAutoStartTx().commit();
        }

        public void doRollback() {
            TitanBlueprintsGraph.this.getAutoStartTx().rollback();
        }

        public TitanTransaction createThreadedTx() {
            return TitanBlueprintsGraph.this.newTransaction();
        }

        public boolean isOpen() {
            if (null == TitanBlueprintsGraph.this.txs) {
                return false;
            }
            TitanBlueprintsTransaction tx = (TitanBlueprintsTransaction)TitanBlueprintsGraph.this.txs.get();
            return tx != null && tx.isOpen();
        }

        public void close() {
            this.close((Transaction)this);
        }

        void close(Transaction tx) {
            ((Consumer)this.closeConsumerInternal.get()).accept(tx);
            Preconditions.checkState((!tx.isOpen() ? 1 : 0) != 0, (String)"Invalid close behavior configured: Should close transaction. [%s]", (Object[])new Object[]{this.closeConsumerInternal});
        }

        public Transaction onReadWrite(Consumer<Transaction> transactionConsumer) {
            Preconditions.checkArgument((boolean)(transactionConsumer instanceof Transaction.READ_WRITE_BEHAVIOR), (String)"Only READ_WRITE_BEHAVIOR instances are accepted argument, got: %s", (Object[])new Object[]{transactionConsumer});
            return super.onReadWrite(transactionConsumer);
        }

        public Transaction onClose(Consumer<Transaction> transactionConsumer) {
            Preconditions.checkArgument((boolean)(transactionConsumer instanceof Transaction.CLOSE_BEHAVIOR), (String)"Only CLOSE_BEHAVIOR instances are accepted argument, got: %s", (Object[])new Object[]{transactionConsumer});
            return super.onClose(transactionConsumer);
        }
    }
}

