/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop;

import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ElementUtils {
    public static long getVertexId(Object id) {
        if (null == id) {
            return 0L;
        }
        if (id instanceof TitanVertex) {
            return ((TitanVertex)id).longId();
        }
        if (id instanceof Long) {
            return (Long)id;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue();
        }
        try {
            if (id instanceof Vertex) {
                return Long.parseLong(((Vertex)id).id().toString());
            }
            return Long.valueOf(id.toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static RelationIdentifier getEdgeId(Object id) {
        if (null == id) {
            return null;
        }
        try {
            if (id instanceof TitanEdge) {
                return (RelationIdentifier)((TitanEdge)id).id();
            }
            if (id instanceof RelationIdentifier) {
                return (RelationIdentifier)id;
            }
            if (id instanceof String) {
                return RelationIdentifier.parse((String)id);
            }
            if (id instanceof long[]) {
                return RelationIdentifier.get((long[])id);
            }
            if (id instanceof int[]) {
                return RelationIdentifier.get((int[])id);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static void verifyArgsMustBeEitherIdorElement(Object ... ids) {
        assert (ids.length > 0);
        int numElements = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (!(ids[i] instanceof Element)) continue;
            ++numElements;
        }
        if (numElements > 0 && numElements < ids.length) {
            throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
        }
    }
}

