/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractTypedRelation;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public abstract class AbstractVertexProperty<V>
extends AbstractTypedRelation
implements TitanVertexProperty<V> {
    private InternalVertex vertex;
    private final Object value;

    public AbstractVertexProperty(long id, PropertyKey type, InternalVertex vertex, Object value) {
        super(id, type);
        Preconditions.checkNotNull((Object)vertex, (Object)"null vertex");
        Preconditions.checkNotNull((Object)value, (String)"null value for property key %s", (Object[])new Object[]{type});
        this.vertex = vertex;
        this.value = value;
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }

    public void setVertexAt(int pos, InternalVertex vertex) {
        Preconditions.checkArgument((pos == 0 && vertex != null && this.vertex.equals(vertex) ? 1 : 0) != 0);
        this.vertex = vertex;
    }

    @Override
    public InternalVertex getVertex(int pos) {
        if (pos == 0) {
            return this.vertex;
        }
        throw new IllegalArgumentException("Invalid position: " + pos);
    }

    @Override
    public TitanTransaction graph() {
        return this.vertex.graph();
    }

    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        return super.properties(propertyKeys);
    }

    @Override
    public final int getArity() {
        return 1;
    }

    @Override
    public final int getLen() {
        return 1;
    }

    @Override
    public TitanVertex element() {
        return this.vertex;
    }

    public V value() {
        return (V)this.value;
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public boolean isEdge() {
        return false;
    }

    public boolean isPresent() {
        return true;
    }
}

