/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.thinkaurelius.titan.core.InvalidElementException;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.graphdb.internal.AbstractElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.relations.SimpleTitanProperty;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public abstract class AbstractTypedRelation
extends AbstractElement
implements InternalRelation {
    protected final InternalRelationType type;

    public AbstractTypedRelation(long id, RelationType type) {
        super(id);
        assert (type != null && type instanceof InternalRelationType);
        this.type = (InternalRelationType)type;
    }

    @Override
    public InternalRelation it() {
        InternalVertex v = this.getVertex(0);
        if (v == v.it()) {
            return this;
        }
        InternalRelation next = (InternalRelation)RelationIdentifier.get(this).findRelation(this.tx());
        if (next == null) {
            throw InvalidElementException.removedException(this);
        }
        return next;
    }

    @Override
    public final StandardTitanTx tx() {
        return this.getVertex(0).tx();
    }

    protected final void verifyAccess() {
    }

    @Override
    public Direction direction(Vertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.it().getVertex(i).equals(vertex)) continue;
            return EdgeDirection.fromPosition(i);
        }
        throw new IllegalArgumentException("Relation is not incident on vertex");
    }

    @Override
    public boolean isIncidentOn(Vertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.it().getVertex(i).equals(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInvisible() {
        return this.type.isInvisibleType();
    }

    @Override
    public boolean isLoop() {
        return this.getArity() == 2 && this.getVertex(0).equals(this.getVertex(1));
    }

    @Override
    public RelationType getType() {
        return this.type;
    }

    @Override
    public RelationIdentifier id() {
        return RelationIdentifier.get(this);
    }

    @Override
    public <V> Property<V> property(String key, V value) {
        this.verifyAccess();
        PropertyKey pkey = this.tx().getOrCreatePropertyKey(key);
        Object normalizedValue = this.tx().verifyAttribute(pkey, value);
        this.it().setPropertyDirect(pkey, normalizedValue);
        return new SimpleTitanProperty<V>(this, pkey, value);
    }

    public <O> O valueOrNull(PropertyKey key) {
        this.verifyAccess();
        if (key instanceof ImplicitKey) {
            return ((ImplicitKey)key).computeProperty(this);
        }
        return this.it().getValueDirect(key);
    }

    public <O> O value(String key) {
        this.verifyAccess();
        O val = this.valueInternal(this.tx().getPropertyKey(key));
        if (val == null) {
            throw Property.Exceptions.propertyDoesNotExist((Element)this, (String)key);
        }
        return val;
    }

    private <O> O valueInternal(PropertyKey type) {
        if (type == null) {
            return null;
        }
        return this.valueOrNull(type);
    }

    public <V> Iterator<Property<V>> properties(String ... keyNames) {
        this.verifyAccess();
        Stream<PropertyKey> keys = keyNames == null || keyNames.length == 0 ? IteratorUtils.stream(this.it().getPropertyKeysDirect().iterator()) : Stream.of(keyNames).map(s -> this.tx().getPropertyKey((String)s)).filter(rt -> rt != null && this.getValueDirect((PropertyKey)rt) != null);
        return keys.map(rt -> new SimpleTitanProperty(this, (PropertyKey)rt, this.valueInternal((PropertyKey)rt))).iterator();
    }
}

